{==============================================================================}
{                                                                              }
{       OpenGL 2.0 - Headertranslation (includes GL 1.1 - 2.0)                 }
{       Version 2.0                                                            }
{       Date : 06.12.2005                                                      }
{                                                                              }
{       Works with :                                                           }
{        - Delphi 3 and up                                                     }
{        - FreePascal (1.9.3 and up)                                           }
{                                                                              }
{==============================================================================}
{                                                                              }
{       Containts the translations of glext.h, gl_1_1.h, glu.h and weglext.h.  }
{       It also contains some helperfunctions that were inspired by those      }
{       found in Mike Lischke's OpenGL12.pas.                                  }
{                                                                              }
{       Also contains the new OpenGL1.5-Extensions :                           }
{         - GL_ARB_occlusion_query                                             }
{         - GL_ARB_shader_objects                                              }
{         - GL_ARB_vertex_shader                                               }
{         - GL_ARB_fragment_shader                                             }
{         - GL_ARB_shading_language_100                                        }
{         - GL_ARB_texture_non_power_of_two                                    }
{         - GL_ARB_point_sprite                                                }
{         - GL_EXT_framebuffer_object                                          }
{                                                                              }
{                                                                              }
{       Copyright (C) DGL-OpenGL2-Portteam                                     }
{       All Rights Reserved                                                    }
{                                                                              }
{       Obtained through:                                                      }
{       Delphi OpenGL Community(DGL) - www.delphigl.com                        }
{                                                                              }
{       Converted and maintained by DGL's GL2.0-Team :                         }
{         - Sascha Willems                - http://www.delphigl.de             }
{         - Steffen Xonna (LossyEx)       - http://www.dev-center.de           }
{         - Lars Middendorf               - http://www.3d-seite.de             }
{       Additional input :                                                     }
{         - Martin Waldegger (Mars)       - http://www.basegraph.com           }
{         - Benjamin Rosseaux (BeRo)      - http://www.0ok.de                  }
{       Additional thanks:                                                     }
{           sigsegv (libdl.so)                                                 }
{                                                                              }
{                                                                              }
{==============================================================================}
{      If you have problems on using our unit, then please take a look at      }
{      the "how to use.txt".                                                   }
{==============================================================================}
{ You may retrieve the latest version of this file at the Delphi OpenGL        }
{ Community home page, located at http://www.delphigl.com/                     }
{                                                                              }
{ The contents of this file are used with permission, subject to               }
{ the Mozilla Public License Version 1.1 (the "License"); you may              }
{ not use this file except in compliance with the License. You may             }
{ obtain a copy of the License at                                              }
{ http://www.mozilla.org/MPL/MPL-1.1.html                                      }
{                                                                              }
{ Software distributed under the License is distributed on an                  }
{ "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or               }
{ implied. See the License for the specific language governing                 }
{ rights and limitations under the License.                                    }
{                                                                              }
{==============================================================================}
{ History :                                                                    }
{ Version 1.0  - Initial Release                                               }
{ Version 1.1  - Added PPointer in Tpyessection for compatiblity with Delphi   }
{                versions lower than 7                                    (SW) }
{              - Added a function named RaiseLastOSError including a comment   }
{                on how to make it run under Delphi versions lower than 7 (SW) }
{              - Added some data types according to the GL-Syntax         (SW) }
{ Version 1.2  - Fixed some problems with getting the addresses of some        }
{                Extensions (e.g. glTexImage3D) where the EXT/ARB did work     }
{                but not the core-functions                               (SW) }
{ Version 1.3  - A second call to ReadimplementationProperties won't           }
{                revert to the default libs anymore                       (MW) }
{              - Libraries now will be released if necessary              (MW) }
{ Version 1.3a - Small fixes for glSlang-functions                        (SW) }
{ Version 1.3b - Fixed a small bug with GL_ARB_shader_objects, that lead       }
{                lead to that extension not loaded correctly              (SW) }
{ Version 1.3c - more GL 1.5 compliance by FOG_COORD_xx and                    }
{                ARB less VBO and occlusion query routines                (MW) }
{ Version 1.3d - Fixed linebreaks (should now be corrected under D5)      (SW) }
{ Version 1.4  - Changed header to correspond to the OpenGL-Shading            }
{	               Language specification 1.10 :                                 }
{                - Added new GL_SAMPLER_*-Constants                            }
{                - Added Constant GL_SHADING_LANGUAGE_VERSION_ARB              }
{                - Added Constant GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB       }
{                - Added Constant GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB  (SW) }
{ Version 1.4a - Fixed a missing stdcall for glBindAttribLocationARB      (SW) }
{ Version 1.4b - Fixed declaration for glUniform*(f/i)vARB (added count)  (MW) }
{              - glCompileShaderARB changed from function to procedure    (MW) }
{ Version 1.5  - Added support for FreePascal                             (BR) }
{              - Added type TGLVectorf3/TGLVector3f                       (SW) }
{ Version 1.6  - Added Extension GL_EXT_framebuffer_object                (SX) }
{ Version 1.7  - Added Extension GL_ARB_fragment_program_shadow           (SX) }
{                Added Extension GL_ARB_draw_buffers                      (SX) }
{                Added Extension GL_ARB_texture_rectangle                 (SX) }
{                Added Extension GL_ARB_color_buffer_float                (SX) }
{                Added Extension GL_ARB_half_float_pixel                  (SX) }
{                Added Extension GL_ARB_texture_float                     (SX) }
{                Added Extension GL_ARB_pixel_buffer_object               (SX) }
{                Added Extension GL_EXT_depth_bounds_test                 (SX) }
{                Added Extension GL_EXT_texture_mirror_clamp              (SX) }
{                Added Extension GL_EXT_blend_equation_separate           (SX) }
{                Added Extension GL_EXT_pixel_buffer_object               (SX) }
{                Added Extension GL_EXT_texture_compression_dxt1          (SX) }
{                Added Extension GL_NV_fragment_program_option            (SX) }
{                Added Extension GL_NV_fragment_program2                  (SX) }
{                Added Extension GL_NV_vertex_program2_option             (SX) }
{                Added Extension GL_NV_vertex_program3                    (SX) }
{ Version 1.8    Added explicit delegate type definitions                 (LM) }
{                Added .Net 1.1 Support                                   (LM) }
{                Added .Net overloaded functions                          (LM) }
{                Added delayed extension loading and stubs                (LM) }
{                Added automatic InitOpenGL call in CreateRenderingContext(LM) }
{                Added extra Read_* function                              (LM) }
{ Version 2.0    fixed some Problem with version string and damn drivers.      }
{                String 1.15 identified as OpenGL 1.5 not as OpenGL 1.1   (SX) }
{                Removed unexisting extension GL_ARB_texture_mirror_repeat(SX) }
{                Added Extension WGL_ARB_pixel_format_float               (SX) }
{                Added Extension GL_EXT_stencil_clear_tag                 (SX) }
{                Added Extension GL_EXT_texture_rectangle                 (SX) }
{                Added Extension GL_EXT_texture_edge_clamp                (SX) }
{                Some 1.5 Core Consts added (now completed)               (SX) }
{                gluProject need pointer for not .net                     (SX) }
{                gluUnProject need pointer for not .net                   (SX) }
{                wglUseFontOutlines* need pointer for not .net            (SX) }
{                wglSwapMultipleBuffers need pointer for not .net         (SX) }
{                Bug with wglGetExtensionsStringEXT removed                    }
{                different type for .net                                  (SX) }
{                Added OpenGL 2.0 Core                                    (SX) }
{==============================================================================}

unit dglOpenGL;
{$IFDEF FPC}
// Added by bero
{$MODE Delphi}
{$IFDEF CPUI386}
{$DEFINE CPU386}
{$ASMMODE INTEL}
{$ENDIF}
{$IFNDEF WIN32}
{$LINKLIB c}
{$ENDIF}
{$ENDIF}

interface

{$H+,O+,X+}

{$IFDEF VER140}
{$DEFINE DELPHI6}
{$ENDIF}
{$IFDEF VER150}
{$DEFINE DELPHI6}
{$DEFINE DELPHI7}
{$ENDIF}
{$IFDEF VER160}
{$DEFINE DELPHI6}
{$DEFINE DELPHI7}
{$DEFINE DELPHI8}
{$ENDIF}
{$IFDEF VER170}
{$DEFINE DELPHI6}
{$DEFINE DELPHI7}
{$DEFINE DELPHI8}
{$DEFINE DELPHI2005}
{$ENDIF}

{$IFDEF DELPHI6}
{$A4}
{$ELSE}
{$A+}
{$ENDIF}

{$IFDEF DELPHI7}
{$WARN UNSAFE_TYPE OFF}
{$WARN UNSAFE_CODE OFF}
{$WARN UNSAFE_CAST OFF}
{$ENDIF}

{$IFDEF DELPHI9}
{$INLINE ON}
{$ENDIF}


{$IFDEF Win32}
{$DEFINE Win32CLR}
{$ENDIF}
{$IFDEF CLR}
{$DEFINE Win32CLR}
{$ENDIF}

uses
  SysUtils{$IFDEF Win32}, Windows{$ENDIF}
{$IFDEF CLR},
  System.Runtime.InteropServices,
  System.Reflection,
  System.Reflection.Emit,
  System.Threading,
  System.Drawing,
  System.Drawing.Imaging,
  System.IO,
  System.Text
{$ENDIF};

type
  // Needed for Delphi 6 and less (defined in system.pas for Delphi 7)
  PPointer = ^Pointer;

  TGLenum = Cardinal;
  TGLboolean = BYTEBOOL;
  TGLbitfield = Cardinal;
  TGLbyte = Shortint;
  TGLshort = SmallInt;
  TGLint = Integer;
  TGLsizei = Integer;
  TGLubyte = Byte;
  TGLushort = Word;
  TGLuint = Cardinal;
  TGLfloat = Single;
  TGLclampf = Single;
  TGLdouble = Double;
  TGLclampd = Double;
  TGLvoid = Pointer;
  TGLint64 = Int64;

  GLenum = Cardinal;
  GLboolean = BYTEBOOL;
  GLbitfield = Cardinal;
  GLbyte = Shortint;
  GLshort = SmallInt;
  GLint = Integer;
  GLsizei = Integer;
  GLubyte = Byte;
  GLushort = Word;
  GLuint = Cardinal;
  GLfloat = Single;
  GLclampf = Single;
  GLdouble = Double;
  GLclampd = Double;
  GLvoid = Pointer;
  GLint64 = Int64;

{$IFDEF CLR}
  PGLBoolean = array of GLBoolean;
  PGLByte = array of GLByte;
  PGLShort = array of GLShort;
  PGLInt = array of GLInt;
  PGLSizei = array of TGLsizei;
  PGLubyte = array of TGLubyte;
  PGLushort = array of TGLushort;
  PGLuint = array of TGLuint;
  PGLclampf = array of TGLclampf;
  PGLfloat = array of TGLfloat;
  PGLdouble = array of TGLdouble;
  PGLclampd = array of TGLclampd;
  PGLenum = array of TGLenum;
  PGLvoid = IntPtr;
  PGLint64 = array of TGLint64;
  // GL_NV_half_float
  TGLhalfNV = WORD;
  PGLhalfNV = array of WORD;
  PChar = string;

  // GL_ARB_shader_objects
  GLHandleARB = Integer;
  PGLHandleARB = array of GLHandleARB;
  PPGLCharARB = array of string;
  PGLCharARB = PChar;
  GLCharARB = Char;

  // GL_VERSION_2_0
  GLHandle = Integer;

{$ELSE}
  PGLBoolean = ^TGLboolean;
  PGLByte = ^TGLbyte;
  PGLShort = ^TGLshort;
  PGLInt = ^TGLint;
  PGLSizei = ^TGLsizei;
  PGLubyte = ^TGLubyte;
  PGLushort = ^TGLushort;
  PGLuint = ^TGLuint;
  PGLclampf = ^TGLclampf;
  PGLfloat = ^TGLfloat;
  PGLdouble = ^TGLdouble;
  PGLclampd = ^TGLclampd;
  PGLenum = ^TGLenum;
  PGLvoid = Pointer;
  PGLint64 = ^TGLint64;
  // GL_NV_half_float
  TGLhalfNV = WORD;
  PGLhalfNV = ^TGLhalfNV;
  // GL_ARB_shader_objects
  PGLHandleARB = ^GLHandleARB;
  GLHandleARB = Integer;
  PPGLCharARB = ^PChar;
  PGLCharARB = PChar;
  GLCharARB = Char;

  // GL_VERSION_2_0
  GLHandle = Integer;
  PPGLChar = ^PChar;
{$ENDIF}

  // Datatypes corresponding to GL's types TGL(name)(type)(count)
  TGLVectori4 = array[0..3] of TGLInt;
  TGLVectorf4 = array[0..3] of TGLFloat;
  TGLVectord3 = array[0..2] of TGLDouble;
  TGLVectord4 = array[0..3] of TGLDouble;
{$IFNDEF CLR}TGLVectorp4 = array[0..3] of Pointer; {$ENDIF}
  TGLVectorf3 = array[0..2] of TGLFloat;
  TGLVector3f = TGLVectorf3;

  TGLArrayf4 = array[0..3] of TGLFloat;
  TGLArrayf3 = array[0..2] of TGLFloat;
  TGLArrayd3 = array[0..2] of TGLDouble;
  TGLArrayi4 = array[0..3] of TGLint;
{$IFNDEF CLR}TGLArrayp4 = array[0..3] of Pointer; {$ENDIF}

  TGLMatrixf4 = array[0..3, 0..3] of Single;
  TGLMatrixd4 = array[0..3, 0..3] of Double;
  TGlMatrixi4 = array[0..3, 0..3] of Integer;

  // Datatypes corresponding to OpenGL12.pas for easy porting
  TVector3d = TGLVectord3;

  TVector4i = TGLVectori4;
  TVector4f = TGLVectorf4;
{$IFNDEF CLR}TVector4p = TGLVectorp4; {$ENDIF}

  TMatrix4f = TGLMatrixf4;
  TMatrix4d = TGLMatrixd4;

{$IFDEF CLR}
  HPBUFFERARB = Integer;
  HPBUFFEREXT = Integer;
  HGLRC = Integer;
  BOOL = LongBool;
  HDC = Integer;
  HWND = Integer;
  UINT = Cardinal;
  DWORD = Cardinal;
  THandle = Integer;

  [StructLayout(LayoutKind.Sequential)]
    TLayerPlaneDescriptor = packed record
    nSize: Word;
    nVersion: Word;
    dwFlags: Integer;
    iPixelType: Byte;
    cColorBits: Byte;
    cRedBits: Byte;
    cRedShift: Byte;
    cGreenBits: Byte;
    cGreenShift: Byte;
    cBlueBits: Byte;
    cBlueShift: Byte;
    cAlphaBits: Byte;
    cAlphaShift: Byte;
    cAccumBits: Byte;
    cAccumRedBits: Byte;
    cAccumGreenBits: Byte;
    cAccumBlueBits: Byte;
    cAccumAlphaBits: Byte;
    cDepthBits: Byte;
    cStencilBits: Byte;
    cAuxBuffers: Byte;
    iLayerPlane: Byte;
    bReserved: Byte;
    crTransparent: Cardinal;
  end;

  [StructLayout(LayoutKind.Sequential)]
    _WGLSWAP = packed record
    hdc: HDC;
    uiFlags: UINT;
  end;

  [StructLayout(LayoutKind.Sequential)]
    TPointFloat = packed record
    x, y: Single;
  end;

  [StructLayout(LayoutKind.Sequential)]
    TGlyphMetricsFloat = packed record
    gmfBlackBoxX: Single;
    gmfBlackBoxY: Single;
    gmfptGlyphOrigin: TPointFloat;
    gmfCellIncX: Single;
    gmfCellIncY: Single;
  end;

  [StructLayout(LayoutKind.Sequential)]
    TPixelFormatDescriptor = packed record
    nSize: Word;
    nVersion: Word;
    dwFlags: DWORD;
    iPixelType: Byte;
    cColorBits: Byte;
    cRedBits: Byte;
    cRedShift: Byte;
    cGreenBits: Byte;
    cGreenShift: Byte;
    cBlueBits: Byte;
    cBlueShift: Byte;
    cAlphaBits: Byte;
    cAlphaShift: Byte;
    cAccumBits: Byte;
    cAccumRedBits: Byte;
    cAccumGreenBits: Byte;
    cAccumBlueBits: Byte;
    cAccumAlphaBits: Byte;
    cDepthBits: Byte;
    cStencilBits: Byte;
    cAuxBuffers: Byte;
    iLayerType: Byte;
    bReserved: Byte;
    dwLayerMask: DWORD;
    dwVisibleMask: DWORD;
    dwDamageMask: DWORD;
  end;

{$ELSE}
  // WGL_ARB_pbuffer
  HPBUFFERARB = THandle;

  // WGL_EXT_pbuffer
  HPBUFFEREXT = THandle;
{$ENDIF}

type
{$IFDEF FPC}
{$IFDEF WIN32}
  // Fixed by bero
  PWGLSwap = ^TWGLSwap;
{$EXTERNALSYM _WGLSWAP}
  _WGLSWAP = packed record
    hdc: HDC;
    uiFlags: UINT;
  end;
  TWGLSwap = _WGLSWAP;
{$EXTERNALSYM WGLSWAP}
  WGLSWAP = _WGLSWAP;
{$ENDIF}
{$ENDIF}

  // GLU types
{$IFDEF CLR}

  PGLUNurbs = IntPtr;
  PGLUQuadric = IntPtr;
  PGLUTesselator = IntPtr;
  // backwards compatibility
  PGLUNurbsObj = IntPtr;
  PGLUQuadricObj = IntPtr;
  PGLUTesselatorObj = IntPtr;
  PGLUTriangulatorObj = IntPtr;

{$ELSE}
  TGLUNurbs = record
  end;
  TGLUQuadric = record
  end;
  TGLUTesselator = record
  end;
  PGLUNurbs = ^TGLUNurbs;
  PGLUQuadric = ^TGLUQuadric;
  PGLUTesselator = ^TGLUTesselator;
  // backwards compatibility
  TGLUNurbsObj = TGLUNurbs;
  TGLUQuadricObj = TGLUQuadric;
  TGLUTesselatorObj = TGLUTesselator;
  TGLUTriangulatorObj = TGLUTesselator;
  PGLUNurbsObj = PGLUNurbs;
  PGLUQuadricObj = PGLUQuadric;
  PGLUTesselatorObj = PGLUTesselator;
  PGLUTriangulatorObj = PGLUTesselator;
{$ENDIF}
  // GLUQuadricCallback
  TGLUQuadricErrorProc = procedure(errorCode: TGLEnum); {$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}
  // GLUTessCallback
  TGLUTessBeginProc = procedure(AType: TGLEnum); {$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}
  TGLUTessEdgeFlagProc = procedure(Flag: TGLboolean); {$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}
  TGLUTessVertexProc = procedure(VertexData: Pointer); {$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}
  TGLUTessEndProc = procedure; {$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}
  TGLUTessErrorProc = procedure(ErrNo: TGLEnum); {$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}
{$IFNDEF CLR}TGLUTessCombineProc = procedure(Coords: TGLArrayd3; VertexData: TGLArrayp4; Weight: TGLArrayf4; OutData: PPointer); {$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TGLUTessBeginDataProc = procedure(AType: TGLEnum; UserData: Pointer); {$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}
  TGLUTessEdgeFlagDataProc = procedure(Flag: TGLboolean; UserData: Pointer); {$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}
  TGLUTessVertexDataProc = procedure(VertexData: Pointer; UserData: Pointer); {$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}
  TGLUTessEndDataProc = procedure(UserData: Pointer); {$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}
  TGLUTessErrorDataProc = procedure(ErrNo: TGLEnum; UserData: Pointer); {$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}
{$IFNDEF CLR}TGLUTessCombineDataProc = procedure(Coords: TGLArrayd3; VertexData: TGLArrayp4; Weight: TGLArrayf4; OutData: PPointer; UserData: Pointer); {$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  // GLUNurbsCallback
  TGLUNurbsErrorProc = procedure(ErrorCode: TGLEnum); {$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}

var
  GL_VERSION_1_0,
    GL_VERSION_1_1,
    GL_VERSION_1_2,
    GL_VERSION_1_3,
    GL_VERSION_1_4,
    GL_VERSION_1_5,
    GL_VERSION_2_0,
    GLU_VERSION_1_1,
    GLU_VERSION_1_2,
    GLU_VERSION_1_3,
    GL_3DFX_multisample,
    GL_3DFX_tbuffer,
    GL_3DFX_texture_compression_FXT1,
    GL_APPLE_client_storage,
    GL_APPLE_element_array,
    GL_APPLE_fence,
    GL_APPLE_specular_vector,
    GL_APPLE_transform_hint,
    GL_APPLE_vertex_array_object,
    GL_APPLE_vertex_array_range,
    GL_APPLE_ycbcr_422,
    GL_ARB_depth_texture,
    GL_ARB_fragment_program,
    GL_ARB_imaging,
    GL_ARB_matrix_palette,
    GL_ARB_multisample,
    GL_ARB_multitexture,
    GL_ARB_point_parameters,
    GL_ARB_shadow,
    GL_ARB_shadow_ambient,
    GL_ARB_texture_border_clamp,
    GL_ARB_texture_compression,
    GL_ARB_texture_cube_map,
    GL_ARB_texture_env_add,
    GL_ARB_texture_env_combine,
    GL_ARB_texture_env_crossbar,
    GL_ARB_texture_env_dot3,
    GL_ARB_texture_mirrored_repeat,
    GL_ARB_transpose_matrix,
    GL_ARB_vertex_blend,
    GL_ARB_vertex_buffer_object,
    GL_ARB_vertex_program,
    GL_ARB_window_pos,
    GL_ARB_shader_objects,
    GL_ARB_vertex_shader,
    GL_ARB_fragment_shader,
    GL_ARB_shading_language_100,
    GL_ARB_occlusion_query,
    GL_ARB_texture_non_power_of_two,
    GL_ARB_point_sprite,
    GL_ARB_fragment_program_shadow,
    GL_ARB_draw_buffers,
    GL_ARB_texture_rectangle,
    GL_ARB_color_buffer_float,
    GL_ARB_half_float_pixel,
    GL_ARB_texture_float,
    GL_ARB_pixel_buffer_object,
    GL_ATI_draw_buffers,
    GL_ATI_element_array,
    GL_ATI_envmap_bumpmap,
    GL_ATI_fragment_shader,
    GL_ATI_map_object_buffer,
    GL_ATI_pn_triangles,
    GL_ATI_separate_stencil,
    GL_ATI_text_fragment_shader,
    GL_ATI_texture_env_combine3,
    GL_ATI_texture_float,
    GL_ATI_texture_mirror_once,
    GL_ATI_vertex_array_object,
    GL_ATI_vertex_attrib_array_object,
    GL_ATI_vertex_streams,
    GL_EXT_422_pixels,
    GL_EXT_abgr,
    GL_EXT_bgra,
    GL_EXT_blend_color,
    GL_EXT_blend_func_separate,
    GL_EXT_blend_logic_op,
    GL_EXT_blend_minmax,
    GL_EXT_blend_subtract,
    GL_EXT_clip_volume_hint,
    GL_EXT_cmyka,
    GL_EXT_color_matrix,
    GL_EXT_color_subtable,
    GL_EXT_compiled_vertex_array,
    GL_EXT_convolution,
    GL_EXT_coordinate_frame,
    GL_EXT_copy_texture,
    GL_EXT_cull_vertex,
    GL_EXT_draw_range_elements,
    GL_EXT_fog_coord,
    GL_EXT_framebuffer_object,
    GL_EXT_histogram,
    GL_EXT_index_array_formats,
    GL_EXT_index_func,
    GL_EXT_index_material,
    GL_EXT_index_texture,
    GL_EXT_light_texture,
    GL_EXT_misc_attribute,
    GL_EXT_multi_draw_arrays,
    GL_EXT_multisample,
    GL_EXT_packed_pixels,
    GL_EXT_paletted_texture,
    GL_EXT_pixel_transform,
    GL_EXT_pixel_transform_color_table,
    GL_EXT_point_parameters,
    GL_EXT_polygon_offset,
    GL_EXT_rescale_normal,
    GL_EXT_secondary_color,
    GL_EXT_separate_specular_color,
    GL_EXT_shadow_funcs,
    GL_EXT_shared_texture_palette,
    GL_EXT_stencil_two_side,
    GL_EXT_stencil_wrap,
    GL_EXT_subtexture,
    GL_EXT_texture,
    GL_EXT_texture3D,
    GL_EXT_texture_compression_s3tc,
    GL_EXT_texture_cube_map,
    GL_EXT_texture_edge_clamp,
    GL_EXT_texture_env_add,
    GL_EXT_texture_env_combine,
    GL_EXT_texture_env_dot3,
    GL_EXT_texture_filter_anisotropic,
    GL_EXT_texture_lod_bias,
    GL_EXT_texture_object,
    GL_EXT_texture_perturb_normal,
    GL_EXT_texture_rectangle,    
    GL_EXT_vertex_array,
    GL_EXT_vertex_shader,
    GL_EXT_vertex_weighting,
    GL_EXT_depth_bounds_test,
    GL_EXT_texture_mirror_clamp,
    GL_EXT_blend_equation_separate,
    GL_EXT_pixel_buffer_object,
    GL_EXT_texture_compression_dxt1,
    GL_EXT_stencil_clear_tag,
    GL_FfdMaskSGIX,
    GL_HP_convolution_border_modes,
    GL_HP_image_transform,
    GL_HP_occlusion_test,
    GL_HP_texture_lighting,
    GL_IBM_cull_vertex,
    GL_IBM_multimode_draw_arrays,
    GL_IBM_rasterpos_clip,
    GL_IBM_texture_mirrored_repeat,
    GL_IBM_vertex_array_lists,
    GL_INGR_blend_func_separate,
    GL_INGR_color_clamp,
    GL_INGR_interlace_read,
    GL_INGR_palette_buffer,
    GL_INTEL_parallel_arrays,
    GL_INTEL_texture_scissor,
    GL_MESA_resize_buffers,
    GL_MESA_window_pos,
    GL_NV_blend_square,
    GL_NV_copy_depth_to_color,
    GL_NV_depth_clamp,
    GL_NV_evaluators,
    GL_NV_fence,
    GL_NV_float_buffer,
    GL_NV_fog_distance,
    GL_NV_fragment_program,
    GL_NV_half_float,
    GL_NV_light_max_exponent,
    GL_NV_multisample_filter_hint,
    GL_NV_occlusion_query,
    GL_NV_packed_depth_stencil,
    GL_NV_pixel_data_range,
    GL_NV_point_sprite,
    GL_NV_primitive_restart,
    GL_NV_register_combiners,
    GL_NV_register_combiners2,
    GL_NV_texgen_emboss,
    GL_NV_texgen_reflection,
    GL_NV_texture_compression_vtc,
    GL_NV_texture_env_combine4,
    GL_NV_texture_expand_normal,
    GL_NV_texture_rectangle,
    GL_NV_texture_shader,
    GL_NV_texture_shader2,
    GL_NV_texture_shader3,
    GL_NV_vertex_array_range,
    GL_NV_vertex_array_range2,
    GL_NV_vertex_program,
    GL_NV_vertex_program1_1,
    GL_NV_vertex_program2,
    GL_NV_fragment_program_option,
    GL_NV_fragment_program2,
    GL_NV_vertex_program2_option,
    GL_NV_vertex_program3,
    GL_OML_interlace,
    GL_OML_resample,
    GL_OML_subsample,
    GL_PGI_misc_hints,
    GL_PGI_vertex_hints,
    GL_REND_screen_coordinates,
    GL_S3_s3tc,
    GL_SGIS_detail_texture,
    GL_SGIS_fog_function,
    GL_SGIS_generate_mipmap,
    GL_SGIS_multisample,
    GL_SGIS_pixel_texture,
    GL_SGIS_point_line_texgen,
    GL_SGIS_point_parameters,
    GL_SGIS_sharpen_texture,
    GL_SGIS_texture4D,
    GL_SGIS_texture_border_clamp,
    GL_SGIS_texture_color_mask,
    GL_SGIS_texture_edge_clamp,
    GL_SGIS_texture_filter4,
    GL_SGIS_texture_lod,
    GL_SGIS_texture_select,
    GL_SGIX_async,
    GL_SGIX_async_histogram,
    GL_SGIX_async_pixel,
    GL_SGIX_blend_alpha_minmax,
    GL_SGIX_calligraphic_fragment,
    GL_SGIX_clipmap,
    GL_SGIX_convolution_accuracy,
    GL_SGIX_depth_pass_instrument,
    GL_SGIX_depth_texture,
    GL_SGIX_flush_raster,
    GL_SGIX_fog_offset,
    GL_SGIX_fog_scale,
    GL_SGIX_fragment_lighting,
    GL_SGIX_framezoom,
    GL_SGIX_igloo_interface,
    GL_SGIX_impact_pixel_texture,
    GL_SGIX_instruments,
    GL_SGIX_interlace,
    GL_SGIX_ir_instrument1,
    GL_SGIX_list_priority,
    GL_SGIX_pixel_texture,
    GL_SGIX_pixel_tiles,
    GL_SGIX_polynomial_ffd,
    GL_SGIX_reference_plane,
    GL_SGIX_resample,
    GL_SGIX_scalebias_hint,
    GL_SGIX_shadow,
    GL_SGIX_shadow_ambient,
    GL_SGIX_sprite,
    GL_SGIX_subsample,
    GL_SGIX_tag_sample_buffer,
    GL_SGIX_texture_add_env,
    GL_SGIX_texture_coordinate_clamp,
    GL_SGIX_texture_lod_bias,
    GL_SGIX_texture_multi_buffer,
    GL_SGIX_texture_scale_bias,
    GL_SGIX_texture_select,
    GL_SGIX_vertex_preclip,
    GL_SGIX_ycrcb,
    GL_SGIX_ycrcb_subsample,
    GL_SGIX_ycrcba,
    GL_SGI_color_matrix,
    GL_SGI_color_table,
    GL_SGI_depth_pass_instrument,
    GL_SGI_texture_color_table,
    GL_SUNX_constant_data,
    GL_SUN_convolution_border_modes,
    GL_SUN_global_alpha,
    GL_SUN_mesh_array,
    GL_SUN_slice_accum,
    GL_SUN_triangle_list,
    GL_SUN_vertex,
    GL_WIN_phong_shading,
    GL_WIN_specular_fog,
    WGL_3DFX_multisample,
    WGL_ARB_buffer_region,
    WGL_ARB_extensions_string,
    WGL_ARB_make_current_read,
    WGL_ARB_multisample,
    WGL_ARB_pbuffer,
    WGL_ARB_pixel_format,
    WGL_ARB_pixel_format_float,
    WGL_ARB_render_texture,
    WGL_ATI_pixel_format_float,
    WGL_EXT_depth_float,
    WGL_EXT_display_color_table,
    WGL_EXT_extensions_string,
    WGL_EXT_make_current_read,
    WGL_EXT_multisample,
    WGL_EXT_pbuffer,
    WGL_EXT_pixel_format,
    WGL_EXT_swap_control,
    WGL_I3D_digital_video_control,
    WGL_I3D_gamma,
    WGL_I3D_genlock,
    WGL_I3D_image_buffer,
    WGL_I3D_swap_frame_lock,
    WGL_I3D_swap_frame_usage,
    WGL_NV_float_buffer,
    WGL_NV_render_depth_texture,
    WGL_NV_render_texture_rectangle,
    WGL_NV_vertex_array_range,
    WGL_OML_sync_control,
    WIN_draw_range_elements,
    WIN_swap_hint: Boolean;

const
  // GL_VERSION_1_1
  GL_ACCUM = $0100;
  GL_LOAD = $0101;
  GL_RETURN = $0102;
  GL_MULT = $0103;
  GL_ADD = $0104;
  GL_NEVER = $0200;
  GL_LESS = $0201;
  GL_EQUAL = $0202;
  GL_LEQUAL = $0203;
  GL_GREATER = $0204;
  GL_NOTEQUAL = $0205;
  GL_GEQUAL = $0206;
  GL_ALWAYS = $0207;
  GL_CURRENT_BIT = $00000001;
  GL_POINT_BIT = $00000002;
  GL_LINE_BIT = $00000004;
  GL_POLYGON_BIT = $00000008;
  GL_POLYGON_STIPPLE_BIT = $00000010;
  GL_PIXEL_MODE_BIT = $00000020;
  GL_LIGHTING_BIT = $00000040;
  GL_FOG_BIT = $00000080;
  GL_DEPTH_BUFFER_BIT = $00000100;
  GL_ACCUM_BUFFER_BIT = $00000200;
  GL_STENCIL_BUFFER_BIT = $00000400;
  GL_VIEWPORT_BIT = $00000800;
  GL_TRANSFORM_BIT = $00001000;
  GL_ENABLE_BIT = $00002000;
  GL_COLOR_BUFFER_BIT = $00004000;
  GL_HINT_BIT = $00008000;
  GL_EVAL_BIT = $00010000;
  GL_LIST_BIT = $00020000;
  GL_TEXTURE_BIT = $00040000;
  GL_SCISSOR_BIT = $00080000;
  GL_ALL_ATTRIB_BITS = $000FFFFF;
  GL_POINTS = $0000;
  GL_LINES = $0001;
  GL_LINE_LOOP = $0002;
  GL_LINE_STRIP = $0003;
  GL_TRIANGLES = $0004;
  GL_TRIANGLE_STRIP = $0005;
  GL_TRIANGLE_FAN = $0006;
  GL_QUADS = $0007;
  GL_QUAD_STRIP = $0008;
  GL_POLYGON = $0009;
  GL_ZERO = 0;
  GL_ONE = 1;
  GL_SRC_COLOR = $0300;
  GL_ONE_MINUS_SRC_COLOR = $0301;
  GL_SRC_ALPHA = $0302;
  GL_ONE_MINUS_SRC_ALPHA = $0303;
  GL_DST_ALPHA = $0304;
  GL_ONE_MINUS_DST_ALPHA = $0305;
  GL_DST_COLOR = $0306;
  GL_ONE_MINUS_DST_COLOR = $0307;
  GL_SRC_ALPHA_SATURATE = $0308;
  GL_TRUE = 1;
  GL_FALSE = 0;
  GL_CLIP_PLANE0 = $3000;
  GL_CLIP_PLANE1 = $3001;
  GL_CLIP_PLANE2 = $3002;
  GL_CLIP_PLANE3 = $3003;
  GL_CLIP_PLANE4 = $3004;
  GL_CLIP_PLANE5 = $3005;
  GL_BYTE = $1400;
  GL_UNSIGNED_BYTE = $1401;
  GL_SHORT = $1402;
  GL_UNSIGNED_SHORT = $1403;
  GL_INT = $1404;
  GL_UNSIGNED_INT = $1405;
  GL_FLOAT = $1406;
  GL_2_BYTES = $1407;
  GL_3_BYTES = $1408;
  GL_4_BYTES = $1409;
  GL_DOUBLE = $140A;
  GL_NONE = 0;
  GL_FRONT_LEFT = $0400;
  GL_FRONT_RIGHT = $0401;
  GL_BACK_LEFT = $0402;
  GL_BACK_RIGHT = $0403;
  GL_FRONT = $0404;
  GL_BACK = $0405;
  GL_LEFT = $0406;
  GL_RIGHT = $0407;
  GL_FRONT_AND_BACK = $0408;
  GL_AUX0 = $0409;
  GL_AUX1 = $040A;
  GL_AUX2 = $040B;
  GL_AUX3 = $040C;
  GL_NO_ERROR = 0;
  GL_INVALID_ENUM = $0500;
  GL_INVALID_VALUE = $0501;
  GL_INVALID_OPERATION = $0502;
  GL_STACK_OVERFLOW = $0503;
  GL_STACK_UNDERFLOW = $0504;
  GL_OUT_OF_MEMORY = $0505;
  GL_2D = $0600;
  GL_3D = $0601;
  GL_3D_COLOR = $0602;
  GL_3D_COLOR_TEXTURE = $0603;
  GL_4D_COLOR_TEXTURE = $0604;
  GL_PASS_THROUGH_TOKEN = $0700;
  GL_POINT_TOKEN = $0701;
  GL_LINE_TOKEN = $0702;
  GL_POLYGON_TOKEN = $0703;
  GL_BITMAP_TOKEN = $0704;
  GL_DRAW_PIXEL_TOKEN = $0705;
  GL_COPY_PIXEL_TOKEN = $0706;
  GL_LINE_RESET_TOKEN = $0707;
  GL_EXP = $0800;
  GL_EXP2 = $0801;
  GL_CW = $0900;
  GL_CCW = $0901;
  GL_COEFF = $0A00;
  GL_ORDER = $0A01;
  GL_DOMAIN = $0A02;
  GL_CURRENT_COLOR = $0B00;
  GL_CURRENT_INDEX = $0B01;
  GL_CURRENT_NORMAL = $0B02;
  GL_CURRENT_TEXTURE_COORDS = $0B03;
  GL_CURRENT_RASTER_COLOR = $0B04;
  GL_CURRENT_RASTER_INDEX = $0B05;
  GL_CURRENT_RASTER_TEXTURE_COORDS = $0B06;
  GL_CURRENT_RASTER_POSITION = $0B07;
  GL_CURRENT_RASTER_POSITION_VALID = $0B08;
  GL_CURRENT_RASTER_DISTANCE = $0B09;
  GL_POINT_SMOOTH = $0B10;
  GL_POINT_SIZE = $0B11;
  GL_POINT_SIZE_RANGE = $0B12;
  GL_POINT_SIZE_GRANULARITY = $0B13;
  GL_LINE_SMOOTH = $0B20;
  GL_LINE_WIDTH = $0B21;
  GL_LINE_WIDTH_RANGE = $0B22;
  GL_LINE_WIDTH_GRANULARITY = $0B23;
  GL_LINE_STIPPLE = $0B24;
  GL_LINE_STIPPLE_PATTERN = $0B25;
  GL_LINE_STIPPLE_REPEAT = $0B26;
  GL_LIST_MODE = $0B30;
  GL_MAX_LIST_NESTING = $0B31;
  GL_LIST_BASE = $0B32;
  GL_LIST_INDEX = $0B33;
  GL_POLYGON_MODE = $0B40;
  GL_POLYGON_SMOOTH = $0B41;
  GL_POLYGON_STIPPLE = $0B42;
  GL_EDGE_FLAG = $0B43;
  GL_CULL_FACE = $0B44;
  GL_CULL_FACE_MODE = $0B45;
  GL_FRONT_FACE = $0B46;
  GL_LIGHTING = $0B50;
  GL_LIGHT_MODEL_LOCAL_VIEWER = $0B51;
  GL_LIGHT_MODEL_TWO_SIDE = $0B52;
  GL_LIGHT_MODEL_AMBIENT = $0B53;
  GL_SHADE_MODEL = $0B54;
  GL_COLOR_MATERIAL_FACE = $0B55;
  GL_COLOR_MATERIAL_PARAMETER = $0B56;
  GL_COLOR_MATERIAL = $0B57;
  GL_FOG = $0B60;
  GL_FOG_INDEX = $0B61;
  GL_FOG_DENSITY = $0B62;
  GL_FOG_START = $0B63;
  GL_FOG_END = $0B64;
  GL_FOG_MODE = $0B65;
  GL_FOG_COLOR = $0B66;
  GL_DEPTH_RANGE = $0B70;
  GL_DEPTH_TEST = $0B71;
  GL_DEPTH_WRITEMASK = $0B72;
  GL_DEPTH_CLEAR_VALUE = $0B73;
  GL_DEPTH_FUNC = $0B74;
  GL_ACCUM_CLEAR_VALUE = $0B80;
  GL_STENCIL_TEST = $0B90;
  GL_STENCIL_CLEAR_VALUE = $0B91;
  GL_STENCIL_FUNC = $0B92;
  GL_STENCIL_VALUE_MASK = $0B93;
  GL_STENCIL_FAIL = $0B94;
  GL_STENCIL_PASS_DEPTH_FAIL = $0B95;
  GL_STENCIL_PASS_DEPTH_PASS = $0B96;
  GL_STENCIL_REF = $0B97;
  GL_STENCIL_WRITEMASK = $0B98;
  GL_MATRIX_MODE = $0BA0;
  GL_NORMALIZE = $0BA1;
  GL_VIEWPORT = $0BA2;
  GL_MODELVIEW_STACK_DEPTH = $0BA3;
  GL_PROJECTION_STACK_DEPTH = $0BA4;
  GL_TEXTURE_STACK_DEPTH = $0BA5;
  GL_MODELVIEW_MATRIX = $0BA6;
  GL_PROJECTION_MATRIX = $0BA7;
  GL_TEXTURE_MATRIX = $0BA8;
  GL_ATTRIB_STACK_DEPTH = $0BB0;
  GL_CLIENT_ATTRIB_STACK_DEPTH = $0BB1;
  GL_ALPHA_TEST = $0BC0;
  GL_ALPHA_TEST_FUNC = $0BC1;
  GL_ALPHA_TEST_REF = $0BC2;
  GL_DITHER = $0BD0;
  GL_BLEND_DST = $0BE0;
  GL_BLEND_SRC = $0BE1;
  GL_BLEND = $0BE2;
  GL_LOGIC_OP_MODE = $0BF0;
  GL_INDEX_LOGIC_OP = $0BF1;
  GL_COLOR_LOGIC_OP = $0BF2;
  GL_AUX_BUFFERS = $0C00;
  GL_DRAW_BUFFER = $0C01;
  GL_READ_BUFFER = $0C02;
  GL_SCISSOR_BOX = $0C10;
  GL_SCISSOR_TEST = $0C11;
  GL_INDEX_CLEAR_VALUE = $0C20;
  GL_INDEX_WRITEMASK = $0C21;
  GL_COLOR_CLEAR_VALUE = $0C22;
  GL_COLOR_WRITEMASK = $0C23;
  GL_INDEX_MODE = $0C30;
  GL_RGBA_MODE = $0C31;
  GL_DOUBLEBUFFER = $0C32;
  GL_STEREO = $0C33;
  GL_RENDER_MODE = $0C40;
  GL_PERSPECTIVE_CORRECTION_HINT = $0C50;
  GL_POINT_SMOOTH_HINT = $0C51;
  GL_LINE_SMOOTH_HINT = $0C52;
  GL_POLYGON_SMOOTH_HINT = $0C53;
  GL_FOG_HINT = $0C54;
  GL_TEXTURE_GEN_S = $0C60;
  GL_TEXTURE_GEN_T = $0C61;
  GL_TEXTURE_GEN_R = $0C62;
  GL_TEXTURE_GEN_Q = $0C63;
  GL_PIXEL_MAP_I_TO_I = $0C70;
  GL_PIXEL_MAP_S_TO_S = $0C71;
  GL_PIXEL_MAP_I_TO_R = $0C72;
  GL_PIXEL_MAP_I_TO_G = $0C73;
  GL_PIXEL_MAP_I_TO_B = $0C74;
  GL_PIXEL_MAP_I_TO_A = $0C75;
  GL_PIXEL_MAP_R_TO_R = $0C76;
  GL_PIXEL_MAP_G_TO_G = $0C77;
  GL_PIXEL_MAP_B_TO_B = $0C78;
  GL_PIXEL_MAP_A_TO_A = $0C79;
  GL_PIXEL_MAP_I_TO_I_SIZE = $0CB0;
  GL_PIXEL_MAP_S_TO_S_SIZE = $0CB1;
  GL_PIXEL_MAP_I_TO_R_SIZE = $0CB2;
  GL_PIXEL_MAP_I_TO_G_SIZE = $0CB3;
  GL_PIXEL_MAP_I_TO_B_SIZE = $0CB4;
  GL_PIXEL_MAP_I_TO_A_SIZE = $0CB5;
  GL_PIXEL_MAP_R_TO_R_SIZE = $0CB6;
  GL_PIXEL_MAP_G_TO_G_SIZE = $0CB7;
  GL_PIXEL_MAP_B_TO_B_SIZE = $0CB8;
  GL_PIXEL_MAP_A_TO_A_SIZE = $0CB9;
  GL_UNPACK_SWAP_BYTES = $0CF0;
  GL_UNPACK_LSB_FIRST = $0CF1;
  GL_UNPACK_ROW_LENGTH = $0CF2;
  GL_UNPACK_SKIP_ROWS = $0CF3;
  GL_UNPACK_SKIP_PIXELS = $0CF4;
  GL_UNPACK_ALIGNMENT = $0CF5;
  GL_PACK_SWAP_BYTES = $0D00;
  GL_PACK_LSB_FIRST = $0D01;
  GL_PACK_ROW_LENGTH = $0D02;
  GL_PACK_SKIP_ROWS = $0D03;
  GL_PACK_SKIP_PIXELS = $0D04;
  GL_PACK_ALIGNMENT = $0D05;
  GL_MAP_COLOR = $0D10;
  GL_MAP_STENCIL = $0D11;
  GL_INDEX_SHIFT = $0D12;
  GL_INDEX_OFFSET = $0D13;
  GL_RED_SCALE = $0D14;
  GL_RED_BIAS = $0D15;
  GL_ZOOM_X = $0D16;
  GL_ZOOM_Y = $0D17;
  GL_GREEN_SCALE = $0D18;
  GL_GREEN_BIAS = $0D19;
  GL_BLUE_SCALE = $0D1A;
  GL_BLUE_BIAS = $0D1B;
  GL_ALPHA_SCALE = $0D1C;
  GL_ALPHA_BIAS = $0D1D;
  GL_DEPTH_SCALE = $0D1E;
  GL_DEPTH_BIAS = $0D1F;
  GL_MAX_EVAL_ORDER = $0D30;
  GL_MAX_LIGHTS = $0D31;
  GL_MAX_CLIP_PLANES = $0D32;
  GL_MAX_TEXTURE_SIZE = $0D33;
  GL_MAX_PIXEL_MAP_TABLE = $0D34;
  GL_MAX_ATTRIB_STACK_DEPTH = $0D35;
  GL_MAX_MODELVIEW_STACK_DEPTH = $0D36;
  GL_MAX_NAME_STACK_DEPTH = $0D37;
  GL_MAX_PROJECTION_STACK_DEPTH = $0D38;
  GL_MAX_TEXTURE_STACK_DEPTH = $0D39;
  GL_MAX_VIEWPORT_DIMS = $0D3A;
  GL_MAX_CLIENT_ATTRIB_STACK_DEPTH = $0D3B;
  GL_SUBPIXEL_BITS = $0D50;
  GL_INDEX_BITS = $0D51;
  GL_RED_BITS = $0D52;
  GL_GREEN_BITS = $0D53;
  GL_BLUE_BITS = $0D54;
  GL_ALPHA_BITS = $0D55;
  GL_DEPTH_BITS = $0D56;
  GL_STENCIL_BITS = $0D57;
  GL_ACCUM_RED_BITS = $0D58;
  GL_ACCUM_GREEN_BITS = $0D59;
  GL_ACCUM_BLUE_BITS = $0D5A;
  GL_ACCUM_ALPHA_BITS = $0D5B;
  GL_NAME_STACK_DEPTH = $0D70;
  GL_AUTO_NORMAL = $0D80;
  GL_MAP1_COLOR_4 = $0D90;
  GL_MAP1_INDEX = $0D91;
  GL_MAP1_NORMAL = $0D92;
  GL_MAP1_TEXTURE_COORD_1 = $0D93;
  GL_MAP1_TEXTURE_COORD_2 = $0D94;
  GL_MAP1_TEXTURE_COORD_3 = $0D95;
  GL_MAP1_TEXTURE_COORD_4 = $0D96;
  GL_MAP1_VERTEX_3 = $0D97;
  GL_MAP1_VERTEX_4 = $0D98;
  GL_MAP2_COLOR_4 = $0DB0;
  GL_MAP2_INDEX = $0DB1;
  GL_MAP2_NORMAL = $0DB2;
  GL_MAP2_TEXTURE_COORD_1 = $0DB3;
  GL_MAP2_TEXTURE_COORD_2 = $0DB4;
  GL_MAP2_TEXTURE_COORD_3 = $0DB5;
  GL_MAP2_TEXTURE_COORD_4 = $0DB6;
  GL_MAP2_VERTEX_3 = $0DB7;
  GL_MAP2_VERTEX_4 = $0DB8;
  GL_MAP1_GRID_DOMAIN = $0DD0;
  GL_MAP1_GRID_SEGMENTS = $0DD1;
  GL_MAP2_GRID_DOMAIN = $0DD2;
  GL_MAP2_GRID_SEGMENTS = $0DD3;
  GL_TEXTURE_1D = $0DE0;
  GL_TEXTURE_2D = $0DE1;
  GL_FEEDBACK_BUFFER_POINTER = $0DF0;
  GL_FEEDBACK_BUFFER_SIZE = $0DF1;
  GL_FEEDBACK_BUFFER_TYPE = $0DF2;
  GL_SELECTION_BUFFER_POINTER = $0DF3;
  GL_SELECTION_BUFFER_SIZE = $0DF4;
  GL_TEXTURE_WIDTH = $1000;
  GL_TEXTURE_HEIGHT = $1001;
  GL_TEXTURE_INTERNAL_FORMAT = $1003;
  GL_TEXTURE_BORDER_COLOR = $1004;
  GL_TEXTURE_BORDER = $1005;
  GL_DONT_CARE = $1100;
  GL_FASTEST = $1101;
  GL_NICEST = $1102;
  GL_LIGHT0 = $4000;
  GL_LIGHT1 = $4001;
  GL_LIGHT2 = $4002;
  GL_LIGHT3 = $4003;
  GL_LIGHT4 = $4004;
  GL_LIGHT5 = $4005;
  GL_LIGHT6 = $4006;
  GL_LIGHT7 = $4007;
  GL_AMBIENT = $1200;
  GL_DIFFUSE = $1201;
  GL_SPECULAR = $1202;
  GL_POSITION = $1203;
  GL_SPOT_DIRECTION = $1204;
  GL_SPOT_EXPONENT = $1205;
  GL_SPOT_CUTOFF = $1206;
  GL_CONSTANT_ATTENUATION = $1207;
  GL_LINEAR_ATTENUATION = $1208;
  GL_QUADRATIC_ATTENUATION = $1209;
  GL_COMPILE = $1300;
  GL_COMPILE_AND_EXECUTE = $1301;
  GL_CLEAR = $1500;
  GL_AND = $1501;
  GL_AND_REVERSE = $1502;
  GL_COPY = $1503;
  GL_AND_INVERTED = $1504;
  GL_NOOP = $1505;
  GL_XOR = $1506;
  GL_OR = $1507;
  GL_NOR = $1508;
  GL_EQUIV = $1509;
  GL_INVERT = $150A;
  GL_OR_REVERSE = $150B;
  GL_COPY_INVERTED = $150C;
  GL_OR_INVERTED = $150D;
  GL_NAND = $150E;
  GL_SET = $150F;
  GL_EMISSION = $1600;
  GL_SHININESS = $1601;
  GL_AMBIENT_AND_DIFFUSE = $1602;
  GL_COLOR_INDEXES = $1603;
  GL_MODELVIEW = $1700;
  GL_PROJECTION = $1701;
  GL_TEXTURE = $1702;
  GL_COLOR = $1800;
  GL_DEPTH = $1801;
  GL_STENCIL = $1802;
  GL_COLOR_INDEX = $1900;
  GL_STENCIL_INDEX = $1901;
  GL_DEPTH_COMPONENT = $1902;
  GL_RED = $1903;
  GL_GREEN = $1904;
  GL_BLUE = $1905;
  GL_ALPHA = $1906;
  GL_RGB = $1907;
  GL_RGBA = $1908;
  GL_LUMINANCE = $1909;
  GL_LUMINANCE_ALPHA = $190A;
  GL_BITMAP = $1A00;
  GL_POINT = $1B00;
  GL_LINE = $1B01;
  GL_FILL = $1B02;
  GL_RENDER = $1C00;
  GL_FEEDBACK = $1C01;
  GL_SELECT = $1C02;
  GL_FLAT = $1D00;
  GL_SMOOTH = $1D01;
  GL_KEEP = $1E00;
  GL_REPLACE = $1E01;
  GL_INCR = $1E02;
  GL_DECR = $1E03;
  GL_VENDOR = $1F00;
  GL_RENDERER = $1F01;
  GL_VERSION = $1F02;
  GL_EXTENSIONS = $1F03;
  GL_S = $2000;
  GL_T = $2001;
  GL_R = $2002;
  GL_Q = $2003;
  GL_MODULATE = $2100;
  GL_DECAL = $2101;
  GL_TEXTURE_ENV_MODE = $2200;
  GL_TEXTURE_ENV_COLOR = $2201;
  GL_TEXTURE_ENV = $2300;
  GL_EYE_LINEAR = $2400;
  GL_OBJECT_LINEAR = $2401;
  GL_SPHERE_MAP = $2402;
  GL_TEXTURE_GEN_MODE = $2500;
  GL_OBJECT_PLANE = $2501;
  GL_EYE_PLANE = $2502;
  GL_NEAREST = $2600;
  GL_LINEAR = $2601;
  GL_NEAREST_MIPMAP_NEAREST = $2700;
  GL_LINEAR_MIPMAP_NEAREST = $2701;
  GL_NEAREST_MIPMAP_LINEAR = $2702;
  GL_LINEAR_MIPMAP_LINEAR = $2703;
  GL_TEXTURE_MAG_FILTER = $2800;
  GL_TEXTURE_MIN_FILTER = $2801;
  GL_TEXTURE_WRAP_S = $2802;
  GL_TEXTURE_WRAP_T = $2803;
  GL_CLAMP = $2900;
  GL_REPEAT = $2901;
  GL_CLIENT_PIXEL_STORE_BIT = $00000001;
  GL_CLIENT_VERTEX_ARRAY_BIT = $00000002;
  GL_CLIENT_ALL_ATTRIB_BITS = $FFFFFFFF;
  GL_POLYGON_OFFSET_FACTOR = $8038;
  GL_POLYGON_OFFSET_UNITS = $2A00;
  GL_POLYGON_OFFSET_POINT = $2A01;
  GL_POLYGON_OFFSET_LINE = $2A02;
  GL_POLYGON_OFFSET_FILL = $8037;
  GL_ALPHA4 = $803B;
  GL_ALPHA8 = $803C;
  GL_ALPHA12 = $803D;
  GL_ALPHA16 = $803E;
  GL_LUMINANCE4 = $803F;
  GL_LUMINANCE8 = $8040;
  GL_LUMINANCE12 = $8041;
  GL_LUMINANCE16 = $8042;
  GL_LUMINANCE4_ALPHA4 = $8043;
  GL_LUMINANCE6_ALPHA2 = $8044;
  GL_LUMINANCE8_ALPHA8 = $8045;
  GL_LUMINANCE12_ALPHA4 = $8046;
  GL_LUMINANCE12_ALPHA12 = $8047;
  GL_LUMINANCE16_ALPHA16 = $8048;
  GL_INTENSITY = $8049;
  GL_INTENSITY4 = $804A;
  GL_INTENSITY8 = $804B;
  GL_INTENSITY12 = $804C;
  GL_INTENSITY16 = $804D;
  GL_R3_G3_B2 = $2A10;
  GL_RGB4 = $804F;
  GL_RGB5 = $8050;
  GL_RGB8 = $8051;
  GL_RGB10 = $8052;
  GL_RGB12 = $8053;
  GL_RGB16 = $8054;
  GL_RGBA2 = $8055;
  GL_RGBA4 = $8056;
  GL_RGB5_A1 = $8057;
  GL_RGBA8 = $8058;
  GL_RGB10_A2 = $8059;
  GL_RGBA12 = $805A;
  GL_RGBA16 = $805B;
  GL_TEXTURE_RED_SIZE = $805C;
  GL_TEXTURE_GREEN_SIZE = $805D;
  GL_TEXTURE_BLUE_SIZE = $805E;
  GL_TEXTURE_ALPHA_SIZE = $805F;
  GL_TEXTURE_LUMINANCE_SIZE = $8060;
  GL_TEXTURE_INTENSITY_SIZE = $8061;
  GL_PROXY_TEXTURE_1D = $8063;
  GL_PROXY_TEXTURE_2D = $8064;
  GL_TEXTURE_PRIORITY = $8066;
  GL_TEXTURE_RESIDENT = $8067;
  GL_TEXTURE_BINDING_1D = $8068;
  GL_TEXTURE_BINDING_2D = $8069;
  GL_VERTEX_ARRAY = $8074;
  GL_NORMAL_ARRAY = $8075;
  GL_COLOR_ARRAY = $8076;
  GL_INDEX_ARRAY = $8077;
  GL_TEXTURE_COORD_ARRAY = $8078;
  GL_EDGE_FLAG_ARRAY = $8079;
  GL_VERTEX_ARRAY_SIZE = $807A;
  GL_VERTEX_ARRAY_TYPE = $807B;
  GL_VERTEX_ARRAY_STRIDE = $807C;
  GL_NORMAL_ARRAY_TYPE = $807E;
  GL_NORMAL_ARRAY_STRIDE = $807F;
  GL_COLOR_ARRAY_SIZE = $8081;
  GL_COLOR_ARRAY_TYPE = $8082;
  GL_COLOR_ARRAY_STRIDE = $8083;
  GL_INDEX_ARRAY_TYPE = $8085;
  GL_INDEX_ARRAY_STRIDE = $8086;
  GL_TEXTURE_COORD_ARRAY_SIZE = $8088;
  GL_TEXTURE_COORD_ARRAY_TYPE = $8089;
  GL_TEXTURE_COORD_ARRAY_STRIDE = $808A;
  GL_EDGE_FLAG_ARRAY_STRIDE = $808C;
  GL_VERTEX_ARRAY_POINTER = $808E;
  GL_NORMAL_ARRAY_POINTER = $808F;
  GL_COLOR_ARRAY_POINTER = $8090;
  GL_INDEX_ARRAY_POINTER = $8091;
  GL_TEXTURE_COORD_ARRAY_POINTER = $8092;
  GL_EDGE_FLAG_ARRAY_POINTER = $8093;
  GL_V2F = $2A20;
  GL_V3F = $2A21;
  GL_C4UB_V2F = $2A22;
  GL_C4UB_V3F = $2A23;
  GL_C3F_V3F = $2A24;
  GL_N3F_V3F = $2A25;
  GL_C4F_N3F_V3F = $2A26;
  GL_T2F_V3F = $2A27;
  GL_T4F_V4F = $2A28;
  GL_T2F_C4UB_V3F = $2A29;
  GL_T2F_C3F_V3F = $2A2A;
  GL_T2F_N3F_V3F = $2A2B;
  GL_T2F_C4F_N3F_V3F = $2A2C;
  GL_T4F_C4F_N3F_V4F = $2A2D;
  GL_COLOR_TABLE_FORMAT_EXT = $80D8;
  GL_COLOR_TABLE_WIDTH_EXT = $80D9;
  GL_COLOR_TABLE_RED_SIZE_EXT = $80DA;
  GL_COLOR_TABLE_GREEN_SIZE_EXT = $80DB;
  GL_COLOR_TABLE_BLUE_SIZE_EXT = $80DC;
  GL_COLOR_TABLE_ALPHA_SIZE_EXT = $80DD;
  GL_COLOR_TABLE_LUMINANCE_SIZE_EXT = $80DE;
  GL_COLOR_TABLE_INTENSITY_SIZE_EXT = $80DF;
  GL_LOGIC_OP = GL_INDEX_LOGIC_OP;
  GL_TEXTURE_COMPONENTS = GL_TEXTURE_INTERNAL_FORMAT;

  // GL_VERSION_1_2
  GL_UNSIGNED_BYTE_3_3_2 = $8032;
  GL_UNSIGNED_SHORT_4_4_4_4 = $8033;
  GL_UNSIGNED_SHORT_5_5_5_1 = $8034;
  GL_UNSIGNED_INT_8_8_8_8 = $8035;
  GL_UNSIGNED_INT_10_10_10_2 = $8036;
  GL_RESCALE_NORMAL = $803A;
  GL_TEXTURE_BINDING_3D = $806A;
  GL_PACK_SKIP_IMAGES = $806B;
  GL_PACK_IMAGE_HEIGHT = $806C;
  GL_UNPACK_SKIP_IMAGES = $806D;
  GL_UNPACK_IMAGE_HEIGHT = $806E;
  GL_TEXTURE_3D = $806F;
  GL_PROXY_TEXTURE_3D = $8070;
  GL_TEXTURE_DEPTH = $8071;
  GL_TEXTURE_WRAP_R = $8072;
  GL_MAX_3D_TEXTURE_SIZE = $8073;
  GL_UNSIGNED_BYTE_2_3_3_REV = $8362;
  GL_UNSIGNED_SHORT_5_6_5 = $8363;
  GL_UNSIGNED_SHORT_5_6_5_REV = $8364;
  GL_UNSIGNED_SHORT_4_4_4_4_REV = $8365;
  GL_UNSIGNED_SHORT_1_5_5_5_REV = $8366;
  GL_UNSIGNED_INT_8_8_8_8_REV = $8367;
  GL_UNSIGNED_INT_2_10_10_10_REV = $8368;
  GL_BGR = $80E0;
  GL_BGRA = $80E1;
  GL_MAX_ELEMENTS_VERTICES = $80E8;
  GL_MAX_ELEMENTS_INDICES = $80E9;
  GL_CLAMP_TO_EDGE = $812F;
  GL_TEXTURE_MIN_LOD = $813A;
  GL_TEXTURE_MAX_LOD = $813B;
  GL_TEXTURE_BASE_LEVEL = $813C;
  GL_TEXTURE_MAX_LEVEL = $813D;
  GL_LIGHT_MODEL_COLOR_CONTROL = $81F8;
  GL_SINGLE_COLOR = $81F9;
  GL_SEPARATE_SPECULAR_COLOR = $81FA;
  GL_SMOOTH_POINT_SIZE_RANGE = $0B12;
  GL_SMOOTH_POINT_SIZE_GRANULARITY = $0B13;
  GL_SMOOTH_LINE_WIDTH_RANGE = $0B22;
  GL_SMOOTH_LINE_WIDTH_GRANULARITY = $0B23;
  GL_ALIASED_POINT_SIZE_RANGE = $846D;
  GL_ALIASED_LINE_WIDTH_RANGE = $846E;

  // GL_VERSION_1_3
  GL_TEXTURE0 = $84C0;
  GL_TEXTURE1 = $84C1;
  GL_TEXTURE2 = $84C2;
  GL_TEXTURE3 = $84C3;
  GL_TEXTURE4 = $84C4;
  GL_TEXTURE5 = $84C5;
  GL_TEXTURE6 = $84C6;
  GL_TEXTURE7 = $84C7;
  GL_TEXTURE8 = $84C8;
  GL_TEXTURE9 = $84C9;
  GL_TEXTURE10 = $84CA;
  GL_TEXTURE11 = $84CB;
  GL_TEXTURE12 = $84CC;
  GL_TEXTURE13 = $84CD;
  GL_TEXTURE14 = $84CE;
  GL_TEXTURE15 = $84CF;
  GL_TEXTURE16 = $84D0;
  GL_TEXTURE17 = $84D1;
  GL_TEXTURE18 = $84D2;
  GL_TEXTURE19 = $84D3;
  GL_TEXTURE20 = $84D4;
  GL_TEXTURE21 = $84D5;
  GL_TEXTURE22 = $84D6;
  GL_TEXTURE23 = $84D7;
  GL_TEXTURE24 = $84D8;
  GL_TEXTURE25 = $84D9;
  GL_TEXTURE26 = $84DA;
  GL_TEXTURE27 = $84DB;
  GL_TEXTURE28 = $84DC;
  GL_TEXTURE29 = $84DD;
  GL_TEXTURE30 = $84DE;
  GL_TEXTURE31 = $84DF;
  GL_ACTIVE_TEXTURE = $84E0;
  GL_CLIENT_ACTIVE_TEXTURE = $84E1;
  GL_MAX_TEXTURE_UNITS = $84E2;
  GL_TRANSPOSE_MODELVIEW_MATRIX = $84E3;
  GL_TRANSPOSE_PROJECTION_MATRIX = $84E4;
  GL_TRANSPOSE_TEXTURE_MATRIX = $84E5;
  GL_TRANSPOSE_COLOR_MATRIX = $84E6;
  GL_MULTISAMPLE = $809D;
  GL_SAMPLE_ALPHA_TO_COVERAGE = $809E;
  GL_SAMPLE_ALPHA_TO_ONE = $809F;
  GL_SAMPLE_COVERAGE = $80A0;
  GL_SAMPLE_BUFFERS = $80A8;
  GL_SAMPLES = $80A9;
  GL_SAMPLE_COVERAGE_VALUE = $80AA;
  GL_SAMPLE_COVERAGE_INVERT = $80AB;
  GL_MULTISAMPLE_BIT = $20000000;
  GL_NORMAL_MAP = $8511;
  GL_REFLECTION_MAP = $8512;
  GL_TEXTURE_CUBE_MAP = $8513;
  GL_TEXTURE_BINDING_CUBE_MAP = $8514;
  GL_TEXTURE_CUBE_MAP_POSITIVE_X = $8515;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_X = $8516;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Y = $8517;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = $8518;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Z = $8519;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = $851A;
  GL_PROXY_TEXTURE_CUBE_MAP = $851B;
  GL_MAX_CUBE_MAP_TEXTURE_SIZE = $851C;
  GL_COMPRESSED_ALPHA = $84E9;
  GL_COMPRESSED_LUMINANCE = $84EA;
  GL_COMPRESSED_LUMINANCE_ALPHA = $84EB;
  GL_COMPRESSED_INTENSITY = $84EC;
  GL_COMPRESSED_RGB = $84ED;
  GL_COMPRESSED_RGBA = $84EE;
  GL_TEXTURE_COMPRESSION_HINT = $84EF;
  GL_TEXTURE_COMPRESSED_IMAGE_SIZE = $86A0;
  GL_TEXTURE_COMPRESSED = $86A1;
  GL_NUM_COMPRESSED_TEXTURE_FORMATS = $86A2;
  GL_COMPRESSED_TEXTURE_FORMATS = $86A3;
  GL_CLAMP_TO_BORDER = $812D;
  GL_CLAMP_TO_BORDER_SGIS = $812D;
  GL_COMBINE = $8570;
  GL_COMBINE_RGB = $8571;
  GL_COMBINE_ALPHA = $8572;
  GL_SOURCE0_RGB = $8580;
  GL_SOURCE1_RGB = $8581;
  GL_SOURCE2_RGB = $8582;
  GL_SOURCE0_ALPHA = $8588;
  GL_SOURCE1_ALPHA = $8589;
  GL_SOURCE2_ALPHA = $858A;
  GL_OPERAND0_RGB = $8590;
  GL_OPERAND1_RGB = $8591;
  GL_OPERAND2_RGB = $8592;
  GL_OPERAND0_ALPHA = $8598;
  GL_OPERAND1_ALPHA = $8599;
  GL_OPERAND2_ALPHA = $859A;
  GL_RGB_SCALE = $8573;
  GL_ADD_SIGNED = $8574;
  GL_INTERPOLATE = $8575;
  GL_SUBTRACT = $84E7;
  GL_CONSTANT = $8576;
  GL_PRIMARY_COLOR = $8577;
  GL_PREVIOUS = $8578;
  GL_DOT3_RGB = $86AE;
  GL_DOT3_RGBA = $86AF;

  // GL_VERSION_1_4
  GL_BLEND_DST_RGB = $80C8;
  GL_BLEND_SRC_RGB = $80C9;
  GL_BLEND_DST_ALPHA = $80CA;
  GL_BLEND_SRC_ALPHA = $80CB;
  GL_POINT_SIZE_MIN = $8126;
  GL_POINT_SIZE_MAX = $8127;
  GL_POINT_FADE_THRESHOLD_SIZE = $8128;
  GL_POINT_DISTANCE_ATTENUATION = $8129;
  GL_GENERATE_MIPMAP = $8191;
  GL_GENERATE_MIPMAP_HINT = $8192;
  GL_DEPTH_COMPONENT16 = $81A5;
  GL_DEPTH_COMPONENT24 = $81A6;
  GL_DEPTH_COMPONENT32 = $81A7;
  GL_MIRRORED_REPEAT = $8370;
  GL_FOG_COORDINATE_SOURCE = $8450;
  GL_FOG_COORDINATE = $8451;
  GL_FRAGMENT_DEPTH = $8452;
  GL_CURRENT_FOG_COORDINATE = $8453;
  GL_FOG_COORDINATE_ARRAY_TYPE = $8454;
  GL_FOG_COORDINATE_ARRAY_STRIDE = $8455;
  GL_FOG_COORDINATE_ARRAY_POINTER = $8456;
  GL_FOG_COORDINATE_ARRAY = $8457;
  GL_COLOR_SUM = $8458;
  GL_CURRENT_SECONDARY_COLOR = $8459;
  GL_SECONDARY_COLOR_ARRAY_SIZE = $845A;
  GL_SECONDARY_COLOR_ARRAY_TYPE = $845B;
  GL_SECONDARY_COLOR_ARRAY_STRIDE = $845C;
  GL_SECONDARY_COLOR_ARRAY_POINTER = $845D;
  GL_SECONDARY_COLOR_ARRAY = $845E;
  GL_MAX_TEXTURE_LOD_BIAS = $84FD;
  GL_TEXTURE_FILTER_CONTROL = $8500;
  GL_TEXTURE_LOD_BIAS = $8501;
  GL_INCR_WRAP = $8507;
  GL_DECR_WRAP = $8508;
  GL_TEXTURE_DEPTH_SIZE = $884A;
  GL_DEPTH_TEXTURE_MODE = $884B;
  GL_TEXTURE_COMPARE_MODE = $884C;
  GL_TEXTURE_COMPARE_FUNC = $884D;
  GL_COMPARE_R_TO_TEXTURE = $884E;

  // GL_VERSION_1_5
  GL_BUFFER_SIZE                    = $8764;
  GL_BUFFER_USAGE                   = $8765;
  GL_QUERY_COUNTER_BITS             = $8864;
  GL_CURRENT_QUERY                  = $8865;
  GL_QUERY_RESULT                   = $8866;
  GL_QUERY_RESULT_AVAILABLE         = $8867;
  GL_ARRAY_BUFFER                   = $8892;
  GL_ELEMENT_ARRAY_BUFFER           = $8893;
  GL_ARRAY_BUFFER_BINDING           = $8894;
  GL_ELEMENT_ARRAY_BUFFER_BINDING   = $8895;
  GL_VERTEX_ARRAY_BUFFER_BINDING    = $8896;
  GL_NORMAL_ARRAY_BUFFER_BINDING    = $8897;
  GL_COLOR_ARRAY_BUFFER_BINDING     = $8898;
  GL_INDEX_ARRAY_BUFFER_BINDING     = $8899;
  GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING = $889A;
  GL_EDGE_FLAG_ARRAY_BUFFER_BINDING = $889B;
  GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING = $889C;
  GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING = $889D;
  GL_WEIGHT_ARRAY_BUFFER_BINDING    = $889E;
  GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = $889F;
  GL_READ_ONLY                      = $88B8;
  GL_WRITE_ONLY                     = $88B9;
  GL_READ_WRITE                     = $88BA;
  GL_BUFFER_ACCESS                  = $88BB;
  GL_BUFFER_MAPPED                  = $88BC;
  GL_BUFFER_MAP_POINTER             = $88BD;
  GL_STREAM_DRAW                    = $88E0;
  GL_STREAM_READ                    = $88E1;
  GL_STREAM_COPY                    = $88E2;
  GL_STATIC_DRAW                    = $88E4;
  GL_STATIC_READ                    = $88E5;
  GL_STATIC_COPY                    = $88E6;
  GL_DYNAMIC_DRAW                   = $88E8;
  GL_DYNAMIC_READ                   = $88E9;
  GL_DYNAMIC_COPY                   = $88EA;
  GL_SAMPLES_PASSED                 = $8914;
  GL_FOG_COORD_SRC                  = GL_FOG_COORDINATE_SOURCE;
  GL_FOG_COORD                      = GL_FOG_COORDINATE;
  GL_CURRENT_FOG_COORD              = GL_CURRENT_FOG_COORDINATE;
  GL_FOG_COORD_ARRAY_TYPE           = GL_FOG_COORDINATE_ARRAY_TYPE;
  GL_FOG_COORD_ARRAY_STRIDE         = GL_FOG_COORDINATE_ARRAY_STRIDE;
  GL_FOG_COORD_ARRAY_POINTER        = GL_FOG_COORDINATE_ARRAY_POINTER;
  GL_FOG_COORD_ARRAY                = GL_FOG_COORDINATE_ARRAY;
  GL_FOG_COORD_ARRAY_BUFFER_BINDING = GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING;
  GL_SRC0_RGB                       = GL_SOURCE0_RGB;
  GL_SRC1_RGB                       = GL_SOURCE1_RGB;
  GL_SRC2_RGB                       = GL_SOURCE2_RGB;
  GL_SRC0_ALPHA                     = GL_SOURCE0_ALPHA;
  GL_SRC1_ALPHA                     = GL_SOURCE1_ALPHA;
  GL_SRC2_ALPHA                     = GL_SOURCE2_ALPHA;

  // GL_VERSION_2_0
  GL_BLEND_EQUATION_RGB             = $8009;
  GL_VERTEX_ATTRIB_ARRAY_ENABLED    = $8622;
  GL_VERTEX_ATTRIB_ARRAY_SIZE       = $8623;
  GL_VERTEX_ATTRIB_ARRAY_STRIDE     = $8624;
  GL_VERTEX_ATTRIB_ARRAY_TYPE       = $8625;
  GL_CURRENT_VERTEX_ATTRIB          = $8626;
  GL_VERTEX_PROGRAM_POINT_SIZE      = $8642;
  GL_VERTEX_PROGRAM_TWO_SIDE        = $8643;
  GL_VERTEX_ATTRIB_ARRAY_POINTER    = $8645;
  GL_STENCIL_BACK_FUNC              = $8800;
  GL_STENCIL_BACK_FAIL              = $8801;
  GL_STENCIL_BACK_PASS_DEPTH_FAIL   = $8802;
  GL_STENCIL_BACK_PASS_DEPTH_PASS   = $8803;
  GL_MAX_DRAW_BUFFERS               = $8824;
  GL_DRAW_BUFFER0                   = $8825;
  GL_DRAW_BUFFER1                   = $8826;
  GL_DRAW_BUFFER2                   = $8827;
  GL_DRAW_BUFFER3                   = $8828;
  GL_DRAW_BUFFER4                   = $8829;
  GL_DRAW_BUFFER5                   = $882A;
  GL_DRAW_BUFFER6                   = $882B;
  GL_DRAW_BUFFER7                   = $882C;
  GL_DRAW_BUFFER8                   = $882D;
  GL_DRAW_BUFFER9                   = $882E;
  GL_DRAW_BUFFER10                  = $882F;
  GL_DRAW_BUFFER11                  = $8830;
  GL_DRAW_BUFFER12                  = $8831;
  GL_DRAW_BUFFER13                  = $8832;
  GL_DRAW_BUFFER14                  = $8833;
  GL_DRAW_BUFFER15                  = $8834;
  GL_BLEND_EQUATION_ALPHA           = $883D;
  GL_POINT_SPRITE                   = $8861;
  GL_COORD_REPLACE                  = $8862;
  GL_MAX_VERTEX_ATTRIBS             = $8869;
  GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = $886A;
  GL_MAX_TEXTURE_COORDS             = $8871;
  GL_MAX_TEXTURE_IMAGE_UNITS        = $8872;
  GL_FRAGMENT_SHADER                = $8B30;
  GL_VERTEX_SHADER                  = $8B31;
  GL_MAX_FRAGMENT_UNIFORM_COMPONENTS = $8B49;
  GL_MAX_VERTEX_UNIFORM_COMPONENTS  = $8B4A;
  GL_MAX_VARYING_FLOATS             = $8B4B;
  GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = $8B4C;
  GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = $8B4D;
  GL_SHADER_TYPE                    = $8B4F;
  GL_FLOAT_VEC2                     = $8B50;
  GL_FLOAT_VEC3                     = $8B51;
  GL_FLOAT_VEC4                     = $8B52;
  GL_INT_VEC2                       = $8B53;
  GL_INT_VEC3                       = $8B54;
  GL_INT_VEC4                       = $8B55;
  GL_BOOL                           = $8B56;
  GL_BOOL_VEC2                      = $8B57;
  GL_BOOL_VEC3                      = $8B58;
  GL_BOOL_VEC4                      = $8B59;
  GL_FLOAT_MAT2                     = $8B5A;
  GL_FLOAT_MAT3                     = $8B5B;
  GL_FLOAT_MAT4                     = $8B5C;
  GL_SAMPLER_1D                     = $8B5D;
  GL_SAMPLER_2D                     = $8B5E;
  GL_SAMPLER_3D                     = $8B5F;
  GL_SAMPLER_CUBE                   = $8B60;
  GL_SAMPLER_1D_SHADOW              = $8B61;
  GL_SAMPLER_2D_SHADOW              = $8B62;
  GL_DELETE_STATUS                  = $8B80;
  GL_COMPILE_STATUS                 = $8B81;
  GL_LINK_STATUS                    = $8B82;
  GL_VALIDATE_STATUS                = $8B83;
  GL_INFO_LOG_LENGTH                = $8B84;
  GL_ATTACHED_SHADERS               = $8B85;
  GL_ACTIVE_UNIFORMS                = $8B86;
  GL_ACTIVE_UNIFORM_MAX_LENGTH      = $8B87;
  GL_SHADER_SOURCE_LENGTH           = $8B88;
  GL_ACTIVE_ATTRIBUTES              = $8B89;
  GL_ACTIVE_ATTRIBUTE_MAX_LENGTH    = $8B8A;
  GL_FRAGMENT_SHADER_DERIVATIVE_HINT = $8B8B;
  GL_SHADING_LANGUAGE_VERSION       = $8B8C;
  GL_CURRENT_PROGRAM                = $8B8D;
  GL_POINT_SPRITE_COORD_ORIGIN      = $8CA0;
  GL_LOWER_LEFT                     = $8CA1;
  GL_UPPER_LEFT                     = $8CA2;
  GL_STENCIL_BACK_REF               = $8CA3;
  GL_STENCIL_BACK_VALUE_MASK        = $8CA4;
  GL_STENCIL_BACK_WRITEMASK         = $8CA5;

  // GL_3DFX_multisample
  GL_MULTISAMPLE_3DFX = $86B2;
  GL_SAMPLE_BUFFERS_3DFX = $86B3;
  GL_SAMPLES_3DFX = $86B4;
  GL_MULTISAMPLE_BIT_3DFX = $20000000;

  // GL_3DFX_texture_compression_FXT1
  GL_COMPRESSED_RGB_FXT1_3DFX = $86B0;
  GL_COMPRESSED_RGBA_FXT1_3DFX = $86B1;

  // GL_APPLE_client_storage
  GL_UNPACK_CLIENT_STORAGE_APPLE = $85B2;

  // GL_APPLE_element_array
  GL_ELEMENT_ARRAY_APPLE = $8768;
  GL_ELEMENT_ARRAY_TYPE_APPLE = $8769;
  GL_ELEMENT_ARRAY_POINTER_APPLE = $876A;

  // GL_APPLE_fence
  GL_DRAW_PIXELS_APPLE = $8A0A;
  GL_FENCE_APPLE = $8A0B;

  // GL_APPLE_specular_vector
  GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE = $85B0;

  // GL_APPLE_transform_hint
  GL_TRANSFORM_HINT_APPLE = $85B1;

  // GL_APPLE_vertex_array_object
  GL_VERTEX_ARRAY_BINDING_APPLE = $85B5;

  // GL_APPLE_vertex_array_range
  GL_VERTEX_ARRAY_RANGE_APPLE = $851D;
  GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE = $851E;
  GL_VERTEX_ARRAY_STORAGE_HINT_APPLE = $851F;
  GL_VERTEX_ARRAY_RANGE_POINTER_APPLE = $8521;
  GL_STORAGE_CACHED_APPLE = $85BE;
  GL_STORAGE_SHARED_APPLE = $85BF;

  // GL_APPLE_ycbcr_422
  GL_YCBCR_422_APPLE = $85B9;
  GL_UNSIGNED_SHORT_8_8_APPLE = $85BA;
  GL_UNSIGNED_SHORT_8_8_REV_APPLE = $85BB;

  // GL_ARB_depth_texture
  GL_DEPTH_COMPONENT16_ARB = $81A5;
  GL_DEPTH_COMPONENT24_ARB = $81A6;
  GL_DEPTH_COMPONENT32_ARB = $81A7;
  GL_TEXTURE_DEPTH_SIZE_ARB = $884A;
  GL_DEPTH_TEXTURE_MODE_ARB = $884B;

  // GL_ARB_fragment_program
  GL_FRAGMENT_PROGRAM_ARB = $8804;
  GL_PROGRAM_ALU_INSTRUCTIONS_ARB = $8805;
  GL_PROGRAM_TEX_INSTRUCTIONS_ARB = $8806;
  GL_PROGRAM_TEX_INDIRECTIONS_ARB = $8807;
  GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB = $8808;
  GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB = $8809;
  GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB = $880A;
  GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB = $880B;
  GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB = $880C;
  GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB = $880D;
  GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB = $880E;
  GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB = $880F;
  GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB = $8810;
  GL_MAX_TEXTURE_COORDS_ARB = $8871;
  GL_MAX_TEXTURE_IMAGE_UNITS_ARB = $8872;

  // GL_ARB_imaging
  GL_CONSTANT_COLOR_ARB = $8001;
  GL_ONE_MINUS_CONSTANT_COLOR = $8002;
  GL_CONSTANT_ALPHA = $8003;
  GL_ONE_MINUS_CONSTANT_ALPHA = $8004;
  GL_BLEND_COLOR = $8005;
  GL_FUNC_ADD = $8006;
  GL_MIN = $8007;
  GL_MAX = $8008;
  GL_BLEND_EQUATION = $8009;
  GL_FUNC_SUBTRACT = $800A;
  GL_FUNC_REVERSE_SUBTRACT = $800B;
  GL_CONVOLUTION_1D = $8010;
  GL_CONVOLUTION_2D = $8011;
  GL_SEPARABLE_2D = $8012;
  GL_CONVOLUTION_BORDER_MODE = $8013;
  GL_CONVOLUTION_FILTER_SCALE = $8014;
  GL_CONVOLUTION_FILTER_BIAS = $8015;
  GL_REDUCE = $8016;
  GL_CONVOLUTION_FORMAT = $8017;
  GL_CONVOLUTION_WIDTH = $8018;
  GL_CONVOLUTION_HEIGHT = $8019;
  GL_MAX_CONVOLUTION_WIDTH = $801A;
  GL_MAX_CONVOLUTION_HEIGHT = $801B;
  GL_POST_CONVOLUTION_RED_SCALE = $801C;
  GL_POST_CONVOLUTION_GREEN_SCALE = $801D;
  GL_POST_CONVOLUTION_BLUE_SCALE = $801E;
  GL_POST_CONVOLUTION_ALPHA_SCALE = $801F;
  GL_POST_CONVOLUTION_RED_BIAS = $8020;
  GL_POST_CONVOLUTION_GREEN_BIAS = $8021;
  GL_POST_CONVOLUTION_BLUE_BIAS = $8022;
  GL_POST_CONVOLUTION_ALPHA_BIAS = $8023;
  GL_HISTOGRAM = $8024;
  GL_PROXY_HISTOGRAM = $8025;
  GL_HISTOGRAM_WIDTH = $8026;
  GL_HISTOGRAM_FORMAT = $8027;
  GL_HISTOGRAM_RED_SIZE = $8028;
  GL_HISTOGRAM_GREEN_SIZE = $8029;
  GL_HISTOGRAM_BLUE_SIZE = $802A;
  GL_HISTOGRAM_ALPHA_SIZE = $802B;
  GL_HISTOGRAM_LUMINANCE_SIZE = $802C;
  GL_HISTOGRAM_SINK = $802D;
  GL_MINMAX = $802E;
  GL_MINMAX_FORMAT = $802F;
  GL_MINMAX_SINK = $8030;
  GL_TABLE_TOO_LARGE = $8031;
  GL_COLOR_MATRIX = $80B1;
  GL_COLOR_MATRIX_STACK_DEPTH = $80B2;
  GL_MAX_COLOR_MATRIX_STACK_DEPTH = $80B3;
  GL_POST_COLOR_MATRIX_RED_SCALE = $80B4;
  GL_POST_COLOR_MATRIX_GREEN_SCALE = $80B5;
  GL_POST_COLOR_MATRIX_BLUE_SCALE = $80B6;
  GL_POST_COLOR_MATRIX_ALPHA_SCALE = $80B7;
  GL_POST_COLOR_MATRIX_RED_BIAS = $80B8;
  GL_POST_COLOR_MATRIX_GREEN_BIAS = $80B9;
  GL_POST_COLOR_MATRIX_BLUE_BIAS = $80BA;
  GL_POST_COLOR_MATRIX_ALPHA_BIAS = $80BB;
  GL_COLOR_TABLE = $80D0;
  GL_POST_CONVOLUTION_COLOR_TABLE = $80D1;
  GL_POST_COLOR_MATRIX_COLOR_TABLE = $80D2;
  GL_PROXY_COLOR_TABLE = $80D3;
  GL_PROXY_POST_CONVOLUTION_COLOR_TABLE = $80D4;
  GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE = $80D5;
  GL_COLOR_TABLE_SCALE = $80D6;
  GL_COLOR_TABLE_BIAS = $80D7;
  GL_COLOR_TABLE_FORMAT = $80D8;
  GL_COLOR_TABLE_WIDTH = $80D9;
  GL_COLOR_TABLE_RED_SIZE = $80DA;
  GL_COLOR_TABLE_GREEN_SIZE = $80DB;
  GL_COLOR_TABLE_BLUE_SIZE = $80DC;
  GL_COLOR_TABLE_ALPHA_SIZE = $80DD;
  GL_COLOR_TABLE_LUMINANCE_SIZE = $80DE;
  GL_COLOR_TABLE_INTENSITY_SIZE = $80DF;
  GL_CONSTANT_BORDER = $8151;
  GL_REPLICATE_BORDER = $8153;
  GL_CONVOLUTION_BORDER_COLOR = $8154;

  // GL_ARB_matrix_palette
  GL_MATRIX_PALETTE_ARB = $8840;
  GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB = $8841;
  GL_MAX_PALETTE_MATRICES_ARB = $8842;
  GL_CURRENT_PALETTE_MATRIX_ARB = $8843;
  GL_MATRIX_INDEX_ARRAY_ARB = $8844;
  GL_CURRENT_MATRIX_INDEX_ARB = $8845;
  GL_MATRIX_INDEX_ARRAY_SIZE_ARB = $8846;
  GL_MATRIX_INDEX_ARRAY_TYPE_ARB = $8847;
  GL_MATRIX_INDEX_ARRAY_STRIDE_ARB = $8848;
  GL_MATRIX_INDEX_ARRAY_POINTER_ARB = $8849;

  // GL_ARB_multisample
  GL_MULTISAMPLE_ARB = $809D;
  GL_SAMPLE_ALPHA_TO_COVERAGE_ARB = $809E;
  GL_SAMPLE_ALPHA_TO_ONE_ARB = $809F;
  GL_SAMPLE_COVERAGE_ARB = $80A0;
  GL_SAMPLE_BUFFERS_ARB = $80A8;
  GL_SAMPLES_ARB = $80A9;
  GL_SAMPLE_COVERAGE_VALUE_ARB = $80AA;
  GL_SAMPLE_COVERAGE_INVERT_ARB = $80AB;
  GL_MULTISAMPLE_BIT_ARB = $20000000;

  // GL_ARB_multitexture
  GL_TEXTURE0_ARB = $84C0;
  GL_TEXTURE1_ARB = $84C1;
  GL_TEXTURE2_ARB = $84C2;
  GL_TEXTURE3_ARB = $84C3;
  GL_TEXTURE4_ARB = $84C4;
  GL_TEXTURE5_ARB = $84C5;
  GL_TEXTURE6_ARB = $84C6;
  GL_TEXTURE7_ARB = $84C7;
  GL_TEXTURE8_ARB = $84C8;
  GL_TEXTURE9_ARB = $84C9;
  GL_TEXTURE10_ARB = $84CA;
  GL_TEXTURE11_ARB = $84CB;
  GL_TEXTURE12_ARB = $84CC;
  GL_TEXTURE13_ARB = $84CD;
  GL_TEXTURE14_ARB = $84CE;
  GL_TEXTURE15_ARB = $84CF;
  GL_TEXTURE16_ARB = $84D0;
  GL_TEXTURE17_ARB = $84D1;
  GL_TEXTURE18_ARB = $84D2;
  GL_TEXTURE19_ARB = $84D3;
  GL_TEXTURE20_ARB = $84D4;
  GL_TEXTURE21_ARB = $84D5;
  GL_TEXTURE22_ARB = $84D6;
  GL_TEXTURE23_ARB = $84D7;
  GL_TEXTURE24_ARB = $84D8;
  GL_TEXTURE25_ARB = $84D9;
  GL_TEXTURE26_ARB = $84DA;
  GL_TEXTURE27_ARB = $84DB;
  GL_TEXTURE28_ARB = $84DC;
  GL_TEXTURE29_ARB = $84DD;
  GL_TEXTURE30_ARB = $84DE;
  GL_TEXTURE31_ARB = $84DF;
  GL_ACTIVE_TEXTURE_ARB = $84E0;
  GL_CLIENT_ACTIVE_TEXTURE_ARB = $84E1;
  GL_MAX_TEXTURE_UNITS_ARB = $84E2;

  // GL_ARB_point_parameters
  GL_POINT_SIZE_MIN_ARB = $8126;
  GL_POINT_SIZE_MAX_ARB = $8127;
  GL_POINT_FADE_THRESHOLD_SIZE_ARB = $8128;
  GL_POINT_DISTANCE_ATTENUATION_ARB = $8129;

  // GL_ARB_shadow
  GL_TEXTURE_COMPARE_MODE_ARB = $884C;
  GL_TEXTURE_COMPARE_FUNC_ARB = $884D;
  GL_COMPARE_R_TO_TEXTURE_ARB = $884E;

  // GL_ARB_shadow_ambient
  GL_TEXTURE_COMPARE_FAIL_VALUE_ARB = $80BF;

  // GL_ARB_texture_border_clamp
  GL_CLAMP_TO_BORDER_ARB = $812D;

  // GL_ARB_texture_compression
  GL_COMPRESSED_ALPHA_ARB = $84E9;
  GL_COMPRESSED_LUMINANCE_ARB = $84EA;
  GL_COMPRESSED_LUMINANCE_ALPHA_ARB = $84EB;
  GL_COMPRESSED_INTENSITY_ARB = $84EC;
  GL_COMPRESSED_RGB_ARB = $84ED;
  GL_COMPRESSED_RGBA_ARB = $84EE;
  GL_TEXTURE_COMPRESSION_HINT_ARB = $84EF;
  GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB = $86A0;
  GL_TEXTURE_COMPRESSED_ARB = $86A1;
  GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB = $86A2;
  GL_COMPRESSED_TEXTURE_FORMATS_ARB = $86A3;

  // GL_ARB_texture_cube_map
  GL_NORMAL_MAP_ARB = $8511;
  GL_REFLECTION_MAP_ARB = $8512;
  GL_TEXTURE_CUBE_MAP_ARB = $8513;
  GL_TEXTURE_BINDING_CUBE_MAP_ARB = $8514;
  GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB = $8515;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB = $8516;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB = $8517;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB = $8518;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB = $8519;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB = $851A;
  GL_PROXY_TEXTURE_CUBE_MAP_ARB = $851B;
  GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB = $851C;

  // GL_ARB_texture_env_combine
  GL_COMBINE_ARB = $8570;
  GL_COMBINE_RGB_ARB = $8571;
  GL_COMBINE_ALPHA_ARB = $8572;
  GL_SOURCE0_RGB_ARB = $8580;
  GL_SOURCE1_RGB_ARB = $8581;
  GL_SOURCE2_RGB_ARB = $8582;
  GL_SOURCE0_ALPHA_ARB = $8588;
  GL_SOURCE1_ALPHA_ARB = $8589;
  GL_SOURCE2_ALPHA_ARB = $858A;
  GL_OPERAND0_RGB_ARB = $8590;
  GL_OPERAND1_RGB_ARB = $8591;
  GL_OPERAND2_RGB_ARB = $8592;
  GL_OPERAND0_ALPHA_ARB = $8598;
  GL_OPERAND1_ALPHA_ARB = $8599;
  GL_OPERAND2_ALPHA_ARB = $859A;
  GL_RGB_SCALE_ARB = $8573;
  GL_ADD_SIGNED_ARB = $8574;
  GL_INTERPOLATE_ARB = $8575;
  GL_SUBTRACT_ARB = $84E7;
  GL_CONSTANT_ARB = $8576;
  GL_PRIMARY_COLOR_ARB = $8577;
  GL_PREVIOUS_ARB = $8578;

  // GL_ARB_texture_env_dot3
  GL_DOT3_RGB_ARB = $86AE;
  GL_DOT3_RGBA_ARB = $86AF;

  // GL_ARB_texture_mirrored_repeat
  GL_MIRRORED_REPEAT_ARB = $8370;

  // GL_ARB_transpose_matrix
  GL_TRANSPOSE_MODELVIEW_MATRIX_ARB = $84E3;
  GL_TRANSPOSE_PROJECTION_MATRIX_ARB = $84E4;
  GL_TRANSPOSE_TEXTURE_MATRIX_ARB = $84E5;
  GL_TRANSPOSE_COLOR_MATRIX_ARB = $84E6;

  // GL_ARB_vertex_blend
  GL_MAX_VERTEX_UNITS_ARB = $86A4;
  GL_ACTIVE_VERTEX_UNITS_ARB = $86A5;
  GL_WEIGHT_SUM_UNITY_ARB = $86A6;
  GL_VERTEX_BLEND_ARB = $86A7;
  GL_CURRENT_WEIGHT_ARB = $86A8;
  GL_WEIGHT_ARRAY_TYPE_ARB = $86A9;
  GL_WEIGHT_ARRAY_STRIDE_ARB = $86AA;
  GL_WEIGHT_ARRAY_SIZE_ARB = $86AB;
  GL_WEIGHT_ARRAY_POINTER_ARB = $86AC;
  GL_WEIGHT_ARRAY_ARB = $86AD;
  GL_MODELVIEW0_ARB = $1700;
  GL_MODELVIEW1_ARB = $850A;
  GL_MODELVIEW2_ARB = $8722;
  GL_MODELVIEW3_ARB = $8723;
  GL_MODELVIEW4_ARB = $8724;
  GL_MODELVIEW5_ARB = $8725;
  GL_MODELVIEW6_ARB = $8726;
  GL_MODELVIEW7_ARB = $8727;
  GL_MODELVIEW8_ARB = $8728;
  GL_MODELVIEW9_ARB = $8729;
  GL_MODELVIEW10_ARB = $872A;
  GL_MODELVIEW11_ARB = $872B;
  GL_MODELVIEW12_ARB = $872C;
  GL_MODELVIEW13_ARB = $872D;
  GL_MODELVIEW14_ARB = $872E;
  GL_MODELVIEW15_ARB = $872F;
  GL_MODELVIEW16_ARB = $8730;
  GL_MODELVIEW17_ARB = $8731;
  GL_MODELVIEW18_ARB = $8732;
  GL_MODELVIEW19_ARB = $8733;
  GL_MODELVIEW20_ARB = $8734;
  GL_MODELVIEW21_ARB = $8735;
  GL_MODELVIEW22_ARB = $8736;
  GL_MODELVIEW23_ARB = $8737;
  GL_MODELVIEW24_ARB = $8738;
  GL_MODELVIEW25_ARB = $8739;
  GL_MODELVIEW26_ARB = $873A;
  GL_MODELVIEW27_ARB = $873B;
  GL_MODELVIEW28_ARB = $873C;
  GL_MODELVIEW29_ARB = $873D;
  GL_MODELVIEW30_ARB = $873E;
  GL_MODELVIEW31_ARB = $873F;

  // GL_ARB_vertex_buffer_object
  GL_BUFFER_SIZE_ARB = $8764;
  GL_BUFFER_USAGE_ARB = $8765;
  GL_ARRAY_BUFFER_ARB = $8892;
  GL_ELEMENT_ARRAY_BUFFER_ARB = $8893;
  GL_ARRAY_BUFFER_BINDING_ARB = $8894;
  GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB = $8895;
  GL_VERTEX_ARRAY_BUFFER_BINDING_ARB = $8896;
  GL_NORMAL_ARRAY_BUFFER_BINDING_ARB = $8897;
  GL_COLOR_ARRAY_BUFFER_BINDING_ARB = $8898;
  GL_INDEX_ARRAY_BUFFER_BINDING_ARB = $8899;
  GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB = $889A;
  GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB = $889B;
  GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB = $889C;
  GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB = $889D;
  GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB = $889E;
  GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB = $889F;
  GL_READ_ONLY_ARB = $88B8;
  GL_WRITE_ONLY_ARB = $88B9;
  GL_READ_WRITE_ARB = $88BA;
  GL_BUFFER_ACCESS_ARB = $88BB;
  GL_BUFFER_MAPPED_ARB = $88BC;
  GL_BUFFER_MAP_POINTER_ARB = $88BD;
  GL_STREAM_DRAW_ARB = $88E0;
  GL_STREAM_READ_ARB = $88E1;
  GL_STREAM_COPY_ARB = $88E2;
  GL_STATIC_DRAW_ARB = $88E4;
  GL_STATIC_READ_ARB = $88E5;
  GL_STATIC_COPY_ARB = $88E6;
  GL_DYNAMIC_DRAW_ARB = $88E8;
  GL_DYNAMIC_READ_ARB = $88E9;
  GL_DYNAMIC_COPY_ARB = $88EA;

  // GL_ARB_vertex_program
  GL_COLOR_SUM_ARB = $8458;
  GL_VERTEX_PROGRAM_ARB = $8620;
  GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB = $8622;
  GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB = $8623;
  GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB = $8624;
  GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB = $8625;
  GL_CURRENT_VERTEX_ATTRIB_ARB = $8626;
  GL_PROGRAM_LENGTH_ARB = $8627;
  GL_PROGRAM_STRING_ARB = $8628;
  GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB = $862E;
  GL_MAX_PROGRAM_MATRICES_ARB = $862F;
  GL_CURRENT_MATRIX_STACK_DEPTH_ARB = $8640;
  GL_CURRENT_MATRIX_ARB = $8641;
  GL_VERTEX_PROGRAM_POINT_SIZE_ARB = $8642;
  GL_VERTEX_PROGRAM_TWO_SIDE_ARB = $8643;
  GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB = $8645;
  GL_PROGRAM_ERROR_POSITION_ARB = $864B;
  GL_PROGRAM_BINDING_ARB = $8677;
  GL_MAX_VERTEX_ATTRIBS_ARB = $8869;
  GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB = $886A;
  GL_PROGRAM_ERROR_STRING_ARB = $8874;
  GL_PROGRAM_FORMAT_ASCII_ARB = $8875;
  GL_PROGRAM_FORMAT_ARB = $8876;
  GL_PROGRAM_INSTRUCTIONS_ARB = $88A0;
  GL_MAX_PROGRAM_INSTRUCTIONS_ARB = $88A1;
  GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB = $88A2;
  GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB = $88A3;
  GL_PROGRAM_TEMPORARIES_ARB = $88A4;
  GL_MAX_PROGRAM_TEMPORARIES_ARB = $88A5;
  GL_PROGRAM_NATIVE_TEMPORARIES_ARB = $88A6;
  GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB = $88A7;
  GL_PROGRAM_PARAMETERS_ARB = $88A8;
  GL_MAX_PROGRAM_PARAMETERS_ARB = $88A9;
  GL_PROGRAM_NATIVE_PARAMETERS_ARB = $88AA;
  GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB = $88AB;
  GL_PROGRAM_ATTRIBS_ARB = $88AC;
  GL_MAX_PROGRAM_ATTRIBS_ARB = $88AD;
  GL_PROGRAM_NATIVE_ATTRIBS_ARB = $88AE;
  GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB = $88AF;
  GL_PROGRAM_ADDRESS_REGISTERS_ARB = $88B0;
  GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB = $88B1;
  GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB = $88B2;
  GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB = $88B3;
  GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB = $88B4;
  GL_MAX_PROGRAM_ENV_PARAMETERS_ARB = $88B5;
  GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB = $88B6;
  GL_TRANSPOSE_CURRENT_MATRIX_ARB = $88B7;
  GL_MATRIX0_ARB = $88C0;
  GL_MATRIX1_ARB = $88C1;
  GL_MATRIX2_ARB = $88C2;
  GL_MATRIX3_ARB = $88C3;
  GL_MATRIX4_ARB = $88C4;
  GL_MATRIX5_ARB = $88C5;
  GL_MATRIX6_ARB = $88C6;
  GL_MATRIX7_ARB = $88C7;
  GL_MATRIX8_ARB = $88C8;
  GL_MATRIX9_ARB = $88C9;
  GL_MATRIX10_ARB = $88CA;
  GL_MATRIX11_ARB = $88CB;
  GL_MATRIX12_ARB = $88CC;
  GL_MATRIX13_ARB = $88CD;
  GL_MATRIX14_ARB = $88CE;
  GL_MATRIX15_ARB = $88CF;
  GL_MATRIX16_ARB = $88D0;
  GL_MATRIX17_ARB = $88D1;
  GL_MATRIX18_ARB = $88D2;
  GL_MATRIX19_ARB = $88D3;
  GL_MATRIX20_ARB = $88D4;
  GL_MATRIX21_ARB = $88D5;
  GL_MATRIX22_ARB = $88D6;
  GL_MATRIX23_ARB = $88D7;
  GL_MATRIX24_ARB = $88D8;
  GL_MATRIX25_ARB = $88D9;
  GL_MATRIX26_ARB = $88DA;
  GL_MATRIX27_ARB = $88DB;
  GL_MATRIX28_ARB = $88DC;
  GL_MATRIX29_ARB = $88DD;
  GL_MATRIX30_ARB = $88DE;
  GL_MATRIX31_ARB = $88DF;

  // GL_ARB_draw_buffers
  GL_MAX_DRAW_BUFFERS_ARB = $8824;
  GL_DRAW_BUFFER0_ARB = $8825;
  GL_DRAW_BUFFER1_ARB = $8826;
  GL_DRAW_BUFFER2_ARB = $8827;
  GL_DRAW_BUFFER3_ARB = $8828;
  GL_DRAW_BUFFER4_ARB = $8829;
  GL_DRAW_BUFFER5_ARB = $882A;
  GL_DRAW_BUFFER6_ARB = $882B;
  GL_DRAW_BUFFER7_ARB = $882C;
  GL_DRAW_BUFFER8_ARB = $882D;
  GL_DRAW_BUFFER9_ARB = $882E;
  GL_DRAW_BUFFER10_ARB = $882F;
  GL_DRAW_BUFFER11_ARB = $8830;
  GL_DRAW_BUFFER12_ARB = $8831;
  GL_DRAW_BUFFER13_ARB = $8832;
  GL_DRAW_BUFFER14_ARB = $8833;
  GL_DRAW_BUFFER15_ARB = $8834;

  // GL_ARB_texture_rectangle
  GL_TEXTURE_RECTANGLE_ARB = $84F5;
  GL_TEXTURE_BINDING_RECTANGLE_ARB = $84F6;
  GL_PROXY_TEXTURE_RECTANGLE_ARB = $84F7;
  GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB = $84F8;

  // GL_ARB_color_buffer_float
  GL_RGBA_FLOAT_MODE_ARB = $8820;
  GL_CLAMP_VERTEX_COLOR_ARB = $891A;
  GL_CLAMP_FRAGMENT_COLOR_ARB = $891B;
  GL_CLAMP_READ_COLOR_ARB = $891C;
  GL_FIXED_ONLY_ARB = $891D;
  WGL_TYPE_RGBA_FLOAT_ARB = $21A0;
  GLX_RGBA_FLOAT_TYPE = $20B9;
  GLX_RGBA_FLOAT_BIT = $00000004;

  // GL_ARB_half_float_pixel
  GL_HALF_FLOAT_ARB = $140B;

  // GL_ARB_texture_float
  GL_TEXTURE_RED_TYPE_ARB = $8C10;
  GL_TEXTURE_GREEN_TYPE_ARB = $8C11;
  GL_TEXTURE_BLUE_TYPE_ARB = $8C12;
  GL_TEXTURE_ALPHA_TYPE_ARB = $8C13;
  GL_TEXTURE_LUMINANCE_TYPE_ARB = $8C14;
  GL_TEXTURE_INTENSITY_TYPE_ARB = $8C15;
  GL_TEXTURE_DEPTH_TYPE_ARB = $8C16;
  GL_UNSIGNED_NORMALIZED_ARB = $8C17;
  GL_RGBA32F_ARB = $8814;
  GL_RGB32F_ARB = $8815;
  GL_ALPHA32F_ARB = $8816;
  GL_INTENSITY32F_ARB = $8817;
  GL_LUMINANCE32F_ARB = $8818;
  GL_LUMINANCE_ALPHA32F_ARB = $8819;
  GL_RGBA16F_ARB = $881A;
  GL_RGB16F_ARB = $881B;
  GL_ALPHA16F_ARB = $881C;
  GL_INTENSITY16F_ARB = $881D;
  GL_LUMINANCE16F_ARB = $881E;
  GL_LUMINANCE_ALPHA16F_ARB = $881F;

  // GL_ARB_pixel_buffer_object
  GL_PIXEL_PACK_BUFFER_ARB = $88EB;
  GL_PIXEL_UNPACK_BUFFER_ARB = $88EC;
  GL_PIXEL_PACK_BUFFER_BINDING_ARB = $88ED;
  GL_PIXEL_UNPACK_BUFFER_BINDING_ARB = $88EF;

  // GL_ATI_draw_buffers
  GL_MAX_DRAW_BUFFERS_ATI = $8824;
  GL_DRAW_BUFFER0_ATI = $8825;
  GL_DRAW_BUFFER1_ATI = $8826;
  GL_DRAW_BUFFER2_ATI = $8827;
  GL_DRAW_BUFFER3_ATI = $8828;
  GL_DRAW_BUFFER4_ATI = $8829;
  GL_DRAW_BUFFER5_ATI = $882A;
  GL_DRAW_BUFFER6_ATI = $882B;
  GL_DRAW_BUFFER7_ATI = $882C;
  GL_DRAW_BUFFER8_ATI = $882D;
  GL_DRAW_BUFFER9_ATI = $882E;
  GL_DRAW_BUFFER10_ATI = $882F;
  GL_DRAW_BUFFER11_ATI = $8830;
  GL_DRAW_BUFFER12_ATI = $8831;
  GL_DRAW_BUFFER13_ATI = $8832;
  GL_DRAW_BUFFER14_ATI = $8833;
  GL_DRAW_BUFFER15_ATI = $8834;

  // GL_ATI_element_array
  GL_ELEMENT_ARRAY_ATI = $8768;
  GL_ELEMENT_ARRAY_TYPE_ATI = $8769;
  GL_ELEMENT_ARRAY_POINTER_ATI = $876A;

  // GL_ATI_envmap_bumpmap
  GL_BUMP_ROT_MATRIX_ATI = $8775;
  GL_BUMP_ROT_MATRIX_SIZE_ATI = $8776;
  GL_BUMP_NUM_TEX_UNITS_ATI = $8777;
  GL_BUMP_TEX_UNITS_ATI = $8778;
  GL_DUDV_ATI = $8779;
  GL_DU8DV8_ATI = $877A;
  GL_BUMP_ENVMAP_ATI = $877B;
  GL_BUMP_TARGET_ATI = $877C;

  // GL_ATI_fragment_shader
  GL_FRAGMENT_SHADER_ATI = $8920;
  GL_REG_0_ATI = $8921;
  GL_REG_1_ATI = $8922;
  GL_REG_2_ATI = $8923;
  GL_REG_3_ATI = $8924;
  GL_REG_4_ATI = $8925;
  GL_REG_5_ATI = $8926;
  GL_REG_6_ATI = $8927;
  GL_REG_7_ATI = $8928;
  GL_REG_8_ATI = $8929;
  GL_REG_9_ATI = $892A;
  GL_REG_10_ATI = $892B;
  GL_REG_11_ATI = $892C;
  GL_REG_12_ATI = $892D;
  GL_REG_13_ATI = $892E;
  GL_REG_14_ATI = $892F;
  GL_REG_15_ATI = $8930;
  GL_REG_16_ATI = $8931;
  GL_REG_17_ATI = $8932;
  GL_REG_18_ATI = $8933;
  GL_REG_19_ATI = $8934;
  GL_REG_20_ATI = $8935;
  GL_REG_21_ATI = $8936;
  GL_REG_22_ATI = $8937;
  GL_REG_23_ATI = $8938;
  GL_REG_24_ATI = $8939;
  GL_REG_25_ATI = $893A;
  GL_REG_26_ATI = $893B;
  GL_REG_27_ATI = $893C;
  GL_REG_28_ATI = $893D;
  GL_REG_29_ATI = $893E;
  GL_REG_30_ATI = $893F;
  GL_REG_31_ATI = $8940;
  GL_CON_0_ATI = $8941;
  GL_CON_1_ATI = $8942;
  GL_CON_2_ATI = $8943;
  GL_CON_3_ATI = $8944;
  GL_CON_4_ATI = $8945;
  GL_CON_5_ATI = $8946;
  GL_CON_6_ATI = $8947;
  GL_CON_7_ATI = $8948;
  GL_CON_8_ATI = $8949;
  GL_CON_9_ATI = $894A;
  GL_CON_10_ATI = $894B;
  GL_CON_11_ATI = $894C;
  GL_CON_12_ATI = $894D;
  GL_CON_13_ATI = $894E;
  GL_CON_14_ATI = $894F;
  GL_CON_15_ATI = $8950;
  GL_CON_16_ATI = $8951;
  GL_CON_17_ATI = $8952;
  GL_CON_18_ATI = $8953;
  GL_CON_19_ATI = $8954;
  GL_CON_20_ATI = $8955;
  GL_CON_21_ATI = $8956;
  GL_CON_22_ATI = $8957;
  GL_CON_23_ATI = $8958;
  GL_CON_24_ATI = $8959;
  GL_CON_25_ATI = $895A;
  GL_CON_26_ATI = $895B;
  GL_CON_27_ATI = $895C;
  GL_CON_28_ATI = $895D;
  GL_CON_29_ATI = $895E;
  GL_CON_30_ATI = $895F;
  GL_CON_31_ATI = $8960;
  GL_MOV_ATI = $8961;
  GL_ADD_ATI = $8963;
  GL_MUL_ATI = $8964;
  GL_SUB_ATI = $8965;
  GL_DOT3_ATI = $8966;
  GL_DOT4_ATI = $8967;
  GL_MAD_ATI = $8968;
  GL_LERP_ATI = $8969;
  GL_CND_ATI = $896A;
  GL_CND0_ATI = $896B;
  GL_DOT2_ADD_ATI = $896C;
  GL_SECONDARY_INTERPOLATOR_ATI = $896D;
  GL_NUM_FRAGMENT_REGISTERS_ATI = $896E;
  GL_NUM_FRAGMENT_CONSTANTS_ATI = $896F;
  GL_NUM_PASSES_ATI = $8970;
  GL_NUM_INSTRUCTIONS_PER_PASS_ATI = $8971;
  GL_NUM_INSTRUCTIONS_TOTAL_ATI = $8972;
  GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI = $8973;
  GL_NUM_LOOPBACK_COMPONENTS_ATI = $8974;
  GL_COLOR_ALPHA_PAIRING_ATI = $8975;
  GL_SWIZZLE_STR_ATI = $8976;
  GL_SWIZZLE_STQ_ATI = $8977;
  GL_SWIZZLE_STR_DR_ATI = $8978;
  GL_SWIZZLE_STQ_DQ_ATI = $8979;
  GL_SWIZZLE_STRQ_ATI = $897A;
  GL_SWIZZLE_STRQ_DQ_ATI = $897B;
  GL_RED_BIT_ATI = $00000001;
  GL_GREEN_BIT_ATI = $00000002;
  GL_BLUE_BIT_ATI = $00000004;
  GL_2X_BIT_ATI = $00000001;
  GL_4X_BIT_ATI = $00000002;
  GL_8X_BIT_ATI = $00000004;
  GL_HALF_BIT_ATI = $00000008;
  GL_QUARTER_BIT_ATI = $00000010;
  GL_EIGHTH_BIT_ATI = $00000020;
  GL_SATURATE_BIT_ATI = $00000040;
  GL_COMP_BIT_ATI = $00000002;
  GL_NEGATE_BIT_ATI = $00000004;
  GL_BIAS_BIT_ATI = $00000008;

  // GL_ATI_pn_triangles
  GL_PN_TRIANGLES_ATI = $87F0;
  GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI = $87F1;
  GL_PN_TRIANGLES_POINT_MODE_ATI = $87F2;
  GL_PN_TRIANGLES_NORMAL_MODE_ATI = $87F3;
  GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI = $87F4;
  GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI = $87F5;
  GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI = $87F6;
  GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI = $87F7;
  GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI = $87F8;

  // GL_ATI_separate_stencil
  GL_STENCIL_BACK_FUNC_ATI = $8800;
  GL_STENCIL_BACK_FAIL_ATI = $8801;
  GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI = $8802;
  GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI = $8803;

  // GL_ATI_text_fragment_shader
  GL_TEXT_FRAGMENT_SHADER_ATI = $8200;

  // GL_ATI_texture_env_combine3
  GL_MODULATE_ADD_ATI = $8744;
  GL_MODULATE_SIGNED_ADD_ATI = $8745;
  GL_MODULATE_SUBTRACT_ATI = $8746;

  // GL_ATI_texture_float
  GL_RGBA_FLOAT32_ATI = $8814;
  GL_RGB_FLOAT32_ATI = $8815;
  GL_ALPHA_FLOAT32_ATI = $8816;
  GL_INTENSITY_FLOAT32_ATI = $8817;
  GL_LUMINANCE_FLOAT32_ATI = $8818;
  GL_LUMINANCE_ALPHA_FLOAT32_ATI = $8819;
  GL_RGBA_FLOAT16_ATI = $881A;
  GL_RGB_FLOAT16_ATI = $881B;
  GL_ALPHA_FLOAT16_ATI = $881C;
  GL_INTENSITY_FLOAT16_ATI = $881D;
  GL_LUMINANCE_FLOAT16_ATI = $881E;
  GL_LUMINANCE_ALPHA_FLOAT16_ATI = $881F;

  // GL_ATI_texture_mirror_once
  GL_MIRROR_CLAMP_ATI = $8742;
  GL_MIRROR_CLAMP_TO_EDGE_ATI = $8743;

  // GL_ATI_vertex_array_object
  GL_STATIC_ATI = $8760;
  GL_DYNAMIC_ATI = $8761;
  GL_PRESERVE_ATI = $8762;
  GL_DISCARD_ATI = $8763;
  GL_OBJECT_BUFFER_SIZE_ATI = $8764;
  GL_OBJECT_BUFFER_USAGE_ATI = $8765;
  GL_ARRAY_OBJECT_BUFFER_ATI = $8766;
  GL_ARRAY_OBJECT_OFFSET_ATI = $8767;

  // GL_ATI_vertex_streams
  GL_MAX_VERTEX_STREAMS_ATI = $876B;
  GL_VERTEX_STREAM0_ATI = $876C;
  GL_VERTEX_STREAM1_ATI = $876D;
  GL_VERTEX_STREAM2_ATI = $876E;
  GL_VERTEX_STREAM3_ATI = $876F;
  GL_VERTEX_STREAM4_ATI = $8770;
  GL_VERTEX_STREAM5_ATI = $8771;
  GL_VERTEX_STREAM6_ATI = $8772;
  GL_VERTEX_STREAM7_ATI = $8773;
  GL_VERTEX_SOURCE_ATI = $8774;

  // GL_EXT_422_pixels
  GL_422_EXT = $80CC;
  GL_422_REV_EXT = $80CD;
  GL_422_AVERAGE_EXT = $80CE;
  GL_422_REV_AVERAGE_EXT = $80CF;

  // GL_EXT_abgr
  GL_ABGR_EXT = $8000;

  // GL_EXT_bgra
  GL_BGR_EXT = $80E0;
  GL_BGRA_EXT = $80E1;

  // GL_EXT_blend_color
  GL_CONSTANT_COLOR_EXT = $8001;
  GL_ONE_MINUS_CONSTANT_COLOR_EXT = $8002;
  GL_CONSTANT_ALPHA_EXT = $8003;
  GL_ONE_MINUS_CONSTANT_ALPHA_EXT = $8004;
  GL_BLEND_COLOR_EXT = $8005;

  // GL_EXT_blend_func_separate
  GL_BLEND_DST_RGB_EXT = $80C8;
  GL_BLEND_SRC_RGB_EXT = $80C9;
  GL_BLEND_DST_ALPHA_EXT = $80CA;
  GL_BLEND_SRC_ALPHA_EXT = $80CB;

  // GL_EXT_blend_minmax
  GL_FUNC_ADD_EXT = $8006;
  GL_MIN_EXT = $8007;
  GL_MAX_EXT = $8008;
  GL_BLEND_EQUATION_EXT = $8009;

  // GL_EXT_blend_subtract
  GL_FUNC_SUBTRACT_EXT = $800A;
  GL_FUNC_REVERSE_SUBTRACT_EXT = $800B;

  // GL_EXT_clip_volume_hint
  GL_CLIP_VOLUME_CLIPPING_HINT_EXT = $80F0;

  // GL_EXT_cmyka
  GL_CMYK_EXT = $800C;
  GL_CMYKA_EXT = $800D;
  GL_PACK_CMYK_HINT_EXT = $800E;
  GL_UNPACK_CMYK_HINT_EXT = $800F;

  // GL_EXT_compiled_vertex_array
  GL_ARRAY_ELEMENT_LOCK_FIRST_EXT = $81A8;
  GL_ARRAY_ELEMENT_LOCK_COUNT_EXT = $81A9;

  // GL_EXT_convolution
  GL_CONVOLUTION_1D_EXT = $8010;
  GL_CONVOLUTION_2D_EXT = $8011;
  GL_SEPARABLE_2D_EXT = $8012;
  GL_CONVOLUTION_BORDER_MODE_EXT = $8013;
  GL_CONVOLUTION_FILTER_SCALE_EXT = $8014;
  GL_CONVOLUTION_FILTER_BIAS_EXT = $8015;
  GL_REDUCE_EXT = $8016;
  GL_CONVOLUTION_FORMAT_EXT = $8017;
  GL_CONVOLUTION_WIDTH_EXT = $8018;
  GL_CONVOLUTION_HEIGHT_EXT = $8019;
  GL_MAX_CONVOLUTION_WIDTH_EXT = $801A;
  GL_MAX_CONVOLUTION_HEIGHT_EXT = $801B;
  GL_POST_CONVOLUTION_RED_SCALE_EXT = $801C;
  GL_POST_CONVOLUTION_GREEN_SCALE_EXT = $801D;
  GL_POST_CONVOLUTION_BLUE_SCALE_EXT = $801E;
  GL_POST_CONVOLUTION_ALPHA_SCALE_EXT = $801F;
  GL_POST_CONVOLUTION_RED_BIAS_EXT = $8020;
  GL_POST_CONVOLUTION_GREEN_BIAS_EXT = $8021;
  GL_POST_CONVOLUTION_BLUE_BIAS_EXT = $8022;
  GL_POST_CONVOLUTION_ALPHA_BIAS_EXT = $8023;

  // GL_EXT_coordinate_frame
  GL_TANGENT_ARRAY_EXT = $8439;
  GL_BINORMAL_ARRAY_EXT = $843A;
  GL_CURRENT_TANGENT_EXT = $843B;
  GL_CURRENT_BINORMAL_EXT = $843C;
  GL_TANGENT_ARRAY_TYPE_EXT = $843E;
  GL_TANGENT_ARRAY_STRIDE_EXT = $843F;
  GL_BINORMAL_ARRAY_TYPE_EXT = $8440;
  GL_BINORMAL_ARRAY_STRIDE_EXT = $8441;
  GL_TANGENT_ARRAY_POINTER_EXT = $8442;
  GL_BINORMAL_ARRAY_POINTER_EXT = $8443;
  GL_MAP1_TANGENT_EXT = $8444;
  GL_MAP2_TANGENT_EXT = $8445;
  GL_MAP1_BINORMAL_EXT = $8446;
  GL_MAP2_BINORMAL_EXT = $8447;

  // GL_EXT_cull_vertex
  GL_CULL_VERTEX_EXT = $81AA;
  GL_CULL_VERTEX_EYE_POSITION_EXT = $81AB;
  GL_CULL_VERTEX_OBJECT_POSITION_EXT = $81AC;

  // GL_EXT_draw_range_elements
  GL_MAX_ELEMENTS_VERTICES_EXT = $80E8;
  GL_MAX_ELEMENTS_INDICES_EXT = $80E9;

  // GL_EXT_fog_coord
  GL_FOG_COORDINATE_SOURCE_EXT = $8450;
  GL_FOG_COORDINATE_EXT = $8451;
  GL_FRAGMENT_DEPTH_EXT = $8452;
  GL_CURRENT_FOG_COORDINATE_EXT = $8453;
  GL_FOG_COORDINATE_ARRAY_TYPE_EXT = $8454;
  GL_FOG_COORDINATE_ARRAY_STRIDE_EXT = $8455;
  GL_FOG_COORDINATE_ARRAY_POINTER_EXT = $8456;
  GL_FOG_COORDINATE_ARRAY_EXT = $8457;

  // GL_EXT_framebuffer_object
  GL_FRAMEBUFFER_EXT = $8D40;
  GL_RENDERBUFFER_EXT = $8D41;
  GL_STENCIL_INDEX_EXT = $8D45;
  GL_STENCIL_INDEX1_EXT = $8D46;
  GL_STENCIL_INDEX4_EXT = $8D47;
  GL_STENCIL_INDEX8_EXT = $8D48;
  GL_STENCIL_INDEX16_EXT = $8D49;
  GL_RENDERBUFFER_WIDTH_EXT = $8D42;
  GL_RENDERBUFFER_HEIGHT_EXT = $8D43;
  GL_RENDERBUFFER_INTERNAL_FORMAT_EXT = $8D44;
  GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT = $8CD0;
  GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT = $8CD1;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT = $8CD2;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT = $8CD3;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT = $8CD4;
  GL_COLOR_ATTACHMENT0_EXT = $8CE0;
  GL_COLOR_ATTACHMENT1_EXT = $8CE1;
  GL_COLOR_ATTACHMENT2_EXT = $8CE2;
  GL_COLOR_ATTACHMENT3_EXT = $8CE3;
  GL_COLOR_ATTACHMENT4_EXT = $8CE4;
  GL_COLOR_ATTACHMENT5_EXT = $8CE5;
  GL_COLOR_ATTACHMENT6_EXT = $8CE6;
  GL_COLOR_ATTACHMENT7_EXT = $8CE7;
  GL_COLOR_ATTACHMENT8_EXT = $8CE8;
  GL_COLOR_ATTACHMENT9_EXT = $8CE9;
  GL_COLOR_ATTACHMENT10_EXT = $8CEA;
  GL_COLOR_ATTACHMENT11_EXT = $8CEB;
  GL_COLOR_ATTACHMENT12_EXT = $8CEC;
  GL_COLOR_ATTACHMENT13_EXT = $8CED;
  GL_COLOR_ATTACHMENT14_EXT = $8CEE;
  GL_COLOR_ATTACHMENT15_EXT = $8CEF;
  GL_DEPTH_ATTACHMENT_EXT = $8D00;
  GL_STENCIL_ATTACHMENT_EXT = $8D20;
  GL_FRAMEBUFFER_COMPLETE_EXT = $8CD5;
  GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT = $8CD6;
  GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT = $8CD7;
  GL_FRAMEBUFFER_INCOMPLETE_DUPLICATE_ATTACHMENT_EXT = $8CD8;
  GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT = $8CD9;
  GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT = $8CDA;
  GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT = $8CDB;
  GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT = $8CDC;
  GL_FRAMEBUFFER_UNSUPPORTED_EXT = $8CDD;
  GL_FRAMEBUFFER_STATUS_ERROR_EXT = $8CDE;
  GL_FRAMEBUFFER_BINDING_EXT = $8CA6;
  GL_RENDERBUFFER_BINDING_EXT = $8CA7;
  GL_MAX_COLOR_ATTACHMENTS_EXT = $8CDF;
  GL_MAX_RENDERBUFFER_SIZE_EXT = $84E8;
  GL_INVALID_FRAMEBUFFER_OPERATION_EXT = $0506;

  // GL_EXT_histogram
  GL_HISTOGRAM_EXT = $8024;
  GL_PROXY_HISTOGRAM_EXT = $8025;
  GL_HISTOGRAM_WIDTH_EXT = $8026;
  GL_HISTOGRAM_FORMAT_EXT = $8027;
  GL_HISTOGRAM_RED_SIZE_EXT = $8028;
  GL_HISTOGRAM_GREEN_SIZE_EXT = $8029;
  GL_HISTOGRAM_BLUE_SIZE_EXT = $802A;
  GL_HISTOGRAM_ALPHA_SIZE_EXT = $802B;
  GL_HISTOGRAM_LUMINANCE_SIZE_EXT = $802C;
  GL_HISTOGRAM_SINK_EXT = $802D;
  GL_MINMAX_EXT = $802E;
  GL_MINMAX_FORMAT_EXT = $802F;
  GL_MINMAX_SINK_EXT = $8030;
  GL_TABLE_TOO_LARGE_EXT = $8031;

  // GL_EXT_index_array_formats
  GL_IUI_V2F_EXT = $81AD;
  GL_IUI_V3F_EXT = $81AE;
  GL_IUI_N3F_V2F_EXT = $81AF;
  GL_IUI_N3F_V3F_EXT = $81B0;
  GL_T2F_IUI_V2F_EXT = $81B1;
  GL_T2F_IUI_V3F_EXT = $81B2;
  GL_T2F_IUI_N3F_V2F_EXT = $81B3;
  GL_T2F_IUI_N3F_V3F_EXT = $81B4;

  // GL_EXT_index_func
  GL_INDEX_TEST_EXT = $81B5;
  GL_INDEX_TEST_FUNC_EXT = $81B6;
  GL_INDEX_TEST_REF_EXT = $81B7;

  // GL_EXT_index_material
  GL_INDEX_MATERIAL_EXT = $81B8;
  GL_INDEX_MATERIAL_PARAMETER_EXT = $81B9;
  GL_INDEX_MATERIAL_FACE_EXT = $81BA;

  // GL_EXT_light_texture
  GL_FRAGMENT_MATERIAL_EXT = $8349;
  GL_FRAGMENT_NORMAL_EXT = $834A;
  GL_FRAGMENT_COLOR_EXT = $834C;
  GL_ATTENUATION_EXT = $834D;
  GL_SHADOW_ATTENUATION_EXT = $834E;
  GL_TEXTURE_APPLICATION_MODE_EXT = $834F;
  GL_TEXTURE_LIGHT_EXT = $8350;
  GL_TEXTURE_MATERIAL_FACE_EXT = $8351;
  GL_TEXTURE_MATERIAL_PARAMETER_EXT = $8352;

  // GL_EXT_multisample
  GL_MULTISAMPLE_EXT = $809D;
  GL_SAMPLE_ALPHA_TO_MASK_EXT = $809E;
  GL_SAMPLE_ALPHA_TO_ONE_EXT = $809F;
  GL_SAMPLE_MASK_EXT = $80A0;
  GL_1PASS_EXT = $80A1;
  GL_2PASS_0_EXT = $80A2;
  GL_2PASS_1_EXT = $80A3;
  GL_4PASS_0_EXT = $80A4;
  GL_4PASS_1_EXT = $80A5;
  GL_4PASS_2_EXT = $80A6;
  GL_4PASS_3_EXT = $80A7;
  GL_SAMPLE_BUFFERS_EXT = $80A8;
  GL_SAMPLES_EXT = $80A9;
  GL_SAMPLE_MASK_VALUE_EXT = $80AA;
  GL_SAMPLE_MASK_INVERT_EXT = $80AB;
  GL_SAMPLE_PATTERN_EXT = $80AC;
  GL_MULTISAMPLE_BIT_EXT = $20000000;

  // GL_EXT_packed_pixels
  GL_UNSIGNED_BYTE_3_3_2_EXT = $8032;
  GL_UNSIGNED_SHORT_4_4_4_4_EXT = $8033;
  GL_UNSIGNED_SHORT_5_5_5_1_EXT = $8034;
  GL_UNSIGNED_INT_8_8_8_8_EXT = $8035;
  GL_UNSIGNED_INT_10_10_10_2_EXT = $8036;

  // GL_EXT_paletted_texture
  GL_COLOR_INDEX1_EXT = $80E2;
  GL_COLOR_INDEX2_EXT = $80E3;
  GL_COLOR_INDEX4_EXT = $80E4;
  GL_COLOR_INDEX8_EXT = $80E5;
  GL_COLOR_INDEX12_EXT = $80E6;
  GL_COLOR_INDEX16_EXT = $80E7;
  GL_TEXTURE_INDEX_SIZE_EXT = $80ED;

  // GL_EXT_pixel_transform
  GL_PIXEL_TRANSFORM_2D_EXT = $8330;
  GL_PIXEL_MAG_FILTER_EXT = $8331;
  GL_PIXEL_MIN_FILTER_EXT = $8332;
  GL_PIXEL_CUBIC_WEIGHT_EXT = $8333;
  GL_CUBIC_EXT = $8334;
  GL_AVERAGE_EXT = $8335;
  GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT = $8336;
  GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT = $8337;
  GL_PIXEL_TRANSFORM_2D_MATRIX_EXT = $8338;

  // GL_EXT_point_parameters
  GL_POINT_SIZE_MIN_EXT = $8126;
  GL_POINT_SIZE_MAX_EXT = $8127;
  GL_POINT_FADE_THRESHOLD_SIZE_EXT = $8128;
  GL_DISTANCE_ATTENUATION_EXT = $8129;

  // GL_EXT_polygon_offset
  GL_POLYGON_OFFSET_EXT = $8037;
  GL_POLYGON_OFFSET_FACTOR_EXT = $8038;
  GL_POLYGON_OFFSET_BIAS_EXT = $8039;

  // GL_EXT_rescale_normal
  GL_RESCALE_NORMAL_EXT = $803A;

  // GL_EXT_secondary_color
  GL_COLOR_SUM_EXT = $8458;
  GL_CURRENT_SECONDARY_COLOR_EXT = $8459;
  GL_SECONDARY_COLOR_ARRAY_SIZE_EXT = $845A;
  GL_SECONDARY_COLOR_ARRAY_TYPE_EXT = $845B;
  GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT = $845C;
  GL_SECONDARY_COLOR_ARRAY_POINTER_EXT = $845D;
  GL_SECONDARY_COLOR_ARRAY_EXT = $845E;

  // GL_EXT_separate_specular_color
  GL_LIGHT_MODEL_COLOR_CONTROL_EXT = $81F8;
  GL_SINGLE_COLOR_EXT = $81F9;
  GL_SEPARATE_SPECULAR_COLOR_EXT = $81FA;

  // GL_EXT_shared_texture_palette
  GL_SHARED_TEXTURE_PALETTE_EXT = $81FB;

  // GL_EXT_stencil_two_side
  GL_STENCIL_TEST_TWO_SIDE_EXT = $8910;
  GL_ACTIVE_STENCIL_FACE_EXT = $8911;

  // GL_EXT_stencil_wrap
  GL_INCR_WRAP_EXT = $8507;
  GL_DECR_WRAP_EXT = $8508;

  // GL_EXT_texture
  GL_ALPHA4_EXT = $803B;
  GL_ALPHA8_EXT = $803C;
  GL_ALPHA12_EXT = $803D;
  GL_ALPHA16_EXT = $803E;
  GL_LUMINANCE4_EXT = $803F;
  GL_LUMINANCE8_EXT = $8040;
  GL_LUMINANCE12_EXT = $8041;
  GL_LUMINANCE16_EXT = $8042;
  GL_LUMINANCE4_ALPHA4_EXT = $8043;
  GL_LUMINANCE6_ALPHA2_EXT = $8044;
  GL_LUMINANCE8_ALPHA8_EXT = $8045;
  GL_LUMINANCE12_ALPHA4_EXT = $8046;
  GL_LUMINANCE12_ALPHA12_EXT = $8047;
  GL_LUMINANCE16_ALPHA16_EXT = $8048;
  GL_INTENSITY_EXT = $8049;
  GL_INTENSITY4_EXT = $804A;
  GL_INTENSITY8_EXT = $804B;
  GL_INTENSITY12_EXT = $804C;
  GL_INTENSITY16_EXT = $804D;
  GL_RGB2_EXT = $804E;
  GL_RGB4_EXT = $804F;
  GL_RGB5_EXT = $8050;
  GL_RGB8_EXT = $8051;
  GL_RGB10_EXT = $8052;
  GL_RGB12_EXT = $8053;
  GL_RGB16_EXT = $8054;
  GL_RGBA2_EXT = $8055;
  GL_RGBA4_EXT = $8056;
  GL_RGB5_A1_EXT = $8057;
  GL_RGBA8_EXT = $8058;
  GL_RGB10_A2_EXT = $8059;
  GL_RGBA12_EXT = $805A;
  GL_RGBA16_EXT = $805B;
  GL_TEXTURE_RED_SIZE_EXT = $805C;
  GL_TEXTURE_GREEN_SIZE_EXT = $805D;
  GL_TEXTURE_BLUE_SIZE_EXT = $805E;
  GL_TEXTURE_ALPHA_SIZE_EXT = $805F;
  GL_TEXTURE_LUMINANCE_SIZE_EXT = $8060;
  GL_TEXTURE_INTENSITY_SIZE_EXT = $8061;
  GL_REPLACE_EXT = $8062;
  GL_PROXY_TEXTURE_1D_EXT = $8063;
  GL_PROXY_TEXTURE_2D_EXT = $8064;
  GL_TEXTURE_TOO_LARGE_EXT = $8065;

  // GL_EXT_texture3D
  GL_PACK_SKIP_IMAGES_EXT = $806B;
  GL_PACK_IMAGE_HEIGHT_EXT = $806C;
  GL_UNPACK_SKIP_IMAGES_EXT = $806D;
  GL_UNPACK_IMAGE_HEIGHT_EXT = $806E;
  GL_TEXTURE_3D_EXT = $806F;
  GL_PROXY_TEXTURE_3D_EXT = $8070;
  GL_TEXTURE_DEPTH_EXT = $8071;
  GL_TEXTURE_WRAP_R_EXT = $8072;
  GL_MAX_3D_TEXTURE_SIZE_EXT = $8073;

  // GL_EXT_texture_compression_s3tc
  GL_COMPRESSED_RGB_S3TC_DXT1_EXT = $83F0;
  GL_COMPRESSED_RGBA_S3TC_DXT1_EXT = $83F1;
  GL_COMPRESSED_RGBA_S3TC_DXT3_EXT = $83F2;
  GL_COMPRESSED_RGBA_S3TC_DXT5_EXT = $83F3;

  // GL_EXT_texture_cube_map
  GL_NORMAL_MAP_EXT = $8511;
  GL_REFLECTION_MAP_EXT = $8512;
  GL_TEXTURE_CUBE_MAP_EXT = $8513;
  GL_TEXTURE_BINDING_CUBE_MAP_EXT = $8514;
  GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT = $8515;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT = $8516;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT = $8517;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT = $8518;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT = $8519;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT = $851A;
  GL_PROXY_TEXTURE_CUBE_MAP_EXT = $851B;
  GL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT = $851C;

  // GL_EXT_texture_edge_clamp
  GL_CLAMP_TO_EDGE_EXT = $812F;

  // GL_EXT_texture_env_combine
  GL_COMBINE_EXT = $8570;
  GL_COMBINE_RGB_EXT = $8571;
  GL_COMBINE_ALPHA_EXT = $8572;
  GL_RGB_SCALE_EXT = $8573;
  GL_ADD_SIGNED_EXT = $8574;
  GL_INTERPOLATE_EXT = $8575;
  GL_CONSTANT_EXT = $8576;
  GL_PRIMARY_COLOR_EXT = $8577;
  GL_PREVIOUS_EXT = $8578;
  GL_SOURCE0_RGB_EXT = $8580;
  GL_SOURCE1_RGB_EXT = $8581;
  GL_SOURCE2_RGB_EXT = $8582;
  GL_SOURCE0_ALPHA_EXT = $8588;
  GL_SOURCE1_ALPHA_EXT = $8589;
  GL_SOURCE2_ALPHA_EXT = $858A;
  GL_OPERAND0_RGB_EXT = $8590;
  GL_OPERAND1_RGB_EXT = $8591;
  GL_OPERAND2_RGB_EXT = $8592;
  GL_OPERAND0_ALPHA_EXT = $8598;
  GL_OPERAND1_ALPHA_EXT = $8599;
  GL_OPERAND2_ALPHA_EXT = $859A;

  // GL_EXT_texture_env_dot3
  GL_DOT3_RGB_EXT = $8740;
  GL_DOT3_RGBA_EXT = $8741;

  // GL_EXT_texture_filter_anisotropic
  GL_TEXTURE_MAX_ANISOTROPY_EXT = $84FE;
  GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT = $84FF;

  // GL_EXT_texture_lod_bias
  GL_MAX_TEXTURE_LOD_BIAS_EXT = $84FD;
  GL_TEXTURE_FILTER_CONTROL_EXT = $8500;
  GL_TEXTURE_LOD_BIAS_EXT = $8501;

  // GL_EXT_texture_object
  GL_TEXTURE_PRIORITY_EXT = $8066;
  GL_TEXTURE_RESIDENT_EXT = $8067;
  GL_TEXTURE_1D_BINDING_EXT = $8068;
  GL_TEXTURE_2D_BINDING_EXT = $8069;
  GL_TEXTURE_3D_BINDING_EXT = $806A;

  // GL_EXT_texture_perturb_normal
  GL_PERTURB_EXT = $85AE;
  GL_TEXTURE_NORMAL_EXT = $85AF;

  // GL_EXT_texture_rectangle
  GL_TEXTURE_RECTANGLE_EXT = $84F5;
  GL_TEXTURE_BINDING_RECTANGLE_EXT = $84F6;
  GL_PROXY_TEXTURE_RECTANGLE_EXT = $84F7;
  GL_MAX_RECTANGLE_TEXTURE_SIZE_EXT = $84F8;

  // GL_EXT_vertex_array
  GL_VERTEX_ARRAY_EXT = $8074;
  GL_NORMAL_ARRAY_EXT = $8075;
  GL_COLOR_ARRAY_EXT = $8076;
  GL_INDEX_ARRAY_EXT = $8077;
  GL_TEXTURE_COORD_ARRAY_EXT = $8078;
  GL_EDGE_FLAG_ARRAY_EXT = $8079;
  GL_VERTEX_ARRAY_SIZE_EXT = $807A;
  GL_VERTEX_ARRAY_TYPE_EXT = $807B;
  GL_VERTEX_ARRAY_STRIDE_EXT = $807C;
  GL_VERTEX_ARRAY_COUNT_EXT = $807D;
  GL_NORMAL_ARRAY_TYPE_EXT = $807E;
  GL_NORMAL_ARRAY_STRIDE_EXT = $807F;
  GL_NORMAL_ARRAY_COUNT_EXT = $8080;
  GL_COLOR_ARRAY_SIZE_EXT = $8081;
  GL_COLOR_ARRAY_TYPE_EXT = $8082;
  GL_COLOR_ARRAY_STRIDE_EXT = $8083;
  GL_COLOR_ARRAY_COUNT_EXT = $8084;
  GL_INDEX_ARRAY_TYPE_EXT = $8085;
  GL_INDEX_ARRAY_STRIDE_EXT = $8086;
  GL_INDEX_ARRAY_COUNT_EXT = $8087;
  GL_TEXTURE_COORD_ARRAY_SIZE_EXT = $8088;
  GL_TEXTURE_COORD_ARRAY_TYPE_EXT = $8089;
  GL_TEXTURE_COORD_ARRAY_STRIDE_EXT = $808A;
  GL_TEXTURE_COORD_ARRAY_COUNT_EXT = $808B;
  GL_EDGE_FLAG_ARRAY_STRIDE_EXT = $808C;
  GL_EDGE_FLAG_ARRAY_COUNT_EXT = $808D;
  GL_VERTEX_ARRAY_POINTER_EXT = $808E;
  GL_NORMAL_ARRAY_POINTER_EXT = $808F;
  GL_COLOR_ARRAY_POINTER_EXT = $8090;
  GL_INDEX_ARRAY_POINTER_EXT = $8091;
  GL_TEXTURE_COORD_ARRAY_POINTER_EXT = $8092;
  GL_EDGE_FLAG_ARRAY_POINTER_EXT = $8093;

  // GL_EXT_vertex_shader
  GL_VERTEX_SHADER_EXT = $8780;
  GL_VERTEX_SHADER_BINDING_EXT = $8781;
  GL_OP_INDEX_EXT = $8782;
  GL_OP_NEGATE_EXT = $8783;
  GL_OP_DOT3_EXT = $8784;
  GL_OP_DOT4_EXT = $8785;
  GL_OP_MUL_EXT = $8786;
  GL_OP_ADD_EXT = $8787;
  GL_OP_MADD_EXT = $8788;
  GL_OP_FRAC_EXT = $8789;
  GL_OP_MAX_EXT = $878A;
  GL_OP_MIN_EXT = $878B;
  GL_OP_SET_GE_EXT = $878C;
  GL_OP_SET_LT_EXT = $878D;
  GL_OP_CLAMP_EXT = $878E;
  GL_OP_FLOOR_EXT = $878F;
  GL_OP_ROUND_EXT = $8790;
  GL_OP_EXP_BASE_2_EXT = $8791;
  GL_OP_LOG_BASE_2_EXT = $8792;
  GL_OP_POWER_EXT = $8793;
  GL_OP_RECIP_EXT = $8794;
  GL_OP_RECIP_SQRT_EXT = $8795;
  GL_OP_SUB_EXT = $8796;
  GL_OP_CROSS_PRODUCT_EXT = $8797;
  GL_OP_MULTIPLY_MATRIX_EXT = $8798;
  GL_OP_MOV_EXT = $8799;
  GL_OUTPUT_VERTEX_EXT = $879A;
  GL_OUTPUT_COLOR0_EXT = $879B;
  GL_OUTPUT_COLOR1_EXT = $879C;
  GL_OUTPUT_TEXTURE_COORD0_EXT = $879D;
  GL_OUTPUT_TEXTURE_COORD1_EXT = $879E;
  GL_OUTPUT_TEXTURE_COORD2_EXT = $879F;
  GL_OUTPUT_TEXTURE_COORD3_EXT = $87A0;
  GL_OUTPUT_TEXTURE_COORD4_EXT = $87A1;
  GL_OUTPUT_TEXTURE_COORD5_EXT = $87A2;
  GL_OUTPUT_TEXTURE_COORD6_EXT = $87A3;
  GL_OUTPUT_TEXTURE_COORD7_EXT = $87A4;
  GL_OUTPUT_TEXTURE_COORD8_EXT = $87A5;
  GL_OUTPUT_TEXTURE_COORD9_EXT = $87A6;
  GL_OUTPUT_TEXTURE_COORD10_EXT = $87A7;
  GL_OUTPUT_TEXTURE_COORD11_EXT = $87A8;
  GL_OUTPUT_TEXTURE_COORD12_EXT = $87A9;
  GL_OUTPUT_TEXTURE_COORD13_EXT = $87AA;
  GL_OUTPUT_TEXTURE_COORD14_EXT = $87AB;
  GL_OUTPUT_TEXTURE_COORD15_EXT = $87AC;
  GL_OUTPUT_TEXTURE_COORD16_EXT = $87AD;
  GL_OUTPUT_TEXTURE_COORD17_EXT = $87AE;
  GL_OUTPUT_TEXTURE_COORD18_EXT = $87AF;
  GL_OUTPUT_TEXTURE_COORD19_EXT = $87B0;
  GL_OUTPUT_TEXTURE_COORD20_EXT = $87B1;
  GL_OUTPUT_TEXTURE_COORD21_EXT = $87B2;
  GL_OUTPUT_TEXTURE_COORD22_EXT = $87B3;
  GL_OUTPUT_TEXTURE_COORD23_EXT = $87B4;
  GL_OUTPUT_TEXTURE_COORD24_EXT = $87B5;
  GL_OUTPUT_TEXTURE_COORD25_EXT = $87B6;
  GL_OUTPUT_TEXTURE_COORD26_EXT = $87B7;
  GL_OUTPUT_TEXTURE_COORD27_EXT = $87B8;
  GL_OUTPUT_TEXTURE_COORD28_EXT = $87B9;
  GL_OUTPUT_TEXTURE_COORD29_EXT = $87BA;
  GL_OUTPUT_TEXTURE_COORD30_EXT = $87BB;
  GL_OUTPUT_TEXTURE_COORD31_EXT = $87BC;
  GL_OUTPUT_FOG_EXT = $87BD;
  GL_SCALAR_EXT = $87BE;
  GL_VECTOR_EXT = $87BF;
  GL_MATRIX_EXT = $87C0;
  GL_VARIANT_EXT = $87C1;
  GL_INVARIANT_EXT = $87C2;
  GL_LOCAL_CONSTANT_EXT = $87C3;
  GL_LOCAL_EXT = $87C4;
  GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT = $87C5;
  GL_MAX_VERTEX_SHADER_VARIANTS_EXT = $87C6;
  GL_MAX_VERTEX_SHADER_INVARIANTS_EXT = $87C7;
  GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = $87C8;
  GL_MAX_VERTEX_SHADER_LOCALS_EXT = $87C9;
  GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT = $87CA;
  GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT = $87CB;
  GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = $87CC;
  GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT = $87CD;
  GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT = $87CE;
  GL_VERTEX_SHADER_INSTRUCTIONS_EXT = $87CF;
  GL_VERTEX_SHADER_VARIANTS_EXT = $87D0;
  GL_VERTEX_SHADER_INVARIANTS_EXT = $87D1;
  GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = $87D2;
  GL_VERTEX_SHADER_LOCALS_EXT = $87D3;
  GL_VERTEX_SHADER_OPTIMIZED_EXT = $87D4;
  GL_X_EXT = $87D5;
  GL_Y_EXT = $87D6;
  GL_Z_EXT = $87D7;
  GL_W_EXT = $87D8;
  GL_NEGATIVE_X_EXT = $87D9;
  GL_NEGATIVE_Y_EXT = $87DA;
  GL_NEGATIVE_Z_EXT = $87DB;
  GL_NEGATIVE_W_EXT = $87DC;
  GL_ZERO_EXT = $87DD;
  GL_ONE_EXT = $87DE;
  GL_NEGATIVE_ONE_EXT = $87DF;
  GL_NORMALIZED_RANGE_EXT = $87E0;
  GL_FULL_RANGE_EXT = $87E1;
  GL_CURRENT_VERTEX_EXT = $87E2;
  GL_MVP_MATRIX_EXT = $87E3;
  GL_VARIANT_VALUE_EXT = $87E4;
  GL_VARIANT_DATATYPE_EXT = $87E5;
  GL_VARIANT_ARRAY_STRIDE_EXT = $87E6;
  GL_VARIANT_ARRAY_TYPE_EXT = $87E7;
  GL_VARIANT_ARRAY_EXT = $87E8;
  GL_VARIANT_ARRAY_POINTER_EXT = $87E9;
  GL_INVARIANT_VALUE_EXT = $87EA;
  GL_INVARIANT_DATATYPE_EXT = $87EB;
  GL_LOCAL_CONSTANT_VALUE_EXT = $87EC;
  GL_LOCAL_CONSTANT_DATATYPE_EXT = $87ED;

  // GL_EXT_vertex_weighting
  GL_MODELVIEW0_STACK_DEPTH_EXT = GL_MODELVIEW_STACK_DEPTH;
  GL_MODELVIEW1_STACK_DEPTH_EXT = $8502;
  GL_MODELVIEW0_MATRIX_EXT = GL_MODELVIEW_MATRIX;
  GL_MODELVIEW1_MATRIX_EXT = $8506;
  GL_VERTEX_WEIGHTING_EXT = $8509;
  GL_MODELVIEW0_EXT = GL_MODELVIEW;
  GL_MODELVIEW1_EXT = $850A;
  GL_CURRENT_VERTEX_WEIGHT_EXT = $850B;
  GL_VERTEX_WEIGHT_ARRAY_EXT = $850C;
  GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT = $850D;
  GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT = $850E;
  GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT = $850F;
  GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT = $8510;

  // GL_EXT_depth_bounds_test
  GL_DEPTH_BOUNDS_TEST_EXT = $8890;
  GL_DEPTH_BOUNDS_EXT = $8891;

  // GL_EXT_texture_mirror_clamp
  GL_MIRROR_CLAMP_EXT = $8742; // (same value as MIRROR_CLAMP_ATI)
  GL_MIRROR_CLAMP_TO_EDGE_EXT = $8743; // (same value as MIRROR_CLAMP_TO_EDGE_ATI)
  GL_MIRROR_CLAMP_TO_BORDER_EXT = $8912;

  // GL_EXT_blend_equation_separate
  GL_BLEND_EQUATION_RGB_EXT = $8009; // (same as BLEND_EQUATION)
  GL_BLEND_EQUATION_ALPHA_EXT = $883D;

  // GL_EXT_pixel_buffer_object
  GL_PIXEL_PACK_BUFFER_EXT = $88EB;
  GL_PIXEL_UNPACK_BUFFER_EXT = $88EC;
  GL_PIXEL_PACK_BUFFER_BINDING_EXT = $88ED;
  GL_PIXEL_UNPACK_BUFFER_BINDING_EXT = $88EF;

  // GL_EXT_stencil_clear_tag
  GL_STENCIL_TAG_BITS_EXT = $88F2;
  GL_STENCIL_CLEAR_TAG_VALUE_EXT = $88F3;

  // GL_FfdMaskSGIX
  GL_TEXTURE_DEFORMATION_BIT_SGIX = $00000001;
  GL_GEOMETRY_DEFORMATION_BIT_SGIX = $00000002;

  // GL_HP_convolution_border_modes
  GL_IGNORE_BORDER_HP = $8150;
  GL_CONSTANT_BORDER_HP = $8151;
  GL_REPLICATE_BORDER_HP = $8153;
  GL_CONVOLUTION_BORDER_COLOR_HP = $8154;

  // GL_HP_image_transform
  GL_IMAGE_SCALE_X_HP = $8155;
  GL_IMAGE_SCALE_Y_HP = $8156;
  GL_IMAGE_TRANSLATE_X_HP = $8157;
  GL_IMAGE_TRANSLATE_Y_HP = $8158;
  GL_IMAGE_ROTATE_ANGLE_HP = $8159;
  GL_IMAGE_ROTATE_ORIGIN_X_HP = $815A;
  GL_IMAGE_ROTATE_ORIGIN_Y_HP = $815B;
  GL_IMAGE_MAG_FILTER_HP = $815C;
  GL_IMAGE_MIN_FILTER_HP = $815D;
  GL_IMAGE_CUBIC_WEIGHT_HP = $815E;
  GL_CUBIC_HP = $815F;
  GL_AVERAGE_HP = $8160;
  GL_IMAGE_TRANSFORM_2D_HP = $8161;
  GL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP = $8162;
  GL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP = $8163;

  // GL_HP_occlusion_test
  GL_OCCLUSION_TEST_HP = $8165;
  GL_OCCLUSION_TEST_RESULT_HP = $8166;

  // GL_HP_texture_lighting
  GL_TEXTURE_LIGHTING_MODE_HP = $8167;
  GL_TEXTURE_POST_SPECULAR_HP = $8168;
  GL_TEXTURE_PRE_SPECULAR_HP = $8169;

  // GL_IBM_cull_vertex
  GL_CULL_VERTEX_IBM = 103050;

  // GL_IBM_rasterpos_clip
  GL_RASTER_POSITION_UNCLIPPED_IBM = $19262;

  // GL_IBM_texture_mirrored_repeat
  GL_MIRRORED_REPEAT_IBM = $8370;

  // GL_IBM_vertex_array_lists
  GL_VERTEX_ARRAY_LIST_IBM = 103070;
  GL_NORMAL_ARRAY_LIST_IBM = 103071;
  GL_COLOR_ARRAY_LIST_IBM = 103072;
  GL_INDEX_ARRAY_LIST_IBM = 103073;
  GL_TEXTURE_COORD_ARRAY_LIST_IBM = 103074;
  GL_EDGE_FLAG_ARRAY_LIST_IBM = 103075;
  GL_FOG_COORDINATE_ARRAY_LIST_IBM = 103076;
  GL_SECONDARY_COLOR_ARRAY_LIST_IBM = 103077;
  GL_VERTEX_ARRAY_LIST_STRIDE_IBM = 103080;
  GL_NORMAL_ARRAY_LIST_STRIDE_IBM = 103081;
  GL_COLOR_ARRAY_LIST_STRIDE_IBM = 103082;
  GL_INDEX_ARRAY_LIST_STRIDE_IBM = 103083;
  GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM = 103084;
  GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM = 103085;
  GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM = 103086;
  GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM = 103087;

  // GL_INGR_color_clamp
  GL_RED_MIN_CLAMP_INGR = $8560;
  GL_GREEN_MIN_CLAMP_INGR = $8561;
  GL_BLUE_MIN_CLAMP_INGR = $8562;
  GL_ALPHA_MIN_CLAMP_INGR = $8563;
  GL_RED_MAX_CLAMP_INGR = $8564;
  GL_GREEN_MAX_CLAMP_INGR = $8565;
  GL_BLUE_MAX_CLAMP_INGR = $8566;
  GL_ALPHA_MAX_CLAMP_INGR = $8567;

  // GL_INGR_interlace_read
  GL_INTERLACE_READ_INGR = $8568;

  // GL_INTEL_parallel_arrays
  GL_PARALLEL_ARRAYS_INTEL = $83F4;
  GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL = $83F5;
  GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL = $83F6;
  GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL = $83F7;
  GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL = $83F8;

  // GL_NV_copy_depth_to_color
  GL_DEPTH_STENCIL_TO_RGBA_NV = $886E;
  GL_DEPTH_STENCIL_TO_BGRA_NV = $886F;

  // GL_NV_depth_clamp
  GL_DEPTH_CLAMP_NV = $864F;

  // GL_NV_evaluators
  GL_EVAL_2D_NV = $86C0;
  GL_EVAL_TRIANGULAR_2D_NV = $86C1;
  GL_MAP_TESSELLATION_NV = $86C2;
  GL_MAP_ATTRIB_U_ORDER_NV = $86C3;
  GL_MAP_ATTRIB_V_ORDER_NV = $86C4;
  GL_EVAL_FRACTIONAL_TESSELLATION_NV = $86C5;
  GL_EVAL_VERTEX_ATTRIB0_NV = $86C6;
  GL_EVAL_VERTEX_ATTRIB1_NV = $86C7;
  GL_EVAL_VERTEX_ATTRIB2_NV = $86C8;
  GL_EVAL_VERTEX_ATTRIB3_NV = $86C9;
  GL_EVAL_VERTEX_ATTRIB4_NV = $86CA;
  GL_EVAL_VERTEX_ATTRIB5_NV = $86CB;
  GL_EVAL_VERTEX_ATTRIB6_NV = $86CC;
  GL_EVAL_VERTEX_ATTRIB7_NV = $86CD;
  GL_EVAL_VERTEX_ATTRIB8_NV = $86CE;
  GL_EVAL_VERTEX_ATTRIB9_NV = $86CF;
  GL_EVAL_VERTEX_ATTRIB10_NV = $86D0;
  GL_EVAL_VERTEX_ATTRIB11_NV = $86D1;
  GL_EVAL_VERTEX_ATTRIB12_NV = $86D2;
  GL_EVAL_VERTEX_ATTRIB13_NV = $86D3;
  GL_EVAL_VERTEX_ATTRIB14_NV = $86D4;
  GL_EVAL_VERTEX_ATTRIB15_NV = $86D5;
  GL_MAX_MAP_TESSELLATION_NV = $86D6;
  GL_MAX_RATIONAL_EVAL_ORDER_NV = $86D7;

  // GL_NV_fence
  GL_ALL_COMPLETED_NV = $84F2;
  GL_FENCE_STATUS_NV = $84F3;
  GL_FENCE_CONDITION_NV = $84F4;

  // GL_NV_float_buffer
  GL_FLOAT_R_NV = $8880;
  GL_FLOAT_RG_NV = $8881;
  GL_FLOAT_RGB_NV = $8882;
  GL_FLOAT_RGBA_NV = $8883;
  GL_FLOAT_R16_NV = $8884;
  GL_FLOAT_R32_NV = $8885;
  GL_FLOAT_RG16_NV = $8886;
  GL_FLOAT_RG32_NV = $8887;
  GL_FLOAT_RGB16_NV = $8888;
  GL_FLOAT_RGB32_NV = $8889;
  GL_FLOAT_RGBA16_NV = $888A;
  GL_FLOAT_RGBA32_NV = $888B;
  GL_TEXTURE_FLOAT_COMPONENTS_NV = $888C;
  GL_FLOAT_CLEAR_COLOR_VALUE_NV = $888D;
  GL_FLOAT_RGBA_MODE_NV = $888E;

  // GL_NV_fog_distance
  GL_FOG_DISTANCE_MODE_NV = $855A;
  GL_EYE_RADIAL_NV = $855B;
  GL_EYE_PLANE_ABSOLUTE_NV = $855C;

  // GL_NV_fragment_program
  GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV = $8868;
  GL_FRAGMENT_PROGRAM_NV = $8870;
  GL_MAX_TEXTURE_COORDS_NV = $8871;
  GL_MAX_TEXTURE_IMAGE_UNITS_NV = $8872;
  GL_FRAGMENT_PROGRAM_BINDING_NV = $8873;
  GL_PROGRAM_ERROR_STRING_NV = $8874;

  // GL_NV_half_float
  GL_HALF_FLOAT_NV = $140B;

  // GL_NV_light_max_exponent
  GL_MAX_SHININESS_NV = $8504;
  GL_MAX_SPOT_EXPONENT_NV = $8505;

  // GL_NV_multisample_filter_hint
  GL_MULTISAMPLE_FILTER_HINT_NV = $8534;

  // GL_NV_occlusion_query
  GL_PIXEL_COUNTER_BITS_NV = $8864;
  GL_CURRENT_OCCLUSION_QUERY_ID_NV = $8865;
  GL_PIXEL_COUNT_NV = $8866;
  GL_PIXEL_COUNT_AVAILABLE_NV = $8867;

  // GL_NV_packed_depth_stencil
  GL_DEPTH_STENCIL_NV = $84F9;
  GL_UNSIGNED_INT_24_8_NV = $84FA;

  // GL_NV_pixel_data_range
  GL_WRITE_PIXEL_DATA_RANGE_NV = $8878;
  GL_READ_PIXEL_DATA_RANGE_NV = $8879;
  GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV = $887A;
  GL_READ_PIXEL_DATA_RANGE_LENGTH_NV = $887B;
  GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV = $887C;
  GL_READ_PIXEL_DATA_RANGE_POINTER_NV = $887D;

  // GL_NV_point_sprite
  GL_POINT_SPRITE_NV = $8861;
  GL_COORD_REPLACE_NV = $8862;
  GL_POINT_SPRITE_R_MODE_NV = $8863;

  // GL_NV_primitive_restart
  GL_PRIMITIVE_RESTART_NV = $8558;
  GL_PRIMITIVE_RESTART_INDEX_NV = $8559;

  // GL_NV_register_combiners
  GL_REGISTER_COMBINERS_NV = $8522;
  GL_VARIABLE_A_NV = $8523;
  GL_VARIABLE_B_NV = $8524;
  GL_VARIABLE_C_NV = $8525;
  GL_VARIABLE_D_NV = $8526;
  GL_VARIABLE_E_NV = $8527;
  GL_VARIABLE_F_NV = $8528;
  GL_VARIABLE_G_NV = $8529;
  GL_CONSTANT_COLOR0_NV = $852A;
  GL_CONSTANT_COLOR1_NV = $852B;
  GL_PRIMARY_COLOR_NV = $852C;
  GL_SECONDARY_COLOR_NV = $852D;
  GL_SPARE0_NV = $852E;
  GL_SPARE1_NV = $852F;
  GL_DISCARD_NV = $8530;
  GL_E_TIMES_F_NV = $8531;
  GL_SPARE0_PLUS_SECONDARY_COLOR_NV = $8532;
  GL_UNSIGNED_IDENTITY_NV = $8536;
  GL_UNSIGNED_INVERT_NV = $8537;
  GL_EXPAND_NORMAL_NV = $8538;
  GL_EXPAND_NEGATE_NV = $8539;
  GL_HALF_BIAS_NORMAL_NV = $853A;
  GL_HALF_BIAS_NEGATE_NV = $853B;
  GL_SIGNED_IDENTITY_NV = $853C;
  GL_SIGNED_NEGATE_NV = $853D;
  GL_SCALE_BY_TWO_NV = $853E;
  GL_SCALE_BY_FOUR_NV = $853F;
  GL_SCALE_BY_ONE_HALF_NV = $8540;
  GL_BIAS_BY_NEGATIVE_ONE_HALF_NV = $8541;
  GL_COMBINER_INPUT_NV = $8542;
  GL_COMBINER_MAPPING_NV = $8543;
  GL_COMBINER_COMPONENT_USAGE_NV = $8544;
  GL_COMBINER_AB_DOT_PRODUCT_NV = $8545;
  GL_COMBINER_CD_DOT_PRODUCT_NV = $8546;
  GL_COMBINER_MUX_SUM_NV = $8547;
  GL_COMBINER_SCALE_NV = $8548;
  GL_COMBINER_BIAS_NV = $8549;
  GL_COMBINER_AB_OUTPUT_NV = $854A;
  GL_COMBINER_CD_OUTPUT_NV = $854B;
  GL_COMBINER_SUM_OUTPUT_NV = $854C;
  GL_MAX_GENERAL_COMBINERS_NV = $854D;
  GL_NUM_GENERAL_COMBINERS_NV = $854E;
  GL_COLOR_SUM_CLAMP_NV = $854F;
  GL_COMBINER0_NV = $8550;
  GL_COMBINER1_NV = $8551;
  GL_COMBINER2_NV = $8552;
  GL_COMBINER3_NV = $8553;
  GL_COMBINER4_NV = $8554;
  GL_COMBINER5_NV = $8555;
  GL_COMBINER6_NV = $8556;
  GL_COMBINER7_NV = $8557;

  // GL_NV_register_combiners2
  GL_PER_STAGE_CONSTANTS_NV = $8535;

  // GL_NV_texgen_emboss
  GL_EMBOSS_LIGHT_NV = $855D;
  GL_EMBOSS_CONSTANT_NV = $855E;
  GL_EMBOSS_MAP_NV = $855F;

  // GL_NV_texgen_reflection
  GL_NORMAL_MAP_NV = $8511;
  GL_REFLECTION_MAP_NV = $8512;

  // GL_NV_texture_env_combine4
  GL_COMBINE4_NV = $8503;
  GL_SOURCE3_RGB_NV = $8583;
  GL_SOURCE3_ALPHA_NV = $858B;
  GL_OPERAND3_RGB_NV = $8593;
  GL_OPERAND3_ALPHA_NV = $859B;

  // GL_NV_texture_expand_normal
  GL_TEXTURE_UNSIGNED_REMAP_MODE_NV = $888F;

  // GL_NV_texture_rectangle
  GL_TEXTURE_RECTANGLE_NV = $84F5;
  GL_TEXTURE_BINDING_RECTANGLE_NV = $84F6;
  GL_PROXY_TEXTURE_RECTANGLE_NV = $84F7;
  GL_MAX_RECTANGLE_TEXTURE_SIZE_NV = $84F8;

  // GL_NV_texture_shader
  GL_OFFSET_TEXTURE_RECTANGLE_NV = $864C;
  GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV = $864D;
  GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV = $864E;
  GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV = $86D9;
  GL_UNSIGNED_INT_S8_S8_8_8_NV = $86DA;
  GL_UNSIGNED_INT_8_8_S8_S8_REV_NV = $86DB;
  GL_DSDT_MAG_INTENSITY_NV = $86DC;
  GL_SHADER_CONSISTENT_NV = $86DD;
  GL_TEXTURE_SHADER_NV = $86DE;
  GL_SHADER_OPERATION_NV = $86DF;
  GL_CULL_MODES_NV = $86E0;
  GL_OFFSET_TEXTURE_MATRIX_NV = $86E1;
  GL_OFFSET_TEXTURE_SCALE_NV = $86E2;
  GL_OFFSET_TEXTURE_BIAS_NV = $86E3;
  GL_OFFSET_TEXTURE_2D_MATRIX_NV = GL_OFFSET_TEXTURE_MATRIX_NV;
  GL_OFFSET_TEXTURE_2D_SCALE_NV = GL_OFFSET_TEXTURE_SCALE_NV;
  GL_OFFSET_TEXTURE_2D_BIAS_NV = GL_OFFSET_TEXTURE_BIAS_NV;
  GL_PREVIOUS_TEXTURE_INPUT_NV = $86E4;
  GL_CONST_EYE_NV = $86E5;
  GL_PASS_THROUGH_NV = $86E6;
  GL_CULL_FRAGMENT_NV = $86E7;
  GL_OFFSET_TEXTURE_2D_NV = $86E8;
  GL_DEPENDENT_AR_TEXTURE_2D_NV = $86E9;
  GL_DEPENDENT_GB_TEXTURE_2D_NV = $86EA;
  GL_DOT_PRODUCT_NV = $86EC;
  GL_DOT_PRODUCT_DEPTH_REPLACE_NV = $86ED;
  GL_DOT_PRODUCT_TEXTURE_2D_NV = $86EE;
  GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV = $86F0;
  GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV = $86F1;
  GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV = $86F2;
  GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV = $86F3;
  GL_HILO_NV = $86F4;
  GL_DSDT_NV = $86F5;
  GL_DSDT_MAG_NV = $86F6;
  GL_DSDT_MAG_VIB_NV = $86F7;
  GL_HILO16_NV = $86F8;
  GL_SIGNED_HILO_NV = $86F9;
  GL_SIGNED_HILO16_NV = $86FA;
  GL_SIGNED_RGBA_NV = $86FB;
  GL_SIGNED_RGBA8_NV = $86FC;
  GL_SIGNED_RGB_NV = $86FE;
  GL_SIGNED_RGB8_NV = $86FF;
  GL_SIGNED_LUMINANCE_NV = $8701;
  GL_SIGNED_LUMINANCE8_NV = $8702;
  GL_SIGNED_LUMINANCE_ALPHA_NV = $8703;
  GL_SIGNED_LUMINANCE8_ALPHA8_NV = $8704;
  GL_SIGNED_ALPHA_NV = $8705;
  GL_SIGNED_ALPHA8_NV = $8706;
  GL_SIGNED_INTENSITY_NV = $8707;
  GL_SIGNED_INTENSITY8_NV = $8708;
  GL_DSDT8_NV = $8709;
  GL_DSDT8_MAG8_NV = $870A;
  GL_DSDT8_MAG8_INTENSITY8_NV = $870B;
  GL_SIGNED_RGB_UNSIGNED_ALPHA_NV = $870C;
  GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV = $870D;
  GL_HI_SCALE_NV = $870E;
  GL_LO_SCALE_NV = $870F;
  GL_DS_SCALE_NV = $8710;
  GL_DT_SCALE_NV = $8711;
  GL_MAGNITUDE_SCALE_NV = $8712;
  GL_VIBRANCE_SCALE_NV = $8713;
  GL_HI_BIAS_NV = $8714;
  GL_LO_BIAS_NV = $8715;
  GL_DS_BIAS_NV = $8716;
  GL_DT_BIAS_NV = $8717;
  GL_MAGNITUDE_BIAS_NV = $8718;
  GL_VIBRANCE_BIAS_NV = $8719;
  GL_TEXTURE_BORDER_VALUES_NV = $871A;
  GL_TEXTURE_HI_SIZE_NV = $871B;
  GL_TEXTURE_LO_SIZE_NV = $871C;
  GL_TEXTURE_DS_SIZE_NV = $871D;
  GL_TEXTURE_DT_SIZE_NV = $871E;
  GL_TEXTURE_MAG_SIZE_NV = $871F;

  // GL_NV_texture_shader2
  GL_DOT_PRODUCT_TEXTURE_3D_NV = $86EF;

  // GL_NV_texture_shader3
  GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV = $8850;
  GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV = $8851;
  GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV = $8852;
  GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV = $8853;
  GL_OFFSET_HILO_TEXTURE_2D_NV = $8854;
  GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV = $8855;
  GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV = $8856;
  GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV = $8857;
  GL_DEPENDENT_HILO_TEXTURE_2D_NV = $8858;
  GL_DEPENDENT_RGB_TEXTURE_3D_NV = $8859;
  GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV = $885A;
  GL_DOT_PRODUCT_PASS_THROUGH_NV = $885B;
  GL_DOT_PRODUCT_TEXTURE_1D_NV = $885C;
  GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV = $885D;
  GL_HILO8_NV = $885E;
  GL_SIGNED_HILO8_NV = $885F;
  GL_FORCE_BLUE_TO_ONE_NV = $8860;

  // GL_NV_vertex_array_range
  GL_VERTEX_ARRAY_RANGE_NV = $851D;
  GL_VERTEX_ARRAY_RANGE_LENGTH_NV = $851E;
  GL_VERTEX_ARRAY_RANGE_VALID_NV = $851F;
  GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV = $8520;
  GL_VERTEX_ARRAY_RANGE_POINTER_NV = $8521;

  // GL_NV_vertex_array_range2
  GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV = $8533;

  // GL_NV_vertex_program
  GL_VERTEX_PROGRAM_NV = $8620;
  GL_VERTEX_STATE_PROGRAM_NV = $8621;
  GL_ATTRIB_ARRAY_SIZE_NV = $8623;
  GL_ATTRIB_ARRAY_STRIDE_NV = $8624;
  GL_ATTRIB_ARRAY_TYPE_NV = $8625;
  GL_CURRENT_ATTRIB_NV = $8626;
  GL_PROGRAM_LENGTH_NV = $8627;
  GL_PROGRAM_STRING_NV = $8628;
  GL_MODELVIEW_PROJECTION_NV = $8629;
  GL_IDENTITY_NV = $862A;
  GL_INVERSE_NV = $862B;
  GL_TRANSPOSE_NV = $862C;
  GL_INVERSE_TRANSPOSE_NV = $862D;
  GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV = $862E;
  GL_MAX_TRACK_MATRICES_NV = $862F;
  GL_MATRIX0_NV = $8630;
  GL_MATRIX1_NV = $8631;
  GL_MATRIX2_NV = $8632;
  GL_MATRIX3_NV = $8633;
  GL_MATRIX4_NV = $8634;
  GL_MATRIX5_NV = $8635;
  GL_MATRIX6_NV = $8636;
  GL_MATRIX7_NV = $8637;
  GL_CURRENT_MATRIX_STACK_DEPTH_NV = $8640;
  GL_CURRENT_MATRIX_NV = $8641;
  GL_VERTEX_PROGRAM_POINT_SIZE_NV = $8642;
  GL_VERTEX_PROGRAM_TWO_SIDE_NV = $8643;
  GL_PROGRAM_PARAMETER_NV = $8644;
  GL_ATTRIB_ARRAY_POINTER_NV = $8645;
  GL_PROGRAM_TARGET_NV = $8646;
  GL_PROGRAM_RESIDENT_NV = $8647;
  GL_TRACK_MATRIX_NV = $8648;
  GL_TRACK_MATRIX_TRANSFORM_NV = $8649;
  GL_VERTEX_PROGRAM_BINDING_NV = $864A;
  GL_PROGRAM_ERROR_POSITION_NV = $864B;
  GL_VERTEX_ATTRIB_ARRAY0_NV = $8650;
  GL_VERTEX_ATTRIB_ARRAY1_NV = $8651;
  GL_VERTEX_ATTRIB_ARRAY2_NV = $8652;
  GL_VERTEX_ATTRIB_ARRAY3_NV = $8653;
  GL_VERTEX_ATTRIB_ARRAY4_NV = $8654;
  GL_VERTEX_ATTRIB_ARRAY5_NV = $8655;
  GL_VERTEX_ATTRIB_ARRAY6_NV = $8656;
  GL_VERTEX_ATTRIB_ARRAY7_NV = $8657;
  GL_VERTEX_ATTRIB_ARRAY8_NV = $8658;
  GL_VERTEX_ATTRIB_ARRAY9_NV = $8659;
  GL_VERTEX_ATTRIB_ARRAY10_NV = $865A;
  GL_VERTEX_ATTRIB_ARRAY11_NV = $865B;
  GL_VERTEX_ATTRIB_ARRAY12_NV = $865C;
  GL_VERTEX_ATTRIB_ARRAY13_NV = $865D;
  GL_VERTEX_ATTRIB_ARRAY14_NV = $865E;
  GL_VERTEX_ATTRIB_ARRAY15_NV = $865F;
  GL_MAP1_VERTEX_ATTRIB0_4_NV = $8660;
  GL_MAP1_VERTEX_ATTRIB1_4_NV = $8661;
  GL_MAP1_VERTEX_ATTRIB2_4_NV = $8662;
  GL_MAP1_VERTEX_ATTRIB3_4_NV = $8663;
  GL_MAP1_VERTEX_ATTRIB4_4_NV = $8664;
  GL_MAP1_VERTEX_ATTRIB5_4_NV = $8665;
  GL_MAP1_VERTEX_ATTRIB6_4_NV = $8666;
  GL_MAP1_VERTEX_ATTRIB7_4_NV = $8667;
  GL_MAP1_VERTEX_ATTRIB8_4_NV = $8668;
  GL_MAP1_VERTEX_ATTRIB9_4_NV = $8669;
  GL_MAP1_VERTEX_ATTRIB10_4_NV = $866A;
  GL_MAP1_VERTEX_ATTRIB11_4_NV = $866B;
  GL_MAP1_VERTEX_ATTRIB12_4_NV = $866C;
  GL_MAP1_VERTEX_ATTRIB13_4_NV = $866D;
  GL_MAP1_VERTEX_ATTRIB14_4_NV = $866E;
  GL_MAP1_VERTEX_ATTRIB15_4_NV = $866F;
  GL_MAP2_VERTEX_ATTRIB0_4_NV = $8670;
  GL_MAP2_VERTEX_ATTRIB1_4_NV = $8671;
  GL_MAP2_VERTEX_ATTRIB2_4_NV = $8672;
  GL_MAP2_VERTEX_ATTRIB3_4_NV = $8673;
  GL_MAP2_VERTEX_ATTRIB4_4_NV = $8674;
  GL_MAP2_VERTEX_ATTRIB5_4_NV = $8675;
  GL_MAP2_VERTEX_ATTRIB6_4_NV = $8676;
  GL_MAP2_VERTEX_ATTRIB7_4_NV = $8677;
  GL_MAP2_VERTEX_ATTRIB8_4_NV = $8678;
  GL_MAP2_VERTEX_ATTRIB9_4_NV = $8679;
  GL_MAP2_VERTEX_ATTRIB10_4_NV = $867A;
  GL_MAP2_VERTEX_ATTRIB11_4_NV = $867B;
  GL_MAP2_VERTEX_ATTRIB12_4_NV = $867C;
  GL_MAP2_VERTEX_ATTRIB13_4_NV = $867D;
  GL_MAP2_VERTEX_ATTRIB14_4_NV = $867E;
  GL_MAP2_VERTEX_ATTRIB15_4_NV = $867F;

  // GL_NV_fragment_program2 and GL_NV_vertex_program2_option
  GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV = $88F4;
  GL_MAX_PROGRAM_CALL_DEPTH_NV = $88F5;

  // GL_NV_fragment_program2
  GL_MAX_PROGRAM_IF_DEPTH_NV = $88F6;
  GL_MAX_PROGRAM_LOOP_DEPTH_NV = $88F7;
  GL_MAX_PROGRAM_LOOP_COUNT_NV = $88F8;

  // GL_NV_vertex_program3
  MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB = $8B4C;

  // GL_OML_interlace
  GL_INTERLACE_OML = $8980;
  GL_INTERLACE_READ_OML = $8981;

  // GL_OML_resample
  GL_PACK_RESAMPLE_OML = $8984;
  GL_UNPACK_RESAMPLE_OML = $8985;
  GL_RESAMPLE_REPLICATE_OML = $8986;
  GL_RESAMPLE_ZERO_FILL_OML = $8987;
  GL_RESAMPLE_AVERAGE_OML = $8988;
  GL_RESAMPLE_DECIMATE_OML = $8989;

  // GL_OML_subsample
  GL_FORMAT_SUBSAMPLE_24_24_OML = $8982;
  GL_FORMAT_SUBSAMPLE_244_244_OML = $8983;

  // GL_PGI_misc_hints
  GL_PREFER_DOUBLEBUFFER_HINT_PGI = $1A1F8;
  GL_CONSERVE_MEMORY_HINT_PGI = $1A1FD;
  GL_RECLAIM_MEMORY_HINT_PGI = $1A1FE;
  GL_NATIVE_GRAPHICS_HANDLE_PGI = $1A202;
  GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI = $1A203;
  GL_NATIVE_GRAPHICS_END_HINT_PGI = $1A204;
  GL_ALWAYS_FAST_HINT_PGI = $1A20C;
  GL_ALWAYS_SOFT_HINT_PGI = $1A20D;
  GL_ALLOW_DRAW_OBJ_HINT_PGI = $1A20E;
  GL_ALLOW_DRAW_WIN_HINT_PGI = $1A20F;
  GL_ALLOW_DRAW_FRG_HINT_PGI = $1A210;
  GL_ALLOW_DRAW_MEM_HINT_PGI = $1A211;
  GL_STRICT_DEPTHFUNC_HINT_PGI = $1A216;
  GL_STRICT_LIGHTING_HINT_PGI = $1A217;
  GL_STRICT_SCISSOR_HINT_PGI = $1A218;
  GL_FULL_STIPPLE_HINT_PGI = $1A219;
  GL_CLIP_NEAR_HINT_PGI = $1A220;
  GL_CLIP_FAR_HINT_PGI = $1A221;
  GL_WIDE_LINE_HINT_PGI = $1A222;
  GL_BACK_NORMALS_HINT_PGI = $1A223;

  // GL_PGI_vertex_hints
  GL_VERTEX_DATA_HINT_PGI = $1A22A;
  GL_VERTEX_CONSISTENT_HINT_PGI = $1A22B;
  GL_MATERIAL_SIDE_HINT_PGI = $1A22C;
  GL_MAX_VERTEX_HINT_PGI = $1A22D;
  GL_COLOR3_BIT_PGI = $00010000;
  GL_COLOR4_BIT_PGI = $00020000;
  GL_EDGEFLAG_BIT_PGI = $00040000;
  GL_INDEX_BIT_PGI = $00080000;
  GL_MAT_AMBIENT_BIT_PGI = $00100000;
  GL_MAT_AMBIENT_AND_DIFFUSE_BIT_PGI = $00200000;
  GL_MAT_DIFFUSE_BIT_PGI = $00400000;
  GL_MAT_EMISSION_BIT_PGI = $00800000;
  GL_MAT_COLOR_INDEXES_BIT_PGI = $01000000;
  GL_MAT_SHININESS_BIT_PGI = $02000000;
  GL_MAT_SPECULAR_BIT_PGI = $04000000;
  GL_NORMAL_BIT_PGI = $08000000;
  GL_TEXCOORD1_BIT_PGI = $10000000;
  GL_TEXCOORD2_BIT_PGI = $20000000;
  GL_TEXCOORD3_BIT_PGI = $40000000;
  GL_TEXCOORD4_BIT_PGI = $80000000;
  GL_VERTEX23_BIT_PGI = $00000004;
  GL_VERTEX4_BIT_PGI = $00000008;

  // GL_REND_screen_coordinates
  GL_SCREEN_COORDINATES_REND = $8490;
  GL_INVERTED_SCREEN_W_REND = $8491;

  // GL_S3_s3tc
  GL_RGB_S3TC = $83A0;
  GL_RGB4_S3TC = $83A1;
  GL_RGBA_S3TC = $83A2;
  GL_RGBA4_S3TC = $83A3;

  // GL_SGIS_detail_texture
  GL_DETAIL_TEXTURE_2D_SGIS = $8095;
  GL_DETAIL_TEXTURE_2D_BINDING_SGIS = $8096;
  GL_LINEAR_DETAIL_SGIS = $8097;
  GL_LINEAR_DETAIL_ALPHA_SGIS = $8098;
  GL_LINEAR_DETAIL_COLOR_SGIS = $8099;
  GL_DETAIL_TEXTURE_LEVEL_SGIS = $809A;
  GL_DETAIL_TEXTURE_MODE_SGIS = $809B;
  GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS = $809C;

  // GL_SGIS_fog_function
  GL_FOG_FUNC_SGIS = $812A;
  GL_FOG_FUNC_POINTS_SGIS = $812B;
  GL_MAX_FOG_FUNC_POINTS_SGIS = $812C;

  // GL_SGIS_generate_mipmap
  GL_GENERATE_MIPMAP_SGIS = $8191;
  GL_GENERATE_MIPMAP_HINT_SGIS = $8192;

  // GL_SGIS_multisample
  GL_MULTISAMPLE_SGIS = $809D;
  GL_SAMPLE_ALPHA_TO_MASK_SGIS = $809E;
  GL_SAMPLE_ALPHA_TO_ONE_SGIS = $809F;
  GL_SAMPLE_MASK_SGIS = $80A0;
  GL_1PASS_SGIS = $80A1;
  GL_2PASS_0_SGIS = $80A2;
  GL_2PASS_1_SGIS = $80A3;
  GL_4PASS_0_SGIS = $80A4;
  GL_4PASS_1_SGIS = $80A5;
  GL_4PASS_2_SGIS = $80A6;
  GL_4PASS_3_SGIS = $80A7;
  GL_SAMPLE_BUFFERS_SGIS = $80A8;
  GL_SAMPLES_SGIS = $80A9;
  GL_SAMPLE_MASK_VALUE_SGIS = $80AA;
  GL_SAMPLE_MASK_INVERT_SGIS = $80AB;
  GL_SAMPLE_PATTERN_SGIS = $80AC;

  // GL_SGIS_pixel_texture
  GL_PIXEL_TEXTURE_SGIS = $8353;
  GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS = $8354;
  GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS = $8355;
  GL_PIXEL_GROUP_COLOR_SGIS = $8356;

  // GL_SGIS_point_line_texgen
  GL_EYE_DISTANCE_TO_POINT_SGIS = $81F0;
  GL_OBJECT_DISTANCE_TO_POINT_SGIS = $81F1;
  GL_EYE_DISTANCE_TO_LINE_SGIS = $81F2;
  GL_OBJECT_DISTANCE_TO_LINE_SGIS = $81F3;
  GL_EYE_POINT_SGIS = $81F4;
  GL_OBJECT_POINT_SGIS = $81F5;
  GL_EYE_LINE_SGIS = $81F6;
  GL_OBJECT_LINE_SGIS = $81F7;

  // GL_SGIS_point_parameters
  GL_POINT_SIZE_MIN_SGIS = $8126;
  GL_POINT_SIZE_MAX_SGIS = $8127;
  GL_POINT_FADE_THRESHOLD_SIZE_SGIS = $8128;
  GL_DISTANCE_ATTENUATION_SGIS = $8129;

  // GL_SGIS_sharpen_texture
  GL_LINEAR_SHARPEN_SGIS = $80AD;
  GL_LINEAR_SHARPEN_ALPHA_SGIS = $80AE;
  GL_LINEAR_SHARPEN_COLOR_SGIS = $80AF;
  GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS = $80B0;

  // GL_SGIS_texture4D
  GL_PACK_SKIP_VOLUMES_SGIS = $8130;
  GL_PACK_IMAGE_DEPTH_SGIS = $8131;
  GL_UNPACK_SKIP_VOLUMES_SGIS = $8132;
  GL_UNPACK_IMAGE_DEPTH_SGIS = $8133;
  GL_TEXTURE_4D_SGIS = $8134;
  GL_PROXY_TEXTURE_4D_SGIS = $8135;
  GL_TEXTURE_4DSIZE_SGIS = $8136;
  GL_TEXTURE_WRAP_Q_SGIS = $8137;
  GL_MAX_4D_TEXTURE_SIZE_SGIS = $8138;
  GL_TEXTURE_4D_BINDING_SGIS = $814F;

  // GL_SGIS_texture_color_mask
  GL_TEXTURE_COLOR_WRITEMASK_SGIS = $81EF;

  // GL_SGIS_texture_edge_clamp
  GL_CLAMP_TO_EDGE_SGIS = $812F;

  // GL_SGIS_texture_filter4
  GL_FILTER4_SGIS = $8146;
  GL_TEXTURE_FILTER4_SIZE_SGIS = $8147;

  // GL_SGIS_texture_lod
  GL_TEXTURE_MIN_LOD_SGIS = $813A;
  GL_TEXTURE_MAX_LOD_SGIS = $813B;
  GL_TEXTURE_BASE_LEVEL_SGIS = $813C;
  GL_TEXTURE_MAX_LEVEL_SGIS = $813D;

  // GL_SGIS_texture_select
  GL_DUAL_ALPHA4_SGIS = $8110;
  GL_DUAL_ALPHA8_SGIS = $8111;
  GL_DUAL_ALPHA12_SGIS = $8112;
  GL_DUAL_ALPHA16_SGIS = $8113;
  GL_DUAL_LUMINANCE4_SGIS = $8114;
  GL_DUAL_LUMINANCE8_SGIS = $8115;
  GL_DUAL_LUMINANCE12_SGIS = $8116;
  GL_DUAL_LUMINANCE16_SGIS = $8117;
  GL_DUAL_INTENSITY4_SGIS = $8118;
  GL_DUAL_INTENSITY8_SGIS = $8119;
  GL_DUAL_INTENSITY12_SGIS = $811A;
  GL_DUAL_INTENSITY16_SGIS = $811B;
  GL_DUAL_LUMINANCE_ALPHA4_SGIS = $811C;
  GL_DUAL_LUMINANCE_ALPHA8_SGIS = $811D;
  GL_QUAD_ALPHA4_SGIS = $811E;
  GL_QUAD_ALPHA8_SGIS = $811F;
  GL_QUAD_LUMINANCE4_SGIS = $8120;
  GL_QUAD_LUMINANCE8_SGIS = $8121;
  GL_QUAD_INTENSITY4_SGIS = $8122;
  GL_QUAD_INTENSITY8_SGIS = $8123;
  GL_DUAL_TEXTURE_SELECT_SGIS = $8124;
  GL_QUAD_TEXTURE_SELECT_SGIS = $8125;

  // GL_SGIX_async
  GL_ASYNC_MARKER_SGIX = $8329;

  // GL_SGIX_async_histogram
  GL_ASYNC_HISTOGRAM_SGIX = $832C;
  GL_MAX_ASYNC_HISTOGRAM_SGIX = $832D;

  // GL_SGIX_async_pixel
  GL_ASYNC_TEX_IMAGE_SGIX = $835C;
  GL_ASYNC_DRAW_PIXELS_SGIX = $835D;
  GL_ASYNC_READ_PIXELS_SGIX = $835E;
  GL_MAX_ASYNC_TEX_IMAGE_SGIX = $835F;
  GL_MAX_ASYNC_DRAW_PIXELS_SGIX = $8360;
  GL_MAX_ASYNC_READ_PIXELS_SGIX = $8361;

  // GL_SGIX_blend_alpha_minmax
  GL_ALPHA_MIN_SGIX = $8320;
  GL_ALPHA_MAX_SGIX = $8321;

  // GL_SGIX_calligraphic_fragment
  GL_CALLIGRAPHIC_FRAGMENT_SGIX = $8183;

  // GL_SGIX_clipmap
  GL_LINEAR_CLIPMAP_LINEAR_SGIX = $8170;
  GL_TEXTURE_CLIPMAP_CENTER_SGIX = $8171;
  GL_TEXTURE_CLIPMAP_FRAME_SGIX = $8172;
  GL_TEXTURE_CLIPMAP_OFFSET_SGIX = $8173;
  GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX = $8174;
  GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX = $8175;
  GL_TEXTURE_CLIPMAP_DEPTH_SGIX = $8176;
  GL_MAX_CLIPMAP_DEPTH_SGIX = $8177;
  GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX = $8178;
  GL_NEAREST_CLIPMAP_NEAREST_SGIX = $844D;
  GL_NEAREST_CLIPMAP_LINEAR_SGIX = $844E;
  GL_LINEAR_CLIPMAP_NEAREST_SGIX = $844F;

  // GL_SGIX_convolution_accuracy
  GL_CONVOLUTION_HINT_SGIX = $8316;

  // GL_SGIX_depth_texture
  GL_DEPTH_COMPONENT16_SGIX = $81A5;
  GL_DEPTH_COMPONENT24_SGIX = $81A6;
  GL_DEPTH_COMPONENT32_SGIX = $81A7;

  // GL_SGIX_fog_offset
  GL_FOG_OFFSET_SGIX = $8198;
  GL_FOG_OFFSET_VALUE_SGIX = $8199;

  // GL_SGIX_fog_scale
  GL_FOG_SCALE_SGIX = $81FC;
  GL_FOG_SCALE_VALUE_SGIX = $81FD;

  // GL_SGIX_fragment_lighting
  GL_FRAGMENT_LIGHTING_SGIX = $8400;
  GL_FRAGMENT_COLOR_MATERIAL_SGIX = $8401;
  GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX = $8402;
  GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX = $8403;
  GL_MAX_FRAGMENT_LIGHTS_SGIX = $8404;
  GL_MAX_ACTIVE_LIGHTS_SGIX = $8405;
  GL_CURRENT_RASTER_NORMAL_SGIX = $8406;
  GL_LIGHT_ENV_MODE_SGIX = $8407;
  GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX = $8408;
  GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX = $8409;
  GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX = $840A;
  GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX = $840B;
  GL_FRAGMENT_LIGHT0_SGIX = $840C;
  GL_FRAGMENT_LIGHT1_SGIX = $840D;
  GL_FRAGMENT_LIGHT2_SGIX = $840E;
  GL_FRAGMENT_LIGHT3_SGIX = $840F;
  GL_FRAGMENT_LIGHT4_SGIX = $8410;
  GL_FRAGMENT_LIGHT5_SGIX = $8411;
  GL_FRAGMENT_LIGHT6_SGIX = $8412;
  GL_FRAGMENT_LIGHT7_SGIX = $8413;

  // GL_SGIX_framezoom
  GL_FRAMEZOOM_SGIX = $818B;
  GL_FRAMEZOOM_FACTOR_SGIX = $818C;
  GL_MAX_FRAMEZOOM_FACTOR_SGIX = $818D;

  // GL_SGIX_impact_pixel_texture
  GL_PIXEL_TEX_GEN_Q_CEILING_SGIX = $8184;
  GL_PIXEL_TEX_GEN_Q_ROUND_SGIX = $8185;
  GL_PIXEL_TEX_GEN_Q_FLOOR_SGIX = $8186;
  GL_PIXEL_TEX_GEN_ALPHA_REPLACE_SGIX = $8187;
  GL_PIXEL_TEX_GEN_ALPHA_NO_REPLACE_SGIX = $8188;
  GL_PIXEL_TEX_GEN_ALPHA_LS_SGIX = $8189;
  GL_PIXEL_TEX_GEN_ALPHA_MS_SGIX = $818A;

  // GL_SGIX_instruments
  GL_INSTRUMENT_BUFFER_POINTER_SGIX = $8180;
  GL_INSTRUMENT_MEASUREMENTS_SGIX = $8181;

  // GL_SGIX_interlace
  GL_INTERLACE_SGIX = $8094;

  // GL_SGIX_ir_instrument1
  GL_IR_INSTRUMENT1_SGIX = $817F;

  // GL_SGIX_list_priority
  GL_LIST_PRIORITY_SGIX = $8182;

  // GL_SGIX_pixel_texture
  GL_PIXEL_TEX_GEN_SGIX = $8139;
  GL_PIXEL_TEX_GEN_MODE_SGIX = $832B;

  // GL_SGIX_pixel_tiles
  GL_PIXEL_TILE_BEST_ALIGNMENT_SGIX = $813E;
  GL_PIXEL_TILE_CACHE_INCREMENT_SGIX = $813F;
  GL_PIXEL_TILE_WIDTH_SGIX = $8140;
  GL_PIXEL_TILE_HEIGHT_SGIX = $8141;
  GL_PIXEL_TILE_GRID_WIDTH_SGIX = $8142;
  GL_PIXEL_TILE_GRID_HEIGHT_SGIX = $8143;
  GL_PIXEL_TILE_GRID_DEPTH_SGIX = $8144;
  GL_PIXEL_TILE_CACHE_SIZE_SGIX = $8145;

  // GL_SGIX_polynomial_ffd
  GL_GEOMETRY_DEFORMATION_SGIX = $8194;
  GL_TEXTURE_DEFORMATION_SGIX = $8195;
  GL_DEFORMATIONS_MASK_SGIX = $8196;
  GL_MAX_DEFORMATION_ORDER_SGIX = $8197;

  // GL_SGIX_reference_plane
  GL_REFERENCE_PLANE_SGIX = $817D;
  GL_REFERENCE_PLANE_EQUATION_SGIX = $817E;

  // GL_SGIX_resample
  GL_PACK_RESAMPLE_SGIX = $842C;
  GL_UNPACK_RESAMPLE_SGIX = $842D;
  GL_RESAMPLE_REPLICATE_SGIX = $842E;
  GL_RESAMPLE_ZERO_FILL_SGIX = $842F;
  GL_RESAMPLE_DECIMATE_SGIX = $8430;

  // GL_SGIX_scalebias_hint
  GL_SCALEBIAS_HINT_SGIX = $8322;

  // GL_SGIX_shadow
  GL_TEXTURE_COMPARE_SGIX = $819A;
  GL_TEXTURE_COMPARE_OPERATOR_SGIX = $819B;
  GL_TEXTURE_LEQUAL_R_SGIX = $819C;
  GL_TEXTURE_GEQUAL_R_SGIX = $819D;

  // GL_SGIX_shadow_ambient
  GL_SHADOW_AMBIENT_SGIX = $80BF;

  // GL_SGIX_sprite
  GL_SPRITE_SGIX = $8148;
  GL_SPRITE_MODE_SGIX = $8149;
  GL_SPRITE_AXIS_SGIX = $814A;
  GL_SPRITE_TRANSLATION_SGIX = $814B;
  GL_SPRITE_AXIAL_SGIX = $814C;
  GL_SPRITE_OBJECT_ALIGNED_SGIX = $814D;
  GL_SPRITE_EYE_ALIGNED_SGIX = $814E;

  // GL_SGIX_subsample
  GL_PACK_SUBSAMPLE_RATE_SGIX = $85A0;
  GL_UNPACK_SUBSAMPLE_RATE_SGIX = $85A1;
  GL_PIXEL_SUBSAMPLE_4444_SGIX = $85A2;
  GL_PIXEL_SUBSAMPLE_2424_SGIX = $85A3;
  GL_PIXEL_SUBSAMPLE_4242_SGIX = $85A4;

  // GL_SGIX_texture_add_env
  GL_TEXTURE_ENV_BIAS_SGIX = $80BE;

  // GL_SGIX_texture_coordinate_clamp
  GL_TEXTURE_MAX_CLAMP_S_SGIX = $8369;
  GL_TEXTURE_MAX_CLAMP_T_SGIX = $836A;
  GL_TEXTURE_MAX_CLAMP_R_SGIX = $836B;

  // GL_SGIX_texture_lod_bias
  GL_TEXTURE_LOD_BIAS_S_SGIX = $818E;
  GL_TEXTURE_LOD_BIAS_T_SGIX = $818F;
  GL_TEXTURE_LOD_BIAS_R_SGIX = $8190;

  // GL_SGIX_texture_multi_buffer
  GL_TEXTURE_MULTI_BUFFER_HINT_SGIX = $812E;

  // GL_SGIX_texture_scale_bias
  GL_POST_TEXTURE_FILTER_BIAS_SGIX = $8179;
  GL_POST_TEXTURE_FILTER_SCALE_SGIX = $817A;
  GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX = $817B;
  GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX = $817C;

  // GL_SGIX_vertex_preclip
  GL_VERTEX_PRECLIP_SGIX = $83EE;
  GL_VERTEX_PRECLIP_HINT_SGIX = $83EF;

  // GL_SGIX_ycrcb
  GL_YCRCB_422_SGIX = $81BB;
  GL_YCRCB_444_SGIX = $81BC;

  // GL_SGIX_ycrcba
  GL_YCRCB_SGIX = $8318;
  GL_YCRCBA_SGIX = $8319;

  // GL_SGI_color_matrix
  GL_COLOR_MATRIX_SGI = $80B1;
  GL_COLOR_MATRIX_STACK_DEPTH_SGI = $80B2;
  GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI = $80B3;
  GL_POST_COLOR_MATRIX_RED_SCALE_SGI = $80B4;
  GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI = $80B5;
  GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI = $80B6;
  GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI = $80B7;
  GL_POST_COLOR_MATRIX_RED_BIAS_SGI = $80B8;
  GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI = $80B9;
  GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI = $80BA;
  GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI = $80BB;

  // GL_SGI_color_table
  GL_COLOR_TABLE_SGI = $80D0;
  GL_POST_CONVOLUTION_COLOR_TABLE_SGI = $80D1;
  GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI = $80D2;
  GL_PROXY_COLOR_TABLE_SGI = $80D3;
  GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI = $80D4;
  GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI = $80D5;
  GL_COLOR_TABLE_SCALE_SGI = $80D6;
  GL_COLOR_TABLE_BIAS_SGI = $80D7;
  GL_COLOR_TABLE_FORMAT_SGI = $80D8;
  GL_COLOR_TABLE_WIDTH_SGI = $80D9;
  GL_COLOR_TABLE_RED_SIZE_SGI = $80DA;
  GL_COLOR_TABLE_GREEN_SIZE_SGI = $80DB;
  GL_COLOR_TABLE_BLUE_SIZE_SGI = $80DC;
  GL_COLOR_TABLE_ALPHA_SIZE_SGI = $80DD;
  GL_COLOR_TABLE_LUMINANCE_SIZE_SGI = $80DE;
  GL_COLOR_TABLE_INTENSITY_SIZE_SGI = $80DF;

  // GL_SGI_depth_pass_instrument
  GL_DEPTH_PASS_INSTRUMENT_SGIX = $8310;
  GL_DEPTH_PASS_INSTRUMENT_COUNTERS_SGIX = $8311;
  GL_DEPTH_PASS_INSTRUMENT_MAX_SGIX = $8312;

  // GL_SGI_texture_color_table
  GL_TEXTURE_COLOR_TABLE_SGI = $80BC;
  GL_PROXY_TEXTURE_COLOR_TABLE_SGI = $80BD;

  // GL_SUNX_constant_data
  GL_UNPACK_CONSTANT_DATA_SUNX = $81D5;
  GL_TEXTURE_CONSTANT_DATA_SUNX = $81D6;

  // GL_SUN_convolution_border_modes
  GL_WRAP_BORDER_SUN = $81D4;

  // GL_SUN_global_alpha
  GL_GLOBAL_ALPHA_SUN = $81D9;
  GL_GLOBAL_ALPHA_FACTOR_SUN = $81DA;

  // GL_SUN_mesh_array
  GL_QUAD_MESH_SUN = $8614;
  GL_TRIANGLE_MESH_SUN = $8615;

  // GL_SUN_slice_accum
  GL_SLICE_ACCUM_SUN = $85CC;

  // GL_SUN_triangle_list
  GL_RESTART_SUN = $0001;
  GL_REPLACE_MIDDLE_SUN = $0002;
  GL_REPLACE_OLDEST_SUN = $0003;
  GL_TRIANGLE_LIST_SUN = $81D7;
  GL_REPLACEMENT_CODE_SUN = $81D8;
  GL_REPLACEMENT_CODE_ARRAY_SUN = $85C0;
  GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN = $85C1;
  GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN = $85C2;
  GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN = $85C3;
  GL_R1UI_V3F_SUN = $85C4;
  GL_R1UI_C4UB_V3F_SUN = $85C5;
  GL_R1UI_C3F_V3F_SUN = $85C6;
  GL_R1UI_N3F_V3F_SUN = $85C7;
  GL_R1UI_C4F_N3F_V3F_SUN = $85C8;
  GL_R1UI_T2F_V3F_SUN = $85C9;
  GL_R1UI_T2F_N3F_V3F_SUN = $85CA;
  GL_R1UI_T2F_C4F_N3F_V3F_SUN = $85CB;

  // GL_WIN_phong_shading
  GL_PHONG_WIN = $80EA;
  GL_PHONG_HINT_WIN = $80EB;

  // GL_WIN_specular_fog
  GL_FOG_SPECULAR_TEXTURE_WIN = $80EC;

   // GL_ARB_vertex_shader
  GL_VERTEX_SHADER_ARB = $8B31;
  GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB = $8B4A;
  GL_MAX_VARYING_FLOATS_ARB = $8B4B;
  GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB = $8B4C;
  GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB = $8B4D;
  GL_OBJECT_ACTIVE_ATTRIBUTES_ARB = $8B89;
  GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB = $8B8A;

  // GL_ARB_fragment_shader
  GL_FRAGMENT_SHADER_ARB = $8B30;
  GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB = $8B49; // 1.4
  GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB = $8B8B; // 1.4

  // GL_ARB_occlusion_query
  GL_SAMPLES_PASSED_ARB = $8914;
  GL_QUERY_COUNTER_BITS_ARB = $8864;
  GL_CURRENT_QUERY_ARB = $8865;
  GL_QUERY_RESULT_ARB = $8866;
  GL_QUERY_RESULT_AVAILABLE_ARB = $8867;

  // GL_ARB_point_sprite
  GL_POINT_SPRITE_ARB = $8861;
  GL_COORD_REPLACE_ARB = $8862;

  // GL_ARB_shading_language_100
  GL_SHADING_LANGUAGE_VERSION_ARB = $8B8C; // 1.4

  // GL_ARB_shader_objects
  GL_PROGRAM_OBJECT_ARB = $8B40;

  GL_OBJECT_TYPE_ARB = $8B4E;
  GL_OBJECT_SUBTYPE_ARB = $8B4F;
  GL_OBJECT_DELETE_STATUS_ARB = $8B80;
  GL_OBJECT_COMPILE_STATUS_ARB = $8B81;
  GL_OBJECT_LINK_STATUS_ARB = $8B82;
  GL_OBJECT_VALIDATE_STATUS_ARB = $8B83;
  GL_OBJECT_INFO_LOG_LENGTH_ARB = $8B84;
  GL_OBJECT_ATTACHED_OBJECTS_ARB = $8B85;
  GL_OBJECT_ACTIVE_UNIFORMS_ARB = $8B86;
  GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB = $8B87;
  GL_OBJECT_SHADER_SOURCE_LENGTH_ARB = $8B88;

  GL_SHADER_OBJECT_ARB = $8B48;

  GL_FLOAT_VEC2_ARB = $8B50;
  GL_FLOAT_VEC3_ARB = $8B51;
  GL_FLOAT_VEC4_ARB = $8B52;
  GL_INT_VEC2_ARB = $8B53;
  GL_INT_VEC3_ARB = $8B54;
  GL_INT_VEC4_ARB = $8B55;
  GL_BOOL_ARB = $8B56;
  GL_BOOL_VEC2_ARB = $8B57;
  GL_BOOL_VEC3_ARB = $8B58;
  GL_BOOL_VEC4_ARB = $8B59;
  GL_FLOAT_MAT2_ARB = $8B5A;
  GL_FLOAT_MAT3_ARB = $8B5B;
  GL_FLOAT_MAT4_ARB = $8B5C;

  // Update for glsl-specification 1.10
  GL_SAMPLER_1D_ARB = $8B5D; // 1.4
  GL_SAMPLER_2D_ARB = $8B5E; // 1.4
  GL_SAMPLER_3D_ARB = $8B5F; // 1.4
  GL_SAMPLER_CUBE_ARB = $8B60; // 1.4
  GL_SAMPLER_1D_SHADOW_ARB = $8B61; // 1.4
  GL_SAMPLER_2D_SHADOW_ARB = $8B62; // 1.4
  GL_SAMPLER_2D_RECT_ARB = $8B63; // 1.4
  GL_SAMPLER_2D_RECT_SHADOW_ARB = $8B64; // 1.4

  // WGL_3DFX_multisample
  WGL_SAMPLE_BUFFERS_3DFX = $2060;
  WGL_SAMPLES_3DFX = $2061;

  // WGL_ARB_buffer_region
  WGL_FRONT_COLOR_BUFFER_BIT_ARB = $00000001;
  WGL_BACK_COLOR_BUFFER_BIT_ARB = $00000002;
  WGL_DEPTH_BUFFER_BIT_ARB = $00000004;
  WGL_STENCIL_BUFFER_BIT_ARB = $00000008;

  // WGL_ARB_make_current_read
  ERROR_INVALID_PIXEL_TYPE_ARB = $2043;
  ERROR_INCOMPATIBLE_DEVICE_CONTEXTS_ARB = $2054;

  // WGL_ARB_multisample
  WGL_SAMPLE_BUFFERS_ARB = $2041;
  WGL_SAMPLES_ARB = $2042;

  // WGL_ARB_pbuffer
  WGL_DRAW_TO_PBUFFER_ARB = $202D;
  WGL_MAX_PBUFFER_PIXELS_ARB = $202E;
  WGL_MAX_PBUFFER_WIDTH_ARB = $202F;
  WGL_MAX_PBUFFER_HEIGHT_ARB = $2030;
  WGL_PBUFFER_LARGEST_ARB = $2033;
  WGL_PBUFFER_WIDTH_ARB = $2034;
  WGL_PBUFFER_HEIGHT_ARB = $2035;
  WGL_PBUFFER_LOST_ARB = $2036;

  // WGL_ARB_pixel_format
  WGL_NUMBER_PIXEL_FORMATS_ARB = $2000;
  WGL_DRAW_TO_WINDOW_ARB = $2001;
  WGL_DRAW_TO_BITMAP_ARB = $2002;
  WGL_ACCELERATION_ARB = $2003;
  WGL_NEED_PALETTE_ARB = $2004;
  WGL_NEED_SYSTEM_PALETTE_ARB = $2005;
  WGL_SWAP_LAYER_BUFFERS_ARB = $2006;
  WGL_SWAP_METHOD_ARB = $2007;
  WGL_NUMBER_OVERLAYS_ARB = $2008;
  WGL_NUMBER_UNDERLAYS_ARB = $2009;
  WGL_TRANSPARENT_ARB = $200A;
  WGL_TRANSPARENT_RED_VALUE_ARB = $2037;
  WGL_TRANSPARENT_GREEN_VALUE_ARB = $2038;
  WGL_TRANSPARENT_BLUE_VALUE_ARB = $2039;
  WGL_TRANSPARENT_ALPHA_VALUE_ARB = $203A;
  WGL_TRANSPARENT_INDEX_VALUE_ARB = $203B;
  WGL_SHARE_DEPTH_ARB = $200C;
  WGL_SHARE_STENCIL_ARB = $200D;
  WGL_SHARE_ACCUM_ARB = $200E;
  WGL_SUPPORT_GDI_ARB = $200F;
  WGL_SUPPORT_OPENGL_ARB = $2010;
  WGL_DOUBLE_BUFFER_ARB = $2011;
  WGL_STEREO_ARB = $2012;
  WGL_PIXEL_TYPE_ARB = $2013;
  WGL_COLOR_BITS_ARB = $2014;
  WGL_RED_BITS_ARB = $2015;
  WGL_RED_SHIFT_ARB = $2016;
  WGL_GREEN_BITS_ARB = $2017;
  WGL_GREEN_SHIFT_ARB = $2018;
  WGL_BLUE_BITS_ARB = $2019;
  WGL_BLUE_SHIFT_ARB = $201A;
  WGL_ALPHA_BITS_ARB = $201B;
  WGL_ALPHA_SHIFT_ARB = $201C;
  WGL_ACCUM_BITS_ARB = $201D;
  WGL_ACCUM_RED_BITS_ARB = $201E;
  WGL_ACCUM_GREEN_BITS_ARB = $201F;
  WGL_ACCUM_BLUE_BITS_ARB = $2020;
  WGL_ACCUM_ALPHA_BITS_ARB = $2021;
  WGL_DEPTH_BITS_ARB = $2022;
  WGL_STENCIL_BITS_ARB = $2023;
  WGL_AUX_BUFFERS_ARB = $2024;
  WGL_NO_ACCELERATION_ARB = $2025;
  WGL_GENERIC_ACCELERATION_ARB = $2026;
  WGL_FULL_ACCELERATION_ARB = $2027;
  WGL_SWAP_EXCHANGE_ARB = $2028;
  WGL_SWAP_COPY_ARB = $2029;
  WGL_SWAP_UNDEFINED_ARB = $202A;
  WGL_TYPE_RGBA_ARB = $202B;
  WGL_TYPE_COLORINDEX_ARB = $202C;

  // WGL_ARB_pixel_format_float
  WGL_RGBA_FLOAT_MODE_ARB = $8820;
  WGL_CLAMP_VERTEX_COLOR_ARB = $891A;
  WGL_CLAMP_FRAGMENT_COLOR_ARB = $891B;
  WGL_CLAMP_READ_COLOR_ARB = $891C;
  WGL_FIXED_ONLY_ARB = $891D;

  // WGL_ARB_render_texture
  WGL_BIND_TO_TEXTURE_RGB_ARB = $2070;
  WGL_BIND_TO_TEXTURE_RGBA_ARB = $2071;
  WGL_TEXTURE_FORMAT_ARB = $2072;
  WGL_TEXTURE_TARGET_ARB = $2073;
  WGL_MIPMAP_TEXTURE_ARB = $2074;
  WGL_TEXTURE_RGB_ARB = $2075;
  WGL_TEXTURE_RGBA_ARB = $2076;
  WGL_NO_TEXTURE_ARB = $2077;
  WGL_TEXTURE_CUBE_MAP_ARB = $2078;
  WGL_TEXTURE_1D_ARB = $2079;
  WGL_TEXTURE_2D_ARB = $207A;
  WGL_MIPMAP_LEVEL_ARB = $207B;
  WGL_CUBE_MAP_FACE_ARB = $207C;
  WGL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB = $207D;
  WGL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB = $207E;
  WGL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB = $207F;
  WGL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB = $2080;
  WGL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB = $2081;
  WGL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB = $2082;
  WGL_FRONT_LEFT_ARB = $2083;
  WGL_FRONT_RIGHT_ARB = $2084;
  WGL_BACK_LEFT_ARB = $2085;
  WGL_BACK_RIGHT_ARB = $2086;
  WGL_AUX0_ARB = $2087;
  WGL_AUX1_ARB = $2088;
  WGL_AUX2_ARB = $2089;
  WGL_AUX3_ARB = $208A;
  WGL_AUX4_ARB = $208B;
  WGL_AUX5_ARB = $208C;
  WGL_AUX6_ARB = $208D;
  WGL_AUX7_ARB = $208E;
  WGL_AUX8_ARB = $208F;
  WGL_AUX9_ARB = $2090;

  // WGL_ATI_pixel_format_float
  WGL_TYPE_RGBA_FLOAT_ATI = $21A0;
  GL_TYPE_RGBA_FLOAT_ATI = $8820;
  GL_COLOR_CLEAR_UNCLAMPED_VALUE_ATI = $8835;

  // WGL_EXT_depth_float
  WGL_DEPTH_FLOAT_EXT = $2040;

  // WGL_EXT_make_current_read
  ERROR_INVALID_PIXEL_TYPE_EXT = $2043;

  // WGL_EXT_multisample
  WGL_SAMPLE_BUFFERS_EXT = $2041;
  WGL_SAMPLES_EXT = $2042;

  // WGL_EXT_pbuffer
  WGL_DRAW_TO_PBUFFER_EXT = $202D;
  WGL_MAX_PBUFFER_PIXELS_EXT = $202E;
  WGL_MAX_PBUFFER_WIDTH_EXT = $202F;
  WGL_MAX_PBUFFER_HEIGHT_EXT = $2030;
  WGL_OPTIMAL_PBUFFER_WIDTH_EXT = $2031;
  WGL_OPTIMAL_PBUFFER_HEIGHT_EXT = $2032;
  WGL_PBUFFER_LARGEST_EXT = $2033;
  WGL_PBUFFER_WIDTH_EXT = $2034;
  WGL_PBUFFER_HEIGHT_EXT = $2035;

  // WGL_EXT_pixel_format
  WGL_NUMBER_PIXEL_FORMATS_EXT = $2000;
  WGL_DRAW_TO_WINDOW_EXT = $2001;
  WGL_DRAW_TO_BITMAP_EXT = $2002;
  WGL_ACCELERATION_EXT = $2003;
  WGL_NEED_PALETTE_EXT = $2004;
  WGL_NEED_SYSTEM_PALETTE_EXT = $2005;
  WGL_SWAP_LAYER_BUFFERS_EXT = $2006;
  WGL_SWAP_METHOD_EXT = $2007;
  WGL_NUMBER_OVERLAYS_EXT = $2008;
  WGL_NUMBER_UNDERLAYS_EXT = $2009;
  WGL_TRANSPARENT_EXT = $200A;
  WGL_TRANSPARENT_VALUE_EXT = $200B;
  WGL_SHARE_DEPTH_EXT = $200C;
  WGL_SHARE_STENCIL_EXT = $200D;
  WGL_SHARE_ACCUM_EXT = $200E;
  WGL_SUPPORT_GDI_EXT = $200F;
  WGL_SUPPORT_OPENGL_EXT = $2010;
  WGL_DOUBLE_BUFFER_EXT = $2011;
  WGL_STEREO_EXT = $2012;
  WGL_PIXEL_TYPE_EXT = $2013;
  WGL_COLOR_BITS_EXT = $2014;
  WGL_RED_BITS_EXT = $2015;
  WGL_RED_SHIFT_EXT = $2016;
  WGL_GREEN_BITS_EXT = $2017;
  WGL_GREEN_SHIFT_EXT = $2018;
  WGL_BLUE_BITS_EXT = $2019;
  WGL_BLUE_SHIFT_EXT = $201A;
  WGL_ALPHA_BITS_EXT = $201B;
  WGL_ALPHA_SHIFT_EXT = $201C;
  WGL_ACCUM_BITS_EXT = $201D;
  WGL_ACCUM_RED_BITS_EXT = $201E;
  WGL_ACCUM_GREEN_BITS_EXT = $201F;
  WGL_ACCUM_BLUE_BITS_EXT = $2020;
  WGL_ACCUM_ALPHA_BITS_EXT = $2021;
  WGL_DEPTH_BITS_EXT = $2022;
  WGL_STENCIL_BITS_EXT = $2023;
  WGL_AUX_BUFFERS_EXT = $2024;
  WGL_NO_ACCELERATION_EXT = $2025;
  WGL_GENERIC_ACCELERATION_EXT = $2026;
  WGL_FULL_ACCELERATION_EXT = $2027;
  WGL_SWAP_EXCHANGE_EXT = $2028;
  WGL_SWAP_COPY_EXT = $2029;
  WGL_SWAP_UNDEFINED_EXT = $202A;
  WGL_TYPE_RGBA_EXT = $202B;
  WGL_TYPE_COLORINDEX_EXT = $202C;

  // WGL_I3D_digital_video_control
  WGL_DIGITAL_VIDEO_CURSOR_ALPHA_FRAMEBUFFER_I3D = $2050;
  WGL_DIGITAL_VIDEO_CURSOR_ALPHA_VALUE_I3D = $2051;
  WGL_DIGITAL_VIDEO_CURSOR_INCLUDED_I3D = $2052;
  WGL_DIGITAL_VIDEO_GAMMA_CORRECTED_I3D = $2053;

  // WGL_I3D_gamma
  WGL_GAMMA_TABLE_SIZE_I3D = $204E;
  WGL_GAMMA_EXCLUDE_DESKTOP_I3D = $204F;

  // WGL_I3D_genlock
  WGL_GENLOCK_SOURCE_MULTIVIEW_I3D = $2044;
  WGL_GENLOCK_SOURCE_EXTENAL_SYNC_I3D = $2045;
  WGL_GENLOCK_SOURCE_EXTENAL_FIELD_I3D = $2046;
  WGL_GENLOCK_SOURCE_EXTENAL_TTL_I3D = $2047;
  WGL_GENLOCK_SOURCE_DIGITAL_SYNC_I3D = $2048;
  WGL_GENLOCK_SOURCE_DIGITAL_FIELD_I3D = $2049;
  WGL_GENLOCK_SOURCE_EDGE_FALLING_I3D = $204A;
  WGL_GENLOCK_SOURCE_EDGE_RISING_I3D = $204B;
  WGL_GENLOCK_SOURCE_EDGE_BOTH_I3D = $204C;

  // WGL_I3D_image_buffer
  WGL_IMAGE_BUFFER_MIN_ACCESS_I3D = $00000001;
  WGL_IMAGE_BUFFER_LOCK_I3D = $00000002;

  // WGL_NV_float_buffer
  WGL_FLOAT_COMPONENTS_NV = $20B0;
  WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_R_NV = $20B1;
  WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_RG_NV = $20B2;
  WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_RGB_NV = $20B3;
  WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_RGBA_NV = $20B4;
  WGL_TEXTURE_FLOAT_R_NV = $20B5;
  WGL_TEXTURE_FLOAT_RG_NV = $20B6;
  WGL_TEXTURE_FLOAT_RGB_NV = $20B7;
  WGL_TEXTURE_FLOAT_RGBA_NV = $20B8;

  // WGL_NV_render_depth_texture
  WGL_BIND_TO_TEXTURE_DEPTH_NV = $20A3;
  WGL_BIND_TO_TEXTURE_RECTANGLE_DEPTH_NV = $20A4;
  WGL_DEPTH_TEXTURE_FORMAT_NV = $20A5;
  WGL_TEXTURE_DEPTH_COMPONENT_NV = $20A6;
  WGL_DEPTH_COMPONENT_NV = $20A7;

  // WGL_NV_render_texture_rectangle
  WGL_BIND_TO_TEXTURE_RECTANGLE_RGB_NV = $20A0;
  WGL_BIND_TO_TEXTURE_RECTANGLE_RGBA_NV = $20A1;
  WGL_TEXTURE_RECTANGLE_NV = $20A2;

  // WIN_draw_range_elements
  GL_MAX_ELEMENTS_VERTICES_WIN = $80E8;
  GL_MAX_ELEMENTS_INDICES_WIN = $80E9;

  // GLU
  GLU_INVALID_ENUM = 100900;
  GLU_INVALID_VALUE = 100901;
  GLU_OUT_OF_MEMORY = 100902;
  GLU_INCOMPATIBLE_GL_VERSION = 100903;
  GLU_VERSION = 100800;
  GLU_EXTENSIONS = 100801;
  GLU_TRUE = GL_TRUE;
  GLU_FALSE = GL_FALSE;
  GLU_SMOOTH = 100000;
  GLU_FLAT = 100001;
  GLU_NONE = 100002;
  GLU_POINT = 100010;
  GLU_LINE = 100011;
  GLU_FILL = 100012;
  GLU_SILHOUETTE = 100013;
  GLU_OUTSIDE = 100020;
  GLU_INSIDE = 100021;
  GLU_TESS_MAX_COORD = 1.0E150;
  GLU_TESS_WINDING_RULE = 100140;
  GLU_TESS_BOUNDARY_ONLY = 100141;
  GLU_TESS_TOLERANCE = 100142;
  GLU_TESS_WINDING_ODD = 100130;
  GLU_TESS_WINDING_NONZERO = 100131;
  GLU_TESS_WINDING_POSITIVE = 100132;
  GLU_TESS_WINDING_NEGATIVE = 100133;
  GLU_TESS_WINDING_ABS_GEQ_TWO = 100134;
  GLU_TESS_BEGIN = 100100; // TGLUTessBeginProc
  GLU_TESS_VERTEX = 100101; // TGLUTessVertexProc
  GLU_TESS_END = 100102; // TGLUTessEndProc
  GLU_TESS_ERROR = 100103; // TGLUTessErrorProc
  GLU_TESS_EDGE_FLAG = 100104; // TGLUTessEdgeFlagProc
  GLU_TESS_COMBINE = 100105; // TGLUTessCombineProc
  GLU_TESS_BEGIN_DATA = 100106; // TGLUTessBeginDataProc
  GLU_TESS_VERTEX_DATA = 100107; // TGLUTessVertexDataProc
  GLU_TESS_END_DATA = 100108; // TGLUTessEndDataProc
  GLU_TESS_ERROR_DATA = 100109; // TGLUTessErrorDataProc
  GLU_TESS_EDGE_FLAG_DATA = 100110; // TGLUTessEdgeFlagDataProc
  GLU_TESS_COMBINE_DATA = 100111; // TGLUTessCombineDataProc
  GLU_TESS_ERROR1 = 100151;
  GLU_TESS_ERROR2 = 100152;
  GLU_TESS_ERROR3 = 100153;
  GLU_TESS_ERROR4 = 100154;
  GLU_TESS_ERROR5 = 100155;
  GLU_TESS_ERROR6 = 100156;
  GLU_TESS_ERROR7 = 100157;
  GLU_TESS_ERROR8 = 100158;
  GLU_TESS_MISSING_BEGIN_POLYGON = GLU_TESS_ERROR1;
  GLU_TESS_MISSING_BEGIN_CONTOUR = GLU_TESS_ERROR2;
  GLU_TESS_MISSING_END_POLYGON = GLU_TESS_ERROR3;
  GLU_TESS_MISSING_END_CONTOUR = GLU_TESS_ERROR4;
  GLU_TESS_COORD_TOO_LARGE = GLU_TESS_ERROR5;
  GLU_TESS_NEED_COMBINE_CALLBACK = GLU_TESS_ERROR6;
  GLU_AUTO_LOAD_MATRIX = 100200;
  GLU_CULLING = 100201;
  GLU_SAMPLING_TOLERANCE = 100203;
  GLU_DISPLAY_MODE = 100204;
  GLU_PARAMETRIC_TOLERANCE = 100202;
  GLU_SAMPLING_METHOD = 100205;
  GLU_U_STEP = 100206;
  GLU_V_STEP = 100207;
  GLU_PATH_LENGTH = 100215;
  GLU_PARAMETRIC_ERROR = 100216;
  GLU_DOMAIN_DISTANCE = 100217;
  GLU_MAP1_TRIM_2 = 100210;
  GLU_MAP1_TRIM_3 = 100211;
  GLU_OUTLINE_POLYGON = 100240;
  GLU_OUTLINE_PATCH = 100241;
  GLU_NURBS_ERROR1 = 100251;
  GLU_NURBS_ERROR2 = 100252;
  GLU_NURBS_ERROR3 = 100253;
  GLU_NURBS_ERROR4 = 100254;
  GLU_NURBS_ERROR5 = 100255;
  GLU_NURBS_ERROR6 = 100256;
  GLU_NURBS_ERROR7 = 100257;
  GLU_NURBS_ERROR8 = 100258;
  GLU_NURBS_ERROR9 = 100259;
  GLU_NURBS_ERROR10 = 100260;
  GLU_NURBS_ERROR11 = 100261;
  GLU_NURBS_ERROR12 = 100262;
  GLU_NURBS_ERROR13 = 100263;
  GLU_NURBS_ERROR14 = 100264;
  GLU_NURBS_ERROR15 = 100265;
  GLU_NURBS_ERROR16 = 100266;
  GLU_NURBS_ERROR17 = 100267;
  GLU_NURBS_ERROR18 = 100268;
  GLU_NURBS_ERROR19 = 100269;
  GLU_NURBS_ERROR20 = 100270;
  GLU_NURBS_ERROR21 = 100271;
  GLU_NURBS_ERROR22 = 100272;
  GLU_NURBS_ERROR23 = 100273;
  GLU_NURBS_ERROR24 = 100274;
  GLU_NURBS_ERROR25 = 100275;
  GLU_NURBS_ERROR26 = 100276;
  GLU_NURBS_ERROR27 = 100277;
  GLU_NURBS_ERROR28 = 100278;
  GLU_NURBS_ERROR29 = 100279;
  GLU_NURBS_ERROR30 = 100280;
  GLU_NURBS_ERROR31 = 100281;
  GLU_NURBS_ERROR32 = 100282;
  GLU_NURBS_ERROR33 = 100283;
  GLU_NURBS_ERROR34 = 100284;
  GLU_NURBS_ERROR35 = 100285;
  GLU_NURBS_ERROR36 = 100286;
  GLU_NURBS_ERROR37 = 100287;
  GLU_CW = 100120;
  GLU_CCW = 100121;
  GLU_INTERIOR = 100122;
  GLU_EXTERIOR = 100123;
  GLU_UNKNOWN = 100124;
  GLU_BEGIN = GLU_TESS_BEGIN;
  GLU_VERTEX = GLU_TESS_VERTEX;
  GLU_END = GLU_TESS_END;
  GLU_ERROR = GLU_TESS_ERROR;
  GLU_EDGE_FLAG = GLU_TESS_EDGE_FLAG;

type
  // GL_VERSION_1_1
  TglAccum = procedure(op: TGLenum; value: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglAlphaFunc = procedure(func: TGLenum; ref: TGLclampf); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglAreTexturesResident = function(n: TGLsizei; const textures: PGLuint; residences: PGLboolean): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglArrayElement = procedure(i: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBegin = procedure(mode: TGLenum); {$IFNDEF CLR}{$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}{$ENDIF}
  TglBindTexture = procedure(target: TGLenum; texture: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBitmap = procedure(width: TGLsizei; height: TGLsizei; xorig: TGLfloat; yorig: TGLfloat; xmove: TGLfloat; ymove: TGLfloat; const bitmap: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBlendFunc = procedure(sfactor: TGLenum; dfactor: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCallList = procedure(list: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCallLists = procedure(n: TGLsizei; _type: TGLenum; const lists: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglClear = procedure(mask: TGLbitfield); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglClearAccum = procedure(red: TGLfloat; green: TGLfloat; blue: TGLfloat; alpha: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglClearColor = procedure(red: TGLclampf; green: TGLclampf; blue: TGLclampf; alpha: TGLclampf); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglClearDepth = procedure(depth: TGLclampd); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglClearIndex = procedure(c: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglClearStencil = procedure(s: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglClipPlane = procedure(plane: TGLenum; const equation: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor3b = procedure(red: TGLbyte; green: TGLbyte; blue: TGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor3bv = procedure(const v: PGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor3d = procedure(red: TGLdouble; green: TGLdouble; blue: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor3dv = procedure(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor3f = procedure(red: TGLfloat; green: TGLfloat; blue: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor3fv = procedure(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor3i = procedure(red: TGLint; green: TGLint; blue: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor3iv = procedure(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor3s = procedure(red: TGLshort; green: TGLshort; blue: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor3sv = procedure(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor3ub = procedure(red: TGLubyte; green: TGLubyte; blue: TGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor3ubv = procedure(const v: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor3ui = procedure(red: TGLuint; green: TGLuint; blue: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor3uiv = procedure(const v: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor3us = procedure(red: TGLushort; green: TGLushort; blue: TGLushort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor3usv = procedure(const v: PGLushort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor4b = procedure(red: TGLbyte; green: TGLbyte; blue: TGLbyte; alpha: TGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor4bv = procedure(const v: PGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor4d = procedure(red: TGLdouble; green: TGLdouble; blue: TGLdouble; alpha: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor4dv = procedure(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor4f = procedure(red: TGLfloat; green: TGLfloat; blue: TGLfloat; alpha: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor4fv = procedure(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor4i = procedure(red: TGLint; green: TGLint; blue: TGLint; alpha: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor4iv = procedure(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor4s = procedure(red: TGLshort; green: TGLshort; blue: TGLshort; alpha: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor4sv = procedure(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor4ub = procedure(red: TGLubyte; green: TGLubyte; blue: TGLubyte; alpha: TGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor4ubv = procedure(const v: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor4ui = procedure(red: TGLuint; green: TGLuint; blue: TGLuint; alpha: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor4uiv = procedure(const v: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor4us = procedure(red: TGLushort; green: TGLushort; blue: TGLushort; alpha: TGLushort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor4usv = procedure(const v: PGLushort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColorMask = procedure(red: TGLboolean; green: TGLboolean; blue: TGLboolean; alpha: TGLboolean); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColorMaterial = procedure(face: TGLenum; mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColorPointer = procedure(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCopyPixels = procedure(x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei; _type: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCopyTexImage1D = procedure(target: TGLenum; level: TGLint; internalFormat: TGLenum; x: TGLint; y: TGLint; width: TGLsizei; border: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCopyTexImage2D = procedure(target: TGLenum; level: TGLint; internalFormat: TGLenum; x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei; border: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCopyTexSubImage1D = procedure(target: TGLenum; level: TGLint; xoffset: TGLint; x: TGLint; y: TGLint; width: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCopyTexSubImage2D = procedure(target: TGLenum; level: TGLint; xoffset: TGLint; yoffset: TGLint; x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCullFace = procedure(mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDeleteLists = procedure(list: TGLuint; range: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDeleteTextures = procedure(n: TGLsizei; const textures: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDepthFunc = procedure(func: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDepthMask = procedure(flag: TGLboolean); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDepthRange = procedure(zNear: TGLclampd; zFar: TGLclampd); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDisable = procedure(cap: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDisableClientState = procedure(_array: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDrawArrays = procedure(mode: TGLenum; first: TGLint; count: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDrawBuffer = procedure(mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDrawElements = procedure(mode: TGLenum; count: TGLsizei; _type: TGLenum; const indices: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDrawPixels = procedure(width: TGLsizei; height: TGLsizei; format: TGLenum; _type: TGLenum; const pixels: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEdgeFlag = procedure(flag: TGLboolean); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEdgeFlagPointer = procedure(stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEdgeFlagv = procedure(const flag: PGLboolean); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEnable = procedure(cap: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEnableClientState = procedure(_array: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEnd = procedure(); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEndList = procedure(); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEvalCoord1d = procedure(u: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEvalCoord1dv = procedure(const u: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEvalCoord1f = procedure(u: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEvalCoord1fv = procedure(const u: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEvalCoord2d = procedure(u: TGLdouble; v: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEvalCoord2dv = procedure(const u: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEvalCoord2f = procedure(u: TGLfloat; v: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEvalCoord2fv = procedure(const u: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEvalMesh1 = procedure(mode: TGLenum; i1: TGLint; i2: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEvalMesh2 = procedure(mode: TGLenum; i1: TGLint; i2: TGLint; j1: TGLint; j2: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEvalPoint1 = procedure(i: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEvalPoint2 = procedure(i: TGLint; j: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFeedbackBuffer = procedure(size: TGLsizei; _type: TGLenum; buffer: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFinish = procedure(); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFlush = procedure(); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFogf = procedure(pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFogfv = procedure(pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFogi = procedure(pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFogiv = procedure(pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFrontFace = procedure(mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFrustum = procedure(left: TGLdouble; right: TGLdouble; bottom: TGLdouble; top: TGLdouble; zNear: TGLdouble; zFar: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGenLists = function(range: TGLsizei): TGLuint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGenTextures = procedure(n: TGLsizei; textures: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetBooleanv = procedure(pname: TGLenum; params: PGLboolean); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetClipPlane = procedure(plane: TGLenum; equation: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetDoublev = procedure(pname: TGLenum; params: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetError = function(): TGLenum; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetFloatv = procedure(pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetIntegerv = procedure(pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetLightfv = procedure(light: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetLightiv = procedure(light: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetMapdv = procedure(target: TGLenum; query: TGLenum; v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetMapfv = procedure(target: TGLenum; query: TGLenum; v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetMapiv = procedure(target: TGLenum; query: TGLenum; v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetMaterialfv = procedure(face: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetMaterialiv = procedure(face: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetPixelMapfv = procedure(map: TGLenum; values: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetPixelMapuiv = procedure(map: TGLenum; values: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetPixelMapusv = procedure(map: TGLenum; values: PGLushort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetPointerv = procedure(pname: TGLenum; params: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetPolygonStipple = procedure(mask: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$IFDEF CLR}
  TglGetString = function(name: TGLenum): IntPtr; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ELSE}
  TglGetString = function(name: TGLenum): PChar; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ENDIF}

  TglGetTexEnvfv = procedure(target: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetTexEnviv = procedure(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetTexGendv = procedure(coord: TGLenum; pname: TGLenum; params: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetTexGenfv = procedure(coord: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetTexGeniv = procedure(coord: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetTexImage = procedure(target: TGLenum; level: TGLint; format: TGLenum; _type: TGLenum; pixels: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetTexLevelParameterfv = procedure(target: TGLenum; level: TGLint; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetTexLevelParameteriv = procedure(target: TGLenum; level: TGLint; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetTexParameterfv = procedure(target: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetTexParameteriv = procedure(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglHint = procedure(target: TGLenum; mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIndexMask = procedure(mask: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIndexPointer = procedure(_type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIndexd = procedure(c: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIndexdv = procedure(const c: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIndexf = procedure(c: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIndexfv = procedure(const c: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIndexi = procedure(c: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIndexiv = procedure(const c: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIndexs = procedure(c: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIndexsv = procedure(const c: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIndexub = procedure(c: TGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIndexubv = procedure(const c: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglInitNames = procedure(); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglInterleavedArrays = procedure(format: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIsEnabled = function(cap: TGLenum): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIsList = function(list: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIsTexture = function(texture: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglLightModelf = procedure(pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglLightModelfv = procedure(pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglLightModeli = procedure(pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglLightModeliv = procedure(pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglLightf = procedure(light: TGLenum; pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglLightfv = procedure(light: TGLenum; pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglLighti = procedure(light: TGLenum; pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglLightiv = procedure(light: TGLenum; pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglLineStipple = procedure(factor: TGLint; pattern: TGLushort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglLineWidth = procedure(width: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglListBase = procedure(base: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglLoadIdentity = procedure(); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglLoadMatrixd = procedure(const m: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglLoadMatrixf = procedure(const m: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglLoadName = procedure(name: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglLogicOp = procedure(opcode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMap1d = procedure(target: TGLenum; u1: TGLdouble; u2: TGLdouble; stride: TGLint; order: TGLint; const points: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMap1f = procedure(target: TGLenum; u1: TGLfloat; u2: TGLfloat; stride: TGLint; order: TGLint; const points: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMap2d = procedure(target: TGLenum; u1: TGLdouble; u2: TGLdouble; ustride: TGLint; uorder: TGLint; v1: TGLdouble; v2: TGLdouble; vstride: TGLint; vorder: TGLint; const points: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMap2f = procedure(target: TGLenum; u1: TGLfloat; u2: TGLfloat; ustride: TGLint; uorder: TGLint; v1: TGLfloat; v2: TGLfloat; vstride: TGLint; vorder: TGLint; const points: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMapGrid1d = procedure(un: TGLint; u1: TGLdouble; u2: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMapGrid1f = procedure(un: TGLint; u1: TGLfloat; u2: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMapGrid2d = procedure(un: TGLint; u1: TGLdouble; u2: TGLdouble; vn: TGLint; v1: TGLdouble; v2: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMapGrid2f = procedure(un: TGLint; u1: TGLfloat; u2: TGLfloat; vn: TGLint; v1: TGLfloat; v2: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMaterialf = procedure(face: TGLenum; pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMaterialfv = procedure(face: TGLenum; pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMateriali = procedure(face: TGLenum; pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMaterialiv = procedure(face: TGLenum; pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMatrixMode = procedure(mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultMatrixd = procedure(const m: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultMatrixf = procedure(const m: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNewList = procedure(list: TGLuint; mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormal3b = procedure(nx: TGLbyte; ny: TGLbyte; nz: TGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormal3bv = procedure(const v: PGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormal3d = procedure(nx: TGLdouble; ny: TGLdouble; nz: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormal3dv = procedure(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormal3f = procedure(nx: TGLfloat; ny: TGLfloat; nz: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormal3fv = procedure(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormal3i = procedure(nx: TGLint; ny: TGLint; nz: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormal3iv = procedure(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormal3s = procedure(nx: TGLshort; ny: TGLshort; nz: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormal3sv = procedure(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormalPointer = procedure(_type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglOrtho = procedure(left: TGLdouble; right: TGLdouble; bottom: TGLdouble; top: TGLdouble; zNear: TGLdouble; zFar: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPassThrough = procedure(token: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPixelMapfv = procedure(map: TGLenum; mapsize: TGLsizei; const values: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPixelMapuiv = procedure(map: TGLenum; mapsize: TGLsizei; const values: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPixelMapusv = procedure(map: TGLenum; mapsize: TGLsizei; const values: PGLushort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPixelStoref = procedure(pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPixelStorei = procedure(pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPixelTransferf = procedure(pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPixelTransferi = procedure(pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPixelZoom = procedure(xfactor: TGLfloat; yfactor: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPointSize = procedure(size: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPolygonMode = procedure(face: TGLenum; mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPolygonOffset = procedure(factor: TGLfloat; units: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPolygonStipple = procedure(const mask: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPopAttrib = procedure(); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPopClientAttrib = procedure(); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPopMatrix = procedure(); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPopName = procedure(); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPrioritizeTextures = procedure(n: TGLsizei; const textures: PGLuint; const priorities: PGLclampf); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPushAttrib = procedure(mask: TGLbitfield); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPushClientAttrib = procedure(mask: TGLbitfield); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPushMatrix = procedure(); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPushName = procedure(name: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRasterPos2d = procedure(x: TGLdouble; y: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRasterPos2dv = procedure(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRasterPos2f = procedure(x: TGLfloat; y: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRasterPos2fv = procedure(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRasterPos2i = procedure(x: TGLint; y: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRasterPos2iv = procedure(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRasterPos2s = procedure(x: TGLshort; y: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRasterPos2sv = procedure(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRasterPos3d = procedure(x: TGLdouble; y: TGLdouble; z: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRasterPos3dv = procedure(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRasterPos3f = procedure(x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRasterPos3fv = procedure(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRasterPos3i = procedure(x: TGLint; y: TGLint; z: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRasterPos3iv = procedure(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRasterPos3s = procedure(x: TGLshort; y: TGLshort; z: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRasterPos3sv = procedure(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRasterPos4d = procedure(x: TGLdouble; y: TGLdouble; z: TGLdouble; w: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRasterPos4dv = procedure(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRasterPos4f = procedure(x: TGLfloat; y: TGLfloat; z: TGLfloat; w: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRasterPos4fv = procedure(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRasterPos4i = procedure(x: TGLint; y: TGLint; z: TGLint; w: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRasterPos4iv = procedure(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRasterPos4s = procedure(x: TGLshort; y: TGLshort; z: TGLshort; w: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRasterPos4sv = procedure(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReadBuffer = procedure(mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReadPixels = procedure(x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei; format: TGLenum; _type: TGLenum; pixels: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRectd = procedure(x1: TGLdouble; y1: TGLdouble; x2: TGLdouble; y2: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRectdv = procedure(const v1: PGLdouble; const v2: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRectf = procedure(x1: TGLfloat; y1: TGLfloat; x2: TGLfloat; y2: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRectfv = procedure(const v1: PGLfloat; const v2: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRecti = procedure(x1: TGLint; y1: TGLint; x2: TGLint; y2: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRectiv = procedure(const v1: PGLint; const v2: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRects = procedure(x1: TGLshort; y1: TGLshort; x2: TGLshort; y2: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRectsv = procedure(const v1: PGLshort; const v2: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRenderMode = function(mode: TGLenum): TGLint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRotated = procedure(angle: TGLdouble; x: TGLdouble; y: TGLdouble; z: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRotatef = procedure(angle: TGLfloat; x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglScaled = procedure(x: TGLdouble; y: TGLdouble; z: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglScalef = procedure(x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglScissor = procedure(x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSelectBuffer = procedure(size: TGLsizei; buffer: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglShadeModel = procedure(mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglStencilFunc = procedure(func: TGLenum; ref: TGLint; mask: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglStencilMask = procedure(mask: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglStencilOp = procedure(fail: TGLenum; zfail: TGLenum; zpass: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord1d = procedure(s: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord1dv = procedure(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord1f = procedure(s: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord1fv = procedure(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord1i = procedure(s: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord1iv = procedure(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord1s = procedure(s: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord1sv = procedure(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord2d = procedure(s: TGLdouble; t: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord2dv = procedure(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord2f = procedure(s: TGLfloat; t: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord2fv = procedure(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord2i = procedure(s: TGLint; t: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord2iv = procedure(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord2s = procedure(s: TGLshort; t: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord2sv = procedure(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord3d = procedure(s: TGLdouble; t: TGLdouble; r: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord3dv = procedure(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord3f = procedure(s: TGLfloat; t: TGLfloat; r: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord3fv = procedure(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord3i = procedure(s: TGLint; t: TGLint; r: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord3iv = procedure(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord3s = procedure(s: TGLshort; t: TGLshort; r: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord3sv = procedure(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord4d = procedure(s: TGLdouble; t: TGLdouble; r: TGLdouble; q: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord4dv = procedure(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord4f = procedure(s: TGLfloat; t: TGLfloat; r: TGLfloat; q: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord4fv = procedure(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord4i = procedure(s: TGLint; t: TGLint; r: TGLint; q: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord4iv = procedure(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord4s = procedure(s: TGLshort; t: TGLshort; r: TGLshort; q: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord4sv = procedure(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoordPointer = procedure(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexEnvf = procedure(target: TGLenum; pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexEnvfv = procedure(target: TGLenum; pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexEnvi = procedure(target: TGLenum; pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexEnviv = procedure(target: TGLenum; pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexGend = procedure(coord: TGLenum; pname: TGLenum; param: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexGendv = procedure(coord: TGLenum; pname: TGLenum; const params: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexGenf = procedure(coord: TGLenum; pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexGenfv = procedure(coord: TGLenum; pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexGeni = procedure(coord: TGLenum; pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexGeniv = procedure(coord: TGLenum; pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexImage1D = procedure(target: TGLenum; level: TGLint; internalformat: TGLint; width: TGLsizei; border: TGLint; format: TGLenum; _type: TGLenum; const pixels: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexImage2D = procedure(target: TGLenum; level: TGLint; internalformat: TGLint; width: TGLsizei; height: TGLsizei; border: TGLint; format: TGLenum; _type: TGLenum; const pixels: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexParameterf = procedure(target: TGLenum; pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexParameterfv = procedure(target: TGLenum; pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexParameteri = procedure(target: TGLenum; pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexParameteriv = procedure(target: TGLenum; pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexSubImage1D = procedure(target: TGLenum; level: TGLint; xoffset: TGLint; width: TGLsizei; format: TGLenum; _type: TGLenum; const pixels: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexSubImage2D = procedure(target: TGLenum; level: TGLint; xoffset: TGLint; yoffset: TGLint; width: TGLsizei; height: TGLsizei; format: TGLenum; _type: TGLenum; const pixels: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTranslated = procedure(x: TGLdouble; y: TGLdouble; z: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTranslatef = procedure(x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex2d = procedure(x: TGLdouble; y: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex2dv = procedure(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex2f = procedure(x: TGLfloat; y: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex2fv = procedure(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex2i = procedure(x: TGLint; y: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex2iv = procedure(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex2s = procedure(x: TGLshort; y: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex2sv = procedure(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex3d = procedure(x: TGLdouble; y: TGLdouble; z: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex3dv = procedure(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex3f = procedure(x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex3fv = procedure(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex3i = procedure(x: TGLint; y: TGLint; z: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex3iv = procedure(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex3s = procedure(x: TGLshort; y: TGLshort; z: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex3sv = procedure(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex4d = procedure(x: TGLdouble; y: TGLdouble; z: TGLdouble; w: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex4dv = procedure(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex4f = procedure(x: TGLfloat; y: TGLfloat; z: TGLfloat; w: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex4fv = procedure(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex4i = procedure(x: TGLint; y: TGLint; z: TGLint; w: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex4iv = procedure(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex4s = procedure(x: TGLshort; y: TGLshort; z: TGLshort; w: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex4sv = procedure(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexPointer = procedure(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglViewport = procedure(x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_VERSION_1_2
  TglBlendColor = procedure(red: TGLclampf; green: TGLclampf; blue: TGLclampf; alpha: TGLclampf); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBlendEquation = procedure(mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDrawRangeElements = procedure(mode: TGLenum; start: TGLuint; _end: TGLuint; count: TGLsizei; _type: TGLenum; const indices: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColorTable = procedure(target: TGLenum; internalformat: TGLenum; width: TGLsizei; format: TGLenum; _type: TGLenum; const table: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColorTableParameterfv = procedure(target: TGLenum; pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColorTableParameteriv = procedure(target: TGLenum; pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCopyColorTable = procedure(target: TGLenum; internalformat: TGLenum; x: TGLint; y: TGLint; width: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetColorTable = procedure(target: TGLenum; format: TGLenum; _type: TGLenum; table: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetColorTableParameterfv = procedure(target: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetColorTableParameteriv = procedure(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColorSubTable = procedure(target: TGLenum; start: TGLsizei; count: TGLsizei; format: TGLenum; _type: TGLenum; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCopyColorSubTable = procedure(target: TGLenum; start: TGLsizei; x: TGLint; y: TGLint; width: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglConvolutionFilter1D = procedure(target: TGLenum; internalformat: TGLenum; width: TGLsizei; format: TGLenum; _type: TGLenum; const image: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglConvolutionFilter2D = procedure(target: TGLenum; internalformat: TGLenum; width: TGLsizei; height: TGLsizei; format: TGLenum; _type: TGLenum; const image: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglConvolutionParameterf = procedure(target: TGLenum; pname: TGLenum; params: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglConvolutionParameterfv = procedure(target: TGLenum; pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglConvolutionParameteri = procedure(target: TGLenum; pname: TGLenum; params: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglConvolutionParameteriv = procedure(target: TGLenum; pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCopyConvolutionFilter1D = procedure(target: TGLenum; internalformat: TGLenum; x: TGLint; y: TGLint; width: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCopyConvolutionFilter2D = procedure(target: TGLenum; internalformat: TGLenum; x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetConvolutionFilter = procedure(target: TGLenum; format: TGLenum; _type: TGLenum; image: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetConvolutionParameterfv = procedure(target: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetConvolutionParameteriv = procedure(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetSeparableFilter = procedure(target: TGLenum; format: TGLenum; _type: TGLenum; row: PGLvoid; column: PGLvoid; span: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSeparableFilter2D = procedure(target: TGLenum; internalformat: TGLenum; width: TGLsizei; height: TGLsizei; format: TGLenum; _type: TGLenum; const row: PGLvoid; const column: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetHistogram = procedure(target: TGLenum; reset: TGLboolean; format: TGLenum; _type: TGLenum; values: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetHistogramParameterfv = procedure(target: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetHistogramParameteriv = procedure(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetMinmax = procedure(target: TGLenum; reset: TGLboolean; format: TGLenum; _type: TGLenum; values: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetMinmaxParameterfv = procedure(target: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetMinmaxParameteriv = procedure(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglHistogram = procedure(target: TGLenum; width: TGLsizei; internalformat: TGLenum; sink: TGLboolean); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMinmax = procedure(target: TGLenum; internalformat: TGLenum; sink: TGLboolean); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglResetHistogram = procedure(target: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglResetMinmax = procedure(target: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexImage3D = procedure(target: TGLenum; level: TGLint; internalformat: TGLint; width: TGLsizei; height: TGLsizei; depth: TGLsizei; border: TGLint; format: TGLenum; _type: TGLenum; const pixels: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexSubImage3D = procedure(target: TGLenum; level: TGLint; xoffset: TGLint; yoffset: TGLint; zoffset: TGLint; width: TGLsizei; height: TGLsizei; depth: TGLsizei; format: TGLenum; _type: TGLenum; const pixels: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCopyTexSubImage3D = procedure(target: TGLenum; level: TGLint; xoffset: TGLint; yoffset: TGLint; zoffset: TGLint; x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_VERSION_1_3
  TglActiveTexture = procedure(texture: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglClientActiveTexture = procedure(texture: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord1d = procedure(target: TGLenum; s: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord1dv = procedure(target: TGLenum; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord1f = procedure(target: TGLenum; s: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord1fv = procedure(target: TGLenum; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord1i = procedure(target: TGLenum; s: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord1iv = procedure(target: TGLenum; const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord1s = procedure(target: TGLenum; s: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord1sv = procedure(target: TGLenum; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord2d = procedure(target: TGLenum; s: TGLdouble; t: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord2dv = procedure(target: TGLenum; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord2f = procedure(target: TGLenum; s: TGLfloat; t: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord2fv = procedure(target: TGLenum; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord2i = procedure(target: TGLenum; s: TGLint; t: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord2iv = procedure(target: TGLenum; const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord2s = procedure(target: TGLenum; s: TGLshort; t: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord2sv = procedure(target: TGLenum; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord3d = procedure(target: TGLenum; s: TGLdouble; t: TGLdouble; r: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord3dv = procedure(target: TGLenum; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord3f = procedure(target: TGLenum; s: TGLfloat; t: TGLfloat; r: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord3fv = procedure(target: TGLenum; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord3i = procedure(target: TGLenum; s: TGLint; t: TGLint; r: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord3iv = procedure(target: TGLenum; const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord3s = procedure(target: TGLenum; s: TGLshort; t: TGLshort; r: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord3sv = procedure(target: TGLenum; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord4d = procedure(target: TGLenum; s: TGLdouble; t: TGLdouble; r: TGLdouble; q: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord4dv = procedure(target: TGLenum; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord4f = procedure(target: TGLenum; s: TGLfloat; t: TGLfloat; r: TGLfloat; q: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord4fv = procedure(target: TGLenum; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord4i = procedure(target: TGLenum; s: TGLint; t: TGLint; r: TGLint; q: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord4iv = procedure(target: TGLenum; const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord4s = procedure(target: TGLenum; s: TGLshort; t: TGLshort; r: TGLshort; q: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord4sv = procedure(target: TGLenum; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglLoadTransposeMatrixf = procedure(const m: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglLoadTransposeMatrixd = procedure(const m: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultTransposeMatrixf = procedure(const m: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultTransposeMatrixd = procedure(const m: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSampleCoverage = procedure(value: TGLclampf; invert: TGLboolean); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCompressedTexImage3D = procedure(target: TGLenum; level: TGLint; internalformat: TGLenum; width: TGLsizei; height: TGLsizei; depth: TGLsizei; border: TGLint; imageSize: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCompressedTexImage2D = procedure(target: TGLenum; level: TGLint; internalformat: TGLenum; width: TGLsizei; height: TGLsizei; border: TGLint; imageSize: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCompressedTexImage1D = procedure(target: TGLenum; level: TGLint; internalformat: TGLenum; width: TGLsizei; border: TGLint; imageSize: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCompressedTexSubImage3D = procedure(target: TGLenum; level: TGLint; xoffset: TGLint; yoffset: TGLint; zoffset: TGLint; width: TGLsizei; height: TGLsizei; depth: TGLsizei; format: TGLenum; imageSize: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCompressedTexSubImage2D = procedure(target: TGLenum; level: TGLint; xoffset: TGLint; yoffset: TGLint; width: TGLsizei; height: TGLsizei; format: TGLenum; imageSize: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCompressedTexSubImage1D = procedure(target: TGLenum; level: TGLint; xoffset: TGLint; width: TGLsizei; format: TGLenum; imageSize: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetCompressedTexImage = procedure(target: TGLenum; level: TGLint; img: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_VERSION_1_4
  TglBlendFuncSeparate = procedure(sfactorRGB: TGLenum; dfactorRGB: TGLenum; sfactorAlpha: TGLenum; dfactorAlpha: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFogCoordf = procedure(coord: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFogCoordfv = procedure(const coord: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFogCoordd = procedure(coord: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFogCoorddv = procedure(const coord: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFogCoordPointer = procedure(_type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiDrawArrays = procedure(mode: TGLenum; first: PGLint; count: PGLsizei; primcount: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiDrawElements = procedure(mode: TGLenum; const count: PGLsizei; _type: TGLenum; const indices: PGLvoid; primcount: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPointParameterf = procedure(pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPointParameterfv = procedure(pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPointParameteri = procedure(pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPointParameteriv = procedure(pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3b = procedure(red: TGLbyte; green: TGLbyte; blue: TGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3bv = procedure(const v: PGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3d = procedure(red: TGLdouble; green: TGLdouble; blue: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3dv = procedure(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3f = procedure(red: TGLfloat; green: TGLfloat; blue: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3fv = procedure(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3i = procedure(red: TGLint; green: TGLint; blue: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3iv = procedure(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3s = procedure(red: TGLshort; green: TGLshort; blue: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3sv = procedure(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3ub = procedure(red: TGLubyte; green: TGLubyte; blue: TGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3ubv = procedure(const v: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3ui = procedure(red: TGLuint; green: TGLuint; blue: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3uiv = procedure(const v: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3us = procedure(red: TGLushort; green: TGLushort; blue: TGLushort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3usv = procedure(const v: PGLushort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColorPointer = procedure(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos2d = procedure(x: TGLdouble; y: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos2dv = procedure(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos2f = procedure(x: TGLfloat; y: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos2fv = procedure(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos2i = procedure(x: TGLint; y: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos2iv = procedure(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos2s = procedure(x: TGLshort; y: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos2sv = procedure(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos3d = procedure(x: TGLdouble; y: TGLdouble; z: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos3dv = procedure(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos3f = procedure(x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos3fv = procedure(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos3i = procedure(x: TGLint; y: TGLint; z: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos3iv = procedure(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos3s = procedure(x: TGLshort; y: TGLshort; z: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos3sv = procedure(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_VERSION_1_5
  TglGenQueries = procedure(n: GLsizei; ids: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDeleteQueries = procedure(n: GLsizei; const ids: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIsQuery = function(id: GLuint): boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBeginQuery = procedure(target: GLenum; id: GLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEndQuery = procedure(target: GLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetQueryiv = procedure(target, pname: GLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetQueryObjectiv = procedure(id: GLuint; pname: GLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetQueryObjectuiv = procedure(id: GLuint; pname: GLenum; params: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  TglBindBuffer = procedure(target: TGLenum; buffer: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDeleteBuffers = procedure(n: TGLsizei; const buffers: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGenBuffers = procedure(n: TGLsizei; buffers: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIsBuffer = function(buffer: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBufferData = procedure(target: TGLenum; size: TGLsizei; const data: PGLvoid; usage: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBufferSubData = procedure(target: TGLenum; offset: TGLsizei; size: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetBufferSubData = procedure(target: TGLenum; offset: TGLsizei; size: TGLsizei; data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMapBuffer = function(target: TGLenum; access: TGLenum): PGLvoid; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUnmapBuffer = function(target: TGLenum): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetBufferParameteriv = procedure(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetBufferPointerv = procedure(target: TGLenum; pname: TGLenum; params: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_VERSION_2_0
  TglBlendEquationSeparate = procedure(modeRGB: GLenum; modeAlpha: GLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDrawBuffers = procedure(n: GLsizei; const bufs: PGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglStencilOpSeparate = procedure(face: GLenum; sfail: GLenum; dpfail: GLenum; dppass: GLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglStencilFuncSeparate = procedure(frontfunc: GLenum; backfunc: GLenum; ref: GLint; mask: GLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglStencilMaskSeparate = procedure(face: GLenum; mask: GLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglAttachShader = procedure(programObj, shaderObj: GLhandle); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBindAttribLocation = procedure(programObj: GLhandle; index: GLuint; name: PChar); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCompileShader = procedure(shaderObj: GLhandle); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCreateProgram = function: GLhandle; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCreateShader = function(shaderType: GLenum): GLhandle; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDeleteProgram = procedure(programObj: GLhandle); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDeleteShader = procedure(shaderObj: GLhandle); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDetachShader = procedure(programObj, shaderObj: GLhandle); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDisableVertexAttribArray = procedure(index: GLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEnableVertexAttribArray = procedure(index: GLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetActiveAttrib = procedure(programObj: GLhandle; index: GLuint; maxlength: GLsizei; var length: GLint; var _type: GLenum; name: PChar); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetActiveUniform = procedure(programObj: GLhandle; index: GLuint; maxLength: GLsizei; var length: GLsizei; var size: GLint; var _type: GLenum; name: PChar); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetAttachedShaders = procedure(programObj: GLhandle; MaxCount: GLsizei; var Count: GLint; shaders: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetAttribLocation = function(programObj: GLhandle; char: string): glint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetProgramiv = procedure(programObj: GLhandle; pname: TGLenum; params: PGLInt); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$IFDEF CLR}
  TglGetProgramInfoLog = procedure(programObj: GLHandle; maxLength: glsizei; var length: GLint; infoLog: StringBuilder); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ELSE}
  TglGetProgramInfoLog = procedure(programObj: GLHandle; maxLength: glsizei; var length: GLint; infoLog: PChar); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ENDIF}
  TglGetShaderiv = procedure(shaderObj: GLhandle; pname: TGLenum; params: PGLInt); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$IFDEF CLR}
  TglGetShaderInfoLog = procedure(shaderObj: GLHandle; maxLength: glsizei; var length: glint; infoLog: StringBuilder); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ELSE}
  TglGetShaderInfoLog = procedure(shaderObj: GLHandle; maxLength: glsizei; var length: glint; infoLog: PChar); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ENDIF}
  TglGetShaderSource = procedure(shaderObj: GLhandle; maxlength: GLsizei; var length: GLsizei; source: PChar); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetUniformLocation = function(programObj: GLhandle; const char: PChar): glint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetUniformfv = procedure(programObj: GLhandle; location: GLint; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetUniformiv = procedure(programObj: GLhandle; location: GLint; params: PGLInt); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetVertexAttribfv = procedure(index: GLuint; pname: GLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetVertexAttribiv = procedure(index: GLuint; pname: GLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetVertexAttribPointerv = procedure(index: GLuint; pname: GLenum; _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIsProgram = function(programObj: GLhandle) : TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIsShader = function(shaderObj: GLhandle) : TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglLinkProgram = procedure(programObj: GLHandle); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$IFDEF CLR}
  TglShaderSource = procedure(shaderObj: GLHandle; count: glsizei; _string: array of string; lengths: pglint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ELSE}
  TglShaderSource = procedure(shaderObj: GLHandle; count: glsizei; _string: PPGLChar; lengths: pglint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ENDIF}
  TglUseProgram = procedure(programObj: GLhandle); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform1f = procedure(location: GLint; v0: GLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform2f = procedure(location: GLint; v0, v1: GLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform3f = procedure(location: GLint; v0, v1, v2: GLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform4f = procedure(location: GLint; v0, v1, v2, v3: GLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform1i = procedure(location: GLint; v0: GLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform2i = procedure(location: GLint; v0, v1: GLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform3i = procedure(location: GLint; v0, v1, v2: GLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform4i = procedure(location: GLint; v0, v1, v2, v3: GLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform1fv = procedure(location: GLint; count: GLsizei; value: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform2fv = procedure(location: GLint; count: GLsizei; value: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform3fv = procedure(location: GLint; count: GLsizei; value: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform4fv = procedure(location: GLint; count: GLsizei; value: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform1iv = procedure(location: GLint; count: GLsizei; value: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform2iv = procedure(location: GLint; count: GLsizei; value: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform3iv = procedure(location: GLint; count: GLsizei; value: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform4iv = procedure(location: GLint; count: GLsizei; value: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniformMatrix2fv = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniformMatrix3fv = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniformMatrix4fv = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglValidateProgram = procedure(programObj: GLhandle); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib1d = procedure(index: GLuint; x: GLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib1dv = procedure(index: GLuint; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib1f = procedure(index: GLuint; x: GLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib1fv = procedure(index: GLuint; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib1s = procedure(index: GLuint; x: GLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib1sv = procedure(index: GLuint; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib2d = procedure(index: GLuint; x: GLdouble; y: GLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib2dv = procedure(index: GLuint; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib2f = procedure(index: GLuint; x: GLfloat; y: GLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib2fv = procedure(index: GLuint; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib2s = procedure(index: GLuint; x: GLshort; y: GLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib2sv = procedure(index: GLuint; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib3d = procedure(index: GLuint; x: GLdouble; y: GLdouble; z: GLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib3dv = procedure(index: GLuint; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib3f = procedure(index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib3fv = procedure(index: GLuint; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib3s = procedure(index: GLuint; x: GLshort; y: GLshort; z: GLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib3sv = procedure(index: GLuint; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4Nbv = procedure(index: GLuint; const v: PGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4Niv = procedure(index: GLuint; const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4Nsv = procedure(index: GLuint; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4Nub = procedure(index: GLuint; x: GLubyte; y: GLubyte; z: GLubyte; w: GLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4Nubv = procedure(index: GLuint; const v: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4Nuiv = procedure(index: GLuint; const v: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4Nusv = procedure(index: GLuint; const v: PGLushort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4bv = procedure(index: GLuint; const v: PGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4d = procedure(index: GLuint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4dv = procedure(index: GLuint; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4f = procedure(index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4fv = procedure(index: GLuint; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4iv = procedure(index: GLuint; const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4s = procedure(index: GLuint; x: GLshort; y: GLshort; z: GLshort; w: GLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4sv = procedure(index: GLuint; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4ubv = procedure(index: GLuint; const v: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4uiv = procedure(index: GLuint; const v: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4usv = procedure(index: GLuint; const v: PGLushort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttribPointer = procedure(index: GLuint; size: GLint; _type: GLenum; normalized: GLboolean; stride: GLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_3DFX_tbuffer
  TglTbufferMask3DFX = procedure(mask: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_APPLE_element_array
  TglElementPointerAPPLE = procedure(_type: TGLenum; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDrawElementArrayAPPLE = procedure(mode: TGLenum; first: TGLint; count: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDrawRangeElementArrayAPPLE = procedure(mode: TGLenum; start: TGLuint; _end: TGLuint; first: TGLint; count: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiDrawElementArrayAPPLE = procedure(mode: TGLenum; const first: PGLint; const count: PGLsizei; primcount: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiDrawRangeElementArrayAPPLE = procedure(mode: TGLenum; start: TGLuint; _end: TGLuint; const first: PGLint; const count: PGLsizei; primcount: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_APPLE_fence
  TglGenFencesAPPLE = procedure(n: TGLsizei; fences: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDeleteFencesAPPLE = procedure(n: TGLsizei; const fences: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSetFenceAPPLE = procedure(fence: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIsFenceAPPLE = function(fence: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTestFenceAPPLE = function(fence: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFinishFenceAPPLE = procedure(fence: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTestObjectAPPLE = function(_object: TGLenum; name: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFinishObjectAPPLE = procedure(_object: TGLenum; name: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_APPLE_vertex_array_object
  TglBindVertexArrayAPPLE = procedure(_array: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDeleteVertexArraysAPPLE = procedure(n: TGLsizei; const arrays: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGenVertexArraysAPPLE = procedure(n: TGLsizei; const arrays: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIsVertexArrayAPPLE = function(_array: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_APPLE_vertex_array_range
  TglVertexArrayRangeAPPLE = procedure(length: TGLsizei; _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFlushVertexArrayRangeAPPLE = procedure(length: TGLsizei; _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexArrayParameteriAPPLE = procedure(pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_ARB_matrix_palette
  TglCurrentPaletteMatrixARB = procedure(index: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMatrixIndexubvARB = procedure(size: TGLint; const indices: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMatrixIndexusvARB = procedure(size: TGLint; const indices: PGLushort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMatrixIndexuivARB = procedure(size: TGLint; const indices: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMatrixIndexPointerARB = procedure(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_ARB_multisample
  TglSampleCoverageARB = procedure(value: TGLclampf; invert: TGLboolean); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_ARB_multitexture
  TglActiveTextureARB = procedure(texture: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglClientActiveTextureARB = procedure(texture: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord1dARB = procedure(target: TGLenum; s: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord1dvARB = procedure(target: TGLenum; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord1fARB = procedure(target: TGLenum; s: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord1fvARB = procedure(target: TGLenum; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord1iARB = procedure(target: TGLenum; s: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord1ivARB = procedure(target: TGLenum; const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord1sARB = procedure(target: TGLenum; s: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord1svARB = procedure(target: TGLenum; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord2dARB = procedure(target: TGLenum; s: TGLdouble; t: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord2dvARB = procedure(target: TGLenum; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord2fARB = procedure(target: TGLenum; s: TGLfloat; t: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord2fvARB = procedure(target: TGLenum; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord2iARB = procedure(target: TGLenum; s: TGLint; t: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord2ivARB = procedure(target: TGLenum; const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord2sARB = procedure(target: TGLenum; s: TGLshort; t: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord2svARB = procedure(target: TGLenum; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord3dARB = procedure(target: TGLenum; s: TGLdouble; t: TGLdouble; r: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord3dvARB = procedure(target: TGLenum; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord3fARB = procedure(target: TGLenum; s: TGLfloat; t: TGLfloat; r: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord3fvARB = procedure(target: TGLenum; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord3iARB = procedure(target: TGLenum; s: TGLint; t: TGLint; r: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord3ivARB = procedure(target: TGLenum; const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord3sARB = procedure(target: TGLenum; s: TGLshort; t: TGLshort; r: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord3svARB = procedure(target: TGLenum; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord4dARB = procedure(target: TGLenum; s: TGLdouble; t: TGLdouble; r: TGLdouble; q: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord4dvARB = procedure(target: TGLenum; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord4fARB = procedure(target: TGLenum; s: TGLfloat; t: TGLfloat; r: TGLfloat; q: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord4fvARB = procedure(target: TGLenum; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord4iARB = procedure(target: TGLenum; s: TGLint; t: TGLint; r: TGLint; q: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord4ivARB = procedure(target: TGLenum; const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord4sARB = procedure(target: TGLenum; s: TGLshort; t: TGLshort; r: TGLshort; q: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord4svARB = procedure(target: TGLenum; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_ARB_point_parameters
  TglPointParameterfARB = procedure(pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPointParameterfvARB = procedure(pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_ARB_texture_compression
  TglCompressedTexImage3DARB = procedure(target: TGLenum; level: TGLint; internalformat: TGLenum; width: TGLsizei; height: TGLsizei; depth: TGLsizei; border: TGLint; imageSize: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCompressedTexImage2DARB = procedure(target: TGLenum; level: TGLint; internalformat: TGLenum; width: TGLsizei; height: TGLsizei; border: TGLint; imageSize: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCompressedTexImage1DARB = procedure(target: TGLenum; level: TGLint; internalformat: TGLenum; width: TGLsizei; border: TGLint; imageSize: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCompressedTexSubImage3DARB = procedure(target: TGLenum; level: TGLint; xoffset: TGLint; yoffset: TGLint; zoffset: TGLint; width: TGLsizei; height: TGLsizei; depth: TGLsizei; format: TGLenum; imageSize: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCompressedTexSubImage2DARB = procedure(target: TGLenum; level: TGLint; xoffset: TGLint; yoffset: TGLint; width: TGLsizei; height: TGLsizei; format: TGLenum; imageSize: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCompressedTexSubImage1DARB = procedure(target: TGLenum; level: TGLint; xoffset: TGLint; width: TGLsizei; format: TGLenum; imageSize: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetCompressedTexImageARB = procedure(target: TGLenum; level: TGLint; img: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_ARB_transpose_matrix
  TglLoadTransposeMatrixfARB = procedure(const m: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglLoadTransposeMatrixdARB = procedure(const m: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultTransposeMatrixfARB = procedure(const m: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultTransposeMatrixdARB = procedure(const m: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_ARB_vertex_blend
  TglWeightbvARB = procedure(size: TGLint; const weights: PGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWeightsvARB = procedure(size: TGLint; const weights: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWeightivARB = procedure(size: TGLint; const weights: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWeightfvARB = procedure(size: TGLint; const weights: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWeightdvARB = procedure(size: TGLint; const weights: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWeightubvARB = procedure(size: TGLint; const weights: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWeightusvARB = procedure(size: TGLint; const weights: PGLushort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWeightuivARB = procedure(size: TGLint; const weights: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWeightPointerARB = procedure(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexBlendARB = procedure(count: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_ARB_vertex_buffer_object
  TglBindBufferARB = procedure(target: TGLenum; buffer: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDeleteBuffersARB = procedure(n: TGLsizei; const buffers: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGenBuffersARB = procedure(n: TGLsizei; buffers: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIsBufferARB = function(buffer: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBufferDataARB = procedure(target: TGLenum; size: TGLsizei; const data: PGLvoid; usage: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBufferSubDataARB = procedure(target: TGLenum; offset: TGLsizei; size: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetBufferSubDataARB = procedure(target: TGLenum; offset: TGLsizei; size: TGLsizei; data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMapBufferARB = function(target: TGLenum; access: TGLenum): PGLvoid; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUnmapBufferARB = function(target: TGLenum): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetBufferParameterivARB = procedure(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetBufferPointervARB = procedure(target: TGLenum; pname: TGLenum; params: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_ARB_vertex_program
  TglVertexAttrib1dARB = procedure(index: TGLuint; x: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib1dvARB = procedure(index: TGLuint; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib1fARB = procedure(index: TGLuint; x: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib1fvARB = procedure(index: TGLuint; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib1sARB = procedure(index: TGLuint; x: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib1svARB = procedure(index: TGLuint; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib2dARB = procedure(index: TGLuint; x: TGLdouble; y: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib2dvARB = procedure(index: TGLuint; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib2fARB = procedure(index: TGLuint; x: TGLfloat; y: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib2fvARB = procedure(index: TGLuint; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib2sARB = procedure(index: TGLuint; x: TGLshort; y: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib2svARB = procedure(index: TGLuint; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib3dARB = procedure(index: TGLuint; x: TGLdouble; y: TGLdouble; z: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib3dvARB = procedure(index: TGLuint; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib3fARB = procedure(index: TGLuint; x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib3fvARB = procedure(index: TGLuint; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib3sARB = procedure(index: TGLuint; x: TGLshort; y: TGLshort; z: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib3svARB = procedure(index: TGLuint; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4NbvARB = procedure(index: TGLuint; const v: PGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4NivARB = procedure(index: TGLuint; const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4NsvARB = procedure(index: TGLuint; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4NubARB = procedure(index: TGLuint; x: TGLubyte; y: TGLubyte; z: TGLubyte; w: TGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4NubvARB = procedure(index: TGLuint; const v: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4NuivARB = procedure(index: TGLuint; const v: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4NusvARB = procedure(index: TGLuint; const v: PGLushort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4bvARB = procedure(index: TGLuint; const v: PGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4dARB = procedure(index: TGLuint; x: TGLdouble; y: TGLdouble; z: TGLdouble; w: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4dvARB = procedure(index: TGLuint; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4fARB = procedure(index: TGLuint; x: TGLfloat; y: TGLfloat; z: TGLfloat; w: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4fvARB = procedure(index: TGLuint; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4ivARB = procedure(index: TGLuint; const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4sARB = procedure(index: TGLuint; x: TGLshort; y: TGLshort; z: TGLshort; w: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4svARB = procedure(index: TGLuint; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4ubvARB = procedure(index: TGLuint; const v: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4uivARB = procedure(index: TGLuint; const v: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4usvARB = procedure(index: TGLuint; const v: PGLushort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttribPointerARB = procedure(index: TGLuint; size: TGLint; _type: TGLenum; normalized: TGLboolean; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEnableVertexAttribArrayARB = procedure(index: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDisableVertexAttribArrayARB = procedure(index: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$IFDEF CLR}
  TglProgramStringARB = procedure(target: TGLenum; format: TGLenum; len: TGLsizei; const _string: System.&String); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ELSE}
  TglProgramStringARB = procedure(target: TGLenum; format: TGLenum; len: TGLsizei; const _string: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ENDIF}
  TglBindProgramARB = procedure(target: TGLenum; _program: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDeleteProgramsARB = procedure(n: TGLsizei; const programs: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGenProgramsARB = procedure(n: TGLsizei; programs: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglProgramEnvParameter4dARB = procedure(target: TGLenum; index: TGLuint; x: TGLdouble; y: TGLdouble; z: TGLdouble; w: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglProgramEnvParameter4dvARB = procedure(target: TGLenum; index: TGLuint; const params: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglProgramEnvParameter4fARB = procedure(target: TGLenum; index: TGLuint; x: TGLfloat; y: TGLfloat; z: TGLfloat; w: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglProgramEnvParameter4fvARB = procedure(target: TGLenum; index: TGLuint; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglProgramLocalParameter4dARB = procedure(target: TGLenum; index: TGLuint; x: TGLdouble; y: TGLdouble; z: TGLdouble; w: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglProgramLocalParameter4dvARB = procedure(target: TGLenum; index: TGLuint; const params: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglProgramLocalParameter4fARB = procedure(target: TGLenum; index: TGLuint; x: TGLfloat; y: TGLfloat; z: TGLfloat; w: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglProgramLocalParameter4fvARB = procedure(target: TGLenum; index: TGLuint; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetProgramEnvParameterdvARB = procedure(target: TGLenum; index: TGLuint; params: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetProgramEnvParameterfvARB = procedure(target: TGLenum; index: TGLuint; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetProgramLocalParameterdvARB = procedure(target: TGLenum; index: TGLuint; params: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetProgramLocalParameterfvARB = procedure(target: TGLenum; index: TGLuint; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetProgramivARB = procedure(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetProgramStringARB = procedure(target: TGLenum; pname: TGLenum; _string: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetVertexAttribdvARB = procedure(index: TGLuint; pname: TGLenum; params: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetVertexAttribfvARB = procedure(index: TGLuint; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetVertexAttribivARB = procedure(index: TGLuint; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetVertexAttribPointervARB = procedure(index: TGLuint; pname: TGLenum; _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIsProgramARB = function(_program: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_ARB_window_pos
  TglWindowPos2dARB = procedure(x: TGLdouble; y: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos2dvARB = procedure(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos2fARB = procedure(x: TGLfloat; y: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos2fvARB = procedure(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos2iARB = procedure(x: TGLint; y: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos2ivARB = procedure(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos2sARB = procedure(x: TGLshort; y: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos2svARB = procedure(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos3dARB = procedure(x: TGLdouble; y: TGLdouble; z: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos3dvARB = procedure(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos3fARB = procedure(x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos3fvARB = procedure(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos3iARB = procedure(x: TGLint; y: TGLint; z: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos3ivARB = procedure(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos3sARB = procedure(x: TGLshort; y: TGLshort; z: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos3svARB = procedure(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_ARB_draw_buffers
  TglDrawBuffersARB = procedure(n: TGLsizei; bufs: PGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_ARB_color_buffer_float
  TglClampColorARB = procedure(target: TGLenum; clamp: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_ARB_vertex_shader
{$IFDEF CLR}
  TglGetActiveAttribARB = procedure(programobj: GLhandleARB; index: GLuint; maxLength: GLsizei; var length: GLsizei; var size: GLint; var _type: GLenum; name: StringBuilder); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetAttribLocationARB = function(programObj: GLhandleARB; char: string): glint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBindAttribLocationARB = procedure(programObj: GLhandleARB; index: GLuint; name: string); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ELSE}
  TglGetActiveAttribARB = procedure(programobj: GLhandleARB; index: GLuint; maxLength: GLsizei; var length: GLsizei; var size: GLint; var _type: GLenum; name: PChar); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetAttribLocationARB = function(programObj: GLhandleARB; const char: PChar): glint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBindAttribLocationARB = procedure(programObj: GLhandleARB; index: GLuint; const name: PChar); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ENDIF}

  //TglGetVertexAttribPointervARB = procedure(index: gluint; pname: glenum; p:PPointer); stdcall;

  // GL_ARB_shader_objects
  TglDeleteObjectARB = procedure(Obj: GLHandleARB); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetHandleARB = function(pname: GlEnum): GLHandleARB; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDetachObjectARB = procedure(container, attached: GLHandleARB); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCreateShaderObjectARB = function(shaderType: glenum): GLHandleARB; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$IFDEF CLR}
  TglShaderSourceARB = procedure(shaderObj: GLHandleARB; count: glsizei; _string: array of string; lengths: pglint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ELSE}
  TglShaderSourceARB = procedure(shaderObj: GLHandleARB; count: glsizei; _string: PPGLCharARB; lengths: pglint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ENDIF}
  TglCompileShaderARB = procedure(shaderObj: GLHandleARB); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCreateProgramObjectARB = function: GLHandleARB; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglAttachObjectARB = procedure(programObj, shaderObj: GLhandleARB); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglLinkProgramARB = procedure(programObj: GLHandleARB); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUseProgramObjectARB = procedure(programObj: GLHandleARB); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglValidateProgramARB = procedure(programObj: GLhandleARB); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform1fARB = procedure(location: glint; v0: glfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform2fARB = procedure(location: glint; v0, v1: glfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform3fARB = procedure(location: glint; v0, v1, v2: glfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform4fARB = procedure(location: glint; v0, v1, v2, v3: glfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform1iARB = procedure(location: glint; v0: glint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform2iARB = procedure(location: glint; v0, v1: glint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform3iARB = procedure(location: glint; v0, v1, v2: glint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform4iARB = procedure(location: glint; v0, v1, v2, v3: glint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform1fvARB = procedure(location: glint; count: GLsizei; value: pglfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform2fvARB = procedure(location: glint; count: GLsizei; value: pglfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform3fvARB = procedure(location: glint; count: GLsizei; value: pglfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform4fvARB = procedure(location: glint; count: GLsizei; value: pglfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform1ivARB = procedure(location: glint; count: GLsizei; value: pglint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform2ivARB = procedure(location: glint; count: GLsizei; value: pglint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform3ivARB = procedure(location: glint; count: GLsizei; value: pglint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniform4ivARB = procedure(location: glint; count: GLsizei; value: pglint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniformMatrix2fvARB = procedure(location: glint; count: glsizei; transpose: glboolean; value: pglfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniformMatrix3fvARB = procedure(location: glint; count: glsizei; transpose: glboolean; value: pglfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUniformMatrix4fvARB = procedure(location: glint; count: glsizei; transpose: glboolean; value: pglfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetObjectParameterfvARB = procedure(Obj: GLHandleARB; pname: GLEnum; params: PGLFloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetObjectParameterivARB = procedure(Obj: GLHandleARB; pname: GLEnum; params: PGLInt); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$IFDEF CLR}
  TglGetInfoLogARB = procedure(shaderObj: GLHandleARB; maxLength: glsizei; var length: glint; infoLog: StringBuilder); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ELSE}
  TglGetInfoLogARB = procedure(shaderObj: GLHandleARB; maxLength: glsizei; var length: glint; infoLog: PChar); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ENDIF}
  TglGetAttachedObjectsARB = procedure(programobj: GLhandleARB; maxCount: GLsizei; var count: GLsizei; objects: PGLhandleARB); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetUniformLocationARB = function(programObj: GLhandleARB; const char: PChar): glint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetActiveUniformARB = procedure(programobj: GLhandleARB; index: GLuint; maxLength: GLsizei; var length: GLsizei; var size: GLint; var _type: GLenum; name: PChar); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetUniformfvARB = procedure(programObj: GLhandleARB; location: GLint; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetUniformivARB = procedure(programObj: GLhandleARB; location: GLint; params: PGLInt); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetShaderSourceARB = procedure(shader: GLhandleARB; maxLength: GLsizei; var length: GLsizei; source: PChar); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_ARB_Occlusion_Query
  TglGenQueriesARB = procedure(n: GLsizei; ids: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDeleteQueriesARB = procedure(n: GLsizei; const ids: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIsQueryARB = function(id: GLuint): boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBeginQueryARB = procedure(target: GLenum; id: GLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEndQueryARB = procedure(target: GLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetQueryivARB = procedure(target, pname: GLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetQueryObjectivARB = procedure(id: GLuint; pname: GLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetQueryObjectuivARB = procedure(id: GLuint; pname: GLenum; params: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_ATI_draw_buffers
  TglDrawBuffersATI = procedure(n: TGLsizei; const bufs: PGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_ATI_element_array
  TglElementPointerATI = procedure(_type: TGLenum; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDrawElementArrayATI = procedure(mode: TGLenum; count: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDrawRangeElementArrayATI = procedure(mode: TGLenum; start: TGLuint; _end: TGLuint; count: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_ATI_envmap_bumpmap
  TglTexBumpParameterivATI = procedure(pname: TGLenum; const param: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexBumpParameterfvATI = procedure(pname: TGLenum; const param: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetTexBumpParameterivATI = procedure(pname: TGLenum; param: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetTexBumpParameterfvATI = procedure(pname: TGLenum; param: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_ATI_fragment_shader
  TglGenFragmentShadersATI = function(range: TGLuint): TGLuint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBindFragmentShaderATI = procedure(id: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDeleteFragmentShaderATI = procedure(id: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBeginFragmentShaderATI = procedure(); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEndFragmentShaderATI = procedure(); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPassTexCoordATI = procedure(dst: TGLuint; coord: TGLuint; swizzle: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSampleMapATI = procedure(dst: TGLuint; interp: TGLuint; swizzle: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColorFragmentOp1ATI = procedure(op: TGLenum; dst: TGLuint; dstMask: TGLuint; dstMod: TGLuint; arg1: TGLuint; arg1Rep: TGLuint; arg1Mod: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColorFragmentOp2ATI = procedure(op: TGLenum; dst: TGLuint; dstMask: TGLuint; dstMod: TGLuint; arg1: TGLuint; arg1Rep: TGLuint; arg1Mod: TGLuint; arg2: TGLuint; arg2Rep: TGLuint; arg2Mod: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColorFragmentOp3ATI = procedure(op: TGLenum; dst: TGLuint; dstMask: TGLuint; dstMod: TGLuint; arg1: TGLuint; arg1Rep: TGLuint; arg1Mod: TGLuint; arg2: TGLuint; arg2Rep: TGLuint; arg2Mod: TGLuint; arg3: TGLuint; arg3Rep: TGLuint; arg3Mod: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglAlphaFragmentOp1ATI = procedure(op: TGLenum; dst: TGLuint; dstMod: TGLuint; arg1: TGLuint; arg1Rep: TGLuint; arg1Mod: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglAlphaFragmentOp2ATI = procedure(op: TGLenum; dst: TGLuint; dstMod: TGLuint; arg1: TGLuint; arg1Rep: TGLuint; arg1Mod: TGLuint; arg2: TGLuint; arg2Rep: TGLuint; arg2Mod: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglAlphaFragmentOp3ATI = procedure(op: TGLenum; dst: TGLuint; dstMod: TGLuint; arg1: TGLuint; arg1Rep: TGLuint; arg1Mod: TGLuint; arg2: TGLuint; arg2Rep: TGLuint; arg2Mod: TGLuint; arg3: TGLuint; arg3Rep: TGLuint; arg3Mod: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSetFragmentShaderConstantATI = procedure(dst: TGLuint; const value: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_ATI_map_object_buffer
  TglMapObjectBufferATI = function(buffer: TGLuint): PGLvoid; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUnmapObjectBufferATI = procedure(buffer: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_ATI_pn_triangles
  TglPNTrianglesiATI = procedure(pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPNTrianglesfATI = procedure(pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_ATI_separate_stencil
  TglStencilOpSeparateATI = procedure(face: TGLenum; sfail: TGLenum; dpfail: TGLenum; dppass: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglStencilFuncSeparateATI = procedure(frontfunc: TGLenum; backfunc: TGLenum; ref: TGLint; mask: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_ATI_vertex_array_object
  TglNewObjectBufferATI = function(size: TGLsizei; const _pointer: PGLvoid; usage: TGLenum): TGLuint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIsObjectBufferATI = function(buffer: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUpdateObjectBufferATI = procedure(buffer: TGLuint; offset: TGLuint; size: TGLsizei; const _pointer: PGLvoid; preserve: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetObjectBufferfvATI = procedure(buffer: TGLuint; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetObjectBufferivATI = procedure(buffer: TGLuint; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFreeObjectBufferATI = procedure(buffer: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglArrayObjectATI = procedure(_array: TGLenum; size: TGLint; _type: TGLenum; stride: TGLsizei; buffer: TGLuint; offset: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetArrayObjectfvATI = procedure(_array: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetArrayObjectivATI = procedure(_array: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVariantArrayObjectATI = procedure(id: TGLuint; _type: TGLenum; stride: TGLsizei; buffer: TGLuint; offset: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetVariantArrayObjectfvATI = procedure(id: TGLuint; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetVariantArrayObjectivATI = procedure(id: TGLuint; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_ATI_vertex_attrib_array_object
  TglVertexAttribArrayObjectATI = procedure(index: TGLuint; size: TGLint; _type: TGLenum; normalized: TGLboolean; stride: TGLsizei; buffer: TGLuint; offset: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetVertexAttribArrayObjectfvATI = procedure(index: TGLuint; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetVertexAttribArrayObjectivATI = procedure(index: TGLuint; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_ATI_vertex_streams
  TglVertexStream1sATI = procedure(stream: TGLenum; x: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream1svATI = procedure(stream: TGLenum; const coords: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream1iATI = procedure(stream: TGLenum; x: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream1ivATI = procedure(stream: TGLenum; const coords: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream1fATI = procedure(stream: TGLenum; x: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream1fvATI = procedure(stream: TGLenum; const coords: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream1dATI = procedure(stream: TGLenum; x: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream1dvATI = procedure(stream: TGLenum; const coords: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream2sATI = procedure(stream: TGLenum; x: TGLshort; y: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream2svATI = procedure(stream: TGLenum; const coords: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream2iATI = procedure(stream: TGLenum; x: TGLint; y: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream2ivATI = procedure(stream: TGLenum; const coords: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream2fATI = procedure(stream: TGLenum; x: TGLfloat; y: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream2fvATI = procedure(stream: TGLenum; const coords: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream2dATI = procedure(stream: TGLenum; x: TGLdouble; y: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream2dvATI = procedure(stream: TGLenum; const coords: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream3sATI = procedure(stream: TGLenum; x: TGLshort; y: TGLshort; z: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream3svATI = procedure(stream: TGLenum; const coords: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream3iATI = procedure(stream: TGLenum; x: TGLint; y: TGLint; z: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream3ivATI = procedure(stream: TGLenum; const coords: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream3fATI = procedure(stream: TGLenum; x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream3fvATI = procedure(stream: TGLenum; const coords: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream3dATI = procedure(stream: TGLenum; x: TGLdouble; y: TGLdouble; z: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream3dvATI = procedure(stream: TGLenum; const coords: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream4sATI = procedure(stream: TGLenum; x: TGLshort; y: TGLshort; z: TGLshort; w: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream4svATI = procedure(stream: TGLenum; const coords: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream4iATI = procedure(stream: TGLenum; x: TGLint; y: TGLint; z: TGLint; w: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream4ivATI = procedure(stream: TGLenum; const coords: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream4fATI = procedure(stream: TGLenum; x: TGLfloat; y: TGLfloat; z: TGLfloat; w: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream4fvATI = procedure(stream: TGLenum; const coords: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream4dATI = procedure(stream: TGLenum; x: TGLdouble; y: TGLdouble; z: TGLdouble; w: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexStream4dvATI = procedure(stream: TGLenum; const coords: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormalStream3bATI = procedure(stream: TGLenum; nx: TGLbyte; ny: TGLbyte; nz: TGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormalStream3bvATI = procedure(stream: TGLenum; const coords: PGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormalStream3sATI = procedure(stream: TGLenum; nx: TGLshort; ny: TGLshort; nz: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormalStream3svATI = procedure(stream: TGLenum; const coords: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormalStream3iATI = procedure(stream: TGLenum; nx: TGLint; ny: TGLint; nz: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormalStream3ivATI = procedure(stream: TGLenum; const coords: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormalStream3fATI = procedure(stream: TGLenum; nx: TGLfloat; ny: TGLfloat; nz: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormalStream3fvATI = procedure(stream: TGLenum; const coords: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormalStream3dATI = procedure(stream: TGLenum; nx: TGLdouble; ny: TGLdouble; nz: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormalStream3dvATI = procedure(stream: TGLenum; const coords: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglClientActiveVertexStreamATI = procedure(stream: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexBlendEnviATI = procedure(pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexBlendEnvfATI = procedure(pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_blend_color
  TglBlendColorEXT = procedure(red: TGLclampf; green: TGLclampf; blue: TGLclampf; alpha: TGLclampf); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_blend_func_separate
  TglBlendFuncSeparateEXT = procedure(sfactorRGB: TGLenum; dfactorRGB: TGLenum; sfactorAlpha: TGLenum; dfactorAlpha: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_blend_minmax
  TglBlendEquationEXT = procedure(mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_color_subtable
  TglColorSubTableEXT = procedure(target: TGLenum; start: TGLsizei; count: TGLsizei; format: TGLenum; _type: TGLenum; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCopyColorSubTableEXT = procedure(target: TGLenum; start: TGLsizei; x: TGLint; y: TGLint; width: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_compiled_vertex_array
  TglLockArraysEXT = procedure(first: TGLint; count: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglUnlockArraysEXT = procedure(); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_convolution
  TglConvolutionFilter1DEXT = procedure(target: TGLenum; internalformat: TGLenum; width: TGLsizei; format: TGLenum; _type: TGLenum; const image: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglConvolutionFilter2DEXT = procedure(target: TGLenum; internalformat: TGLenum; width: TGLsizei; height: TGLsizei; format: TGLenum; _type: TGLenum; const image: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglConvolutionParameterfEXT = procedure(target: TGLenum; pname: TGLenum; params: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglConvolutionParameterfvEXT = procedure(target: TGLenum; pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglConvolutionParameteriEXT = procedure(target: TGLenum; pname: TGLenum; params: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglConvolutionParameterivEXT = procedure(target: TGLenum; pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCopyConvolutionFilter1DEXT = procedure(target: TGLenum; internalformat: TGLenum; x: TGLint; y: TGLint; width: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCopyConvolutionFilter2DEXT = procedure(target: TGLenum; internalformat: TGLenum; x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetConvolutionFilterEXT = procedure(target: TGLenum; format: TGLenum; _type: TGLenum; image: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetConvolutionParameterfvEXT = procedure(target: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetConvolutionParameterivEXT = procedure(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetSeparableFilterEXT = procedure(target: TGLenum; format: TGLenum; _type: TGLenum; row: PGLvoid; column: PGLvoid; span: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSeparableFilter2DEXT = procedure(target: TGLenum; internalformat: TGLenum; width: TGLsizei; height: TGLsizei; format: TGLenum; _type: TGLenum; const row: PGLvoid; const column: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_coordinate_frame
  TglTangent3bEXT = procedure(tx: TGLbyte; ty: TGLbyte; tz: TGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTangent3bvEXT = procedure(const v: PGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTangent3dEXT = procedure(tx: TGLdouble; ty: TGLdouble; tz: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTangent3dvEXT = procedure(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTangent3fEXT = procedure(tx: TGLfloat; ty: TGLfloat; tz: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTangent3fvEXT = procedure(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTangent3iEXT = procedure(tx: TGLint; ty: TGLint; tz: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTangent3ivEXT = procedure(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTangent3sEXT = procedure(tx: TGLshort; ty: TGLshort; tz: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTangent3svEXT = procedure(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBinormal3bEXT = procedure(bx: TGLbyte; by: TGLbyte; bz: TGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBinormal3bvEXT = procedure(const v: PGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBinormal3dEXT = procedure(bx: TGLdouble; by: TGLdouble; bz: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBinormal3dvEXT = procedure(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBinormal3fEXT = procedure(bx: TGLfloat; by: TGLfloat; bz: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBinormal3fvEXT = procedure(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBinormal3iEXT = procedure(bx: TGLint; by: TGLint; bz: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBinormal3ivEXT = procedure(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBinormal3sEXT = procedure(bx: TGLshort; by: TGLshort; bz: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBinormal3svEXT = procedure(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTangentPointerEXT = procedure(_type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBinormalPointerEXT = procedure(_type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_copy_texture
  TglCopyTexImage1DEXT = procedure(target: TGLenum; level: TGLint; internalformat: TGLenum; x: TGLint; y: TGLint; width: TGLsizei; border: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCopyTexImage2DEXT = procedure(target: TGLenum; level: TGLint; internalformat: TGLenum; x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei; border: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCopyTexSubImage1DEXT = procedure(target: TGLenum; level: TGLint; xoffset: TGLint; x: TGLint; y: TGLint; width: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCopyTexSubImage2DEXT = procedure(target: TGLenum; level: TGLint; xoffset: TGLint; yoffset: TGLint; x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCopyTexSubImage3DEXT = procedure(target: TGLenum; level: TGLint; xoffset: TGLint; yoffset: TGLint; zoffset: TGLint; x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_cull_vertex
  TglCullParameterdvEXT = procedure(pname: TGLenum; params: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCullParameterfvEXT = procedure(pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_draw_range_elements
  TglDrawRangeElementsEXT = procedure(mode: TGLenum; start: TGLuint; _end: TGLuint; count: TGLsizei; _type: TGLenum; const indices: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_fog_coord
  TglFogCoordfEXT = procedure(coord: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFogCoordfvEXT = procedure(const coord: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFogCoorddEXT = procedure(coord: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFogCoorddvEXT = procedure(const coord: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFogCoordPointerEXT = procedure(_type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_framebuffer_object
  TglIsRenderbufferEXT = function(renderbuffer: TGLuint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBindRenderbufferEXT = procedure(target: TGLenum; renderbuffer: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDeleteRenderbuffersEXT = procedure(n: TGLsizei; const renderbuffers: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGenRenderbuffersEXT = procedure(n: TGLsizei; renderbuffers: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRenderbufferStorageEXT = procedure(target: TGLenum; internalformat: TGLenum; width: TGLsizei; height: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetRenderbufferParameterivEXT = procedure(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIsFramebufferEXT = function(framebuffer: TGLuint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBindFramebufferEXT = procedure(target: TGLenum; framebuffer: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDeleteFramebuffersEXT = procedure(n: TGLsizei; const framebuffers: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGenFramebuffersEXT = procedure(n: TGLsizei; framebuffers: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCheckFramebufferStatusEXT = function(target: TGLenum): TGLenum; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFramebufferTexture1DEXT = procedure(target: TGLenum; attachment: TGLenum; textarget: TGLenum; texture: TGLuint; level: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFramebufferTexture2DEXT = procedure(target: TGLenum; attachment: TGLenum; textarget: TGLenum; texture: TGLuint; level: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFramebufferTexture3DEXT = procedure(target: TGLenum; attachment: TGLenum; textarget: TGLenum; texture: TGLuint; level: TGLint; zoffset: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFramebufferRenderbufferEXT = procedure(target: TGLenum; attachment: TGLenum; renderbuffertarget: TGLenum; renderbuffer: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetFramebufferAttachmentParameterivEXT = procedure(target: TGLenum; attachment: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGenerateMipmapEXT = procedure(target: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_histogram
  TglGetHistogramEXT = procedure(target: TGLenum; reset: TGLboolean; format: TGLenum; _type: TGLenum; values: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetHistogramParameterfvEXT = procedure(target: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetHistogramParameterivEXT = procedure(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetMinmaxEXT = procedure(target: TGLenum; reset: TGLboolean; format: TGLenum; _type: TGLenum; values: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetMinmaxParameterfvEXT = procedure(target: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetMinmaxParameterivEXT = procedure(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglHistogramEXT = procedure(target: TGLenum; width: TGLsizei; internalformat: TGLenum; sink: TGLboolean); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMinmaxEXT = procedure(target: TGLenum; internalformat: TGLenum; sink: TGLboolean); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglResetHistogramEXT = procedure(target: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglResetMinmaxEXT = procedure(target: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_index_func
  TglIndexFuncEXT = procedure(func: TGLenum; ref: TGLclampf); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_index_material
  TglIndexMaterialEXT = procedure(face: TGLenum; mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_light_texture
  TglApplyTextureEXT = procedure(mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTextureLightEXT = procedure(pname: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTextureMaterialEXT = procedure(face: TGLenum; mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_multi_draw_arrays
  TglMultiDrawArraysEXT = procedure(mode: TGLenum; first: PGLint; count: PGLsizei; primcount: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiDrawElementsEXT = procedure(mode: TGLenum; const count: PGLsizei; _type: TGLenum; const indices: PGLvoid; primcount: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_multisample
  TglSampleMaskEXT = procedure(value: TGLclampf; invert: TGLboolean); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSamplePatternEXT = procedure(pattern: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_paletted_texture
  TglColorTableEXT = procedure(target: TGLenum; internalFormat: TGLenum; width: TGLsizei; format: TGLenum; _type: TGLenum; const table: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetColorTableEXT = procedure(target: TGLenum; format: TGLenum; _type: TGLenum; data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetColorTableParameterivEXT = procedure(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetColorTableParameterfvEXT = procedure(target: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_pixel_transform
  TglPixelTransformParameteriEXT = procedure(target: TGLenum; pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPixelTransformParameterfEXT = procedure(target: TGLenum; pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPixelTransformParameterivEXT = procedure(target: TGLenum; pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPixelTransformParameterfvEXT = procedure(target: TGLenum; pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_point_parameters
  TglPointParameterfEXT = procedure(pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPointParameterfvEXT = procedure(pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_polygon_offset
  TglPolygonOffsetEXT = procedure(factor: TGLfloat; bias: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_secondary_color
  TglSecondaryColor3bEXT = procedure(red: TGLbyte; green: TGLbyte; blue: TGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3bvEXT = procedure(const v: PGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3dEXT = procedure(red: TGLdouble; green: TGLdouble; blue: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3dvEXT = procedure(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3fEXT = procedure(red: TGLfloat; green: TGLfloat; blue: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3fvEXT = procedure(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3iEXT = procedure(red: TGLint; green: TGLint; blue: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3ivEXT = procedure(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3sEXT = procedure(red: TGLshort; green: TGLshort; blue: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3svEXT = procedure(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3ubEXT = procedure(red: TGLubyte; green: TGLubyte; blue: TGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3ubvEXT = procedure(const v: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3uiEXT = procedure(red: TGLuint; green: TGLuint; blue: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3uivEXT = procedure(const v: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3usEXT = procedure(red: TGLushort; green: TGLushort; blue: TGLushort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3usvEXT = procedure(const v: PGLushort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColorPointerEXT = procedure(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_stencil_two_side
  TglActiveStencilFaceEXT = procedure(face: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_subtexture
  TglTexSubImage1DEXT = procedure(target: TGLenum; level: TGLint; xoffset: TGLint; width: TGLsizei; format: TGLenum; _type: TGLenum; const pixels: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexSubImage2DEXT = procedure(target: TGLenum; level: TGLint; xoffset: TGLint; yoffset: TGLint; width: TGLsizei; height: TGLsizei; format: TGLenum; _type: TGLenum; const pixels: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_texture3D
  TglTexImage3DEXT = procedure(target: TGLenum; level: TGLint; internalformat: TGLenum; width: TGLsizei; height: TGLsizei; depth: TGLsizei; border: TGLint; format: TGLenum; _type: TGLenum; const pixels: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexSubImage3DEXT = procedure(target: TGLenum; level: TGLint; xoffset: TGLint; yoffset: TGLint; zoffset: TGLint; width: TGLsizei; height: TGLsizei; depth: TGLsizei; format: TGLenum; _type: TGLenum; const pixels: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_texture_object
  TglAreTexturesResidentEXT = function(n: TGLsizei; const textures: PGLuint; residences: PGLboolean): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBindTextureEXT = procedure(target: TGLenum; texture: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDeleteTexturesEXT = procedure(n: TGLsizei; const textures: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGenTexturesEXT = procedure(n: TGLsizei; textures: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIsTextureEXT = function(texture: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPrioritizeTexturesEXT = procedure(n: TGLsizei; const textures: PGLuint; const priorities: PGLclampf); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_texture_perturb_normal
  TglTextureNormalEXT = procedure(mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_vertex_array
  TglArrayElementEXT = procedure(i: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColorPointerEXT = procedure(size: TGLint; _type: TGLenum; stride: TGLsizei; count: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDrawArraysEXT = procedure(mode: TGLenum; first: TGLint; count: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEdgeFlagPointerEXT = procedure(stride: TGLsizei; count: TGLsizei; const _pointer: PGLboolean); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetPointervEXT = procedure(pname: TGLenum; params: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIndexPointerEXT = procedure(_type: TGLenum; stride: TGLsizei; count: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormalPointerEXT = procedure(_type: TGLenum; stride: TGLsizei; count: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoordPointerEXT = procedure(size: TGLint; _type: TGLenum; stride: TGLsizei; count: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexPointerEXT = procedure(size: TGLint; _type: TGLenum; stride: TGLsizei; count: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_vertex_shader
  TglBeginVertexShaderEXT = procedure(); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEndVertexShaderEXT = procedure(); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBindVertexShaderEXT = procedure(id: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGenVertexShadersEXT = function(range: TGLuint): TGLuint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDeleteVertexShaderEXT = procedure(id: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglShaderOp1EXT = procedure(op: TGLenum; res: TGLuint; arg1: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglShaderOp2EXT = procedure(op: TGLenum; res: TGLuint; arg1: TGLuint; arg2: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglShaderOp3EXT = procedure(op: TGLenum; res: TGLuint; arg1: TGLuint; arg2: TGLuint; arg3: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSwizzleEXT = procedure(res: TGLuint; _in: TGLuint; outX: TGLenum; outY: TGLenum; outZ: TGLenum; outW: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWriteMaskEXT = procedure(res: TGLuint; _in: TGLuint; outX: TGLenum; outY: TGLenum; outZ: TGLenum; outW: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglInsertComponentEXT = procedure(res: TGLuint; src: TGLuint; num: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglExtractComponentEXT = procedure(res: TGLuint; src: TGLuint; num: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGenSymbolsEXT = function(datatype: TGLenum; storagetype: TGLenum; range: TGLenum; components: TGLuint): TGLuint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSetInvariantEXT = procedure(id: TGLuint; _type: TGLenum; const addr: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSetLocalConstantEXT = procedure(id: TGLuint; _type: TGLenum; const addr: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVariantbvEXT = procedure(id: TGLuint; const addr: PGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVariantsvEXT = procedure(id: TGLuint; const addr: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVariantivEXT = procedure(id: TGLuint; const addr: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVariantfvEXT = procedure(id: TGLuint; const addr: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVariantdvEXT = procedure(id: TGLuint; const addr: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVariantubvEXT = procedure(id: TGLuint; const addr: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVariantusvEXT = procedure(id: TGLuint; const addr: PGLushort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVariantuivEXT = procedure(id: TGLuint; const addr: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVariantPointerEXT = procedure(id: TGLuint; _type: TGLenum; stride: TGLuint; const addr: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEnableVariantClientStateEXT = procedure(id: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDisableVariantClientStateEXT = procedure(id: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBindLightParameterEXT = function(light: TGLenum; value: TGLenum): TGLuint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBindMaterialParameterEXT = function(face: TGLenum; value: TGLenum): TGLuint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBindTexGenParameterEXT = function(_unit: TGLenum; coord: TGLenum; value: TGLenum): TGLuint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBindTextureUnitParameterEXT = function(_unit: TGLenum; value: TGLenum): TGLuint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBindParameterEXT = function(value: TGLenum): TGLuint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIsVariantEnabledEXT = function(id: TGLuint; cap: TGLenum): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetVariantBooleanvEXT = procedure(id: TGLuint; value: TGLenum; data: PGLboolean); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetVariantIntegervEXT = procedure(id: TGLuint; value: TGLenum; data: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetVariantFloatvEXT = procedure(id: TGLuint; value: TGLenum; data: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetVariantPointervEXT = procedure(id: TGLuint; value: TGLenum; data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetInvariantBooleanvEXT = procedure(id: TGLuint; value: TGLenum; data: PGLboolean); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetInvariantIntegervEXT = procedure(id: TGLuint; value: TGLenum; data: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetInvariantFloatvEXT = procedure(id: TGLuint; value: TGLenum; data: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetLocalConstantBooleanvEXT = procedure(id: TGLuint; value: TGLenum; data: PGLboolean); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetLocalConstantIntegervEXT = procedure(id: TGLuint; value: TGLenum; data: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetLocalConstantFloatvEXT = procedure(id: TGLuint; value: TGLenum; data: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_vertex_weighting
  TglVertexWeightfEXT = procedure(weight: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexWeightfvEXT = procedure(const weight: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexWeightPointerEXT = procedure(size: TGLsizei; _type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_stencil_clear_tag
  TglStencilClearTagEXT = procedure(stencilTagBits: TGLsizei; stencilClearTag: Tgluint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_HP_image_transform
  TglImageTransformParameteriHP = procedure(target: TGLenum; pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglImageTransformParameterfHP = procedure(target: TGLenum; pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglImageTransformParameterivHP = procedure(target: TGLenum; pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglImageTransformParameterfvHP = procedure(target: TGLenum; pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetImageTransformParameterivHP = procedure(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetImageTransformParameterfvHP = procedure(target: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_depth_bounds_test
  TglDepthBoundsEXT = procedure(zmin: TGLclampd; zmax: TGLclampd); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_EXT_blend_equation_separate
  TglBlendEquationSeparateEXT = procedure(modeRGB: TGLenum; modeAlpha: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_IBM_multimode_draw_arrays
  TglMultiModeDrawArraysIBM = procedure(mode: TGLenum; const first: PGLint; const count: PGLsizei; primcount: TGLsizei; modestride: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiModeDrawElementsIBM = procedure(const mode: PGLenum; const count: PGLsizei; _type: TGLenum; const indices: PGLvoid; primcount: TGLsizei; modestride: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_IBM_vertex_array_lists
  TglColorPointerListIBM = procedure(size: TGLint; _type: TGLenum; stride: TGLint; const _pointer: PGLvoid; ptrstride: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColorPointerListIBM = procedure(size: TGLint; _type: TGLenum; stride: TGLint; const _pointer: PGLvoid; ptrstride: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEdgeFlagPointerListIBM = procedure(stride: TGLint; const _pointer: PGLboolean; ptrstride: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFogCoordPointerListIBM = procedure(_type: TGLenum; stride: TGLint; const _pointer: PGLvoid; ptrstride: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIndexPointerListIBM = procedure(_type: TGLenum; stride: TGLint; const _pointer: PGLvoid; ptrstride: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormalPointerListIBM = procedure(_type: TGLenum; stride: TGLint; const _pointer: PGLvoid; ptrstride: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoordPointerListIBM = procedure(size: TGLint; _type: TGLenum; stride: TGLint; const _pointer: PGLvoid; ptrstride: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexPointerListIBM = procedure(size: TGLint; _type: TGLenum; stride: TGLint; const _pointer: PGLvoid; ptrstride: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_INGR_blend_func_separate
  TglBlendFuncSeparateINGR = procedure(sfactorRGB: TGLenum; dfactorRGB: TGLenum; sfactorAlpha: TGLenum; dfactorAlpha: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_INTEL_parallel_arrays
  TglVertexPointervINTEL = procedure(size: TGLint; _type: TGLenum; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormalPointervINTEL = procedure(_type: TGLenum; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColorPointervINTEL = procedure(size: TGLint; _type: TGLenum; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoordPointervINTEL = procedure(size: TGLint; _type: TGLenum; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_MESA_resize_buffers
  TglResizeBuffersMESA = procedure(); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_MESA_window_pos
  TglWindowPos2dMESA = procedure(x: TGLdouble; y: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos2dvMESA = procedure(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos2fMESA = procedure(x: TGLfloat; y: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos2fvMESA = procedure(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos2iMESA = procedure(x: TGLint; y: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos2ivMESA = procedure(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos2sMESA = procedure(x: TGLshort; y: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos2svMESA = procedure(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos3dMESA = procedure(x: TGLdouble; y: TGLdouble; z: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos3dvMESA = procedure(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos3fMESA = procedure(x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos3fvMESA = procedure(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos3iMESA = procedure(x: TGLint; y: TGLint; z: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos3ivMESA = procedure(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos3sMESA = procedure(x: TGLshort; y: TGLshort; z: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos3svMESA = procedure(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos4dMESA = procedure(x: TGLdouble; y: TGLdouble; z: TGLdouble; w: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos4dvMESA = procedure(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos4fMESA = procedure(x: TGLfloat; y: TGLfloat; z: TGLfloat; w: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos4fvMESA = procedure(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos4iMESA = procedure(x: TGLint; y: TGLint; z: TGLint; w: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos4ivMESA = procedure(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos4sMESA = procedure(x: TGLshort; y: TGLshort; z: TGLshort; w: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglWindowPos4svMESA = procedure(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_NV_evaluators
  TglMapControlPointsNV = procedure(target: TGLenum; index: TGLuint; _type: TGLenum; ustride: TGLsizei; vstride: TGLsizei; uorder: TGLint; vorder: TGLint; _packed: TGLboolean; const points: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMapParameterivNV = procedure(target: TGLenum; pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMapParameterfvNV = procedure(target: TGLenum; pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetMapControlPointsNV = procedure(target: TGLenum; index: TGLuint; _type: TGLenum; ustride: TGLsizei; vstride: TGLsizei; _packed: TGLboolean; points: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetMapParameterivNV = procedure(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetMapParameterfvNV = procedure(target: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetMapAttribParameterivNV = procedure(target: TGLenum; index: TGLuint; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetMapAttribParameterfvNV = procedure(target: TGLenum; index: TGLuint; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEvalMapsNV = procedure(target: TGLenum; mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_NV_fence
  TglDeleteFencesNV = procedure(n: TGLsizei; const fences: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGenFencesNV = procedure(n: TGLsizei; fences: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIsFenceNV = function(fence: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTestFenceNV = function(fence: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetFenceivNV = procedure(fence: TGLuint; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFinishFenceNV = procedure(fence: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSetFenceNV = procedure(fence: TGLuint; condition: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_NV_fragment_program
  TglProgramNamedParameter4fNV = procedure(id: TGLuint; len: TGLsizei; const name: PGLubyte; x: TGLfloat; y: TGLfloat; z: TGLfloat; w: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglProgramNamedParameter4dNV = procedure(id: TGLuint; len: TGLsizei; const name: PGLubyte; x: TGLdouble; y: TGLdouble; z: TGLdouble; w: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglProgramNamedParameter4fvNV = procedure(id: TGLuint; len: TGLsizei; const name: PGLubyte; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglProgramNamedParameter4dvNV = procedure(id: TGLuint; len: TGLsizei; const name: PGLubyte; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetProgramNamedParameterfvNV = procedure(id: TGLuint; len: TGLsizei; const name: PGLubyte; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetProgramNamedParameterdvNV = procedure(id: TGLuint; len: TGLsizei; const name: PGLubyte; params: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_NV_half_float
  TglVertex2hNV = procedure(x: TGLhalfNV; y: TGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex2hvNV = procedure(const v: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex3hNV = procedure(x: TGLhalfNV; y: TGLhalfNV; z: TGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex3hvNV = procedure(const v: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex4hNV = procedure(x: TGLhalfNV; y: TGLhalfNV; z: TGLhalfNV; w: TGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertex4hvNV = procedure(const v: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormal3hNV = procedure(nx: TGLhalfNV; ny: TGLhalfNV; nz: TGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormal3hvNV = procedure(const v: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor3hNV = procedure(red: TGLhalfNV; green: TGLhalfNV; blue: TGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor3hvNV = procedure(const v: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor4hNV = procedure(red: TGLhalfNV; green: TGLhalfNV; blue: TGLhalfNV; alpha: TGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor4hvNV = procedure(const v: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord1hNV = procedure(s: TGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord1hvNV = procedure(const v: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord2hNV = procedure(s: TGLhalfNV; t: TGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord2hvNV = procedure(const v: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord3hNV = procedure(s: TGLhalfNV; t: TGLhalfNV; r: TGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord3hvNV = procedure(const v: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord4hNV = procedure(s: TGLhalfNV; t: TGLhalfNV; r: TGLhalfNV; q: TGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord4hvNV = procedure(const v: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord1hNV = procedure(target: TGLenum; s: TGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord1hvNV = procedure(target: TGLenum; const v: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord2hNV = procedure(target: TGLenum; s: TGLhalfNV; t: TGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord2hvNV = procedure(target: TGLenum; const v: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord3hNV = procedure(target: TGLenum; s: TGLhalfNV; t: TGLhalfNV; r: TGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord3hvNV = procedure(target: TGLenum; const v: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord4hNV = procedure(target: TGLenum; s: TGLhalfNV; t: TGLhalfNV; r: TGLhalfNV; q: TGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglMultiTexCoord4hvNV = procedure(target: TGLenum; const v: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFogCoordhNV = procedure(fog: TGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFogCoordhvNV = procedure(const fog: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3hNV = procedure(red: TGLhalfNV; green: TGLhalfNV; blue: TGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSecondaryColor3hvNV = procedure(const v: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexWeighthNV = procedure(weight: TGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexWeighthvNV = procedure(const weight: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib1hNV = procedure(index: TGLuint; x: TGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib1hvNV = procedure(index: TGLuint; const v: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib2hNV = procedure(index: TGLuint; x: TGLhalfNV; y: TGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib2hvNV = procedure(index: TGLuint; const v: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib3hNV = procedure(index: TGLuint; x: TGLhalfNV; y: TGLhalfNV; z: TGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib3hvNV = procedure(index: TGLuint; const v: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4hNV = procedure(index: TGLuint; x: TGLhalfNV; y: TGLhalfNV; z: TGLhalfNV; w: TGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4hvNV = procedure(index: TGLuint; const v: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttribs1hvNV = procedure(index: TGLuint; n: TGLsizei; const v: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttribs2hvNV = procedure(index: TGLuint; n: TGLsizei; const v: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttribs3hvNV = procedure(index: TGLuint; n: TGLsizei; const v: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttribs4hvNV = procedure(index: TGLuint; n: TGLsizei; const v: PGLhalfNV); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_NV_occlusion_query
  TglGenOcclusionQueriesNV = procedure(n: TGLsizei; ids: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDeleteOcclusionQueriesNV = procedure(n: TGLsizei; const ids: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIsOcclusionQueryNV = function(id: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBeginOcclusionQueryNV = procedure(id: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglEndOcclusionQueryNV = procedure(); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetOcclusionQueryivNV = procedure(id: TGLuint; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetOcclusionQueryuivNV = procedure(id: TGLuint; pname: TGLenum; params: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_NV_pixel_data_range
  TglPixelDataRangeNV = procedure(target: TGLenum; length: TGLsizei; _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFlushPixelDataRangeNV = procedure(target: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_NV_point_sprite
  TglPointParameteriNV = procedure(pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPointParameterivNV = procedure(pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_NV_primitive_restart
  TglPrimitiveRestartNV = procedure(); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPrimitiveRestartIndexNV = procedure(index: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_NV_register_combiners
  TglCombinerParameterfvNV = procedure(pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCombinerParameterfNV = procedure(pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCombinerParameterivNV = procedure(pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCombinerParameteriNV = procedure(pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCombinerInputNV = procedure(stage: TGLenum; portion: TGLenum; variable: TGLenum; input: TGLenum; mapping: TGLenum; componentUsage: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCombinerOutputNV = procedure(stage: TGLenum; portion: TGLenum; abOutput: TGLenum; cdOutput: TGLenum; sumOutput: TGLenum; scale: TGLenum; bias: TGLenum; abDotProduct: TGLboolean; cdDotProduct: TGLboolean; muxSum: TGLboolean); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFinalCombinerInputNV = procedure(variable: TGLenum; input: TGLenum; mapping: TGLenum; componentUsage: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetCombinerInputParameterfvNV = procedure(stage: TGLenum; portion: TGLenum; variable: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetCombinerInputParameterivNV = procedure(stage: TGLenum; portion: TGLenum; variable: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetCombinerOutputParameterfvNV = procedure(stage: TGLenum; portion: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetCombinerOutputParameterivNV = procedure(stage: TGLenum; portion: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetFinalCombinerInputParameterfvNV = procedure(variable: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetFinalCombinerInputParameterivNV = procedure(variable: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_NV_register_combiners2
  TglCombinerStageParameterfvNV = procedure(stage: TGLenum; pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetCombinerStageParameterfvNV = procedure(stage: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_NV_vertex_array_range
  TglFlushVertexArrayRangeNV = procedure(); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexArrayRangeNV = procedure(length: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_NV_vertex_program
  TglAreProgramsResidentNV = function(n: TGLsizei; const programs: PGLuint; residences: PGLboolean): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglBindProgramNV = procedure(target: TGLenum; id: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDeleteProgramsNV = procedure(n: TGLsizei; const programs: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglExecuteProgramNV = procedure(target: TGLenum; id: TGLuint; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGenProgramsNV = procedure(n: TGLsizei; programs: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetProgramParameterdvNV = procedure(target: TGLenum; index: TGLuint; pname: TGLenum; params: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetProgramParameterfvNV = procedure(target: TGLenum; index: TGLuint; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetProgramivNV = procedure(id: TGLuint; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetProgramStringNV = procedure(id: TGLuint; pname: TGLenum; _program: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetTrackMatrixivNV = procedure(target: TGLenum; address: TGLuint; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetVertexAttribdvNV = procedure(index: TGLuint; pname: TGLenum; params: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetVertexAttribfvNV = procedure(index: TGLuint; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetVertexAttribivNV = procedure(index: TGLuint; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetVertexAttribPointervNV = procedure(index: TGLuint; pname: TGLenum; _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIsProgramNV = function(id: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglLoadProgramNV = procedure(target: TGLenum; id: TGLuint; len: TGLsizei; const _program: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglProgramParameter4dNV = procedure(target: TGLenum; index: TGLuint; x: TGLdouble; y: TGLdouble; z: TGLdouble; w: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglProgramParameter4dvNV = procedure(target: TGLenum; index: TGLuint; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglProgramParameter4fNV = procedure(target: TGLenum; index: TGLuint; x: TGLfloat; y: TGLfloat; z: TGLfloat; w: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglProgramParameter4fvNV = procedure(target: TGLenum; index: TGLuint; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglProgramParameters4dvNV = procedure(target: TGLenum; index: TGLuint; count: TGLuint; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglProgramParameters4fvNV = procedure(target: TGLenum; index: TGLuint; count: TGLuint; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglRequestResidentProgramsNV = procedure(n: TGLsizei; const programs: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTrackMatrixNV = procedure(target: TGLenum; address: TGLuint; matrix: TGLenum; transform: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttribPointerNV = procedure(index: TGLuint; fsize: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib1dNV = procedure(index: TGLuint; x: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib1dvNV = procedure(index: TGLuint; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib1fNV = procedure(index: TGLuint; x: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib1fvNV = procedure(index: TGLuint; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib1sNV = procedure(index: TGLuint; x: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib1svNV = procedure(index: TGLuint; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib2dNV = procedure(index: TGLuint; x: TGLdouble; y: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib2dvNV = procedure(index: TGLuint; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib2fNV = procedure(index: TGLuint; x: TGLfloat; y: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib2fvNV = procedure(index: TGLuint; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib2sNV = procedure(index: TGLuint; x: TGLshort; y: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib2svNV = procedure(index: TGLuint; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib3dNV = procedure(index: TGLuint; x: TGLdouble; y: TGLdouble; z: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib3dvNV = procedure(index: TGLuint; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib3fNV = procedure(index: TGLuint; x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib3fvNV = procedure(index: TGLuint; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib3sNV = procedure(index: TGLuint; x: TGLshort; y: TGLshort; z: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib3svNV = procedure(index: TGLuint; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4dNV = procedure(index: TGLuint; x: TGLdouble; y: TGLdouble; z: TGLdouble; w: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4dvNV = procedure(index: TGLuint; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4fNV = procedure(index: TGLuint; x: TGLfloat; y: TGLfloat; z: TGLfloat; w: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4fvNV = procedure(index: TGLuint; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4sNV = procedure(index: TGLuint; x: TGLshort; y: TGLshort; z: TGLshort; w: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4svNV = procedure(index: TGLuint; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4ubNV = procedure(index: TGLuint; x: TGLubyte; y: TGLubyte; z: TGLubyte; w: TGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttrib4ubvNV = procedure(index: TGLuint; const v: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttribs1dvNV = procedure(index: TGLuint; count: TGLsizei; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttribs1fvNV = procedure(index: TGLuint; count: TGLsizei; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttribs1svNV = procedure(index: TGLuint; count: TGLsizei; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttribs2dvNV = procedure(index: TGLuint; count: TGLsizei; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttribs2fvNV = procedure(index: TGLuint; count: TGLsizei; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttribs2svNV = procedure(index: TGLuint; count: TGLsizei; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttribs3dvNV = procedure(index: TGLuint; count: TGLsizei; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttribs3fvNV = procedure(index: TGLuint; count: TGLsizei; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttribs3svNV = procedure(index: TGLuint; count: TGLsizei; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttribs4dvNV = procedure(index: TGLuint; count: TGLsizei; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttribs4fvNV = procedure(index: TGLuint; count: TGLsizei; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttribs4svNV = procedure(index: TGLuint; count: TGLsizei; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglVertexAttribs4ubvNV = procedure(index: TGLuint; count: TGLsizei; const v: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_PGI_misc_hints
  TglHintPGI = procedure(target: TGLenum; mode: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SGIS_detail_texture
  TglDetailTexFuncSGIS = procedure(target: TGLenum; n: TGLsizei; const points: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetDetailTexFuncSGIS = procedure(target: TGLenum; points: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SGIS_fog_function
  TglFogFuncSGIS = procedure(n: TGLsizei; const points: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetFogFuncSGIS = procedure(points: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SGIS_multisample
  TglSampleMaskSGIS = procedure(value: TGLclampf; invert: TGLboolean); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSamplePatternSGIS = procedure(pattern: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SGIS_pixel_texture
  TglPixelTexGenParameteriSGIS = procedure(pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPixelTexGenParameterivSGIS = procedure(pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPixelTexGenParameterfSGIS = procedure(pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPixelTexGenParameterfvSGIS = procedure(pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetPixelTexGenParameterivSGIS = procedure(pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetPixelTexGenParameterfvSGIS = procedure(pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SGIS_point_parameters
  TglPointParameterfSGIS = procedure(pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPointParameterfvSGIS = procedure(pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SGIS_sharpen_texture
  TglSharpenTexFuncSGIS = procedure(target: TGLenum; n: TGLsizei; const points: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetSharpenTexFuncSGIS = procedure(target: TGLenum; points: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SGIS_texture4D
  TglTexImage4DSGIS = procedure(target: TGLenum; level: TGLint; internalformat: TGLenum; width: TGLsizei; height: TGLsizei; depth: TGLsizei; size4d: TGLsizei; border: TGLint; format: TGLenum; _type: TGLenum; const pixels: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexSubImage4DSGIS = procedure(target: TGLenum; level: TGLint; xoffset: TGLint; yoffset: TGLint; zoffset: TGLint; woffset: TGLint; width: TGLsizei; height: TGLsizei; depth: TGLsizei; size4d: TGLsizei; format: TGLenum; _type: TGLenum; const pixels: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SGIS_texture_color_mask
  TglTextureColorMaskSGIS = procedure(red: TGLboolean; green: TGLboolean; blue: TGLboolean; alpha: TGLboolean); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SGIS_texture_filter4
  TglGetTexFilterFuncSGIS = procedure(target: TGLenum; filter: TGLenum; weights: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexFilterFuncSGIS = procedure(target: TGLenum; filter: TGLenum; n: TGLsizei; const weights: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SGIX_async
  TglAsyncMarkerSGIX = procedure(marker: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFinishAsyncSGIX = function(markerp: PGLuint): TGLint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPollAsyncSGIX = function(markerp: PGLuint): TGLint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGenAsyncMarkersSGIX = function(range: TGLsizei): TGLuint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDeleteAsyncMarkersSGIX = procedure(marker: TGLuint; range: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglIsAsyncMarkerSGIX = function(marker: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SGIX_flush_raster
  TglFlushRasterSGIX = procedure(); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SGIX_fragment_lighting
  TglFragmentColorMaterialSGIX = procedure(face: TGLenum; mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFragmentLightfSGIX = procedure(light: TGLenum; pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFragmentLightfvSGIX = procedure(light: TGLenum; pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFragmentLightiSGIX = procedure(light: TGLenum; pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFragmentLightivSGIX = procedure(light: TGLenum; pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFragmentLightModelfSGIX = procedure(pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFragmentLightModelfvSGIX = procedure(pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFragmentLightModeliSGIX = procedure(pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFragmentLightModelivSGIX = procedure(pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFragmentMaterialfSGIX = procedure(face: TGLenum; pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFragmentMaterialfvSGIX = procedure(face: TGLenum; pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFragmentMaterialiSGIX = procedure(face: TGLenum; pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglFragmentMaterialivSGIX = procedure(face: TGLenum; pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetFragmentLightfvSGIX = procedure(light: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetFragmentLightivSGIX = procedure(light: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetFragmentMaterialfvSGIX = procedure(face: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetFragmentMaterialivSGIX = procedure(face: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglLightEnviSGIX = procedure(pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SGIX_framezoom
  TglFrameZoomSGIX = procedure(factor: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SGIX_igloo_interface
  TglIglooInterfaceSGIX = procedure(pname: TGLenum; const params: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SGIX_instruments
  TglGetInstrumentsSGIX = function(): TGLint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglInstrumentsBufferSGIX = procedure(size: TGLsizei; buffer: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglPollInstrumentsSGIX = function(marker_p: PGLint): TGLint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReadInstrumentsSGIX = procedure(marker: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglStartInstrumentsSGIX = procedure(); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglStopInstrumentsSGIX = procedure(marker: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SGIX_list_priority
  TglGetListParameterfvSGIX = procedure(list: TGLuint; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetListParameterivSGIX = procedure(list: TGLuint; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglListParameterfSGIX = procedure(list: TGLuint; pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglListParameterfvSGIX = procedure(list: TGLuint; pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglListParameteriSGIX = procedure(list: TGLuint; pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglListParameterivSGIX = procedure(list: TGLuint; pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SGIX_pixel_texture
  TglPixelTexGenSGIX = procedure(mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SGIX_polynomial_ffd
  TglDeformationMap3dSGIX = procedure(target: TGLenum; u1: TGLdouble; u2: TGLdouble; ustride: TGLint; uorder: TGLint; v1: TGLdouble; v2: TGLdouble; vstride: TGLint; vorder: TGLint; w1: TGLdouble; w2: TGLdouble; wstride: TGLint; worder: TGLint; const points: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDeformationMap3fSGIX = procedure(target: TGLenum; u1: TGLfloat; u2: TGLfloat; ustride: TGLint; uorder: TGLint; v1: TGLfloat; v2: TGLfloat; vstride: TGLint; vorder: TGLint; w1: TGLfloat; w2: TGLfloat; wstride: TGLint; worder: TGLint; const points: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglDeformSGIX = procedure(mask: TGLbitfield); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglLoadIdentityDeformationMapSGIX = procedure(mask: TGLbitfield); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SGIX_reference_plane
  TglReferencePlaneSGIX = procedure(const equation: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SGIX_sprite
  TglSpriteParameterfSGIX = procedure(pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSpriteParameterfvSGIX = procedure(pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSpriteParameteriSGIX = procedure(pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglSpriteParameterivSGIX = procedure(pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SGIX_tag_sample_buffer
  TglTagSampleBufferSGIX = procedure(); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SGI_color_table
  TglColorTableSGI = procedure(target: TGLenum; internalformat: TGLenum; width: TGLsizei; format: TGLenum; _type: TGLenum; const table: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColorTableParameterfvSGI = procedure(target: TGLenum; pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColorTableParameterivSGI = procedure(target: TGLenum; pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglCopyColorTableSGI = procedure(target: TGLenum; internalformat: TGLenum; x: TGLint; y: TGLint; width: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetColorTableSGI = procedure(target: TGLenum; format: TGLenum; _type: TGLenum; table: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetColorTableParameterfvSGI = procedure(target: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGetColorTableParameterivSGI = procedure(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SUNX_constant_data
  TglFinishTextureSUNX = procedure(); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SUN_global_alpha
  TglGlobalAlphaFactorbSUN = procedure(factor: TGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGlobalAlphaFactorsSUN = procedure(factor: TGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGlobalAlphaFactoriSUN = procedure(factor: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGlobalAlphaFactorfSUN = procedure(factor: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGlobalAlphaFactordSUN = procedure(factor: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGlobalAlphaFactorubSUN = procedure(factor: TGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGlobalAlphaFactorusSUN = procedure(factor: TGLushort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglGlobalAlphaFactoruiSUN = procedure(factor: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SUN_mesh_array
  TglDrawMeshArraysSUN = procedure(mode: TGLenum; first: TGLint; count: TGLsizei; width: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SUN_triangle_list
  TglReplacementCodeuiSUN = procedure(code: TGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReplacementCodeusSUN = procedure(code: TGLushort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReplacementCodeubSUN = procedure(code: TGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReplacementCodeuivSUN = procedure(const code: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReplacementCodeusvSUN = procedure(const code: PGLushort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReplacementCodeubvSUN = procedure(const code: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReplacementCodePointerSUN = procedure(_type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL_SUN_vertex
  TglColor4ubVertex2fSUN = procedure(r: TGLubyte; g: TGLubyte; b: TGLubyte; a: TGLubyte; x: TGLfloat; y: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor4ubVertex2fvSUN = procedure(const c: PGLubyte; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor4ubVertex3fSUN = procedure(r: TGLubyte; g: TGLubyte; b: TGLubyte; a: TGLubyte; x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor4ubVertex3fvSUN = procedure(const c: PGLubyte; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor3fVertex3fSUN = procedure(r: TGLfloat; g: TGLfloat; b: TGLfloat; x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor3fVertex3fvSUN = procedure(const c: PGLfloat; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormal3fVertex3fSUN = procedure(nx: TGLfloat; ny: TGLfloat; nz: TGLfloat; x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglNormal3fVertex3fvSUN = procedure(const n: PGLfloat; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor4fNormal3fVertex3fSUN = procedure(r: TGLfloat; g: TGLfloat; b: TGLfloat; a: TGLfloat; nx: TGLfloat; ny: TGLfloat; nz: TGLfloat; x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglColor4fNormal3fVertex3fvSUN = procedure(const c: PGLfloat; const n: PGLfloat; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord2fVertex3fSUN = procedure(s: TGLfloat; t: TGLfloat; x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord2fVertex3fvSUN = procedure(const tc: PGLfloat; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord4fVertex4fSUN = procedure(s: TGLfloat; t: TGLfloat; p: TGLfloat; q: TGLfloat; x: TGLfloat; y: TGLfloat; z: TGLfloat; w: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord4fVertex4fvSUN = procedure(const tc: PGLfloat; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord2fColor4ubVertex3fSUN = procedure(s: TGLfloat; t: TGLfloat; r: TGLubyte; g: TGLubyte; b: TGLubyte; a: TGLubyte; x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord2fColor4ubVertex3fvSUN = procedure(const tc: PGLfloat; const c: PGLubyte; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord2fColor3fVertex3fSUN = procedure(s: TGLfloat; t: TGLfloat; r: TGLfloat; g: TGLfloat; b: TGLfloat; x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord2fColor3fVertex3fvSUN = procedure(const tc: PGLfloat; const c: PGLfloat; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord2fNormal3fVertex3fSUN = procedure(s: TGLfloat; t: TGLfloat; nx: TGLfloat; ny: TGLfloat; nz: TGLfloat; x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord2fNormal3fVertex3fvSUN = procedure(const tc: PGLfloat; const n: PGLfloat; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord2fColor4fNormal3fVertex3fSUN = procedure(s: TGLfloat; t: TGLfloat; r: TGLfloat; g: TGLfloat; b: TGLfloat; a: TGLfloat; nx: TGLfloat; ny: TGLfloat; nz: TGLfloat; x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord2fColor4fNormal3fVertex3fvSUN = procedure(const tc: PGLfloat; const c: PGLfloat; const n: PGLfloat; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord4fColor4fNormal3fVertex4fSUN = procedure(s: TGLfloat; t: TGLfloat; p: TGLfloat; q: TGLfloat; r: TGLfloat; g: TGLfloat; b: TGLfloat; a: TGLfloat; nx: TGLfloat; ny: TGLfloat; nz: TGLfloat; x: TGLfloat; y: TGLfloat; z: TGLfloat; w: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglTexCoord4fColor4fNormal3fVertex4fvSUN = procedure(const tc: PGLfloat; const c: PGLfloat; const n: PGLfloat; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReplacementCodeuiVertex3fSUN = procedure(rc: TGLuint; x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReplacementCodeuiVertex3fvSUN = procedure(const rc: PGLuint; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReplacementCodeuiColor4ubVertex3fSUN = procedure(rc: TGLuint; r: TGLubyte; g: TGLubyte; b: TGLubyte; a: TGLubyte; x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReplacementCodeuiColor4ubVertex3fvSUN = procedure(const rc: PGLuint; const c: PGLubyte; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReplacementCodeuiColor3fVertex3fSUN = procedure(rc: TGLuint; r: TGLfloat; g: TGLfloat; b: TGLfloat; x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReplacementCodeuiColor3fVertex3fvSUN = procedure(const rc: PGLuint; const c: PGLfloat; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReplacementCodeuiNormal3fVertex3fSUN = procedure(rc: TGLuint; nx: TGLfloat; ny: TGLfloat; nz: TGLfloat; x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReplacementCodeuiNormal3fVertex3fvSUN = procedure(const rc: PGLuint; const n: PGLfloat; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReplacementCodeuiColor4fNormal3fVertex3fSUN = procedure(rc: TGLuint; r: TGLfloat; g: TGLfloat; b: TGLfloat; a: TGLfloat; nx: TGLfloat; ny: TGLfloat; nz: TGLfloat; x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReplacementCodeuiColor4fNormal3fVertex3fvSUN = procedure(const rc: PGLuint; const c: PGLfloat; const n: PGLfloat; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReplacementCodeuiTexCoord2fVertex3fSUN = procedure(rc: TGLuint; s: TGLfloat; t: TGLfloat; x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReplacementCodeuiTexCoord2fVertex3fvSUN = procedure(const rc: PGLuint; const tc: PGLfloat; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReplacementCodeuiTexCoord2fNormal3fVertex3fSUN = procedure(rc: TGLuint; s: TGLfloat; t: TGLfloat; nx: TGLfloat; ny: TGLfloat; nz: TGLfloat; x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN = procedure(const rc: PGLuint; const tc: PGLfloat; const n: PGLfloat; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN = procedure(rc: TGLuint; s: TGLfloat; t: TGLfloat; r: TGLfloat; g: TGLfloat; b: TGLfloat; a: TGLfloat; nx: TGLfloat; ny: TGLfloat; nz: TGLfloat; x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TglReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN = procedure(const rc: PGLuint; const tc: PGLfloat; const c: PGLfloat; const n: PGLfloat; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // window support functions
{$IFDEF Win32CLR}

{$IFDEF CLR}
  TwglGetProcAddress = function(ProcName: string): Integer; stdcall;
{$ELSE}
  TwglGetProcAddress = function(ProcName: PChar): Pointer; stdcall;
{$ENDIF}
  TwglCopyContext = function(p1: HGLRC; p2: HGLRC; p3: Cardinal): BOOL; stdcall;
  TwglCreateContext = function(DC: HDC): HGLRC; stdcall;
  TwglCreateLayerContext = function(p1: HDC; p2: Integer): HGLRC; stdcall;
  TwglDeleteContext = function(p1: HGLRC): BOOL; stdcall;
{$IFDEF CLR}
  TwglDescribeLayerPlane = function(p1: HDC; p2, p3: Integer; p4: Cardinal; var p5: TLayerPlaneDescriptor): BOOL; stdcall;
{$ELSE}
  TwglDescribeLayerPlane = function(p1: HDC; p2, p3: Integer; p4: Cardinal; p5: PLayerPlaneDescriptor): BOOL; stdcall;
{$ENDIF}
  TwglGetCurrentContext = function: HGLRC; stdcall;
  TwglGetCurrentDC = function: HDC; stdcall;
  TwglGetLayerPaletteEntries = function(p1: HDC; p2, p3, p4: Integer; var pcr): Integer; stdcall;
  TwglMakeCurrent = function(DC: HDC; p2: HGLRC): BOOL; stdcall;
  TwglRealizeLayerPalette = function(p1: HDC; p2: Integer; p3: BOOL): BOOL; stdcall;
  TwglSetLayerPaletteEntries = function(p1: HDC; p2, p3, p4: Integer; var pcr): Integer; stdcall;
  TwglShareLists = function(p1, p2: HGLRC): BOOL; stdcall;
  TwglSwapLayerBuffers = function(p1: HDC; p2: Cardinal): BOOL; stdcall;
{$IFDEF CLR}
  TwglSwapMultipleBuffers = function(p1: UINT; var p2: _WGLSWAP): DWORD; stdcall;
{$ELSE}
  TwglSwapMultipleBuffers = function(p1: UINT; const p2: PWGLSWAP): DWORD; stdcall;
{$ENDIF}
  TwglUseFontBitmapsA = function(DC: HDC; p2, p3, p4: DWORD): BOOL; stdcall;
  TwglUseFontBitmapsW = function(DC: HDC; p2, p3, p4: DWORD): BOOL; stdcall;
  TwglUseFontBitmaps = function(DC: HDC; p2, p3, p4: DWORD): BOOL; stdcall;
  
{$IFDEF CLR}
  TwglUseFontOutlinesA = function(p1: HDC; p2, p3, p4: DWORD; p5, p6: Single; p7: Integer; const p8: TGlyphMetricsFloat): BOOL; stdcall;
  TwglUseFontOutlinesW = function(p1: HDC; p2, p3, p4: DWORD; p5, p6: Single; p7: Integer; const p8: TGlyphMetricsFloat): BOOL; stdcall;
  TwglUseFontOutlines = function(p1: HDC; p2, p3, p4: DWORD; p5, p6: Single; p7: Integer; const p8: TGlyphMetricsFloat): BOOL; stdcall;
{$ELSE}
  TwglUseFontOutlinesA = function(p1: HDC; p2, p3, p4: DWORD; p5, p6: Single; p7: Integer; p8: PGlyphMetricsFloat): BOOL; stdcall;
  TwglUseFontOutlinesW = function(p1: HDC; p2, p3, p4: DWORD; p5, p6: Single; p7: Integer; p8: PGlyphMetricsFloat): BOOL; stdcall;
  TwglUseFontOutlines = function(p1: HDC; p2, p3, p4: DWORD; p5, p6: Single; p7: Integer; p8: PGlyphMetricsFloat): BOOL; stdcall;
{$ENDIF}

{$ENDIF}

{$IFDEF Win32CLR}
  // Changed by bero
  // WGL_ARB_buffer_region
  TwglCreateBufferRegionARB = function(hDC: HDC; iLayerPlane: TGLint; uType: TGLuint): THandle; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglDeleteBufferRegionARB = procedure(hRegion: THandle); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglSaveBufferRegionARB = function(hRegion: THandle; x: TGLint; y: TGLint; width: TGLint; height: TGLint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglRestoreBufferRegionARB = function(hRegion: THandle; x: TGLint; y: TGLint; width: TGLint; height: TGLint; xSrc: TGLint; ySrc: TGLint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // WGL_ARB_extensions_string
{$IFDEF CLR}
  TwglGetExtensionsStringARB = function(hdc: HDC): IntPtr; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ELSE}
  TwglGetExtensionsStringARB = function(hdc: HDC): PChar; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ENDIF}
  // WGL_ARB_make_current_read
  TwglMakeContextCurrentARB = function(hDrawDC: HDC; hReadDC: HDC; hglrc: HGLRC): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglGetCurrentReadDCARB = function(): HDC; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // WGL_ARB_pbuffer
  TwglCreatePbufferARB = function(hDC: HDC; iPixelFormat: TGLint; iWidth: TGLint; iHeight: TGLint; const piAttribList: PGLint): HPBUFFERARB; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglGetPbufferDCARB = function(hPbuffer: HPBUFFERARB): HDC; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglReleasePbufferDCARB = function(hPbuffer: HPBUFFERARB; hDC: HDC): TGLint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglDestroyPbufferARB = function(hPbuffer: HPBUFFERARB): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglQueryPbufferARB = function(hPbuffer: HPBUFFERARB; iAttribute: TGLint; piValue: PGLint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // WGL_ARB_pixel_format
  TwglGetPixelFormatAttribivARB = function(hdc: HDC; iPixelFormat: TGLint; iLayerPlane: TGLint; nAttributes: TGLuint; const piAttributes: PGLint; piValues: PGLint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglGetPixelFormatAttribfvARB = function(hdc: HDC; iPixelFormat: TGLint; iLayerPlane: TGLint; nAttributes: TGLuint; const piAttributes: PGLint; pfValues: PGLfloat): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglChoosePixelFormatARB = function(hdc: HDC; const piAttribIList: PGLint; const pfAttribFList: PGLfloat; nMaxFormats: TGLuint; piFormats: PGLint; nNumFormats: PGLuint): BOOL; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // WGL_ARB_color_buffer_float
  TwglClampColorARB = procedure(target: TGLenum; clamp: TGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // WGL_ARB_render_texture
  TwglBindTexImageARB = function(hPbuffer: HPBUFFERARB; iBuffer: TGLint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglReleaseTexImageARB = function(hPbuffer: HPBUFFERARB; iBuffer: TGLint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglSetPbufferAttribARB = function(hPbuffer: HPBUFFERARB; const piAttribList: PGLint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // WGL_EXT_display_color_table
  TwglCreateDisplayColorTableEXT = function(id: TGLushort): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglLoadDisplayColorTableEXT = function(const table: PGLushort; length: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglBindDisplayColorTableEXT = function(id: TGLushort): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglDestroyDisplayColorTableEXT = procedure(id: TGLushort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // WGL_EXT_extensions_string
{$IFDEF CLR}
  TwglGetExtensionsStringEXT = function(): IntPtr; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ELSE}
  TwglGetExtensionsStringEXT = function(): PChar; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ENDIF}

  // WGL_EXT_make_current_read
  TwglMakeContextCurrentEXT = function(hDrawDC: HDC; hReadDC: HDC; hglrc: HGLRC): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglGetCurrentReadDCEXT = function(): HDC; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // WGL_EXT_pbuffer
  TwglCreatePbufferEXT = function(hDC: HDC; iPixelFormat: TGLint; iWidth: TGLint; iHeight: TGLint; const piAttribList: PGLint): HPBUFFEREXT; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglGetPbufferDCEXT = function(hPbuffer: HPBUFFEREXT): HDC; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglReleasePbufferDCEXT = function(hPbuffer: HPBUFFEREXT; hDC: HDC): TGLint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglDestroyPbufferEXT = function(hPbuffer: HPBUFFEREXT): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglQueryPbufferEXT = function(hPbuffer: HPBUFFEREXT; iAttribute: TGLint; piValue: PGLint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // WGL_EXT_pixel_format
  TwglGetPixelFormatAttribivEXT = function(hdc: HDC; iPixelFormat: TGLint; iLayerPlane: TGLint; nAttributes: TGLuint; piAttributes: PGLint; piValues: PGLint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglGetPixelFormatAttribfvEXT = function(hdc: HDC; iPixelFormat: TGLint; iLayerPlane: TGLint; nAttributes: TGLuint; piAttributes: PGLint; pfValues: PGLfloat): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglChoosePixelFormatEXT = function(hdc: HDC; const piAttribIList: PGLint; const pfAttribFList: PGLfloat; nMaxFormats: TGLuint; piFormats: PGLint; nNumFormats: PGLuint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // WGL_EXT_swap_control
  TwglSwapIntervalEXT = function(interval: TGLint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglGetSwapIntervalEXT = function(): TGLint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // WGL_I3D_digital_video_control
  TwglGetDigitalVideoParametersI3D = function(hDC: HDC; iAttribute: TGLint; piValue: PGLint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglSetDigitalVideoParametersI3D = function(hDC: HDC; iAttribute: TGLint; const piValue: PGLint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // WGL_I3D_gamma
  TwglGetGammaTableParametersI3D = function(hDC: HDC; iAttribute: TGLint; piValue: PGLint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglSetGammaTableParametersI3D = function(hDC: HDC; iAttribute: TGLint; const piValue: PGLint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglGetGammaTableI3D = function(hDC: HDC; iEntries: TGLint; puRed: PGLushort; puGreen: PGLushort; puBlue: PGLushort): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglSetGammaTableI3D = function(hDC: HDC; iEntries: TGLint; const puRed: PGLushort; const puGreen: PGLushort; const puBlue: PGLushort): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // WGL_I3D_genlock
  TwglEnableGenlockI3D = function(hDC: HDC): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglDisableGenlockI3D = function(hDC: HDC): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglIsEnabledGenlockI3D = function(hDC: HDC; pFlag: Boolean): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglGenlockSourceI3D = function(hDC: HDC; uSource: TGLuint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglGetGenlockSourceI3D = function(hDC: HDC; uSource: PGLuint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglGenlockSourceEdgeI3D = function(hDC: HDC; uEdge: TGLuint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglGetGenlockSourceEdgeI3D = function(hDC: HDC; uEdge: PGLuint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglGenlockSampleRateI3D = function(hDC: HDC; uRate: TGLuint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglGetGenlockSampleRateI3D = function(hDC: HDC; uRate: PGLuint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglGenlockSourceDelayI3D = function(hDC: HDC; uDelay: TGLuint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglGetGenlockSourceDelayI3D = function(hDC: HDC; uDelay: PGLuint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglQueryGenlockMaxSourceDelayI3D = function(hDC: HDC; uMaxLineDelay: PGLuint; uMaxPixelDelay: PGLuint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // WGL_I3D_image_buffer
  TwglCreateImageBufferI3D = function(hDC: HDC; dwSize: TGLuint; uFlags: TGLuint): TGLvoid; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglDestroyImageBufferI3D = function(hDC: HDC; pAddress: TGLvoid): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglAssociateImageBufferEventsI3D = function(hDC: HDC; const pEvent: THandle; const pAddress: PGLvoid; const pSize: PGLuint; count: TGLuint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglReleaseImageBufferEventsI3D = function(hDC: HDC; const pAddress: PGLvoid; count: TGLuint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // WGL_I3D_swap_frame_lock
  TwglEnableFrameLockI3D = function(): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglDisableFrameLockI3D = function(): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglIsEnabledFrameLockI3D = function(pFlag: Boolean): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglQueryFrameLockMasterI3D = function(pFlag: Boolean): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // WGL_I3D_swap_frame_usage
  TwglGetFrameUsageI3D = function(pUsage: PGLfloat): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglBeginFrameTrackingI3D = function(): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglEndFrameTrackingI3D = function(): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglQueryFrameTrackingI3D = function(pFrameCount: PGLuint; pMissedFrames: PGLuint; pLastMissedUsage: PGLfloat): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // WGL_NV_vertex_array_range
  TwglAllocateMemoryNV = procedure(size: TGLsizei; readfreq: TGLfloat; writefreq: TGLfloat; priority: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglFreeMemoryNV = procedure(_pointer: Pointer); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // WGL_OML_sync_control
  TwglGetSyncValuesOML = function(hdc: HDC; ust: PGLint64; msc: PGLint64; sbc: PGLint64): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglGetMscRateOML = function(hdc: HDC; numerator: PGLint; denominator: PGLint): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglSwapBuffersMscOML = function(hdc: HDC; target_msc: TGLint64; divisor: TGLint64; remainder: TGLint64): TGLint64; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglSwapLayerBuffersMscOML = function(hdc: HDC; fuPlanes: TGLint; target_msc: TGLint64; divisor: TGLint64; remainder: TGLint64): TGLint64; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglWaitForMscOML = function(hdc: HDC; target_msc: TGLint64; divisor: TGLint64; remainder: TGLint64; ust: PGLint64; msc: PGLint64; sbc: PGLint64): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TwglWaitForSbcOML = function(hdc: HDC; target_sbc: TGLint64; ust: PGLint64; msc: PGLint64; sbc: PGLint64): Boolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ENDIF}

  // WIN_draw_range_elements
  TglDrawRangeElementsWIN = procedure(mode: TGLenum; start: TGLuint; _end: TGLuint; count: TGLsizei; _type: TGLenum; const indices: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // WIN_swap_hint
  TglAddSwapHintRectWIN = procedure(x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

  // GL utility functions and procedures
  TgluErrorString = function(errCode: TGLEnum): PChar; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$IFDEF CLR}
  TgluGetString = function(name: TGLEnum): IntPtr; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ELSE}
  TgluGetString = function(name: TGLEnum): PChar; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ENDIF}
  TgluOrtho2D = procedure(left, right, bottom, top: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluPerspective = procedure(fovy, aspect, zNear, zFar: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluPickMatrix = procedure(x, y, width, height: TGLdouble; viewport: TVector4i); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluLookAt = procedure(eyex, eyey, eyez, centerx, centery, centerz, upx, upy, upz: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$IFDEF CLR}
  TgluProject = function(objx, objy, objz: TGLdouble; modelMatrix: TGLMatrixd4; projMatrix: TGLMatrixd4; viewport: TVector4i; var winx, winy, winz: TGLdouble): TGLint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluUnProject = function(winx, winy, winz: TGLdouble; modelMatrix: TGLMatrixd4; projMatrix: TGLMatrixd4; viewport: TVector4i; var objx, objy, objz: TGLdouble): TGLint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ELSE}
  TgluProject = function(objx, objy, objz: TGLdouble; modelMatrix: TGLMatrixd4; projMatrix: TGLMatrixd4; viewport: TVector4i; winx, winy, winz: PGLdouble): TGLint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluUnProject = function(winx, winy, winz: TGLdouble; modelMatrix: TGLMatrixd4; projMatrix: TGLMatrixd4; viewport: TVector4i; objx, objy, objz: PGLdouble): TGLint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
{$ENDIF}
  TgluScaleImage = function(format: TGLEnum; widthin, heightin: TGLint; typein: TGLEnum; datain: Pointer; widthout, heightout: TGLint; typeout: TGLEnum; dataout: Pointer): TGLint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluBuild1DMipmaps = function(target: TGLEnum; components, width: TGLint; format, atype: TGLEnum; data: Pointer): TGLint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluBuild2DMipmaps = function(target: TGLEnum; components, width, height: TGLint; format, atype: TGLEnum; Data: Pointer): TGLint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluNewQuadric = function: PGLUquadric; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluDeleteQuadric = procedure(state: PGLUquadric); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluQuadricNormals = procedure(quadObject: PGLUquadric; normals: TGLEnum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluQuadricTexture = procedure(quadObject: PGLUquadric; textureCoords: TGLboolean); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluQuadricOrientation = procedure(quadObject: PGLUquadric; orientation: TGLEnum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluQuadricDrawStyle = procedure(quadObject: PGLUquadric; drawStyle: TGLEnum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluCylinder = procedure(quadObject: PGLUquadric; baseRadius, topRadius, height: TGLdouble; slices, stacks: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluDisk = procedure(quadObject: PGLUquadric; innerRadius, outerRadius: TGLdouble; slices, loops: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluPartialDisk = procedure(quadObject: PGLUquadric; innerRadius, outerRadius: TGLdouble; slices, loops: TGLint; startAngle, sweepAngle: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluSphere = procedure(quadObject: PGLUquadric; radius: TGLdouble; slices, stacks: TGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluQuadricCallback = procedure(quadObject: PGLUquadric; which: TGLEnum; fn: TGLUQuadricErrorProc); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluNewTess = function: PGLUtesselator; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluDeleteTess = procedure(tess: PGLUtesselator); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluTessBeginPolygon = procedure(tess: PGLUtesselator; polygon_data: Pointer); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluTessBeginContour = procedure(tess: PGLUtesselator); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluTessVertex = procedure(tess: PGLUtesselator; coords: TGLArrayd3; data: Pointer); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluTessEndContour = procedure(tess: PGLUtesselator); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluTessEndPolygon = procedure(tess: PGLUtesselator); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluTessProperty = procedure(tess: PGLUtesselator; which: TGLEnum; value: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluTessNormal = procedure(tess: PGLUtesselator; x, y, z: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluTessCallback = procedure(tess: PGLUtesselator; which: TGLEnum; fn: Pointer); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluGetTessProperty = procedure(tess: PGLUtesselator; which: TGLEnum; value: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluNewNurbsRenderer = function: PGLUnurbs; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluDeleteNurbsRenderer = procedure(nobj: PGLUnurbs); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluBeginSurface = procedure(nobj: PGLUnurbs); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluBeginCurve = procedure(nobj: PGLUnurbs); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluEndCurve = procedure(nobj: PGLUnurbs); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluEndSurface = procedure(nobj: PGLUnurbs); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluBeginTrim = procedure(nobj: PGLUnurbs); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluEndTrim = procedure(nobj: PGLUnurbs); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluPwlCurve = procedure(nobj: PGLUnurbs; count: TGLint; points: PGLfloat; stride: TGLint; atype: TGLEnum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluNurbsCurve = procedure(nobj: PGLUnurbs; nknots: TGLint; knot: PGLfloat; stride: TGLint; ctlarray: PGLfloat; order: TGLint; atype: TGLEnum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluNurbsSurface = procedure(nobj: PGLUnurbs; sknot_count: TGLint; sknot: PGLfloat; tknot_count: TGLint; tknot: PGLfloat; s_stride, t_stride: TGLint; ctlarray: PGLfloat; sorder, torder: TGLint; atype: TGLEnum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluLoadSamplingMatrices = procedure(nobj: PGLUnurbs; modelMatrix, projMatrix: TGLMatrixf4; viewport: TVector4i); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluNurbsProperty = procedure(nobj: PGLUnurbs; aproperty: TGLEnum; value: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluGetNurbsProperty = procedure(nobj: PGLUnurbs; aproperty: TGLEnum; value: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluNurbsCallback = procedure(nobj: PGLUnurbs; which: TGLEnum; fn: TGLUNurbsErrorProc); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluBeginPolygon = procedure(tess: PGLUtesselator); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluNextContour = procedure(tess: PGLUtesselator; atype: TGLEnum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
  TgluEndPolygon = procedure(tess: PGLUtesselator); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}

var
  // GL_VERSION_1_1
  glAccum: TglAccum;
  glAlphaFunc: TglAlphaFunc;
  glAreTexturesResident: TglAreTexturesResident;
  glArrayElement: TglArrayElement;
  glBegin: TglBegin;
  glBindTexture: TglBindTexture;
  glBitmap: TglBitmap;
  glBlendFunc: TglBlendFunc;
  glCallList: TglCallList;
  glCallLists: TglCallLists;
  glClear: TglClear;
  glClearAccum: TglClearAccum;
  glClearColor: TglClearColor;
  glClearDepth: TglClearDepth;
  glClearIndex: TglClearIndex;
  glClearStencil: TglClearStencil;
  glClipPlane: TglClipPlane;
  glColor3b: TglColor3b;
  glColor3bv: TglColor3bv;
  glColor3d: TglColor3d;
  glColor3dv: TglColor3dv;
  glColor3f: TglColor3f;
  glColor3fv: TglColor3fv;
  glColor3i: TglColor3i;
  glColor3iv: TglColor3iv;
  glColor3s: TglColor3s;
  glColor3sv: TglColor3sv;
  glColor3ub: TglColor3ub;
  glColor3ubv: TglColor3ubv;
  glColor3ui: TglColor3ui;
  glColor3uiv: TglColor3uiv;
  glColor3us: TglColor3us;
  glColor3usv: TglColor3usv;
  glColor4b: TglColor4b;
  glColor4bv: TglColor4bv;
  glColor4d: TglColor4d;
  glColor4dv: TglColor4dv;
  glColor4f: TglColor4f;
  glColor4fv: TglColor4fv;
  glColor4i: TglColor4i;
  glColor4iv: TglColor4iv;
  glColor4s: TglColor4s;
  glColor4sv: TglColor4sv;
  glColor4ub: TglColor4ub;
  glColor4ubv: TglColor4ubv;
  glColor4ui: TglColor4ui;
  glColor4uiv: TglColor4uiv;
  glColor4us: TglColor4us;
  glColor4usv: TglColor4usv;
  glColorMask: TglColorMask;
  glColorMaterial: TglColorMaterial;
  glCopyPixels: TglCopyPixels;
  glCopyTexImage1D: TglCopyTexImage1D;
  glCopyTexImage2D: TglCopyTexImage2D;
  glCopyTexSubImage1D: TglCopyTexSubImage1D;
  glCopyTexSubImage2D: TglCopyTexSubImage2D;
  glCullFace: TglCullFace;
  glDeleteLists: TglDeleteLists;
  glDeleteTextures: TglDeleteTextures;
  glDepthFunc: TglDepthFunc;
  glDepthMask: TglDepthMask;
  glDepthRange: TglDepthRange;
  glDisable: TglDisable;
  glDisableClientState: TglDisableClientState;
  glDrawArrays: TglDrawArrays;
  glDrawBuffer: TglDrawBuffer;
  glDrawElements: TglDrawElements;
  glDrawPixels: TglDrawPixels;
  glEdgeFlag: TglEdgeFlag;
  glEdgeFlagPointer: TglEdgeFlagPointer;
  glEdgeFlagv: TglEdgeFlagv;
  glEnable: TglEnable;
  glEnableClientState: TglEnableClientState;
  glEnd: TglEnd;
  glEndList: TglEndList;
  glEvalCoord1d: TglEvalCoord1d;
  glEvalCoord1dv: TglEvalCoord1dv;
  glEvalCoord1f: TglEvalCoord1f;
  glEvalCoord1fv: TglEvalCoord1fv;
  glEvalCoord2d: TglEvalCoord2d;
  glEvalCoord2dv: TglEvalCoord2dv;
  glEvalCoord2f: TglEvalCoord2f;
  glEvalCoord2fv: TglEvalCoord2fv;
  glEvalMesh1: TglEvalMesh1;
  glEvalMesh2: TglEvalMesh2;
  glEvalPoint1: TglEvalPoint1;
  glEvalPoint2: TglEvalPoint2;
  glFeedbackBuffer: TglFeedbackBuffer;
  glFinish: TglFinish;
  glFlush: TglFlush;
  glFogf: TglFogf;
  glFogfv: TglFogfv;
  glFogi: TglFogi;
  glFogiv: TglFogiv;
  glFrontFace: TglFrontFace;
  glFrustum: TglFrustum;
  glGenLists: TglGenLists;
  glGetBooleanv: TglGetBooleanv;
  glGetClipPlane: TglGetClipPlane;
  glGetDoublev: TglGetDoublev;
  glGetError: TglGetError;
  glGetFloatv: TglGetFloatv;
  glGetIntegerv: TglGetIntegerv;
  glGetLightfv: TglGetLightfv;
  glGetLightiv: TglGetLightiv;
  glGetMapdv: TglGetMapdv;
  glGetMapfv: TglGetMapfv;
  glGetMapiv: TglGetMapiv;
  glGetMaterialfv: TglGetMaterialfv;
  glGetMaterialiv: TglGetMaterialiv;
  glGetPixelMapfv: TglGetPixelMapfv;
  glGetPixelMapuiv: TglGetPixelMapuiv;
  glGetPixelMapusv: TglGetPixelMapusv;
  glGetPointerv: TglGetPointerv;
  glGetPolygonStipple: TglGetPolygonStipple;
  glGetTexEnvfv: TglGetTexEnvfv;
  glGetTexEnviv: TglGetTexEnviv;
  glGetTexGendv: TglGetTexGendv;
  glGetTexGenfv: TglGetTexGenfv;
  glGetTexGeniv: TglGetTexGeniv;
  glGetTexImage: TglGetTexImage;
  glGetTexLevelParameterfv: TglGetTexLevelParameterfv;
  glGetTexLevelParameteriv: TglGetTexLevelParameteriv;
  glGetTexParameterfv: TglGetTexParameterfv;
  glGetTexParameteriv: TglGetTexParameteriv;
  glHint: TglHint;
  glIndexMask: TglIndexMask;
  glIndexPointer: TglIndexPointer;
  glIndexd: TglIndexd;
  glIndexdv: TglIndexdv;
  glIndexf: TglIndexf;
  glIndexfv: TglIndexfv;
  glIndexi: TglIndexi;
  glIndexiv: TglIndexiv;
  glIndexs: TglIndexs;
  glIndexsv: TglIndexsv;
  glIndexub: TglIndexub;
  glIndexubv: TglIndexubv;
  glInitNames: TglInitNames;
  glInterleavedArrays: TglInterleavedArrays;
  glIsEnabled: TglIsEnabled;
  glIsList: TglIsList;
  glIsTexture: TglIsTexture;
  glLightModelf: TglLightModelf;
  glLightModelfv: TglLightModelfv;
  glLightModeli: TglLightModeli;
  glLightModeliv: TglLightModeliv;
  glLightf: TglLightf;
  glLightfv: TglLightfv;
  glLighti: TglLighti;
  glLightiv: TglLightiv;
  glLineStipple: TglLineStipple;
  glLineWidth: TglLineWidth;
  glListBase: TglListBase;
  glLoadIdentity: TglLoadIdentity;
  glLoadMatrixd: TglLoadMatrixd;
  glLoadMatrixf: TglLoadMatrixf;
  glLoadName: TglLoadName;
  glLogicOp: TglLogicOp;
  glMap1d: TglMap1d;
  glMap1f: TglMap1f;
  glMap2d: TglMap2d;
  glMap2f: TglMap2f;
  glMapGrid1d: TglMapGrid1d;
  glMapGrid1f: TglMapGrid1f;
  glMapGrid2d: TglMapGrid2d;
  glMapGrid2f: TglMapGrid2f;
  glMaterialf: TglMaterialf;
  glMaterialfv: TglMaterialfv;
  glMateriali: TglMateriali;
  glMaterialiv: TglMaterialiv;
  glMatrixMode: TglMatrixMode;
  glMultMatrixd: TglMultMatrixd;
  glMultMatrixf: TglMultMatrixf;
  glNewList: TglNewList;
  glNormal3b: TglNormal3b;
  glNormal3bv: TglNormal3bv;
  glNormal3d: TglNormal3d;
  glNormal3dv: TglNormal3dv;
  glNormal3f: TglNormal3f;
  glNormal3fv: TglNormal3fv;
  glNormal3i: TglNormal3i;
  glNormal3iv: TglNormal3iv;
  glNormal3s: TglNormal3s;
  glNormal3sv: TglNormal3sv;
  glOrtho: TglOrtho;
  glPassThrough: TglPassThrough;
  glPixelMapfv: TglPixelMapfv;
  glPixelMapuiv: TglPixelMapuiv;
  glPixelMapusv: TglPixelMapusv;
  glPixelStoref: TglPixelStoref;
  glPixelStorei: TglPixelStorei;
  glPixelTransferf: TglPixelTransferf;
  glPixelTransferi: TglPixelTransferi;
  glPixelZoom: TglPixelZoom;
  glPointSize: TglPointSize;
  glPolygonMode: TglPolygonMode;
  glPolygonOffset: TglPolygonOffset;
  glPolygonStipple: TglPolygonStipple;
  glPopAttrib: TglPopAttrib;
  glPopClientAttrib: TglPopClientAttrib;
  glPopMatrix: TglPopMatrix;
  glPopName: TglPopName;
  glPrioritizeTextures: TglPrioritizeTextures;
  glPushAttrib: TglPushAttrib;
  glPushClientAttrib: TglPushClientAttrib;
  glPushMatrix: TglPushMatrix;
  glPushName: TglPushName;
  glRasterPos2d: TglRasterPos2d;
  glRasterPos2dv: TglRasterPos2dv;
  glRasterPos2f: TglRasterPos2f;
  glRasterPos2fv: TglRasterPos2fv;
  glRasterPos2i: TglRasterPos2i;
  glRasterPos2iv: TglRasterPos2iv;
  glRasterPos2s: TglRasterPos2s;
  glRasterPos2sv: TglRasterPos2sv;
  glRasterPos3d: TglRasterPos3d;
  glRasterPos3dv: TglRasterPos3dv;
  glRasterPos3f: TglRasterPos3f;
  glRasterPos3fv: TglRasterPos3fv;
  glRasterPos3i: TglRasterPos3i;
  glRasterPos3iv: TglRasterPos3iv;
  glRasterPos3s: TglRasterPos3s;
  glRasterPos3sv: TglRasterPos3sv;
  glRasterPos4d: TglRasterPos4d;
  glRasterPos4dv: TglRasterPos4dv;
  glRasterPos4f: TglRasterPos4f;
  glRasterPos4fv: TglRasterPos4fv;
  glRasterPos4i: TglRasterPos4i;
  glRasterPos4iv: TglRasterPos4iv;
  glRasterPos4s: TglRasterPos4s;
  glRasterPos4sv: TglRasterPos4sv;
  glReadBuffer: TglReadBuffer;
  glRectd: TglRectd;
  glRectdv: TglRectdv;
  glRectf: TglRectf;
  glRectfv: TglRectfv;
  glRecti: TglRecti;
  glRectiv: TglRectiv;
  glRects: TglRects;
  glRectsv: TglRectsv;
  glRenderMode: TglRenderMode;
  glRotated: TglRotated;
  glRotatef: TglRotatef;
  glScaled: TglScaled;
  glScalef: TglScalef;
  glScissor: TglScissor;
  glSelectBuffer: TglSelectBuffer;
  glShadeModel: TglShadeModel;
  glStencilFunc: TglStencilFunc;
  glStencilMask: TglStencilMask;
  glStencilOp: TglStencilOp;
  glTexCoord1d: TglTexCoord1d;
  glTexCoord1dv: TglTexCoord1dv;
  glTexCoord1f: TglTexCoord1f;
  glTexCoord1fv: TglTexCoord1fv;
  glTexCoord1i: TglTexCoord1i;
  glTexCoord1iv: TglTexCoord1iv;
  glTexCoord1s: TglTexCoord1s;
  glTexCoord1sv: TglTexCoord1sv;
  glTexCoord2d: TglTexCoord2d;
  glTexCoord2dv: TglTexCoord2dv;
  glTexCoord2f: TglTexCoord2f;
  glTexCoord2fv: TglTexCoord2fv;
  glTexCoord2i: TglTexCoord2i;
  glTexCoord2iv: TglTexCoord2iv;
  glTexCoord2s: TglTexCoord2s;
  glTexCoord2sv: TglTexCoord2sv;
  glTexCoord3d: TglTexCoord3d;
  glTexCoord3dv: TglTexCoord3dv;
  glTexCoord3f: TglTexCoord3f;
  glTexCoord3fv: TglTexCoord3fv;
  glTexCoord3i: TglTexCoord3i;
  glTexCoord3iv: TglTexCoord3iv;
  glTexCoord3s: TglTexCoord3s;
  glTexCoord3sv: TglTexCoord3sv;
  glTexCoord4d: TglTexCoord4d;
  glTexCoord4dv: TglTexCoord4dv;
  glTexCoord4f: TglTexCoord4f;
  glTexCoord4fv: TglTexCoord4fv;
  glTexCoord4i: TglTexCoord4i;
  glTexCoord4iv: TglTexCoord4iv;
  glTexCoord4s: TglTexCoord4s;
  glTexCoord4sv: TglTexCoord4sv;
  glTexEnvf: TglTexEnvf;
  glTexEnvfv: TglTexEnvfv;
  glTexEnvi: TglTexEnvi;
  glTexEnviv: TglTexEnviv;
  glTexGend: TglTexGend;
  glTexGendv: TglTexGendv;
  glTexGenf: TglTexGenf;
  glTexGenfv: TglTexGenfv;
  glTexGeni: TglTexGeni;
  glTexGeniv: TglTexGeniv;
  glTexImage1D: TglTexImage1D;
  glTexParameterf: TglTexParameterf;
  glTexParameterfv: TglTexParameterfv;
  glTexParameteri: TglTexParameteri;
  glTexParameteriv: TglTexParameteriv;
  glTexSubImage1D: TglTexSubImage1D;
  glTexSubImage2D: TglTexSubImage2D;
  glTranslated: TglTranslated;
  glTranslatef: TglTranslatef;
  glVertex2d: TglVertex2d;
  glVertex2dv: TglVertex2dv;
  glVertex2f: TglVertex2f;
  glVertex2fv: TglVertex2fv;
  glVertex2i: TglVertex2i;
  glVertex2iv: TglVertex2iv;
  glVertex2s: TglVertex2s;
  glVertex2sv: TglVertex2sv;
  glVertex3d: TglVertex3d;
  glVertex3dv: TglVertex3dv;
  glVertex3f: TglVertex3f;
  glVertex3fv: TglVertex3fv;
  glVertex3i: TglVertex3i;
  glVertex3iv: TglVertex3iv;
  glVertex3s: TglVertex3s;
  glVertex3sv: TglVertex3sv;
  glVertex4d: TglVertex4d;
  glVertex4dv: TglVertex4dv;
  glVertex4f: TglVertex4f;
  glVertex4fv: TglVertex4fv;
  glVertex4i: TglVertex4i;
  glVertex4iv: TglVertex4iv;
  glVertex4s: TglVertex4s;
  glVertex4sv: TglVertex4sv;
  glViewport: TglViewport;

  // GL_VERSION_1_2
  glBlendColor: TglBlendColor;
  glBlendEquation: TglBlendEquation;
  glDrawRangeElements: TglDrawRangeElements;
  glColorTable: TglColorTable;
  glColorTableParameterfv: TglColorTableParameterfv;
  glColorTableParameteriv: TglColorTableParameteriv;
  glCopyColorTable: TglCopyColorTable;
  glGetColorTable: TglGetColorTable;
  glGetColorTableParameterfv: TglGetColorTableParameterfv;
  glGetColorTableParameteriv: TglGetColorTableParameteriv;
  glColorSubTable: TglColorSubTable;
  glCopyColorSubTable: TglCopyColorSubTable;
  glConvolutionFilter1D: TglConvolutionFilter1D;
  glConvolutionFilter2D: TglConvolutionFilter2D;
  glConvolutionParameterf: TglConvolutionParameterf;
  glConvolutionParameterfv: TglConvolutionParameterfv;
  glConvolutionParameteri: TglConvolutionParameteri;
  glConvolutionParameteriv: TglConvolutionParameteriv;
  glCopyConvolutionFilter1D: TglCopyConvolutionFilter1D;
  glCopyConvolutionFilter2D: TglCopyConvolutionFilter2D;
  glGetConvolutionFilter: TglGetConvolutionFilter;
  glGetConvolutionParameterfv: TglGetConvolutionParameterfv;
  glGetConvolutionParameteriv: TglGetConvolutionParameteriv;
  glGetSeparableFilter: TglGetSeparableFilter;
  glSeparableFilter2D: TglSeparableFilter2D;
  glGetHistogram: TglGetHistogram;
  glGetHistogramParameterfv: TglGetHistogramParameterfv;
  glGetHistogramParameteriv: TglGetHistogramParameteriv;
  glGetMinmax: TglGetMinmax;
  glGetMinmaxParameterfv: TglGetMinmaxParameterfv;
  glGetMinmaxParameteriv: TglGetMinmaxParameteriv;
  glHistogram: TglHistogram;
  glMinmax: TglMinmax;
  glResetHistogram: TglResetHistogram;
  glResetMinmax: TglResetMinmax;
  glTexImage3D: TglTexImage3D;
  glTexSubImage3D: TglTexSubImage3D;
  glCopyTexSubImage3D: TglCopyTexSubImage3D;

  // GL_VERSION_1_3
  glActiveTexture: TglActiveTexture;
  glClientActiveTexture: TglClientActiveTexture;
  glMultiTexCoord1d: TglMultiTexCoord1d;
  glMultiTexCoord1dv: TglMultiTexCoord1dv;
  glMultiTexCoord1f: TglMultiTexCoord1f;
  glMultiTexCoord1fv: TglMultiTexCoord1fv;
  glMultiTexCoord1i: TglMultiTexCoord1i;
  glMultiTexCoord1iv: TglMultiTexCoord1iv;
  glMultiTexCoord1s: TglMultiTexCoord1s;
  glMultiTexCoord1sv: TglMultiTexCoord1sv;
  glMultiTexCoord2d: TglMultiTexCoord2d;
  glMultiTexCoord2dv: TglMultiTexCoord2dv;
  glMultiTexCoord2f: TglMultiTexCoord2f;
  glMultiTexCoord2fv: TglMultiTexCoord2fv;
  glMultiTexCoord2i: TglMultiTexCoord2i;
  glMultiTexCoord2iv: TglMultiTexCoord2iv;
  glMultiTexCoord2s: TglMultiTexCoord2s;
  glMultiTexCoord2sv: TglMultiTexCoord2sv;
  glMultiTexCoord3d: TglMultiTexCoord3d;
  glMultiTexCoord3dv: TglMultiTexCoord3dv;
  glMultiTexCoord3f: TglMultiTexCoord3f;
  glMultiTexCoord3fv: TglMultiTexCoord3fv;
  glMultiTexCoord3i: TglMultiTexCoord3i;
  glMultiTexCoord3iv: TglMultiTexCoord3iv;
  glMultiTexCoord3s: TglMultiTexCoord3s;
  glMultiTexCoord3sv: TglMultiTexCoord3sv;
  glMultiTexCoord4d: TglMultiTexCoord4d;
  glMultiTexCoord4dv: TglMultiTexCoord4dv;
  glMultiTexCoord4f: TglMultiTexCoord4f;
  glMultiTexCoord4fv: TglMultiTexCoord4fv;
  glMultiTexCoord4i: TglMultiTexCoord4i;
  glMultiTexCoord4iv: TglMultiTexCoord4iv;
  glMultiTexCoord4s: TglMultiTexCoord4s;
  glMultiTexCoord4sv: TglMultiTexCoord4sv;
  glLoadTransposeMatrixf: TglLoadTransposeMatrixf;
  glLoadTransposeMatrixd: TglLoadTransposeMatrixd;
  glMultTransposeMatrixf: TglMultTransposeMatrixf;
  glMultTransposeMatrixd: TglMultTransposeMatrixd;
  glSampleCoverage: TglSampleCoverage;
  glCompressedTexImage3D: TglCompressedTexImage3D;
  glCompressedTexImage2D: TglCompressedTexImage2D;
  glCompressedTexImage1D: TglCompressedTexImage1D;
  glCompressedTexSubImage3D: TglCompressedTexSubImage3D;
  glCompressedTexSubImage2D: TglCompressedTexSubImage2D;
  glCompressedTexSubImage1D: TglCompressedTexSubImage1D;
  glGetCompressedTexImage: TglGetCompressedTexImage;

  // GL_VERSION_1_4
  glBlendFuncSeparate: TglBlendFuncSeparate;
  glFogCoordf: TglFogCoordf;
  glFogCoordfv: TglFogCoordfv;
  glFogCoordd: TglFogCoordd;
  glFogCoorddv: TglFogCoorddv;
  glFogCoordPointer: TglFogCoordPointer;
  glMultiDrawArrays: TglMultiDrawArrays;
  glMultiDrawElements: TglMultiDrawElements;
  glPointParameterf: TglPointParameterf;
  glPointParameterfv: TglPointParameterfv;
  glPointParameteri: TglPointParameteri;
  glPointParameteriv: TglPointParameteriv;
  glSecondaryColor3b: TglSecondaryColor3b;
  glSecondaryColor3bv: TglSecondaryColor3bv;
  glSecondaryColor3d: TglSecondaryColor3d;
  glSecondaryColor3dv: TglSecondaryColor3dv;
  glSecondaryColor3f: TglSecondaryColor3f;
  glSecondaryColor3fv: TglSecondaryColor3fv;
  glSecondaryColor3i: TglSecondaryColor3i;
  glSecondaryColor3iv: TglSecondaryColor3iv;
  glSecondaryColor3s: TglSecondaryColor3s;
  glSecondaryColor3sv: TglSecondaryColor3sv;
  glSecondaryColor3ub: TglSecondaryColor3ub;
  glSecondaryColor3ubv: TglSecondaryColor3ubv;
  glSecondaryColor3ui: TglSecondaryColor3ui;
  glSecondaryColor3uiv: TglSecondaryColor3uiv;
  glSecondaryColor3us: TglSecondaryColor3us;
  glSecondaryColor3usv: TglSecondaryColor3usv;
  glSecondaryColorPointer: TglSecondaryColorPointer;
  glWindowPos2d: TglWindowPos2d;
  glWindowPos2dv: TglWindowPos2dv;
  glWindowPos2f: TglWindowPos2f;
  glWindowPos2fv: TglWindowPos2fv;
  glWindowPos2i: TglWindowPos2i;
  glWindowPos2iv: TglWindowPos2iv;
  glWindowPos2s: TglWindowPos2s;
  glWindowPos2sv: TglWindowPos2sv;
  glWindowPos3d: TglWindowPos3d;
  glWindowPos3dv: TglWindowPos3dv;
  glWindowPos3f: TglWindowPos3f;
  glWindowPos3fv: TglWindowPos3fv;
  glWindowPos3i: TglWindowPos3i;
  glWindowPos3iv: TglWindowPos3iv;
  glWindowPos3s: TglWindowPos3s;
  glWindowPos3sv: TglWindowPos3sv;

  // GL_VERSION_1_5
  glGenQueries: TglGenQueries;
  glDeleteQueries: TglDeleteQueries;
  glIsQuery: TglIsQuery;
  glBeginQuery: TglBeginQuery;
  glEndQuery: TglEndQuery;
  glGetQueryiv: TglGetQueryiv;
  glGetQueryObjectiv: TglGetQueryObjectiv;
  glGetQueryObjectuiv: TglGetQueryObjectuiv;
  glBindBuffer: TglBindBuffer;
  glDeleteBuffers: TglDeleteBuffers;
  glGenBuffers: TglGenBuffers;
  glIsBuffer: TglIsBuffer;
  glGetBufferSubData: TglGetBufferSubData;
  glMapBuffer: TglMapBuffer;
  glUnmapBuffer: TglUnmapBuffer;
  glGetBufferParameteriv: TglGetBufferParameteriv;
  glGetBufferPointerv: TglGetBufferPointerv;

  // GL_VERSION_2_0
  glBlendEquationSeparate: TglBlendEquationSeparate;
  glDrawBuffers: TglDrawBuffers;
  glStencilOpSeparate: TglStencilOpSeparate;
  glStencilFuncSeparate: TglStencilFuncSeparate;
  glStencilMaskSeparate: TglStencilMaskSeparate;
  glAttachShader: TglAttachShader;
  glBindAttribLocation: TglBindAttribLocation;
  glCompileShader: TglCompileShader;
  glCreateProgram: TglCreateProgram;
  glCreateShader: TglCreateShader;
  glDeleteProgram: TglDeleteProgram;
  glDeleteShader: TglDeleteShader;
  glDetachShader: TglDetachShader;
  glDisableVertexAttribArray: TglDisableVertexAttribArray;
  glEnableVertexAttribArray: TglEnableVertexAttribArray;
  glGetActiveAttrib: TglGetActiveAttrib;
  glGetActiveUniform: TglGetActiveUniform;
  glGetAttachedShaders: TglGetAttachedShaders;
  glGetAttribLocation: TglGetAttribLocation;
  glGetProgramiv: TglGetProgramiv;
  _glGetProgramInfoLog: TglGetProgramInfoLog;
  glGetShaderiv: TglGetShaderiv;
  _glGetShaderInfoLog: TglGetShaderInfoLog;
  glGetShaderSource: TglGetShaderSource;
  glGetUniformLocation: TglGetUniformLocation;
  glGetUniformfv: TglGetUniformfv;
  glGetUniformiv: TglGetUniformiv;
  glGetVertexAttribfv: TglGetVertexAttribfv;
  glGetVertexAttribiv: TglGetVertexAttribiv;
  glGetVertexAttribPointerv: TglGetVertexAttribPointerv;
  glIsProgram: TglIsProgram;
  glIsShader: TglIsShader;
  glLinkProgram: TglLinkProgram;
  _glShaderSource: TglShaderSource;
  glUseProgram: TglUseProgram;
  glUniform1f: TglUniform1f;
  glUniform2f: TglUniform2f;
  glUniform3f: TglUniform3f;
  glUniform4f: TglUniform4f;
  glUniform1i: TglUniform1i;
  glUniform2i: TglUniform2i;
  glUniform3i: TglUniform3i;
  glUniform4i: TglUniform4i;
  glUniform1fv: TglUniform1fv;
  glUniform2fv: TglUniform2fv;
  glUniform3fv: TglUniform3fv;
  glUniform4fv: TglUniform4fv;
  glUniform1iv: TglUniform1iv;
  glUniform2iv: TglUniform2iv;
  glUniform3iv: TglUniform3iv;
  glUniform4iv: TglUniform4iv;
  glUniformMatrix2fv: TglUniformMatrix2fv;
  glUniformMatrix3fv: TglUniformMatrix3fv;
  glUniformMatrix4fv: TglUniformMatrix4fv;
  glValidateProgram: TglValidateProgram;
  glVertexAttrib1d: TglVertexAttrib1d;
  glVertexAttrib1dv: TglVertexAttrib1dv;
  glVertexAttrib1f: TglVertexAttrib1f;
  glVertexAttrib1fv: TglVertexAttrib1fv;
  glVertexAttrib1s: TglVertexAttrib1s;
  glVertexAttrib1sv: TglVertexAttrib1sv;
  glVertexAttrib2d: TglVertexAttrib2d;
  glVertexAttrib2dv: TglVertexAttrib2dv;
  glVertexAttrib2f: TglVertexAttrib2f;
  glVertexAttrib2fv: TglVertexAttrib2fv;
  glVertexAttrib2s: TglVertexAttrib2s;
  glVertexAttrib2sv: TglVertexAttrib2sv;
  glVertexAttrib3d: TglVertexAttrib3d;
  glVertexAttrib3dv: TglVertexAttrib3dv;
  glVertexAttrib3f: TglVertexAttrib3f;
  glVertexAttrib3fv: TglVertexAttrib3fv;
  glVertexAttrib3s: TglVertexAttrib3s;
  glVertexAttrib3sv: TglVertexAttrib3sv;
  glVertexAttrib4Nbv: TglVertexAttrib4Nbv;
  glVertexAttrib4Niv: TglVertexAttrib4Niv;
  glVertexAttrib4Nsv: TglVertexAttrib4Nsv;
  glVertexAttrib4Nub: TglVertexAttrib4Nub;
  glVertexAttrib4Nubv: TglVertexAttrib4Nubv;
  glVertexAttrib4Nuiv: TglVertexAttrib4Nuiv;
  glVertexAttrib4Nusv: TglVertexAttrib4Nusv;
  glVertexAttrib4bv: TglVertexAttrib4bv;
  glVertexAttrib4d: TglVertexAttrib4d;
  glVertexAttrib4dv: TglVertexAttrib4dv;
  glVertexAttrib4f: TglVertexAttrib4f;
  glVertexAttrib4fv: TglVertexAttrib4fv;
  glVertexAttrib4iv: TglVertexAttrib4iv;
  glVertexAttrib4s: TglVertexAttrib4s;
  glVertexAttrib4sv: TglVertexAttrib4sv;
  glVertexAttrib4ubv: TglVertexAttrib4ubv;
  glVertexAttrib4uiv: TglVertexAttrib4uiv;
  glVertexAttrib4usv: TglVertexAttrib4usv;
  glVertexAttribPointer: TglVertexAttribPointer;

  // GL_3DFX_tbuffer
  glTbufferMask3DFX: TglTbufferMask3DFX;

  // GL_APPLE_element_array
  glElementPointerAPPLE: TglElementPointerAPPLE;
  glDrawElementArrayAPPLE: TglDrawElementArrayAPPLE;
  glDrawRangeElementArrayAPPLE: TglDrawRangeElementArrayAPPLE;
  glMultiDrawElementArrayAPPLE: TglMultiDrawElementArrayAPPLE;
  glMultiDrawRangeElementArrayAPPLE: TglMultiDrawRangeElementArrayAPPLE;

  // GL_APPLE_fence
  glGenFencesAPPLE: TglGenFencesAPPLE;
  glDeleteFencesAPPLE: TglDeleteFencesAPPLE;
  glSetFenceAPPLE: TglSetFenceAPPLE;
  glIsFenceAPPLE: TglIsFenceAPPLE;
  glTestFenceAPPLE: TglTestFenceAPPLE;
  glFinishFenceAPPLE: TglFinishFenceAPPLE;
  glTestObjectAPPLE: TglTestObjectAPPLE;
  glFinishObjectAPPLE: TglFinishObjectAPPLE;

  // GL_APPLE_vertex_array_object
  glBindVertexArrayAPPLE: TglBindVertexArrayAPPLE;
  glDeleteVertexArraysAPPLE: TglDeleteVertexArraysAPPLE;
  glGenVertexArraysAPPLE: TglGenVertexArraysAPPLE;
  glIsVertexArrayAPPLE: TglIsVertexArrayAPPLE;

  // GL_APPLE_vertex_array_range
  glVertexArrayRangeAPPLE: TglVertexArrayRangeAPPLE;
  glFlushVertexArrayRangeAPPLE: TglFlushVertexArrayRangeAPPLE;
  glVertexArrayParameteriAPPLE: TglVertexArrayParameteriAPPLE;

  // GL_ARB_matrix_palette
  glCurrentPaletteMatrixARB: TglCurrentPaletteMatrixARB;
  glMatrixIndexubvARB: TglMatrixIndexubvARB;
  glMatrixIndexusvARB: TglMatrixIndexusvARB;
  glMatrixIndexuivARB: TglMatrixIndexuivARB;
  glMatrixIndexPointerARB: TglMatrixIndexPointerARB;

  // GL_ARB_multisample
  glSampleCoverageARB: TglSampleCoverageARB;

  // GL_ARB_multitexture
  glActiveTextureARB: TglActiveTextureARB;
  glClientActiveTextureARB: TglClientActiveTextureARB;
  glMultiTexCoord1dARB: TglMultiTexCoord1dARB;
  glMultiTexCoord1dvARB: TglMultiTexCoord1dvARB;
  glMultiTexCoord1fARB: TglMultiTexCoord1fARB;
  glMultiTexCoord1fvARB: TglMultiTexCoord1fvARB;
  glMultiTexCoord1iARB: TglMultiTexCoord1iARB;
  glMultiTexCoord1ivARB: TglMultiTexCoord1ivARB;
  glMultiTexCoord1sARB: TglMultiTexCoord1sARB;
  glMultiTexCoord1svARB: TglMultiTexCoord1svARB;
  glMultiTexCoord2dARB: TglMultiTexCoord2dARB;
  glMultiTexCoord2dvARB: TglMultiTexCoord2dvARB;
  glMultiTexCoord2fARB: TglMultiTexCoord2fARB;
  glMultiTexCoord2fvARB: TglMultiTexCoord2fvARB;
  glMultiTexCoord2iARB: TglMultiTexCoord2iARB;
  glMultiTexCoord2ivARB: TglMultiTexCoord2ivARB;
  glMultiTexCoord2sARB: TglMultiTexCoord2sARB;
  glMultiTexCoord2svARB: TglMultiTexCoord2svARB;
  glMultiTexCoord3dARB: TglMultiTexCoord3dARB;
  glMultiTexCoord3dvARB: TglMultiTexCoord3dvARB;
  glMultiTexCoord3fARB: TglMultiTexCoord3fARB;
  glMultiTexCoord3fvARB: TglMultiTexCoord3fvARB;
  glMultiTexCoord3iARB: TglMultiTexCoord3iARB;
  glMultiTexCoord3ivARB: TglMultiTexCoord3ivARB;
  glMultiTexCoord3sARB: TglMultiTexCoord3sARB;
  glMultiTexCoord3svARB: TglMultiTexCoord3svARB;
  glMultiTexCoord4dARB: TglMultiTexCoord4dARB;
  glMultiTexCoord4dvARB: TglMultiTexCoord4dvARB;
  glMultiTexCoord4fARB: TglMultiTexCoord4fARB;
  glMultiTexCoord4fvARB: TglMultiTexCoord4fvARB;
  glMultiTexCoord4iARB: TglMultiTexCoord4iARB;
  glMultiTexCoord4ivARB: TglMultiTexCoord4ivARB;
  glMultiTexCoord4sARB: TglMultiTexCoord4sARB;
  glMultiTexCoord4svARB: TglMultiTexCoord4svARB;

  // GL_ARB_point_parameters
  glPointParameterfARB: TglPointParameterfARB;
  glPointParameterfvARB: TglPointParameterfvARB;

  // GL_ARB_texture_compression
  glCompressedTexImage3DARB: TglCompressedTexImage3DARB;
  glCompressedTexImage2DARB: TglCompressedTexImage2DARB;
  glCompressedTexImage1DARB: TglCompressedTexImage1DARB;
  glCompressedTexSubImage3DARB: TglCompressedTexSubImage3DARB;
  glCompressedTexSubImage2DARB: TglCompressedTexSubImage2DARB;
  glCompressedTexSubImage1DARB: TglCompressedTexSubImage1DARB;
  glGetCompressedTexImageARB: TglGetCompressedTexImageARB;

  // GL_ARB_transpose_matrix
  glLoadTransposeMatrixfARB: TglLoadTransposeMatrixfARB;
  glLoadTransposeMatrixdARB: TglLoadTransposeMatrixdARB;
  glMultTransposeMatrixfARB: TglMultTransposeMatrixfARB;
  glMultTransposeMatrixdARB: TglMultTransposeMatrixdARB;

  // GL_ARB_vertex_blend
  glWeightbvARB: TglWeightbvARB;
  glWeightsvARB: TglWeightsvARB;
  glWeightivARB: TglWeightivARB;
  glWeightfvARB: TglWeightfvARB;
  glWeightdvARB: TglWeightdvARB;
  glWeightubvARB: TglWeightubvARB;
  glWeightusvARB: TglWeightusvARB;
  glWeightuivARB: TglWeightuivARB;
  glWeightPointerARB: TglWeightPointerARB;
  glVertexBlendARB: TglVertexBlendARB;

  // GL_ARB_vertex_buffer_object
  glBindBufferARB: TglBindBufferARB;
  glDeleteBuffersARB: TglDeleteBuffersARB;
  glGenBuffersARB: TglGenBuffersARB;
  glIsBufferARB: TglIsBufferARB;
  glGetBufferSubDataARB: TglGetBufferSubDataARB;
  glMapBufferARB: TglMapBufferARB;
  glUnmapBufferARB: TglUnmapBufferARB;
  glGetBufferParameterivARB: TglGetBufferParameterivARB;
  glGetBufferPointervARB: TglGetBufferPointervARB;

  // GL_ARB_vertex_program
  glVertexAttrib1dARB: TglVertexAttrib1dARB;
  glVertexAttrib1dvARB: TglVertexAttrib1dvARB;
  glVertexAttrib1fARB: TglVertexAttrib1fARB;
  glVertexAttrib1fvARB: TglVertexAttrib1fvARB;
  glVertexAttrib1sARB: TglVertexAttrib1sARB;
  glVertexAttrib1svARB: TglVertexAttrib1svARB;
  glVertexAttrib2dARB: TglVertexAttrib2dARB;
  glVertexAttrib2dvARB: TglVertexAttrib2dvARB;
  glVertexAttrib2fARB: TglVertexAttrib2fARB;
  glVertexAttrib2fvARB: TglVertexAttrib2fvARB;
  glVertexAttrib2sARB: TglVertexAttrib2sARB;
  glVertexAttrib2svARB: TglVertexAttrib2svARB;
  glVertexAttrib3dARB: TglVertexAttrib3dARB;
  glVertexAttrib3dvARB: TglVertexAttrib3dvARB;
  glVertexAttrib3fARB: TglVertexAttrib3fARB;
  glVertexAttrib3fvARB: TglVertexAttrib3fvARB;
  glVertexAttrib3sARB: TglVertexAttrib3sARB;
  glVertexAttrib3svARB: TglVertexAttrib3svARB;
  glVertexAttrib4NbvARB: TglVertexAttrib4NbvARB;
  glVertexAttrib4NivARB: TglVertexAttrib4NivARB;
  glVertexAttrib4NsvARB: TglVertexAttrib4NsvARB;
  glVertexAttrib4NubARB: TglVertexAttrib4NubARB;
  glVertexAttrib4NubvARB: TglVertexAttrib4NubvARB;
  glVertexAttrib4NuivARB: TglVertexAttrib4NuivARB;
  glVertexAttrib4NusvARB: TglVertexAttrib4NusvARB;
  glVertexAttrib4bvARB: TglVertexAttrib4bvARB;
  glVertexAttrib4dARB: TglVertexAttrib4dARB;
  glVertexAttrib4dvARB: TglVertexAttrib4dvARB;
  glVertexAttrib4fARB: TglVertexAttrib4fARB;
  glVertexAttrib4fvARB: TglVertexAttrib4fvARB;
  glVertexAttrib4ivARB: TglVertexAttrib4ivARB;
  glVertexAttrib4sARB: TglVertexAttrib4sARB;
  glVertexAttrib4svARB: TglVertexAttrib4svARB;
  glVertexAttrib4ubvARB: TglVertexAttrib4ubvARB;
  glVertexAttrib4uivARB: TglVertexAttrib4uivARB;
  glVertexAttrib4usvARB: TglVertexAttrib4usvARB;
  glEnableVertexAttribArrayARB: TglEnableVertexAttribArrayARB;
  glDisableVertexAttribArrayARB: TglDisableVertexAttribArrayARB;
  glProgramStringARB: TglProgramStringARB;
  glBindProgramARB: TglBindProgramARB;
  glDeleteProgramsARB: TglDeleteProgramsARB;
  glGenProgramsARB: TglGenProgramsARB;

  glProgramEnvParameter4dARB: TglProgramEnvParameter4dARB;
  glProgramEnvParameter4dvARB: TglProgramEnvParameter4dvARB;
  glProgramEnvParameter4fARB: TglProgramEnvParameter4fARB;
  glProgramEnvParameter4fvARB: TglProgramEnvParameter4fvARB;
  glProgramLocalParameter4dARB: TglProgramLocalParameter4dARB;
  glProgramLocalParameter4dvARB: TglProgramLocalParameter4dvARB;
  glProgramLocalParameter4fARB: TglProgramLocalParameter4fARB;
  glProgramLocalParameter4fvARB: TglProgramLocalParameter4fvARB;
  glGetProgramEnvParameterdvARB: TglGetProgramEnvParameterdvARB;
  glGetProgramEnvParameterfvARB: TglGetProgramEnvParameterfvARB;
  glGetProgramLocalParameterdvARB: TglGetProgramLocalParameterdvARB;
  glGetProgramLocalParameterfvARB: TglGetProgramLocalParameterfvARB;
  glGetProgramivARB: TglGetProgramivARB;
  glGetProgramStringARB: TglGetProgramStringARB;
  glGetVertexAttribdvARB: TglGetVertexAttribdvARB;
  glGetVertexAttribfvARB: TglGetVertexAttribfvARB;
  glGetVertexAttribivARB: TglGetVertexAttribivARB;
  glGetVertexAttribPointervARB: TglGetVertexAttribPointervARB;
  glIsProgramARB: TglIsProgramARB;

  // GL_ARB_window_pos
  glWindowPos2dARB: TglWindowPos2dARB;
  glWindowPos2dvARB: TglWindowPos2dvARB;
  glWindowPos2fARB: TglWindowPos2fARB;
  glWindowPos2fvARB: TglWindowPos2fvARB;
  glWindowPos2iARB: TglWindowPos2iARB;
  glWindowPos2ivARB: TglWindowPos2ivARB;
  glWindowPos2sARB: TglWindowPos2sARB;
  glWindowPos2svARB: TglWindowPos2svARB;
  glWindowPos3dARB: TglWindowPos3dARB;
  glWindowPos3dvARB: TglWindowPos3dvARB;
  glWindowPos3fARB: TglWindowPos3fARB;
  glWindowPos3fvARB: TglWindowPos3fvARB;
  glWindowPos3iARB: TglWindowPos3iARB;
  glWindowPos3ivARB: TglWindowPos3ivARB;
  glWindowPos3sARB: TglWindowPos3sARB;
  glWindowPos3svARB: TglWindowPos3svARB;

  // GL_ARB_draw_buffers
  glDrawBuffersARB: TglDrawBuffersARB;

  // GL_ARB_color_buffer_float
  glClampColorARB: TglClampColorARB;

  // GL_ARB_vertex_shader
  glGetActiveAttribARB: TglGetActiveAttribARB;
  glGetAttribLocationARB: TglGetAttribLocationARB;
  glBindAttribLocationARB: TglBindAttribLocationARB;
  //glGetVertexAttribPointervARB:T//glGetVertexAttribPointervARB;

  // GL_ARB_shader_objects
  glDeleteObjectARB: TglDeleteObjectARB;
  glGetHandleARB: TglGetHandleARB;
  glDetachObjectARB: TglDetachObjectARB;
  glCompileShaderARB: TglCompileShaderARB;
  glCreateProgramObjectARB: TglCreateProgramObjectARB;
  glAttachObjectARB: TglAttachObjectARB;
  glLinkProgramARB: TglLinkProgramARB;
  glUseProgramObjectARB: TglUseProgramObjectARB;
  glValidateProgramARB: TglValidateProgramARB;
  glUniform1fARB: TglUniform1fARB;
  glUniform2fARB: TglUniform2fARB;
  glUniform3fARB: TglUniform3fARB;
  glUniform4fARB: TglUniform4fARB;
  glUniform1iARB: TglUniform1iARB;
  glUniform2iARB: TglUniform2iARB;
  glUniform3iARB: TglUniform3iARB;
  glUniform4iARB: TglUniform4iARB;
  glUniform1fvARB: TglUniform1fvARB;
  glUniform2fvARB: TglUniform2fvARB;
  glUniform3fvARB: TglUniform3fvARB;
  glUniform4fvARB: TglUniform4fvARB;
  glUniform1ivARB: TglUniform1ivARB;
  glUniform2ivARB: TglUniform2ivARB;
  glUniform3ivARB: TglUniform3ivARB;
  glUniform4ivARB: TglUniform4ivARB;
  glUniformMatrix2fvARB: TglUniformMatrix2fvARB;
  glUniformMatrix3fvARB: TglUniformMatrix3fvARB;
  glUniformMatrix4fvARB: TglUniformMatrix4fvARB;
  glGetObjectParameterfvARB: TglGetObjectParameterfvARB;
  glGetObjectParameterivARB: TglGetObjectParameterivARB;
  glGetAttachedObjectsARB: TglGetAttachedObjectsARB;
  glGetUniformLocationARB: TglGetUniformLocationARB;
  glGetActiveUniformARB: TglGetActiveUniformARB;
  glGetUniformfvARB: TglGetUniformfvARB;
  glGetUniformivARB: TglGetUniformivARB;
  glGetShaderSourceARB: TglGetShaderSourceARB;

  // GL_ARB_Occlusion_Query
  glGenQueriesARB: TglGenQueriesARB;
  glDeleteQueriesARB: TglDeleteQueriesARB;
  glIsQueryARB: TglIsQueryARB;
  glBeginQueryARB: TglBeginQueryARB;
  glEndQueryARB: TglEndQueryARB;
  glGetQueryivARB: TglGetQueryivARB;
  glGetQueryObjectivARB: TglGetQueryObjectivARB;
  glGetQueryObjectuivARB: TglGetQueryObjectuivARB;

  // GL_ATI_draw_buffers
  glDrawBuffersATI: TglDrawBuffersATI;

  // GL_ATI_element_array
  glElementPointerATI: TglElementPointerATI;
  glDrawElementArrayATI: TglDrawElementArrayATI;
  glDrawRangeElementArrayATI: TglDrawRangeElementArrayATI;

  // GL_ATI_envmap_bumpmap
  glTexBumpParameterivATI: TglTexBumpParameterivATI;
  glTexBumpParameterfvATI: TglTexBumpParameterfvATI;
  glGetTexBumpParameterivATI: TglGetTexBumpParameterivATI;
  glGetTexBumpParameterfvATI: TglGetTexBumpParameterfvATI;

  // GL_ATI_fragment_shader
  glGenFragmentShadersATI: TglGenFragmentShadersATI;
  glBindFragmentShaderATI: TglBindFragmentShaderATI;
  glDeleteFragmentShaderATI: TglDeleteFragmentShaderATI;
  glBeginFragmentShaderATI: TglBeginFragmentShaderATI;
  glEndFragmentShaderATI: TglEndFragmentShaderATI;
  glPassTexCoordATI: TglPassTexCoordATI;
  glSampleMapATI: TglSampleMapATI;
  glColorFragmentOp1ATI: TglColorFragmentOp1ATI;
  glColorFragmentOp2ATI: TglColorFragmentOp2ATI;
  glColorFragmentOp3ATI: TglColorFragmentOp3ATI;
  glAlphaFragmentOp1ATI: TglAlphaFragmentOp1ATI;
  glAlphaFragmentOp2ATI: TglAlphaFragmentOp2ATI;
  glAlphaFragmentOp3ATI: TglAlphaFragmentOp3ATI;
  glSetFragmentShaderConstantATI: TglSetFragmentShaderConstantATI;

  // GL_ATI_map_object_buffer
  glMapObjectBufferATI: TglMapObjectBufferATI;
  glUnmapObjectBufferATI: TglUnmapObjectBufferATI;

  // GL_ATI_pn_triangles
  glPNTrianglesiATI: TglPNTrianglesiATI;
  glPNTrianglesfATI: TglPNTrianglesfATI;

  // GL_ATI_separate_stencil
  glStencilOpSeparateATI: TglStencilOpSeparateATI;
  glStencilFuncSeparateATI: TglStencilFuncSeparateATI;

  // GL_ATI_vertex_array_object
  glNewObjectBufferATI: TglNewObjectBufferATI;
  glIsObjectBufferATI: TglIsObjectBufferATI;
  glUpdateObjectBufferATI: TglUpdateObjectBufferATI;
  glGetObjectBufferfvATI: TglGetObjectBufferfvATI;
  glGetObjectBufferivATI: TglGetObjectBufferivATI;
  glFreeObjectBufferATI: TglFreeObjectBufferATI;
  glArrayObjectATI: TglArrayObjectATI;
  glGetArrayObjectfvATI: TglGetArrayObjectfvATI;
  glGetArrayObjectivATI: TglGetArrayObjectivATI;
  glVariantArrayObjectATI: TglVariantArrayObjectATI;
  glGetVariantArrayObjectfvATI: TglGetVariantArrayObjectfvATI;
  glGetVariantArrayObjectivATI: TglGetVariantArrayObjectivATI;
  glVertexAttribArrayObjectATI: TglVertexAttribArrayObjectATI;
  glGetVertexAttribArrayObjectfvATI: TglGetVertexAttribArrayObjectfvATI;
  glGetVertexAttribArrayObjectivATI: TglGetVertexAttribArrayObjectivATI;

  // GL_ATI_vertex_streams
  glVertexStream1sATI: TglVertexStream1sATI;
  glVertexStream1svATI: TglVertexStream1svATI;
  glVertexStream1iATI: TglVertexStream1iATI;
  glVertexStream1ivATI: TglVertexStream1ivATI;
  glVertexStream1fATI: TglVertexStream1fATI;
  glVertexStream1fvATI: TglVertexStream1fvATI;
  glVertexStream1dATI: TglVertexStream1dATI;
  glVertexStream1dvATI: TglVertexStream1dvATI;
  glVertexStream2sATI: TglVertexStream2sATI;
  glVertexStream2svATI: TglVertexStream2svATI;
  glVertexStream2iATI: TglVertexStream2iATI;
  glVertexStream2ivATI: TglVertexStream2ivATI;
  glVertexStream2fATI: TglVertexStream2fATI;
  glVertexStream2fvATI: TglVertexStream2fvATI;
  glVertexStream2dATI: TglVertexStream2dATI;
  glVertexStream2dvATI: TglVertexStream2dvATI;
  glVertexStream3sATI: TglVertexStream3sATI;
  glVertexStream3svATI: TglVertexStream3svATI;
  glVertexStream3iATI: TglVertexStream3iATI;
  glVertexStream3ivATI: TglVertexStream3ivATI;
  glVertexStream3fATI: TglVertexStream3fATI;
  glVertexStream3fvATI: TglVertexStream3fvATI;
  glVertexStream3dATI: TglVertexStream3dATI;
  glVertexStream3dvATI: TglVertexStream3dvATI;
  glVertexStream4sATI: TglVertexStream4sATI;
  glVertexStream4svATI: TglVertexStream4svATI;
  glVertexStream4iATI: TglVertexStream4iATI;
  glVertexStream4ivATI: TglVertexStream4ivATI;
  glVertexStream4fATI: TglVertexStream4fATI;
  glVertexStream4fvATI: TglVertexStream4fvATI;
  glVertexStream4dATI: TglVertexStream4dATI;
  glVertexStream4dvATI: TglVertexStream4dvATI;
  glNormalStream3bATI: TglNormalStream3bATI;
  glNormalStream3bvATI: TglNormalStream3bvATI;
  glNormalStream3sATI: TglNormalStream3sATI;
  glNormalStream3svATI: TglNormalStream3svATI;
  glNormalStream3iATI: TglNormalStream3iATI;
  glNormalStream3ivATI: TglNormalStream3ivATI;
  glNormalStream3fATI: TglNormalStream3fATI;
  glNormalStream3fvATI: TglNormalStream3fvATI;
  glNormalStream3dATI: TglNormalStream3dATI;
  glNormalStream3dvATI: TglNormalStream3dvATI;
  glClientActiveVertexStreamATI: TglClientActiveVertexStreamATI;
  glVertexBlendEnviATI: TglVertexBlendEnviATI;
  glVertexBlendEnvfATI: TglVertexBlendEnvfATI;

  // GL_EXT_blend_color
  glBlendColorEXT: TglBlendColorEXT;

  // GL_EXT_blend_func_separate
  glBlendFuncSeparateEXT: TglBlendFuncSeparateEXT;

  // GL_EXT_blend_minmax
  glBlendEquationEXT: TglBlendEquationEXT;

  // GL_EXT_color_subtable
  glColorSubTableEXT: TglColorSubTableEXT;
  glCopyColorSubTableEXT: TglCopyColorSubTableEXT;

  // GL_EXT_compiled_vertex_array
  glLockArraysEXT: TglLockArraysEXT;
  glUnlockArraysEXT: TglUnlockArraysEXT;

  // GL_EXT_convolution
  glConvolutionFilter1DEXT: TglConvolutionFilter1DEXT;
  glConvolutionFilter2DEXT: TglConvolutionFilter2DEXT;
  glConvolutionParameterfEXT: TglConvolutionParameterfEXT;
  glConvolutionParameterfvEXT: TglConvolutionParameterfvEXT;
  glConvolutionParameteriEXT: TglConvolutionParameteriEXT;
  glConvolutionParameterivEXT: TglConvolutionParameterivEXT;
  glCopyConvolutionFilter1DEXT: TglCopyConvolutionFilter1DEXT;
  glCopyConvolutionFilter2DEXT: TglCopyConvolutionFilter2DEXT;
  glGetConvolutionFilterEXT: TglGetConvolutionFilterEXT;
  glGetConvolutionParameterfvEXT: TglGetConvolutionParameterfvEXT;
  glGetConvolutionParameterivEXT: TglGetConvolutionParameterivEXT;
  glGetSeparableFilterEXT: TglGetSeparableFilterEXT;
  glSeparableFilter2DEXT: TglSeparableFilter2DEXT;

  // GL_EXT_coordinate_frame
  glTangent3bEXT: TglTangent3bEXT;
  glTangent3bvEXT: TglTangent3bvEXT;
  glTangent3dEXT: TglTangent3dEXT;
  glTangent3dvEXT: TglTangent3dvEXT;
  glTangent3fEXT: TglTangent3fEXT;
  glTangent3fvEXT: TglTangent3fvEXT;
  glTangent3iEXT: TglTangent3iEXT;
  glTangent3ivEXT: TglTangent3ivEXT;
  glTangent3sEXT: TglTangent3sEXT;
  glTangent3svEXT: TglTangent3svEXT;
  glBinormal3bEXT: TglBinormal3bEXT;
  glBinormal3bvEXT: TglBinormal3bvEXT;
  glBinormal3dEXT: TglBinormal3dEXT;
  glBinormal3dvEXT: TglBinormal3dvEXT;
  glBinormal3fEXT: TglBinormal3fEXT;
  glBinormal3fvEXT: TglBinormal3fvEXT;
  glBinormal3iEXT: TglBinormal3iEXT;
  glBinormal3ivEXT: TglBinormal3ivEXT;
  glBinormal3sEXT: TglBinormal3sEXT;
  glBinormal3svEXT: TglBinormal3svEXT;
  glTangentPointerEXT: TglTangentPointerEXT;
  glBinormalPointerEXT: TglBinormalPointerEXT;

  // GL_EXT_copy_texture
  glCopyTexImage1DEXT: TglCopyTexImage1DEXT;
  glCopyTexImage2DEXT: TglCopyTexImage2DEXT;
  glCopyTexSubImage1DEXT: TglCopyTexSubImage1DEXT;
  glCopyTexSubImage2DEXT: TglCopyTexSubImage2DEXT;
  glCopyTexSubImage3DEXT: TglCopyTexSubImage3DEXT;

  // GL_EXT_cull_vertex
  glCullParameterdvEXT: TglCullParameterdvEXT;
  glCullParameterfvEXT: TglCullParameterfvEXT;

  // GL_EXT_draw_range_elements
  glDrawRangeElementsEXT: TglDrawRangeElementsEXT;

  // GL_EXT_fog_coord
  glFogCoordfEXT: TglFogCoordfEXT;
  glFogCoordfvEXT: TglFogCoordfvEXT;
  glFogCoorddEXT: TglFogCoorddEXT;
  glFogCoorddvEXT: TglFogCoorddvEXT;
  glFogCoordPointerEXT: TglFogCoordPointerEXT;

  // GL_EXT_framebuffer_object
  glIsRenderbufferEXT: TglIsRenderbufferEXT;
  glBindRenderbufferEXT: TglBindRenderbufferEXT;
  glDeleteRenderbuffersEXT: TglDeleteRenderbuffersEXT;
  glGenRenderbuffersEXT: TglGenRenderbuffersEXT;
  glRenderbufferStorageEXT: TglRenderbufferStorageEXT;
  glGetRenderbufferParameterivEXT: TglGetRenderbufferParameterivEXT;
  glIsFramebufferEXT: TglIsFramebufferEXT;
  glBindFramebufferEXT: TglBindFramebufferEXT;
  glDeleteFramebuffersEXT: TglDeleteFramebuffersEXT;
  glGenFramebuffersEXT: TglGenFramebuffersEXT;
  glCheckFramebufferStatusEXT: TglCheckFramebufferStatusEXT;
  glFramebufferTexture1DEXT: TglFramebufferTexture1DEXT;
  glFramebufferTexture2DEXT: TglFramebufferTexture2DEXT;
  glFramebufferTexture3DEXT: TglFramebufferTexture3DEXT;
  glFramebufferRenderbufferEXT: TglFramebufferRenderbufferEXT;
  glGetFramebufferAttachmentParameterivEXT: TglGetFramebufferAttachmentParameterivEXT;
  glGenerateMipmapEXT: TglGenerateMipmapEXT;

  // GL_EXT_histogram
  glGetHistogramEXT: TglGetHistogramEXT;
  glGetHistogramParameterfvEXT: TglGetHistogramParameterfvEXT;
  glGetHistogramParameterivEXT: TglGetHistogramParameterivEXT;
  glGetMinmaxEXT: TglGetMinmaxEXT;
  glGetMinmaxParameterfvEXT: TglGetMinmaxParameterfvEXT;
  glGetMinmaxParameterivEXT: TglGetMinmaxParameterivEXT;
  glHistogramEXT: TglHistogramEXT;
  glMinmaxEXT: TglMinmaxEXT;
  glResetHistogramEXT: TglResetHistogramEXT;
  glResetMinmaxEXT: TglResetMinmaxEXT;

  // GL_EXT_index_func
  glIndexFuncEXT: TglIndexFuncEXT;

  // GL_EXT_index_material
  glIndexMaterialEXT: TglIndexMaterialEXT;

  // GL_EXT_light_texture
  glApplyTextureEXT: TglApplyTextureEXT;
  glTextureLightEXT: TglTextureLightEXT;
  glTextureMaterialEXT: TglTextureMaterialEXT;

  // GL_EXT_multi_draw_arrays
  glMultiDrawArraysEXT: TglMultiDrawArraysEXT;
  glMultiDrawElementsEXT: TglMultiDrawElementsEXT;

  // GL_EXT_multisample
  glSampleMaskEXT: TglSampleMaskEXT;
  glSamplePatternEXT: TglSamplePatternEXT;

  // GL_EXT_paletted_texture
  glColorTableEXT: TglColorTableEXT;
  glGetColorTableEXT: TglGetColorTableEXT;
  glGetColorTableParameterivEXT: TglGetColorTableParameterivEXT;
  glGetColorTableParameterfvEXT: TglGetColorTableParameterfvEXT;

  // GL_EXT_pixel_transform
  glPixelTransformParameteriEXT: TglPixelTransformParameteriEXT;
  glPixelTransformParameterfEXT: TglPixelTransformParameterfEXT;
  glPixelTransformParameterivEXT: TglPixelTransformParameterivEXT;
  glPixelTransformParameterfvEXT: TglPixelTransformParameterfvEXT;

  // GL_EXT_point_parameters
  glPointParameterfEXT: TglPointParameterfEXT;
  glPointParameterfvEXT: TglPointParameterfvEXT;

  // GL_EXT_polygon_offset
  glPolygonOffsetEXT: TglPolygonOffsetEXT;

  // GL_EXT_secondary_color
  glSecondaryColor3bEXT: TglSecondaryColor3bEXT;
  glSecondaryColor3bvEXT: TglSecondaryColor3bvEXT;
  glSecondaryColor3dEXT: TglSecondaryColor3dEXT;
  glSecondaryColor3dvEXT: TglSecondaryColor3dvEXT;
  glSecondaryColor3fEXT: TglSecondaryColor3fEXT;
  glSecondaryColor3fvEXT: TglSecondaryColor3fvEXT;
  glSecondaryColor3iEXT: TglSecondaryColor3iEXT;
  glSecondaryColor3ivEXT: TglSecondaryColor3ivEXT;
  glSecondaryColor3sEXT: TglSecondaryColor3sEXT;
  glSecondaryColor3svEXT: TglSecondaryColor3svEXT;
  glSecondaryColor3ubEXT: TglSecondaryColor3ubEXT;
  glSecondaryColor3ubvEXT: TglSecondaryColor3ubvEXT;
  glSecondaryColor3uiEXT: TglSecondaryColor3uiEXT;
  glSecondaryColor3uivEXT: TglSecondaryColor3uivEXT;
  glSecondaryColor3usEXT: TglSecondaryColor3usEXT;
  glSecondaryColor3usvEXT: TglSecondaryColor3usvEXT;
  glSecondaryColorPointerEXT: TglSecondaryColorPointerEXT;

  // GL_EXT_stencil_two_side
  glActiveStencilFaceEXT: TglActiveStencilFaceEXT;

  // GL_EXT_subtexture
  glTexSubImage1DEXT: TglTexSubImage1DEXT;
  glTexSubImage2DEXT: TglTexSubImage2DEXT;

  // GL_EXT_texture3D
  glTexImage3DEXT: TglTexImage3DEXT;
  glTexSubImage3DEXT: TglTexSubImage3DEXT;

  // GL_EXT_texture_object
  glAreTexturesResidentEXT: TglAreTexturesResidentEXT;
  glBindTextureEXT: TglBindTextureEXT;
  glDeleteTexturesEXT: TglDeleteTexturesEXT;
  glGenTexturesEXT: TglGenTexturesEXT;
  glIsTextureEXT: TglIsTextureEXT;
  glPrioritizeTexturesEXT: TglPrioritizeTexturesEXT;

  // GL_EXT_texture_perturb_normal
  glTextureNormalEXT: TglTextureNormalEXT;

  // GL_EXT_vertex_array
  glArrayElementEXT: TglArrayElementEXT;
  glColorPointerEXT: TglColorPointerEXT;
  glDrawArraysEXT: TglDrawArraysEXT;
  glEdgeFlagPointerEXT: TglEdgeFlagPointerEXT;
  glGetPointervEXT: TglGetPointervEXT;
  glIndexPointerEXT: TglIndexPointerEXT;
  glNormalPointerEXT: TglNormalPointerEXT;
  glTexCoordPointerEXT: TglTexCoordPointerEXT;
  glVertexPointerEXT: TglVertexPointerEXT;

  // GL_EXT_vertex_shader
  glBeginVertexShaderEXT: TglBeginVertexShaderEXT;
  glEndVertexShaderEXT: TglEndVertexShaderEXT;
  glBindVertexShaderEXT: TglBindVertexShaderEXT;
  glGenVertexShadersEXT: TglGenVertexShadersEXT;
  glDeleteVertexShaderEXT: TglDeleteVertexShaderEXT;
  glShaderOp1EXT: TglShaderOp1EXT;
  glShaderOp2EXT: TglShaderOp2EXT;
  glShaderOp3EXT: TglShaderOp3EXT;
  glSwizzleEXT: TglSwizzleEXT;
  glWriteMaskEXT: TglWriteMaskEXT;
  glInsertComponentEXT: TglInsertComponentEXT;
  glExtractComponentEXT: TglExtractComponentEXT;
  glGenSymbolsEXT: TglGenSymbolsEXT;
  glSetInvariantEXT: TglSetInvariantEXT;
  glSetLocalConstantEXT: TglSetLocalConstantEXT;
  glVariantbvEXT: TglVariantbvEXT;
  glVariantsvEXT: TglVariantsvEXT;
  glVariantivEXT: TglVariantivEXT;
  glVariantfvEXT: TglVariantfvEXT;
  glVariantdvEXT: TglVariantdvEXT;
  glVariantubvEXT: TglVariantubvEXT;
  glVariantusvEXT: TglVariantusvEXT;
  glVariantuivEXT: TglVariantuivEXT;
  glVariantPointerEXT: TglVariantPointerEXT;
  glEnableVariantClientStateEXT: TglEnableVariantClientStateEXT;
  glDisableVariantClientStateEXT: TglDisableVariantClientStateEXT;
  glBindLightParameterEXT: TglBindLightParameterEXT;
  glBindMaterialParameterEXT: TglBindMaterialParameterEXT;
  glBindTexGenParameterEXT: TglBindTexGenParameterEXT;
  glBindTextureUnitParameterEXT: TglBindTextureUnitParameterEXT;
  glBindParameterEXT: TglBindParameterEXT;
  glIsVariantEnabledEXT: TglIsVariantEnabledEXT;
  glGetVariantBooleanvEXT: TglGetVariantBooleanvEXT;
  glGetVariantIntegervEXT: TglGetVariantIntegervEXT;
  glGetVariantFloatvEXT: TglGetVariantFloatvEXT;
  glGetVariantPointervEXT: TglGetVariantPointervEXT;
  glGetInvariantBooleanvEXT: TglGetInvariantBooleanvEXT;
  glGetInvariantIntegervEXT: TglGetInvariantIntegervEXT;
  glGetInvariantFloatvEXT: TglGetInvariantFloatvEXT;
  glGetLocalConstantBooleanvEXT: TglGetLocalConstantBooleanvEXT;
  glGetLocalConstantIntegervEXT: TglGetLocalConstantIntegervEXT;
  glGetLocalConstantFloatvEXT: TglGetLocalConstantFloatvEXT;

  // GL_EXT_vertex_weighting
  glVertexWeightfEXT: TglVertexWeightfEXT;
  glVertexWeightfvEXT: TglVertexWeightfvEXT;
  glVertexWeightPointerEXT: TglVertexWeightPointerEXT;

  // GL_EXT_stencil_clear_tag
  glStencilClearTagEXT: TglStencilClearTagEXT;

  // GL_HP_image_transform
  glImageTransformParameteriHP: TglImageTransformParameteriHP;
  glImageTransformParameterfHP: TglImageTransformParameterfHP;
  glImageTransformParameterivHP: TglImageTransformParameterivHP;
  glImageTransformParameterfvHP: TglImageTransformParameterfvHP;
  glGetImageTransformParameterivHP: TglGetImageTransformParameterivHP;
  glGetImageTransformParameterfvHP: TglGetImageTransformParameterfvHP;

  // GL_EXT_depth_bounds_test
  glDepthBoundsEXT: TglDepthBoundsEXT;

  // GL_EXT_blend_equation_separate
  glBlendEquationSeparateEXT: TglBlendEquationSeparateEXT;

  // GL_IBM_multimode_draw_arrays
  glMultiModeDrawArraysIBM: TglMultiModeDrawArraysIBM;
  glMultiModeDrawElementsIBM: TglMultiModeDrawElementsIBM;

  // GL_IBM_vertex_array_lists
  glColorPointerListIBM: TglColorPointerListIBM;
  glSecondaryColorPointerListIBM: TglSecondaryColorPointerListIBM;
  glEdgeFlagPointerListIBM: TglEdgeFlagPointerListIBM;
  glFogCoordPointerListIBM: TglFogCoordPointerListIBM;
  glIndexPointerListIBM: TglIndexPointerListIBM;
  glNormalPointerListIBM: TglNormalPointerListIBM;
  glTexCoordPointerListIBM: TglTexCoordPointerListIBM;
  glVertexPointerListIBM: TglVertexPointerListIBM;

  // GL_INGR_blend_func_separate
  glBlendFuncSeparateINGR: TglBlendFuncSeparateINGR;

  // GL_INTEL_parallel_arrays
  glVertexPointervINTEL: TglVertexPointervINTEL;
  glNormalPointervINTEL: TglNormalPointervINTEL;
  glColorPointervINTEL: TglColorPointervINTEL;
  glTexCoordPointervINTEL: TglTexCoordPointervINTEL;

  // GL_MESA_resize_buffers
  glResizeBuffersMESA: TglResizeBuffersMESA;

  // GL_MESA_window_pos
  glWindowPos2dMESA: TglWindowPos2dMESA;
  glWindowPos2dvMESA: TglWindowPos2dvMESA;
  glWindowPos2fMESA: TglWindowPos2fMESA;
  glWindowPos2fvMESA: TglWindowPos2fvMESA;
  glWindowPos2iMESA: TglWindowPos2iMESA;
  glWindowPos2ivMESA: TglWindowPos2ivMESA;
  glWindowPos2sMESA: TglWindowPos2sMESA;
  glWindowPos2svMESA: TglWindowPos2svMESA;
  glWindowPos3dMESA: TglWindowPos3dMESA;
  glWindowPos3dvMESA: TglWindowPos3dvMESA;
  glWindowPos3fMESA: TglWindowPos3fMESA;
  glWindowPos3fvMESA: TglWindowPos3fvMESA;
  glWindowPos3iMESA: TglWindowPos3iMESA;
  glWindowPos3ivMESA: TglWindowPos3ivMESA;
  glWindowPos3sMESA: TglWindowPos3sMESA;
  glWindowPos3svMESA: TglWindowPos3svMESA;
  glWindowPos4dMESA: TglWindowPos4dMESA;
  glWindowPos4dvMESA: TglWindowPos4dvMESA;
  glWindowPos4fMESA: TglWindowPos4fMESA;
  glWindowPos4fvMESA: TglWindowPos4fvMESA;
  glWindowPos4iMESA: TglWindowPos4iMESA;
  glWindowPos4ivMESA: TglWindowPos4ivMESA;
  glWindowPos4sMESA: TglWindowPos4sMESA;
  glWindowPos4svMESA: TglWindowPos4svMESA;

  // GL_NV_evaluators
  glMapControlPointsNV: TglMapControlPointsNV;
  glMapParameterivNV: TglMapParameterivNV;
  glMapParameterfvNV: TglMapParameterfvNV;
  glGetMapControlPointsNV: TglGetMapControlPointsNV;
  glGetMapParameterivNV: TglGetMapParameterivNV;
  glGetMapParameterfvNV: TglGetMapParameterfvNV;
  glGetMapAttribParameterivNV: TglGetMapAttribParameterivNV;
  glGetMapAttribParameterfvNV: TglGetMapAttribParameterfvNV;
  glEvalMapsNV: TglEvalMapsNV;

  // GL_NV_fence
  glDeleteFencesNV: TglDeleteFencesNV;
  glGenFencesNV: TglGenFencesNV;
  glIsFenceNV: TglIsFenceNV;
  glTestFenceNV: TglTestFenceNV;
  glGetFenceivNV: TglGetFenceivNV;
  glFinishFenceNV: TglFinishFenceNV;
  glSetFenceNV: TglSetFenceNV;

  // GL_NV_fragment_program
  glProgramNamedParameter4fNV: TglProgramNamedParameter4fNV;
  glProgramNamedParameter4dNV: TglProgramNamedParameter4dNV;
  glProgramNamedParameter4fvNV: TglProgramNamedParameter4fvNV;
  glProgramNamedParameter4dvNV: TglProgramNamedParameter4dvNV;
  glGetProgramNamedParameterfvNV: TglGetProgramNamedParameterfvNV;
  glGetProgramNamedParameterdvNV: TglGetProgramNamedParameterdvNV;

  // GL_NV_half_float
  glVertex2hNV: TglVertex2hNV;
  glVertex2hvNV: TglVertex2hvNV;
  glVertex3hNV: TglVertex3hNV;
  glVertex3hvNV: TglVertex3hvNV;
  glVertex4hNV: TglVertex4hNV;
  glVertex4hvNV: TglVertex4hvNV;
  glNormal3hNV: TglNormal3hNV;
  glNormal3hvNV: TglNormal3hvNV;
  glColor3hNV: TglColor3hNV;
  glColor3hvNV: TglColor3hvNV;
  glColor4hNV: TglColor4hNV;
  glColor4hvNV: TglColor4hvNV;
  glTexCoord1hNV: TglTexCoord1hNV;
  glTexCoord1hvNV: TglTexCoord1hvNV;
  glTexCoord2hNV: TglTexCoord2hNV;
  glTexCoord2hvNV: TglTexCoord2hvNV;
  glTexCoord3hNV: TglTexCoord3hNV;
  glTexCoord3hvNV: TglTexCoord3hvNV;
  glTexCoord4hNV: TglTexCoord4hNV;
  glTexCoord4hvNV: TglTexCoord4hvNV;
  glMultiTexCoord1hNV: TglMultiTexCoord1hNV;
  glMultiTexCoord1hvNV: TglMultiTexCoord1hvNV;
  glMultiTexCoord2hNV: TglMultiTexCoord2hNV;
  glMultiTexCoord2hvNV: TglMultiTexCoord2hvNV;
  glMultiTexCoord3hNV: TglMultiTexCoord3hNV;
  glMultiTexCoord3hvNV: TglMultiTexCoord3hvNV;
  glMultiTexCoord4hNV: TglMultiTexCoord4hNV;
  glMultiTexCoord4hvNV: TglMultiTexCoord4hvNV;
  glFogCoordhNV: TglFogCoordhNV;
  glFogCoordhvNV: TglFogCoordhvNV;
  glSecondaryColor3hNV: TglSecondaryColor3hNV;
  glSecondaryColor3hvNV: TglSecondaryColor3hvNV;
  glVertexWeighthNV: TglVertexWeighthNV;
  glVertexWeighthvNV: TglVertexWeighthvNV;
  glVertexAttrib1hNV: TglVertexAttrib1hNV;
  glVertexAttrib1hvNV: TglVertexAttrib1hvNV;
  glVertexAttrib2hNV: TglVertexAttrib2hNV;
  glVertexAttrib2hvNV: TglVertexAttrib2hvNV;
  glVertexAttrib3hNV: TglVertexAttrib3hNV;
  glVertexAttrib3hvNV: TglVertexAttrib3hvNV;
  glVertexAttrib4hNV: TglVertexAttrib4hNV;
  glVertexAttrib4hvNV: TglVertexAttrib4hvNV;
  glVertexAttribs1hvNV: TglVertexAttribs1hvNV;
  glVertexAttribs2hvNV: TglVertexAttribs2hvNV;
  glVertexAttribs3hvNV: TglVertexAttribs3hvNV;
  glVertexAttribs4hvNV: TglVertexAttribs4hvNV;

  // GL_NV_occlusion_query
  glGenOcclusionQueriesNV: TglGenOcclusionQueriesNV;
  glDeleteOcclusionQueriesNV: TglDeleteOcclusionQueriesNV;
  glIsOcclusionQueryNV: TglIsOcclusionQueryNV;
  glBeginOcclusionQueryNV: TglBeginOcclusionQueryNV;
  glEndOcclusionQueryNV: TglEndOcclusionQueryNV;
  glGetOcclusionQueryivNV: TglGetOcclusionQueryivNV;
  glGetOcclusionQueryuivNV: TglGetOcclusionQueryuivNV;

  // GL_NV_pixel_data_range
  glPixelDataRangeNV: TglPixelDataRangeNV;
  glFlushPixelDataRangeNV: TglFlushPixelDataRangeNV;

  // GL_NV_point_sprite
  glPointParameteriNV: TglPointParameteriNV;
  glPointParameterivNV: TglPointParameterivNV;

  // GL_NV_primitive_restart
  glPrimitiveRestartNV: TglPrimitiveRestartNV;
  glPrimitiveRestartIndexNV: TglPrimitiveRestartIndexNV;

  // GL_NV_register_combiners
  glCombinerParameterfvNV: TglCombinerParameterfvNV;
  glCombinerParameterfNV: TglCombinerParameterfNV;
  glCombinerParameterivNV: TglCombinerParameterivNV;
  glCombinerParameteriNV: TglCombinerParameteriNV;
  glCombinerInputNV: TglCombinerInputNV;
  glCombinerOutputNV: TglCombinerOutputNV;
  glFinalCombinerInputNV: TglFinalCombinerInputNV;
  glGetCombinerInputParameterfvNV: TglGetCombinerInputParameterfvNV;
  glGetCombinerInputParameterivNV: TglGetCombinerInputParameterivNV;
  glGetCombinerOutputParameterfvNV: TglGetCombinerOutputParameterfvNV;
  glGetCombinerOutputParameterivNV: TglGetCombinerOutputParameterivNV;
  glGetFinalCombinerInputParameterfvNV: TglGetFinalCombinerInputParameterfvNV;
  glGetFinalCombinerInputParameterivNV: TglGetFinalCombinerInputParameterivNV;

  // GL_NV_register_combiners2
  glCombinerStageParameterfvNV: TglCombinerStageParameterfvNV;
  glGetCombinerStageParameterfvNV: TglGetCombinerStageParameterfvNV;

  // GL_NV_vertex_array_range
  glFlushVertexArrayRangeNV: TglFlushVertexArrayRangeNV;
  glVertexArrayRangeNV: TglVertexArrayRangeNV;

  // GL_NV_vertex_program
  glAreProgramsResidentNV: TglAreProgramsResidentNV;
  glBindProgramNV: TglBindProgramNV;
  glDeleteProgramsNV: TglDeleteProgramsNV;
  glExecuteProgramNV: TglExecuteProgramNV;
  glGenProgramsNV: TglGenProgramsNV;
  glGetProgramParameterdvNV: TglGetProgramParameterdvNV;
  glGetProgramParameterfvNV: TglGetProgramParameterfvNV;
  glGetProgramivNV: TglGetProgramivNV;
  glGetProgramStringNV: TglGetProgramStringNV;
  glGetTrackMatrixivNV: TglGetTrackMatrixivNV;
  glGetVertexAttribdvNV: TglGetVertexAttribdvNV;
  glGetVertexAttribfvNV: TglGetVertexAttribfvNV;
  glGetVertexAttribivNV: TglGetVertexAttribivNV;
  glGetVertexAttribPointervNV: TglGetVertexAttribPointervNV;
  glIsProgramNV: TglIsProgramNV;
  glLoadProgramNV: TglLoadProgramNV;
  glProgramParameter4dNV: TglProgramParameter4dNV;
  glProgramParameter4dvNV: TglProgramParameter4dvNV;
  glProgramParameter4fNV: TglProgramParameter4fNV;
  glProgramParameter4fvNV: TglProgramParameter4fvNV;
  glProgramParameters4dvNV: TglProgramParameters4dvNV;
  glProgramParameters4fvNV: TglProgramParameters4fvNV;
  glRequestResidentProgramsNV: TglRequestResidentProgramsNV;
  glTrackMatrixNV: TglTrackMatrixNV;
  glVertexAttribPointerNV: TglVertexAttribPointerNV;
  glVertexAttrib1dNV: TglVertexAttrib1dNV;
  glVertexAttrib1dvNV: TglVertexAttrib1dvNV;
  glVertexAttrib1fNV: TglVertexAttrib1fNV;
  glVertexAttrib1fvNV: TglVertexAttrib1fvNV;
  glVertexAttrib1sNV: TglVertexAttrib1sNV;
  glVertexAttrib1svNV: TglVertexAttrib1svNV;
  glVertexAttrib2dNV: TglVertexAttrib2dNV;
  glVertexAttrib2dvNV: TglVertexAttrib2dvNV;
  glVertexAttrib2fNV: TglVertexAttrib2fNV;
  glVertexAttrib2fvNV: TglVertexAttrib2fvNV;
  glVertexAttrib2sNV: TglVertexAttrib2sNV;
  glVertexAttrib2svNV: TglVertexAttrib2svNV;
  glVertexAttrib3dNV: TglVertexAttrib3dNV;
  glVertexAttrib3dvNV: TglVertexAttrib3dvNV;
  glVertexAttrib3fNV: TglVertexAttrib3fNV;
  glVertexAttrib3fvNV: TglVertexAttrib3fvNV;
  glVertexAttrib3sNV: TglVertexAttrib3sNV;
  glVertexAttrib3svNV: TglVertexAttrib3svNV;
  glVertexAttrib4dNV: TglVertexAttrib4dNV;
  glVertexAttrib4dvNV: TglVertexAttrib4dvNV;
  glVertexAttrib4fNV: TglVertexAttrib4fNV;
  glVertexAttrib4fvNV: TglVertexAttrib4fvNV;
  glVertexAttrib4sNV: TglVertexAttrib4sNV;
  glVertexAttrib4svNV: TglVertexAttrib4svNV;
  glVertexAttrib4ubNV: TglVertexAttrib4ubNV;
  glVertexAttrib4ubvNV: TglVertexAttrib4ubvNV;
  glVertexAttribs1dvNV: TglVertexAttribs1dvNV;
  glVertexAttribs1fvNV: TglVertexAttribs1fvNV;
  glVertexAttribs1svNV: TglVertexAttribs1svNV;
  glVertexAttribs2dvNV: TglVertexAttribs2dvNV;
  glVertexAttribs2fvNV: TglVertexAttribs2fvNV;
  glVertexAttribs2svNV: TglVertexAttribs2svNV;
  glVertexAttribs3dvNV: TglVertexAttribs3dvNV;
  glVertexAttribs3fvNV: TglVertexAttribs3fvNV;
  glVertexAttribs3svNV: TglVertexAttribs3svNV;
  glVertexAttribs4dvNV: TglVertexAttribs4dvNV;
  glVertexAttribs4fvNV: TglVertexAttribs4fvNV;
  glVertexAttribs4svNV: TglVertexAttribs4svNV;
  glVertexAttribs4ubvNV: TglVertexAttribs4ubvNV;

  // GL_PGI_misc_hints
  glHintPGI: TglHintPGI;

  // GL_SGIS_detail_texture
  glDetailTexFuncSGIS: TglDetailTexFuncSGIS;
  glGetDetailTexFuncSGIS: TglGetDetailTexFuncSGIS;

  // GL_SGIS_fog_function
  glFogFuncSGIS: TglFogFuncSGIS;
  glGetFogFuncSGIS: TglGetFogFuncSGIS;

  // GL_SGIS_multisample
  glSampleMaskSGIS: TglSampleMaskSGIS;
  glSamplePatternSGIS: TglSamplePatternSGIS;

  // GL_SGIS_pixel_texture
  glPixelTexGenParameteriSGIS: TglPixelTexGenParameteriSGIS;
  glPixelTexGenParameterivSGIS: TglPixelTexGenParameterivSGIS;
  glPixelTexGenParameterfSGIS: TglPixelTexGenParameterfSGIS;
  glPixelTexGenParameterfvSGIS: TglPixelTexGenParameterfvSGIS;
  glGetPixelTexGenParameterivSGIS: TglGetPixelTexGenParameterivSGIS;
  glGetPixelTexGenParameterfvSGIS: TglGetPixelTexGenParameterfvSGIS;

  // GL_SGIS_point_parameters
  glPointParameterfSGIS: TglPointParameterfSGIS;
  glPointParameterfvSGIS: TglPointParameterfvSGIS;

  // GL_SGIS_sharpen_texture
  glSharpenTexFuncSGIS: TglSharpenTexFuncSGIS;
  glGetSharpenTexFuncSGIS: TglGetSharpenTexFuncSGIS;

  // GL_SGIS_texture4D
  glTexImage4DSGIS: TglTexImage4DSGIS;
  glTexSubImage4DSGIS: TglTexSubImage4DSGIS;

  // GL_SGIS_texture_color_mask
  glTextureColorMaskSGIS: TglTextureColorMaskSGIS;

  // GL_SGIS_texture_filter4
  glGetTexFilterFuncSGIS: TglGetTexFilterFuncSGIS;
  glTexFilterFuncSGIS: TglTexFilterFuncSGIS;

  // GL_SGIX_async
  glAsyncMarkerSGIX: TglAsyncMarkerSGIX;
  glFinishAsyncSGIX: TglFinishAsyncSGIX;
  glPollAsyncSGIX: TglPollAsyncSGIX;
  glGenAsyncMarkersSGIX: TglGenAsyncMarkersSGIX;
  glDeleteAsyncMarkersSGIX: TglDeleteAsyncMarkersSGIX;
  glIsAsyncMarkerSGIX: TglIsAsyncMarkerSGIX;

  // GL_SGIX_flush_raster
  glFlushRasterSGIX: TglFlushRasterSGIX;

  // GL_SGIX_fragment_lighting
  glFragmentColorMaterialSGIX: TglFragmentColorMaterialSGIX;
  glFragmentLightfSGIX: TglFragmentLightfSGIX;
  glFragmentLightfvSGIX: TglFragmentLightfvSGIX;
  glFragmentLightiSGIX: TglFragmentLightiSGIX;
  glFragmentLightivSGIX: TglFragmentLightivSGIX;
  glFragmentLightModelfSGIX: TglFragmentLightModelfSGIX;
  glFragmentLightModelfvSGIX: TglFragmentLightModelfvSGIX;
  glFragmentLightModeliSGIX: TglFragmentLightModeliSGIX;
  glFragmentLightModelivSGIX: TglFragmentLightModelivSGIX;
  glFragmentMaterialfSGIX: TglFragmentMaterialfSGIX;
  glFragmentMaterialfvSGIX: TglFragmentMaterialfvSGIX;
  glFragmentMaterialiSGIX: TglFragmentMaterialiSGIX;
  glFragmentMaterialivSGIX: TglFragmentMaterialivSGIX;
  glGetFragmentLightfvSGIX: TglGetFragmentLightfvSGIX;
  glGetFragmentLightivSGIX: TglGetFragmentLightivSGIX;
  glGetFragmentMaterialfvSGIX: TglGetFragmentMaterialfvSGIX;
  glGetFragmentMaterialivSGIX: TglGetFragmentMaterialivSGIX;
  glLightEnviSGIX: TglLightEnviSGIX;

  // GL_SGIX_framezoom
  glFrameZoomSGIX: TglFrameZoomSGIX;

  // GL_SGIX_igloo_interface
  glIglooInterfaceSGIX: TglIglooInterfaceSGIX;

  // GL_SGIX_instruments
  glGetInstrumentsSGIX: TglGetInstrumentsSGIX;
  glInstrumentsBufferSGIX: TglInstrumentsBufferSGIX;
  glPollInstrumentsSGIX: TglPollInstrumentsSGIX;
  glReadInstrumentsSGIX: TglReadInstrumentsSGIX;
  glStartInstrumentsSGIX: TglStartInstrumentsSGIX;
  glStopInstrumentsSGIX: TglStopInstrumentsSGIX;

  // GL_SGIX_list_priority
  glGetListParameterfvSGIX: TglGetListParameterfvSGIX;
  glGetListParameterivSGIX: TglGetListParameterivSGIX;
  glListParameterfSGIX: TglListParameterfSGIX;
  glListParameterfvSGIX: TglListParameterfvSGIX;
  glListParameteriSGIX: TglListParameteriSGIX;
  glListParameterivSGIX: TglListParameterivSGIX;

  // GL_SGIX_pixel_texture
  glPixelTexGenSGIX: TglPixelTexGenSGIX;

  // GL_SGIX_polynomial_ffd
  glDeformationMap3dSGIX: TglDeformationMap3dSGIX;
  glDeformationMap3fSGIX: TglDeformationMap3fSGIX;
  glDeformSGIX: TglDeformSGIX;
  glLoadIdentityDeformationMapSGIX: TglLoadIdentityDeformationMapSGIX;

  // GL_SGIX_reference_plane
  glReferencePlaneSGIX: TglReferencePlaneSGIX;

  // GL_SGIX_sprite
  glSpriteParameterfSGIX: TglSpriteParameterfSGIX;
  glSpriteParameterfvSGIX: TglSpriteParameterfvSGIX;
  glSpriteParameteriSGIX: TglSpriteParameteriSGIX;
  glSpriteParameterivSGIX: TglSpriteParameterivSGIX;

  // GL_SGIX_tag_sample_buffer
  glTagSampleBufferSGIX: TglTagSampleBufferSGIX;

  // GL_SGI_color_table
  glColorTableSGI: TglColorTableSGI;
  glColorTableParameterfvSGI: TglColorTableParameterfvSGI;
  glColorTableParameterivSGI: TglColorTableParameterivSGI;
  glCopyColorTableSGI: TglCopyColorTableSGI;
  glGetColorTableSGI: TglGetColorTableSGI;
  glGetColorTableParameterfvSGI: TglGetColorTableParameterfvSGI;
  glGetColorTableParameterivSGI: TglGetColorTableParameterivSGI;

  // GL_SUNX_constant_data
  glFinishTextureSUNX: TglFinishTextureSUNX;

  // GL_SUN_global_alpha
  glGlobalAlphaFactorbSUN: TglGlobalAlphaFactorbSUN;
  glGlobalAlphaFactorsSUN: TglGlobalAlphaFactorsSUN;
  glGlobalAlphaFactoriSUN: TglGlobalAlphaFactoriSUN;
  glGlobalAlphaFactorfSUN: TglGlobalAlphaFactorfSUN;
  glGlobalAlphaFactordSUN: TglGlobalAlphaFactordSUN;
  glGlobalAlphaFactorubSUN: TglGlobalAlphaFactorubSUN;
  glGlobalAlphaFactorusSUN: TglGlobalAlphaFactorusSUN;
  glGlobalAlphaFactoruiSUN: TglGlobalAlphaFactoruiSUN;

  // GL_SUN_mesh_array
  glDrawMeshArraysSUN: TglDrawMeshArraysSUN;

  // GL_SUN_triangle_list
  glReplacementCodeuiSUN: TglReplacementCodeuiSUN;
  glReplacementCodeusSUN: TglReplacementCodeusSUN;
  glReplacementCodeubSUN: TglReplacementCodeubSUN;
  glReplacementCodeuivSUN: TglReplacementCodeuivSUN;
  glReplacementCodeusvSUN: TglReplacementCodeusvSUN;
  glReplacementCodeubvSUN: TglReplacementCodeubvSUN;
  glReplacementCodePointerSUN: TglReplacementCodePointerSUN;

  // GL_SUN_vertex
  glColor4ubVertex2fSUN: TglColor4ubVertex2fSUN;
  glColor4ubVertex2fvSUN: TglColor4ubVertex2fvSUN;
  glColor4ubVertex3fSUN: TglColor4ubVertex3fSUN;
  glColor4ubVertex3fvSUN: TglColor4ubVertex3fvSUN;
  glColor3fVertex3fSUN: TglColor3fVertex3fSUN;
  glColor3fVertex3fvSUN: TglColor3fVertex3fvSUN;
  glNormal3fVertex3fSUN: TglNormal3fVertex3fSUN;
  glNormal3fVertex3fvSUN: TglNormal3fVertex3fvSUN;
  glColor4fNormal3fVertex3fSUN: TglColor4fNormal3fVertex3fSUN;
  glColor4fNormal3fVertex3fvSUN: TglColor4fNormal3fVertex3fvSUN;
  glTexCoord2fVertex3fSUN: TglTexCoord2fVertex3fSUN;
  glTexCoord2fVertex3fvSUN: TglTexCoord2fVertex3fvSUN;
  glTexCoord4fVertex4fSUN: TglTexCoord4fVertex4fSUN;
  glTexCoord4fVertex4fvSUN: TglTexCoord4fVertex4fvSUN;
  glTexCoord2fColor4ubVertex3fSUN: TglTexCoord2fColor4ubVertex3fSUN;
  glTexCoord2fColor4ubVertex3fvSUN: TglTexCoord2fColor4ubVertex3fvSUN;
  glTexCoord2fColor3fVertex3fSUN: TglTexCoord2fColor3fVertex3fSUN;
  glTexCoord2fColor3fVertex3fvSUN: TglTexCoord2fColor3fVertex3fvSUN;
  glTexCoord2fNormal3fVertex3fSUN: TglTexCoord2fNormal3fVertex3fSUN;
  glTexCoord2fNormal3fVertex3fvSUN: TglTexCoord2fNormal3fVertex3fvSUN;
  glTexCoord2fColor4fNormal3fVertex3fSUN: TglTexCoord2fColor4fNormal3fVertex3fSUN;
  glTexCoord2fColor4fNormal3fVertex3fvSUN: TglTexCoord2fColor4fNormal3fVertex3fvSUN;
  glTexCoord4fColor4fNormal3fVertex4fSUN: TglTexCoord4fColor4fNormal3fVertex4fSUN;
  glTexCoord4fColor4fNormal3fVertex4fvSUN: TglTexCoord4fColor4fNormal3fVertex4fvSUN;
  glReplacementCodeuiVertex3fSUN: TglReplacementCodeuiVertex3fSUN;
  glReplacementCodeuiVertex3fvSUN: TglReplacementCodeuiVertex3fvSUN;
  glReplacementCodeuiColor4ubVertex3fSUN: TglReplacementCodeuiColor4ubVertex3fSUN;
  glReplacementCodeuiColor4ubVertex3fvSUN: TglReplacementCodeuiColor4ubVertex3fvSUN;
  glReplacementCodeuiColor3fVertex3fSUN: TglReplacementCodeuiColor3fVertex3fSUN;
  glReplacementCodeuiColor3fVertex3fvSUN: TglReplacementCodeuiColor3fVertex3fvSUN;
  glReplacementCodeuiNormal3fVertex3fSUN: TglReplacementCodeuiNormal3fVertex3fSUN;
  glReplacementCodeuiNormal3fVertex3fvSUN: TglReplacementCodeuiNormal3fVertex3fvSUN;
  glReplacementCodeuiColor4fNormal3fVertex3fSUN: TglReplacementCodeuiColor4fNormal3fVertex3fSUN;
  glReplacementCodeuiColor4fNormal3fVertex3fvSUN: TglReplacementCodeuiColor4fNormal3fVertex3fvSUN;
  glReplacementCodeuiTexCoord2fVertex3fSUN: TglReplacementCodeuiTexCoord2fVertex3fSUN;
  glReplacementCodeuiTexCoord2fVertex3fvSUN: TglReplacementCodeuiTexCoord2fVertex3fvSUN;
  glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN: TglReplacementCodeuiTexCoord2fNormal3fVertex3fSUN;
  glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN: TglReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN;
  glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN: TglReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN;
  glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN: TglReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN;
{$IFDEF CLR}
  wglGetProcAddressEx: TwglGetProcAddress;
{$ELSE}
  // Phobeus
  {$IFDEF Win32}wglGetProcAddress: TwglGetProcAddress;{$ENDIF}
{$ENDIF}
// Phobeus
{$IFDEF Win32CLR}
  wglCopyContext: TwglCopyContext;
  wglCreateContext: TwglCreateContext;
  wglCreateLayerContext: TwglCreateLayerContext;
  wglDeleteContext: TwglDeleteContext;
  wglDescribeLayerPlane: TwglDescribeLayerPlane;
  wglGetCurrentContext: TwglGetCurrentContext;
  wglGetCurrentDC: TwglGetCurrentDC;
  wglGetLayerPaletteEntries: TwglGetLayerPaletteEntries;
  wglMakeCurrent: TwglMakeCurrent;
  wglRealizeLayerPalette: TwglRealizeLayerPalette;
  wglSetLayerPaletteEntries: TwglSetLayerPaletteEntries;
  wglShareLists: TwglShareLists;
  wglSwapLayerBuffers: TwglSwapLayerBuffers;
  wglSwapMultipleBuffers: TwglSwapMultipleBuffers;
  wglUseFontBitmapsA: TwglUseFontBitmapsA;
  wglUseFontOutlinesA: TwglUseFontOutlinesA;
  wglUseFontBitmapsW: TwglUseFontBitmapsW;
  wglUseFontOutlinesW: TwglUseFontOutlinesW;
  wglUseFontBitmaps: TwglUseFontBitmaps;
  wglUseFontOutlines: TwglUseFontOutlines;

   // WGL_ARB_buffer_region
  wglCreateBufferRegionARB: TwglCreateBufferRegionARB;
  wglDeleteBufferRegionARB: TwglDeleteBufferRegionARB;
  wglSaveBufferRegionARB: TwglSaveBufferRegionARB;
  wglRestoreBufferRegionARB: TwglRestoreBufferRegionARB;

  // WGL_ARB_make_current_read
  wglMakeContextCurrentARB: TwglMakeContextCurrentARB;
  wglGetCurrentReadDCARB: TwglGetCurrentReadDCARB;

  // WGL_ARB_pbuffer
  wglCreatePbufferARB: TwglCreatePbufferARB;
  wglGetPbufferDCARB: TwglGetPbufferDCARB;
  wglReleasePbufferDCARB: TwglReleasePbufferDCARB;
  wglDestroyPbufferARB: TwglDestroyPbufferARB;
  wglQueryPbufferARB: TwglQueryPbufferARB;

  // WGL_ARB_pixel_format
  wglGetPixelFormatAttribivARB: TwglGetPixelFormatAttribivARB;
  wglGetPixelFormatAttribfvARB: TwglGetPixelFormatAttribfvARB;
  wglChoosePixelFormatARB: TwglChoosePixelFormatARB;
  // WGL_ARB_color_buffer_float
  wglClampColorARB: TwglClampColorARB;

  // WGL_ARB_render_texture
  wglBindTexImageARB: TwglBindTexImageARB;
  wglReleaseTexImageARB: TwglReleaseTexImageARB;
  wglSetPbufferAttribARB: TwglSetPbufferAttribARB;

  // WGL_EXT_display_color_table
  wglCreateDisplayColorTableEXT: TwglCreateDisplayColorTableEXT;
  wglLoadDisplayColorTableEXT: TwglLoadDisplayColorTableEXT;
  wglBindDisplayColorTableEXT: TwglBindDisplayColorTableEXT;
  wglDestroyDisplayColorTableEXT: TwglDestroyDisplayColorTableEXT;

  // WGL_EXT_make_current_read
  wglMakeContextCurrentEXT: TwglMakeContextCurrentEXT;
  wglGetCurrentReadDCEXT: TwglGetCurrentReadDCEXT;

  // WGL_EXT_pbuffer
  wglCreatePbufferEXT: TwglCreatePbufferEXT;
  wglGetPbufferDCEXT: TwglGetPbufferDCEXT;
  wglReleasePbufferDCEXT: TwglReleasePbufferDCEXT;
  wglDestroyPbufferEXT: TwglDestroyPbufferEXT;
  wglQueryPbufferEXT: TwglQueryPbufferEXT;

  // WGL_EXT_pixel_format
  wglGetPixelFormatAttribivEXT: TwglGetPixelFormatAttribivEXT;
  wglGetPixelFormatAttribfvEXT: TwglGetPixelFormatAttribfvEXT;
  wglChoosePixelFormatEXT: TwglChoosePixelFormatEXT;

  // WGL_EXT_swap_control
  wglSwapIntervalEXT: TwglSwapIntervalEXT;
  wglGetSwapIntervalEXT: TwglGetSwapIntervalEXT;

  // WGL_I3D_digital_video_control
  wglGetDigitalVideoParametersI3D: TwglGetDigitalVideoParametersI3D;
  wglSetDigitalVideoParametersI3D: TwglSetDigitalVideoParametersI3D;

  // WGL_I3D_gamma
  wglGetGammaTableParametersI3D: TwglGetGammaTableParametersI3D;
  wglSetGammaTableParametersI3D: TwglSetGammaTableParametersI3D;
  wglGetGammaTableI3D: TwglGetGammaTableI3D;
  wglSetGammaTableI3D: TwglSetGammaTableI3D;

  // WGL_I3D_genlock
  wglEnableGenlockI3D: TwglEnableGenlockI3D;
  wglDisableGenlockI3D: TwglDisableGenlockI3D;
  wglIsEnabledGenlockI3D: TwglIsEnabledGenlockI3D;
  wglGenlockSourceI3D: TwglGenlockSourceI3D;
  wglGetGenlockSourceI3D: TwglGetGenlockSourceI3D;
  wglGenlockSourceEdgeI3D: TwglGenlockSourceEdgeI3D;
  wglGetGenlockSourceEdgeI3D: TwglGetGenlockSourceEdgeI3D;
  wglGenlockSampleRateI3D: TwglGenlockSampleRateI3D;
  wglGetGenlockSampleRateI3D: TwglGetGenlockSampleRateI3D;
  wglGenlockSourceDelayI3D: TwglGenlockSourceDelayI3D;
  wglGetGenlockSourceDelayI3D: TwglGetGenlockSourceDelayI3D;
  wglQueryGenlockMaxSourceDelayI3D: TwglQueryGenlockMaxSourceDelayI3D;

  // WGL_I3D_image_buffer
  wglCreateImageBufferI3D: TwglCreateImageBufferI3D;
  wglDestroyImageBufferI3D: TwglDestroyImageBufferI3D;
  wglAssociateImageBufferEventsI3D: TwglAssociateImageBufferEventsI3D;
  wglReleaseImageBufferEventsI3D: TwglReleaseImageBufferEventsI3D;

  // WGL_I3D_swap_frame_lock
  wglEnableFrameLockI3D: TwglEnableFrameLockI3D;
  wglDisableFrameLockI3D: TwglDisableFrameLockI3D;
  wglIsEnabledFrameLockI3D: TwglIsEnabledFrameLockI3D;
  wglQueryFrameLockMasterI3D: TwglQueryFrameLockMasterI3D;

  // WGL_I3D_swap_frame_usage
  wglGetFrameUsageI3D: TwglGetFrameUsageI3D;
  wglBeginFrameTrackingI3D: TwglBeginFrameTrackingI3D;
  wglEndFrameTrackingI3D: TwglEndFrameTrackingI3D;
  wglQueryFrameTrackingI3D: TwglQueryFrameTrackingI3D;

  // WGL_NV_vertex_array_range
  wglAllocateMemoryNV: TwglAllocateMemoryNV;
  wglFreeMemoryNV: TwglFreeMemoryNV;

  // WGL_OML_sync_control
  wglGetSyncValuesOML: TwglGetSyncValuesOML;
  wglGetMscRateOML: TwglGetMscRateOML;
  wglSwapBuffersMscOML: TwglSwapBuffersMscOML;
  wglSwapLayerBuffersMscOML: TwglSwapLayerBuffersMscOML;
  wglWaitForMscOML: TwglWaitForMscOML;
  wglWaitForSbcOML: TwglWaitForSbcOML;

  {$ENDIF}
  
  // WIN_draw_range_elements
  glDrawRangeElementsWIN: TglDrawRangeElementsWIN;

  // WIN_swap_hint
  glAddSwapHintRectWIN: TglAddSwapHintRectWIN;

  // GL utility functions and procedures
  gluErrorString: TgluErrorString;
  gluOrtho2D: TgluOrtho2D;
  gluPerspective: TgluPerspective;
  gluPickMatrix: TgluPickMatrix;
  gluLookAt: TgluLookAt;
  gluProject: TgluProject;
  gluUnProject: TgluUnProject;
  gluScaleImage: TgluScaleImage;
  gluBuild1DMipmaps: TgluBuild1DMipmaps;
  gluBuild2DMipmaps: TgluBuild2DMipmaps;
  gluNewQuadric: TgluNewQuadric;
  gluDeleteQuadric: TgluDeleteQuadric;
  gluQuadricNormals: TgluQuadricNormals;
  gluQuadricTexture: TgluQuadricTexture;
  gluQuadricOrientation: TgluQuadricOrientation;
  gluQuadricDrawStyle: TgluQuadricDrawStyle;
  gluCylinder: TgluCylinder;
  gluDisk: TgluDisk;
  gluPartialDisk: TgluPartialDisk;
  gluSphere: TgluSphere;
  gluQuadricCallback: TgluQuadricCallback;
  gluNewTess: TgluNewTess;
  gluDeleteTess: TgluDeleteTess;
  gluTessBeginPolygon: TgluTessBeginPolygon;
  gluTessBeginContour: TgluTessBeginContour;
  gluTessVertex: TgluTessVertex;
  gluTessEndContour: TgluTessEndContour;
  gluTessEndPolygon: TgluTessEndPolygon;
  gluTessProperty: TgluTessProperty;
  gluTessNormal: TgluTessNormal;
  gluTessCallback: TgluTessCallback;
  gluGetTessProperty: TgluGetTessProperty;
  gluNewNurbsRenderer: TgluNewNurbsRenderer;
  gluDeleteNurbsRenderer: TgluDeleteNurbsRenderer;
  gluBeginSurface: TgluBeginSurface;
  gluBeginCurve: TgluBeginCurve;
  gluEndCurve: TgluEndCurve;
  gluEndSurface: TgluEndSurface;
  gluBeginTrim: TgluBeginTrim;
  gluEndTrim: TgluEndTrim;
  gluPwlCurve: TgluPwlCurve;
  gluNurbsCurve: TgluNurbsCurve;
  gluNurbsSurface: TgluNurbsSurface;
  gluLoadSamplingMatrices: TgluLoadSamplingMatrices;
  gluNurbsProperty: TgluNurbsProperty;
  gluGetNurbsProperty: TgluGetNurbsProperty;
  gluNurbsCallback: TgluNurbsCallback;
  gluBeginPolygon: TgluBeginPolygon;
  gluNextContour: TgluNextContour;
  gluEndPolygon: TgluEndPolygon;

var
  _glColorPointer: TglColorPointer;
  _glGenTextures: TglGenTextures;
  _glGetString: TglGetString;
  _glNormalPointer: TglNormalPointer;
  _glReadPixels: TglReadPixels;
  _glTexCoordPointer: TglTexCoordPointer;
  _glTexImage2D: TglTexImage2D;
  _glVertexPointer: TglVertexPointer;
  _glVertexAttribPointerARB: TglVertexAttribPointerARB;

  // GL_VERSION_1_5
  _glBufferData: TglBufferData;
  _glBufferSubData: TglBufferSubData;

  //Phobeus
  {$IFDEF Win32CLR}
  _wglGetExtensionsStringARB: TwglGetExtensionsStringARB;
  _wglGetExtensionsStringEXT: TwglGetExtensionsStringEXT;
  {$ENDIF}

  _glCreateShaderObjectARB: TglCreateShaderObjectARB;
  _glShaderSourceARB: TglShaderSourceARB;
  _glGetInfoLogARB: TglGetInfoLogARB;

  _glBufferDataARB: TglBufferDataARB;
  _glBufferSubDataARB: TglBufferSubDataARB;

  _gluGetString: TgluGetString;

type
  TRCOptions = set of (opDoubleBuffered, opGDI, opStereo);

var
  LibHandle: THandle = 0;
  GLULibHandle: THandle = 0;
  LastPixelFormat: Integer;
  ExtensionsRead: Boolean;
  ImplementationRead: Boolean;

{$IFDEF Win32CLR}
function InitOpenGL(LibName: string = 'OpenGL32.dll'; GLULibName: string = 'GLU32.dll'): Boolean;
{$ELSE}
function InitOpenGL(LibName: string = 'libGL.so.1'; GLULibName: string = 'libGLU.so.1'): Boolean;
{$ENDIF}
procedure ReadExtensions;
procedure ReadImplementationProperties;
{$IFDEF Win32CLR}
// =============================================================================
// Helper-Functions
// =============================================================================
function CreateRenderingContext(DC: HDC; Options: TRCOptions; ColorBits, ZBits, StencilBits, AccumBits, AuxBuffers: Integer; Layer: Integer): HGLRC;
procedure ActivateRenderingContext(DC: HDC; RC: HGLRC; loadext: boolean = true);
procedure DeactivateRenderingContext;
procedure DestroyRenderingContext(RC: HGLRC);
{$ENDIF}

{$IFDEF CLR}
function SwapBuffers(DC: HDC): BOOL; stdcall;
function GetDC(hWnd: HWND): HDC; stdcall;
function ReleaseDC(hWnd: HWND; hDC: HDC): Integer; stdcall;
{$ENDIF}

procedure glTexImage2D(target: TGLenum; level: TGLint; internalformat: TGLint; width: TGLsizei; height: TGLsizei; border: TGLint; format: TGLenum; _type: TGLenum; const pixels: PGLvoid); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glGenTextures(n: TGLsizei; textures: PGLuint); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glVertexPointer(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glColorPointer(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glTexCoordPointer(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glNormalPointer(_type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glVertexAttribPointerARB(index: TGLuint; size: TGLint; _type: TGLenum; normalized: TGLboolean; stride: TGLsizei; const _pointer: PGLvoid); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glReadPixels(x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei; format: TGLenum; _type: TGLenum; pixels: PGLvoid); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
function glCreateShaderObjectARB(shaderType: glenum): GLHandleARB; overload;{$IFDEF DELPHI2005}inline;{$ENDIF}

// GL_ARB_vertex_buffer_object
procedure glBufferDataARB(target: TGLenum; size: TGLsizei; const data: PGLvoid; usage: TGLenum); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glBufferSubDataARB(target: TGLenum; offset: TGLsizei; size: TGLsizei; const data: PGLvoid); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}

// GL_VERSION_1_5
procedure glBufferData(target: TGLenum; size: TGLsizei; const data: PGLvoid; usage: TGLenum); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glBufferSubData(target: TGLenum; offset: TGLsizei; size: TGLsizei; const data: PGLvoid); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}

{$IFDEF CLR}
procedure glTexImage2D(target: TGLenum; level: TGLint; internalformat: TGLint; width: TGLsizei; height: TGLsizei; border: TGLint; format: TGLenum; _type: TGLenum; const pixels: System.array); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glTexImage2D(target: TGLenum; level: TGLint; internalformat: TGLint; border: TGLint; bmp: Bitmap); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glTexImage2D(target: TGLenum; level: TGLint; internalformat: TGLint; border: TGLint; st: Stream); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glTexImage2D(target: TGLenum; level: TGLint; internalformat: TGLint; border: TGLint; filename: string); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
function glGenTextures(n: TGLsizei): PGLuInt; overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
function glGenTexture(): GLuInt; overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
function glGenTexture(bmp: Bitmap): GLuInt; overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
function glGenTexture(st: Stream): GLuInt; overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
function glGenTexture(filename: string): GLuInt; overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glVertexPointer(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: System.array); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glColorPointer(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: System.array); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glTexCoordPointer(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: System.array); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glNormalPointer(_type: TGLenum; stride: TGLsizei; const _pointer: System.array); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glVertexAttribPointerARB(index: TGLuint; size: TGLint; _type: TGLenum; normalized: TGLboolean; stride: TGLsizei; const _pointer: System.array); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glVertexPointer(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: Integer); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glColorPointer(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: Integer); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glTexCoordPointer(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: Integer); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glNormalPointer(_type: TGLenum; stride: TGLsizei; const _pointer: Integer); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glVertexAttribPointerARB(index: TGLuint; size: TGLint; _type: TGLenum; normalized: TGLboolean; stride: TGLsizei; const _pointer: Integer); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glReadPixels(x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei; format: TGLenum; _type: TGLenum; pixels: System.array); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
function glReadPixels(x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei): Bitmap; overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
function glGetString(name: TGLenum): string;{$IFDEF DELPHI2005}inline;{$ENDIF}
function gluGetString(name: TGLenum): string;{$IFDEF DELPHI2005}inline;{$ENDIF}
function wglGetExtensionsStringEXT: string;{$IFDEF DELPHI2005}inline;{$ENDIF}
function wglGetExtensionsStringARB(dc: HDC): string;{$IFDEF DELPHI2005}inline;{$ENDIF}

procedure glBufferDataARB(target: TGLenum; size: TGLsizei; data: System.array; usage: TGLenum); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glBufferSubDataARB(target: TGLenum; offset: TGLsizei; size: TGLsizei; data: System.array); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glBufferData(target: TGLenum; size: TGLsizei; data: System.array; usage: TGLenum); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glBufferSubData(target: TGLenum; offset: TGLsizei; size: TGLsizei; data: System.array); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}

// GL_VERSION_1_5
function glCreateShaderObjectARB(shaderType: glenum; source: string): GLHandleARB; overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glShaderSourceARB(shaderObj: GLHandleARB; count: glsizei; _string: array of string; lengths: pglint); overload;
procedure glShaderSourceARB(shaderObj: GLHandleARB; source: string); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glGetInfoLogARB(shaderObj: GLHandleARB; maxLength: glsizei; var length: glint; infoLog: StringBuilder); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
function glGetInfoLogARB(shaderObj: GLHandleARB): string; overload;{$IFDEF DELPHI2005}inline;{$ENDIF}

// GL_VERSION_2_0
procedure glShaderSource(shaderObj: GLHandle; count: glsizei; _string: array of string; lengths: pglint); overload;
procedure glShaderSource(shaderObj: GLHandle; source: string); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glGetProgramInfoLog(programObj: GLHandle; maxLength: glsizei; var length: glint; infoLog: StringBuilder); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
function glGetProgramInfoLog(programObj: GLHandle): string; overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glGetShaderInfoLog(shaderObj: GLHandle; maxLength: glsizei; var length: glint; infoLog: StringBuilder); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
function glGetShaderInfoLog(shaderObj: GLHandle): string; overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
{$ELSE}

function glGetString(name: TGLenum): PChar;{$IFDEF DELPHI2005}inline;{$ENDIF}
function gluGetString(name: TGLenum): PChar;{$IFDEF DELPHI2005}inline;{$ENDIF}


//Phobeus
{$IFDEF Win32CLR}
function wglGetExtensionsStringEXT: PChar;{$IFDEF DELPHI2005}inline;{$ENDIF}
function wglGetExtensionsStringARB(dc: HDC): PChar;{$IFDEF DELPHI2005}inline;{$ENDIF}
{$ENDIF}

procedure glShaderSourceARB(shaderObj: GLHandleARB; count: glsizei; _string: PPGLCharARB; lengths: pglint); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glGetInfoLogARB(shaderObj: GLHandleARB; maxLength: glsizei; var length: glint; infoLog: PChar);{$IFDEF DELPHI2005}inline;{$ENDIF}

// GL_VERSION_2_0
procedure glShaderSource(shaderObj: GLHandle; count: glsizei; _string: PPGLChar; lengths: pglint); overload;
procedure glGetProgramInfoLog(programObj: GLHandle; maxLength: glsizei; var length: glint; infoLog: PChar); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
procedure glGetShaderInfoLog(shaderObj: GLHandle; maxLength: glsizei; var length: glint; infoLog: PChar); overload;{$IFDEF DELPHI2005}inline;{$ENDIF}
{$ENDIF}

procedure ReadOpenGLCore;
procedure Read_GL_3DFX_tbuffer;
procedure Read_GL_APPLE_element_array;
procedure Read_GL_APPLE_fence;
procedure Read_GL_APPLE_vertex_array_object;
procedure Read_GL_APPLE_vertex_array_range;
procedure Read_GL_ARB_matrix_palette;
procedure Read_GL_ARB_multitexture;
procedure Read_GL_ARB_point_parameters;
procedure Read_GL_ARB_texture_compression;
procedure Read_GL_ARB_transpose_matrix;
procedure Read_GL_ARB_vertex_blend;
procedure Read_GL_ARB_buffer_object;
procedure Read_GL_ARB_vertex_program;
procedure Read_GL_ARB_window_pos;
procedure Read_GL_ARB_color_buffer_float;
procedure Read_GL_ARB_Shader_Objects;
procedure Read_GL_ARB_occlusion_query;
procedure Read_GL_ATI_draw_buffers;
procedure Read_GL_ATI_element_array;
procedure Read_GL_ATI_envmap_bumpmap;
procedure Read_GL_ATI_fragment_shader;
procedure Read_GL_ATI_map_object_buffer;
procedure Read_GL_ATI_pn_triangles;
procedure Read_GL_ATI_separate_stencil;
procedure Read_GL_ATI_vertex_array_object;
procedure Read_GL_ATI_vertex_attrib_array_object;
procedure Read_GL_ATI_vertex_streams;
procedure Read_GL_EXT_blend_color;
procedure Read_GL_EXT_blend_func_separate;
procedure Read_GL_EXT_blend_minmax;
procedure Read_GL_EXT_color_subtable;
procedure Read_GL_EXT_compiled_vertex_array;
procedure Read_GL_EXT_convolution;
procedure Read_GL_EXT_coordinate_frame;
procedure Read_GL_EXT_copy_texture;
procedure Read_GL_EXT_cull_vertex;
procedure Read_GL_EXT_draw_range_elements;
procedure Read_GL_EXT_fog_coord;
procedure Read_GL_EXT_framebuffer_object;
procedure Read_GL_EXT_histogram;
procedure Read_GL_EXT_index_func;
procedure Read_GL_EXT_index_material;
procedure Read_GL_EXT_multi_draw_arrays;
procedure Read_GL_EXT_multisample;
procedure Read_GL_EXT_paletted_texture;
procedure Read_GL_EXT_pixel_transform;
procedure Read_GL_EXT_point_parameters;
procedure Read_GL_EXT_polygon_offset;
procedure Read_GL_EXT_secondary_color;
procedure Read_GL_EXT_stencil_two_side;
procedure Read_GL_EXT_subtexture;
procedure Read_GL_EXT_texture3D;
procedure Read_GL_EXT_texture_object;
procedure Read_GL_EXT_texture_perturb_normal;
procedure Read_GL_EXT_vertex_array;
procedure Read_GL_EXT_vertex_shader;
procedure Read_GL_EXT_vertex_weighting;
procedure Read_GL_EXT_depth_bounds_test;
procedure Read_GL_EXT_blend_equation_separate;
procedure Read_GL_EXT_stencil_clear_tag;
procedure Read_GL_HP_image_transform;
procedure Read_GL_IBM_multimode_draw_arrays;
procedure Read_GL_IBM_vertex_array_lists;
procedure Read_GL_INGR_blend_func_separate;
procedure Read_GL_INTEL_parallel_arrays;
procedure Read_GL_MESA_resize_buffers;
procedure Read_GL_MESA_window_pos;
procedure Read_GL_NV_evaluators;
procedure Read_GL_NV_fence;
procedure Read_GL_NV_fragment_program;
procedure Read_GL_NV_half_float;
procedure Read_GL_NV_occlusion_query;
procedure Read_GL_NV_pixel_data_range;
procedure Read_GL_NV_point_sprite;
procedure Read_GL_NV_primitive_restart;
procedure Read_GL_NV_register_combiners;
procedure Read_GL_NV_register_combiners2;
procedure Read_GL_NV_vertex_array_range;
procedure Read_GL_NV_vertex_program;
procedure Read_GL_PGI_misc_hints;
procedure Read_GL_SGIS_detail_texture;
procedure Read_GL_SGIS_fog_function;
procedure Read_GL_SGIS_multisample;
procedure Read_GL_SGIS_pixel_texture;
procedure Read_GL_SGIS_point_parameters;
procedure Read_GL_SGIS_sharpen_texture;
procedure Read_GL_SGIS_texture4D;
procedure Read_GL_SGIS_texture_color_mask;
procedure Read_GL_SGIS_texture_filter4;
procedure Read_GL_SGIX_async;
procedure Read_GL_SGIX_flush_raster;
procedure Read_GL_SGIX_fragment_lighting;
procedure Read_GL_SGIX_framezoom;
procedure Read_GL_SGIX_igloo_interface;
procedure Read_GL_SGIX_instruments;
procedure Read_GL_SGIX_list_priority;
procedure Read_GL_SGIX_pixel_texture;
procedure Read_GL_SGIX_polynomial_ffd;
procedure Read_GL_SGIX_reference_plane;
procedure Read_GL_SGIX_sprite;
procedure Read_GL_SGIX_tag_sample_buffer;
procedure Read_GL_SGI_color_table;
procedure Read_GL_SUNX_constant_data;
procedure Read_GL_SUN_global_alpha;
procedure Read_GL_SUN_mesh_array;
procedure Read_GL_SUN_triangle_list;
procedure Read_GL_SUN_vertex;

//Phobeus
{$IFDEF Win32CLR}
procedure Read_WGL_ARB_buffer_region;
procedure Read_WGL_ARB_extensions_string;
procedure Read_WGL_ARB_make_current_read;
procedure Read_WGL_ARB_pbuffer;
procedure Read_WGL_ARB_pixel_format;
procedure Read_WGL_ARB_pixel_format_float;
procedure Read_WGL_ARB_render_texture;
procedure Read_WGL_EXT_display_color_table;
procedure Read_WGL_EXT_extensions_string;
procedure Read_WGL_EXT_make_current_read;
procedure Read_WGL_EXT_pbuffer;
procedure Read_WGL_EXT_pixel_format;
procedure Read_WGL_EXT_swap_control;
procedure Read_WGL_I3D_digital_video_control;
procedure Read_WGL_I3D_gamma;
procedure Read_WGL_I3D_genlock;
procedure Read_WGL_I3D_image_buffer;
procedure Read_WGL_I3D_swap_frame_lock;
procedure Read_WGL_I3D_swap_frame_usage;
procedure Read_WGL_NV_vertex_array_range;
procedure Read_WGL_OML_sync_control;

procedure Read_WIN_draw_range_elements;
procedure Read_WIN_swap_hint;
{$ENDIF}


implementation


{$IFNDEF Win32}
{$IFNDEF CLR}
  // Added by bero
const
  RTLD_LAZY = $001;
  RTLD_NOW = $002;
  RTLD_BINDING_MASK = $003;
  // Added by FS ( Seems to work on Debian / Fedora )
  LibraryLib = {$IFDEF Linux} 'libdl.so.2'{$ELSE} 'c'{$ENDIF};

function LoadLibraryEx(Name: PChar; Flags: LongInt): Pointer; cdecl; external LibraryLib name 'dlopen';

function GetProcAddressEx(Lib: Pointer; Name: PChar): Pointer; cdecl; external LibraryLib name 'dlsym';

function FreeLibraryEx(Lib: Pointer): LongInt; cdecl; external LibraryLib name 'dlclose';

function LoadLibrary(Name: PChar): THandle;
begin
  Result := THandle(LoadLibraryEx(Name, RTLD_LAZY));
end;

function GetProcAddress(LibHandle: THandle; ProcName: PChar): Pointer;
begin
  Result := GetProcAddressEx(Pointer(LibHandle), ProcName);
end;

function FreeLibrary(LibHandle: THandle): Boolean;
begin
  if LibHandle = 0 then
    Result := False
  else
    Result := FreeLibraryEx(Pointer(LibHandle)) = 0;
end;

function wglGetProcAddress(ProcName: PChar): Pointer;
begin
  Result := GetProcAddress(LibHandle, ProcName);
end;

{$ENDIF}
{$ENDIF}

{$IFDEF CLR}
var
  modbuilder: ModuleBuilder;
  asmbuilder: AssemblyBuilder;

function LoadLibrary(filename: string): Integer; external 'Kernel32.dll';
procedure FreeLibrary(handle: Integer); external 'Kernel32.dll';

function SwapBuffers(DC: HDC): BOOL; stdcall; external 'gdi32.dll';

function GetDC(hWnd: HWND): HDC; stdcall; external 'user32.dll';

function ReleaseDC(hWnd: HWND; hDC: HDC): Integer; stdcall; external 'gdi32.dll';

function GetObjectType(h: Integer): DWORD; stdcall; external 'gdi32.dll';

function ChoosePixelFormat(DC: HDC; var p2: TPixelFormatDescriptor): Integer; stdcall; external 'gdi32.dll';

function DescribePixelFormat(DC: HDC; p2: Integer; p3: UINT; var p4: TPixelFormatDescriptor): BOOL; stdcall; external 'gdi32.dll';

function GetPixelFormat(DC: HDC): Integer; stdcall; external 'gdi32.dll';

function SetPixelFormat(DC: HDC; PixelFormat: Integer; var FormatDef: TPixelFormatDescriptor): BOOL; stdcall; external 'gdi32.dll';

[DllImport('Kernel32.dll', EntryPoint = 'GetProcAddress')]

function GetProcAddressEx(handle: Integer; name: string): Integer;
begin
  result := 0;
end;

procedure InitAssembly;
var
  name: AssemblyName;
begin
  if assigned(modbuilder) then
    Exit;
  name := AssemblyName.Create;
  name.Name := 'Temp';
  asmbuilder := Thread.GetDomain.DefineDynamicAssembly(name, AssemblyBuilderAccess.Run);
  modbuilder := asmbuilder.DefineDynamicModule('Temp');
end;

function CreateDelegate(ptr: Integer; dtype: System.Type): Delegate;
var
  d, m2: MethodInfo;
  paramlist: array of System.Type;
  i: Integer;
  t: TypeBuilder;
  t2: System.Type;
  m: MethodBuilder;
  ilgen: ILGenerator;
begin
  try
    d := dtype.GetMethod('Invoke');
    setlength(paramlist, Length(d.GetParameters));
    for i := 0 to Length(paramlist) - 1 do
      paramlist[i] := d.GetParameters[i].ParameterType;
    t2 := modbuilder.GetType('_' + dtype.Name, false, false);
    if (t2 <> nil) then
    begin
      m2 := t2.GetMethod('Invoke');
      Result := Delegate.CreateDelegate(dtype, m2);
      exit;
    end;
    t := modbuilder.DefineType('_' + dtype.Name);
    m := t.DefineMethod('Invoke', MethodAttributes.Static or MethodAttributes.Public, d.ReturnType, paramlist);
    ilgen := m.GetILGenerator;
    for i := 0 to Length(paramlist) - 1 do
      ilgen.Emit(OpCodes.Ldarg, i);
    ilgen.Emit(OpCodes.Ldc_I4, Integer(ptr));
    ilgen.EmitCalli(OpCodes.Calli, CallingConvention.StdCall, d.ReturnType, paramlist);
    ilgen.Emit(OpCodes.Ret);
    t2 := t.CreateType();
    m2 := t2.GetMethod('Invoke');
    Result := Delegate.CreateDelegate(dtype, m2);
  except
    Result := nil;
  end;
end;

function GetProcAddress(handle: Integer; name: string): System.Delegate; overload;
var
  t: System.&Type;
  ptr: Integer;
begin
  result := nil;
  InitAssembly;
  t := &Type.GetType('dglOpengl.T' + name, false, true);
  ptr := GetProcAddressEx(handle, name);
  if (ptr <> 0) then
    result := CreateDelegate(ptr, t);
end;

function GetProcAddress(handle: Integer; name: string; t: System.&Type): System.Delegate; overload;
var
  ptr: Integer;
begin
  result := nil;
  InitAssembly;
  ptr := GetProcAddressEx(handle, name);
  if (ptr <> 0) then
    result := CreateDelegate(ptr, t);
end;

function wglGetProcAddress(name: string): System.Delegate; overload;
var
  t: System.&Type;
  ptr: Integer;
begin
  result := nil;
  InitAssembly;
  t := &Type.GetType('dglOpengl.T' + name, false, true);
  ptr := wglGetProcAddressEx(name);
  if (ptr <> 0) then
    result := CreateDelegate(ptr, t);
end;

function wglGetProcAddress(name: string; t: System.Type): System.Delegate; overload;
var
  ptr: Integer;
begin
  result := nil;
  InitAssembly;
  ptr := wglGetProcAddressEx(name);
  if (ptr <> 0) then
    result := CreateDelegate(ptr, t);
end;

function glProcedure(ProcName: string): System.Delegate; overload;
begin
  Result := nil;
  if Assigned(wglGetProcAddressEx) then
    Result := wglGetProcAddress(ProcName);
  if result <> nil then
    exit;
  Result := GetProcAddress(LibHandle, ProcName);
end;

function glProcedure(ProcName: string; t: System.Type): System.Delegate; overload;
begin
  Result := nil;
  if Assigned(wglGetProcAddressEx) then
    Result := wglGetProcAddress(ProcName, t);
  if result <> nil then
    exit;
  Result := GetProcAddress(LibHandle, ProcName, t);
end;

function glGetString(name: TGLenum): string;
begin
  result := Marshal.PtrToStringAnsi(_glGetString(name));
end;

function gluGetString(name: TGLenum): string;
begin
  if Assigned(_gluGetString) then
    result := Marshal.PtrToStringAnsi(_gluGetString(name));
end;

function wglGetExtensionsStringEXT: string;
begin
  result := Marshal.PtrToStringAnsi(_wglGetExtensionsStringEXT);
end;

function wglGetExtensionsStringARB(dc: HDC): string;
begin
  result := Marshal.PtrToStringAnsi(_wglGetExtensionsStringARB(dc));
end;

{$ELSE}

function glGetString(name: TGLenum): PChar;
begin
  result := _glGetString(name);
end;

function gluGetString(name: TGLenum): PChar;
begin
  result := _gluGetString(name);
end;

//Phobeus
{$IFDEF Win32CLR}
function wglGetExtensionsStringEXT: pchar;
begin
  result := _wglGetExtensionsStringEXT;
end;

function wglGetExtensionsStringARB(dc: HDC): pchar;
begin
  result := _wglGetExtensionsStringARB(dc);
end;
{$ENDIF}

// Thanks Mars!

function glProcedure(ProcName: PChar): Pointer;
begin
  Result := nil;
{$IFDEF Win32}
  // Changed by bero
  if Addr(wglGetProcAddress) <> nil then
    Result := wglGetProcAddress(ProcName);
  if result <> nil then
    exit;
{$ENDIF}
  Result := GetProcAddress(LibHandle, ProcName);
end;

{$ENDIF}

procedure glTexImage2D(target: TGLenum; level: TGLint; internalformat: TGLint; width: TGLsizei; height: TGLsizei; border: TGLint; format: TGLenum; _type: TGLenum; const pixels: PGLvoid); overload;
begin
  _glTexImage2D(target, level, internalformat, width, height, border, format, _type, pixels);
end;

procedure glGenTextures(n: TGLsizei; textures: PGLuint); overload;
begin
  _glGenTextures(n, textures);
end;

procedure glVertexPointer(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); overload;
begin
  _glVertexPointer(size, _type, stride, _pointer);
end;

procedure glColorPointer(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); overload;
begin
  _glColorPointer(size, _type, stride, _pointer);
end;

procedure glTexCoordPointer(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); overload;
begin
  _glTexCoordPointer(size, _type, stride, _pointer);
end;

procedure glNormalPointer(_type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); overload;
begin
  _glNormalPointer(_type, stride, _pointer);
end;

procedure glVertexAttribPointerARB(index: TGLuint; size: TGLint; _type: TGLenum; normalized: TGLboolean; stride: TGLsizei; const _pointer: PGLvoid); overload;
begin
  _glVertexAttribPointerARB(index, size, _type, normalized, stride, _pointer);
end;

procedure glReadPixels(x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei; format: TGLenum; _type: TGLenum; pixels: PGLvoid); overload;
begin
  _glReadPixels(x, y, width, height, format, _type, pixels);
end;

procedure glBufferDataARB(target: TGLenum; size: TGLsizei; const data: PGLvoid; usage: TGLenum);
begin
  _glBufferDataARB(target, size, data, usage);
end;

procedure glBufferSubDataARB(target: TGLenum; offset: TGLsizei; size: TGLsizei; const data: PGLvoid);
begin
  _glBufferSubDataARB(target, offset, size, data);
end;

procedure glBufferData(target: TGLenum; size: TGLsizei; const data: PGLvoid; usage: TGLenum);
begin
  _glBufferData(target, size, data, usage);
end;

procedure glBufferSubData(target: TGLenum; offset: TGLsizei; size: TGLsizei; const data: PGLvoid);
begin
  _glBufferSubData(target, offset, size, data);
end;

function glCreateShaderObjectARB(shaderType: glenum): GLHandleARB; overload;
begin
  result := _glCreateShaderObjectARB(shaderType);
end;

{$IFDEF CLR}

procedure glTexImage2D(target: TGLenum; level: TGLint; internalformat: TGLint; width: TGLsizei; height: TGLsizei; border: TGLint; format: TGLenum; _type: TGLenum; const pixels: System.array); overload;
var
  h: GCHandle;
begin
  h := GCHandle.Alloc(pixels, GCHandleType.Pinned);
  try
    _glTexImage2D(target, level, internalformat, width, height, border, format, _type, h.AddrOfPinnedObject);
  finally
    h.Free;
  end;
end;

procedure glTexImage2D(target: TGLenum; level: TGLint; internalformat: TGLint; border: TGLint; bmp: Bitmap); overload;
var
  data: BitmapData;
begin
  data := bmp.LockBits(Rectangle.Create(0, 0, bmp.Width, bmp.Height), ImageLockMode.ReadOnly, PixelFormat.Format32bppArgb);
  glTexImage2D(target, level, internalformat, bmp.Width, bmp.Height, border, GL_BGRA, GL_UNSIGNED_BYTE, data.Scan0);
  bmp.UnlockBits(data);
end;

procedure glTexImage2D(target: TGLenum; level: TGLint; internalformat: TGLint; border: TGLint; st: Stream); overload;
var
  bmp: Bitmap;
begin
  bmp := Bitmap.Create(st);
  try
    glTexImage2D(target, level, internalformat, border, bmp);
  finally
    bmp.Dispose();
  end;
end;

procedure glTexImage2D(target: TGLenum; level: TGLint; internalformat: TGLint; border: TGLint; filename: string); overload;
var
  bmp: Bitmap;
begin
  bmp := Bitmap.Create(filename);
  try
    glTexImage2D(target, level, internalformat, border, bmp);
  finally
    bmp.Dispose();
  end;
end;

function glGenTextures(n: TGLsizei): PGLuInt; overload;
begin
  SetLength(Result, n);
  glGenTextures(n, Result);
end;

function glGenTexture(): GLuInt; overload;
begin
  Result := glGenTextures(1)[0];
end;

function glGenTexture(bmp: Bitmap): GLuInt; overload;
begin
  Result := glGenTextures(1)[0];
  glBindTexture(GL_TEXTURE_2D, result);
  glEnable(GL_TEXTURE_2D);
  glTexParameteri(gl_texture_2d, GL_GENERATE_MIPMAP_SGIS, GL_TRUE);
  glTexParameteri(gl_texture_2d, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
  glTexParameteri(gl_texture_2d, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA8, 0, bmp);
end;

function glGenTexture(st: Stream): GLuInt; overload;
begin
  Result := glGenTextures(1)[0];
  glBindTexture(GL_TEXTURE_2D, result);
  glEnable(GL_TEXTURE_2D);
  glTexParameteri(gl_texture_2d, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
  glTexParameteri(gl_texture_2d, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexParameteri(gl_texture_2d, GL_GENERATE_MIPMAP_SGIS, GL_TRUE);
  glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA8, 0, st);
end;

function glGenTexture(filename: string): GLuInt; overload;
begin
  Result := glGenTextures(1)[0];
  glBindTexture(GL_TEXTURE_2D, result);
  glEnable(GL_TEXTURE_2D);
  glTexParameteri(gl_texture_2d, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
  glTexParameteri(gl_texture_2d, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexParameteri(gl_texture_2d, GL_GENERATE_MIPMAP_SGIS, GL_TRUE);
  glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA8, 0, filename);
end;

procedure glVertexPointer(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: System.array); overload;
var
  h: GCHandle;
begin
  h := GCHandle.Alloc(_pointer, GCHandleType.Pinned);
  try
    glVertexPointer(size, _type, stride, h.AddrOfPinnedObject);
  finally
    h.Free;
  end;
end;

procedure glColorPointer(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: System.array); overload;
var
  h: GCHandle;
begin
  h := GCHandle.Alloc(_pointer, GCHandleType.Pinned);
  try
    glColorPointer(size, _type, stride, h.AddrOfPinnedObject);
  finally
    h.Free;
  end;
end;

procedure glTexCoordPointer(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: System.array); overload;
var
  h: GCHandle;
begin
  h := GCHandle.Alloc(_pointer, GCHandleType.Pinned);
  try
    glTexCoordPointer(size, _type, stride, h.AddrOfPinnedObject);
  finally
    h.Free;
  end;
end;

procedure glNormalPointer(_type: TGLenum; stride: TGLsizei; const _pointer: System.array); overload;
var
  h: GCHandle;
begin
  h := GCHandle.Alloc(_pointer, GCHandleType.Pinned);
  try
    glNormalPointer(_type, stride, h.AddrOfPinnedObject);
  finally
    h.Free;
  end;
end;

procedure glVertexAttribPointerARB(index: TGLuint; size: TGLint; _type: TGLenum; normalized: TGLboolean; stride: TGLsizei; const _pointer: System.array); overload;
var
  h: GCHandle;
begin
  h := GCHandle.Alloc(_pointer, GCHandleType.Pinned);
  try
    _glVertexAttribPointerARB(index, size, _type, normalized, stride, h.AddrOfPinnedObject);
  finally
    h.Free;
  end;
end;

procedure glVertexPointer(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: Integer); overload;
begin
  glVertexPointer(size, _type, stride, IntPtr.create(_pointer));
end;

procedure glColorPointer(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: Integer); overload;
begin
  glColorPointer(size, _type, stride, IntPtr.create(_pointer));
end;

procedure glTexCoordPointer(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: Integer); overload;
begin
  glTexCoordPointer(size, _type, stride, IntPtr.create(_pointer));
end;

procedure glNormalPointer(_type: TGLenum; stride: TGLsizei; const _pointer: Integer); overload;
begin
  glNormalPointer(_type, stride, IntPtr.Create(_pointer));
end;

procedure glVertexAttribPointerARB(index: TGLuint; size: TGLint; _type: TGLenum; normalized: TGLboolean; stride: TGLsizei; const _pointer: Integer); overload;
begin
  _glVertexAttribPointerARB(index, size, _type, normalized, stride, IntPtr.Create(_pointer));
end;

procedure glReadPixels(x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei; format: TGLenum; _type: TGLenum; pixels: System.array); overload;
var
  h: GCHandle;
begin
  h := GCHandle.Alloc(pixels, GCHandleType.Pinned);
  try
    _glReadPixels(x, y, width, height, format, _type, h.AddrOfPinnedObject);
  finally
    h.Free;
  end;
end;

function glReadPixels(x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei): Bitmap; overload;
var
  data: BitmapData;
begin
  result := Bitmap.Create(width, height);
  data := result.LockBits(Rectangle.Create(0, 0, width, height), ImageLockMode.ReadOnly, PixelFormat.Format32bppArgb);
  try
    glReadPixels(x, y, width, height, GL_BGRA, gl_UNSIGNED_BYTE, data.Scan0);
  finally
    result.UnlockBits(data);
  end;
end;

function glCreateShaderObjectARB(shaderType: glenum; source: string): GLHandleARB; overload;
begin
  result := _glCreateShaderObjectARB(shaderType);
  glShaderSourceARB(result, source);
  glCompileShaderARB(result);
end;

procedure glShaderSourceARB(shaderObj: GLHandleARB; count: glsizei; _string: array of string; lengths: pglint); overload;
begin
  _glShaderSourceARB(shaderObj, count, _string, lengths);
end;

procedure glShaderSourceARB(shaderObj: GLHandleARB; source: string); overload;
var
  l: array[0..0] of Integer;
begin
  l[0] := Length(Source);
  _glShaderSourceARB(shaderObj, 1, [source], l);
end;

procedure glGetInfoLogARB(shaderObj: GLHandleARB; maxLength: glsizei; var length: glint; infoLog: StringBuilder);
begin
  _glGetInfoLogARB(shaderobj, maxlength, length, infoLog);
end;

function glGetInfoLogARB(shaderObj: GLHandleARB): string;
var
  r: StringBuilder;
  l: Integer;
begin
  r := StringBuilder.Create(1024);
  _glGetInfoLogARB(shaderobj, 1024, l, r);
  result := r.ToString;
end;

procedure glGetProgramInfoLog(programObj: GLHandle; maxLength: glsizei; var length: glint; infoLog: StringBuilder);
begin
  _glGetProgramInfoLog(programObj, maxlength, length, infoLog);
end;

function glGetProgramInfoLog(programObj: GLHandleARB): string;
var
  r: StringBuilder;
  l: Integer;
begin
  r := StringBuilder.Create(1024);
  _glGetProgramInfoLog(programObj, 1024, l, r);
  result := r.ToString;
end;

procedure glGetShaderInfoLog(shaderObj: GLHandle; maxLength: glsizei; var length: glint; infoLog: StringBuilder);
begin
  _glGetShaderInfoLog(shaderObj, maxlength, length, infoLog);
end;

function glGetShaderInfoLog(shaderObj: GLHandleARB): string;
var
  r: StringBuilder;
  l: Integer;
begin
  r := StringBuilder.Create(1024);
  _glGetShaderInfoLog(shaderObj, 1024, l, r);
  result := r.ToString;
end;

procedure glShaderSource(shaderObj: GLHandle; count: glsizei; _string: array of string; lengths: pglint); overload;
begin
  _glShaderSource(shaderObj, count, _string, lengths);
end;

procedure glShaderSource(shaderObj: GLHandle; source: string); overload;
var
  l: array[0..0] of Integer;
begin
  l[0] := Length(Source);
  _glShaderSource(shaderObj, 1, [source], l);
end;

procedure glBufferDataARB(target: TGLenum; size: TGLsizei; data: System.array; usage: TGLenum);
var
  h: GCHandle;
begin
  h := GCHandle.Alloc(data, GCHandleType.Pinned);
  try
    _glBufferDataARB(target, size, h.AddrOfPinnedObject, usage);
  finally
    h.Free;
  end;
end;

procedure glBufferSubDataARB(target: TGLenum; offset: TGLsizei; size: TGLsizei; data: System.array);
var
  h: GCHandle;
begin
  h := GCHandle.Alloc(data, GCHandleType.Pinned);
  try
    _glBufferSubDataARB(target, offset, size, h.AddrOfPinnedObject);
  finally
    h.Free;
  end;
end;

procedure glBufferData(target: TGLenum; size: TGLsizei; data: System.array; usage: TGLenum);
var
  h: GCHandle;
begin
  h := GCHandle.Alloc(data, GCHandleType.Pinned);
  try
    _glBufferData(target, size, h.AddrOfPinnedObject, usage);
  finally
    h.Free;
  end;
end;

procedure glBufferSubData(target: TGLenum; offset: TGLsizei; size: TGLsizei; data: System.array);
var
  h: GCHandle;
begin
  h := GCHandle.Alloc(data, GCHandleType.Pinned);
  try
    _glBufferSubData(target, offset, size, h.AddrOfPinnedObject);
  finally
    h.Free;
  end;
end;

{$ELSE}

procedure glShaderSourceARB(shaderObj: GLHandleARB; count: glsizei; _string: PPGLCharARB; lengths: pglint); overload;
begin
  _glShaderSourceARB(shaderObj, count, _string, lengths);
end;

procedure glGetInfoLogARB(shaderObj: GLHandleARB; maxLength: glsizei; var length: glint; infoLog: PChar);
begin
  _glGetInfoLogARB(shaderobj, maxlength, length, infoLog);
end;

procedure glGetProgramInfoLog(programObj: GLHandle; maxLength: glsizei; var length: glint; infoLog: PChar);
begin
  _glGetProgramInfoLog(programObj, maxlength, length, infoLog);
end;

procedure glGetShaderInfoLog(shaderObj: GLHandle; maxLength: glsizei; var length: glint; infoLog: PChar);
begin
  _glGetShaderInfoLog(shaderObj, maxlength, length, infoLog);
end;

procedure glShaderSource(shaderObj: GLHandle; count: glsizei; _string: PPGLChar; lengths: pglint); overload;
begin
  _glShaderSource(shaderObj, count, _string, lengths);
end;
{$ENDIF}

function InitOpenGL(LibName: string; GLULibName: string): Boolean;
begin
  Result := False;
  if LibHandle <> 0 then
    FreeLibrary(LibHandle);
  if GLULibHandle <> 0 then
    FreeLibrary(GLULibHandle);
{$IFDEF CLR}
  LibHandle := LoadLibrary(LibName);
  GLULibHandle := LoadLibrary(GLULibName);
  wglGetProcAddressEx := TwglGetProcAddress(GetProcAddress(LibHandle, 'wglGetProcAddress', typeof(TwglGetProcAddress)));
{$ELSE}

  LibHandle := LoadLibrary(PChar(LibName));
  GLULibHandle := LoadLibrary(PChar(GLULibName));

{$IFDEF Win32}
  // Changed by bero
  wglGetProcAddress := GetProcAddress(LibHandle, 'wglGetProcAddress');
{$ENDIF}
{$ENDIF}
  if (LibHandle <> 0) then
  begin
    _glGetString := TglGetString(glProcedure('glGetString'{$IFDEF CLR}, typeof(TglGetString){$ENDIF}));

    // window support routines (WGL) ==============================================
{$IFDEF Win32CLR}
    // Changed by bero
    wglCopyContext := TwglCopyContext(glProcedure('wglCopyContext'{$IFDEF CLR}, typeof(TwglCopyContext){$ENDIF}));
    wglCreateLayerContext := TwglCreateLayerContext(glProcedure('wglCreateLayerContext'{$IFDEF CLR}, typeof(TwglCreateLayerContext){$ENDIF}));
    wglCreateContext := TwglCreateContext(glProcedure('wglCreateContext'{$IFDEF CLR}, typeof(TwglCreateContext){$ENDIF}));
    wglDeleteContext := TwglDeleteContext(glProcedure('wglDeleteContext'{$IFDEF CLR}, typeof(TwglDeleteContext){$ENDIF}));
    wglDescribeLayerPlane := TwglDescribeLayerPlane(glProcedure('wglDescribeLayerPlane'{$IFDEF CLR}, typeof(TwglDescribeLayerPlane){$ENDIF}));
    wglGetCurrentContext := TwglGetCurrentContext(glProcedure('wglGetCurrentContext'{$IFDEF CLR}, typeof(TwglGetCurrentContext){$ENDIF}));
    wglGetCurrentDC := TwglGetCurrentDC(glProcedure('wglGetCurrentDC'{$IFDEF CLR}, typeof(TwglGetCurrentDC){$ENDIF}));
    wglGetLayerPaletteEntries := TwglGetLayerPaletteEntries(glProcedure('wglGetLayerPaletteEntries'{$IFDEF CLR}, typeof(TwglGetLayerPaletteEntries){$ENDIF}));
    wglMakeCurrent := TwglMakeCurrent(glProcedure('wglMakeCurrent'{$IFDEF CLR}, typeof(TwglMakeCurrent){$ENDIF}));
    wglRealizeLayerPalette := TwglRealizeLayerPalette(glProcedure('wglRealizeLayerPalette'{$IFDEF CLR}, typeof(TwglRealizeLayerPalette){$ENDIF}));
    wglSetLayerPaletteEntries := TwglSetLayerPaletteEntries(glProcedure('wglSetLayerPaletteEntries'{$IFDEF CLR}, typeof(TwglSetLayerPaletteEntries){$ENDIF}));
    wglShareLists := TwglShareLists(glProcedure('wglShareLists'{$IFDEF CLR}, typeof(TwglShareLists){$ENDIF}));
    wglSwapLayerBuffers := TwglSwapLayerBuffers(glProcedure('wglSwapLayerBuffers'{$IFDEF CLR}, typeof(TwglSwapLayerBuffers){$ENDIF}));
    wglSwapMultipleBuffers := TwglSwapMultipleBuffers(glProcedure('wglSwapMultipleBuffers'{$IFDEF CLR}, typeof(TwglSwapMultipleBuffers){$ENDIF}));
    _wglGetExtensionsStringEXT := TwglGetExtensionsStringEXT(glProcedure('wglGetExtensionsStringEXT'{$IFDEF CLR}, typeof(TwglGetExtensionsStringEXT){$ENDIF}));
{$IFDEF CLR}
    wglUseFontBitmapsA := nil;
    wglUseFontOutlinesA := nil;
{$ELSE}
    wglUseFontBitmapsA := TwglUseFontBitmapsA(glProcedure('wglUseFontBitmapsA'{$IFDEF CLR}, typeof(TwglUseFontBitmapsA){$ENDIF}));
    wglUseFontOutlinesA := TwglUseFontOutlinesA(glProcedure('wglUseFontOutlinesA'{$IFDEF CLR}, typeof(TwglUseFontOutlinesA){$ENDIF}));
{$ENDIF}
    wglUseFontBitmapsW := TwglUseFontBitmapsW(glProcedure('wglUseFontBitmapsW'{$IFDEF CLR}, typeof(TwglUseFontBitmapsW){$ENDIF}));
    wglUseFontOutlinesW := TwglUseFontOutlinesW(glProcedure('wglUseFontOutlinesW'{$IFDEF CLR}, typeof(TwglUseFontOutlinesW){$ENDIF}));
    wglUseFontBitmaps := TwglUseFontBitmaps(glProcedure('wglUseFontBitmapsA'{$IFDEF CLR}, typeof(TwglUseFontBitmapsA){$ENDIF}));
    wglUseFontOutlines := TwglUseFontOutlines(glProcedure('wglUseFontOutlinesA'{$IFDEF CLR}, typeof(TwglUseFontOutlinesA){$ENDIF}));
{$ENDIF}
    Result := True;
  end;

  if GLULibHandle <> 0 then
  begin
    // GLU ========================================================================
    gluBeginCurve := TgluBeginCurve(GetProcAddress(GLULibHandle, 'gluBeginCurve'{$IFDEF CLR}, typeof(TgluBeginCurve){$ENDIF}));
    gluBeginPolygon := TgluBeginPolygon(GetProcAddress(GLULibHandle, 'gluBeginPolygon'{$IFDEF CLR}, typeof(TgluBeginPolygon){$ENDIF}));
    gluBeginSurface := TgluBeginSurface(GetProcAddress(GLULibHandle, 'gluBeginSurface'{$IFDEF CLR}, typeof(TgluBeginSurface){$ENDIF}));
    gluBeginTrim := TgluBeginTrim(GetProcAddress(GLULibHandle, 'gluBeginTrim'{$IFDEF CLR}, typeof(TgluBeginTrim){$ENDIF}));
    gluBuild1DMipmaps := TgluBuild1DMipmaps(GetProcAddress(GLULibHandle, 'gluBuild1DMipmaps'{$IFDEF CLR}, typeof(TgluBuild1DMipmaps){$ENDIF}));
    gluBuild2DMipmaps := TgluBuild2DMipmaps(GetProcAddress(GLULibHandle, 'gluBuild2DMipmaps'{$IFDEF CLR}, typeof(TgluBuild2DMipmaps){$ENDIF}));
    gluCylinder := TgluCylinder(GetProcAddress(GLULibHandle, 'gluCylinder'{$IFDEF CLR}, typeof(TgluCylinder){$ENDIF}));
    gluDeleteNurbsRenderer := TgluDeleteNurbsRenderer(GetProcAddress(GLULibHandle, 'gluDeleteNurbsRenderer'{$IFDEF CLR}, typeof(TgluDeleteNurbsRenderer){$ENDIF}));
    gluDeleteQuadric := TgluDeleteQuadric(GetProcAddress(GLULibHandle, 'gluDeleteQuadric'{$IFDEF CLR}, typeof(TgluDeleteQuadric){$ENDIF}));
    gluDeleteTess := TgluDeleteTess(GetProcAddress(GLULibHandle, 'gluDeleteTess'{$IFDEF CLR}, typeof(TgluDeleteTess){$ENDIF}));
    gluDisk := TgluDisk(GetProcAddress(GLULibHandle, 'gluDisk'{$IFDEF CLR}, typeof(TgluDisk){$ENDIF}));
    gluEndCurve := TgluEndCurve(GetProcAddress(GLULibHandle, 'gluEndCurve'{$IFDEF CLR}, typeof(TgluEndCurve){$ENDIF}));
    gluEndPolygon := TgluEndPolygon(GetProcAddress(GLULibHandle, 'gluEndPolygon'{$IFDEF CLR}, typeof(TgluEndPolygon){$ENDIF}));
    gluEndSurface := TgluEndSurface(GetProcAddress(GLULibHandle, 'gluEndSurface'{$IFDEF CLR}, typeof(TgluEndSurface){$ENDIF}));
    gluEndTrim := TgluEndTrim(GetProcAddress(GLULibHandle, 'gluEndTrim'{$IFDEF CLR}, typeof(TgluEndTrim){$ENDIF}));
    gluErrorString := TgluErrorString(GetProcAddress(GLULibHandle, 'gluErrorString'{$IFDEF CLR}, typeof(TgluErrorString){$ENDIF}));
    gluGetNurbsProperty := TgluGetNurbsProperty(GetProcAddress(GLULibHandle, 'gluGetNurbsProperty'{$IFDEF CLR}, typeof(TgluGetNurbsProperty){$ENDIF}));
    _gluGetString := TgluGetString(GetProcAddress(GLULibHandle, 'gluGetString'{$IFDEF CLR}, typeof(TgluGetString){$ENDIF}));
    gluGetTessProperty := TgluGetTessProperty(GetProcAddress(GLULibHandle, 'gluGetTessProperty'{$IFDEF CLR}, typeof(TgluGetTessProperty){$ENDIF}));
    gluLoadSamplingMatrices := TgluLoadSamplingMatrices(GetProcAddress(GLULibHandle, 'gluLoadSamplingMatrices'{$IFDEF CLR}, typeof(TgluLoadSamplingMatrices){$ENDIF}));
    gluLookAt := TgluLookAt(GetProcAddress(GLULibHandle, 'gluLookAt'{$IFDEF CLR}, typeof(TgluLookAt){$ENDIF}));
    gluNewNurbsRenderer := TgluNewNurbsRenderer(GetProcAddress(GLULibHandle, 'gluNewNurbsRenderer'{$IFDEF CLR}, typeof(TgluNewNurbsRenderer){$ENDIF}));
    gluNewQuadric := TgluNewQuadric(GetProcAddress(GLULibHandle, 'gluNewQuadric'{$IFDEF CLR}, typeof(TgluNewQuadric){$ENDIF}));
    gluNewTess := TgluNewTess(GetProcAddress(GLULibHandle, 'gluNewTess'{$IFDEF CLR}, typeof(TgluNewTess){$ENDIF}));
    gluNextContour := TgluNextContour(GetProcAddress(GLULibHandle, 'gluNextContour'{$IFDEF CLR}, typeof(TgluNextContour){$ENDIF}));
    gluNurbsCallback := TgluNurbsCallback(GetProcAddress(GLULibHandle, 'gluNurbsCallback'{$IFDEF CLR}, typeof(TgluNurbsCallback){$ENDIF}));
    gluNurbsCurve := TgluNurbsCurve(GetProcAddress(GLULibHandle, 'gluNurbsCurve'{$IFDEF CLR}, typeof(TgluNurbsCurve){$ENDIF}));
    gluNurbsProperty := TgluNurbsProperty(GetProcAddress(GLULibHandle, 'gluNurbsProperty'{$IFDEF CLR}, typeof(TgluNurbsProperty){$ENDIF}));
    gluNurbsSurface := TgluNurbsSurface(GetProcAddress(GLULibHandle, 'gluNurbsSurface'{$IFDEF CLR}, typeof(TgluNurbsSurface){$ENDIF}));
    gluOrtho2D := TgluOrtho2D(GetProcAddress(GLULibHandle, 'gluOrtho2D'{$IFDEF CLR}, typeof(TgluOrtho2D){$ENDIF}));
    gluPartialDisk := TgluPartialDisk(GetProcAddress(GLULibHandle, 'gluPartialDisk'{$IFDEF CLR}, typeof(TgluPartialDisk){$ENDIF}));
    gluPerspective := TgluPerspective(GetProcAddress(GLULibHandle, 'gluPerspective'{$IFDEF CLR}, typeof(TgluPerspective){$ENDIF}));
    gluPickMatrix := TgluPickMatrix(GetProcAddress(GLULibHandle, 'gluPickMatrix'{$IFDEF CLR}, typeof(TgluPickMatrix){$ENDIF}));
    gluProject := TgluProject(GetProcAddress(GLULibHandle, 'gluProject'{$IFDEF CLR}, typeof(TgluProject){$ENDIF}));
    gluPwlCurve := TgluPwlCurve(GetProcAddress(GLULibHandle, 'gluPwlCurve'{$IFDEF CLR}, typeof(TgluPwlCurve){$ENDIF}));
    gluQuadricCallback := TgluQuadricCallback(GetProcAddress(GLULibHandle, 'gluQuadricCallback'{$IFDEF CLR}, typeof(TgluQuadricCallback){$ENDIF}));
    gluQuadricDrawStyle := TgluQuadricDrawStyle(GetProcAddress(GLULibHandle, 'gluQuadricDrawStyle'{$IFDEF CLR}, typeof(TgluQuadricDrawStyle){$ENDIF}));
    gluQuadricNormals := TgluQuadricNormals(GetProcAddress(GLULibHandle, 'gluQuadricNormals'{$IFDEF CLR}, typeof(TgluQuadricNormals){$ENDIF}));
    gluQuadricOrientation := TgluQuadricOrientation(GetProcAddress(GLULibHandle, 'gluQuadricOrientation'{$IFDEF CLR}, typeof(TgluQuadricOrientation){$ENDIF}));
    gluQuadricTexture := TgluQuadricTexture(GetProcAddress(GLULibHandle, 'gluQuadricTexture'{$IFDEF CLR}, typeof(TgluQuadricTexture){$ENDIF}));
    gluScaleImage := TgluScaleImage(GetProcAddress(GLULibHandle, 'gluScaleImage'{$IFDEF CLR}, typeof(TgluScaleImage){$ENDIF}));
    gluSphere := TgluSphere(GetProcAddress(GLULibHandle, 'gluSphere'{$IFDEF CLR}, typeof(TgluSphere){$ENDIF}));
    gluTessBeginContour := TgluTessBeginContour(GetProcAddress(GLULibHandle, 'gluTessBeginContour'{$IFDEF CLR}, typeof(TgluTessBeginContour){$ENDIF}));
    gluTessBeginPolygon := TgluTessBeginPolygon(GetProcAddress(GLULibHandle, 'gluTessBeginPolygon'{$IFDEF CLR}, typeof(TgluTessBeginPolygon){$ENDIF}));
    gluTessCallback := TgluTessCallback(GetProcAddress(GLULibHandle, 'gluTessCallback'{$IFDEF CLR}, typeof(TgluTessCallback){$ENDIF}));
    gluTessEndContour := TgluTessEndContour(GetProcAddress(GLULibHandle, 'gluTessEndContour'{$IFDEF CLR}, typeof(TgluTessEndContour){$ENDIF}));
    gluTessEndPolygon := TgluTessEndPolygon(GetProcAddress(GLULibHandle, 'gluTessEndPolygon'{$IFDEF CLR}, typeof(TgluTessEndPolygon){$ENDIF}));
    gluTessNormal := TgluTessNormal(GetProcAddress(GLULibHandle, 'gluTessNormal'{$IFDEF CLR}, typeof(TgluTessNormal){$ENDIF}));
    gluTessProperty := TgluTessProperty(GetProcAddress(GLULibHandle, 'gluTessProperty'{$IFDEF CLR}, typeof(TgluTessProperty){$ENDIF}));
    gluTessVertex := TgluTessVertex(GetProcAddress(GLULibHandle, 'gluTessVertex'{$IFDEF CLR}, typeof(TgluTessVertex){$ENDIF}));
    gluUnProject := TgluUnProject(GetProcAddress(GLULibHandle, 'gluUnProject'{$IFDEF CLR}, typeof(TgluUnProject){$ENDIF}));
  end;
end;

procedure ReadOpenGLCore;
begin
  if LibHandle = 0 then
    exit;

  // GL_VERSION_1_1
  glAccum := TglAccum(glProcedure('glAccum'{$IFDEF CLR}, typeof(TglAccum){$ENDIF}));
  glAlphaFunc := TglAlphaFunc(glProcedure('glAlphaFunc'{$IFDEF CLR}, typeof(TglAlphaFunc){$ENDIF}));
  glAreTexturesResident := TglAreTexturesResident(glProcedure('glAreTexturesResident'{$IFDEF CLR}, typeof(TglAreTexturesResident){$ENDIF}));
  glArrayElement := TglArrayElement(glProcedure('glArrayElement'{$IFDEF CLR}, typeof(TglArrayElement){$ENDIF}));
  glBegin := TglBegin(glProcedure('glBegin'{$IFDEF CLR}, typeof(TglBegin){$ENDIF}));
  glBindTexture := TglBindTexture(glProcedure('glBindTexture'{$IFDEF CLR}, typeof(TglBindTexture){$ENDIF}));
  glBitmap := TglBitmap(glProcedure('glBitmap'{$IFDEF CLR}, typeof(TglBitmap){$ENDIF}));
  glBlendFunc := TglBlendFunc(glProcedure('glBlendFunc'{$IFDEF CLR}, typeof(TglBlendFunc){$ENDIF}));
  glCallList := TglCallList(glProcedure('glCallList'{$IFDEF CLR}, typeof(TglCallList){$ENDIF}));
  glCallLists := TglCallLists(glProcedure('glCallLists'{$IFDEF CLR}, typeof(TglCallLists){$ENDIF}));
  glClear := TglClear(glProcedure('glClear'{$IFDEF CLR}, typeof(TglClear){$ENDIF}));
  glClearAccum := TglClearAccum(glProcedure('glClearAccum'{$IFDEF CLR}, typeof(TglClearAccum){$ENDIF}));
  glClearColor := TglClearColor(glProcedure('glClearColor'{$IFDEF CLR}, typeof(TglClearColor){$ENDIF}));
  glClearDepth := TglClearDepth(glProcedure('glClearDepth'{$IFDEF CLR}, typeof(TglClearDepth){$ENDIF}));
  glClearIndex := TglClearIndex(glProcedure('glClearIndex'{$IFDEF CLR}, typeof(TglClearIndex){$ENDIF}));
  glClearStencil := TglClearStencil(glProcedure('glClearStencil'{$IFDEF CLR}, typeof(TglClearStencil){$ENDIF}));
  glClipPlane := TglClipPlane(glProcedure('glClipPlane'{$IFDEF CLR}, typeof(TglClipPlane){$ENDIF}));
  glColor3b := TglColor3b(glProcedure('glColor3b'{$IFDEF CLR}, typeof(TglColor3b){$ENDIF}));
  glColor3bv := TglColor3bv(glProcedure('glColor3bv'{$IFDEF CLR}, typeof(TglColor3bv){$ENDIF}));
  glColor3d := TglColor3d(glProcedure('glColor3d'{$IFDEF CLR}, typeof(TglColor3d){$ENDIF}));
  glColor3dv := TglColor3dv(glProcedure('glColor3dv'{$IFDEF CLR}, typeof(TglColor3dv){$ENDIF}));
  glColor3f := TglColor3f(glProcedure('glColor3f'{$IFDEF CLR}, typeof(TglColor3f){$ENDIF}));
  glColor3fv := TglColor3fv(glProcedure('glColor3fv'{$IFDEF CLR}, typeof(TglColor3fv){$ENDIF}));
  glColor3i := TglColor3i(glProcedure('glColor3i'{$IFDEF CLR}, typeof(TglColor3i){$ENDIF}));
  glColor3iv := TglColor3iv(glProcedure('glColor3iv'{$IFDEF CLR}, typeof(TglColor3iv){$ENDIF}));
  glColor3s := TglColor3s(glProcedure('glColor3s'{$IFDEF CLR}, typeof(TglColor3s){$ENDIF}));
  glColor3sv := TglColor3sv(glProcedure('glColor3sv'{$IFDEF CLR}, typeof(TglColor3sv){$ENDIF}));
  glColor3ub := TglColor3ub(glProcedure('glColor3ub'{$IFDEF CLR}, typeof(TglColor3ub){$ENDIF}));
  glColor3ubv := TglColor3ubv(glProcedure('glColor3ubv'{$IFDEF CLR}, typeof(TglColor3ubv){$ENDIF}));
  glColor3ui := TglColor3ui(glProcedure('glColor3ui'{$IFDEF CLR}, typeof(TglColor3ui){$ENDIF}));
  glColor3uiv := TglColor3uiv(glProcedure('glColor3uiv'{$IFDEF CLR}, typeof(TglColor3uiv){$ENDIF}));
  glColor3us := TglColor3us(glProcedure('glColor3us'{$IFDEF CLR}, typeof(TglColor3us){$ENDIF}));
  glColor3usv := TglColor3usv(glProcedure('glColor3usv'{$IFDEF CLR}, typeof(TglColor3usv){$ENDIF}));
  glColor4b := TglColor4b(glProcedure('glColor4b'{$IFDEF CLR}, typeof(TglColor4b){$ENDIF}));
  glColor4bv := TglColor4bv(glProcedure('glColor4bv'{$IFDEF CLR}, typeof(TglColor4bv){$ENDIF}));
  glColor4d := TglColor4d(glProcedure('glColor4d'{$IFDEF CLR}, typeof(TglColor4d){$ENDIF}));
  glColor4dv := TglColor4dv(glProcedure('glColor4dv'{$IFDEF CLR}, typeof(TglColor4dv){$ENDIF}));
  glColor4f := TglColor4f(glProcedure('glColor4f'{$IFDEF CLR}, typeof(TglColor4f){$ENDIF}));
  glColor4fv := TglColor4fv(glProcedure('glColor4fv'{$IFDEF CLR}, typeof(TglColor4fv){$ENDIF}));
  glColor4i := TglColor4i(glProcedure('glColor4i'{$IFDEF CLR}, typeof(TglColor4i){$ENDIF}));
  glColor4iv := TglColor4iv(glProcedure('glColor4iv'{$IFDEF CLR}, typeof(TglColor4iv){$ENDIF}));
  glColor4s := TglColor4s(glProcedure('glColor4s'{$IFDEF CLR}, typeof(TglColor4s){$ENDIF}));
  glColor4sv := TglColor4sv(glProcedure('glColor4sv'{$IFDEF CLR}, typeof(TglColor4sv){$ENDIF}));
  glColor4ub := TglColor4ub(glProcedure('glColor4ub'{$IFDEF CLR}, typeof(TglColor4ub){$ENDIF}));
  glColor4ubv := TglColor4ubv(glProcedure('glColor4ubv'{$IFDEF CLR}, typeof(TglColor4ubv){$ENDIF}));
  glColor4ui := TglColor4ui(glProcedure('glColor4ui'{$IFDEF CLR}, typeof(TglColor4ui){$ENDIF}));
  glColor4uiv := TglColor4uiv(glProcedure('glColor4uiv'{$IFDEF CLR}, typeof(TglColor4uiv){$ENDIF}));
  glColor4us := TglColor4us(glProcedure('glColor4us'{$IFDEF CLR}, typeof(TglColor4us){$ENDIF}));
  glColor4usv := TglColor4usv(glProcedure('glColor4usv'{$IFDEF CLR}, typeof(TglColor4usv){$ENDIF}));
  glColorMask := TglColorMask(glProcedure('glColorMask'{$IFDEF CLR}, typeof(TglColorMask){$ENDIF}));
  glColorMaterial := TglColorMaterial(glProcedure('glColorMaterial'{$IFDEF CLR}, typeof(TglColorMaterial){$ENDIF}));
  _glColorPointer := TglColorPointer(glProcedure('glColorPointer'{$IFDEF CLR}, typeof(TglColorPointer){$ENDIF}));
  glCopyPixels := TglCopyPixels(glProcedure('glCopyPixels'{$IFDEF CLR}, typeof(TglCopyPixels){$ENDIF}));
  glCopyTexImage1D := TglCopyTexImage1D(glProcedure('glCopyTexImage1D'{$IFDEF CLR}, typeof(TglCopyTexImage1D){$ENDIF}));
  glCopyTexImage2D := TglCopyTexImage2D(glProcedure('glCopyTexImage2D'{$IFDEF CLR}, typeof(TglCopyTexImage2D){$ENDIF}));
  glCopyTexSubImage1D := TglCopyTexSubImage1D(glProcedure('glCopyTexSubImage1D'{$IFDEF CLR}, typeof(TglCopyTexSubImage1D){$ENDIF}));
  glCopyTexSubImage2D := TglCopyTexSubImage2D(glProcedure('glCopyTexSubImage2D'{$IFDEF CLR}, typeof(TglCopyTexSubImage2D){$ENDIF}));
  glCullFace := TglCullFace(glProcedure('glCullFace'{$IFDEF CLR}, typeof(TglCullFace){$ENDIF}));
  glDeleteLists := TglDeleteLists(glProcedure('glDeleteLists'{$IFDEF CLR}, typeof(TglDeleteLists){$ENDIF}));
  glDeleteTextures := TglDeleteTextures(glProcedure('glDeleteTextures'{$IFDEF CLR}, typeof(TglDeleteTextures){$ENDIF}));
  glDepthFunc := TglDepthFunc(glProcedure('glDepthFunc'{$IFDEF CLR}, typeof(TglDepthFunc){$ENDIF}));
  glDepthMask := TglDepthMask(glProcedure('glDepthMask'{$IFDEF CLR}, typeof(TglDepthMask){$ENDIF}));
  glDepthRange := TglDepthRange(glProcedure('glDepthRange'{$IFDEF CLR}, typeof(TglDepthRange){$ENDIF}));
  glDisable := TglDisable(glProcedure('glDisable'{$IFDEF CLR}, typeof(TglDisable){$ENDIF}));
  glDisableClientState := TglDisableClientState(glProcedure('glDisableClientState'{$IFDEF CLR}, typeof(TglDisableClientState){$ENDIF}));
  glDrawArrays := TglDrawArrays(glProcedure('glDrawArrays'{$IFDEF CLR}, typeof(TglDrawArrays){$ENDIF}));
  glDrawBuffer := TglDrawBuffer(glProcedure('glDrawBuffer'{$IFDEF CLR}, typeof(TglDrawBuffer){$ENDIF}));
  glDrawElements := TglDrawElements(glProcedure('glDrawElements'{$IFDEF CLR}, typeof(TglDrawElements){$ENDIF}));
  glDrawPixels := TglDrawPixels(glProcedure('glDrawPixels'{$IFDEF CLR}, typeof(TglDrawPixels){$ENDIF}));
  glEdgeFlag := TglEdgeFlag(glProcedure('glEdgeFlag'{$IFDEF CLR}, typeof(TglEdgeFlag){$ENDIF}));
  glEdgeFlagPointer := TglEdgeFlagPointer(glProcedure('glEdgeFlagPointer'{$IFDEF CLR}, typeof(TglEdgeFlagPointer){$ENDIF}));
  glEdgeFlagv := TglEdgeFlagv(glProcedure('glEdgeFlagv'{$IFDEF CLR}, typeof(TglEdgeFlagv){$ENDIF}));
  glEnable := TglEnable(glProcedure('glEnable'{$IFDEF CLR}, typeof(TglEnable){$ENDIF}));
  glEnableClientState := TglEnableClientState(glProcedure('glEnableClientState'{$IFDEF CLR}, typeof(TglEnableClientState){$ENDIF}));
  glEnd := TglEnd(glProcedure('glEnd'{$IFDEF CLR}, typeof(TglEnd){$ENDIF}));
  glEndList := TglEndList(glProcedure('glEndList'{$IFDEF CLR}, typeof(TglEndList){$ENDIF}));
  glEvalCoord1d := TglEvalCoord1d(glProcedure('glEvalCoord1d'{$IFDEF CLR}, typeof(TglEvalCoord1d){$ENDIF}));
  glEvalCoord1dv := TglEvalCoord1dv(glProcedure('glEvalCoord1dv'{$IFDEF CLR}, typeof(TglEvalCoord1dv){$ENDIF}));
  glEvalCoord1f := TglEvalCoord1f(glProcedure('glEvalCoord1f'{$IFDEF CLR}, typeof(TglEvalCoord1f){$ENDIF}));
  glEvalCoord1fv := TglEvalCoord1fv(glProcedure('glEvalCoord1fv'{$IFDEF CLR}, typeof(TglEvalCoord1fv){$ENDIF}));
  glEvalCoord2d := TglEvalCoord2d(glProcedure('glEvalCoord2d'{$IFDEF CLR}, typeof(TglEvalCoord2d){$ENDIF}));
  glEvalCoord2dv := TglEvalCoord2dv(glProcedure('glEvalCoord2dv'{$IFDEF CLR}, typeof(TglEvalCoord2dv){$ENDIF}));
  glEvalCoord2f := TglEvalCoord2f(glProcedure('glEvalCoord2f'{$IFDEF CLR}, typeof(TglEvalCoord2f){$ENDIF}));
  glEvalCoord2fv := TglEvalCoord2fv(glProcedure('glEvalCoord2fv'{$IFDEF CLR}, typeof(TglEvalCoord2fv){$ENDIF}));
  glEvalMesh1 := TglEvalMesh1(glProcedure('glEvalMesh1'{$IFDEF CLR}, typeof(TglEvalMesh1){$ENDIF}));
  glEvalMesh2 := TglEvalMesh2(glProcedure('glEvalMesh2'{$IFDEF CLR}, typeof(TglEvalMesh2){$ENDIF}));
  glEvalPoint1 := TglEvalPoint1(glProcedure('glEvalPoint1'{$IFDEF CLR}, typeof(TglEvalPoint1){$ENDIF}));
  glEvalPoint2 := TglEvalPoint2(glProcedure('glEvalPoint2'{$IFDEF CLR}, typeof(TglEvalPoint2){$ENDIF}));
  glFeedbackBuffer := TglFeedbackBuffer(glProcedure('glFeedbackBuffer'{$IFDEF CLR}, typeof(TglFeedbackBuffer){$ENDIF}));
  glFinish := TglFinish(glProcedure('glFinish'{$IFDEF CLR}, typeof(TglFinish){$ENDIF}));
  glFlush := TglFlush(glProcedure('glFlush'{$IFDEF CLR}, typeof(TglFlush){$ENDIF}));
  glFogf := TglFogf(glProcedure('glFogf'{$IFDEF CLR}, typeof(TglFogf){$ENDIF}));
  glFogfv := TglFogfv(glProcedure('glFogfv'{$IFDEF CLR}, typeof(TglFogfv){$ENDIF}));
  glFogi := TglFogi(glProcedure('glFogi'{$IFDEF CLR}, typeof(TglFogi){$ENDIF}));
  glFogiv := TglFogiv(glProcedure('glFogiv'{$IFDEF CLR}, typeof(TglFogiv){$ENDIF}));
  glFrontFace := TglFrontFace(glProcedure('glFrontFace'{$IFDEF CLR}, typeof(TglFrontFace){$ENDIF}));
  glFrustum := TglFrustum(glProcedure('glFrustum'{$IFDEF CLR}, typeof(TglFrustum){$ENDIF}));
  glGenLists := TglGenLists(glProcedure('glGenLists'{$IFDEF CLR}, typeof(TglGenLists){$ENDIF}));
  _glGenTextures := TglGenTextures(glProcedure('glGenTextures'{$IFDEF CLR}, typeof(TglGenTextures){$ENDIF}));
  glGetBooleanv := TglGetBooleanv(glProcedure('glGetBooleanv'{$IFDEF CLR}, typeof(TglGetBooleanv){$ENDIF}));
  glGetClipPlane := TglGetClipPlane(glProcedure('glGetClipPlane'{$IFDEF CLR}, typeof(TglGetClipPlane){$ENDIF}));
  glGetDoublev := TglGetDoublev(glProcedure('glGetDoublev'{$IFDEF CLR}, typeof(TglGetDoublev){$ENDIF}));
  glGetError := TglGetError(glProcedure('glGetError'{$IFDEF CLR}, typeof(TglGetError){$ENDIF}));
  glGetFloatv := TglGetFloatv(glProcedure('glGetFloatv'{$IFDEF CLR}, typeof(TglGetFloatv){$ENDIF}));
  glGetIntegerv := TglGetIntegerv(glProcedure('glGetIntegerv'{$IFDEF CLR}, typeof(TglGetIntegerv){$ENDIF}));
  glGetLightfv := TglGetLightfv(glProcedure('glGetLightfv'{$IFDEF CLR}, typeof(TglGetLightfv){$ENDIF}));
  glGetLightiv := TglGetLightiv(glProcedure('glGetLightiv'{$IFDEF CLR}, typeof(TglGetLightiv){$ENDIF}));
  glGetMapdv := TglGetMapdv(glProcedure('glGetMapdv'{$IFDEF CLR}, typeof(TglGetMapdv){$ENDIF}));
  glGetMapfv := TglGetMapfv(glProcedure('glGetMapfv'{$IFDEF CLR}, typeof(TglGetMapfv){$ENDIF}));
  glGetMapiv := TglGetMapiv(glProcedure('glGetMapiv'{$IFDEF CLR}, typeof(TglGetMapiv){$ENDIF}));
  glGetMaterialfv := TglGetMaterialfv(glProcedure('glGetMaterialfv'{$IFDEF CLR}, typeof(TglGetMaterialfv){$ENDIF}));
  glGetMaterialiv := TglGetMaterialiv(glProcedure('glGetMaterialiv'{$IFDEF CLR}, typeof(TglGetMaterialiv){$ENDIF}));
  glGetPixelMapfv := TglGetPixelMapfv(glProcedure('glGetPixelMapfv'{$IFDEF CLR}, typeof(TglGetPixelMapfv){$ENDIF}));
  glGetPixelMapuiv := TglGetPixelMapuiv(glProcedure('glGetPixelMapuiv'{$IFDEF CLR}, typeof(TglGetPixelMapuiv){$ENDIF}));
  glGetPixelMapusv := TglGetPixelMapusv(glProcedure('glGetPixelMapusv'{$IFDEF CLR}, typeof(TglGetPixelMapusv){$ENDIF}));
  glGetPointerv := TglGetPointerv(glProcedure('glGetPointerv'{$IFDEF CLR}, typeof(TglGetPointerv){$ENDIF}));
  glGetPolygonStipple := TglGetPolygonStipple(glProcedure('glGetPolygonStipple'{$IFDEF CLR}, typeof(TglGetPolygonStipple){$ENDIF}));
  glGetTexEnvfv := TglGetTexEnvfv(glProcedure('glGetTexEnvfv'{$IFDEF CLR}, typeof(TglGetTexEnvfv){$ENDIF}));
  glGetTexEnviv := TglGetTexEnviv(glProcedure('glGetTexEnviv'{$IFDEF CLR}, typeof(TglGetTexEnviv){$ENDIF}));
  glGetTexGendv := TglGetTexGendv(glProcedure('glGetTexGendv'{$IFDEF CLR}, typeof(TglGetTexGendv){$ENDIF}));
  glGetTexGenfv := TglGetTexGenfv(glProcedure('glGetTexGenfv'{$IFDEF CLR}, typeof(TglGetTexGenfv){$ENDIF}));
  glGetTexGeniv := TglGetTexGeniv(glProcedure('glGetTexGeniv'{$IFDEF CLR}, typeof(TglGetTexGeniv){$ENDIF}));
  glGetTexImage := TglGetTexImage(glProcedure('glGetTexImage'{$IFDEF CLR}, typeof(TglGetTexImage){$ENDIF}));
  glGetTexLevelParameterfv := TglGetTexLevelParameterfv(glProcedure('glGetTexLevelParameterfv'{$IFDEF CLR}, typeof(TglGetTexLevelParameterfv){$ENDIF}));
  glGetTexLevelParameteriv := TglGetTexLevelParameteriv(glProcedure('glGetTexLevelParameteriv'{$IFDEF CLR}, typeof(TglGetTexLevelParameteriv){$ENDIF}));
  glGetTexParameterfv := TglGetTexParameterfv(glProcedure('glGetTexParameterfv'{$IFDEF CLR}, typeof(TglGetTexParameterfv){$ENDIF}));
  glGetTexParameteriv := TglGetTexParameteriv(glProcedure('glGetTexParameteriv'{$IFDEF CLR}, typeof(TglGetTexParameteriv){$ENDIF}));
  glHint := TglHint(glProcedure('glHint'{$IFDEF CLR}, typeof(TglHint){$ENDIF}));
  glIndexMask := TglIndexMask(glProcedure('glIndexMask'{$IFDEF CLR}, typeof(TglIndexMask){$ENDIF}));
  glIndexPointer := TglIndexPointer(glProcedure('glIndexPointer'{$IFDEF CLR}, typeof(TglIndexPointer){$ENDIF}));
  glIndexd := TglIndexd(glProcedure('glIndexd'{$IFDEF CLR}, typeof(TglIndexd){$ENDIF}));
  glIndexdv := TglIndexdv(glProcedure('glIndexdv'{$IFDEF CLR}, typeof(TglIndexdv){$ENDIF}));
  glIndexf := TglIndexf(glProcedure('glIndexf'{$IFDEF CLR}, typeof(TglIndexf){$ENDIF}));
  glIndexfv := TglIndexfv(glProcedure('glIndexfv'{$IFDEF CLR}, typeof(TglIndexfv){$ENDIF}));
  glIndexi := TglIndexi(glProcedure('glIndexi'{$IFDEF CLR}, typeof(TglIndexi){$ENDIF}));
  glIndexiv := TglIndexiv(glProcedure('glIndexiv'{$IFDEF CLR}, typeof(TglIndexiv){$ENDIF}));
  glIndexs := TglIndexs(glProcedure('glIndexs'{$IFDEF CLR}, typeof(TglIndexs){$ENDIF}));
  glIndexsv := TglIndexsv(glProcedure('glIndexsv'{$IFDEF CLR}, typeof(TglIndexsv){$ENDIF}));
  glIndexub := TglIndexub(glProcedure('glIndexub'{$IFDEF CLR}, typeof(TglIndexub){$ENDIF}));
  glIndexubv := TglIndexubv(glProcedure('glIndexubv'{$IFDEF CLR}, typeof(TglIndexubv){$ENDIF}));
  glInitNames := TglInitNames(glProcedure('glInitNames'{$IFDEF CLR}, typeof(TglInitNames){$ENDIF}));
  glInterleavedArrays := TglInterleavedArrays(glProcedure('glInterleavedArrays'{$IFDEF CLR}, typeof(TglInterleavedArrays){$ENDIF}));
  glIsEnabled := TglIsEnabled(glProcedure('glIsEnabled'{$IFDEF CLR}, typeof(TglIsEnabled){$ENDIF}));
  glIsList := TglIsList(glProcedure('glIsList'{$IFDEF CLR}, typeof(TglIsList){$ENDIF}));
  glIsTexture := TglIsTexture(glProcedure('glIsTexture'{$IFDEF CLR}, typeof(TglIsTexture){$ENDIF}));
  glLightModelf := TglLightModelf(glProcedure('glLightModelf'{$IFDEF CLR}, typeof(TglLightModelf){$ENDIF}));
  glLightModelfv := TglLightModelfv(glProcedure('glLightModelfv'{$IFDEF CLR}, typeof(TglLightModelfv){$ENDIF}));
  glLightModeli := TglLightModeli(glProcedure('glLightModeli'{$IFDEF CLR}, typeof(TglLightModeli){$ENDIF}));
  glLightModeliv := TglLightModeliv(glProcedure('glLightModeliv'{$IFDEF CLR}, typeof(TglLightModeliv){$ENDIF}));
  glLightf := TglLightf(glProcedure('glLightf'{$IFDEF CLR}, typeof(TglLightf){$ENDIF}));
  glLightfv := TglLightfv(glProcedure('glLightfv'{$IFDEF CLR}, typeof(TglLightfv){$ENDIF}));
  glLighti := TglLighti(glProcedure('glLighti'{$IFDEF CLR}, typeof(TglLighti){$ENDIF}));
  glLightiv := TglLightiv(glProcedure('glLightiv'{$IFDEF CLR}, typeof(TglLightiv){$ENDIF}));
  glLineStipple := TglLineStipple(glProcedure('glLineStipple'{$IFDEF CLR}, typeof(TglLineStipple){$ENDIF}));
  glLineWidth := TglLineWidth(glProcedure('glLineWidth'{$IFDEF CLR}, typeof(TglLineWidth){$ENDIF}));
  glListBase := TglListBase(glProcedure('glListBase'{$IFDEF CLR}, typeof(TglListBase){$ENDIF}));
  glLoadIdentity := TglLoadIdentity(glProcedure('glLoadIdentity'{$IFDEF CLR}, typeof(TglLoadIdentity){$ENDIF}));
  glLoadMatrixd := TglLoadMatrixd(glProcedure('glLoadMatrixd'{$IFDEF CLR}, typeof(TglLoadMatrixd){$ENDIF}));
  glLoadMatrixf := TglLoadMatrixf(glProcedure('glLoadMatrixf'{$IFDEF CLR}, typeof(TglLoadMatrixf){$ENDIF}));
  glLoadName := TglLoadName(glProcedure('glLoadName'{$IFDEF CLR}, typeof(TglLoadName){$ENDIF}));
  glLogicOp := TglLogicOp(glProcedure('glLogicOp'{$IFDEF CLR}, typeof(TglLogicOp){$ENDIF}));
  glMap1d := TglMap1d(glProcedure('glMap1d'{$IFDEF CLR}, typeof(TglMap1d){$ENDIF}));
  glMap1f := TglMap1f(glProcedure('glMap1f'{$IFDEF CLR}, typeof(TglMap1f){$ENDIF}));
  glMap2d := TglMap2d(glProcedure('glMap2d'{$IFDEF CLR}, typeof(TglMap2d){$ENDIF}));
  glMap2f := TglMap2f(glProcedure('glMap2f'{$IFDEF CLR}, typeof(TglMap2f){$ENDIF}));
  glMapGrid1d := TglMapGrid1d(glProcedure('glMapGrid1d'{$IFDEF CLR}, typeof(TglMapGrid1d){$ENDIF}));
  glMapGrid1f := TglMapGrid1f(glProcedure('glMapGrid1f'{$IFDEF CLR}, typeof(TglMapGrid1f){$ENDIF}));
  glMapGrid2d := TglMapGrid2d(glProcedure('glMapGrid2d'{$IFDEF CLR}, typeof(TglMapGrid2d){$ENDIF}));
  glMapGrid2f := TglMapGrid2f(glProcedure('glMapGrid2f'{$IFDEF CLR}, typeof(TglMapGrid2f){$ENDIF}));
  glMaterialf := TglMaterialf(glProcedure('glMaterialf'{$IFDEF CLR}, typeof(TglMaterialf){$ENDIF}));
  glMaterialfv := TglMaterialfv(glProcedure('glMaterialfv'{$IFDEF CLR}, typeof(TglMaterialfv){$ENDIF}));
  glMateriali := TglMateriali(glProcedure('glMateriali'{$IFDEF CLR}, typeof(TglMateriali){$ENDIF}));
  glMaterialiv := TglMaterialiv(glProcedure('glMaterialiv'{$IFDEF CLR}, typeof(TglMaterialiv){$ENDIF}));
  glMatrixMode := TglMatrixMode(glProcedure('glMatrixMode'{$IFDEF CLR}, typeof(TglMatrixMode){$ENDIF}));
  glMultMatrixd := TglMultMatrixd(glProcedure('glMultMatrixd'{$IFDEF CLR}, typeof(TglMultMatrixd){$ENDIF}));
  glMultMatrixf := TglMultMatrixf(glProcedure('glMultMatrixf'{$IFDEF CLR}, typeof(TglMultMatrixf){$ENDIF}));
  glNewList := TglNewList(glProcedure('glNewList'{$IFDEF CLR}, typeof(TglNewList){$ENDIF}));
  glNormal3b := TglNormal3b(glProcedure('glNormal3b'{$IFDEF CLR}, typeof(TglNormal3b){$ENDIF}));
  glNormal3bv := TglNormal3bv(glProcedure('glNormal3bv'{$IFDEF CLR}, typeof(TglNormal3bv){$ENDIF}));
  glNormal3d := TglNormal3d(glProcedure('glNormal3d'{$IFDEF CLR}, typeof(TglNormal3d){$ENDIF}));
  glNormal3dv := TglNormal3dv(glProcedure('glNormal3dv'{$IFDEF CLR}, typeof(TglNormal3dv){$ENDIF}));
  glNormal3f := TglNormal3f(glProcedure('glNormal3f'{$IFDEF CLR}, typeof(TglNormal3f){$ENDIF}));
  glNormal3fv := TglNormal3fv(glProcedure('glNormal3fv'{$IFDEF CLR}, typeof(TglNormal3fv){$ENDIF}));
  glNormal3i := TglNormal3i(glProcedure('glNormal3i'{$IFDEF CLR}, typeof(TglNormal3i){$ENDIF}));
  glNormal3iv := TglNormal3iv(glProcedure('glNormal3iv'{$IFDEF CLR}, typeof(TglNormal3iv){$ENDIF}));
  glNormal3s := TglNormal3s(glProcedure('glNormal3s'{$IFDEF CLR}, typeof(TglNormal3s){$ENDIF}));
  glNormal3sv := TglNormal3sv(glProcedure('glNormal3sv'{$IFDEF CLR}, typeof(TglNormal3sv){$ENDIF}));
  _glNormalPointer := TglNormalPointer(glProcedure('glNormalPointer'{$IFDEF CLR}, typeof(TglNormalPointer){$ENDIF}));
  glOrtho := TglOrtho(glProcedure('glOrtho'{$IFDEF CLR}, typeof(TglOrtho){$ENDIF}));
  glPassThrough := TglPassThrough(glProcedure('glPassThrough'{$IFDEF CLR}, typeof(TglPassThrough){$ENDIF}));
  glPixelMapfv := TglPixelMapfv(glProcedure('glPixelMapfv'{$IFDEF CLR}, typeof(TglPixelMapfv){$ENDIF}));
  glPixelMapuiv := TglPixelMapuiv(glProcedure('glPixelMapuiv'{$IFDEF CLR}, typeof(TglPixelMapuiv){$ENDIF}));
  glPixelMapusv := TglPixelMapusv(glProcedure('glPixelMapusv'{$IFDEF CLR}, typeof(TglPixelMapusv){$ENDIF}));
  glPixelStoref := TglPixelStoref(glProcedure('glPixelStoref'{$IFDEF CLR}, typeof(TglPixelStoref){$ENDIF}));
  glPixelStorei := TglPixelStorei(glProcedure('glPixelStorei'{$IFDEF CLR}, typeof(TglPixelStorei){$ENDIF}));
  glPixelTransferf := TglPixelTransferf(glProcedure('glPixelTransferf'{$IFDEF CLR}, typeof(TglPixelTransferf){$ENDIF}));
  glPixelTransferi := TglPixelTransferi(glProcedure('glPixelTransferi'{$IFDEF CLR}, typeof(TglPixelTransferi){$ENDIF}));
  glPixelZoom := TglPixelZoom(glProcedure('glPixelZoom'{$IFDEF CLR}, typeof(TglPixelZoom){$ENDIF}));
  glPointSize := TglPointSize(glProcedure('glPointSize'{$IFDEF CLR}, typeof(TglPointSize){$ENDIF}));
  glPolygonMode := TglPolygonMode(glProcedure('glPolygonMode'{$IFDEF CLR}, typeof(TglPolygonMode){$ENDIF}));
  glPolygonOffset := TglPolygonOffset(glProcedure('glPolygonOffset'{$IFDEF CLR}, typeof(TglPolygonOffset){$ENDIF}));
  glPolygonStipple := TglPolygonStipple(glProcedure('glPolygonStipple'{$IFDEF CLR}, typeof(TglPolygonStipple){$ENDIF}));
  glPopAttrib := TglPopAttrib(glProcedure('glPopAttrib'{$IFDEF CLR}, typeof(TglPopAttrib){$ENDIF}));
  glPopClientAttrib := TglPopClientAttrib(glProcedure('glPopClientAttrib'{$IFDEF CLR}, typeof(TglPopClientAttrib){$ENDIF}));
  glPopMatrix := TglPopMatrix(glProcedure('glPopMatrix'{$IFDEF CLR}, typeof(TglPopMatrix){$ENDIF}));
  glPopName := TglPopName(glProcedure('glPopName'{$IFDEF CLR}, typeof(TglPopName){$ENDIF}));
  glPrioritizeTextures := TglPrioritizeTextures(glProcedure('glPrioritizeTextures'{$IFDEF CLR}, typeof(TglPrioritizeTextures){$ENDIF}));
  glPushAttrib := TglPushAttrib(glProcedure('glPushAttrib'{$IFDEF CLR}, typeof(TglPushAttrib){$ENDIF}));
  glPushClientAttrib := TglPushClientAttrib(glProcedure('glPushClientAttrib'{$IFDEF CLR}, typeof(TglPushClientAttrib){$ENDIF}));
  glPushMatrix := TglPushMatrix(glProcedure('glPushMatrix'{$IFDEF CLR}, typeof(TglPushMatrix){$ENDIF}));
  glPushName := TglPushName(glProcedure('glPushName'{$IFDEF CLR}, typeof(TglPushName){$ENDIF}));
  glRasterPos2d := TglRasterPos2d(glProcedure('glRasterPos2d'{$IFDEF CLR}, typeof(TglRasterPos2d){$ENDIF}));
  glRasterPos2dv := TglRasterPos2dv(glProcedure('glRasterPos2dv'{$IFDEF CLR}, typeof(TglRasterPos2dv){$ENDIF}));
  glRasterPos2f := TglRasterPos2f(glProcedure('glRasterPos2f'{$IFDEF CLR}, typeof(TglRasterPos2f){$ENDIF}));
  glRasterPos2fv := TglRasterPos2fv(glProcedure('glRasterPos2fv'{$IFDEF CLR}, typeof(TglRasterPos2fv){$ENDIF}));
  glRasterPos2i := TglRasterPos2i(glProcedure('glRasterPos2i'{$IFDEF CLR}, typeof(TglRasterPos2i){$ENDIF}));
  glRasterPos2iv := TglRasterPos2iv(glProcedure('glRasterPos2iv'{$IFDEF CLR}, typeof(TglRasterPos2iv){$ENDIF}));
  glRasterPos2s := TglRasterPos2s(glProcedure('glRasterPos2s'{$IFDEF CLR}, typeof(TglRasterPos2s){$ENDIF}));
  glRasterPos2sv := TglRasterPos2sv(glProcedure('glRasterPos2sv'{$IFDEF CLR}, typeof(TglRasterPos2sv){$ENDIF}));
  glRasterPos3d := TglRasterPos3d(glProcedure('glRasterPos3d'{$IFDEF CLR}, typeof(TglRasterPos3d){$ENDIF}));
  glRasterPos3dv := TglRasterPos3dv(glProcedure('glRasterPos3dv'{$IFDEF CLR}, typeof(TglRasterPos3dv){$ENDIF}));
  glRasterPos3f := TglRasterPos3f(glProcedure('glRasterPos3f'{$IFDEF CLR}, typeof(TglRasterPos3f){$ENDIF}));
  glRasterPos3fv := TglRasterPos3fv(glProcedure('glRasterPos3fv'{$IFDEF CLR}, typeof(TglRasterPos3fv){$ENDIF}));
  glRasterPos3i := TglRasterPos3i(glProcedure('glRasterPos3i'{$IFDEF CLR}, typeof(TglRasterPos3i){$ENDIF}));
  glRasterPos3iv := TglRasterPos3iv(glProcedure('glRasterPos3iv'{$IFDEF CLR}, typeof(TglRasterPos3iv){$ENDIF}));
  glRasterPos3s := TglRasterPos3s(glProcedure('glRasterPos3s'{$IFDEF CLR}, typeof(TglRasterPos3s){$ENDIF}));
  glRasterPos3sv := TglRasterPos3sv(glProcedure('glRasterPos3sv'{$IFDEF CLR}, typeof(TglRasterPos3sv){$ENDIF}));
  glRasterPos4d := TglRasterPos4d(glProcedure('glRasterPos4d'{$IFDEF CLR}, typeof(TglRasterPos4d){$ENDIF}));
  glRasterPos4dv := TglRasterPos4dv(glProcedure('glRasterPos4dv'{$IFDEF CLR}, typeof(TglRasterPos4dv){$ENDIF}));
  glRasterPos4f := TglRasterPos4f(glProcedure('glRasterPos4f'{$IFDEF CLR}, typeof(TglRasterPos4f){$ENDIF}));
  glRasterPos4fv := TglRasterPos4fv(glProcedure('glRasterPos4fv'{$IFDEF CLR}, typeof(TglRasterPos4fv){$ENDIF}));
  glRasterPos4i := TglRasterPos4i(glProcedure('glRasterPos4i'{$IFDEF CLR}, typeof(TglRasterPos4i){$ENDIF}));
  glRasterPos4iv := TglRasterPos4iv(glProcedure('glRasterPos4iv'{$IFDEF CLR}, typeof(TglRasterPos4iv){$ENDIF}));
  glRasterPos4s := TglRasterPos4s(glProcedure('glRasterPos4s'{$IFDEF CLR}, typeof(TglRasterPos4s){$ENDIF}));
  glRasterPos4sv := TglRasterPos4sv(glProcedure('glRasterPos4sv'{$IFDEF CLR}, typeof(TglRasterPos4sv){$ENDIF}));
  glReadBuffer := TglReadBuffer(glProcedure('glReadBuffer'{$IFDEF CLR}, typeof(TglReadBuffer){$ENDIF}));
  _glReadPixels := TglReadPixels(glProcedure('glReadPixels'{$IFDEF CLR}, typeof(TglReadPixels){$ENDIF}));
  glRectd := TglRectd(glProcedure('glRectd'{$IFDEF CLR}, typeof(TglRectd){$ENDIF}));
  glRectdv := TglRectdv(glProcedure('glRectdv'{$IFDEF CLR}, typeof(TglRectdv){$ENDIF}));
  glRectf := TglRectf(glProcedure('glRectf'{$IFDEF CLR}, typeof(TglRectf){$ENDIF}));
  glRectfv := TglRectfv(glProcedure('glRectfv'{$IFDEF CLR}, typeof(TglRectfv){$ENDIF}));
  glRecti := TglRecti(glProcedure('glRecti'{$IFDEF CLR}, typeof(TglRecti){$ENDIF}));
  glRectiv := TglRectiv(glProcedure('glRectiv'{$IFDEF CLR}, typeof(TglRectiv){$ENDIF}));
  glRects := TglRects(glProcedure('glRects'{$IFDEF CLR}, typeof(TglRects){$ENDIF}));
  glRectsv := TglRectsv(glProcedure('glRectsv'{$IFDEF CLR}, typeof(TglRectsv){$ENDIF}));
  glRenderMode := TglRenderMode(glProcedure('glRenderMode'{$IFDEF CLR}, typeof(TglRenderMode){$ENDIF}));
  glRotated := TglRotated(glProcedure('glRotated'{$IFDEF CLR}, typeof(TglRotated){$ENDIF}));
  glRotatef := TglRotatef(glProcedure('glRotatef'{$IFDEF CLR}, typeof(TglRotatef){$ENDIF}));
  glScaled := TglScaled(glProcedure('glScaled'{$IFDEF CLR}, typeof(TglScaled){$ENDIF}));
  glScalef := TglScalef(glProcedure('glScalef'{$IFDEF CLR}, typeof(TglScalef){$ENDIF}));
  glScissor := TglScissor(glProcedure('glScissor'{$IFDEF CLR}, typeof(TglScissor){$ENDIF}));
  glSelectBuffer := TglSelectBuffer(glProcedure('glSelectBuffer'{$IFDEF CLR}, typeof(TglSelectBuffer){$ENDIF}));
  glShadeModel := TglShadeModel(glProcedure('glShadeModel'{$IFDEF CLR}, typeof(TglShadeModel){$ENDIF}));
  glStencilFunc := TglStencilFunc(glProcedure('glStencilFunc'{$IFDEF CLR}, typeof(TglStencilFunc){$ENDIF}));
  glStencilMask := TglStencilMask(glProcedure('glStencilMask'{$IFDEF CLR}, typeof(TglStencilMask){$ENDIF}));
  glStencilOp := TglStencilOp(glProcedure('glStencilOp'{$IFDEF CLR}, typeof(TglStencilOp){$ENDIF}));
  glTexCoord1d := TglTexCoord1d(glProcedure('glTexCoord1d'{$IFDEF CLR}, typeof(TglTexCoord1d){$ENDIF}));
  glTexCoord1dv := TglTexCoord1dv(glProcedure('glTexCoord1dv'{$IFDEF CLR}, typeof(TglTexCoord1dv){$ENDIF}));
  glTexCoord1f := TglTexCoord1f(glProcedure('glTexCoord1f'{$IFDEF CLR}, typeof(TglTexCoord1f){$ENDIF}));
  glTexCoord1fv := TglTexCoord1fv(glProcedure('glTexCoord1fv'{$IFDEF CLR}, typeof(TglTexCoord1fv){$ENDIF}));
  glTexCoord1i := TglTexCoord1i(glProcedure('glTexCoord1i'{$IFDEF CLR}, typeof(TglTexCoord1i){$ENDIF}));
  glTexCoord1iv := TglTexCoord1iv(glProcedure('glTexCoord1iv'{$IFDEF CLR}, typeof(TglTexCoord1iv){$ENDIF}));
  glTexCoord1s := TglTexCoord1s(glProcedure('glTexCoord1s'{$IFDEF CLR}, typeof(TglTexCoord1s){$ENDIF}));
  glTexCoord1sv := TglTexCoord1sv(glProcedure('glTexCoord1sv'{$IFDEF CLR}, typeof(TglTexCoord1sv){$ENDIF}));
  glTexCoord2d := TglTexCoord2d(glProcedure('glTexCoord2d'{$IFDEF CLR}, typeof(TglTexCoord2d){$ENDIF}));
  glTexCoord2dv := TglTexCoord2dv(glProcedure('glTexCoord2dv'{$IFDEF CLR}, typeof(TglTexCoord2dv){$ENDIF}));
  glTexCoord2f := TglTexCoord2f(glProcedure('glTexCoord2f'{$IFDEF CLR}, typeof(TglTexCoord2f){$ENDIF}));
  glTexCoord2fv := TglTexCoord2fv(glProcedure('glTexCoord2fv'{$IFDEF CLR}, typeof(TglTexCoord2fv){$ENDIF}));
  glTexCoord2i := TglTexCoord2i(glProcedure('glTexCoord2i'{$IFDEF CLR}, typeof(TglTexCoord2i){$ENDIF}));
  glTexCoord2iv := TglTexCoord2iv(glProcedure('glTexCoord2iv'{$IFDEF CLR}, typeof(TglTexCoord2iv){$ENDIF}));
  glTexCoord2s := TglTexCoord2s(glProcedure('glTexCoord2s'{$IFDEF CLR}, typeof(TglTexCoord2s){$ENDIF}));
  glTexCoord2sv := TglTexCoord2sv(glProcedure('glTexCoord2sv'{$IFDEF CLR}, typeof(TglTexCoord2sv){$ENDIF}));
  glTexCoord3d := TglTexCoord3d(glProcedure('glTexCoord3d'{$IFDEF CLR}, typeof(TglTexCoord3d){$ENDIF}));
  glTexCoord3dv := TglTexCoord3dv(glProcedure('glTexCoord3dv'{$IFDEF CLR}, typeof(TglTexCoord3dv){$ENDIF}));
  glTexCoord3f := TglTexCoord3f(glProcedure('glTexCoord3f'{$IFDEF CLR}, typeof(TglTexCoord3f){$ENDIF}));
  glTexCoord3fv := TglTexCoord3fv(glProcedure('glTexCoord3fv'{$IFDEF CLR}, typeof(TglTexCoord3fv){$ENDIF}));
  glTexCoord3i := TglTexCoord3i(glProcedure('glTexCoord3i'{$IFDEF CLR}, typeof(TglTexCoord3i){$ENDIF}));
  glTexCoord3iv := TglTexCoord3iv(glProcedure('glTexCoord3iv'{$IFDEF CLR}, typeof(TglTexCoord3iv){$ENDIF}));
  glTexCoord3s := TglTexCoord3s(glProcedure('glTexCoord3s'{$IFDEF CLR}, typeof(TglTexCoord3s){$ENDIF}));
  glTexCoord3sv := TglTexCoord3sv(glProcedure('glTexCoord3sv'{$IFDEF CLR}, typeof(TglTexCoord3sv){$ENDIF}));
  glTexCoord4d := TglTexCoord4d(glProcedure('glTexCoord4d'{$IFDEF CLR}, typeof(TglTexCoord4d){$ENDIF}));
  glTexCoord4dv := TglTexCoord4dv(glProcedure('glTexCoord4dv'{$IFDEF CLR}, typeof(TglTexCoord4dv){$ENDIF}));
  glTexCoord4f := TglTexCoord4f(glProcedure('glTexCoord4f'{$IFDEF CLR}, typeof(TglTexCoord4f){$ENDIF}));
  glTexCoord4fv := TglTexCoord4fv(glProcedure('glTexCoord4fv'{$IFDEF CLR}, typeof(TglTexCoord4fv){$ENDIF}));
  glTexCoord4i := TglTexCoord4i(glProcedure('glTexCoord4i'{$IFDEF CLR}, typeof(TglTexCoord4i){$ENDIF}));
  glTexCoord4iv := TglTexCoord4iv(glProcedure('glTexCoord4iv'{$IFDEF CLR}, typeof(TglTexCoord4iv){$ENDIF}));
  glTexCoord4s := TglTexCoord4s(glProcedure('glTexCoord4s'{$IFDEF CLR}, typeof(TglTexCoord4s){$ENDIF}));
  glTexCoord4sv := TglTexCoord4sv(glProcedure('glTexCoord4sv'{$IFDEF CLR}, typeof(TglTexCoord4sv){$ENDIF}));
  _glTexCoordPointer := TglTexCoordPointer(glProcedure('glTexCoordPointer'{$IFDEF CLR}, typeof(TglTexCoordPointer){$ENDIF}));
  glTexEnvf := TglTexEnvf(glProcedure('glTexEnvf'{$IFDEF CLR}, typeof(TglTexEnvf){$ENDIF}));
  glTexEnvfv := TglTexEnvfv(glProcedure('glTexEnvfv'{$IFDEF CLR}, typeof(TglTexEnvfv){$ENDIF}));
  glTexEnvi := TglTexEnvi(glProcedure('glTexEnvi'{$IFDEF CLR}, typeof(TglTexEnvi){$ENDIF}));
  glTexEnviv := TglTexEnviv(glProcedure('glTexEnviv'{$IFDEF CLR}, typeof(TglTexEnviv){$ENDIF}));
  glTexGend := TglTexGend(glProcedure('glTexGend'{$IFDEF CLR}, typeof(TglTexGend){$ENDIF}));
  glTexGendv := TglTexGendv(glProcedure('glTexGendv'{$IFDEF CLR}, typeof(TglTexGendv){$ENDIF}));
  glTexGenf := TglTexGenf(glProcedure('glTexGenf'{$IFDEF CLR}, typeof(TglTexGenf){$ENDIF}));
  glTexGenfv := TglTexGenfv(glProcedure('glTexGenfv'{$IFDEF CLR}, typeof(TglTexGenfv){$ENDIF}));
  glTexGeni := TglTexGeni(glProcedure('glTexGeni'{$IFDEF CLR}, typeof(TglTexGeni){$ENDIF}));
  glTexGeniv := TglTexGeniv(glProcedure('glTexGeniv'{$IFDEF CLR}, typeof(TglTexGeniv){$ENDIF}));
  glTexImage1D := TglTexImage1D(glProcedure('glTexImage1D'{$IFDEF CLR}, typeof(TglTexImage1D){$ENDIF}));
  _glTexImage2D := TglTexImage2D(glProcedure('glTexImage2D'{$IFDEF CLR}, typeof(TglTexImage2D){$ENDIF}));
  glTexParameterf := TglTexParameterf(glProcedure('glTexParameterf'{$IFDEF CLR}, typeof(TglTexParameterf){$ENDIF}));
  glTexParameterfv := TglTexParameterfv(glProcedure('glTexParameterfv'{$IFDEF CLR}, typeof(TglTexParameterfv){$ENDIF}));
  glTexParameteri := TglTexParameteri(glProcedure('glTexParameteri'{$IFDEF CLR}, typeof(TglTexParameteri){$ENDIF}));
  glTexParameteriv := TglTexParameteriv(glProcedure('glTexParameteriv'{$IFDEF CLR}, typeof(TglTexParameteriv){$ENDIF}));
  glTexSubImage1D := TglTexSubImage1D(glProcedure('glTexSubImage1D'{$IFDEF CLR}, typeof(TglTexSubImage1D){$ENDIF}));
  glTexSubImage2D := TglTexSubImage2D(glProcedure('glTexSubImage2D'{$IFDEF CLR}, typeof(TglTexSubImage2D){$ENDIF}));
  glTranslated := TglTranslated(glProcedure('glTranslated'{$IFDEF CLR}, typeof(TglTranslated){$ENDIF}));
  glTranslatef := TglTranslatef(glProcedure('glTranslatef'{$IFDEF CLR}, typeof(TglTranslatef){$ENDIF}));
  glVertex2d := TglVertex2d(glProcedure('glVertex2d'{$IFDEF CLR}, typeof(TglVertex2d){$ENDIF}));
  glVertex2dv := TglVertex2dv(glProcedure('glVertex2dv'{$IFDEF CLR}, typeof(TglVertex2dv){$ENDIF}));
  glVertex2f := TglVertex2f(glProcedure('glVertex2f'{$IFDEF CLR}, typeof(TglVertex2f){$ENDIF}));
  glVertex2fv := TglVertex2fv(glProcedure('glVertex2fv'{$IFDEF CLR}, typeof(TglVertex2fv){$ENDIF}));
  glVertex2i := TglVertex2i(glProcedure('glVertex2i'{$IFDEF CLR}, typeof(TglVertex2i){$ENDIF}));
  glVertex2iv := TglVertex2iv(glProcedure('glVertex2iv'{$IFDEF CLR}, typeof(TglVertex2iv){$ENDIF}));
  glVertex2s := TglVertex2s(glProcedure('glVertex2s'{$IFDEF CLR}, typeof(TglVertex2s){$ENDIF}));
  glVertex2sv := TglVertex2sv(glProcedure('glVertex2sv'{$IFDEF CLR}, typeof(TglVertex2sv){$ENDIF}));
  glVertex3d := TglVertex3d(glProcedure('glVertex3d'{$IFDEF CLR}, typeof(TglVertex3d){$ENDIF}));
  glVertex3dv := TglVertex3dv(glProcedure('glVertex3dv'{$IFDEF CLR}, typeof(TglVertex3dv){$ENDIF}));
  glVertex3f := TglVertex3f(glProcedure('glVertex3f'{$IFDEF CLR}, typeof(TglVertex3f){$ENDIF}));
  glVertex3fv := TglVertex3fv(glProcedure('glVertex3fv'{$IFDEF CLR}, typeof(TglVertex3fv){$ENDIF}));
  glVertex3i := TglVertex3i(glProcedure('glVertex3i'{$IFDEF CLR}, typeof(TglVertex3i){$ENDIF}));
  glVertex3iv := TglVertex3iv(glProcedure('glVertex3iv'{$IFDEF CLR}, typeof(TglVertex3iv){$ENDIF}));
  glVertex3s := TglVertex3s(glProcedure('glVertex3s'{$IFDEF CLR}, typeof(TglVertex3s){$ENDIF}));
  glVertex3sv := TglVertex3sv(glProcedure('glVertex3sv'{$IFDEF CLR}, typeof(TglVertex3sv){$ENDIF}));
  glVertex4d := TglVertex4d(glProcedure('glVertex4d'{$IFDEF CLR}, typeof(TglVertex4d){$ENDIF}));
  glVertex4dv := TglVertex4dv(glProcedure('glVertex4dv'{$IFDEF CLR}, typeof(TglVertex4dv){$ENDIF}));
  glVertex4f := TglVertex4f(glProcedure('glVertex4f'{$IFDEF CLR}, typeof(TglVertex4f){$ENDIF}));
  glVertex4fv := TglVertex4fv(glProcedure('glVertex4fv'{$IFDEF CLR}, typeof(TglVertex4fv){$ENDIF}));
  glVertex4i := TglVertex4i(glProcedure('glVertex4i'{$IFDEF CLR}, typeof(TglVertex4i){$ENDIF}));
  glVertex4iv := TglVertex4iv(glProcedure('glVertex4iv'{$IFDEF CLR}, typeof(TglVertex4iv){$ENDIF}));
  glVertex4s := TglVertex4s(glProcedure('glVertex4s'{$IFDEF CLR}, typeof(TglVertex4s){$ENDIF}));
  glVertex4sv := TglVertex4sv(glProcedure('glVertex4sv'{$IFDEF CLR}, typeof(TglVertex4sv){$ENDIF}));
  _glVertexPointer := TglVertexPointer(glProcedure('glVertexPointer'{$IFDEF CLR}, typeof(TglVertexPointer){$ENDIF}));
  glViewport := TglViewport(glProcedure('glViewport'{$IFDEF CLR}, typeof(TglViewport){$ENDIF}));

  // GL_VERSION_1_2
  glBlendColor := TglBlendColor(glProcedure('glBlendColor'{$IFDEF CLR}, typeof(TglBlendColor){$ENDIF}));
  glBlendEquation := TglBlendEquation(glProcedure('glBlendEquation'{$IFDEF CLR}, typeof(TglBlendEquation){$ENDIF}));
  glDrawRangeElements := TglDrawRangeElements(glProcedure('glDrawRangeElements'{$IFDEF CLR}, typeof(TglDrawRangeElements){$ENDIF}));
  glColorTable := TglColorTable(glProcedure('glColorTable'{$IFDEF CLR}, typeof(TglColorTable){$ENDIF}));
  glColorTableParameterfv := TglColorTableParameterfv(glProcedure('glColorTableParameterfv'{$IFDEF CLR}, typeof(TglColorTableParameterfv){$ENDIF}));
  glColorTableParameteriv := TglColorTableParameteriv(glProcedure('glColorTableParameteriv'{$IFDEF CLR}, typeof(TglColorTableParameteriv){$ENDIF}));
  glCopyColorTable := TglCopyColorTable(glProcedure('glCopyColorTable'{$IFDEF CLR}, typeof(TglCopyColorTable){$ENDIF}));
  glGetColorTable := TglGetColorTable(glProcedure('glGetColorTable'{$IFDEF CLR}, typeof(TglGetColorTable){$ENDIF}));
  glGetColorTableParameterfv := TglGetColorTableParameterfv(glProcedure('glGetColorTableParameterfv'{$IFDEF CLR}, typeof(TglGetColorTableParameterfv){$ENDIF}));
  glGetColorTableParameteriv := TglGetColorTableParameteriv(glProcedure('glGetColorTableParameteriv'{$IFDEF CLR}, typeof(TglGetColorTableParameteriv){$ENDIF}));
  glColorSubTable := TglColorSubTable(glProcedure('glColorSubTable'{$IFDEF CLR}, typeof(TglColorSubTable){$ENDIF}));
  glCopyColorSubTable := TglCopyColorSubTable(glProcedure('glCopyColorSubTable'{$IFDEF CLR}, typeof(TglCopyColorSubTable){$ENDIF}));
  glConvolutionFilter1D := TglConvolutionFilter1D(glProcedure('glConvolutionFilter1D'{$IFDEF CLR}, typeof(TglConvolutionFilter1D){$ENDIF}));
  glConvolutionFilter2D := TglConvolutionFilter2D(glProcedure('glConvolutionFilter2D'{$IFDEF CLR}, typeof(TglConvolutionFilter2D){$ENDIF}));
  glConvolutionParameterf := TglConvolutionParameterf(glProcedure('glConvolutionParameterf'{$IFDEF CLR}, typeof(TglConvolutionParameterf){$ENDIF}));
  glConvolutionParameterfv := TglConvolutionParameterfv(glProcedure('glConvolutionParameterfv'{$IFDEF CLR}, typeof(TglConvolutionParameterfv){$ENDIF}));
  glConvolutionParameteri := TglConvolutionParameteri(glProcedure('glConvolutionParameteri'{$IFDEF CLR}, typeof(TglConvolutionParameteri){$ENDIF}));
  glConvolutionParameteriv := TglConvolutionParameteriv(glProcedure('glConvolutionParameteriv'{$IFDEF CLR}, typeof(TglConvolutionParameteriv){$ENDIF}));
  glCopyConvolutionFilter1D := TglCopyConvolutionFilter1D(glProcedure('glCopyConvolutionFilter1D'{$IFDEF CLR}, typeof(TglCopyConvolutionFilter1D){$ENDIF}));
  glCopyConvolutionFilter2D := TglCopyConvolutionFilter2D(glProcedure('glCopyConvolutionFilter2D'{$IFDEF CLR}, typeof(TglCopyConvolutionFilter2D){$ENDIF}));
  glGetConvolutionFilter := TglGetConvolutionFilter(glProcedure('glGetConvolutionFilter'{$IFDEF CLR}, typeof(TglGetConvolutionFilter){$ENDIF}));
  glGetConvolutionParameterfv := TglGetConvolutionParameterfv(glProcedure('glGetConvolutionParameterfv'{$IFDEF CLR}, typeof(TglGetConvolutionParameterfv){$ENDIF}));
  glGetConvolutionParameteriv := TglGetConvolutionParameteriv(glProcedure('glGetConvolutionParameteriv'{$IFDEF CLR}, typeof(TglGetConvolutionParameteriv){$ENDIF}));
  glGetSeparableFilter := TglGetSeparableFilter(glProcedure('glGetSeparableFilter'{$IFDEF CLR}, typeof(TglGetSeparableFilter){$ENDIF}));
  glSeparableFilter2D := TglSeparableFilter2D(glProcedure('glSeparableFilter2D'{$IFDEF CLR}, typeof(TglSeparableFilter2D){$ENDIF}));
  glGetHistogram := TglGetHistogram(glProcedure('glGetHistogram'{$IFDEF CLR}, typeof(TglGetHistogram){$ENDIF}));
  glGetHistogramParameterfv := TglGetHistogramParameterfv(glProcedure('glGetHistogramParameterfv'{$IFDEF CLR}, typeof(TglGetHistogramParameterfv){$ENDIF}));
  glGetHistogramParameteriv := TglGetHistogramParameteriv(glProcedure('glGetHistogramParameteriv'{$IFDEF CLR}, typeof(TglGetHistogramParameteriv){$ENDIF}));
  glGetMinmax := TglGetMinmax(glProcedure('glGetMinmax'{$IFDEF CLR}, typeof(TglGetMinmax){$ENDIF}));
  glGetMinmaxParameterfv := TglGetMinmaxParameterfv(glProcedure('glGetMinmaxParameterfv'{$IFDEF CLR}, typeof(TglGetMinmaxParameterfv){$ENDIF}));
  glGetMinmaxParameteriv := TglGetMinmaxParameteriv(glProcedure('glGetMinmaxParameteriv'{$IFDEF CLR}, typeof(TglGetMinmaxParameteriv){$ENDIF}));
  glHistogram := TglHistogram(glProcedure('glHistogram'{$IFDEF CLR}, typeof(TglHistogram){$ENDIF}));
  glMinmax := TglMinmax(glProcedure('glMinmax'{$IFDEF CLR}, typeof(TglMinmax){$ENDIF}));
  glResetHistogram := TglResetHistogram(glProcedure('glResetHistogram'{$IFDEF CLR}, typeof(TglResetHistogram){$ENDIF}));
  glResetMinmax := TglResetMinmax(glProcedure('glResetMinmax'{$IFDEF CLR}, typeof(TglResetMinmax){$ENDIF}));
  glTexImage3D := TglTexImage3D(glProcedure('glTexImage3D'{$IFDEF CLR}, typeof(TglTexImage3D){$ENDIF}));
  glTexSubImage3D := TglTexSubImage3D(glProcedure('glTexSubImage3D'{$IFDEF CLR}, typeof(TglTexSubImage3D){$ENDIF}));
  glCopyTexSubImage3D := TglCopyTexSubImage3D(glProcedure('glCopyTexSubImage3D'{$IFDEF CLR}, typeof(TglCopyTexSubImage3D){$ENDIF}));

  // GL_VERSION_1_3
  glActiveTexture := TglActiveTexture(glProcedure('glActiveTexture'{$IFDEF CLR}, typeof(TglActiveTexture){$ENDIF}));
  glClientActiveTexture := TglClientActiveTexture(glProcedure('glClientActiveTexture'{$IFDEF CLR}, typeof(TglClientActiveTexture){$ENDIF}));
  glMultiTexCoord1d := TglMultiTexCoord1d(glProcedure('glMultiTexCoord1d'{$IFDEF CLR}, typeof(TglMultiTexCoord1d){$ENDIF}));
  glMultiTexCoord1dv := TglMultiTexCoord1dv(glProcedure('glMultiTexCoord1dv'{$IFDEF CLR}, typeof(TglMultiTexCoord1dv){$ENDIF}));
  glMultiTexCoord1f := TglMultiTexCoord1f(glProcedure('glMultiTexCoord1f'{$IFDEF CLR}, typeof(TglMultiTexCoord1f){$ENDIF}));
  glMultiTexCoord1fv := TglMultiTexCoord1fv(glProcedure('glMultiTexCoord1fv'{$IFDEF CLR}, typeof(TglMultiTexCoord1fv){$ENDIF}));
  glMultiTexCoord1i := TglMultiTexCoord1i(glProcedure('glMultiTexCoord1i'{$IFDEF CLR}, typeof(TglMultiTexCoord1i){$ENDIF}));
  glMultiTexCoord1iv := TglMultiTexCoord1iv(glProcedure('glMultiTexCoord1iv'{$IFDEF CLR}, typeof(TglMultiTexCoord1iv){$ENDIF}));
  glMultiTexCoord1s := TglMultiTexCoord1s(glProcedure('glMultiTexCoord1s'{$IFDEF CLR}, typeof(TglMultiTexCoord1s){$ENDIF}));
  glMultiTexCoord1sv := TglMultiTexCoord1sv(glProcedure('glMultiTexCoord1sv'{$IFDEF CLR}, typeof(TglMultiTexCoord1sv){$ENDIF}));
  glMultiTexCoord2d := TglMultiTexCoord2d(glProcedure('glMultiTexCoord2d'{$IFDEF CLR}, typeof(TglMultiTexCoord2d){$ENDIF}));
  glMultiTexCoord2dv := TglMultiTexCoord2dv(glProcedure('glMultiTexCoord2dv'{$IFDEF CLR}, typeof(TglMultiTexCoord2dv){$ENDIF}));
  glMultiTexCoord2f := TglMultiTexCoord2f(glProcedure('glMultiTexCoord2f'{$IFDEF CLR}, typeof(TglMultiTexCoord2f){$ENDIF}));
  glMultiTexCoord2fv := TglMultiTexCoord2fv(glProcedure('glMultiTexCoord2fv'{$IFDEF CLR}, typeof(TglMultiTexCoord2fv){$ENDIF}));
  glMultiTexCoord2i := TglMultiTexCoord2i(glProcedure('glMultiTexCoord2i'{$IFDEF CLR}, typeof(TglMultiTexCoord2i){$ENDIF}));
  glMultiTexCoord2iv := TglMultiTexCoord2iv(glProcedure('glMultiTexCoord2iv'{$IFDEF CLR}, typeof(TglMultiTexCoord2iv){$ENDIF}));
  glMultiTexCoord2s := TglMultiTexCoord2s(glProcedure('glMultiTexCoord2s'{$IFDEF CLR}, typeof(TglMultiTexCoord2s){$ENDIF}));
  glMultiTexCoord2sv := TglMultiTexCoord2sv(glProcedure('glMultiTexCoord2sv'{$IFDEF CLR}, typeof(TglMultiTexCoord2sv){$ENDIF}));
  glMultiTexCoord3d := TglMultiTexCoord3d(glProcedure('glMultiTexCoord3d'{$IFDEF CLR}, typeof(TglMultiTexCoord3d){$ENDIF}));
  glMultiTexCoord3dv := TglMultiTexCoord3dv(glProcedure('glMultiTexCoord3dv'{$IFDEF CLR}, typeof(TglMultiTexCoord3dv){$ENDIF}));
  glMultiTexCoord3f := TglMultiTexCoord3f(glProcedure('glMultiTexCoord3f'{$IFDEF CLR}, typeof(TglMultiTexCoord3f){$ENDIF}));
  glMultiTexCoord3fv := TglMultiTexCoord3fv(glProcedure('glMultiTexCoord3fv'{$IFDEF CLR}, typeof(TglMultiTexCoord3fv){$ENDIF}));
  glMultiTexCoord3i := TglMultiTexCoord3i(glProcedure('glMultiTexCoord3i'{$IFDEF CLR}, typeof(TglMultiTexCoord3i){$ENDIF}));
  glMultiTexCoord3iv := TglMultiTexCoord3iv(glProcedure('glMultiTexCoord3iv'{$IFDEF CLR}, typeof(TglMultiTexCoord3iv){$ENDIF}));
  glMultiTexCoord3s := TglMultiTexCoord3s(glProcedure('glMultiTexCoord3s'{$IFDEF CLR}, typeof(TglMultiTexCoord3s){$ENDIF}));
  glMultiTexCoord3sv := TglMultiTexCoord3sv(glProcedure('glMultiTexCoord3sv'{$IFDEF CLR}, typeof(TglMultiTexCoord3sv){$ENDIF}));
  glMultiTexCoord4d := TglMultiTexCoord4d(glProcedure('glMultiTexCoord4d'{$IFDEF CLR}, typeof(TglMultiTexCoord4d){$ENDIF}));
  glMultiTexCoord4dv := TglMultiTexCoord4dv(glProcedure('glMultiTexCoord4dv'{$IFDEF CLR}, typeof(TglMultiTexCoord4dv){$ENDIF}));
  glMultiTexCoord4f := TglMultiTexCoord4f(glProcedure('glMultiTexCoord4f'{$IFDEF CLR}, typeof(TglMultiTexCoord4f){$ENDIF}));
  glMultiTexCoord4fv := TglMultiTexCoord4fv(glProcedure('glMultiTexCoord4fv'{$IFDEF CLR}, typeof(TglMultiTexCoord4fv){$ENDIF}));
  glMultiTexCoord4i := TglMultiTexCoord4i(glProcedure('glMultiTexCoord4i'{$IFDEF CLR}, typeof(TglMultiTexCoord4i){$ENDIF}));
  glMultiTexCoord4iv := TglMultiTexCoord4iv(glProcedure('glMultiTexCoord4iv'{$IFDEF CLR}, typeof(TglMultiTexCoord4iv){$ENDIF}));
  glMultiTexCoord4s := TglMultiTexCoord4s(glProcedure('glMultiTexCoord4s'{$IFDEF CLR}, typeof(TglMultiTexCoord4s){$ENDIF}));
  glMultiTexCoord4sv := TglMultiTexCoord4sv(glProcedure('glMultiTexCoord4sv'{$IFDEF CLR}, typeof(TglMultiTexCoord4sv){$ENDIF}));
  glLoadTransposeMatrixf := TglLoadTransposeMatrixf(glProcedure('glLoadTransposeMatrixf'{$IFDEF CLR}, typeof(TglLoadTransposeMatrixf){$ENDIF}));
  glLoadTransposeMatrixd := TglLoadTransposeMatrixd(glProcedure('glLoadTransposeMatrixd'{$IFDEF CLR}, typeof(TglLoadTransposeMatrixd){$ENDIF}));
  glMultTransposeMatrixf := TglMultTransposeMatrixf(glProcedure('glMultTransposeMatrixf'{$IFDEF CLR}, typeof(TglMultTransposeMatrixf){$ENDIF}));
  glMultTransposeMatrixd := TglMultTransposeMatrixd(glProcedure('glMultTransposeMatrixd'{$IFDEF CLR}, typeof(TglMultTransposeMatrixd){$ENDIF}));
  glSampleCoverage := TglSampleCoverage(glProcedure('glSampleCoverage'{$IFDEF CLR}, typeof(TglSampleCoverage){$ENDIF}));
  glCompressedTexImage3D := TglCompressedTexImage3D(glProcedure('glCompressedTexImage3D'{$IFDEF CLR}, typeof(TglCompressedTexImage3D){$ENDIF}));
  glCompressedTexImage2D := TglCompressedTexImage2D(glProcedure('glCompressedTexImage2D'{$IFDEF CLR}, typeof(TglCompressedTexImage2D){$ENDIF}));
  glCompressedTexImage1D := TglCompressedTexImage1D(glProcedure('glCompressedTexImage1D'{$IFDEF CLR}, typeof(TglCompressedTexImage1D){$ENDIF}));
  glCompressedTexSubImage3D := TglCompressedTexSubImage3D(glProcedure('glCompressedTexSubImage3D'{$IFDEF CLR}, typeof(TglCompressedTexSubImage3D){$ENDIF}));
  glCompressedTexSubImage2D := TglCompressedTexSubImage2D(glProcedure('glCompressedTexSubImage2D'{$IFDEF CLR}, typeof(TglCompressedTexSubImage2D){$ENDIF}));
  glCompressedTexSubImage1D := TglCompressedTexSubImage1D(glProcedure('glCompressedTexSubImage1D'{$IFDEF CLR}, typeof(TglCompressedTexSubImage1D){$ENDIF}));
  glGetCompressedTexImage := TglGetCompressedTexImage(glProcedure('glGetCompressedTexImage'{$IFDEF CLR}, typeof(TglGetCompressedTexImage){$ENDIF}));

  // GL_VERSION_1_4
  glBlendFuncSeparate := TglBlendFuncSeparate(glProcedure('glBlendFuncSeparate'{$IFDEF CLR}, typeof(TglBlendFuncSeparate){$ENDIF}));
  glFogCoordf := TglFogCoordf(glProcedure('glFogCoordf'{$IFDEF CLR}, typeof(TglFogCoordf){$ENDIF}));
  glFogCoordfv := TglFogCoordfv(glProcedure('glFogCoordfv'{$IFDEF CLR}, typeof(TglFogCoordfv){$ENDIF}));
  glFogCoordd := TglFogCoordd(glProcedure('glFogCoordd'{$IFDEF CLR}, typeof(TglFogCoordd){$ENDIF}));
  glFogCoorddv := TglFogCoorddv(glProcedure('glFogCoorddv'{$IFDEF CLR}, typeof(TglFogCoorddv){$ENDIF}));
  glFogCoordPointer := TglFogCoordPointer(glProcedure('glFogCoordPointer'{$IFDEF CLR}, typeof(TglFogCoordPointer){$ENDIF}));
  glMultiDrawArrays := TglMultiDrawArrays(glProcedure('glMultiDrawArrays'{$IFDEF CLR}, typeof(TglMultiDrawArrays){$ENDIF}));
  glMultiDrawElements := TglMultiDrawElements(glProcedure('glMultiDrawElements'{$IFDEF CLR}, typeof(TglMultiDrawElements){$ENDIF}));
  glPointParameterf := TglPointParameterf(glProcedure('glPointParameterf'{$IFDEF CLR}, typeof(TglPointParameterf){$ENDIF}));
  glPointParameterfv := TglPointParameterfv(glProcedure('glPointParameterfv'{$IFDEF CLR}, typeof(TglPointParameterfv){$ENDIF}));
  glPointParameteri := TglPointParameteri(glProcedure('glPointParameteri'{$IFDEF CLR}, typeof(TglPointParameteri){$ENDIF}));
  glPointParameteriv := TglPointParameteriv(glProcedure('glPointParameteriv'{$IFDEF CLR}, typeof(TglPointParameteriv){$ENDIF}));
  glSecondaryColor3b := TglSecondaryColor3b(glProcedure('glSecondaryColor3b'{$IFDEF CLR}, typeof(TglSecondaryColor3b){$ENDIF}));
  glSecondaryColor3bv := TglSecondaryColor3bv(glProcedure('glSecondaryColor3bv'{$IFDEF CLR}, typeof(TglSecondaryColor3bv){$ENDIF}));
  glSecondaryColor3d := TglSecondaryColor3d(glProcedure('glSecondaryColor3d'{$IFDEF CLR}, typeof(TglSecondaryColor3d){$ENDIF}));
  glSecondaryColor3dv := TglSecondaryColor3dv(glProcedure('glSecondaryColor3dv'{$IFDEF CLR}, typeof(TglSecondaryColor3dv){$ENDIF}));
  glSecondaryColor3f := TglSecondaryColor3f(glProcedure('glSecondaryColor3f'{$IFDEF CLR}, typeof(TglSecondaryColor3f){$ENDIF}));
  glSecondaryColor3fv := TglSecondaryColor3fv(glProcedure('glSecondaryColor3fv'{$IFDEF CLR}, typeof(TglSecondaryColor3fv){$ENDIF}));
  glSecondaryColor3i := TglSecondaryColor3i(glProcedure('glSecondaryColor3i'{$IFDEF CLR}, typeof(TglSecondaryColor3i){$ENDIF}));
  glSecondaryColor3iv := TglSecondaryColor3iv(glProcedure('glSecondaryColor3iv'{$IFDEF CLR}, typeof(TglSecondaryColor3iv){$ENDIF}));
  glSecondaryColor3s := TglSecondaryColor3s(glProcedure('glSecondaryColor3s'{$IFDEF CLR}, typeof(TglSecondaryColor3s){$ENDIF}));
  glSecondaryColor3sv := TglSecondaryColor3sv(glProcedure('glSecondaryColor3sv'{$IFDEF CLR}, typeof(TglSecondaryColor3sv){$ENDIF}));
  glSecondaryColor3ub := TglSecondaryColor3ub(glProcedure('glSecondaryColor3ub'{$IFDEF CLR}, typeof(TglSecondaryColor3ub){$ENDIF}));
  glSecondaryColor3ubv := TglSecondaryColor3ubv(glProcedure('glSecondaryColor3ubv'{$IFDEF CLR}, typeof(TglSecondaryColor3ubv){$ENDIF}));
  glSecondaryColor3ui := TglSecondaryColor3ui(glProcedure('glSecondaryColor3ui'{$IFDEF CLR}, typeof(TglSecondaryColor3ui){$ENDIF}));
  glSecondaryColor3uiv := TglSecondaryColor3uiv(glProcedure('glSecondaryColor3uiv'{$IFDEF CLR}, typeof(TglSecondaryColor3uiv){$ENDIF}));
  glSecondaryColor3us := TglSecondaryColor3us(glProcedure('glSecondaryColor3us'{$IFDEF CLR}, typeof(TglSecondaryColor3us){$ENDIF}));
  glSecondaryColor3usv := TglSecondaryColor3usv(glProcedure('glSecondaryColor3usv'{$IFDEF CLR}, typeof(TglSecondaryColor3usv){$ENDIF}));
  glSecondaryColorPointer := TglSecondaryColorPointer(glProcedure('glSecondaryColorPointer'{$IFDEF CLR}, typeof(TglSecondaryColorPointer){$ENDIF}));
  glWindowPos2d := TglWindowPos2d(glProcedure('glWindowPos2d'{$IFDEF CLR}, typeof(TglWindowPos2d){$ENDIF}));
  glWindowPos2dv := TglWindowPos2dv(glProcedure('glWindowPos2dv'{$IFDEF CLR}, typeof(TglWindowPos2dv){$ENDIF}));
  glWindowPos2f := TglWindowPos2f(glProcedure('glWindowPos2f'{$IFDEF CLR}, typeof(TglWindowPos2f){$ENDIF}));
  glWindowPos2fv := TglWindowPos2fv(glProcedure('glWindowPos2fv'{$IFDEF CLR}, typeof(TglWindowPos2fv){$ENDIF}));
  glWindowPos2i := TglWindowPos2i(glProcedure('glWindowPos2i'{$IFDEF CLR}, typeof(TglWindowPos2i){$ENDIF}));
  glWindowPos2iv := TglWindowPos2iv(glProcedure('glWindowPos2iv'{$IFDEF CLR}, typeof(TglWindowPos2iv){$ENDIF}));
  glWindowPos2s := TglWindowPos2s(glProcedure('glWindowPos2s'{$IFDEF CLR}, typeof(TglWindowPos2s){$ENDIF}));
  glWindowPos2sv := TglWindowPos2sv(glProcedure('glWindowPos2sv'{$IFDEF CLR}, typeof(TglWindowPos2sv){$ENDIF}));
  glWindowPos3d := TglWindowPos3d(glProcedure('glWindowPos3d'{$IFDEF CLR}, typeof(TglWindowPos3d){$ENDIF}));
  glWindowPos3dv := TglWindowPos3dv(glProcedure('glWindowPos3dv'{$IFDEF CLR}, typeof(TglWindowPos3dv){$ENDIF}));
  glWindowPos3f := TglWindowPos3f(glProcedure('glWindowPos3f'{$IFDEF CLR}, typeof(TglWindowPos3f){$ENDIF}));
  glWindowPos3fv := TglWindowPos3fv(glProcedure('glWindowPos3fv'{$IFDEF CLR}, typeof(TglWindowPos3fv){$ENDIF}));
  glWindowPos3i := TglWindowPos3i(glProcedure('glWindowPos3i'{$IFDEF CLR}, typeof(TglWindowPos3i){$ENDIF}));
  glWindowPos3iv := TglWindowPos3iv(glProcedure('glWindowPos3iv'{$IFDEF CLR}, typeof(TglWindowPos3iv){$ENDIF}));
  glWindowPos3s := TglWindowPos3s(glProcedure('glWindowPos3s'{$IFDEF CLR}, typeof(TglWindowPos3s){$ENDIF}));
  glWindowPos3sv := TglWindowPos3sv(glProcedure('glWindowPos3sv'{$IFDEF CLR}, typeof(TglWindowPos3sv){$ENDIF}));

  // GL_VERSION_1_5
  glGenQueries := TglGenQueries(glProcedure('glGenQueries'{$IFDEF CLR}, typeof(TglGenQueries){$ENDIF}));
  glDeleteQueries := TglDeleteQueries(glProcedure('glDeleteQueries'{$IFDEF CLR}, typeof(TglDeleteQueries){$ENDIF}));
  glIsQuery := TglIsQuery(glProcedure('glIsQuery'{$IFDEF CLR}, typeof(TglIsQuery){$ENDIF}));
  glBeginQuery := TglBeginQuery(glProcedure('glBeginQuery'{$IFDEF CLR}, typeof(TglBeginQuery){$ENDIF}));
  glEndQuery := TglEndQuery(glProcedure('glEndQuery'{$IFDEF CLR}, typeof(TglEndQuery){$ENDIF}));
  glGetQueryiv := TglGetQueryiv(glProcedure('glGetQueryiv'{$IFDEF CLR}, typeof(TglGetQueryiv){$ENDIF}));
  glGetQueryObjectiv := TglGetQueryObjectiv(glProcedure('glGetQueryObjectiv'{$IFDEF CLR}, typeof(TglGetQueryObjectiv){$ENDIF}));
  glGetQueryObjectuiv := TglGetQueryObjectuiv(glProcedure('glGetQueryObjectuiv'{$IFDEF CLR}, typeof(TglGetQueryObjectuiv){$ENDIF}));

  glBindBuffer := TglBindBuffer(glProcedure('glBindBuffer'{$IFDEF CLR}, typeof(TglBindBuffer){$ENDIF}));
  glDeleteBuffers := TglDeleteBuffers(glProcedure('glDeleteBuffers'{$IFDEF CLR}, typeof(TglDeleteBuffers){$ENDIF}));
  glGenBuffers := TglGenBuffers(glProcedure('glGenBuffers'{$IFDEF CLR}, typeof(TglGenBuffers){$ENDIF}));
  glIsBuffer := TglIsBuffer(glProcedure('glIsBuffer'{$IFDEF CLR}, typeof(TglIsBuffer){$ENDIF}));
  _glBufferData := TglBufferData(glProcedure('glBufferData'{$IFDEF CLR}, typeof(TglBufferData){$ENDIF}));
  _glBufferSubData := TglBufferSubData(glProcedure('glBufferSubData'{$IFDEF CLR}, typeof(TglBufferSubData){$ENDIF}));
  glGetBufferSubData := TglGetBufferSubData(glProcedure('glGetBufferSubData'{$IFDEF CLR}, typeof(TglGetBufferSubData){$ENDIF}));
  glMapBuffer := TglMapBuffer(glProcedure('glMapBuffer'{$IFDEF CLR}, typeof(TglMapBuffer){$ENDIF}));
  glUnmapBuffer := TglUnmapBuffer(glProcedure('glUnmapBuffer'{$IFDEF CLR}, typeof(TglUnmapBuffer){$ENDIF}));
  glGetBufferParameteriv := TglGetBufferParameteriv(glProcedure('glGetBufferParameteriv'{$IFDEF CLR}, typeof(TglGetBufferParameteriv){$ENDIF}));
  glGetBufferPointerv := TglGetBufferPointerv(glProcedure('glGetBufferPointerv'{$IFDEF CLR}, typeof(TglGetBufferPointerv){$ENDIF}));

  // GL_VERSION_2_0
  glBlendEquationSeparate := TglBlendEquationSeparate(glProcedure('glBlendEquationSeparate'{$IFDEF CLR}, typeof(TglBlendEquationSeparate){$ENDIF}));
  glDrawBuffers := TglDrawBuffers(glProcedure('glDrawBuffers'{$IFDEF CLR}, typeof(TglDrawBuffers){$ENDIF}));
  glStencilOpSeparate := TglStencilOpSeparate(glProcedure('glStencilOpSeparate'{$IFDEF CLR}, typeof(TglStencilOpSeparate){$ENDIF}));
  glStencilFuncSeparate := TglStencilFuncSeparate(glProcedure('glStencilFuncSeparate'{$IFDEF CLR}, typeof(TglStencilFuncSeparate){$ENDIF}));
  glStencilMaskSeparate := TglStencilMaskSeparate(glProcedure('glStencilMaskSeparate'{$IFDEF CLR}, typeof(TglStencilMaskSeparate){$ENDIF}));
  glAttachShader := TglAttachShader(glProcedure('glAttachShader'{$IFDEF CLR}, typeof(TglAttachShader){$ENDIF}));
  glBindAttribLocation := TglBindAttribLocation(glProcedure('glBindAttribLocation'{$IFDEF CLR}, typeof(TglBindAttribLocation){$ENDIF}));
  glCompileShader := TglCompileShader(glProcedure('glCompileShader'{$IFDEF CLR}, typeof(TglCompileShader){$ENDIF}));
  glCreateProgram := TglCreateProgram(glProcedure('glCreateProgram'{$IFDEF CLR}, typeof(TglCreateProgram){$ENDIF}));
  glCreateShader := TglCreateShader(glProcedure('glCreateShader'{$IFDEF CLR}, typeof(TglCreateShader){$ENDIF}));
  glDeleteProgram := TglDeleteProgram(glProcedure('glDeleteProgram'{$IFDEF CLR}, typeof(TglDeleteProgram){$ENDIF}));
  glDeleteShader := TglDeleteShader(glProcedure('glDeleteShader'{$IFDEF CLR}, typeof(TglDeleteShader){$ENDIF}));
  glDetachShader := TglDetachShader(glProcedure('glDetachShader'{$IFDEF CLR}, typeof(TglDetachShader){$ENDIF}));
  glDisableVertexAttribArray := TglDisableVertexAttribArray(glProcedure('glDisableVertexAttribArray'{$IFDEF CLR}, typeof(TglDisableVertexAttribArray){$ENDIF}));
  glEnableVertexAttribArray := TglEnableVertexAttribArray(glProcedure('glEnableVertexAttribArray'{$IFDEF CLR}, typeof(TglEnableVertexAttribArray){$ENDIF}));
  glGetActiveAttrib := TglGetActiveAttrib(glProcedure('glGetActiveAttrib'{$IFDEF CLR}, typeof(TglGetActiveAttrib){$ENDIF}));
  glGetActiveUniform := TglGetActiveUniform(glProcedure('glGetActiveUniform'{$IFDEF CLR}, typeof(TglGetActiveUniform){$ENDIF}));
  glGetAttachedShaders := TglGetAttachedShaders(glProcedure('glGetAttachedShaders'{$IFDEF CLR}, typeof(TglGetAttachedShaders){$ENDIF}));
  glGetAttribLocation := TglGetAttribLocation(glProcedure('glGetAttribLocation'{$IFDEF CLR}, typeof(TglGetAttribLocation){$ENDIF}));
  glGetProgramiv := TglGetProgramiv(glProcedure('glGetProgramiv'{$IFDEF CLR}, typeof(TglGetProgramiv){$ENDIF}));
  _glGetProgramInfoLog := TglGetProgramInfoLog(glProcedure('glGetProgramInfoLog'{$IFDEF CLR}, typeof(TglGetProgramInfoLog){$ENDIF}));
  glGetShaderiv := TglGetShaderiv(glProcedure('glGetShaderiv'{$IFDEF CLR}, typeof(TglGetShaderiv){$ENDIF}));
  _glGetShaderInfoLog := TglGetShaderInfoLog(glProcedure('glGetShaderInfoLog'{$IFDEF CLR}, typeof(TglGetShaderInfoLog){$ENDIF}));
  glGetShaderSource := TglGetShaderSource(glProcedure('glGetShaderSource'{$IFDEF CLR}, typeof(TglGetShaderSource){$ENDIF}));
  glGetUniformLocation := TglGetUniformLocation(glProcedure('glGetUniformLocation'{$IFDEF CLR}, typeof(TglGetUniformLocation){$ENDIF}));
  glGetUniformfv := TglGetUniformfv(glProcedure('glGetUniformfv'{$IFDEF CLR}, typeof(TglGetUniformfv){$ENDIF}));
  glGetUniformiv := TglGetUniformiv(glProcedure('glGetUniformiv'{$IFDEF CLR}, typeof(TglGetUniformiv){$ENDIF}));
  glGetVertexAttribfv := TglGetVertexAttribfv(glProcedure('glGetVertexAttribfv'{$IFDEF CLR}, typeof(TglGetVertexAttribfv){$ENDIF}));
  glGetVertexAttribiv := TglGetVertexAttribiv(glProcedure('glGetVertexAttribiv'{$IFDEF CLR}, typeof(TglGetVertexAttribiv){$ENDIF}));
  glGetVertexAttribPointerv := TglGetVertexAttribPointerv(glProcedure('glGetVertexAttribPointerv'{$IFDEF CLR}, typeof(TglGetVertexAttribPointerv){$ENDIF}));
  glIsProgram := TglIsProgram(glProcedure('glIsProgram'{$IFDEF CLR}, typeof(TglIsProgram){$ENDIF}));
  glIsShader := TglIsShader(glProcedure('glIsShader'{$IFDEF CLR}, typeof(TglIsShader){$ENDIF}));
  glLinkProgram := TglLinkProgram(glProcedure('glLinkProgram'{$IFDEF CLR}, typeof(TglLinkProgram){$ENDIF}));
  _glShaderSource := TglShaderSource(glProcedure('glShaderSource'{$IFDEF CLR}, typeof(TglShaderSource){$ENDIF}));
  glUseProgram := TglUseProgram(glProcedure('glUseProgram'{$IFDEF CLR}, typeof(TglUseProgram){$ENDIF}));
  glUniform1f := TglUniform1f(glProcedure('glUniform1f'{$IFDEF CLR}, typeof(TglUniform1f){$ENDIF}));
  glUniform2f := TglUniform2f(glProcedure('glUniform2f'{$IFDEF CLR}, typeof(TglUniform2f){$ENDIF}));
  glUniform3f := TglUniform3f(glProcedure('glUniform3f'{$IFDEF CLR}, typeof(TglUniform3f){$ENDIF}));
  glUniform4f := TglUniform4f(glProcedure('glUniform4f'{$IFDEF CLR}, typeof(TglUniform4f){$ENDIF}));
  glUniform1i := TglUniform1i(glProcedure('glUniform1i'{$IFDEF CLR}, typeof(TglUniform1i){$ENDIF}));
  glUniform2i := TglUniform2i(glProcedure('glUniform2i'{$IFDEF CLR}, typeof(TglUniform2i){$ENDIF}));
  glUniform3i := TglUniform3i(glProcedure('glUniform3i'{$IFDEF CLR}, typeof(TglUniform3i){$ENDIF}));
  glUniform4i := TglUniform4i(glProcedure('glUniform4i'{$IFDEF CLR}, typeof(TglUniform4i){$ENDIF}));
  glUniform1fv := TglUniform1fv(glProcedure('glUniform1fv'{$IFDEF CLR}, typeof(TglUniform1fv){$ENDIF}));
  glUniform2fv := TglUniform2fv(glProcedure('glUniform2fv'{$IFDEF CLR}, typeof(TglUniform2fv){$ENDIF}));
  glUniform3fv := TglUniform3fv(glProcedure('glUniform3fv'{$IFDEF CLR}, typeof(TglUniform3fv){$ENDIF}));
  glUniform4fv := TglUniform4fv(glProcedure('glUniform4fv'{$IFDEF CLR}, typeof(TglUniform4fv){$ENDIF}));
  glUniform1iv := TglUniform1iv(glProcedure('glUniform1iv'{$IFDEF CLR}, typeof(TglUniform1iv){$ENDIF}));
  glUniform2iv := TglUniform2iv(glProcedure('glUniform2iv'{$IFDEF CLR}, typeof(TglUniform2iv){$ENDIF}));
  glUniform3iv := TglUniform3iv(glProcedure('glUniform3iv'{$IFDEF CLR}, typeof(TglUniform3iv){$ENDIF}));
  glUniform4iv := TglUniform4iv(glProcedure('glUniform4iv'{$IFDEF CLR}, typeof(TglUniform4iv){$ENDIF}));
  glUniformMatrix2fv := TglUniformMatrix2fv(glProcedure('glUniformMatrix2fv'{$IFDEF CLR}, typeof(TglUniformMatrix2fv){$ENDIF}));
  glUniformMatrix3fv := TglUniformMatrix3fv(glProcedure('glUniformMatrix3fv'{$IFDEF CLR}, typeof(TglUniformMatrix3fv){$ENDIF}));
  glUniformMatrix4fv := TglUniformMatrix4fv(glProcedure('glUniformMatrix4fv'{$IFDEF CLR}, typeof(TglUniformMatrix4fv){$ENDIF}));
  glValidateProgram := TglValidateProgram(glProcedure('glValidateProgram'{$IFDEF CLR}, typeof(TglValidateProgram){$ENDIF}));
  glVertexAttrib1d := TglVertexAttrib1d(glProcedure('glVertexAttrib1d'{$IFDEF CLR}, typeof(TglVertexAttrib1d){$ENDIF}));
  glVertexAttrib1dv := TglVertexAttrib1dv(glProcedure('glVertexAttrib1dv'{$IFDEF CLR}, typeof(TglVertexAttrib1dv){$ENDIF}));
  glVertexAttrib1f := TglVertexAttrib1f(glProcedure('glVertexAttrib1f'{$IFDEF CLR}, typeof(TglVertexAttrib1f){$ENDIF}));
  glVertexAttrib1fv := TglVertexAttrib1fv(glProcedure('glVertexAttrib1fv'{$IFDEF CLR}, typeof(TglVertexAttrib1fv){$ENDIF}));
  glVertexAttrib1s := TglVertexAttrib1s(glProcedure('glVertexAttrib1s'{$IFDEF CLR}, typeof(TglVertexAttrib1s){$ENDIF}));
  glVertexAttrib1sv := TglVertexAttrib1sv(glProcedure('glVertexAttrib1sv'{$IFDEF CLR}, typeof(TglVertexAttrib1sv){$ENDIF}));
  glVertexAttrib2d := TglVertexAttrib2d(glProcedure('glVertexAttrib2d'{$IFDEF CLR}, typeof(TglVertexAttrib2d){$ENDIF}));
  glVertexAttrib2dv := TglVertexAttrib2dv(glProcedure('glVertexAttrib2dv'{$IFDEF CLR}, typeof(TglVertexAttrib2dv){$ENDIF}));
  glVertexAttrib2f := TglVertexAttrib2f(glProcedure('glVertexAttrib2f'{$IFDEF CLR}, typeof(TglVertexAttrib2f){$ENDIF}));
  glVertexAttrib2fv := TglVertexAttrib2fv(glProcedure('glVertexAttrib2fv'{$IFDEF CLR}, typeof(TglVertexAttrib2fv){$ENDIF}));
  glVertexAttrib2s := TglVertexAttrib2s(glProcedure('glVertexAttrib2s'{$IFDEF CLR}, typeof(TglVertexAttrib2s){$ENDIF}));
  glVertexAttrib2sv := TglVertexAttrib2sv(glProcedure('glVertexAttrib2sv'{$IFDEF CLR}, typeof(TglVertexAttrib2sv){$ENDIF}));
  glVertexAttrib3d := TglVertexAttrib3d(glProcedure('glVertexAttrib3d'{$IFDEF CLR}, typeof(TglVertexAttrib3d){$ENDIF}));
  glVertexAttrib3dv := TglVertexAttrib3dv(glProcedure('glVertexAttrib3dv'{$IFDEF CLR}, typeof(TglVertexAttrib3dv){$ENDIF}));
  glVertexAttrib3f := TglVertexAttrib3f(glProcedure('glVertexAttrib3f'{$IFDEF CLR}, typeof(TglVertexAttrib3f){$ENDIF}));
  glVertexAttrib3fv := TglVertexAttrib3fv(glProcedure('glVertexAttrib3fv'{$IFDEF CLR}, typeof(TglVertexAttrib3fv){$ENDIF}));
  glVertexAttrib3s := TglVertexAttrib3s(glProcedure('glVertexAttrib3s'{$IFDEF CLR}, typeof(TglVertexAttrib3s){$ENDIF}));
  glVertexAttrib3sv := TglVertexAttrib3sv(glProcedure('glVertexAttrib3sv'{$IFDEF CLR}, typeof(TglVertexAttrib3sv){$ENDIF}));
  glVertexAttrib4Nbv := TglVertexAttrib4Nbv(glProcedure('glVertexAttrib4Nbv'{$IFDEF CLR}, typeof(TglVertexAttrib4Nbv){$ENDIF}));
  glVertexAttrib4Niv := TglVertexAttrib4Niv(glProcedure('glVertexAttrib4Niv'{$IFDEF CLR}, typeof(TglVertexAttrib4Niv){$ENDIF}));
  glVertexAttrib4Nsv := TglVertexAttrib4Nsv(glProcedure('glVertexAttrib4Nsv'{$IFDEF CLR}, typeof(TglVertexAttrib4Nsv){$ENDIF}));
  glVertexAttrib4Nub := TglVertexAttrib4Nub(glProcedure('glVertexAttrib4Nub'{$IFDEF CLR}, typeof(TglVertexAttrib4Nub){$ENDIF}));
  glVertexAttrib4Nubv := TglVertexAttrib4Nubv(glProcedure('glVertexAttrib4Nubv'{$IFDEF CLR}, typeof(TglVertexAttrib4Nubv){$ENDIF}));
  glVertexAttrib4Nuiv := TglVertexAttrib4Nuiv(glProcedure('glVertexAttrib4Nuiv'{$IFDEF CLR}, typeof(TglVertexAttrib4Nuiv){$ENDIF}));
  glVertexAttrib4Nusv := TglVertexAttrib4Nusv(glProcedure('glVertexAttrib4Nusv'{$IFDEF CLR}, typeof(TglVertexAttrib4Nusv){$ENDIF}));
  glVertexAttrib4bv := TglVertexAttrib4bv(glProcedure('glVertexAttrib4bv'{$IFDEF CLR}, typeof(TglVertexAttrib4bv){$ENDIF}));
  glVertexAttrib4d := TglVertexAttrib4d(glProcedure('glVertexAttrib4d'{$IFDEF CLR}, typeof(TglVertexAttrib4d){$ENDIF}));
  glVertexAttrib4dv := TglVertexAttrib4dv(glProcedure('glVertexAttrib4dv'{$IFDEF CLR}, typeof(TglVertexAttrib4dv){$ENDIF}));
  glVertexAttrib4f := TglVertexAttrib4f(glProcedure('glVertexAttrib4f'{$IFDEF CLR}, typeof(TglVertexAttrib4f){$ENDIF}));
  glVertexAttrib4fv := TglVertexAttrib4fv(glProcedure('glVertexAttrib4fv'{$IFDEF CLR}, typeof(TglVertexAttrib4fv){$ENDIF}));
  glVertexAttrib4iv := TglVertexAttrib4iv(glProcedure('glVertexAttrib4iv'{$IFDEF CLR}, typeof(TglVertexAttrib4iv){$ENDIF}));
  glVertexAttrib4s := TglVertexAttrib4s(glProcedure('glVertexAttrib4s'{$IFDEF CLR}, typeof(TglVertexAttrib4s){$ENDIF}));
  glVertexAttrib4sv := TglVertexAttrib4sv(glProcedure('glVertexAttrib4sv'{$IFDEF CLR}, typeof(TglVertexAttrib4sv){$ENDIF}));
  glVertexAttrib4ubv := TglVertexAttrib4ubv(glProcedure('glVertexAttrib4ubv'{$IFDEF CLR}, typeof(TglVertexAttrib4ubv){$ENDIF}));
  glVertexAttrib4uiv := TglVertexAttrib4uiv(glProcedure('glVertexAttrib4uiv'{$IFDEF CLR}, typeof(TglVertexAttrib4uiv){$ENDIF}));
  glVertexAttrib4usv := TglVertexAttrib4usv(glProcedure('glVertexAttrib4usv'{$IFDEF CLR}, typeof(TglVertexAttrib4usv){$ENDIF}));
  glVertexAttribPointer := TglVertexAttribPointer(glProcedure('glVertexAttribPointer'{$IFDEF CLR}, typeof(TglVertexAttribPointer){$ENDIF}));
end;

procedure Read_GL_3DFX_tbuffer;
begin
  glTbufferMask3DFX := TglTbufferMask3DFX(wglGetProcAddress('glTbufferMask3DFX'{$IFDEF CLR}, typeof(TglTbufferMask3DFX){$ENDIF}));
end;

procedure Read_GL_APPLE_element_array;
begin
  glElementPointerAPPLE := TglElementPointerAPPLE(wglGetProcAddress('glElementPointerAPPLE'{$IFDEF CLR}, typeof(TglElementPointerAPPLE){$ENDIF}));
  glDrawElementArrayAPPLE := TglDrawElementArrayAPPLE(wglGetProcAddress('glDrawElementArrayAPPLE'{$IFDEF CLR}, typeof(TglDrawElementArrayAPPLE){$ENDIF}));
  glDrawRangeElementArrayAPPLE := TglDrawRangeElementArrayAPPLE(wglGetProcAddress('glDrawRangeElementArrayAPPLE'{$IFDEF CLR}, typeof(TglDrawRangeElementArrayAPPLE){$ENDIF}));
  glMultiDrawElementArrayAPPLE := TglMultiDrawElementArrayAPPLE(wglGetProcAddress('glMultiDrawElementArrayAPPLE'{$IFDEF CLR}, typeof(TglMultiDrawElementArrayAPPLE){$ENDIF}));
  glMultiDrawRangeElementArrayAPPLE := TglMultiDrawRangeElementArrayAPPLE(wglGetProcAddress('glMultiDrawRangeElementArrayAPPLE'{$IFDEF CLR}, typeof(TglMultiDrawRangeElementArrayAPPLE){$ENDIF}));
end;

procedure Read_GL_APPLE_fence;
begin
  glGenFencesAPPLE := TglGenFencesAPPLE(wglGetProcAddress('glGenFencesAPPLE'{$IFDEF CLR}, typeof(TglGenFencesAPPLE){$ENDIF}));
  glDeleteFencesAPPLE := TglDeleteFencesAPPLE(wglGetProcAddress('glDeleteFencesAPPLE'{$IFDEF CLR}, typeof(TglDeleteFencesAPPLE){$ENDIF}));
  glSetFenceAPPLE := TglSetFenceAPPLE(wglGetProcAddress('glSetFenceAPPLE'{$IFDEF CLR}, typeof(TglSetFenceAPPLE){$ENDIF}));
  glIsFenceAPPLE := TglIsFenceAPPLE(wglGetProcAddress('glIsFenceAPPLE'{$IFDEF CLR}, typeof(TglIsFenceAPPLE){$ENDIF}));
  glTestFenceAPPLE := TglTestFenceAPPLE(wglGetProcAddress('glTestFenceAPPLE'{$IFDEF CLR}, typeof(TglTestFenceAPPLE){$ENDIF}));
  glFinishFenceAPPLE := TglFinishFenceAPPLE(wglGetProcAddress('glFinishFenceAPPLE'{$IFDEF CLR}, typeof(TglFinishFenceAPPLE){$ENDIF}));
  glTestObjectAPPLE := TglTestObjectAPPLE(wglGetProcAddress('glTestObjectAPPLE'{$IFDEF CLR}, typeof(TglTestObjectAPPLE){$ENDIF}));
  glFinishObjectAPPLE := TglFinishObjectAPPLE(wglGetProcAddress('glFinishObjectAPPLE'{$IFDEF CLR}, typeof(TglFinishObjectAPPLE){$ENDIF}));
end;

procedure Read_GL_APPLE_vertex_array_object;
begin
  glBindVertexArrayAPPLE := TglBindVertexArrayAPPLE(wglGetProcAddress('glBindVertexArrayAPPLE'{$IFDEF CLR}, typeof(TglBindVertexArrayAPPLE){$ENDIF}));
  glDeleteVertexArraysAPPLE := TglDeleteVertexArraysAPPLE(wglGetProcAddress('glDeleteVertexArraysAPPLE'{$IFDEF CLR}, typeof(TglDeleteVertexArraysAPPLE){$ENDIF}));
  glGenVertexArraysAPPLE := TglGenVertexArraysAPPLE(wglGetProcAddress('glGenVertexArraysAPPLE'{$IFDEF CLR}, typeof(TglGenVertexArraysAPPLE){$ENDIF}));
  glIsVertexArrayAPPLE := TglIsVertexArrayAPPLE(wglGetProcAddress('glIsVertexArrayAPPLE'{$IFDEF CLR}, typeof(TglIsVertexArrayAPPLE){$ENDIF}));
end;

procedure Read_GL_APPLE_vertex_array_range;
begin
  glVertexArrayRangeAPPLE := TglVertexArrayRangeAPPLE(wglGetProcAddress('glVertexArrayRangeAPPLE'{$IFDEF CLR}, typeof(TglVertexArrayRangeAPPLE){$ENDIF}));
  glFlushVertexArrayRangeAPPLE := TglFlushVertexArrayRangeAPPLE(wglGetProcAddress('glFlushVertexArrayRangeAPPLE'{$IFDEF CLR}, typeof(TglFlushVertexArrayRangeAPPLE){$ENDIF}));
  glVertexArrayParameteriAPPLE := TglVertexArrayParameteriAPPLE(wglGetProcAddress('glVertexArrayParameteriAPPLE'{$IFDEF CLR}, typeof(TglVertexArrayParameteriAPPLE){$ENDIF}));
end;

procedure Read_GL_ARB_matrix_palette;
begin
  glCurrentPaletteMatrixARB := TglCurrentPaletteMatrixARB(wglGetProcAddress('glCurrentPaletteMatrixARB'{$IFDEF CLR}, typeof(TglCurrentPaletteMatrixARB){$ENDIF}));
  glMatrixIndexubvARB := TglMatrixIndexubvARB(wglGetProcAddress('glMatrixIndexubvARB'{$IFDEF CLR}, typeof(TglMatrixIndexubvARB){$ENDIF}));
  glMatrixIndexusvARB := TglMatrixIndexusvARB(wglGetProcAddress('glMatrixIndexusvARB'{$IFDEF CLR}, typeof(TglMatrixIndexusvARB){$ENDIF}));
  glMatrixIndexuivARB := TglMatrixIndexuivARB(wglGetProcAddress('glMatrixIndexuivARB'{$IFDEF CLR}, typeof(TglMatrixIndexuivARB){$ENDIF}));
  glMatrixIndexPointerARB := TglMatrixIndexPointerARB(wglGetProcAddress('glMatrixIndexPointerARB'{$IFDEF CLR}, typeof(TglMatrixIndexPointerARB){$ENDIF}));
end;

procedure Read_GL_ARB_multisample;
begin
  glSampleCoverageARB := TglSampleCoverageARB(wglGetProcAddress('glSampleCoverageARB'{$IFDEF CLR}, typeof(TglSampleCoverageARB){$ENDIF}));
end;

procedure Read_GL_ARB_multitexture;
begin
  glActiveTextureARB := TglActiveTextureARB(wglGetProcAddress('glActiveTextureARB'{$IFDEF CLR}, typeof(TglActiveTextureARB){$ENDIF}));
  glClientActiveTextureARB := TglClientActiveTextureARB(wglGetProcAddress('glClientActiveTextureARB'{$IFDEF CLR}, typeof(TglClientActiveTextureARB){$ENDIF}));
  glMultiTexCoord1dARB := TglMultiTexCoord1dARB(wglGetProcAddress('glMultiTexCoord1dARB'{$IFDEF CLR}, typeof(TglMultiTexCoord1dARB){$ENDIF}));
  glMultiTexCoord1dvARB := TglMultiTexCoord1dvARB(wglGetProcAddress('glMultiTexCoord1dvARB'{$IFDEF CLR}, typeof(TglMultiTexCoord1dvARB){$ENDIF}));
  glMultiTexCoord1fARB := TglMultiTexCoord1fARB(wglGetProcAddress('glMultiTexCoord1fARB'{$IFDEF CLR}, typeof(TglMultiTexCoord1fARB){$ENDIF}));
  glMultiTexCoord1fvARB := TglMultiTexCoord1fvARB(wglGetProcAddress('glMultiTexCoord1fvARB'{$IFDEF CLR}, typeof(TglMultiTexCoord1fvARB){$ENDIF}));
  glMultiTexCoord1iARB := TglMultiTexCoord1iARB(wglGetProcAddress('glMultiTexCoord1iARB'{$IFDEF CLR}, typeof(TglMultiTexCoord1iARB){$ENDIF}));
  glMultiTexCoord1ivARB := TglMultiTexCoord1ivARB(wglGetProcAddress('glMultiTexCoord1ivARB'{$IFDEF CLR}, typeof(TglMultiTexCoord1ivARB){$ENDIF}));
  glMultiTexCoord1sARB := TglMultiTexCoord1sARB(wglGetProcAddress('glMultiTexCoord1sARB'{$IFDEF CLR}, typeof(TglMultiTexCoord1sARB){$ENDIF}));
  glMultiTexCoord1svARB := TglMultiTexCoord1svARB(wglGetProcAddress('glMultiTexCoord1svARB'{$IFDEF CLR}, typeof(TglMultiTexCoord1svARB){$ENDIF}));
  glMultiTexCoord2dARB := TglMultiTexCoord2dARB(wglGetProcAddress('glMultiTexCoord2dARB'{$IFDEF CLR}, typeof(TglMultiTexCoord2dARB){$ENDIF}));
  glMultiTexCoord2dvARB := TglMultiTexCoord2dvARB(wglGetProcAddress('glMultiTexCoord2dvARB'{$IFDEF CLR}, typeof(TglMultiTexCoord2dvARB){$ENDIF}));
  glMultiTexCoord2fARB := TglMultiTexCoord2fARB(wglGetProcAddress('glMultiTexCoord2fARB'{$IFDEF CLR}, typeof(TglMultiTexCoord2fARB){$ENDIF}));
  glMultiTexCoord2fvARB := TglMultiTexCoord2fvARB(wglGetProcAddress('glMultiTexCoord2fvARB'{$IFDEF CLR}, typeof(TglMultiTexCoord2fvARB){$ENDIF}));
  glMultiTexCoord2iARB := TglMultiTexCoord2iARB(wglGetProcAddress('glMultiTexCoord2iARB'{$IFDEF CLR}, typeof(TglMultiTexCoord2iARB){$ENDIF}));
  glMultiTexCoord2ivARB := TglMultiTexCoord2ivARB(wglGetProcAddress('glMultiTexCoord2ivARB'{$IFDEF CLR}, typeof(TglMultiTexCoord2ivARB){$ENDIF}));
  glMultiTexCoord2sARB := TglMultiTexCoord2sARB(wglGetProcAddress('glMultiTexCoord2sARB'{$IFDEF CLR}, typeof(TglMultiTexCoord2sARB){$ENDIF}));
  glMultiTexCoord2svARB := TglMultiTexCoord2svARB(wglGetProcAddress('glMultiTexCoord2svARB'{$IFDEF CLR}, typeof(TglMultiTexCoord2svARB){$ENDIF}));
  glMultiTexCoord3dARB := TglMultiTexCoord3dARB(wglGetProcAddress('glMultiTexCoord3dARB'{$IFDEF CLR}, typeof(TglMultiTexCoord3dARB){$ENDIF}));
  glMultiTexCoord3dvARB := TglMultiTexCoord3dvARB(wglGetProcAddress('glMultiTexCoord3dvARB'{$IFDEF CLR}, typeof(TglMultiTexCoord3dvARB){$ENDIF}));
  glMultiTexCoord3fARB := TglMultiTexCoord3fARB(wglGetProcAddress('glMultiTexCoord3fARB'{$IFDEF CLR}, typeof(TglMultiTexCoord3fARB){$ENDIF}));
  glMultiTexCoord3fvARB := TglMultiTexCoord3fvARB(wglGetProcAddress('glMultiTexCoord3fvARB'{$IFDEF CLR}, typeof(TglMultiTexCoord3fvARB){$ENDIF}));
  glMultiTexCoord3iARB := TglMultiTexCoord3iARB(wglGetProcAddress('glMultiTexCoord3iARB'{$IFDEF CLR}, typeof(TglMultiTexCoord3iARB){$ENDIF}));
  glMultiTexCoord3ivARB := TglMultiTexCoord3ivARB(wglGetProcAddress('glMultiTexCoord3ivARB'{$IFDEF CLR}, typeof(TglMultiTexCoord3ivARB){$ENDIF}));
  glMultiTexCoord3sARB := TglMultiTexCoord3sARB(wglGetProcAddress('glMultiTexCoord3sARB'{$IFDEF CLR}, typeof(TglMultiTexCoord3sARB){$ENDIF}));
  glMultiTexCoord3svARB := TglMultiTexCoord3svARB(wglGetProcAddress('glMultiTexCoord3svARB'{$IFDEF CLR}, typeof(TglMultiTexCoord3svARB){$ENDIF}));
  glMultiTexCoord4dARB := TglMultiTexCoord4dARB(wglGetProcAddress('glMultiTexCoord4dARB'{$IFDEF CLR}, typeof(TglMultiTexCoord4dARB){$ENDIF}));
  glMultiTexCoord4dvARB := TglMultiTexCoord4dvARB(wglGetProcAddress('glMultiTexCoord4dvARB'{$IFDEF CLR}, typeof(TglMultiTexCoord4dvARB){$ENDIF}));
  glMultiTexCoord4fARB := TglMultiTexCoord4fARB(wglGetProcAddress('glMultiTexCoord4fARB'{$IFDEF CLR}, typeof(TglMultiTexCoord4fARB){$ENDIF}));
  glMultiTexCoord4fvARB := TglMultiTexCoord4fvARB(wglGetProcAddress('glMultiTexCoord4fvARB'{$IFDEF CLR}, typeof(TglMultiTexCoord4fvARB){$ENDIF}));
  glMultiTexCoord4iARB := TglMultiTexCoord4iARB(wglGetProcAddress('glMultiTexCoord4iARB'{$IFDEF CLR}, typeof(TglMultiTexCoord4iARB){$ENDIF}));
  glMultiTexCoord4ivARB := TglMultiTexCoord4ivARB(wglGetProcAddress('glMultiTexCoord4ivARB'{$IFDEF CLR}, typeof(TglMultiTexCoord4ivARB){$ENDIF}));
  glMultiTexCoord4sARB := TglMultiTexCoord4sARB(wglGetProcAddress('glMultiTexCoord4sARB'{$IFDEF CLR}, typeof(TglMultiTexCoord4sARB){$ENDIF}));
  glMultiTexCoord4svARB := TglMultiTexCoord4svARB(wglGetProcAddress('glMultiTexCoord4svARB'{$IFDEF CLR}, typeof(TglMultiTexCoord4svARB){$ENDIF}));
end;

procedure Read_GL_ARB_point_parameters;
begin
  glPointParameterfARB := TglPointParameterfARB(wglGetProcAddress('glPointParameterfARB'{$IFDEF CLR}, typeof(TglPointParameterfARB){$ENDIF}));
  glPointParameterfvARB := TglPointParameterfvARB(wglGetProcAddress('glPointParameterfvARB'{$IFDEF CLR}, typeof(TglPointParameterfvARB){$ENDIF}));
end;

procedure Read_GL_ARB_texture_compression;
begin
  glCompressedTexImage3DARB := TglCompressedTexImage3DARB(wglGetProcAddress('glCompressedTexImage3DARB'{$IFDEF CLR}, typeof(TglCompressedTexImage3DARB){$ENDIF}));
  glCompressedTexImage2DARB := TglCompressedTexImage2DARB(wglGetProcAddress('glCompressedTexImage2DARB'{$IFDEF CLR}, typeof(TglCompressedTexImage2DARB){$ENDIF}));
  glCompressedTexImage1DARB := TglCompressedTexImage1DARB(wglGetProcAddress('glCompressedTexImage1DARB'{$IFDEF CLR}, typeof(TglCompressedTexImage1DARB){$ENDIF}));
  glCompressedTexSubImage3DARB := TglCompressedTexSubImage3DARB(wglGetProcAddress('glCompressedTexSubImage3DARB'{$IFDEF CLR}, typeof(TglCompressedTexSubImage3DARB){$ENDIF}));
  glCompressedTexSubImage2DARB := TglCompressedTexSubImage2DARB(wglGetProcAddress('glCompressedTexSubImage2DARB'{$IFDEF CLR}, typeof(TglCompressedTexSubImage2DARB){$ENDIF}));
  glCompressedTexSubImage1DARB := TglCompressedTexSubImage1DARB(wglGetProcAddress('glCompressedTexSubImage1DARB'{$IFDEF CLR}, typeof(TglCompressedTexSubImage1DARB){$ENDIF}));
  glGetCompressedTexImageARB := TglGetCompressedTexImageARB(wglGetProcAddress('glGetCompressedTexImageARB'{$IFDEF CLR}, typeof(TglGetCompressedTexImageARB){$ENDIF}));
end;

procedure Read_GL_ARB_transpose_matrix;
begin
  glLoadTransposeMatrixfARB := TglLoadTransposeMatrixfARB(wglGetProcAddress('glLoadTransposeMatrixfARB'{$IFDEF CLR}, typeof(TglLoadTransposeMatrixfARB){$ENDIF}));
  glLoadTransposeMatrixdARB := TglLoadTransposeMatrixdARB(wglGetProcAddress('glLoadTransposeMatrixdARB'{$IFDEF CLR}, typeof(TglLoadTransposeMatrixdARB){$ENDIF}));
  glMultTransposeMatrixfARB := TglMultTransposeMatrixfARB(wglGetProcAddress('glMultTransposeMatrixfARB'{$IFDEF CLR}, typeof(TglMultTransposeMatrixfARB){$ENDIF}));
  glMultTransposeMatrixdARB := TglMultTransposeMatrixdARB(wglGetProcAddress('glMultTransposeMatrixdARB'{$IFDEF CLR}, typeof(TglMultTransposeMatrixdARB){$ENDIF}));
end;

procedure Read_GL_ARB_vertex_blend;
begin
  glWeightbvARB := TglWeightbvARB(wglGetProcAddress('glWeightbvARB'{$IFDEF CLR}, typeof(TglWeightbvARB){$ENDIF}));
  glWeightsvARB := TglWeightsvARB(wglGetProcAddress('glWeightsvARB'{$IFDEF CLR}, typeof(TglWeightsvARB){$ENDIF}));
  glWeightivARB := TglWeightivARB(wglGetProcAddress('glWeightivARB'{$IFDEF CLR}, typeof(TglWeightivARB){$ENDIF}));
  glWeightfvARB := TglWeightfvARB(wglGetProcAddress('glWeightfvARB'{$IFDEF CLR}, typeof(TglWeightfvARB){$ENDIF}));
  glWeightdvARB := TglWeightdvARB(wglGetProcAddress('glWeightdvARB'{$IFDEF CLR}, typeof(TglWeightdvARB){$ENDIF}));
  glWeightubvARB := TglWeightubvARB(wglGetProcAddress('glWeightubvARB'{$IFDEF CLR}, typeof(TglWeightubvARB){$ENDIF}));
  glWeightusvARB := TglWeightusvARB(wglGetProcAddress('glWeightusvARB'{$IFDEF CLR}, typeof(TglWeightusvARB){$ENDIF}));
  glWeightuivARB := TglWeightuivARB(wglGetProcAddress('glWeightuivARB'{$IFDEF CLR}, typeof(TglWeightuivARB){$ENDIF}));
  glWeightPointerARB := TglWeightPointerARB(wglGetProcAddress('glWeightPointerARB'{$IFDEF CLR}, typeof(TglWeightPointerARB){$ENDIF}));
  glVertexBlendARB := TglVertexBlendARB(wglGetProcAddress('glVertexBlendARB'{$IFDEF CLR}, typeof(TglVertexBlendARB){$ENDIF}));
end;

procedure Read_GL_ARB_buffer_object;
begin
  glBindBufferARB := TglBindBufferARB(wglGetProcAddress('glBindBufferARB'{$IFDEF CLR}, typeof(TglBindBufferARB){$ENDIF}));
  glDeleteBuffersARB := TglDeleteBuffersARB(wglGetProcAddress('glDeleteBuffersARB'{$IFDEF CLR}, typeof(TglDeleteBuffersARB){$ENDIF}));
  glGenBuffersARB := TglGenBuffersARB(wglGetProcAddress('glGenBuffersARB'{$IFDEF CLR}, typeof(TglGenBuffersARB){$ENDIF}));
  glIsBufferARB := TglIsBufferARB(wglGetProcAddress('glIsBufferARB'{$IFDEF CLR}, typeof(TglIsBufferARB){$ENDIF}));
  _glBufferDataARB := TglBufferDataARB(wglGetProcAddress('glBufferDataARB'{$IFDEF CLR}, typeof(TglBufferDataARB){$ENDIF}));
  _glBufferSubDataARB := TglBufferSubDataARB(wglGetProcAddress('glBufferSubDataARB'{$IFDEF CLR}, typeof(TglBufferSubDataARB){$ENDIF}));
  glGetBufferSubDataARB := TglGetBufferSubDataARB(wglGetProcAddress('glGetBufferSubDataARB'{$IFDEF CLR}, typeof(TglGetBufferSubDataARB){$ENDIF}));
  glMapBufferARB := TglMapBufferARB(wglGetProcAddress('glMapBufferARB'{$IFDEF CLR}, typeof(TglMapBufferARB){$ENDIF}));
  glUnmapBufferARB := TglUnmapBufferARB(wglGetProcAddress('glUnmapBufferARB'{$IFDEF CLR}, typeof(TglUnmapBufferARB){$ENDIF}));
  glGetBufferParameterivARB := TglGetBufferParameterivARB(wglGetProcAddress('glGetBufferParameterivARB'{$IFDEF CLR}, typeof(TglGetBufferParameterivARB){$ENDIF}));
  glGetBufferPointervARB := TglGetBufferPointervARB(wglGetProcAddress('glGetBufferPointervARB'{$IFDEF CLR}, typeof(TglGetBufferPointervARB){$ENDIF}));
end;

procedure Read_GL_ARB_vertex_program;
begin
  glVertexAttrib1dARB := TglVertexAttrib1dARB(wglGetProcAddress('glVertexAttrib1dARB'{$IFDEF CLR}, typeof(TglVertexAttrib1dARB){$ENDIF}));
  glVertexAttrib1dvARB := TglVertexAttrib1dvARB(wglGetProcAddress('glVertexAttrib1dvARB'{$IFDEF CLR}, typeof(TglVertexAttrib1dvARB){$ENDIF}));
  glVertexAttrib1fARB := TglVertexAttrib1fARB(wglGetProcAddress('glVertexAttrib1fARB'{$IFDEF CLR}, typeof(TglVertexAttrib1fARB){$ENDIF}));
  glVertexAttrib1fvARB := TglVertexAttrib1fvARB(wglGetProcAddress('glVertexAttrib1fvARB'{$IFDEF CLR}, typeof(TglVertexAttrib1fvARB){$ENDIF}));
  glVertexAttrib1sARB := TglVertexAttrib1sARB(wglGetProcAddress('glVertexAttrib1sARB'{$IFDEF CLR}, typeof(TglVertexAttrib1sARB){$ENDIF}));
  glVertexAttrib1svARB := TglVertexAttrib1svARB(wglGetProcAddress('glVertexAttrib1svARB'{$IFDEF CLR}, typeof(TglVertexAttrib1svARB){$ENDIF}));
  glVertexAttrib2dARB := TglVertexAttrib2dARB(wglGetProcAddress('glVertexAttrib2dARB'{$IFDEF CLR}, typeof(TglVertexAttrib2dARB){$ENDIF}));
  glVertexAttrib2dvARB := TglVertexAttrib2dvARB(wglGetProcAddress('glVertexAttrib2dvARB'{$IFDEF CLR}, typeof(TglVertexAttrib2dvARB){$ENDIF}));
  glVertexAttrib2fARB := TglVertexAttrib2fARB(wglGetProcAddress('glVertexAttrib2fARB'{$IFDEF CLR}, typeof(TglVertexAttrib2fARB){$ENDIF}));
  glVertexAttrib2fvARB := TglVertexAttrib2fvARB(wglGetProcAddress('glVertexAttrib2fvARB'{$IFDEF CLR}, typeof(TglVertexAttrib2fvARB){$ENDIF}));
  glVertexAttrib2sARB := TglVertexAttrib2sARB(wglGetProcAddress('glVertexAttrib2sARB'{$IFDEF CLR}, typeof(TglVertexAttrib2sARB){$ENDIF}));
  glVertexAttrib2svARB := TglVertexAttrib2svARB(wglGetProcAddress('glVertexAttrib2svARB'{$IFDEF CLR}, typeof(TglVertexAttrib2svARB){$ENDIF}));
  glVertexAttrib3dARB := TglVertexAttrib3dARB(wglGetProcAddress('glVertexAttrib3dARB'{$IFDEF CLR}, typeof(TglVertexAttrib3dARB){$ENDIF}));
  glVertexAttrib3dvARB := TglVertexAttrib3dvARB(wglGetProcAddress('glVertexAttrib3dvARB'{$IFDEF CLR}, typeof(TglVertexAttrib3dvARB){$ENDIF}));
  glVertexAttrib3fARB := TglVertexAttrib3fARB(wglGetProcAddress('glVertexAttrib3fARB'{$IFDEF CLR}, typeof(TglVertexAttrib3fARB){$ENDIF}));
  glVertexAttrib3fvARB := TglVertexAttrib3fvARB(wglGetProcAddress('glVertexAttrib3fvARB'{$IFDEF CLR}, typeof(TglVertexAttrib3fvARB){$ENDIF}));
  glVertexAttrib3sARB := TglVertexAttrib3sARB(wglGetProcAddress('glVertexAttrib3sARB'{$IFDEF CLR}, typeof(TglVertexAttrib3sARB){$ENDIF}));
  glVertexAttrib3svARB := TglVertexAttrib3svARB(wglGetProcAddress('glVertexAttrib3svARB'{$IFDEF CLR}, typeof(TglVertexAttrib3svARB){$ENDIF}));
  glVertexAttrib4NbvARB := TglVertexAttrib4NbvARB(wglGetProcAddress('glVertexAttrib4NbvARB'{$IFDEF CLR}, typeof(TglVertexAttrib4NbvARB){$ENDIF}));
  glVertexAttrib4NivARB := TglVertexAttrib4NivARB(wglGetProcAddress('glVertexAttrib4NivARB'{$IFDEF CLR}, typeof(TglVertexAttrib4NivARB){$ENDIF}));
  glVertexAttrib4NsvARB := TglVertexAttrib4NsvARB(wglGetProcAddress('glVertexAttrib4NsvARB'{$IFDEF CLR}, typeof(TglVertexAttrib4NsvARB){$ENDIF}));
  glVertexAttrib4NubARB := TglVertexAttrib4NubARB(wglGetProcAddress('glVertexAttrib4NubARB'{$IFDEF CLR}, typeof(TglVertexAttrib4NubARB){$ENDIF}));
  glVertexAttrib4NubvARB := TglVertexAttrib4NubvARB(wglGetProcAddress('glVertexAttrib4NubvARB'{$IFDEF CLR}, typeof(TglVertexAttrib4NubvARB){$ENDIF}));
  glVertexAttrib4NuivARB := TglVertexAttrib4NuivARB(wglGetProcAddress('glVertexAttrib4NuivARB'{$IFDEF CLR}, typeof(TglVertexAttrib4NuivARB){$ENDIF}));
  glVertexAttrib4NusvARB := TglVertexAttrib4NusvARB(wglGetProcAddress('glVertexAttrib4NusvARB'{$IFDEF CLR}, typeof(TglVertexAttrib4NusvARB){$ENDIF}));
  glVertexAttrib4bvARB := TglVertexAttrib4bvARB(wglGetProcAddress('glVertexAttrib4bvARB'{$IFDEF CLR}, typeof(TglVertexAttrib4bvARB){$ENDIF}));
  glVertexAttrib4dARB := TglVertexAttrib4dARB(wglGetProcAddress('glVertexAttrib4dARB'{$IFDEF CLR}, typeof(TglVertexAttrib4dARB){$ENDIF}));
  glVertexAttrib4dvARB := TglVertexAttrib4dvARB(wglGetProcAddress('glVertexAttrib4dvARB'{$IFDEF CLR}, typeof(TglVertexAttrib4dvARB){$ENDIF}));
  glVertexAttrib4fARB := TglVertexAttrib4fARB(wglGetProcAddress('glVertexAttrib4fARB'{$IFDEF CLR}, typeof(TglVertexAttrib4fARB){$ENDIF}));
  glVertexAttrib4fvARB := TglVertexAttrib4fvARB(wglGetProcAddress('glVertexAttrib4fvARB'{$IFDEF CLR}, typeof(TglVertexAttrib4fvARB){$ENDIF}));
  glVertexAttrib4ivARB := TglVertexAttrib4ivARB(wglGetProcAddress('glVertexAttrib4ivARB'{$IFDEF CLR}, typeof(TglVertexAttrib4ivARB){$ENDIF}));
  glVertexAttrib4sARB := TglVertexAttrib4sARB(wglGetProcAddress('glVertexAttrib4sARB'{$IFDEF CLR}, typeof(TglVertexAttrib4sARB){$ENDIF}));
  glVertexAttrib4svARB := TglVertexAttrib4svARB(wglGetProcAddress('glVertexAttrib4svARB'{$IFDEF CLR}, typeof(TglVertexAttrib4svARB){$ENDIF}));
  glVertexAttrib4ubvARB := TglVertexAttrib4ubvARB(wglGetProcAddress('glVertexAttrib4ubvARB'{$IFDEF CLR}, typeof(TglVertexAttrib4ubvARB){$ENDIF}));
  glVertexAttrib4uivARB := TglVertexAttrib4uivARB(wglGetProcAddress('glVertexAttrib4uivARB'{$IFDEF CLR}, typeof(TglVertexAttrib4uivARB){$ENDIF}));
  glVertexAttrib4usvARB := TglVertexAttrib4usvARB(wglGetProcAddress('glVertexAttrib4usvARB'{$IFDEF CLR}, typeof(TglVertexAttrib4usvARB){$ENDIF}));
  _glVertexAttribPointerARB := TglVertexAttribPointerARB(wglGetProcAddress('glVertexAttribPointerARB'{$IFDEF CLR}, typeof(TglVertexAttribPointerARB){$ENDIF}));
  glEnableVertexAttribArrayARB := TglEnableVertexAttribArrayARB(wglGetProcAddress('glEnableVertexAttribArrayARB'{$IFDEF CLR}, typeof(TglEnableVertexAttribArrayARB){$ENDIF}));
  glDisableVertexAttribArrayARB := TglDisableVertexAttribArrayARB(wglGetProcAddress('glDisableVertexAttribArrayARB'{$IFDEF CLR}, typeof(TglDisableVertexAttribArrayARB){$ENDIF}));
  glProgramStringARB := TglProgramStringARB(wglGetProcAddress('glProgramStringARB'{$IFDEF CLR}, typeof(TglProgramStringARB){$ENDIF}));
  glBindProgramARB := TglBindProgramARB(wglGetProcAddress('glBindProgramARB'{$IFDEF CLR}, typeof(TglBindProgramARB){$ENDIF}));
  glDeleteProgramsARB := TglDeleteProgramsARB(wglGetProcAddress('glDeleteProgramsARB'{$IFDEF CLR}, typeof(TglDeleteProgramsARB){$ENDIF}));
  glGenProgramsARB := TglGenProgramsARB(wglGetProcAddress('glGenProgramsARB'{$IFDEF CLR}, typeof(TglGenProgramsARB){$ENDIF}));
  glProgramEnvParameter4dARB := TglProgramEnvParameter4dARB(wglGetProcAddress('glProgramEnvParameter4dARB'{$IFDEF CLR}, typeof(TglProgramEnvParameter4dARB){$ENDIF}));
  glProgramEnvParameter4dvARB := TglProgramEnvParameter4dvARB(wglGetProcAddress('glProgramEnvParameter4dvARB'{$IFDEF CLR}, typeof(TglProgramEnvParameter4dvARB){$ENDIF}));
  glProgramEnvParameter4fARB := TglProgramEnvParameter4fARB(wglGetProcAddress('glProgramEnvParameter4fARB'{$IFDEF CLR}, typeof(TglProgramEnvParameter4fARB){$ENDIF}));
  glProgramEnvParameter4fvARB := TglProgramEnvParameter4fvARB(wglGetProcAddress('glProgramEnvParameter4fvARB'{$IFDEF CLR}, typeof(TglProgramEnvParameter4fvARB){$ENDIF}));
  glProgramLocalParameter4dARB := TglProgramLocalParameter4dARB(wglGetProcAddress('glProgramLocalParameter4dARB'{$IFDEF CLR}, typeof(TglProgramLocalParameter4dARB){$ENDIF}));
  glProgramLocalParameter4dvARB := TglProgramLocalParameter4dvARB(wglGetProcAddress('glProgramLocalParameter4dvARB'{$IFDEF CLR}, typeof(TglProgramLocalParameter4dvARB){$ENDIF}));
  glProgramLocalParameter4fARB := TglProgramLocalParameter4fARB(wglGetProcAddress('glProgramLocalParameter4fARB'{$IFDEF CLR}, typeof(TglProgramLocalParameter4fARB){$ENDIF}));
  glProgramLocalParameter4fvARB := TglProgramLocalParameter4fvARB(wglGetProcAddress('glProgramLocalParameter4fvARB'{$IFDEF CLR}, typeof(TglProgramLocalParameter4fvARB){$ENDIF}));
  glGetProgramEnvParameterdvARB := TglGetProgramEnvParameterdvARB(wglGetProcAddress('glGetProgramEnvParameterdvARB'{$IFDEF CLR}, typeof(TglGetProgramEnvParameterdvARB){$ENDIF}));
  glGetProgramEnvParameterfvARB := TglGetProgramEnvParameterfvARB(wglGetProcAddress('glGetProgramEnvParameterfvARB'{$IFDEF CLR}, typeof(TglGetProgramEnvParameterfvARB){$ENDIF}));
  glGetProgramLocalParameterdvARB := TglGetProgramLocalParameterdvARB(wglGetProcAddress('glGetProgramLocalParameterdvARB'{$IFDEF CLR}, typeof(TglGetProgramLocalParameterdvARB){$ENDIF}));
  glGetProgramLocalParameterfvARB := TglGetProgramLocalParameterfvARB(wglGetProcAddress('glGetProgramLocalParameterfvARB'{$IFDEF CLR}, typeof(TglGetProgramLocalParameterfvARB){$ENDIF}));
  glGetProgramivARB := TglGetProgramivARB(wglGetProcAddress('glGetProgramivARB'{$IFDEF CLR}, typeof(TglGetProgramivARB){$ENDIF}));
  glGetProgramStringARB := TglGetProgramStringARB(wglGetProcAddress('glGetProgramStringARB'{$IFDEF CLR}, typeof(TglGetProgramStringARB){$ENDIF}));
  glGetVertexAttribdvARB := TglGetVertexAttribdvARB(wglGetProcAddress('glGetVertexAttribdvARB'{$IFDEF CLR}, typeof(TglGetVertexAttribdvARB){$ENDIF}));
  glGetVertexAttribfvARB := TglGetVertexAttribfvARB(wglGetProcAddress('glGetVertexAttribfvARB'{$IFDEF CLR}, typeof(TglGetVertexAttribfvARB){$ENDIF}));
  glGetVertexAttribivARB := TglGetVertexAttribivARB(wglGetProcAddress('glGetVertexAttribivARB'{$IFDEF CLR}, typeof(TglGetVertexAttribivARB){$ENDIF}));
  glGetVertexAttribPointervARB := TglGetVertexAttribPointervARB(wglGetProcAddress('glGetVertexAttribPointervARB'{$IFDEF CLR}, typeof(TglGetVertexAttribPointervARB){$ENDIF}));
  glIsProgramARB := TglIsProgramARB(wglGetProcAddress('glIsProgramARB'{$IFDEF CLR}, typeof(TglIsProgramARB){$ENDIF}));
end;

procedure Read_GL_ARB_window_pos;
begin
  glWindowPos2dARB := TglWindowPos2dARB(wglGetProcAddress('glWindowPos2dARB'{$IFDEF CLR}, typeof(TglWindowPos2dARB){$ENDIF}));
  glWindowPos2dvARB := TglWindowPos2dvARB(wglGetProcAddress('glWindowPos2dvARB'{$IFDEF CLR}, typeof(TglWindowPos2dvARB){$ENDIF}));
  glWindowPos2fARB := TglWindowPos2fARB(wglGetProcAddress('glWindowPos2fARB'{$IFDEF CLR}, typeof(TglWindowPos2fARB){$ENDIF}));
  glWindowPos2fvARB := TglWindowPos2fvARB(wglGetProcAddress('glWindowPos2fvARB'{$IFDEF CLR}, typeof(TglWindowPos2fvARB){$ENDIF}));
  glWindowPos2iARB := TglWindowPos2iARB(wglGetProcAddress('glWindowPos2iARB'{$IFDEF CLR}, typeof(TglWindowPos2iARB){$ENDIF}));
  glWindowPos2ivARB := TglWindowPos2ivARB(wglGetProcAddress('glWindowPos2ivARB'{$IFDEF CLR}, typeof(TglWindowPos2ivARB){$ENDIF}));
  glWindowPos2sARB := TglWindowPos2sARB(wglGetProcAddress('glWindowPos2sARB'{$IFDEF CLR}, typeof(TglWindowPos2sARB){$ENDIF}));
  glWindowPos2svARB := TglWindowPos2svARB(wglGetProcAddress('glWindowPos2svARB'{$IFDEF CLR}, typeof(TglWindowPos2svARB){$ENDIF}));
  glWindowPos3dARB := TglWindowPos3dARB(wglGetProcAddress('glWindowPos3dARB'{$IFDEF CLR}, typeof(TglWindowPos3dARB){$ENDIF}));
  glWindowPos3dvARB := TglWindowPos3dvARB(wglGetProcAddress('glWindowPos3dvARB'{$IFDEF CLR}, typeof(TglWindowPos3dvARB){$ENDIF}));
  glWindowPos3fARB := TglWindowPos3fARB(wglGetProcAddress('glWindowPos3fARB'{$IFDEF CLR}, typeof(TglWindowPos3fARB){$ENDIF}));
  glWindowPos3fvARB := TglWindowPos3fvARB(wglGetProcAddress('glWindowPos3fvARB'{$IFDEF CLR}, typeof(TglWindowPos3fvARB){$ENDIF}));
  glWindowPos3iARB := TglWindowPos3iARB(wglGetProcAddress('glWindowPos3iARB'{$IFDEF CLR}, typeof(TglWindowPos3iARB){$ENDIF}));
  glWindowPos3ivARB := TglWindowPos3ivARB(wglGetProcAddress('glWindowPos3ivARB'{$IFDEF CLR}, typeof(TglWindowPos3ivARB){$ENDIF}));
  glWindowPos3sARB := TglWindowPos3sARB(wglGetProcAddress('glWindowPos3sARB'{$IFDEF CLR}, typeof(TglWindowPos3sARB){$ENDIF}));
  glWindowPos3svARB := TglWindowPos3svARB(wglGetProcAddress('glWindowPos3svARB'{$IFDEF CLR}, typeof(TglWindowPos3svARB){$ENDIF}));

end;

procedure Read_GL_ARB_draw_buffers;
begin
  glDrawBuffersARB := TglDrawBuffersARB(wglGetProcAddress('glDrawBuffersARB'{$IFDEF CLR}, typeof(TglDrawBuffersARB){$ENDIF}));
end;

procedure Read_GL_ARB_color_buffer_float;
begin
  glClampColorARB := TglClampColorARB(wglGetProcAddress('glClampColorARB'{$IFDEF CLR}, typeof(TglClampColorARB){$ENDIF}));
end;

procedure Read_GL_ATI_draw_buffers;
begin
  glDrawBuffersATI := TglDrawBuffersATI(wglGetProcAddress('glDrawBuffersATI'{$IFDEF CLR}, typeof(TglDrawBuffersATI){$ENDIF}));
end;

procedure Read_GL_ATI_element_array;
begin
  glElementPointerATI := TglElementPointerATI(wglGetProcAddress('glElementPointerATI'{$IFDEF CLR}, typeof(TglElementPointerATI){$ENDIF}));
  glDrawElementArrayATI := TglDrawElementArrayATI(wglGetProcAddress('glDrawElementArrayATI'{$IFDEF CLR}, typeof(TglDrawElementArrayATI){$ENDIF}));
  glDrawRangeElementArrayATI := TglDrawRangeElementArrayATI(wglGetProcAddress('glDrawRangeElementArrayATI'{$IFDEF CLR}, typeof(TglDrawRangeElementArrayATI){$ENDIF}));
end;

procedure Read_GL_ATI_envmap_bumpmap;
begin
  glTexBumpParameterivATI := TglTexBumpParameterivATI(wglGetProcAddress('glTexBumpParameterivATI'{$IFDEF CLR}, typeof(TglTexBumpParameterivATI){$ENDIF}));
  glTexBumpParameterfvATI := TglTexBumpParameterfvATI(wglGetProcAddress('glTexBumpParameterfvATI'{$IFDEF CLR}, typeof(TglTexBumpParameterfvATI){$ENDIF}));
  glGetTexBumpParameterivATI := TglGetTexBumpParameterivATI(wglGetProcAddress('glGetTexBumpParameterivATI'{$IFDEF CLR}, typeof(TglGetTexBumpParameterivATI){$ENDIF}));
  glGetTexBumpParameterfvATI := TglGetTexBumpParameterfvATI(wglGetProcAddress('glGetTexBumpParameterfvATI'{$IFDEF CLR}, typeof(TglGetTexBumpParameterfvATI){$ENDIF}));
end;

procedure Read_GL_ATI_fragment_shader;
begin
  glGenFragmentShadersATI := TglGenFragmentShadersATI(wglGetProcAddress('glGenFragmentShadersATI'{$IFDEF CLR}, typeof(TglGenFragmentShadersATI){$ENDIF}));
  glBindFragmentShaderATI := TglBindFragmentShaderATI(wglGetProcAddress('glBindFragmentShaderATI'{$IFDEF CLR}, typeof(TglBindFragmentShaderATI){$ENDIF}));
  glDeleteFragmentShaderATI := TglDeleteFragmentShaderATI(wglGetProcAddress('glDeleteFragmentShaderATI'{$IFDEF CLR}, typeof(TglDeleteFragmentShaderATI){$ENDIF}));
  glBeginFragmentShaderATI := TglBeginFragmentShaderATI(wglGetProcAddress('glBeginFragmentShaderATI'{$IFDEF CLR}, typeof(TglBeginFragmentShaderATI){$ENDIF}));
  glEndFragmentShaderATI := TglEndFragmentShaderATI(wglGetProcAddress('glEndFragmentShaderATI'{$IFDEF CLR}, typeof(TglEndFragmentShaderATI){$ENDIF}));
  glPassTexCoordATI := TglPassTexCoordATI(wglGetProcAddress('glPassTexCoordATI'{$IFDEF CLR}, typeof(TglPassTexCoordATI){$ENDIF}));
  glSampleMapATI := TglSampleMapATI(wglGetProcAddress('glSampleMapATI'{$IFDEF CLR}, typeof(TglSampleMapATI){$ENDIF}));
  glColorFragmentOp1ATI := TglColorFragmentOp1ATI(wglGetProcAddress('glColorFragmentOp1ATI'{$IFDEF CLR}, typeof(TglColorFragmentOp1ATI){$ENDIF}));
  glColorFragmentOp2ATI := TglColorFragmentOp2ATI(wglGetProcAddress('glColorFragmentOp2ATI'{$IFDEF CLR}, typeof(TglColorFragmentOp2ATI){$ENDIF}));
  glColorFragmentOp3ATI := TglColorFragmentOp3ATI(wglGetProcAddress('glColorFragmentOp3ATI'{$IFDEF CLR}, typeof(TglColorFragmentOp3ATI){$ENDIF}));
  glAlphaFragmentOp1ATI := TglAlphaFragmentOp1ATI(wglGetProcAddress('glAlphaFragmentOp1ATI'{$IFDEF CLR}, typeof(TglAlphaFragmentOp1ATI){$ENDIF}));
  glAlphaFragmentOp2ATI := TglAlphaFragmentOp2ATI(wglGetProcAddress('glAlphaFragmentOp2ATI'{$IFDEF CLR}, typeof(TglAlphaFragmentOp2ATI){$ENDIF}));
  glAlphaFragmentOp3ATI := TglAlphaFragmentOp3ATI(wglGetProcAddress('glAlphaFragmentOp3ATI'{$IFDEF CLR}, typeof(TglAlphaFragmentOp3ATI){$ENDIF}));
  glSetFragmentShaderConstantATI := TglSetFragmentShaderConstantATI(wglGetProcAddress('glSetFragmentShaderConstantATI'{$IFDEF CLR}, typeof(TglSetFragmentShaderConstantATI){$ENDIF}));
end;

procedure Read_GL_ATI_map_object_buffer;
begin
  glMapObjectBufferATI := TglMapObjectBufferATI(wglGetProcAddress('glMapObjectBufferATI'{$IFDEF CLR}, typeof(TglMapObjectBufferATI){$ENDIF}));
  glUnmapObjectBufferATI := TglUnmapObjectBufferATI(wglGetProcAddress('glUnmapObjectBufferATI'{$IFDEF CLR}, typeof(TglUnmapObjectBufferATI){$ENDIF}));
end;

procedure Read_GL_ATI_pn_triangles;
begin
  glPNTrianglesiATI := TglPNTrianglesiATI(wglGetProcAddress('glPNTrianglesiATI'{$IFDEF CLR}, typeof(TglPNTrianglesiATI){$ENDIF}));
  glPNTrianglesfATI := TglPNTrianglesfATI(wglGetProcAddress('glPNTrianglesfATI'{$IFDEF CLR}, typeof(TglPNTrianglesfATI){$ENDIF}));
end;

procedure Read_GL_ATI_separate_stencil;
begin
  glStencilOpSeparateATI := TglStencilOpSeparateATI(wglGetProcAddress('glStencilOpSeparateATI'{$IFDEF CLR}, typeof(TglStencilOpSeparateATI){$ENDIF}));
  glStencilFuncSeparateATI := TglStencilFuncSeparateATI(wglGetProcAddress('glStencilFuncSeparateATI'{$IFDEF CLR}, typeof(TglStencilFuncSeparateATI){$ENDIF}));
end;

procedure Read_GL_ATI_vertex_array_object;
begin
  glNewObjectBufferATI := TglNewObjectBufferATI(wglGetProcAddress('glNewObjectBufferATI'{$IFDEF CLR}, typeof(TglNewObjectBufferATI){$ENDIF}));
  glIsObjectBufferATI := TglIsObjectBufferATI(wglGetProcAddress('glIsObjectBufferATI'{$IFDEF CLR}, typeof(TglIsObjectBufferATI){$ENDIF}));
  glUpdateObjectBufferATI := TglUpdateObjectBufferATI(wglGetProcAddress('glUpdateObjectBufferATI'{$IFDEF CLR}, typeof(TglUpdateObjectBufferATI){$ENDIF}));
  glGetObjectBufferfvATI := TglGetObjectBufferfvATI(wglGetProcAddress('glGetObjectBufferfvATI'{$IFDEF CLR}, typeof(TglGetObjectBufferfvATI){$ENDIF}));
  glGetObjectBufferivATI := TglGetObjectBufferivATI(wglGetProcAddress('glGetObjectBufferivATI'{$IFDEF CLR}, typeof(TglGetObjectBufferivATI){$ENDIF}));
  glFreeObjectBufferATI := TglFreeObjectBufferATI(wglGetProcAddress('glFreeObjectBufferATI'{$IFDEF CLR}, typeof(TglFreeObjectBufferATI){$ENDIF}));
  glArrayObjectATI := TglArrayObjectATI(wglGetProcAddress('glArrayObjectATI'{$IFDEF CLR}, typeof(TglArrayObjectATI){$ENDIF}));
  glGetArrayObjectfvATI := TglGetArrayObjectfvATI(wglGetProcAddress('glGetArrayObjectfvATI'{$IFDEF CLR}, typeof(TglGetArrayObjectfvATI){$ENDIF}));
  glGetArrayObjectivATI := TglGetArrayObjectivATI(wglGetProcAddress('glGetArrayObjectivATI'{$IFDEF CLR}, typeof(TglGetArrayObjectivATI){$ENDIF}));
  glVariantArrayObjectATI := TglVariantArrayObjectATI(wglGetProcAddress('glVariantArrayObjectATI'{$IFDEF CLR}, typeof(TglVariantArrayObjectATI){$ENDIF}));
  glGetVariantArrayObjectfvATI := TglGetVariantArrayObjectfvATI(wglGetProcAddress('glGetVariantArrayObjectfvATI'{$IFDEF CLR}, typeof(TglGetVariantArrayObjectfvATI){$ENDIF}));
  glGetVariantArrayObjectivATI := TglGetVariantArrayObjectivATI(wglGetProcAddress('glGetVariantArrayObjectivATI'{$IFDEF CLR}, typeof(TglGetVariantArrayObjectivATI){$ENDIF}));

end;

procedure Read_GL_ATI_vertex_attrib_array_object;
begin
  glVertexAttribArrayObjectATI := TglVertexAttribArrayObjectATI(wglGetProcAddress('glVertexAttribArrayObjectATI'{$IFDEF CLR}, typeof(TglVertexAttribArrayObjectATI){$ENDIF}));
  glGetVertexAttribArrayObjectfvATI := TglGetVertexAttribArrayObjectfvATI(wglGetProcAddress('glGetVertexAttribArrayObjectfvATI'{$IFDEF CLR}, typeof(TglGetVertexAttribArrayObjectfvATI){$ENDIF}));
  glGetVertexAttribArrayObjectivATI := TglGetVertexAttribArrayObjectivATI(wglGetProcAddress('glGetVertexAttribArrayObjectivATI'{$IFDEF CLR}, typeof(TglGetVertexAttribArrayObjectivATI){$ENDIF}));
end;

procedure Read_GL_ATI_vertex_streams;
begin
  glVertexStream1sATI := TglVertexStream1sATI(wglGetProcAddress('glVertexStream1sATI'{$IFDEF CLR}, typeof(TglVertexStream1sATI){$ENDIF}));
  glVertexStream1svATI := TglVertexStream1svATI(wglGetProcAddress('glVertexStream1svATI'{$IFDEF CLR}, typeof(TglVertexStream1svATI){$ENDIF}));
  glVertexStream1iATI := TglVertexStream1iATI(wglGetProcAddress('glVertexStream1iATI'{$IFDEF CLR}, typeof(TglVertexStream1iATI){$ENDIF}));
  glVertexStream1ivATI := TglVertexStream1ivATI(wglGetProcAddress('glVertexStream1ivATI'{$IFDEF CLR}, typeof(TglVertexStream1ivATI){$ENDIF}));
  glVertexStream1fATI := TglVertexStream1fATI(wglGetProcAddress('glVertexStream1fATI'{$IFDEF CLR}, typeof(TglVertexStream1fATI){$ENDIF}));
  glVertexStream1fvATI := TglVertexStream1fvATI(wglGetProcAddress('glVertexStream1fvATI'{$IFDEF CLR}, typeof(TglVertexStream1fvATI){$ENDIF}));
  glVertexStream1dATI := TglVertexStream1dATI(wglGetProcAddress('glVertexStream1dATI'{$IFDEF CLR}, typeof(TglVertexStream1dATI){$ENDIF}));
  glVertexStream1dvATI := TglVertexStream1dvATI(wglGetProcAddress('glVertexStream1dvATI'{$IFDEF CLR}, typeof(TglVertexStream1dvATI){$ENDIF}));
  glVertexStream2sATI := TglVertexStream2sATI(wglGetProcAddress('glVertexStream2sATI'{$IFDEF CLR}, typeof(TglVertexStream2sATI){$ENDIF}));
  glVertexStream2svATI := TglVertexStream2svATI(wglGetProcAddress('glVertexStream2svATI'{$IFDEF CLR}, typeof(TglVertexStream2svATI){$ENDIF}));
  glVertexStream2iATI := TglVertexStream2iATI(wglGetProcAddress('glVertexStream2iATI'{$IFDEF CLR}, typeof(TglVertexStream2iATI){$ENDIF}));
  glVertexStream2ivATI := TglVertexStream2ivATI(wglGetProcAddress('glVertexStream2ivATI'{$IFDEF CLR}, typeof(TglVertexStream2ivATI){$ENDIF}));
  glVertexStream2fATI := TglVertexStream2fATI(wglGetProcAddress('glVertexStream2fATI'{$IFDEF CLR}, typeof(TglVertexStream2fATI){$ENDIF}));
  glVertexStream2fvATI := TglVertexStream2fvATI(wglGetProcAddress('glVertexStream2fvATI'{$IFDEF CLR}, typeof(TglVertexStream2fvATI){$ENDIF}));
  glVertexStream2dATI := TglVertexStream2dATI(wglGetProcAddress('glVertexStream2dATI'{$IFDEF CLR}, typeof(TglVertexStream2dATI){$ENDIF}));
  glVertexStream2dvATI := TglVertexStream2dvATI(wglGetProcAddress('glVertexStream2dvATI'{$IFDEF CLR}, typeof(TglVertexStream2dvATI){$ENDIF}));
  glVertexStream3sATI := TglVertexStream3sATI(wglGetProcAddress('glVertexStream3sATI'{$IFDEF CLR}, typeof(TglVertexStream3sATI){$ENDIF}));
  glVertexStream3svATI := TglVertexStream3svATI(wglGetProcAddress('glVertexStream3svATI'{$IFDEF CLR}, typeof(TglVertexStream3svATI){$ENDIF}));
  glVertexStream3iATI := TglVertexStream3iATI(wglGetProcAddress('glVertexStream3iATI'{$IFDEF CLR}, typeof(TglVertexStream3iATI){$ENDIF}));
  glVertexStream3ivATI := TglVertexStream3ivATI(wglGetProcAddress('glVertexStream3ivATI'{$IFDEF CLR}, typeof(TglVertexStream3ivATI){$ENDIF}));
  glVertexStream3fATI := TglVertexStream3fATI(wglGetProcAddress('glVertexStream3fATI'{$IFDEF CLR}, typeof(TglVertexStream3fATI){$ENDIF}));
  glVertexStream3fvATI := TglVertexStream3fvATI(wglGetProcAddress('glVertexStream3fvATI'{$IFDEF CLR}, typeof(TglVertexStream3fvATI){$ENDIF}));
  glVertexStream3dATI := TglVertexStream3dATI(wglGetProcAddress('glVertexStream3dATI'{$IFDEF CLR}, typeof(TglVertexStream3dATI){$ENDIF}));
  glVertexStream3dvATI := TglVertexStream3dvATI(wglGetProcAddress('glVertexStream3dvATI'{$IFDEF CLR}, typeof(TglVertexStream3dvATI){$ENDIF}));
  glVertexStream4sATI := TglVertexStream4sATI(wglGetProcAddress('glVertexStream4sATI'{$IFDEF CLR}, typeof(TglVertexStream4sATI){$ENDIF}));
  glVertexStream4svATI := TglVertexStream4svATI(wglGetProcAddress('glVertexStream4svATI'{$IFDEF CLR}, typeof(TglVertexStream4svATI){$ENDIF}));
  glVertexStream4iATI := TglVertexStream4iATI(wglGetProcAddress('glVertexStream4iATI'{$IFDEF CLR}, typeof(TglVertexStream4iATI){$ENDIF}));
  glVertexStream4ivATI := TglVertexStream4ivATI(wglGetProcAddress('glVertexStream4ivATI'{$IFDEF CLR}, typeof(TglVertexStream4ivATI){$ENDIF}));
  glVertexStream4fATI := TglVertexStream4fATI(wglGetProcAddress('glVertexStream4fATI'{$IFDEF CLR}, typeof(TglVertexStream4fATI){$ENDIF}));
  glVertexStream4fvATI := TglVertexStream4fvATI(wglGetProcAddress('glVertexStream4fvATI'{$IFDEF CLR}, typeof(TglVertexStream4fvATI){$ENDIF}));
  glVertexStream4dATI := TglVertexStream4dATI(wglGetProcAddress('glVertexStream4dATI'{$IFDEF CLR}, typeof(TglVertexStream4dATI){$ENDIF}));
  glVertexStream4dvATI := TglVertexStream4dvATI(wglGetProcAddress('glVertexStream4dvATI'{$IFDEF CLR}, typeof(TglVertexStream4dvATI){$ENDIF}));
  glNormalStream3bATI := TglNormalStream3bATI(wglGetProcAddress('glNormalStream3bATI'{$IFDEF CLR}, typeof(TglNormalStream3bATI){$ENDIF}));
  glNormalStream3bvATI := TglNormalStream3bvATI(wglGetProcAddress('glNormalStream3bvATI'{$IFDEF CLR}, typeof(TglNormalStream3bvATI){$ENDIF}));
  glNormalStream3sATI := TglNormalStream3sATI(wglGetProcAddress('glNormalStream3sATI'{$IFDEF CLR}, typeof(TglNormalStream3sATI){$ENDIF}));
  glNormalStream3svATI := TglNormalStream3svATI(wglGetProcAddress('glNormalStream3svATI'{$IFDEF CLR}, typeof(TglNormalStream3svATI){$ENDIF}));
  glNormalStream3iATI := TglNormalStream3iATI(wglGetProcAddress('glNormalStream3iATI'{$IFDEF CLR}, typeof(TglNormalStream3iATI){$ENDIF}));
  glNormalStream3ivATI := TglNormalStream3ivATI(wglGetProcAddress('glNormalStream3ivATI'{$IFDEF CLR}, typeof(TglNormalStream3ivATI){$ENDIF}));
  glNormalStream3fATI := TglNormalStream3fATI(wglGetProcAddress('glNormalStream3fATI'{$IFDEF CLR}, typeof(TglNormalStream3fATI){$ENDIF}));
  glNormalStream3fvATI := TglNormalStream3fvATI(wglGetProcAddress('glNormalStream3fvATI'{$IFDEF CLR}, typeof(TglNormalStream3fvATI){$ENDIF}));
  glNormalStream3dATI := TglNormalStream3dATI(wglGetProcAddress('glNormalStream3dATI'{$IFDEF CLR}, typeof(TglNormalStream3dATI){$ENDIF}));
  glNormalStream3dvATI := TglNormalStream3dvATI(wglGetProcAddress('glNormalStream3dvATI'{$IFDEF CLR}, typeof(TglNormalStream3dvATI){$ENDIF}));
  glClientActiveVertexStreamATI := TglClientActiveVertexStreamATI(wglGetProcAddress('glClientActiveVertexStreamATI'{$IFDEF CLR}, typeof(TglClientActiveVertexStreamATI){$ENDIF}));
  glVertexBlendEnviATI := TglVertexBlendEnviATI(wglGetProcAddress('glVertexBlendEnviATI'{$IFDEF CLR}, typeof(TglVertexBlendEnviATI){$ENDIF}));
  glVertexBlendEnvfATI := TglVertexBlendEnvfATI(wglGetProcAddress('glVertexBlendEnvfATI'{$IFDEF CLR}, typeof(TglVertexBlendEnvfATI){$ENDIF}));
end;

procedure Read_GL_EXT_blend_color;
begin
  glBlendColorEXT := TglBlendColorEXT(wglGetProcAddress('glBlendColorEXT'{$IFDEF CLR}, typeof(TglBlendColorEXT){$ENDIF}));
end;

procedure Read_GL_EXT_blend_func_separate;
begin
  glBlendFuncSeparateEXT := TglBlendFuncSeparateEXT(wglGetProcAddress('glBlendFuncSeparateEXT'{$IFDEF CLR}, typeof(TglBlendFuncSeparateEXT){$ENDIF}));
end;

procedure Read_GL_EXT_blend_minmax;
begin
  glBlendEquationEXT := TglBlendEquationEXT(wglGetProcAddress('glBlendEquationEXT'{$IFDEF CLR}, typeof(TglBlendEquationEXT){$ENDIF}));
end;

procedure Read_GL_EXT_color_subtable;
begin
  glColorSubTableEXT := TglColorSubTableEXT(wglGetProcAddress('glColorSubTableEXT'{$IFDEF CLR}, typeof(TglColorSubTableEXT){$ENDIF}));
  glCopyColorSubTableEXT := TglCopyColorSubTableEXT(wglGetProcAddress('glCopyColorSubTableEXT'{$IFDEF CLR}, typeof(TglCopyColorSubTableEXT){$ENDIF}));
end;

procedure Read_GL_EXT_compiled_vertex_array;
begin
  glLockArraysEXT := TglLockArraysEXT(wglGetProcAddress('glLockArraysEXT'{$IFDEF CLR}, typeof(TglLockArraysEXT){$ENDIF}));
  glUnlockArraysEXT := TglUnlockArraysEXT(wglGetProcAddress('glUnlockArraysEXT'{$IFDEF CLR}, typeof(TglUnlockArraysEXT){$ENDIF}));
end;

procedure Read_GL_EXT_convolution;
begin
  glConvolutionFilter1DEXT := TglConvolutionFilter1DEXT(wglGetProcAddress('glConvolutionFilter1DEXT'{$IFDEF CLR}, typeof(TglConvolutionFilter1DEXT){$ENDIF}));
  glConvolutionFilter2DEXT := TglConvolutionFilter2DEXT(wglGetProcAddress('glConvolutionFilter2DEXT'{$IFDEF CLR}, typeof(TglConvolutionFilter2DEXT){$ENDIF}));
  glConvolutionParameterfEXT := TglConvolutionParameterfEXT(wglGetProcAddress('glConvolutionParameterfEXT'{$IFDEF CLR}, typeof(TglConvolutionParameterfEXT){$ENDIF}));
  glConvolutionParameterfvEXT := TglConvolutionParameterfvEXT(wglGetProcAddress('glConvolutionParameterfvEXT'{$IFDEF CLR}, typeof(TglConvolutionParameterfvEXT){$ENDIF}));
  glConvolutionParameteriEXT := TglConvolutionParameteriEXT(wglGetProcAddress('glConvolutionParameteriEXT'{$IFDEF CLR}, typeof(TglConvolutionParameteriEXT){$ENDIF}));
  glConvolutionParameterivEXT := TglConvolutionParameterivEXT(wglGetProcAddress('glConvolutionParameterivEXT'{$IFDEF CLR}, typeof(TglConvolutionParameterivEXT){$ENDIF}));
  glCopyConvolutionFilter1DEXT := TglCopyConvolutionFilter1DEXT(wglGetProcAddress('glCopyConvolutionFilter1DEXT'{$IFDEF CLR}, typeof(TglCopyConvolutionFilter1DEXT){$ENDIF}));
  glCopyConvolutionFilter2DEXT := TglCopyConvolutionFilter2DEXT(wglGetProcAddress('glCopyConvolutionFilter2DEXT'{$IFDEF CLR}, typeof(TglCopyConvolutionFilter2DEXT){$ENDIF}));
  glGetConvolutionFilterEXT := TglGetConvolutionFilterEXT(wglGetProcAddress('glGetConvolutionFilterEXT'{$IFDEF CLR}, typeof(TglGetConvolutionFilterEXT){$ENDIF}));
  glGetConvolutionParameterfvEXT := TglGetConvolutionParameterfvEXT(wglGetProcAddress('glGetConvolutionParameterfvEXT'{$IFDEF CLR}, typeof(TglGetConvolutionParameterfvEXT){$ENDIF}));
  glGetConvolutionParameterivEXT := TglGetConvolutionParameterivEXT(wglGetProcAddress('glGetConvolutionParameterivEXT'{$IFDEF CLR}, typeof(TglGetConvolutionParameterivEXT){$ENDIF}));
  glGetSeparableFilterEXT := TglGetSeparableFilterEXT(wglGetProcAddress('glGetSeparableFilterEXT'{$IFDEF CLR}, typeof(TglGetSeparableFilterEXT){$ENDIF}));
  glSeparableFilter2DEXT := TglSeparableFilter2DEXT(wglGetProcAddress('glSeparableFilter2DEXT'{$IFDEF CLR}, typeof(TglSeparableFilter2DEXT){$ENDIF}));
end;

procedure Read_GL_EXT_coordinate_frame;
begin
  glTangent3bEXT := TglTangent3bEXT(wglGetProcAddress('glTangent3bEXT'{$IFDEF CLR}, typeof(TglTangent3bEXT){$ENDIF}));
  glTangent3bvEXT := TglTangent3bvEXT(wglGetProcAddress('glTangent3bvEXT'{$IFDEF CLR}, typeof(TglTangent3bvEXT){$ENDIF}));
  glTangent3dEXT := TglTangent3dEXT(wglGetProcAddress('glTangent3dEXT'{$IFDEF CLR}, typeof(TglTangent3dEXT){$ENDIF}));
  glTangent3dvEXT := TglTangent3dvEXT(wglGetProcAddress('glTangent3dvEXT'{$IFDEF CLR}, typeof(TglTangent3dvEXT){$ENDIF}));
  glTangent3fEXT := TglTangent3fEXT(wglGetProcAddress('glTangent3fEXT'{$IFDEF CLR}, typeof(TglTangent3fEXT){$ENDIF}));
  glTangent3fvEXT := TglTangent3fvEXT(wglGetProcAddress('glTangent3fvEXT'{$IFDEF CLR}, typeof(TglTangent3fvEXT){$ENDIF}));
  glTangent3iEXT := TglTangent3iEXT(wglGetProcAddress('glTangent3iEXT'{$IFDEF CLR}, typeof(TglTangent3iEXT){$ENDIF}));
  glTangent3ivEXT := TglTangent3ivEXT(wglGetProcAddress('glTangent3ivEXT'{$IFDEF CLR}, typeof(TglTangent3ivEXT){$ENDIF}));
  glTangent3sEXT := TglTangent3sEXT(wglGetProcAddress('glTangent3sEXT'{$IFDEF CLR}, typeof(TglTangent3sEXT){$ENDIF}));
  glTangent3svEXT := TglTangent3svEXT(wglGetProcAddress('glTangent3svEXT'{$IFDEF CLR}, typeof(TglTangent3svEXT){$ENDIF}));
  glBinormal3bEXT := TglBinormal3bEXT(wglGetProcAddress('glBinormal3bEXT'{$IFDEF CLR}, typeof(TglBinormal3bEXT){$ENDIF}));
  glBinormal3bvEXT := TglBinormal3bvEXT(wglGetProcAddress('glBinormal3bvEXT'{$IFDEF CLR}, typeof(TglBinormal3bvEXT){$ENDIF}));
  glBinormal3dEXT := TglBinormal3dEXT(wglGetProcAddress('glBinormal3dEXT'{$IFDEF CLR}, typeof(TglBinormal3dEXT){$ENDIF}));
  glBinormal3dvEXT := TglBinormal3dvEXT(wglGetProcAddress('glBinormal3dvEXT'{$IFDEF CLR}, typeof(TglBinormal3dvEXT){$ENDIF}));
  glBinormal3fEXT := TglBinormal3fEXT(wglGetProcAddress('glBinormal3fEXT'{$IFDEF CLR}, typeof(TglBinormal3fEXT){$ENDIF}));
  glBinormal3fvEXT := TglBinormal3fvEXT(wglGetProcAddress('glBinormal3fvEXT'{$IFDEF CLR}, typeof(TglBinormal3fvEXT){$ENDIF}));
  glBinormal3iEXT := TglBinormal3iEXT(wglGetProcAddress('glBinormal3iEXT'{$IFDEF CLR}, typeof(TglBinormal3iEXT){$ENDIF}));
  glBinormal3ivEXT := TglBinormal3ivEXT(wglGetProcAddress('glBinormal3ivEXT'{$IFDEF CLR}, typeof(TglBinormal3ivEXT){$ENDIF}));
  glBinormal3sEXT := TglBinormal3sEXT(wglGetProcAddress('glBinormal3sEXT'{$IFDEF CLR}, typeof(TglBinormal3sEXT){$ENDIF}));
  glBinormal3svEXT := TglBinormal3svEXT(wglGetProcAddress('glBinormal3svEXT'{$IFDEF CLR}, typeof(TglBinormal3svEXT){$ENDIF}));
  glTangentPointerEXT := TglTangentPointerEXT(wglGetProcAddress('glTangentPointerEXT'{$IFDEF CLR}, typeof(TglTangentPointerEXT){$ENDIF}));
  glBinormalPointerEXT := TglBinormalPointerEXT(wglGetProcAddress('glBinormalPointerEXT'{$IFDEF CLR}, typeof(TglBinormalPointerEXT){$ENDIF}));
end;

procedure Read_GL_EXT_copy_texture;
begin
  glCopyTexImage1DEXT := TglCopyTexImage1DEXT(wglGetProcAddress('glCopyTexImage1DEXT'{$IFDEF CLR}, typeof(TglCopyTexImage1DEXT){$ENDIF}));
  glCopyTexImage2DEXT := TglCopyTexImage2DEXT(wglGetProcAddress('glCopyTexImage2DEXT'{$IFDEF CLR}, typeof(TglCopyTexImage2DEXT){$ENDIF}));
  glCopyTexSubImage1DEXT := TglCopyTexSubImage1DEXT(wglGetProcAddress('glCopyTexSubImage1DEXT'{$IFDEF CLR}, typeof(TglCopyTexSubImage1DEXT){$ENDIF}));
  glCopyTexSubImage2DEXT := TglCopyTexSubImage2DEXT(wglGetProcAddress('glCopyTexSubImage2DEXT'{$IFDEF CLR}, typeof(TglCopyTexSubImage2DEXT){$ENDIF}));
  glCopyTexSubImage3DEXT := TglCopyTexSubImage3DEXT(wglGetProcAddress('glCopyTexSubImage3DEXT'{$IFDEF CLR}, typeof(TglCopyTexSubImage3DEXT){$ENDIF}));
end;

procedure Read_GL_EXT_cull_vertex;
begin
  glCullParameterdvEXT := TglCullParameterdvEXT(wglGetProcAddress('glCullParameterdvEXT'{$IFDEF CLR}, typeof(TglCullParameterdvEXT){$ENDIF}));
  glCullParameterfvEXT := TglCullParameterfvEXT(wglGetProcAddress('glCullParameterfvEXT'{$IFDEF CLR}, typeof(TglCullParameterfvEXT){$ENDIF}));
end;

procedure Read_GL_EXT_draw_range_elements;
begin
  glDrawRangeElementsEXT := TglDrawRangeElementsEXT(wglGetProcAddress('glDrawRangeElementsEXT'{$IFDEF CLR}, typeof(TglDrawRangeElementsEXT){$ENDIF}));
end;

procedure Read_GL_EXT_fog_coord;
begin
  glFogCoordfEXT := TglFogCoordfEXT(wglGetProcAddress('glFogCoordfEXT'{$IFDEF CLR}, typeof(TglFogCoordfEXT){$ENDIF}));
  glFogCoordfvEXT := TglFogCoordfvEXT(wglGetProcAddress('glFogCoordfvEXT'{$IFDEF CLR}, typeof(TglFogCoordfvEXT){$ENDIF}));
  glFogCoorddEXT := TglFogCoorddEXT(wglGetProcAddress('glFogCoorddEXT'{$IFDEF CLR}, typeof(TglFogCoorddEXT){$ENDIF}));
  glFogCoorddvEXT := TglFogCoorddvEXT(wglGetProcAddress('glFogCoorddvEXT'{$IFDEF CLR}, typeof(TglFogCoorddvEXT){$ENDIF}));
  glFogCoordPointerEXT := TglFogCoordPointerEXT(wglGetProcAddress('glFogCoordPointerEXT'{$IFDEF CLR}, typeof(TglFogCoordPointerEXT){$ENDIF}));
end;

procedure Read_GL_EXT_framebuffer_object;
begin
  glIsRenderbufferEXT := TglIsRenderbufferEXT(wglGetProcAddress('glIsRenderbufferEXT'{$IFDEF CLR}, typeof(TglIsRenderbufferEXT){$ENDIF}));
  glBindRenderbufferEXT := TglBindRenderbufferEXT(wglGetProcAddress('glBindRenderbufferEXT'{$IFDEF CLR}, typeof(TglBindRenderbufferEXT){$ENDIF}));
  glDeleteRenderbuffersEXT := TglDeleteRenderbuffersEXT(wglGetProcAddress('glDeleteRenderbuffersEXT'{$IFDEF CLR}, typeof(TglDeleteRenderbuffersEXT){$ENDIF}));
  glGenRenderbuffersEXT := TglGenRenderbuffersEXT(wglGetProcAddress('glGenRenderbuffersEXT'{$IFDEF CLR}, typeof(TglGenRenderbuffersEXT){$ENDIF}));
  glRenderbufferStorageEXT := TglRenderbufferStorageEXT(wglGetProcAddress('glRenderbufferStorageEXT'{$IFDEF CLR}, typeof(TglRenderbufferStorageEXT){$ENDIF}));
  glGetRenderbufferParameterivEXT := TglGetRenderbufferParameterivEXT(wglGetProcAddress('glGetRenderbufferParameterivEXT'{$IFDEF CLR}, typeof(TglGetRenderbufferParameterivEXT){$ENDIF}));
  glIsFramebufferEXT := TglIsFramebufferEXT(wglGetProcAddress('glIsFramebufferEXT'{$IFDEF CLR}, typeof(TglIsFramebufferEXT){$ENDIF}));
  glBindFramebufferEXT := TglBindFramebufferEXT(wglGetProcAddress('glBindFramebufferEXT'{$IFDEF CLR}, typeof(TglBindFramebufferEXT){$ENDIF}));
  glDeleteFramebuffersEXT := TglDeleteFramebuffersEXT(wglGetProcAddress('glDeleteFramebuffersEXT'{$IFDEF CLR}, typeof(TglDeleteFramebuffersEXT){$ENDIF}));
  glGenFramebuffersEXT := TglGenFramebuffersEXT(wglGetProcAddress('glGenFramebuffersEXT'{$IFDEF CLR}, typeof(TglGenFramebuffersEXT){$ENDIF}));
  glCheckFramebufferStatusEXT := TglCheckFramebufferStatusEXT(wglGetProcAddress('glCheckFramebufferStatusEXT'{$IFDEF CLR}, typeof(TglCheckFramebufferStatusEXT){$ENDIF}));
  glFramebufferTexture1DEXT := TglFramebufferTexture1DEXT(wglGetProcAddress('glFramebufferTexture1DEXT'{$IFDEF CLR}, typeof(TglFramebufferTexture1DEXT){$ENDIF}));
  glFramebufferTexture2DEXT := TglFramebufferTexture2DEXT(wglGetProcAddress('glFramebufferTexture2DEXT'{$IFDEF CLR}, typeof(TglFramebufferTexture2DEXT){$ENDIF}));
  glFramebufferTexture3DEXT := TglFramebufferTexture3DEXT(wglGetProcAddress('glFramebufferTexture3DEXT'{$IFDEF CLR}, typeof(TglFramebufferTexture3DEXT){$ENDIF}));
  glFramebufferRenderbufferEXT := TglFramebufferRenderbufferEXT(wglGetProcAddress('glFramebufferRenderbufferEXT'{$IFDEF CLR}, typeof(TglFramebufferRenderbufferEXT){$ENDIF}));
  glGetFramebufferAttachmentParameterivEXT := TglGetFramebufferAttachmentParameterivEXT(wglGetProcAddress('glGetFramebufferAttachmentParameterivEXT'{$IFDEF CLR}, typeof(TglGetFramebufferAttachmentParameterivEXT){$ENDIF}));
  glGenerateMipmapEXT := TglGenerateMipmapEXT(wglGetProcAddress('glGenerateMipmapEXT'{$IFDEF CLR}, typeof(TglGenerateMipmapEXT){$ENDIF}));
end;

procedure Read_GL_EXT_histogram;
begin
  glGetHistogramEXT := TglGetHistogramEXT(wglGetProcAddress('glGetHistogramEXT'{$IFDEF CLR}, typeof(TglGetHistogramEXT){$ENDIF}));
  glGetHistogramParameterfvEXT := TglGetHistogramParameterfvEXT(wglGetProcAddress('glGetHistogramParameterfvEXT'{$IFDEF CLR}, typeof(TglGetHistogramParameterfvEXT){$ENDIF}));
  glGetHistogramParameterivEXT := TglGetHistogramParameterivEXT(wglGetProcAddress('glGetHistogramParameterivEXT'{$IFDEF CLR}, typeof(TglGetHistogramParameterivEXT){$ENDIF}));
  glGetMinmaxEXT := TglGetMinmaxEXT(wglGetProcAddress('glGetMinmaxEXT'{$IFDEF CLR}, typeof(TglGetMinmaxEXT){$ENDIF}));
  glGetMinmaxParameterfvEXT := TglGetMinmaxParameterfvEXT(wglGetProcAddress('glGetMinmaxParameterfvEXT'{$IFDEF CLR}, typeof(TglGetMinmaxParameterfvEXT){$ENDIF}));
  glGetMinmaxParameterivEXT := TglGetMinmaxParameterivEXT(wglGetProcAddress('glGetMinmaxParameterivEXT'{$IFDEF CLR}, typeof(TglGetMinmaxParameterivEXT){$ENDIF}));
  glHistogramEXT := TglHistogramEXT(wglGetProcAddress('glHistogramEXT'{$IFDEF CLR}, typeof(TglHistogramEXT){$ENDIF}));
  glMinmaxEXT := TglMinmaxEXT(wglGetProcAddress('glMinmaxEXT'{$IFDEF CLR}, typeof(TglMinmaxEXT){$ENDIF}));
  glResetHistogramEXT := TglResetHistogramEXT(wglGetProcAddress('glResetHistogramEXT'{$IFDEF CLR}, typeof(TglResetHistogramEXT){$ENDIF}));
  glResetMinmaxEXT := TglResetMinmaxEXT(wglGetProcAddress('glResetMinmaxEXT'{$IFDEF CLR}, typeof(TglResetMinmaxEXT){$ENDIF}));
end;

procedure Read_GL_EXT_index_func;
begin
  glIndexFuncEXT := TglIndexFuncEXT(wglGetProcAddress('glIndexFuncEXT'{$IFDEF CLR}, typeof(TglIndexFuncEXT){$ENDIF}));
end;

procedure Read_GL_EXT_index_material;
begin
  glIndexMaterialEXT := TglIndexMaterialEXT(wglGetProcAddress('glIndexMaterialEXT'{$IFDEF CLR}, typeof(TglIndexMaterialEXT){$ENDIF}));
end;

procedure Read_GL_EXT_light_texture;
begin
  glApplyTextureEXT := TglApplyTextureEXT(wglGetProcAddress('glApplyTextureEXT'{$IFDEF CLR}, typeof(TglApplyTextureEXT){$ENDIF}));
  glTextureLightEXT := TglTextureLightEXT(wglGetProcAddress('glTextureLightEXT'{$IFDEF CLR}, typeof(TglTextureLightEXT){$ENDIF}));
  glTextureMaterialEXT := TglTextureMaterialEXT(wglGetProcAddress('glTextureMaterialEXT'{$IFDEF CLR}, typeof(TglTextureMaterialEXT){$ENDIF}));
end;

procedure Read_GL_EXT_multi_draw_arrays;
begin
  glMultiDrawArraysEXT := TglMultiDrawArraysEXT(wglGetProcAddress('glMultiDrawArraysEXT'{$IFDEF CLR}, typeof(TglMultiDrawArraysEXT){$ENDIF}));
  glMultiDrawElementsEXT := TglMultiDrawElementsEXT(wglGetProcAddress('glMultiDrawElementsEXT'{$IFDEF CLR}, typeof(TglMultiDrawElementsEXT){$ENDIF}));
end;

procedure Read_GL_EXT_multisample;
begin
  glSampleMaskEXT := TglSampleMaskEXT(wglGetProcAddress('glSampleMaskEXT'{$IFDEF CLR}, typeof(TglSampleMaskEXT){$ENDIF}));
  glSamplePatternEXT := TglSamplePatternEXT(wglGetProcAddress('glSamplePatternEXT'{$IFDEF CLR}, typeof(TglSamplePatternEXT){$ENDIF}));
end;

procedure Read_GL_EXT_paletted_texture;
begin
  glColorTableEXT := TglColorTableEXT(wglGetProcAddress('glColorTableEXT'{$IFDEF CLR}, typeof(TglColorTableEXT){$ENDIF}));
  glGetColorTableEXT := TglGetColorTableEXT(wglGetProcAddress('glGetColorTableEXT'{$IFDEF CLR}, typeof(TglGetColorTableEXT){$ENDIF}));
  glGetColorTableParameterivEXT := TglGetColorTableParameterivEXT(wglGetProcAddress('glGetColorTableParameterivEXT'{$IFDEF CLR}, typeof(TglGetColorTableParameterivEXT){$ENDIF}));
  glGetColorTableParameterfvEXT := TglGetColorTableParameterfvEXT(wglGetProcAddress('glGetColorTableParameterfvEXT'{$IFDEF CLR}, typeof(TglGetColorTableParameterfvEXT){$ENDIF}));
end;

procedure Read_GL_EXT_pixel_transform;
begin
  glPixelTransformParameteriEXT := TglPixelTransformParameteriEXT(wglGetProcAddress('glPixelTransformParameteriEXT'{$IFDEF CLR}, typeof(TglPixelTransformParameteriEXT){$ENDIF}));
  glPixelTransformParameterfEXT := TglPixelTransformParameterfEXT(wglGetProcAddress('glPixelTransformParameterfEXT'{$IFDEF CLR}, typeof(TglPixelTransformParameterfEXT){$ENDIF}));
  glPixelTransformParameterivEXT := TglPixelTransformParameterivEXT(wglGetProcAddress('glPixelTransformParameterivEXT'{$IFDEF CLR}, typeof(TglPixelTransformParameterivEXT){$ENDIF}));
  glPixelTransformParameterfvEXT := TglPixelTransformParameterfvEXT(wglGetProcAddress('glPixelTransformParameterfvEXT'{$IFDEF CLR}, typeof(TglPixelTransformParameterfvEXT){$ENDIF}));
end;

procedure Read_GL_EXT_point_parameters;
begin
  glPointParameterfEXT := TglPointParameterfEXT(wglGetProcAddress('glPointParameterfEXT'{$IFDEF CLR}, typeof(TglPointParameterfEXT){$ENDIF}));
  glPointParameterfvEXT := TglPointParameterfvEXT(wglGetProcAddress('glPointParameterfvEXT'{$IFDEF CLR}, typeof(TglPointParameterfvEXT){$ENDIF}));
end;

procedure Read_GL_EXT_polygon_offset;
begin
  glPolygonOffsetEXT := TglPolygonOffsetEXT(wglGetProcAddress('glPolygonOffsetEXT'{$IFDEF CLR}, typeof(TglPolygonOffsetEXT){$ENDIF}));
end;

procedure Read_GL_EXT_secondary_color;
begin
  glSecondaryColor3bEXT := TglSecondaryColor3bEXT(wglGetProcAddress('glSecondaryColor3bEXT'{$IFDEF CLR}, typeof(TglSecondaryColor3bEXT){$ENDIF}));
  glSecondaryColor3bvEXT := TglSecondaryColor3bvEXT(wglGetProcAddress('glSecondaryColor3bvEXT'{$IFDEF CLR}, typeof(TglSecondaryColor3bvEXT){$ENDIF}));
  glSecondaryColor3dEXT := TglSecondaryColor3dEXT(wglGetProcAddress('glSecondaryColor3dEXT'{$IFDEF CLR}, typeof(TglSecondaryColor3dEXT){$ENDIF}));
  glSecondaryColor3dvEXT := TglSecondaryColor3dvEXT(wglGetProcAddress('glSecondaryColor3dvEXT'{$IFDEF CLR}, typeof(TglSecondaryColor3dvEXT){$ENDIF}));
  glSecondaryColor3fEXT := TglSecondaryColor3fEXT(wglGetProcAddress('glSecondaryColor3fEXT'{$IFDEF CLR}, typeof(TglSecondaryColor3fEXT){$ENDIF}));
  glSecondaryColor3fvEXT := TglSecondaryColor3fvEXT(wglGetProcAddress('glSecondaryColor3fvEXT'{$IFDEF CLR}, typeof(TglSecondaryColor3fvEXT){$ENDIF}));
  glSecondaryColor3iEXT := TglSecondaryColor3iEXT(wglGetProcAddress('glSecondaryColor3iEXT'{$IFDEF CLR}, typeof(TglSecondaryColor3iEXT){$ENDIF}));
  glSecondaryColor3ivEXT := TglSecondaryColor3ivEXT(wglGetProcAddress('glSecondaryColor3ivEXT'{$IFDEF CLR}, typeof(TglSecondaryColor3ivEXT){$ENDIF}));
  glSecondaryColor3sEXT := TglSecondaryColor3sEXT(wglGetProcAddress('glSecondaryColor3sEXT'{$IFDEF CLR}, typeof(TglSecondaryColor3sEXT){$ENDIF}));
  glSecondaryColor3svEXT := TglSecondaryColor3svEXT(wglGetProcAddress('glSecondaryColor3svEXT'{$IFDEF CLR}, typeof(TglSecondaryColor3svEXT){$ENDIF}));
  glSecondaryColor3ubEXT := TglSecondaryColor3ubEXT(wglGetProcAddress('glSecondaryColor3ubEXT'{$IFDEF CLR}, typeof(TglSecondaryColor3ubEXT){$ENDIF}));
  glSecondaryColor3ubvEXT := TglSecondaryColor3ubvEXT(wglGetProcAddress('glSecondaryColor3ubvEXT'{$IFDEF CLR}, typeof(TglSecondaryColor3ubvEXT){$ENDIF}));
  glSecondaryColor3uiEXT := TglSecondaryColor3uiEXT(wglGetProcAddress('glSecondaryColor3uiEXT'{$IFDEF CLR}, typeof(TglSecondaryColor3uiEXT){$ENDIF}));
  glSecondaryColor3uivEXT := TglSecondaryColor3uivEXT(wglGetProcAddress('glSecondaryColor3uivEXT'{$IFDEF CLR}, typeof(TglSecondaryColor3uivEXT){$ENDIF}));
  glSecondaryColor3usEXT := TglSecondaryColor3usEXT(wglGetProcAddress('glSecondaryColor3usEXT'{$IFDEF CLR}, typeof(TglSecondaryColor3usEXT){$ENDIF}));
  glSecondaryColor3usvEXT := TglSecondaryColor3usvEXT(wglGetProcAddress('glSecondaryColor3usvEXT'{$IFDEF CLR}, typeof(TglSecondaryColor3usvEXT){$ENDIF}));
  glSecondaryColorPointerEXT := TglSecondaryColorPointerEXT(wglGetProcAddress('glSecondaryColorPointerEXT'{$IFDEF CLR}, typeof(TglSecondaryColorPointerEXT){$ENDIF}));
end;

procedure Read_GL_EXT_stencil_two_side;
begin
  glActiveStencilFaceEXT := TglActiveStencilFaceEXT(wglGetProcAddress('glActiveStencilFaceEXT'{$IFDEF CLR}, typeof(TglActiveStencilFaceEXT){$ENDIF}));
end;

procedure Read_GL_EXT_subtexture;
begin
  glTexSubImage1DEXT := TglTexSubImage1DEXT(wglGetProcAddress('glTexSubImage1DEXT'{$IFDEF CLR}, typeof(TglTexSubImage1DEXT){$ENDIF}));
  glTexSubImage2DEXT := TglTexSubImage2DEXT(wglGetProcAddress('glTexSubImage2DEXT'{$IFDEF CLR}, typeof(TglTexSubImage2DEXT){$ENDIF}));
end;

procedure Read_GL_EXT_texture3D;
begin
  glTexImage3DEXT := TglTexImage3DEXT(wglGetProcAddress('glTexImage3DEXT'{$IFDEF CLR}, typeof(TglTexImage3DEXT){$ENDIF}));
  glTexSubImage3DEXT := TglTexSubImage3DEXT(wglGetProcAddress('glTexSubImage3DEXT'{$IFDEF CLR}, typeof(TglTexSubImage3DEXT){$ENDIF}));
end;

procedure Read_GL_EXT_texture_object;
begin
  glAreTexturesResidentEXT := TglAreTexturesResidentEXT(wglGetProcAddress('glAreTexturesResidentEXT'{$IFDEF CLR}, typeof(TglAreTexturesResidentEXT){$ENDIF}));
  glBindTextureEXT := TglBindTextureEXT(wglGetProcAddress('glBindTextureEXT'{$IFDEF CLR}, typeof(TglBindTextureEXT){$ENDIF}));
  glDeleteTexturesEXT := TglDeleteTexturesEXT(wglGetProcAddress('glDeleteTexturesEXT'{$IFDEF CLR}, typeof(TglDeleteTexturesEXT){$ENDIF}));
  glGenTexturesEXT := TglGenTexturesEXT(wglGetProcAddress('glGenTexturesEXT'{$IFDEF CLR}, typeof(TglGenTexturesEXT){$ENDIF}));
  glIsTextureEXT := TglIsTextureEXT(wglGetProcAddress('glIsTextureEXT'{$IFDEF CLR}, typeof(TglIsTextureEXT){$ENDIF}));
  glPrioritizeTexturesEXT := TglPrioritizeTexturesEXT(wglGetProcAddress('glPrioritizeTexturesEXT'{$IFDEF CLR}, typeof(TglPrioritizeTexturesEXT){$ENDIF}));
end;

procedure Read_GL_EXT_texture_perturb_normal;
begin
  glTextureNormalEXT := TglTextureNormalEXT(wglGetProcAddress('glTextureNormalEXT'{$IFDEF CLR}, typeof(TglTextureNormalEXT){$ENDIF}));
end;

procedure Read_GL_EXT_vertex_array;
begin
  glArrayElementEXT := TglArrayElementEXT(wglGetProcAddress('glArrayElementEXT'{$IFDEF CLR}, typeof(TglArrayElementEXT){$ENDIF}));
  glColorPointerEXT := TglColorPointerEXT(wglGetProcAddress('glColorPointerEXT'{$IFDEF CLR}, typeof(TglColorPointerEXT){$ENDIF}));
  glDrawArraysEXT := TglDrawArraysEXT(wglGetProcAddress('glDrawArraysEXT'{$IFDEF CLR}, typeof(TglDrawArraysEXT){$ENDIF}));
  glEdgeFlagPointerEXT := TglEdgeFlagPointerEXT(wglGetProcAddress('glEdgeFlagPointerEXT'{$IFDEF CLR}, typeof(TglEdgeFlagPointerEXT){$ENDIF}));
  glGetPointervEXT := TglGetPointervEXT(wglGetProcAddress('glGetPointervEXT'{$IFDEF CLR}, typeof(TglGetPointervEXT){$ENDIF}));
  glIndexPointerEXT := TglIndexPointerEXT(wglGetProcAddress('glIndexPointerEXT'{$IFDEF CLR}, typeof(TglIndexPointerEXT){$ENDIF}));
  glNormalPointerEXT := TglNormalPointerEXT(wglGetProcAddress('glNormalPointerEXT'{$IFDEF CLR}, typeof(TglNormalPointerEXT){$ENDIF}));
  glTexCoordPointerEXT := TglTexCoordPointerEXT(wglGetProcAddress('glTexCoordPointerEXT'{$IFDEF CLR}, typeof(TglTexCoordPointerEXT){$ENDIF}));
  glVertexPointerEXT := TglVertexPointerEXT(wglGetProcAddress('glVertexPointerEXT'{$IFDEF CLR}, typeof(TglVertexPointerEXT){$ENDIF}));
end;

procedure Read_GL_EXT_vertex_shader;
begin
  glBeginVertexShaderEXT := TglBeginVertexShaderEXT(wglGetProcAddress('glBeginVertexShaderEXT'{$IFDEF CLR}, typeof(TglBeginVertexShaderEXT){$ENDIF}));
  glEndVertexShaderEXT := TglEndVertexShaderEXT(wglGetProcAddress('glEndVertexShaderEXT'{$IFDEF CLR}, typeof(TglEndVertexShaderEXT){$ENDIF}));
  glBindVertexShaderEXT := TglBindVertexShaderEXT(wglGetProcAddress('glBindVertexShaderEXT'{$IFDEF CLR}, typeof(TglBindVertexShaderEXT){$ENDIF}));
  glGenVertexShadersEXT := TglGenVertexShadersEXT(wglGetProcAddress('glGenVertexShadersEXT'{$IFDEF CLR}, typeof(TglGenVertexShadersEXT){$ENDIF}));
  glDeleteVertexShaderEXT := TglDeleteVertexShaderEXT(wglGetProcAddress('glDeleteVertexShaderEXT'{$IFDEF CLR}, typeof(TglDeleteVertexShaderEXT){$ENDIF}));
  glShaderOp1EXT := TglShaderOp1EXT(wglGetProcAddress('glShaderOp1EXT'{$IFDEF CLR}, typeof(TglShaderOp1EXT){$ENDIF}));
  glShaderOp2EXT := TglShaderOp2EXT(wglGetProcAddress('glShaderOp2EXT'{$IFDEF CLR}, typeof(TglShaderOp2EXT){$ENDIF}));
  glShaderOp3EXT := TglShaderOp3EXT(wglGetProcAddress('glShaderOp3EXT'{$IFDEF CLR}, typeof(TglShaderOp3EXT){$ENDIF}));
  glSwizzleEXT := TglSwizzleEXT(wglGetProcAddress('glSwizzleEXT'{$IFDEF CLR}, typeof(TglSwizzleEXT){$ENDIF}));
  glWriteMaskEXT := TglWriteMaskEXT(wglGetProcAddress('glWriteMaskEXT'{$IFDEF CLR}, typeof(TglWriteMaskEXT){$ENDIF}));
  glInsertComponentEXT := TglInsertComponentEXT(wglGetProcAddress('glInsertComponentEXT'{$IFDEF CLR}, typeof(TglInsertComponentEXT){$ENDIF}));
  glExtractComponentEXT := TglExtractComponentEXT(wglGetProcAddress('glExtractComponentEXT'{$IFDEF CLR}, typeof(TglExtractComponentEXT){$ENDIF}));
  glGenSymbolsEXT := TglGenSymbolsEXT(wglGetProcAddress('glGenSymbolsEXT'{$IFDEF CLR}, typeof(TglGenSymbolsEXT){$ENDIF}));
  glSetInvariantEXT := TglSetInvariantEXT(wglGetProcAddress('glSetInvariantEXT'{$IFDEF CLR}, typeof(TglSetInvariantEXT){$ENDIF}));
  glSetLocalConstantEXT := TglSetLocalConstantEXT(wglGetProcAddress('glSetLocalConstantEXT'{$IFDEF CLR}, typeof(TglSetLocalConstantEXT){$ENDIF}));
  glVariantbvEXT := TglVariantbvEXT(wglGetProcAddress('glVariantbvEXT'{$IFDEF CLR}, typeof(TglVariantbvEXT){$ENDIF}));
  glVariantsvEXT := TglVariantsvEXT(wglGetProcAddress('glVariantsvEXT'{$IFDEF CLR}, typeof(TglVariantsvEXT){$ENDIF}));
  glVariantivEXT := TglVariantivEXT(wglGetProcAddress('glVariantivEXT'{$IFDEF CLR}, typeof(TglVariantivEXT){$ENDIF}));
  glVariantfvEXT := TglVariantfvEXT(wglGetProcAddress('glVariantfvEXT'{$IFDEF CLR}, typeof(TglVariantfvEXT){$ENDIF}));
  glVariantdvEXT := TglVariantdvEXT(wglGetProcAddress('glVariantdvEXT'{$IFDEF CLR}, typeof(TglVariantdvEXT){$ENDIF}));
  glVariantubvEXT := TglVariantubvEXT(wglGetProcAddress('glVariantubvEXT'{$IFDEF CLR}, typeof(TglVariantubvEXT){$ENDIF}));
  glVariantusvEXT := TglVariantusvEXT(wglGetProcAddress('glVariantusvEXT'{$IFDEF CLR}, typeof(TglVariantusvEXT){$ENDIF}));
  glVariantuivEXT := TglVariantuivEXT(wglGetProcAddress('glVariantuivEXT'{$IFDEF CLR}, typeof(TglVariantuivEXT){$ENDIF}));
  glVariantPointerEXT := TglVariantPointerEXT(wglGetProcAddress('glVariantPointerEXT'{$IFDEF CLR}, typeof(TglVariantPointerEXT){$ENDIF}));
  glEnableVariantClientStateEXT := TglEnableVariantClientStateEXT(wglGetProcAddress('glEnableVariantClientStateEXT'{$IFDEF CLR}, typeof(TglEnableVariantClientStateEXT){$ENDIF}));
  glDisableVariantClientStateEXT := TglDisableVariantClientStateEXT(wglGetProcAddress('glDisableVariantClientStateEXT'{$IFDEF CLR}, typeof(TglDisableVariantClientStateEXT){$ENDIF}));
  glBindLightParameterEXT := TglBindLightParameterEXT(wglGetProcAddress('glBindLightParameterEXT'{$IFDEF CLR}, typeof(TglBindLightParameterEXT){$ENDIF}));
  glBindMaterialParameterEXT := TglBindMaterialParameterEXT(wglGetProcAddress('glBindMaterialParameterEXT'{$IFDEF CLR}, typeof(TglBindMaterialParameterEXT){$ENDIF}));
  glBindTexGenParameterEXT := TglBindTexGenParameterEXT(wglGetProcAddress('glBindTexGenParameterEXT'{$IFDEF CLR}, typeof(TglBindTexGenParameterEXT){$ENDIF}));
  glBindTextureUnitParameterEXT := TglBindTextureUnitParameterEXT(wglGetProcAddress('glBindTextureUnitParameterEXT'{$IFDEF CLR}, typeof(TglBindTextureUnitParameterEXT){$ENDIF}));
  glBindParameterEXT := TglBindParameterEXT(wglGetProcAddress('glBindParameterEXT'{$IFDEF CLR}, typeof(TglBindParameterEXT){$ENDIF}));
  glIsVariantEnabledEXT := TglIsVariantEnabledEXT(wglGetProcAddress('glIsVariantEnabledEXT'{$IFDEF CLR}, typeof(TglIsVariantEnabledEXT){$ENDIF}));
  glGetVariantBooleanvEXT := TglGetVariantBooleanvEXT(wglGetProcAddress('glGetVariantBooleanvEXT'{$IFDEF CLR}, typeof(TglGetVariantBooleanvEXT){$ENDIF}));
  glGetVariantIntegervEXT := TglGetVariantIntegervEXT(wglGetProcAddress('glGetVariantIntegervEXT'{$IFDEF CLR}, typeof(TglGetVariantIntegervEXT){$ENDIF}));
  glGetVariantFloatvEXT := TglGetVariantFloatvEXT(wglGetProcAddress('glGetVariantFloatvEXT'{$IFDEF CLR}, typeof(TglGetVariantFloatvEXT){$ENDIF}));
  glGetVariantPointervEXT := TglGetVariantPointervEXT(wglGetProcAddress('glGetVariantPointervEXT'{$IFDEF CLR}, typeof(TglGetVariantPointervEXT){$ENDIF}));
  glGetInvariantBooleanvEXT := TglGetInvariantBooleanvEXT(wglGetProcAddress('glGetInvariantBooleanvEXT'{$IFDEF CLR}, typeof(TglGetInvariantBooleanvEXT){$ENDIF}));
  glGetInvariantIntegervEXT := TglGetInvariantIntegervEXT(wglGetProcAddress('glGetInvariantIntegervEXT'{$IFDEF CLR}, typeof(TglGetInvariantIntegervEXT){$ENDIF}));
  glGetInvariantFloatvEXT := TglGetInvariantFloatvEXT(wglGetProcAddress('glGetInvariantFloatvEXT'{$IFDEF CLR}, typeof(TglGetInvariantFloatvEXT){$ENDIF}));
  glGetLocalConstantBooleanvEXT := TglGetLocalConstantBooleanvEXT(wglGetProcAddress('glGetLocalConstantBooleanvEXT'{$IFDEF CLR}, typeof(TglGetLocalConstantBooleanvEXT){$ENDIF}));
  glGetLocalConstantIntegervEXT := TglGetLocalConstantIntegervEXT(wglGetProcAddress('glGetLocalConstantIntegervEXT'{$IFDEF CLR}, typeof(TglGetLocalConstantIntegervEXT){$ENDIF}));
  glGetLocalConstantFloatvEXT := TglGetLocalConstantFloatvEXT(wglGetProcAddress('glGetLocalConstantFloatvEXT'{$IFDEF CLR}, typeof(TglGetLocalConstantFloatvEXT){$ENDIF}));
end;

procedure Read_GL_EXT_vertex_weighting;
begin
  glVertexWeightfEXT := TglVertexWeightfEXT(wglGetProcAddress('glVertexWeightfEXT'{$IFDEF CLR}, typeof(TglVertexWeightfEXT){$ENDIF}));
  glVertexWeightfvEXT := TglVertexWeightfvEXT(wglGetProcAddress('glVertexWeightfvEXT'{$IFDEF CLR}, typeof(TglVertexWeightfvEXT){$ENDIF}));
  glVertexWeightPointerEXT := TglVertexWeightPointerEXT(wglGetProcAddress('glVertexWeightPointerEXT'{$IFDEF CLR}, typeof(TglVertexWeightPointerEXT){$ENDIF}));
end;

procedure Read_GL_EXT_depth_bounds_test;
begin
  glDepthBoundsEXT := TglDepthBoundsEXT(wglGetProcAddress('glDepthBoundsEXT'{$IFDEF CLR}, typeof(TglDepthBoundsEXT){$ENDIF}));
end;

procedure Read_GL_EXT_blend_equation_separate;
begin
  glBlendEquationSeparateEXT := TglBlendEquationSeparateEXT(wglGetProcAddress('glBlendEquationSeparateEXT'{$IFDEF CLR}, typeof(TglBlendEquationSeparateEXT){$ENDIF}));
end;

procedure Read_GL_EXT_stencil_clear_tag;
begin
  glStencilClearTagEXT := TglStencilClearTagEXT(wglGetProcAddress('glStencilClearTagEXT'{$IFDEF CLR}, typeof(TglStencilClearTagEXT){$ENDIF}));
end;

procedure Read_GL_HP_image_transform;
begin
  glImageTransformParameteriHP := TglImageTransformParameteriHP(wglGetProcAddress('glImageTransformParameteriHP'{$IFDEF CLR}, typeof(TglImageTransformParameteriHP){$ENDIF}));
  glImageTransformParameterfHP := TglImageTransformParameterfHP(wglGetProcAddress('glImageTransformParameterfHP'{$IFDEF CLR}, typeof(TglImageTransformParameterfHP){$ENDIF}));
  glImageTransformParameterivHP := TglImageTransformParameterivHP(wglGetProcAddress('glImageTransformParameterivHP'{$IFDEF CLR}, typeof(TglImageTransformParameterivHP){$ENDIF}));
  glImageTransformParameterfvHP := TglImageTransformParameterfvHP(wglGetProcAddress('glImageTransformParameterfvHP'{$IFDEF CLR}, typeof(TglImageTransformParameterfvHP){$ENDIF}));
  glGetImageTransformParameterivHP := TglGetImageTransformParameterivHP(wglGetProcAddress('glGetImageTransformParameterivHP'{$IFDEF CLR}, typeof(TglGetImageTransformParameterivHP){$ENDIF}));
  glGetImageTransformParameterfvHP := TglGetImageTransformParameterfvHP(wglGetProcAddress('glGetImageTransformParameterfvHP'{$IFDEF CLR}, typeof(TglGetImageTransformParameterfvHP){$ENDIF}));
end;

procedure Read_GL_IBM_multimode_draw_arrays;
begin
  glMultiModeDrawArraysIBM := TglMultiModeDrawArraysIBM(wglGetProcAddress('glMultiModeDrawArraysIBM'{$IFDEF CLR}, typeof(TglMultiModeDrawArraysIBM){$ENDIF}));
  glMultiModeDrawElementsIBM := TglMultiModeDrawElementsIBM(wglGetProcAddress('glMultiModeDrawElementsIBM'{$IFDEF CLR}, typeof(TglMultiModeDrawElementsIBM){$ENDIF}));
end;

procedure Read_GL_IBM_vertex_array_lists;
begin
  glColorPointerListIBM := TglColorPointerListIBM(wglGetProcAddress('glColorPointerListIBM'{$IFDEF CLR}, typeof(TglColorPointerListIBM){$ENDIF}));
  glSecondaryColorPointerListIBM := TglSecondaryColorPointerListIBM(wglGetProcAddress('glSecondaryColorPointerListIBM'{$IFDEF CLR}, typeof(TglSecondaryColorPointerListIBM){$ENDIF}));
  glEdgeFlagPointerListIBM := TglEdgeFlagPointerListIBM(wglGetProcAddress('glEdgeFlagPointerListIBM'{$IFDEF CLR}, typeof(TglEdgeFlagPointerListIBM){$ENDIF}));
  glFogCoordPointerListIBM := TglFogCoordPointerListIBM(wglGetProcAddress('glFogCoordPointerListIBM'{$IFDEF CLR}, typeof(TglFogCoordPointerListIBM){$ENDIF}));
  glIndexPointerListIBM := TglIndexPointerListIBM(wglGetProcAddress('glIndexPointerListIBM'{$IFDEF CLR}, typeof(TglIndexPointerListIBM){$ENDIF}));
  glNormalPointerListIBM := TglNormalPointerListIBM(wglGetProcAddress('glNormalPointerListIBM'{$IFDEF CLR}, typeof(TglNormalPointerListIBM){$ENDIF}));
  glTexCoordPointerListIBM := TglTexCoordPointerListIBM(wglGetProcAddress('glTexCoordPointerListIBM'{$IFDEF CLR}, typeof(TglTexCoordPointerListIBM){$ENDIF}));
  glVertexPointerListIBM := TglVertexPointerListIBM(wglGetProcAddress('glVertexPointerListIBM'{$IFDEF CLR}, typeof(TglVertexPointerListIBM){$ENDIF}));
end;

procedure Read_GL_INGR_blend_func_separate;
begin
  glBlendFuncSeparateINGR := TglBlendFuncSeparateINGR(wglGetProcAddress('glBlendFuncSeparateINGR'{$IFDEF CLR}, typeof(TglBlendFuncSeparateINGR){$ENDIF}));
end;

procedure Read_GL_INTEL_parallel_arrays;
begin
  glVertexPointervINTEL := TglVertexPointervINTEL(wglGetProcAddress('glVertexPointervINTEL'{$IFDEF CLR}, typeof(TglVertexPointervINTEL){$ENDIF}));
  glNormalPointervINTEL := TglNormalPointervINTEL(wglGetProcAddress('glNormalPointervINTEL'{$IFDEF CLR}, typeof(TglNormalPointervINTEL){$ENDIF}));
  glColorPointervINTEL := TglColorPointervINTEL(wglGetProcAddress('glColorPointervINTEL'{$IFDEF CLR}, typeof(TglColorPointervINTEL){$ENDIF}));
  glTexCoordPointervINTEL := TglTexCoordPointervINTEL(wglGetProcAddress('glTexCoordPointervINTEL'{$IFDEF CLR}, typeof(TglTexCoordPointervINTEL){$ENDIF}));
end;

procedure Read_GL_MESA_resize_buffers;
begin
  glResizeBuffersMESA := TglResizeBuffersMESA(wglGetProcAddress('glResizeBuffersMESA'{$IFDEF CLR}, typeof(TglResizeBuffersMESA){$ENDIF}));
end;

procedure Read_GL_MESA_window_pos;
begin
  glWindowPos2dMESA := TglWindowPos2dMESA(wglGetProcAddress('glWindowPos2dMESA'{$IFDEF CLR}, typeof(TglWindowPos2dMESA){$ENDIF}));
  glWindowPos2dvMESA := TglWindowPos2dvMESA(wglGetProcAddress('glWindowPos2dvMESA'{$IFDEF CLR}, typeof(TglWindowPos2dvMESA){$ENDIF}));
  glWindowPos2fMESA := TglWindowPos2fMESA(wglGetProcAddress('glWindowPos2fMESA'{$IFDEF CLR}, typeof(TglWindowPos2fMESA){$ENDIF}));
  glWindowPos2fvMESA := TglWindowPos2fvMESA(wglGetProcAddress('glWindowPos2fvMESA'{$IFDEF CLR}, typeof(TglWindowPos2fvMESA){$ENDIF}));
  glWindowPos2iMESA := TglWindowPos2iMESA(wglGetProcAddress('glWindowPos2iMESA'{$IFDEF CLR}, typeof(TglWindowPos2iMESA){$ENDIF}));
  glWindowPos2ivMESA := TglWindowPos2ivMESA(wglGetProcAddress('glWindowPos2ivMESA'{$IFDEF CLR}, typeof(TglWindowPos2ivMESA){$ENDIF}));
  glWindowPos2sMESA := TglWindowPos2sMESA(wglGetProcAddress('glWindowPos2sMESA'{$IFDEF CLR}, typeof(TglWindowPos2sMESA){$ENDIF}));
  glWindowPos2svMESA := TglWindowPos2svMESA(wglGetProcAddress('glWindowPos2svMESA'{$IFDEF CLR}, typeof(TglWindowPos2svMESA){$ENDIF}));
  glWindowPos3dMESA := TglWindowPos3dMESA(wglGetProcAddress('glWindowPos3dMESA'{$IFDEF CLR}, typeof(TglWindowPos3dMESA){$ENDIF}));
  glWindowPos3dvMESA := TglWindowPos3dvMESA(wglGetProcAddress('glWindowPos3dvMESA'{$IFDEF CLR}, typeof(TglWindowPos3dvMESA){$ENDIF}));
  glWindowPos3fMESA := TglWindowPos3fMESA(wglGetProcAddress('glWindowPos3fMESA'{$IFDEF CLR}, typeof(TglWindowPos3fMESA){$ENDIF}));
  glWindowPos3fvMESA := TglWindowPos3fvMESA(wglGetProcAddress('glWindowPos3fvMESA'{$IFDEF CLR}, typeof(TglWindowPos3fvMESA){$ENDIF}));
  glWindowPos3iMESA := TglWindowPos3iMESA(wglGetProcAddress('glWindowPos3iMESA'{$IFDEF CLR}, typeof(TglWindowPos3iMESA){$ENDIF}));
  glWindowPos3ivMESA := TglWindowPos3ivMESA(wglGetProcAddress('glWindowPos3ivMESA'{$IFDEF CLR}, typeof(TglWindowPos3ivMESA){$ENDIF}));
  glWindowPos3sMESA := TglWindowPos3sMESA(wglGetProcAddress('glWindowPos3sMESA'{$IFDEF CLR}, typeof(TglWindowPos3sMESA){$ENDIF}));
  glWindowPos3svMESA := TglWindowPos3svMESA(wglGetProcAddress('glWindowPos3svMESA'{$IFDEF CLR}, typeof(TglWindowPos3svMESA){$ENDIF}));
  glWindowPos4dMESA := TglWindowPos4dMESA(wglGetProcAddress('glWindowPos4dMESA'{$IFDEF CLR}, typeof(TglWindowPos4dMESA){$ENDIF}));
  glWindowPos4dvMESA := TglWindowPos4dvMESA(wglGetProcAddress('glWindowPos4dvMESA'{$IFDEF CLR}, typeof(TglWindowPos4dvMESA){$ENDIF}));
  glWindowPos4fMESA := TglWindowPos4fMESA(wglGetProcAddress('glWindowPos4fMESA'{$IFDEF CLR}, typeof(TglWindowPos4fMESA){$ENDIF}));
  glWindowPos4fvMESA := TglWindowPos4fvMESA(wglGetProcAddress('glWindowPos4fvMESA'{$IFDEF CLR}, typeof(TglWindowPos4fvMESA){$ENDIF}));
  glWindowPos4iMESA := TglWindowPos4iMESA(wglGetProcAddress('glWindowPos4iMESA'{$IFDEF CLR}, typeof(TglWindowPos4iMESA){$ENDIF}));
  glWindowPos4ivMESA := TglWindowPos4ivMESA(wglGetProcAddress('glWindowPos4ivMESA'{$IFDEF CLR}, typeof(TglWindowPos4ivMESA){$ENDIF}));
  glWindowPos4sMESA := TglWindowPos4sMESA(wglGetProcAddress('glWindowPos4sMESA'{$IFDEF CLR}, typeof(TglWindowPos4sMESA){$ENDIF}));
  glWindowPos4svMESA := TglWindowPos4svMESA(wglGetProcAddress('glWindowPos4svMESA'{$IFDEF CLR}, typeof(TglWindowPos4svMESA){$ENDIF}));
end;

procedure Read_GL_NV_evaluators;
begin
  glMapControlPointsNV := TglMapControlPointsNV(wglGetProcAddress('glMapControlPointsNV'{$IFDEF CLR}, typeof(TglMapControlPointsNV){$ENDIF}));
  glMapParameterivNV := TglMapParameterivNV(wglGetProcAddress('glMapParameterivNV'{$IFDEF CLR}, typeof(TglMapParameterivNV){$ENDIF}));
  glMapParameterfvNV := TglMapParameterfvNV(wglGetProcAddress('glMapParameterfvNV'{$IFDEF CLR}, typeof(TglMapParameterfvNV){$ENDIF}));
  glGetMapControlPointsNV := TglGetMapControlPointsNV(wglGetProcAddress('glGetMapControlPointsNV'{$IFDEF CLR}, typeof(TglGetMapControlPointsNV){$ENDIF}));
  glGetMapParameterivNV := TglGetMapParameterivNV(wglGetProcAddress('glGetMapParameterivNV'{$IFDEF CLR}, typeof(TglGetMapParameterivNV){$ENDIF}));
  glGetMapParameterfvNV := TglGetMapParameterfvNV(wglGetProcAddress('glGetMapParameterfvNV'{$IFDEF CLR}, typeof(TglGetMapParameterfvNV){$ENDIF}));
  glGetMapAttribParameterivNV := TglGetMapAttribParameterivNV(wglGetProcAddress('glGetMapAttribParameterivNV'{$IFDEF CLR}, typeof(TglGetMapAttribParameterivNV){$ENDIF}));
  glGetMapAttribParameterfvNV := TglGetMapAttribParameterfvNV(wglGetProcAddress('glGetMapAttribParameterfvNV'{$IFDEF CLR}, typeof(TglGetMapAttribParameterfvNV){$ENDIF}));
  glEvalMapsNV := TglEvalMapsNV(wglGetProcAddress('glEvalMapsNV'{$IFDEF CLR}, typeof(TglEvalMapsNV){$ENDIF}));
end;

procedure Read_GL_NV_fence;
begin
  glDeleteFencesNV := TglDeleteFencesNV(wglGetProcAddress('glDeleteFencesNV'{$IFDEF CLR}, typeof(TglDeleteFencesNV){$ENDIF}));
  glGenFencesNV := TglGenFencesNV(wglGetProcAddress('glGenFencesNV'{$IFDEF CLR}, typeof(TglGenFencesNV){$ENDIF}));
  glIsFenceNV := TglIsFenceNV(wglGetProcAddress('glIsFenceNV'{$IFDEF CLR}, typeof(TglIsFenceNV){$ENDIF}));
  glTestFenceNV := TglTestFenceNV(wglGetProcAddress('glTestFenceNV'{$IFDEF CLR}, typeof(TglTestFenceNV){$ENDIF}));
  glGetFenceivNV := TglGetFenceivNV(wglGetProcAddress('glGetFenceivNV'{$IFDEF CLR}, typeof(TglGetFenceivNV){$ENDIF}));
  glFinishFenceNV := TglFinishFenceNV(wglGetProcAddress('glFinishFenceNV'{$IFDEF CLR}, typeof(TglFinishFenceNV){$ENDIF}));
  glSetFenceNV := TglSetFenceNV(wglGetProcAddress('glSetFenceNV'{$IFDEF CLR}, typeof(TglSetFenceNV){$ENDIF}));
end;

procedure Read_GL_NV_fragment_program;
begin
  glProgramNamedParameter4fNV := TglProgramNamedParameter4fNV(wglGetProcAddress('glProgramNamedParameter4fNV'{$IFDEF CLR}, typeof(TglProgramNamedParameter4fNV){$ENDIF}));
  glProgramNamedParameter4dNV := TglProgramNamedParameter4dNV(wglGetProcAddress('glProgramNamedParameter4dNV'{$IFDEF CLR}, typeof(TglProgramNamedParameter4dNV){$ENDIF}));
  glProgramNamedParameter4fvNV := TglProgramNamedParameter4fvNV(wglGetProcAddress('glProgramNamedParameter4fvNV'{$IFDEF CLR}, typeof(TglProgramNamedParameter4fvNV){$ENDIF}));
  glProgramNamedParameter4dvNV := TglProgramNamedParameter4dvNV(wglGetProcAddress('glProgramNamedParameter4dvNV'{$IFDEF CLR}, typeof(TglProgramNamedParameter4dvNV){$ENDIF}));
  glGetProgramNamedParameterfvNV := TglGetProgramNamedParameterfvNV(wglGetProcAddress('glGetProgramNamedParameterfvNV'{$IFDEF CLR}, typeof(TglGetProgramNamedParameterfvNV){$ENDIF}));
  glGetProgramNamedParameterdvNV := TglGetProgramNamedParameterdvNV(wglGetProcAddress('glGetProgramNamedParameterdvNV'{$IFDEF CLR}, typeof(TglGetProgramNamedParameterdvNV){$ENDIF}));
end;

procedure Read_GL_NV_half_float;
begin
  glVertex2hNV := TglVertex2hNV(wglGetProcAddress('glVertex2hNV'{$IFDEF CLR}, typeof(TglVertex2hNV){$ENDIF}));
  glVertex2hvNV := TglVertex2hvNV(wglGetProcAddress('glVertex2hvNV'{$IFDEF CLR}, typeof(TglVertex2hvNV){$ENDIF}));
  glVertex3hNV := TglVertex3hNV(wglGetProcAddress('glVertex3hNV'{$IFDEF CLR}, typeof(TglVertex3hNV){$ENDIF}));
  glVertex3hvNV := TglVertex3hvNV(wglGetProcAddress('glVertex3hvNV'{$IFDEF CLR}, typeof(TglVertex3hvNV){$ENDIF}));
  glVertex4hNV := TglVertex4hNV(wglGetProcAddress('glVertex4hNV'{$IFDEF CLR}, typeof(TglVertex4hNV){$ENDIF}));
  glVertex4hvNV := TglVertex4hvNV(wglGetProcAddress('glVertex4hvNV'{$IFDEF CLR}, typeof(TglVertex4hvNV){$ENDIF}));
  glNormal3hNV := TglNormal3hNV(wglGetProcAddress('glNormal3hNV'{$IFDEF CLR}, typeof(TglNormal3hNV){$ENDIF}));
  glNormal3hvNV := TglNormal3hvNV(wglGetProcAddress('glNormal3hvNV'{$IFDEF CLR}, typeof(TglNormal3hvNV){$ENDIF}));
  glColor3hNV := TglColor3hNV(wglGetProcAddress('glColor3hNV'{$IFDEF CLR}, typeof(TglColor3hNV){$ENDIF}));
  glColor3hvNV := TglColor3hvNV(wglGetProcAddress('glColor3hvNV'{$IFDEF CLR}, typeof(TglColor3hvNV){$ENDIF}));
  glColor4hNV := TglColor4hNV(wglGetProcAddress('glColor4hNV'{$IFDEF CLR}, typeof(TglColor4hNV){$ENDIF}));
  glColor4hvNV := TglColor4hvNV(wglGetProcAddress('glColor4hvNV'{$IFDEF CLR}, typeof(TglColor4hvNV){$ENDIF}));
  glTexCoord1hNV := TglTexCoord1hNV(wglGetProcAddress('glTexCoord1hNV'{$IFDEF CLR}, typeof(TglTexCoord1hNV){$ENDIF}));
  glTexCoord1hvNV := TglTexCoord1hvNV(wglGetProcAddress('glTexCoord1hvNV'{$IFDEF CLR}, typeof(TglTexCoord1hvNV){$ENDIF}));
  glTexCoord2hNV := TglTexCoord2hNV(wglGetProcAddress('glTexCoord2hNV'{$IFDEF CLR}, typeof(TglTexCoord2hNV){$ENDIF}));
  glTexCoord2hvNV := TglTexCoord2hvNV(wglGetProcAddress('glTexCoord2hvNV'{$IFDEF CLR}, typeof(TglTexCoord2hvNV){$ENDIF}));
  glTexCoord3hNV := TglTexCoord3hNV(wglGetProcAddress('glTexCoord3hNV'{$IFDEF CLR}, typeof(TglTexCoord3hNV){$ENDIF}));
  glTexCoord3hvNV := TglTexCoord3hvNV(wglGetProcAddress('glTexCoord3hvNV'{$IFDEF CLR}, typeof(TglTexCoord3hvNV){$ENDIF}));
  glTexCoord4hNV := TglTexCoord4hNV(wglGetProcAddress('glTexCoord4hNV'{$IFDEF CLR}, typeof(TglTexCoord4hNV){$ENDIF}));
  glTexCoord4hvNV := TglTexCoord4hvNV(wglGetProcAddress('glTexCoord4hvNV'{$IFDEF CLR}, typeof(TglTexCoord4hvNV){$ENDIF}));
  glMultiTexCoord1hNV := TglMultiTexCoord1hNV(wglGetProcAddress('glMultiTexCoord1hNV'{$IFDEF CLR}, typeof(TglMultiTexCoord1hNV){$ENDIF}));
  glMultiTexCoord1hvNV := TglMultiTexCoord1hvNV(wglGetProcAddress('glMultiTexCoord1hvNV'{$IFDEF CLR}, typeof(TglMultiTexCoord1hvNV){$ENDIF}));
  glMultiTexCoord2hNV := TglMultiTexCoord2hNV(wglGetProcAddress('glMultiTexCoord2hNV'{$IFDEF CLR}, typeof(TglMultiTexCoord2hNV){$ENDIF}));
  glMultiTexCoord2hvNV := TglMultiTexCoord2hvNV(wglGetProcAddress('glMultiTexCoord2hvNV'{$IFDEF CLR}, typeof(TglMultiTexCoord2hvNV){$ENDIF}));
  glMultiTexCoord3hNV := TglMultiTexCoord3hNV(wglGetProcAddress('glMultiTexCoord3hNV'{$IFDEF CLR}, typeof(TglMultiTexCoord3hNV){$ENDIF}));
  glMultiTexCoord3hvNV := TglMultiTexCoord3hvNV(wglGetProcAddress('glMultiTexCoord3hvNV'{$IFDEF CLR}, typeof(TglMultiTexCoord3hvNV){$ENDIF}));
  glMultiTexCoord4hNV := TglMultiTexCoord4hNV(wglGetProcAddress('glMultiTexCoord4hNV'{$IFDEF CLR}, typeof(TglMultiTexCoord4hNV){$ENDIF}));
  glMultiTexCoord4hvNV := TglMultiTexCoord4hvNV(wglGetProcAddress('glMultiTexCoord4hvNV'{$IFDEF CLR}, typeof(TglMultiTexCoord4hvNV){$ENDIF}));
  glFogCoordhNV := TglFogCoordhNV(wglGetProcAddress('glFogCoordhNV'{$IFDEF CLR}, typeof(TglFogCoordhNV){$ENDIF}));
  glFogCoordhvNV := TglFogCoordhvNV(wglGetProcAddress('glFogCoordhvNV'{$IFDEF CLR}, typeof(TglFogCoordhvNV){$ENDIF}));
  glSecondaryColor3hNV := TglSecondaryColor3hNV(wglGetProcAddress('glSecondaryColor3hNV'{$IFDEF CLR}, typeof(TglSecondaryColor3hNV){$ENDIF}));
  glSecondaryColor3hvNV := TglSecondaryColor3hvNV(wglGetProcAddress('glSecondaryColor3hvNV'{$IFDEF CLR}, typeof(TglSecondaryColor3hvNV){$ENDIF}));
  glVertexWeighthNV := TglVertexWeighthNV(wglGetProcAddress('glVertexWeighthNV'{$IFDEF CLR}, typeof(TglVertexWeighthNV){$ENDIF}));
  glVertexWeighthvNV := TglVertexWeighthvNV(wglGetProcAddress('glVertexWeighthvNV'{$IFDEF CLR}, typeof(TglVertexWeighthvNV){$ENDIF}));
  glVertexAttrib1hNV := TglVertexAttrib1hNV(wglGetProcAddress('glVertexAttrib1hNV'{$IFDEF CLR}, typeof(TglVertexAttrib1hNV){$ENDIF}));
  glVertexAttrib1hvNV := TglVertexAttrib1hvNV(wglGetProcAddress('glVertexAttrib1hvNV'{$IFDEF CLR}, typeof(TglVertexAttrib1hvNV){$ENDIF}));
  glVertexAttrib2hNV := TglVertexAttrib2hNV(wglGetProcAddress('glVertexAttrib2hNV'{$IFDEF CLR}, typeof(TglVertexAttrib2hNV){$ENDIF}));
  glVertexAttrib2hvNV := TglVertexAttrib2hvNV(wglGetProcAddress('glVertexAttrib2hvNV'{$IFDEF CLR}, typeof(TglVertexAttrib2hvNV){$ENDIF}));
  glVertexAttrib3hNV := TglVertexAttrib3hNV(wglGetProcAddress('glVertexAttrib3hNV'{$IFDEF CLR}, typeof(TglVertexAttrib3hNV){$ENDIF}));
  glVertexAttrib3hvNV := TglVertexAttrib3hvNV(wglGetProcAddress('glVertexAttrib3hvNV'{$IFDEF CLR}, typeof(TglVertexAttrib3hvNV){$ENDIF}));
  glVertexAttrib4hNV := TglVertexAttrib4hNV(wglGetProcAddress('glVertexAttrib4hNV'{$IFDEF CLR}, typeof(TglVertexAttrib4hNV){$ENDIF}));
  glVertexAttrib4hvNV := TglVertexAttrib4hvNV(wglGetProcAddress('glVertexAttrib4hvNV'{$IFDEF CLR}, typeof(TglVertexAttrib4hvNV){$ENDIF}));
  glVertexAttribs1hvNV := TglVertexAttribs1hvNV(wglGetProcAddress('glVertexAttribs1hvNV'{$IFDEF CLR}, typeof(TglVertexAttribs1hvNV){$ENDIF}));
  glVertexAttribs2hvNV := TglVertexAttribs2hvNV(wglGetProcAddress('glVertexAttribs2hvNV'{$IFDEF CLR}, typeof(TglVertexAttribs2hvNV){$ENDIF}));
  glVertexAttribs3hvNV := TglVertexAttribs3hvNV(wglGetProcAddress('glVertexAttribs3hvNV'{$IFDEF CLR}, typeof(TglVertexAttribs3hvNV){$ENDIF}));
  glVertexAttribs4hvNV := TglVertexAttribs4hvNV(wglGetProcAddress('glVertexAttribs4hvNV'{$IFDEF CLR}, typeof(TglVertexAttribs4hvNV){$ENDIF}));
end;

procedure Read_GL_NV_occlusion_query;
begin
  glGenOcclusionQueriesNV := TglGenOcclusionQueriesNV(wglGetProcAddress('glGenOcclusionQueriesNV'{$IFDEF CLR}, typeof(TglGenOcclusionQueriesNV){$ENDIF}));
  glDeleteOcclusionQueriesNV := TglDeleteOcclusionQueriesNV(wglGetProcAddress('glDeleteOcclusionQueriesNV'{$IFDEF CLR}, typeof(TglDeleteOcclusionQueriesNV){$ENDIF}));
  glIsOcclusionQueryNV := TglIsOcclusionQueryNV(wglGetProcAddress('glIsOcclusionQueryNV'{$IFDEF CLR}, typeof(TglIsOcclusionQueryNV){$ENDIF}));
  glBeginOcclusionQueryNV := TglBeginOcclusionQueryNV(wglGetProcAddress('glBeginOcclusionQueryNV'{$IFDEF CLR}, typeof(TglBeginOcclusionQueryNV){$ENDIF}));
  glEndOcclusionQueryNV := TglEndOcclusionQueryNV(wglGetProcAddress('glEndOcclusionQueryNV'{$IFDEF CLR}, typeof(TglEndOcclusionQueryNV){$ENDIF}));
  glGetOcclusionQueryivNV := TglGetOcclusionQueryivNV(wglGetProcAddress('glGetOcclusionQueryivNV'{$IFDEF CLR}, typeof(TglGetOcclusionQueryivNV){$ENDIF}));
  glGetOcclusionQueryuivNV := TglGetOcclusionQueryuivNV(wglGetProcAddress('glGetOcclusionQueryuivNV'{$IFDEF CLR}, typeof(TglGetOcclusionQueryuivNV){$ENDIF}));
end;

procedure Read_GL_NV_pixel_data_range;
begin
  glPixelDataRangeNV := TglPixelDataRangeNV(wglGetProcAddress('glPixelDataRangeNV'{$IFDEF CLR}, typeof(TglPixelDataRangeNV){$ENDIF}));
  glFlushPixelDataRangeNV := TglFlushPixelDataRangeNV(wglGetProcAddress('glFlushPixelDataRangeNV'{$IFDEF CLR}, typeof(TglFlushPixelDataRangeNV){$ENDIF}));
end;

procedure Read_GL_NV_point_sprite;
begin
  glPointParameteriNV := TglPointParameteriNV(wglGetProcAddress('glPointParameteriNV'{$IFDEF CLR}, typeof(TglPointParameteriNV){$ENDIF}));
  glPointParameterivNV := TglPointParameterivNV(wglGetProcAddress('glPointParameterivNV'{$IFDEF CLR}, typeof(TglPointParameterivNV){$ENDIF}));
end;

procedure Read_GL_NV_primitive_restart;
begin
  glPrimitiveRestartNV := TglPrimitiveRestartNV(wglGetProcAddress('glPrimitiveRestartNV'{$IFDEF CLR}, typeof(TglPrimitiveRestartNV){$ENDIF}));
  glPrimitiveRestartIndexNV := TglPrimitiveRestartIndexNV(wglGetProcAddress('glPrimitiveRestartIndexNV'{$IFDEF CLR}, typeof(TglPrimitiveRestartIndexNV){$ENDIF}));
end;

procedure Read_GL_NV_register_combiners;
begin
  glCombinerParameterfvNV := TglCombinerParameterfvNV(wglGetProcAddress('glCombinerParameterfvNV'{$IFDEF CLR}, typeof(TglCombinerParameterfvNV){$ENDIF}));
  glCombinerParameterfNV := TglCombinerParameterfNV(wglGetProcAddress('glCombinerParameterfNV'{$IFDEF CLR}, typeof(TglCombinerParameterfNV){$ENDIF}));
  glCombinerParameterivNV := TglCombinerParameterivNV(wglGetProcAddress('glCombinerParameterivNV'{$IFDEF CLR}, typeof(TglCombinerParameterivNV){$ENDIF}));
  glCombinerParameteriNV := TglCombinerParameteriNV(wglGetProcAddress('glCombinerParameteriNV'{$IFDEF CLR}, typeof(TglCombinerParameteriNV){$ENDIF}));
  glCombinerInputNV := TglCombinerInputNV(wglGetProcAddress('glCombinerInputNV'{$IFDEF CLR}, typeof(TglCombinerInputNV){$ENDIF}));
  glCombinerOutputNV := TglCombinerOutputNV(wglGetProcAddress('glCombinerOutputNV'{$IFDEF CLR}, typeof(TglCombinerOutputNV){$ENDIF}));
  glFinalCombinerInputNV := TglFinalCombinerInputNV(wglGetProcAddress('glFinalCombinerInputNV'{$IFDEF CLR}, typeof(TglFinalCombinerInputNV){$ENDIF}));
  glGetCombinerInputParameterfvNV := TglGetCombinerInputParameterfvNV(wglGetProcAddress('glGetCombinerInputParameterfvNV'{$IFDEF CLR}, typeof(TglGetCombinerInputParameterfvNV){$ENDIF}));
  glGetCombinerInputParameterivNV := TglGetCombinerInputParameterivNV(wglGetProcAddress('glGetCombinerInputParameterivNV'{$IFDEF CLR}, typeof(TglGetCombinerInputParameterivNV){$ENDIF}));
  glGetCombinerOutputParameterfvNV := TglGetCombinerOutputParameterfvNV(wglGetProcAddress('glGetCombinerOutputParameterfvNV'{$IFDEF CLR}, typeof(TglGetCombinerOutputParameterfvNV){$ENDIF}));
  glGetCombinerOutputParameterivNV := TglGetCombinerOutputParameterivNV(wglGetProcAddress('glGetCombinerOutputParameterivNV'{$IFDEF CLR}, typeof(TglGetCombinerOutputParameterivNV){$ENDIF}));
  glGetFinalCombinerInputParameterfvNV := TglGetFinalCombinerInputParameterfvNV(wglGetProcAddress('glGetFinalCombinerInputParameterfvNV'{$IFDEF CLR}, typeof(TglGetFinalCombinerInputParameterfvNV){$ENDIF}));
  glGetFinalCombinerInputParameterivNV := TglGetFinalCombinerInputParameterivNV(wglGetProcAddress('glGetFinalCombinerInputParameterivNV'{$IFDEF CLR}, typeof(TglGetFinalCombinerInputParameterivNV){$ENDIF}));
end;

procedure Read_GL_NV_register_combiners2;
begin
  glCombinerStageParameterfvNV := TglCombinerStageParameterfvNV(wglGetProcAddress('glCombinerStageParameterfvNV'{$IFDEF CLR}, typeof(TglCombinerStageParameterfvNV){$ENDIF}));
  glGetCombinerStageParameterfvNV := TglGetCombinerStageParameterfvNV(wglGetProcAddress('glGetCombinerStageParameterfvNV'{$IFDEF CLR}, typeof(TglGetCombinerStageParameterfvNV){$ENDIF}));
end;

procedure Read_GL_NV_vertex_array_range;
begin
  glFlushVertexArrayRangeNV := TglFlushVertexArrayRangeNV(wglGetProcAddress('glFlushVertexArrayRangeNV'{$IFDEF CLR}, typeof(TglFlushVertexArrayRangeNV){$ENDIF}));
  glVertexArrayRangeNV := TglVertexArrayRangeNV(wglGetProcAddress('glVertexArrayRangeNV'{$IFDEF CLR}, typeof(TglVertexArrayRangeNV){$ENDIF}));
end;

procedure Read_GL_NV_vertex_program;
begin
  glAreProgramsResidentNV := TglAreProgramsResidentNV(wglGetProcAddress('glAreProgramsResidentNV'{$IFDEF CLR}, typeof(TglAreProgramsResidentNV){$ENDIF}));
  glBindProgramNV := TglBindProgramNV(wglGetProcAddress('glBindProgramNV'{$IFDEF CLR}, typeof(TglBindProgramNV){$ENDIF}));
  glDeleteProgramsNV := TglDeleteProgramsNV(wglGetProcAddress('glDeleteProgramsNV'{$IFDEF CLR}, typeof(TglDeleteProgramsNV){$ENDIF}));
  glExecuteProgramNV := TglExecuteProgramNV(wglGetProcAddress('glExecuteProgramNV'{$IFDEF CLR}, typeof(TglExecuteProgramNV){$ENDIF}));
  glGenProgramsNV := TglGenProgramsNV(wglGetProcAddress('glGenProgramsNV'{$IFDEF CLR}, typeof(TglGenProgramsNV){$ENDIF}));
  glGetProgramParameterdvNV := TglGetProgramParameterdvNV(wglGetProcAddress('glGetProgramParameterdvNV'{$IFDEF CLR}, typeof(TglGetProgramParameterdvNV){$ENDIF}));
  glGetProgramParameterfvNV := TglGetProgramParameterfvNV(wglGetProcAddress('glGetProgramParameterfvNV'{$IFDEF CLR}, typeof(TglGetProgramParameterfvNV){$ENDIF}));
  glGetProgramivNV := TglGetProgramivNV(wglGetProcAddress('glGetProgramivNV'{$IFDEF CLR}, typeof(TglGetProgramivNV){$ENDIF}));
  glGetProgramStringNV := TglGetProgramStringNV(wglGetProcAddress('glGetProgramStringNV'{$IFDEF CLR}, typeof(TglGetProgramStringNV){$ENDIF}));
  glGetTrackMatrixivNV := TglGetTrackMatrixivNV(wglGetProcAddress('glGetTrackMatrixivNV'{$IFDEF CLR}, typeof(TglGetTrackMatrixivNV){$ENDIF}));
  glGetVertexAttribdvNV := TglGetVertexAttribdvNV(wglGetProcAddress('glGetVertexAttribdvNV'{$IFDEF CLR}, typeof(TglGetVertexAttribdvNV){$ENDIF}));
  glGetVertexAttribfvNV := TglGetVertexAttribfvNV(wglGetProcAddress('glGetVertexAttribfvNV'{$IFDEF CLR}, typeof(TglGetVertexAttribfvNV){$ENDIF}));
  glGetVertexAttribivNV := TglGetVertexAttribivNV(wglGetProcAddress('glGetVertexAttribivNV'{$IFDEF CLR}, typeof(TglGetVertexAttribivNV){$ENDIF}));
  glGetVertexAttribPointervNV := TglGetVertexAttribPointervNV(wglGetProcAddress('glGetVertexAttribPointervNV'{$IFDEF CLR}, typeof(TglGetVertexAttribPointervNV){$ENDIF}));
  glIsProgramNV := TglIsProgramNV(wglGetProcAddress('glIsProgramNV'{$IFDEF CLR}, typeof(TglIsProgramNV){$ENDIF}));
  glLoadProgramNV := TglLoadProgramNV(wglGetProcAddress('glLoadProgramNV'{$IFDEF CLR}, typeof(TglLoadProgramNV){$ENDIF}));
  glProgramParameter4dNV := TglProgramParameter4dNV(wglGetProcAddress('glProgramParameter4dNV'{$IFDEF CLR}, typeof(TglProgramParameter4dNV){$ENDIF}));
  glProgramParameter4dvNV := TglProgramParameter4dvNV(wglGetProcAddress('glProgramParameter4dvNV'{$IFDEF CLR}, typeof(TglProgramParameter4dvNV){$ENDIF}));
  glProgramParameter4fNV := TglProgramParameter4fNV(wglGetProcAddress('glProgramParameter4fNV'{$IFDEF CLR}, typeof(TglProgramParameter4fNV){$ENDIF}));
  glProgramParameter4fvNV := TglProgramParameter4fvNV(wglGetProcAddress('glProgramParameter4fvNV'{$IFDEF CLR}, typeof(TglProgramParameter4fvNV){$ENDIF}));
  glProgramParameters4dvNV := TglProgramParameters4dvNV(wglGetProcAddress('glProgramParameters4dvNV'{$IFDEF CLR}, typeof(TglProgramParameters4dvNV){$ENDIF}));
  glProgramParameters4fvNV := TglProgramParameters4fvNV(wglGetProcAddress('glProgramParameters4fvNV'{$IFDEF CLR}, typeof(TglProgramParameters4fvNV){$ENDIF}));
  glRequestResidentProgramsNV := TglRequestResidentProgramsNV(wglGetProcAddress('glRequestResidentProgramsNV'{$IFDEF CLR}, typeof(TglRequestResidentProgramsNV){$ENDIF}));
  glTrackMatrixNV := TglTrackMatrixNV(wglGetProcAddress('glTrackMatrixNV'{$IFDEF CLR}, typeof(TglTrackMatrixNV){$ENDIF}));
  glVertexAttribPointerNV := TglVertexAttribPointerNV(wglGetProcAddress('glVertexAttribPointerNV'{$IFDEF CLR}, typeof(TglVertexAttribPointerNV){$ENDIF}));
  glVertexAttrib1dNV := TglVertexAttrib1dNV(wglGetProcAddress('glVertexAttrib1dNV'{$IFDEF CLR}, typeof(TglVertexAttrib1dNV){$ENDIF}));
  glVertexAttrib1dvNV := TglVertexAttrib1dvNV(wglGetProcAddress('glVertexAttrib1dvNV'{$IFDEF CLR}, typeof(TglVertexAttrib1dvNV){$ENDIF}));
  glVertexAttrib1fNV := TglVertexAttrib1fNV(wglGetProcAddress('glVertexAttrib1fNV'{$IFDEF CLR}, typeof(TglVertexAttrib1fNV){$ENDIF}));
  glVertexAttrib1fvNV := TglVertexAttrib1fvNV(wglGetProcAddress('glVertexAttrib1fvNV'{$IFDEF CLR}, typeof(TglVertexAttrib1fvNV){$ENDIF}));
  glVertexAttrib1sNV := TglVertexAttrib1sNV(wglGetProcAddress('glVertexAttrib1sNV'{$IFDEF CLR}, typeof(TglVertexAttrib1sNV){$ENDIF}));
  glVertexAttrib1svNV := TglVertexAttrib1svNV(wglGetProcAddress('glVertexAttrib1svNV'{$IFDEF CLR}, typeof(TglVertexAttrib1svNV){$ENDIF}));
  glVertexAttrib2dNV := TglVertexAttrib2dNV(wglGetProcAddress('glVertexAttrib2dNV'{$IFDEF CLR}, typeof(TglVertexAttrib2dNV){$ENDIF}));
  glVertexAttrib2dvNV := TglVertexAttrib2dvNV(wglGetProcAddress('glVertexAttrib2dvNV'{$IFDEF CLR}, typeof(TglVertexAttrib2dvNV){$ENDIF}));
  glVertexAttrib2fNV := TglVertexAttrib2fNV(wglGetProcAddress('glVertexAttrib2fNV'{$IFDEF CLR}, typeof(TglVertexAttrib2fNV){$ENDIF}));
  glVertexAttrib2fvNV := TglVertexAttrib2fvNV(wglGetProcAddress('glVertexAttrib2fvNV'{$IFDEF CLR}, typeof(TglVertexAttrib2fvNV){$ENDIF}));
  glVertexAttrib2sNV := TglVertexAttrib2sNV(wglGetProcAddress('glVertexAttrib2sNV'{$IFDEF CLR}, typeof(TglVertexAttrib2sNV){$ENDIF}));
  glVertexAttrib2svNV := TglVertexAttrib2svNV(wglGetProcAddress('glVertexAttrib2svNV'{$IFDEF CLR}, typeof(TglVertexAttrib2svNV){$ENDIF}));
  glVertexAttrib3dNV := TglVertexAttrib3dNV(wglGetProcAddress('glVertexAttrib3dNV'{$IFDEF CLR}, typeof(TglVertexAttrib3dNV){$ENDIF}));
  glVertexAttrib3dvNV := TglVertexAttrib3dvNV(wglGetProcAddress('glVertexAttrib3dvNV'{$IFDEF CLR}, typeof(TglVertexAttrib3dvNV){$ENDIF}));
  glVertexAttrib3fNV := TglVertexAttrib3fNV(wglGetProcAddress('glVertexAttrib3fNV'{$IFDEF CLR}, typeof(TglVertexAttrib3fNV){$ENDIF}));
  glVertexAttrib3fvNV := TglVertexAttrib3fvNV(wglGetProcAddress('glVertexAttrib3fvNV'{$IFDEF CLR}, typeof(TglVertexAttrib3fvNV){$ENDIF}));
  glVertexAttrib3sNV := TglVertexAttrib3sNV(wglGetProcAddress('glVertexAttrib3sNV'{$IFDEF CLR}, typeof(TglVertexAttrib3sNV){$ENDIF}));
  glVertexAttrib3svNV := TglVertexAttrib3svNV(wglGetProcAddress('glVertexAttrib3svNV'{$IFDEF CLR}, typeof(TglVertexAttrib3svNV){$ENDIF}));
  glVertexAttrib4dNV := TglVertexAttrib4dNV(wglGetProcAddress('glVertexAttrib4dNV'{$IFDEF CLR}, typeof(TglVertexAttrib4dNV){$ENDIF}));
  glVertexAttrib4dvNV := TglVertexAttrib4dvNV(wglGetProcAddress('glVertexAttrib4dvNV'{$IFDEF CLR}, typeof(TglVertexAttrib4dvNV){$ENDIF}));
  glVertexAttrib4fNV := TglVertexAttrib4fNV(wglGetProcAddress('glVertexAttrib4fNV'{$IFDEF CLR}, typeof(TglVertexAttrib4fNV){$ENDIF}));
  glVertexAttrib4fvNV := TglVertexAttrib4fvNV(wglGetProcAddress('glVertexAttrib4fvNV'{$IFDEF CLR}, typeof(TglVertexAttrib4fvNV){$ENDIF}));
  glVertexAttrib4sNV := TglVertexAttrib4sNV(wglGetProcAddress('glVertexAttrib4sNV'{$IFDEF CLR}, typeof(TglVertexAttrib4sNV){$ENDIF}));
  glVertexAttrib4svNV := TglVertexAttrib4svNV(wglGetProcAddress('glVertexAttrib4svNV'{$IFDEF CLR}, typeof(TglVertexAttrib4svNV){$ENDIF}));
  glVertexAttrib4ubNV := TglVertexAttrib4ubNV(wglGetProcAddress('glVertexAttrib4ubNV'{$IFDEF CLR}, typeof(TglVertexAttrib4ubNV){$ENDIF}));
  glVertexAttrib4ubvNV := TglVertexAttrib4ubvNV(wglGetProcAddress('glVertexAttrib4ubvNV'{$IFDEF CLR}, typeof(TglVertexAttrib4ubvNV){$ENDIF}));
  glVertexAttribs1dvNV := TglVertexAttribs1dvNV(wglGetProcAddress('glVertexAttribs1dvNV'{$IFDEF CLR}, typeof(TglVertexAttribs1dvNV){$ENDIF}));
  glVertexAttribs1fvNV := TglVertexAttribs1fvNV(wglGetProcAddress('glVertexAttribs1fvNV'{$IFDEF CLR}, typeof(TglVertexAttribs1fvNV){$ENDIF}));
  glVertexAttribs1svNV := TglVertexAttribs1svNV(wglGetProcAddress('glVertexAttribs1svNV'{$IFDEF CLR}, typeof(TglVertexAttribs1svNV){$ENDIF}));
  glVertexAttribs2dvNV := TglVertexAttribs2dvNV(wglGetProcAddress('glVertexAttribs2dvNV'{$IFDEF CLR}, typeof(TglVertexAttribs2dvNV){$ENDIF}));
  glVertexAttribs2fvNV := TglVertexAttribs2fvNV(wglGetProcAddress('glVertexAttribs2fvNV'{$IFDEF CLR}, typeof(TglVertexAttribs2fvNV){$ENDIF}));
  glVertexAttribs2svNV := TglVertexAttribs2svNV(wglGetProcAddress('glVertexAttribs2svNV'{$IFDEF CLR}, typeof(TglVertexAttribs2svNV){$ENDIF}));
  glVertexAttribs3dvNV := TglVertexAttribs3dvNV(wglGetProcAddress('glVertexAttribs3dvNV'{$IFDEF CLR}, typeof(TglVertexAttribs3dvNV){$ENDIF}));
  glVertexAttribs3fvNV := TglVertexAttribs3fvNV(wglGetProcAddress('glVertexAttribs3fvNV'{$IFDEF CLR}, typeof(TglVertexAttribs3fvNV){$ENDIF}));
  glVertexAttribs3svNV := TglVertexAttribs3svNV(wglGetProcAddress('glVertexAttribs3svNV'{$IFDEF CLR}, typeof(TglVertexAttribs3svNV){$ENDIF}));
  glVertexAttribs4dvNV := TglVertexAttribs4dvNV(wglGetProcAddress('glVertexAttribs4dvNV'{$IFDEF CLR}, typeof(TglVertexAttribs4dvNV){$ENDIF}));
  glVertexAttribs4fvNV := TglVertexAttribs4fvNV(wglGetProcAddress('glVertexAttribs4fvNV'{$IFDEF CLR}, typeof(TglVertexAttribs4fvNV){$ENDIF}));
  glVertexAttribs4svNV := TglVertexAttribs4svNV(wglGetProcAddress('glVertexAttribs4svNV'{$IFDEF CLR}, typeof(TglVertexAttribs4svNV){$ENDIF}));
  glVertexAttribs4ubvNV := TglVertexAttribs4ubvNV(wglGetProcAddress('glVertexAttribs4ubvNV'{$IFDEF CLR}, typeof(TglVertexAttribs4ubvNV){$ENDIF}));
end;

procedure Read_GL_PGI_misc_hints;
begin
  glHintPGI := TglHintPGI(wglGetProcAddress('glHintPGI'{$IFDEF CLR}, typeof(TglHintPGI){$ENDIF}));
end;

procedure Read_GL_SGIS_detail_texture;
begin
  glDetailTexFuncSGIS := TglDetailTexFuncSGIS(wglGetProcAddress('glDetailTexFuncSGIS'{$IFDEF CLR}, typeof(TglDetailTexFuncSGIS){$ENDIF}));
  glGetDetailTexFuncSGIS := TglGetDetailTexFuncSGIS(wglGetProcAddress('glGetDetailTexFuncSGIS'{$IFDEF CLR}, typeof(TglGetDetailTexFuncSGIS){$ENDIF}));
end;

procedure Read_GL_SGIS_fog_function;
begin
  glFogFuncSGIS := TglFogFuncSGIS(wglGetProcAddress('glFogFuncSGIS'{$IFDEF CLR}, typeof(TglFogFuncSGIS){$ENDIF}));
  glGetFogFuncSGIS := TglGetFogFuncSGIS(wglGetProcAddress('glGetFogFuncSGIS'{$IFDEF CLR}, typeof(TglGetFogFuncSGIS){$ENDIF}));
end;

procedure Read_GL_SGIS_multisample;
begin
  glSampleMaskSGIS := TglSampleMaskSGIS(wglGetProcAddress('glSampleMaskSGIS'{$IFDEF CLR}, typeof(TglSampleMaskSGIS){$ENDIF}));
  glSamplePatternSGIS := TglSamplePatternSGIS(wglGetProcAddress('glSamplePatternSGIS'{$IFDEF CLR}, typeof(TglSamplePatternSGIS){$ENDIF}));
end;

procedure Read_GL_SGIS_pixel_texture;
begin
  glPixelTexGenParameteriSGIS := TglPixelTexGenParameteriSGIS(wglGetProcAddress('glPixelTexGenParameteriSGIS'{$IFDEF CLR}, typeof(TglPixelTexGenParameteriSGIS){$ENDIF}));
  glPixelTexGenParameterivSGIS := TglPixelTexGenParameterivSGIS(wglGetProcAddress('glPixelTexGenParameterivSGIS'{$IFDEF CLR}, typeof(TglPixelTexGenParameterivSGIS){$ENDIF}));
  glPixelTexGenParameterfSGIS := TglPixelTexGenParameterfSGIS(wglGetProcAddress('glPixelTexGenParameterfSGIS'{$IFDEF CLR}, typeof(TglPixelTexGenParameterfSGIS){$ENDIF}));
  glPixelTexGenParameterfvSGIS := TglPixelTexGenParameterfvSGIS(wglGetProcAddress('glPixelTexGenParameterfvSGIS'{$IFDEF CLR}, typeof(TglPixelTexGenParameterfvSGIS){$ENDIF}));
  glGetPixelTexGenParameterivSGIS := TglGetPixelTexGenParameterivSGIS(wglGetProcAddress('glGetPixelTexGenParameterivSGIS'{$IFDEF CLR}, typeof(TglGetPixelTexGenParameterivSGIS){$ENDIF}));
  glGetPixelTexGenParameterfvSGIS := TglGetPixelTexGenParameterfvSGIS(wglGetProcAddress('glGetPixelTexGenParameterfvSGIS'{$IFDEF CLR}, typeof(TglGetPixelTexGenParameterfvSGIS){$ENDIF}));
end;

procedure Read_GL_SGIS_point_parameters;
begin
  glPointParameterfSGIS := TglPointParameterfSGIS(wglGetProcAddress('glPointParameterfSGIS'{$IFDEF CLR}, typeof(TglPointParameterfSGIS){$ENDIF}));
  glPointParameterfvSGIS := TglPointParameterfvSGIS(wglGetProcAddress('glPointParameterfvSGIS'{$IFDEF CLR}, typeof(TglPointParameterfvSGIS){$ENDIF}));
end;

procedure Read_GL_SGIS_sharpen_texture;
begin
  glSharpenTexFuncSGIS := TglSharpenTexFuncSGIS(wglGetProcAddress('glSharpenTexFuncSGIS'{$IFDEF CLR}, typeof(TglSharpenTexFuncSGIS){$ENDIF}));
  glGetSharpenTexFuncSGIS := TglGetSharpenTexFuncSGIS(wglGetProcAddress('glGetSharpenTexFuncSGIS'{$IFDEF CLR}, typeof(TglGetSharpenTexFuncSGIS){$ENDIF}));
end;

procedure Read_GL_SGIS_texture4D;
begin
  glTexImage4DSGIS := TglTexImage4DSGIS(wglGetProcAddress('glTexImage4DSGIS'{$IFDEF CLR}, typeof(TglTexImage4DSGIS){$ENDIF}));
  glTexSubImage4DSGIS := TglTexSubImage4DSGIS(wglGetProcAddress('glTexSubImage4DSGIS'{$IFDEF CLR}, typeof(TglTexSubImage4DSGIS){$ENDIF}));
end;

procedure Read_GL_SGIS_texture_color_mask;
begin
  glTextureColorMaskSGIS := TglTextureColorMaskSGIS(wglGetProcAddress('glTextureColorMaskSGIS'{$IFDEF CLR}, typeof(TglTextureColorMaskSGIS){$ENDIF}));
end;

procedure Read_GL_SGIS_texture_filter4;
begin
  glGetTexFilterFuncSGIS := TglGetTexFilterFuncSGIS(wglGetProcAddress('glGetTexFilterFuncSGIS'{$IFDEF CLR}, typeof(TglGetTexFilterFuncSGIS){$ENDIF}));
  glTexFilterFuncSGIS := TglTexFilterFuncSGIS(wglGetProcAddress('glTexFilterFuncSGIS'{$IFDEF CLR}, typeof(TglTexFilterFuncSGIS){$ENDIF}));
end;

procedure Read_GL_SGIX_async;
begin
  glAsyncMarkerSGIX := TglAsyncMarkerSGIX(wglGetProcAddress('glAsyncMarkerSGIX'{$IFDEF CLR}, typeof(TglAsyncMarkerSGIX){$ENDIF}));
  glFinishAsyncSGIX := TglFinishAsyncSGIX(wglGetProcAddress('glFinishAsyncSGIX'{$IFDEF CLR}, typeof(TglFinishAsyncSGIX){$ENDIF}));
  glPollAsyncSGIX := TglPollAsyncSGIX(wglGetProcAddress('glPollAsyncSGIX'{$IFDEF CLR}, typeof(TglPollAsyncSGIX){$ENDIF}));
  glGenAsyncMarkersSGIX := TglGenAsyncMarkersSGIX(wglGetProcAddress('glGenAsyncMarkersSGIX'{$IFDEF CLR}, typeof(TglGenAsyncMarkersSGIX){$ENDIF}));
  glDeleteAsyncMarkersSGIX := TglDeleteAsyncMarkersSGIX(wglGetProcAddress('glDeleteAsyncMarkersSGIX'{$IFDEF CLR}, typeof(TglDeleteAsyncMarkersSGIX){$ENDIF}));
  glIsAsyncMarkerSGIX := TglIsAsyncMarkerSGIX(wglGetProcAddress('glIsAsyncMarkerSGIX'{$IFDEF CLR}, typeof(TglIsAsyncMarkerSGIX){$ENDIF}));
end;

procedure Read_GL_SGIX_flush_raster;
begin
  glFlushRasterSGIX := TglFlushRasterSGIX(wglGetProcAddress('glFlushRasterSGIX'{$IFDEF CLR}, typeof(TglFlushRasterSGIX){$ENDIF}));
end;

procedure Read_GL_SGIX_fragment_lighting;
begin
  glFragmentColorMaterialSGIX := TglFragmentColorMaterialSGIX(wglGetProcAddress('glFragmentColorMaterialSGIX'{$IFDEF CLR}, typeof(TglFragmentColorMaterialSGIX){$ENDIF}));
  glFragmentLightfSGIX := TglFragmentLightfSGIX(wglGetProcAddress('glFragmentLightfSGIX'{$IFDEF CLR}, typeof(TglFragmentLightfSGIX){$ENDIF}));
  glFragmentLightfvSGIX := TglFragmentLightfvSGIX(wglGetProcAddress('glFragmentLightfvSGIX'{$IFDEF CLR}, typeof(TglFragmentLightfvSGIX){$ENDIF}));
  glFragmentLightiSGIX := TglFragmentLightiSGIX(wglGetProcAddress('glFragmentLightiSGIX'{$IFDEF CLR}, typeof(TglFragmentLightiSGIX){$ENDIF}));
  glFragmentLightivSGIX := TglFragmentLightivSGIX(wglGetProcAddress('glFragmentLightivSGIX'{$IFDEF CLR}, typeof(TglFragmentLightivSGIX){$ENDIF}));
  glFragmentLightModelfSGIX := TglFragmentLightModelfSGIX(wglGetProcAddress('glFragmentLightModelfSGIX'{$IFDEF CLR}, typeof(TglFragmentLightModelfSGIX){$ENDIF}));
  glFragmentLightModelfvSGIX := TglFragmentLightModelfvSGIX(wglGetProcAddress('glFragmentLightModelfvSGIX'{$IFDEF CLR}, typeof(TglFragmentLightModelfvSGIX){$ENDIF}));
  glFragmentLightModeliSGIX := TglFragmentLightModeliSGIX(wglGetProcAddress('glFragmentLightModeliSGIX'{$IFDEF CLR}, typeof(TglFragmentLightModeliSGIX){$ENDIF}));
  glFragmentLightModelivSGIX := TglFragmentLightModelivSGIX(wglGetProcAddress('glFragmentLightModelivSGIX'{$IFDEF CLR}, typeof(TglFragmentLightModelivSGIX){$ENDIF}));
  glFragmentMaterialfSGIX := TglFragmentMaterialfSGIX(wglGetProcAddress('glFragmentMaterialfSGIX'{$IFDEF CLR}, typeof(TglFragmentMaterialfSGIX){$ENDIF}));
  glFragmentMaterialfvSGIX := TglFragmentMaterialfvSGIX(wglGetProcAddress('glFragmentMaterialfvSGIX'{$IFDEF CLR}, typeof(TglFragmentMaterialfvSGIX){$ENDIF}));
  glFragmentMaterialiSGIX := TglFragmentMaterialiSGIX(wglGetProcAddress('glFragmentMaterialiSGIX'{$IFDEF CLR}, typeof(TglFragmentMaterialiSGIX){$ENDIF}));
  glFragmentMaterialivSGIX := TglFragmentMaterialivSGIX(wglGetProcAddress('glFragmentMaterialivSGIX'{$IFDEF CLR}, typeof(TglFragmentMaterialivSGIX){$ENDIF}));
  glGetFragmentLightfvSGIX := TglGetFragmentLightfvSGIX(wglGetProcAddress('glGetFragmentLightfvSGIX'{$IFDEF CLR}, typeof(TglGetFragmentLightfvSGIX){$ENDIF}));
  glGetFragmentLightivSGIX := TglGetFragmentLightivSGIX(wglGetProcAddress('glGetFragmentLightivSGIX'{$IFDEF CLR}, typeof(TglGetFragmentLightivSGIX){$ENDIF}));
  glGetFragmentMaterialfvSGIX := TglGetFragmentMaterialfvSGIX(wglGetProcAddress('glGetFragmentMaterialfvSGIX'{$IFDEF CLR}, typeof(TglGetFragmentMaterialfvSGIX){$ENDIF}));
  glGetFragmentMaterialivSGIX := TglGetFragmentMaterialivSGIX(wglGetProcAddress('glGetFragmentMaterialivSGIX'{$IFDEF CLR}, typeof(TglGetFragmentMaterialivSGIX){$ENDIF}));
  glLightEnviSGIX := TglLightEnviSGIX(wglGetProcAddress('glLightEnviSGIX'{$IFDEF CLR}, typeof(TglLightEnviSGIX){$ENDIF}));
end;

procedure Read_GL_SGIX_framezoom;
begin
  glFrameZoomSGIX := TglFrameZoomSGIX(wglGetProcAddress('glFrameZoomSGIX'{$IFDEF CLR}, typeof(TglFrameZoomSGIX){$ENDIF}));
end;

procedure Read_GL_SGIX_igloo_interface;
begin
  glIglooInterfaceSGIX := TglIglooInterfaceSGIX(wglGetProcAddress('glIglooInterfaceSGIX'{$IFDEF CLR}, typeof(TglIglooInterfaceSGIX){$ENDIF}));
end;

procedure Read_GL_SGIX_instruments;
begin
  glGetInstrumentsSGIX := TglGetInstrumentsSGIX(wglGetProcAddress('glGetInstrumentsSGIX'{$IFDEF CLR}, typeof(TglGetInstrumentsSGIX){$ENDIF}));
  glInstrumentsBufferSGIX := TglInstrumentsBufferSGIX(wglGetProcAddress('glInstrumentsBufferSGIX'{$IFDEF CLR}, typeof(TglInstrumentsBufferSGIX){$ENDIF}));
  glPollInstrumentsSGIX := TglPollInstrumentsSGIX(wglGetProcAddress('glPollInstrumentsSGIX'{$IFDEF CLR}, typeof(TglPollInstrumentsSGIX){$ENDIF}));
  glReadInstrumentsSGIX := TglReadInstrumentsSGIX(wglGetProcAddress('glReadInstrumentsSGIX'{$IFDEF CLR}, typeof(TglReadInstrumentsSGIX){$ENDIF}));
  glStartInstrumentsSGIX := TglStartInstrumentsSGIX(wglGetProcAddress('glStartInstrumentsSGIX'{$IFDEF CLR}, typeof(TglStartInstrumentsSGIX){$ENDIF}));
  glStopInstrumentsSGIX := TglStopInstrumentsSGIX(wglGetProcAddress('glStopInstrumentsSGIX'{$IFDEF CLR}, typeof(TglStopInstrumentsSGIX){$ENDIF}));
end;

procedure Read_GL_SGIX_list_priority;
begin
  glGetListParameterfvSGIX := TglGetListParameterfvSGIX(wglGetProcAddress('glGetListParameterfvSGIX'{$IFDEF CLR}, typeof(TglGetListParameterfvSGIX){$ENDIF}));
  glGetListParameterivSGIX := TglGetListParameterivSGIX(wglGetProcAddress('glGetListParameterivSGIX'{$IFDEF CLR}, typeof(TglGetListParameterivSGIX){$ENDIF}));
  glListParameterfSGIX := TglListParameterfSGIX(wglGetProcAddress('glListParameterfSGIX'{$IFDEF CLR}, typeof(TglListParameterfSGIX){$ENDIF}));
  glListParameterfvSGIX := TglListParameterfvSGIX(wglGetProcAddress('glListParameterfvSGIX'{$IFDEF CLR}, typeof(TglListParameterfvSGIX){$ENDIF}));
  glListParameteriSGIX := TglListParameteriSGIX(wglGetProcAddress('glListParameteriSGIX'{$IFDEF CLR}, typeof(TglListParameteriSGIX){$ENDIF}));
  glListParameterivSGIX := TglListParameterivSGIX(wglGetProcAddress('glListParameterivSGIX'{$IFDEF CLR}, typeof(TglListParameterivSGIX){$ENDIF}));
end;

procedure Read_GL_SGIX_pixel_texture;
begin
  glPixelTexGenSGIX := TglPixelTexGenSGIX(wglGetProcAddress('glPixelTexGenSGIX'{$IFDEF CLR}, typeof(TglPixelTexGenSGIX){$ENDIF}));
end;

procedure Read_GL_SGIX_polynomial_ffd;
begin
  glDeformationMap3dSGIX := TglDeformationMap3dSGIX(wglGetProcAddress('glDeformationMap3dSGIX'{$IFDEF CLR}, typeof(TglDeformationMap3dSGIX){$ENDIF}));
  glDeformationMap3fSGIX := TglDeformationMap3fSGIX(wglGetProcAddress('glDeformationMap3fSGIX'{$IFDEF CLR}, typeof(TglDeformationMap3fSGIX){$ENDIF}));
  glDeformSGIX := TglDeformSGIX(wglGetProcAddress('glDeformSGIX'{$IFDEF CLR}, typeof(TglDeformSGIX){$ENDIF}));
  glLoadIdentityDeformationMapSGIX := TglLoadIdentityDeformationMapSGIX(wglGetProcAddress('glLoadIdentityDeformationMapSGIX'{$IFDEF CLR}, typeof(TglLoadIdentityDeformationMapSGIX){$ENDIF}));
end;

procedure Read_GL_SGIX_reference_plane;
begin
  glReferencePlaneSGIX := TglReferencePlaneSGIX(wglGetProcAddress('glReferencePlaneSGIX'{$IFDEF CLR}, typeof(TglReferencePlaneSGIX){$ENDIF}));
end;

procedure Read_GL_SGIX_sprite;
begin
  glSpriteParameterfSGIX := TglSpriteParameterfSGIX(wglGetProcAddress('glSpriteParameterfSGIX'{$IFDEF CLR}, typeof(TglSpriteParameterfSGIX){$ENDIF}));
  glSpriteParameterfvSGIX := TglSpriteParameterfvSGIX(wglGetProcAddress('glSpriteParameterfvSGIX'{$IFDEF CLR}, typeof(TglSpriteParameterfvSGIX){$ENDIF}));
  glSpriteParameteriSGIX := TglSpriteParameteriSGIX(wglGetProcAddress('glSpriteParameteriSGIX'{$IFDEF CLR}, typeof(TglSpriteParameteriSGIX){$ENDIF}));
  glSpriteParameterivSGIX := TglSpriteParameterivSGIX(wglGetProcAddress('glSpriteParameterivSGIX'{$IFDEF CLR}, typeof(TglSpriteParameterivSGIX){$ENDIF}));
end;

procedure Read_GL_SGIX_tag_sample_buffer;
begin
  glTagSampleBufferSGIX := TglTagSampleBufferSGIX(wglGetProcAddress('glTagSampleBufferSGIX'{$IFDEF CLR}, typeof(TglTagSampleBufferSGIX){$ENDIF}));
end;

procedure Read_GL_SGI_color_table;
begin
  glColorTableSGI := TglColorTableSGI(wglGetProcAddress('glColorTableSGI'{$IFDEF CLR}, typeof(TglColorTableSGI){$ENDIF}));
  glColorTableParameterfvSGI := TglColorTableParameterfvSGI(wglGetProcAddress('glColorTableParameterfvSGI'{$IFDEF CLR}, typeof(TglColorTableParameterfvSGI){$ENDIF}));
  glColorTableParameterivSGI := TglColorTableParameterivSGI(wglGetProcAddress('glColorTableParameterivSGI'{$IFDEF CLR}, typeof(TglColorTableParameterivSGI){$ENDIF}));
  glCopyColorTableSGI := TglCopyColorTableSGI(wglGetProcAddress('glCopyColorTableSGI'{$IFDEF CLR}, typeof(TglCopyColorTableSGI){$ENDIF}));
  glGetColorTableSGI := TglGetColorTableSGI(wglGetProcAddress('glGetColorTableSGI'{$IFDEF CLR}, typeof(TglGetColorTableSGI){$ENDIF}));
  glGetColorTableParameterfvSGI := TglGetColorTableParameterfvSGI(wglGetProcAddress('glGetColorTableParameterfvSGI'{$IFDEF CLR}, typeof(TglGetColorTableParameterfvSGI){$ENDIF}));
  glGetColorTableParameterivSGI := TglGetColorTableParameterivSGI(wglGetProcAddress('glGetColorTableParameterivSGI'{$IFDEF CLR}, typeof(TglGetColorTableParameterivSGI){$ENDIF}));
end;

procedure Read_GL_SUNX_constant_data;
begin
  glFinishTextureSUNX := TglFinishTextureSUNX(wglGetProcAddress('glFinishTextureSUNX'{$IFDEF CLR}, typeof(TglFinishTextureSUNX){$ENDIF}));
end;

procedure Read_GL_SUN_global_alpha;
begin
  glGlobalAlphaFactorbSUN := TglGlobalAlphaFactorbSUN(wglGetProcAddress('glGlobalAlphaFactorbSUN'{$IFDEF CLR}, typeof(TglGlobalAlphaFactorbSUN){$ENDIF}));
  glGlobalAlphaFactorsSUN := TglGlobalAlphaFactorsSUN(wglGetProcAddress('glGlobalAlphaFactorsSUN'{$IFDEF CLR}, typeof(TglGlobalAlphaFactorsSUN){$ENDIF}));
  glGlobalAlphaFactoriSUN := TglGlobalAlphaFactoriSUN(wglGetProcAddress('glGlobalAlphaFactoriSUN'{$IFDEF CLR}, typeof(TglGlobalAlphaFactoriSUN){$ENDIF}));
  glGlobalAlphaFactorfSUN := TglGlobalAlphaFactorfSUN(wglGetProcAddress('glGlobalAlphaFactorfSUN'{$IFDEF CLR}, typeof(TglGlobalAlphaFactorfSUN){$ENDIF}));
  glGlobalAlphaFactordSUN := TglGlobalAlphaFactordSUN(wglGetProcAddress('glGlobalAlphaFactordSUN'{$IFDEF CLR}, typeof(TglGlobalAlphaFactordSUN){$ENDIF}));
  glGlobalAlphaFactorubSUN := TglGlobalAlphaFactorubSUN(wglGetProcAddress('glGlobalAlphaFactorubSUN'{$IFDEF CLR}, typeof(TglGlobalAlphaFactorubSUN){$ENDIF}));
  glGlobalAlphaFactorusSUN := TglGlobalAlphaFactorusSUN(wglGetProcAddress('glGlobalAlphaFactorusSUN'{$IFDEF CLR}, typeof(TglGlobalAlphaFactorusSUN){$ENDIF}));
  glGlobalAlphaFactoruiSUN := TglGlobalAlphaFactoruiSUN(wglGetProcAddress('glGlobalAlphaFactoruiSUN'{$IFDEF CLR}, typeof(TglGlobalAlphaFactoruiSUN){$ENDIF}));
end;

procedure Read_GL_SUN_mesh_array;
begin
  glDrawMeshArraysSUN := TglDrawMeshArraysSUN(wglGetProcAddress('glDrawMeshArraysSUN'{$IFDEF CLR}, typeof(TglDrawMeshArraysSUN){$ENDIF}));
end;

procedure Read_GL_SUN_triangle_list;
begin
  glReplacementCodeuiSUN := TglReplacementCodeuiSUN(wglGetProcAddress('glReplacementCodeuiSUN'{$IFDEF CLR}, typeof(TglReplacementCodeuiSUN){$ENDIF}));
  glReplacementCodeusSUN := TglReplacementCodeusSUN(wglGetProcAddress('glReplacementCodeusSUN'{$IFDEF CLR}, typeof(TglReplacementCodeusSUN){$ENDIF}));
  glReplacementCodeubSUN := TglReplacementCodeubSUN(wglGetProcAddress('glReplacementCodeubSUN'{$IFDEF CLR}, typeof(TglReplacementCodeubSUN){$ENDIF}));
  glReplacementCodeuivSUN := TglReplacementCodeuivSUN(wglGetProcAddress('glReplacementCodeuivSUN'{$IFDEF CLR}, typeof(TglReplacementCodeuivSUN){$ENDIF}));
  glReplacementCodeusvSUN := TglReplacementCodeusvSUN(wglGetProcAddress('glReplacementCodeusvSUN'{$IFDEF CLR}, typeof(TglReplacementCodeusvSUN){$ENDIF}));
  glReplacementCodeubvSUN := TglReplacementCodeubvSUN(wglGetProcAddress('glReplacementCodeubvSUN'{$IFDEF CLR}, typeof(TglReplacementCodeubvSUN){$ENDIF}));
  glReplacementCodePointerSUN := TglReplacementCodePointerSUN(wglGetProcAddress('glReplacementCodePointerSUN'{$IFDEF CLR}, typeof(TglReplacementCodePointerSUN){$ENDIF}));
end;

procedure Read_GL_SUN_vertex;
begin
  glColor4ubVertex2fSUN := TglColor4ubVertex2fSUN(wglGetProcAddress('glColor4ubVertex2fSUN'{$IFDEF CLR}, typeof(TglColor4ubVertex2fSUN){$ENDIF}));
  glColor4ubVertex2fvSUN := TglColor4ubVertex2fvSUN(wglGetProcAddress('glColor4ubVertex2fvSUN'{$IFDEF CLR}, typeof(TglColor4ubVertex2fvSUN){$ENDIF}));
  glColor4ubVertex3fSUN := TglColor4ubVertex3fSUN(wglGetProcAddress('glColor4ubVertex3fSUN'{$IFDEF CLR}, typeof(TglColor4ubVertex3fSUN){$ENDIF}));
  glColor4ubVertex3fvSUN := TglColor4ubVertex3fvSUN(wglGetProcAddress('glColor4ubVertex3fvSUN'{$IFDEF CLR}, typeof(TglColor4ubVertex3fvSUN){$ENDIF}));
  glColor3fVertex3fSUN := TglColor3fVertex3fSUN(wglGetProcAddress('glColor3fVertex3fSUN'{$IFDEF CLR}, typeof(TglColor3fVertex3fSUN){$ENDIF}));
  glColor3fVertex3fvSUN := TglColor3fVertex3fvSUN(wglGetProcAddress('glColor3fVertex3fvSUN'{$IFDEF CLR}, typeof(TglColor3fVertex3fvSUN){$ENDIF}));
  glNormal3fVertex3fSUN := TglNormal3fVertex3fSUN(wglGetProcAddress('glNormal3fVertex3fSUN'{$IFDEF CLR}, typeof(TglNormal3fVertex3fSUN){$ENDIF}));
  glNormal3fVertex3fvSUN := TglNormal3fVertex3fvSUN(wglGetProcAddress('glNormal3fVertex3fvSUN'{$IFDEF CLR}, typeof(TglNormal3fVertex3fvSUN){$ENDIF}));
  glColor4fNormal3fVertex3fSUN := TglColor4fNormal3fVertex3fSUN(wglGetProcAddress('glColor4fNormal3fVertex3fSUN'{$IFDEF CLR}, typeof(TglColor4fNormal3fVertex3fSUN){$ENDIF}));
  glColor4fNormal3fVertex3fvSUN := TglColor4fNormal3fVertex3fvSUN(wglGetProcAddress('glColor4fNormal3fVertex3fvSUN'{$IFDEF CLR}, typeof(TglColor4fNormal3fVertex3fvSUN){$ENDIF}));
  glTexCoord2fVertex3fSUN := TglTexCoord2fVertex3fSUN(wglGetProcAddress('glTexCoord2fVertex3fSUN'{$IFDEF CLR}, typeof(TglTexCoord2fVertex3fSUN){$ENDIF}));
  glTexCoord2fVertex3fvSUN := TglTexCoord2fVertex3fvSUN(wglGetProcAddress('glTexCoord2fVertex3fvSUN'{$IFDEF CLR}, typeof(TglTexCoord2fVertex3fvSUN){$ENDIF}));
  glTexCoord4fVertex4fSUN := TglTexCoord4fVertex4fSUN(wglGetProcAddress('glTexCoord4fVertex4fSUN'{$IFDEF CLR}, typeof(TglTexCoord4fVertex4fSUN){$ENDIF}));
  glTexCoord4fVertex4fvSUN := TglTexCoord4fVertex4fvSUN(wglGetProcAddress('glTexCoord4fVertex4fvSUN'{$IFDEF CLR}, typeof(TglTexCoord4fVertex4fvSUN){$ENDIF}));
  glTexCoord2fColor4ubVertex3fSUN := TglTexCoord2fColor4ubVertex3fSUN(wglGetProcAddress('glTexCoord2fColor4ubVertex3fSUN'{$IFDEF CLR}, typeof(TglTexCoord2fColor4ubVertex3fSUN){$ENDIF}));
  glTexCoord2fColor4ubVertex3fvSUN := TglTexCoord2fColor4ubVertex3fvSUN(wglGetProcAddress('glTexCoord2fColor4ubVertex3fvSUN'{$IFDEF CLR}, typeof(TglTexCoord2fColor4ubVertex3fvSUN){$ENDIF}));
  glTexCoord2fColor3fVertex3fSUN := TglTexCoord2fColor3fVertex3fSUN(wglGetProcAddress('glTexCoord2fColor3fVertex3fSUN'{$IFDEF CLR}, typeof(TglTexCoord2fColor3fVertex3fSUN){$ENDIF}));
  glTexCoord2fColor3fVertex3fvSUN := TglTexCoord2fColor3fVertex3fvSUN(wglGetProcAddress('glTexCoord2fColor3fVertex3fvSUN'{$IFDEF CLR}, typeof(TglTexCoord2fColor3fVertex3fvSUN){$ENDIF}));
  glTexCoord2fNormal3fVertex3fSUN := TglTexCoord2fNormal3fVertex3fSUN(wglGetProcAddress('glTexCoord2fNormal3fVertex3fSUN'{$IFDEF CLR}, typeof(TglTexCoord2fNormal3fVertex3fSUN){$ENDIF}));
  glTexCoord2fNormal3fVertex3fvSUN := TglTexCoord2fNormal3fVertex3fvSUN(wglGetProcAddress('glTexCoord2fNormal3fVertex3fvSUN'{$IFDEF CLR}, typeof(TglTexCoord2fNormal3fVertex3fvSUN){$ENDIF}));
  glTexCoord2fColor4fNormal3fVertex3fSUN := TglTexCoord2fColor4fNormal3fVertex3fSUN(wglGetProcAddress('glTexCoord2fColor4fNormal3fVertex3fSUN'{$IFDEF CLR}, typeof(TglTexCoord2fColor4fNormal3fVertex3fSUN){$ENDIF}));
  glTexCoord2fColor4fNormal3fVertex3fvSUN := TglTexCoord2fColor4fNormal3fVertex3fvSUN(wglGetProcAddress('glTexCoord2fColor4fNormal3fVertex3fvSUN'{$IFDEF CLR}, typeof(TglTexCoord2fColor4fNormal3fVertex3fvSUN){$ENDIF}));
  glTexCoord4fColor4fNormal3fVertex4fSUN := TglTexCoord4fColor4fNormal3fVertex4fSUN(wglGetProcAddress('glTexCoord4fColor4fNormal3fVertex4fSUN'{$IFDEF CLR}, typeof(TglTexCoord4fColor4fNormal3fVertex4fSUN){$ENDIF}));
  glTexCoord4fColor4fNormal3fVertex4fvSUN := TglTexCoord4fColor4fNormal3fVertex4fvSUN(wglGetProcAddress('glTexCoord4fColor4fNormal3fVertex4fvSUN'{$IFDEF CLR}, typeof(TglTexCoord4fColor4fNormal3fVertex4fvSUN){$ENDIF}));
  glReplacementCodeuiVertex3fSUN := TglReplacementCodeuiVertex3fSUN(wglGetProcAddress('glReplacementCodeuiVertex3fSUN'{$IFDEF CLR}, typeof(TglReplacementCodeuiVertex3fSUN){$ENDIF}));
  glReplacementCodeuiVertex3fvSUN := TglReplacementCodeuiVertex3fvSUN(wglGetProcAddress('glReplacementCodeuiVertex3fvSUN'{$IFDEF CLR}, typeof(TglReplacementCodeuiVertex3fvSUN){$ENDIF}));
  glReplacementCodeuiColor4ubVertex3fSUN := TglReplacementCodeuiColor4ubVertex3fSUN(wglGetProcAddress('glReplacementCodeuiColor4ubVertex3fSUN'{$IFDEF CLR}, typeof(TglReplacementCodeuiColor4ubVertex3fSUN){$ENDIF}));
  glReplacementCodeuiColor4ubVertex3fvSUN := TglReplacementCodeuiColor4ubVertex3fvSUN(wglGetProcAddress('glReplacementCodeuiColor4ubVertex3fvSUN'{$IFDEF CLR}, typeof(TglReplacementCodeuiColor4ubVertex3fvSUN){$ENDIF}));
  glReplacementCodeuiColor3fVertex3fSUN := TglReplacementCodeuiColor3fVertex3fSUN(wglGetProcAddress('glReplacementCodeuiColor3fVertex3fSUN'{$IFDEF CLR}, typeof(TglReplacementCodeuiColor3fVertex3fSUN){$ENDIF}));
  glReplacementCodeuiColor3fVertex3fvSUN := TglReplacementCodeuiColor3fVertex3fvSUN(wglGetProcAddress('glReplacementCodeuiColor3fVertex3fvSUN'{$IFDEF CLR}, typeof(TglReplacementCodeuiColor3fVertex3fvSUN){$ENDIF}));
  glReplacementCodeuiNormal3fVertex3fSUN := TglReplacementCodeuiNormal3fVertex3fSUN(wglGetProcAddress('glReplacementCodeuiNormal3fVertex3fSUN'{$IFDEF CLR}, typeof(TglReplacementCodeuiNormal3fVertex3fSUN){$ENDIF}));
  glReplacementCodeuiNormal3fVertex3fvSUN := TglReplacementCodeuiNormal3fVertex3fvSUN(wglGetProcAddress('glReplacementCodeuiNormal3fVertex3fvSUN'{$IFDEF CLR}, typeof(TglReplacementCodeuiNormal3fVertex3fvSUN){$ENDIF}));
  glReplacementCodeuiColor4fNormal3fVertex3fSUN := TglReplacementCodeuiColor4fNormal3fVertex3fSUN(wglGetProcAddress('glReplacementCodeuiColor4fNormal3fVertex3fSUN'{$IFDEF CLR}, typeof(TglReplacementCodeuiColor4fNormal3fVertex3fSUN){$ENDIF}));
  glReplacementCodeuiColor4fNormal3fVertex3fvSUN := TglReplacementCodeuiColor4fNormal3fVertex3fvSUN(wglGetProcAddress('glReplacementCodeuiColor4fNormal3fVertex3fvSUN'{$IFDEF CLR}, typeof(TglReplacementCodeuiColor4fNormal3fVertex3fvSUN){$ENDIF}));
  glReplacementCodeuiTexCoord2fVertex3fSUN := TglReplacementCodeuiTexCoord2fVertex3fSUN(wglGetProcAddress('glReplacementCodeuiTexCoord2fVertex3fSUN'{$IFDEF CLR}, typeof(TglReplacementCodeuiTexCoord2fVertex3fSUN){$ENDIF}));
  glReplacementCodeuiTexCoord2fVertex3fvSUN := TglReplacementCodeuiTexCoord2fVertex3fvSUN(wglGetProcAddress('glReplacementCodeuiTexCoord2fVertex3fvSUN'{$IFDEF CLR}, typeof(TglReplacementCodeuiTexCoord2fVertex3fvSUN){$ENDIF}));
  glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN := TglReplacementCodeuiTexCoord2fNormal3fVertex3fSUN(wglGetProcAddress('glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN'{$IFDEF CLR}, typeof(TglReplacementCodeuiTexCoord2fNormal3fVertex3fSUN){$ENDIF}));
  glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN := TglReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(wglGetProcAddress('glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN'{$IFDEF CLR}, typeof(TglReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN){$ENDIF}));
  glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN := TglReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN(wglGetProcAddress('glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN'{$IFDEF CLR}, typeof(TglReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN){$ENDIF}));
  glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN := TglReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(wglGetProcAddress('glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN'{$IFDEF CLR}, typeof(TglReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN){$ENDIF}));
end;

//Phobeus
{$IFDEF Win32CLR}
procedure Read_WGL_ARB_buffer_region;
begin
  wglCreateBufferRegionARB := TwglCreateBufferRegionARB(wglGetProcAddress('wglCreateBufferRegionARB'{$IFDEF CLR}, typeof(TwglCreateBufferRegionARB){$ENDIF}));
  wglDeleteBufferRegionARB := TwglDeleteBufferRegionARB(wglGetProcAddress('wglDeleteBufferRegionARB'{$IFDEF CLR}, typeof(TwglDeleteBufferRegionARB){$ENDIF}));
  wglSaveBufferRegionARB := TwglSaveBufferRegionARB(wglGetProcAddress('wglSaveBufferRegionARB'{$IFDEF CLR}, typeof(TwglSaveBufferRegionARB){$ENDIF}));
  wglRestoreBufferRegionARB := TwglRestoreBufferRegionARB(wglGetProcAddress('wglRestoreBufferRegionARB'{$IFDEF CLR}, typeof(TwglRestoreBufferRegionARB){$ENDIF}));
end;

procedure Read_WGL_ARB_extensions_string;
begin
  _wglGetExtensionsStringARB := TwglGetExtensionsStringARB(wglGetProcAddress('wglGetExtensionsStringARB'{$IFDEF CLR}, typeof(TwglGetExtensionsStringARB){$ENDIF}));
end;

procedure Read_WGL_ARB_make_current_read;
begin
  wglMakeContextCurrentARB := TwglMakeContextCurrentARB(wglGetProcAddress('wglMakeContextCurrentARB'{$IFDEF CLR}, typeof(TwglMakeContextCurrentARB){$ENDIF}));
  wglGetCurrentReadDCARB := TwglGetCurrentReadDCARB(wglGetProcAddress('wglGetCurrentReadDCARB'{$IFDEF CLR}, typeof(TwglGetCurrentReadDCARB){$ENDIF}));
end;

procedure Read_WGL_ARB_pbuffer;
begin
  wglCreatePbufferARB := TwglCreatePbufferARB(wglGetProcAddress('wglCreatePbufferARB'{$IFDEF CLR}, typeof(TwglCreatePbufferARB){$ENDIF}));
  wglGetPbufferDCARB := TwglGetPbufferDCARB(wglGetProcAddress('wglGetPbufferDCARB'{$IFDEF CLR}, typeof(TwglGetPbufferDCARB){$ENDIF}));
  wglReleasePbufferDCARB := TwglReleasePbufferDCARB(wglGetProcAddress('wglReleasePbufferDCARB'{$IFDEF CLR}, typeof(TwglReleasePbufferDCARB){$ENDIF}));
  wglDestroyPbufferARB := TwglDestroyPbufferARB(wglGetProcAddress('wglDestroyPbufferARB'{$IFDEF CLR}, typeof(TwglDestroyPbufferARB){$ENDIF}));
  wglQueryPbufferARB := TwglQueryPbufferARB(wglGetProcAddress('wglQueryPbufferARB'{$IFDEF CLR}, typeof(TwglQueryPbufferARB){$ENDIF}));
end;

procedure Read_WGL_ARB_pixel_format;
begin
  wglGetPixelFormatAttribivARB := TwglGetPixelFormatAttribivARB(wglGetProcAddress('wglGetPixelFormatAttribivARB'{$IFDEF CLR}, typeof(TwglGetPixelFormatAttribivARB){$ENDIF}));
  wglGetPixelFormatAttribfvARB := TwglGetPixelFormatAttribfvARB(wglGetProcAddress('wglGetPixelFormatAttribfvARB'{$IFDEF CLR}, typeof(TwglGetPixelFormatAttribfvARB){$ENDIF}));
  wglChoosePixelFormatARB := TwglChoosePixelFormatARB(wglGetProcAddress('wglChoosePixelFormatARB'{$IFDEF CLR}, typeof(TwglChoosePixelFormatARB){$ENDIF}));
end;

procedure Read_WGL_ARB_pixel_format_float;
begin
  wglClampColorARB := TwglClampColorARB(wglGetProcAddress('wglClampColorARB'{$IFDEF CLR}, typeof(TwglClampColorARB){$ENDIF}));
end;

procedure Read_WGL_ARB_render_texture;
begin
  wglBindTexImageARB := TwglBindTexImageARB(wglGetProcAddress('wglBindTexImageARB'{$IFDEF CLR}, typeof(TwglBindTexImageARB){$ENDIF}));
  wglReleaseTexImageARB := TwglReleaseTexImageARB(wglGetProcAddress('wglReleaseTexImageARB'{$IFDEF CLR}, typeof(TwglReleaseTexImageARB){$ENDIF}));
  wglSetPbufferAttribARB := TwglSetPbufferAttribARB(wglGetProcAddress('wglSetPbufferAttribARB'{$IFDEF CLR}, typeof(TwglSetPbufferAttribARB){$ENDIF}));
end;

procedure Read_WGL_EXT_display_color_table;
begin
  wglCreateDisplayColorTableEXT := TwglCreateDisplayColorTableEXT(wglGetProcAddress('wglCreateDisplayColorTableEXT'{$IFDEF CLR}, typeof(TwglCreateDisplayColorTableEXT){$ENDIF}));
  wglLoadDisplayColorTableEXT := TwglLoadDisplayColorTableEXT(wglGetProcAddress('wglLoadDisplayColorTableEXT'{$IFDEF CLR}, typeof(TwglLoadDisplayColorTableEXT){$ENDIF}));
  wglBindDisplayColorTableEXT := TwglBindDisplayColorTableEXT(wglGetProcAddress('wglBindDisplayColorTableEXT'{$IFDEF CLR}, typeof(TwglBindDisplayColorTableEXT){$ENDIF}));
  wglDestroyDisplayColorTableEXT := TwglDestroyDisplayColorTableEXT(wglGetProcAddress('wglDestroyDisplayColorTableEXT'{$IFDEF CLR}, typeof(TwglDestroyDisplayColorTableEXT){$ENDIF}));
end;

procedure Read_WGL_EXT_extensions_string;
begin
  _wglGetExtensionsStringEXT := TwglGetExtensionsStringEXT(wglGetProcAddress('wglGetExtensionsStringEXT'{$IFDEF CLR}, typeof(TwglGetExtensionsStringEXT){$ENDIF}));
end;

procedure Read_WGL_EXT_make_current_read;
begin
  wglMakeContextCurrentEXT := TwglMakeContextCurrentEXT(wglGetProcAddress('wglMakeContextCurrentEXT'{$IFDEF CLR}, typeof(TwglMakeContextCurrentEXT){$ENDIF}));
  wglGetCurrentReadDCEXT := TwglGetCurrentReadDCEXT(wglGetProcAddress('wglGetCurrentReadDCEXT'{$IFDEF CLR}, typeof(TwglGetCurrentReadDCEXT){$ENDIF}));
end;

procedure Read_WGL_EXT_pbuffer;
begin
  wglCreatePbufferEXT := TwglCreatePbufferEXT(wglGetProcAddress('wglCreatePbufferEXT'{$IFDEF CLR}, typeof(TwglCreatePbufferEXT){$ENDIF}));
  wglGetPbufferDCEXT := TwglGetPbufferDCEXT(wglGetProcAddress('wglGetPbufferDCEXT'{$IFDEF CLR}, typeof(TwglGetPbufferDCEXT){$ENDIF}));
  wglReleasePbufferDCEXT := TwglReleasePbufferDCEXT(wglGetProcAddress('wglReleasePbufferDCEXT'{$IFDEF CLR}, typeof(TwglReleasePbufferDCEXT){$ENDIF}));
  wglDestroyPbufferEXT := TwglDestroyPbufferEXT(wglGetProcAddress('wglDestroyPbufferEXT'{$IFDEF CLR}, typeof(TwglDestroyPbufferEXT){$ENDIF}));
  wglQueryPbufferEXT := TwglQueryPbufferEXT(wglGetProcAddress('wglQueryPbufferEXT'{$IFDEF CLR}, typeof(TwglQueryPbufferEXT){$ENDIF}));
end;

procedure Read_WGL_EXT_pixel_format;
begin
  wglGetPixelFormatAttribivEXT := TwglGetPixelFormatAttribivEXT(wglGetProcAddress('wglGetPixelFormatAttribivEXT'{$IFDEF CLR}, typeof(TwglGetPixelFormatAttribivEXT){$ENDIF}));
  wglGetPixelFormatAttribfvEXT := TwglGetPixelFormatAttribfvEXT(wglGetProcAddress('wglGetPixelFormatAttribfvEXT'{$IFDEF CLR}, typeof(TwglGetPixelFormatAttribfvEXT){$ENDIF}));
  wglChoosePixelFormatEXT := TwglChoosePixelFormatEXT(wglGetProcAddress('wglChoosePixelFormatEXT'{$IFDEF CLR}, typeof(TwglChoosePixelFormatEXT){$ENDIF}));
end;

procedure Read_WGL_EXT_swap_control;
begin
  wglSwapIntervalEXT := TwglSwapIntervalEXT(wglGetProcAddress('wglSwapIntervalEXT'{$IFDEF CLR}, typeof(TwglSwapIntervalEXT){$ENDIF}));
  wglGetSwapIntervalEXT := TwglGetSwapIntervalEXT(wglGetProcAddress('wglGetSwapIntervalEXT'{$IFDEF CLR}, typeof(TwglGetSwapIntervalEXT){$ENDIF}));
end;

procedure Read_WGL_I3D_digital_video_control;
begin
  wglGetDigitalVideoParametersI3D := TwglGetDigitalVideoParametersI3D(wglGetProcAddress('wglGetDigitalVideoParametersI3D'{$IFDEF CLR}, typeof(TwglGetDigitalVideoParametersI3D){$ENDIF}));
  wglSetDigitalVideoParametersI3D := TwglSetDigitalVideoParametersI3D(wglGetProcAddress('wglSetDigitalVideoParametersI3D'{$IFDEF CLR}, typeof(TwglSetDigitalVideoParametersI3D){$ENDIF}));
end;

procedure Read_WGL_I3D_gamma;
begin
  wglGetGammaTableParametersI3D := TwglGetGammaTableParametersI3D(wglGetProcAddress('wglGetGammaTableParametersI3D'{$IFDEF CLR}, typeof(TwglGetGammaTableParametersI3D){$ENDIF}));
  wglSetGammaTableParametersI3D := TwglSetGammaTableParametersI3D(wglGetProcAddress('wglSetGammaTableParametersI3D'{$IFDEF CLR}, typeof(TwglSetGammaTableParametersI3D){$ENDIF}));
  wglGetGammaTableI3D := TwglGetGammaTableI3D(wglGetProcAddress('wglGetGammaTableI3D'{$IFDEF CLR}, typeof(TwglGetGammaTableI3D){$ENDIF}));
  wglSetGammaTableI3D := TwglSetGammaTableI3D(wglGetProcAddress('wglSetGammaTableI3D'{$IFDEF CLR}, typeof(TwglSetGammaTableI3D){$ENDIF}));
end;

procedure Read_WGL_I3D_genlock;
begin
  wglEnableGenlockI3D := TwglEnableGenlockI3D(wglGetProcAddress('wglEnableGenlockI3D'{$IFDEF CLR}, typeof(TwglEnableGenlockI3D){$ENDIF}));
  wglDisableGenlockI3D := TwglDisableGenlockI3D(wglGetProcAddress('wglDisableGenlockI3D'{$IFDEF CLR}, typeof(TwglDisableGenlockI3D){$ENDIF}));
  wglIsEnabledGenlockI3D := TwglIsEnabledGenlockI3D(wglGetProcAddress('wglIsEnabledGenlockI3D'{$IFDEF CLR}, typeof(TwglIsEnabledGenlockI3D){$ENDIF}));
  wglGenlockSourceI3D := TwglGenlockSourceI3D(wglGetProcAddress('wglGenlockSourceI3D'{$IFDEF CLR}, typeof(TwglGenlockSourceI3D){$ENDIF}));
  wglGetGenlockSourceI3D := TwglGetGenlockSourceI3D(wglGetProcAddress('wglGetGenlockSourceI3D'{$IFDEF CLR}, typeof(TwglGetGenlockSourceI3D){$ENDIF}));
  wglGenlockSourceEdgeI3D := TwglGenlockSourceEdgeI3D(wglGetProcAddress('wglGenlockSourceEdgeI3D'{$IFDEF CLR}, typeof(TwglGenlockSourceEdgeI3D){$ENDIF}));
  wglGetGenlockSourceEdgeI3D := TwglGetGenlockSourceEdgeI3D(wglGetProcAddress('wglGetGenlockSourceEdgeI3D'{$IFDEF CLR}, typeof(TwglGetGenlockSourceEdgeI3D){$ENDIF}));
  wglGenlockSampleRateI3D := TwglGenlockSampleRateI3D(wglGetProcAddress('wglGenlockSampleRateI3D'{$IFDEF CLR}, typeof(TwglGenlockSampleRateI3D){$ENDIF}));
  wglGetGenlockSampleRateI3D := TwglGetGenlockSampleRateI3D(wglGetProcAddress('wglGetGenlockSampleRateI3D'{$IFDEF CLR}, typeof(TwglGetGenlockSampleRateI3D){$ENDIF}));
  wglGenlockSourceDelayI3D := TwglGenlockSourceDelayI3D(wglGetProcAddress('wglGenlockSourceDelayI3D'{$IFDEF CLR}, typeof(TwglGenlockSourceDelayI3D){$ENDIF}));
  wglGetGenlockSourceDelayI3D := TwglGetGenlockSourceDelayI3D(wglGetProcAddress('wglGetGenlockSourceDelayI3D'{$IFDEF CLR}, typeof(TwglGetGenlockSourceDelayI3D){$ENDIF}));
  wglQueryGenlockMaxSourceDelayI3D := TwglQueryGenlockMaxSourceDelayI3D(wglGetProcAddress('wglQueryGenlockMaxSourceDelayI3D'{$IFDEF CLR}, typeof(TwglQueryGenlockMaxSourceDelayI3D){$ENDIF}));
end;

procedure Read_WGL_I3D_image_buffer;
begin
  wglCreateImageBufferI3D := TwglCreateImageBufferI3D(wglGetProcAddress('wglCreateImageBufferI3D'{$IFDEF CLR}, typeof(TwglCreateImageBufferI3D){$ENDIF}));
  wglDestroyImageBufferI3D := TwglDestroyImageBufferI3D(wglGetProcAddress('wglDestroyImageBufferI3D'{$IFDEF CLR}, typeof(TwglDestroyImageBufferI3D){$ENDIF}));
  wglAssociateImageBufferEventsI3D := TwglAssociateImageBufferEventsI3D(wglGetProcAddress('wglAssociateImageBufferEventsI3D'{$IFDEF CLR}, typeof(TwglAssociateImageBufferEventsI3D){$ENDIF}));
  wglReleaseImageBufferEventsI3D := TwglReleaseImageBufferEventsI3D(wglGetProcAddress('wglReleaseImageBufferEventsI3D'{$IFDEF CLR}, typeof(TwglReleaseImageBufferEventsI3D){$ENDIF}));
end;

procedure Read_WGL_I3D_swap_frame_lock;
begin
  wglEnableFrameLockI3D := TwglEnableFrameLockI3D(wglGetProcAddress('wglEnableFrameLockI3D'{$IFDEF CLR}, typeof(TwglEnableFrameLockI3D){$ENDIF}));
  wglDisableFrameLockI3D := TwglDisableFrameLockI3D(wglGetProcAddress('wglDisableFrameLockI3D'{$IFDEF CLR}, typeof(TwglDisableFrameLockI3D){$ENDIF}));
  wglIsEnabledFrameLockI3D := TwglIsEnabledFrameLockI3D(wglGetProcAddress('wglIsEnabledFrameLockI3D'{$IFDEF CLR}, typeof(TwglIsEnabledFrameLockI3D){$ENDIF}));
  wglQueryFrameLockMasterI3D := TwglQueryFrameLockMasterI3D(wglGetProcAddress('wglQueryFrameLockMasterI3D'{$IFDEF CLR}, typeof(TwglQueryFrameLockMasterI3D){$ENDIF}));
end;

procedure Read_WGL_I3D_swap_frame_usage;
begin
  wglGetFrameUsageI3D := TwglGetFrameUsageI3D(wglGetProcAddress('wglGetFrameUsageI3D'{$IFDEF CLR}, typeof(TwglGetFrameUsageI3D){$ENDIF}));
  wglBeginFrameTrackingI3D := TwglBeginFrameTrackingI3D(wglGetProcAddress('wglBeginFrameTrackingI3D'{$IFDEF CLR}, typeof(TwglBeginFrameTrackingI3D){$ENDIF}));
  wglEndFrameTrackingI3D := TwglEndFrameTrackingI3D(wglGetProcAddress('wglEndFrameTrackingI3D'{$IFDEF CLR}, typeof(TwglEndFrameTrackingI3D){$ENDIF}));
  wglQueryFrameTrackingI3D := TwglQueryFrameTrackingI3D(wglGetProcAddress('wglQueryFrameTrackingI3D'{$IFDEF CLR}, typeof(TwglQueryFrameTrackingI3D){$ENDIF}));
end;

procedure Read_WGL_NV_vertex_array_range;
begin
  wglAllocateMemoryNV := TwglAllocateMemoryNV(wglGetProcAddress('wglAllocateMemoryNV'{$IFDEF CLR}, typeof(TwglAllocateMemoryNV){$ENDIF}));
  wglFreeMemoryNV := TwglFreeMemoryNV(wglGetProcAddress('wglFreeMemoryNV'{$IFDEF CLR}, typeof(TwglFreeMemoryNV){$ENDIF}));
end;

procedure Read_WGL_OML_sync_control;
begin
  wglGetSyncValuesOML := TwglGetSyncValuesOML(wglGetProcAddress('wglGetSyncValuesOML'{$IFDEF CLR}, typeof(TwglGetSyncValuesOML){$ENDIF}));
  wglGetMscRateOML := TwglGetMscRateOML(wglGetProcAddress('wglGetMscRateOML'{$IFDEF CLR}, typeof(TwglGetMscRateOML){$ENDIF}));
  wglSwapBuffersMscOML := TwglSwapBuffersMscOML(wglGetProcAddress('wglSwapBuffersMscOML'{$IFDEF CLR}, typeof(TwglSwapBuffersMscOML){$ENDIF}));
  wglSwapLayerBuffersMscOML := TwglSwapLayerBuffersMscOML(wglGetProcAddress('wglSwapLayerBuffersMscOML'{$IFDEF CLR}, typeof(TwglSwapLayerBuffersMscOML){$ENDIF}));
  wglWaitForMscOML := TwglWaitForMscOML(wglGetProcAddress('wglWaitForMscOML'{$IFDEF CLR}, typeof(TwglWaitForMscOML){$ENDIF}));
  wglWaitForSbcOML := TwglWaitForSbcOML(wglGetProcAddress('wglWaitForSbcOML'{$IFDEF CLR}, typeof(TwglWaitForSbcOML){$ENDIF}));
end;

procedure Read_WIN_draw_range_elements;
begin
  glDrawRangeElementsWIN := TglDrawRangeElementsWIN(wglGetProcAddress('glDrawRangeElementsWIN'{$IFDEF CLR}, typeof(TglDrawRangeElementsWIN){$ENDIF}));
end;

procedure Read_WIN_swap_hint;
begin
  glAddSwapHintRectWIN := TglAddSwapHintRectWIN(wglGetProcAddress('glAddSwapHintRectWIN'{$IFDEF CLR}, typeof(TglAddSwapHintRectWIN){$ENDIF}));
end;
{$ENDIF}
procedure Read_GL_ARB_Shader_Objects;
begin
  // GL_ARB_Shader_Objects
  _glCreateShaderObjectARB := TglCreateShaderObjectARB(wglGetProcAddress('glCreateShaderObjectARB'{$IFDEF CLR}, typeof(TglCreateShaderObjectARB){$ENDIF}));

  _glShaderSourceARB := TglShaderSourceARB(wglGetProcAddress('glShaderSourceARB'{$IFDEF CLR}, typeof(TglShaderSourceARB){$ENDIF}));
  glCompileShaderARB := TglCompileShaderARB(wglGetProcAddress('glCompileShaderARB'{$IFDEF CLR}, typeof(TglCompileShaderARB){$ENDIF}));
  glDeleteObjectARB := TglDeleteObjectARB(wglGetProcAddress('glDeleteObjectARB'{$IFDEF CLR}, typeof(TglDeleteObjectARB){$ENDIF}));
  glGetHandleARB := TglGetHandleARB(wglGetProcAddress('glGetHandleARB'{$IFDEF CLR}, typeof(TglGetHandleARB){$ENDIF}));
  glDetachObjectARB := TglDetachObjectARB(wglGetProcAddress('glDetachObjectARB'{$IFDEF CLR}, typeof(TglDetachObjectARB){$ENDIF}));
  glCreateProgramObjectARB := TglCreateProgramObjectARB(wglGetProcAddress('glCreateProgramObjectARB'{$IFDEF CLR}, typeof(TglCreateProgramObjectARB){$ENDIF}));
  glAttachObjectARB := TglAttachObjectARB(wglGetProcAddress('glAttachObjectARB'{$IFDEF CLR}, typeof(TglAttachObjectARB){$ENDIF}));
  glLinkProgramARB := TglLinkProgramARB(wglGetProcAddress('glLinkProgramARB'{$IFDEF CLR}, typeof(TglLinkProgramARB){$ENDIF}));
  glUseProgramObjectARB := TglUseProgramObjectARB(wglGetProcAddress('glUseProgramObjectARB'{$IFDEF CLR}, typeof(TglUseProgramObjectARB){$ENDIF}));
  glValidateProgramARB := TglValidateProgramARB(wglGetProcAddress('glValidateProgramARB'{$IFDEF CLR}, typeof(TglValidateProgramARB){$ENDIF}));
  glGetObjectParameterfvARB := TglGetObjectParameterfvARB(wglGetProcAddress('glGetObjectParameterfvARB'{$IFDEF CLR}, typeof(TglGetObjectParameterfvARB){$ENDIF}));
  glGetObjectParameterivARB := TglGetObjectParameterivARB(wglGetProcAddress('glGetObjectParameterivARB'{$IFDEF CLR}, typeof(TglGetObjectParameterivARB){$ENDIF}));
  glGetActiveUniformARB := TglGetActiveUniformARB(wglGetProcAddress('glGetActiveUniformARB'{$IFDEF CLR}, typeof(TglGetActiveUniformARB){$ENDIF}));
  glGetAttachedObjectsARB := TglGetAttachedObjectsARB(wglGetProcAddress('glGetAttachedObjectsARB'{$IFDEF CLR}, typeof(TglGetAttachedObjectsARB){$ENDIF}));
  glGetShaderSourceARB := TglGetShaderSourceARB(wglGetProcAddress('glGetShaderSourceARB'{$IFDEF CLR}, typeof(TglGetShaderSourceARB){$ENDIF}));
  glGetUniformfvARB := TglGetUniformfvARB(wglGetProcAddress('glGetUniformfvARB'{$IFDEF CLR}, typeof(TglGetUniformfvARB){$ENDIF}));
  glGetUniformivARB := TglGetUniformivARB(wglGetProcAddress('glGetUniformivARB'{$IFDEF CLR}, typeof(TglGetUniformivARB){$ENDIF}));
  glGetUniformLocationARB := TglGetUniformLocationARB(wglGetProcAddress('glGetUniformLocationARB'{$IFDEF CLR}, typeof(TglGetUniformLocationARB){$ENDIF}));
  _glGetInfoLogARB := TglGetInfoLogARB(wglGetProcAddress('glGetInfoLogARB'{$IFDEF CLR}, typeof(TglGetInfoLogARB){$ENDIF}));
  glUniform1fARB := TglUniform1fARB(wglGetProcAddress('glUniform1fARB'{$IFDEF CLR}, typeof(TglUniform1fARB){$ENDIF}));
  glUniform2fARB := TglUniform2fARB(wglGetProcAddress('glUniform2fARB'{$IFDEF CLR}, typeof(TglUniform2fARB){$ENDIF}));
  glUniform3fARB := TglUniform3fARB(wglGetProcAddress('glUniform3fARB'{$IFDEF CLR}, typeof(TglUniform3fARB){$ENDIF}));
  glUniform4fARB := TglUniform4fARB(wglGetProcAddress('glUniform4fARB'{$IFDEF CLR}, typeof(TglUniform4fARB){$ENDIF}));
  glUniform1iARB := TglUniform1iARB(wglGetProcAddress('glUniform1iARB'{$IFDEF CLR}, typeof(TglUniform1iARB){$ENDIF}));
  glUniform2iARB := TglUniform2iARB(wglGetProcAddress('glUniform2iARB'{$IFDEF CLR}, typeof(TglUniform2iARB){$ENDIF}));
  glUniform3iARB := TglUniform3iARB(wglGetProcAddress('glUniform3iARB'{$IFDEF CLR}, typeof(TglUniform3iARB){$ENDIF}));
  glUniform4iARB := TglUniform4iARB(wglGetProcAddress('glUniform4iARB'{$IFDEF CLR}, typeof(TglUniform4iARB){$ENDIF}));
  glUniform1fvARB := TglUniform1fvARB(wglGetProcAddress('glUniform1fvARB'{$IFDEF CLR}, typeof(TglUniform1fvARB){$ENDIF}));
  glUniform2fvARB := TglUniform2fvARB(wglGetProcAddress('glUniform2fvARB'{$IFDEF CLR}, typeof(TglUniform2fvARB){$ENDIF}));
  glUniform3fvARB := TglUniform3fvARB(wglGetProcAddress('glUniform3fvARB'{$IFDEF CLR}, typeof(TglUniform3fvARB){$ENDIF}));
  glUniform4fvARB := TglUniform4fvARB(wglGetProcAddress('glUniform4fvARB'{$IFDEF CLR}, typeof(TglUniform4fvARB){$ENDIF}));
  glUniform1ivARB := TglUniform1ivARB(wglGetProcAddress('glUniform1ivARB'{$IFDEF CLR}, typeof(TglUniform1ivARB){$ENDIF}));
  glUniform2ivARB := TglUniform2ivARB(wglGetProcAddress('glUniform2ivARB'{$IFDEF CLR}, typeof(TglUniform2ivARB){$ENDIF}));
  glUniform3ivARB := TglUniform3ivARB(wglGetProcAddress('glUniform3ivARB'{$IFDEF CLR}, typeof(TglUniform3ivARB){$ENDIF}));
  glUniform4ivARB := TglUniform4ivARB(wglGetProcAddress('glUniform4ivARB'{$IFDEF CLR}, typeof(TglUniform4ivARB){$ENDIF}));
  glUniformMatrix2fvARB := TglUniformMatrix2fvARB(wglGetProcAddress('glUniformMatrix2fvARB'{$IFDEF CLR}, typeof(TglUniformMatrix2fvARB){$ENDIF}));
  glUniformMatrix3fvARB := TglUniformMatrix3fvARB(wglGetProcAddress('glUniformMatrix3fvARB'{$IFDEF CLR}, typeof(TglUniformMatrix3fvARB){$ENDIF}));
  glUniformMatrix4fvARB := TglUniformMatrix4fvARB(wglGetProcAddress('glUniformMatrix4fvARB'{$IFDEF CLR}, typeof(TglUniformMatrix4fvARB){$ENDIF}));

  // GL_ARB_vertex_shader
  glGetActiveAttribARB := TglGetActiveAttribARB(wglGetProcAddress('glGetActiveAttribARB'{$IFDEF CLR}, typeof(TglGetActiveAttribARB){$ENDIF}));
  glGetAttribLocationARB := TglGetAttribLocationARB(wglGetProcAddress('glGetAttribLocationARB'{$IFDEF CLR}, typeof(TglGetAttribLocationARB){$ENDIF}));
  glBindAttribLocationARB := TglBindAttribLocationARB(wglGetProcAddress('glBindAttribLocationARB'{$IFDEF CLR}, typeof(TglBindAttribLocationARB){$ENDIF}));
  glGetVertexAttribPointervARB := TglGetVertexAttribPointervARB(wglGetProcAddress('glGetVertexAttribPointervARB'{$IFDEF CLR}, typeof(TglGetVertexAttribPointervARB){$ENDIF}));
end;

procedure Read_GL_ARB_occlusion_query;
begin
  glGenQueriesARB := TglGenQueriesARB(wglGetProcAddress('glGenQueriesARB'{$IFDEF CLR}, typeof(TglGenQueriesARB){$ENDIF}));
  glDeleteQueriesARB := TglDeleteQueriesARB(wglGetProcAddress('glDeleteQueriesARB'{$IFDEF CLR}, typeof(TglDeleteQueriesARB){$ENDIF}));
  glIsQueryARB := TglIsQueryARB(wglGetProcAddress('glIsQueryARB'{$IFDEF CLR}, typeof(TglIsQueryARB){$ENDIF}));
  glBeginQueryARB := TglBeginQueryARB(wglGetProcAddress('glBeginQueryARB'{$IFDEF CLR}, typeof(TglBeginQueryARB){$ENDIF}));
  glEndQueryARB := TglEndQueryARB(wglGetProcAddress('glEndQueryARB'{$IFDEF CLR}, typeof(TglEndQueryARB){$ENDIF}));
  glGetQueryivARB := TglGetQueryivARB(wglGetProcAddress('glGetQueryivARB'{$IFDEF CLR}, typeof(TglGetQueryivARB){$ENDIF}));
  glGetQueryObjectivARB := TglGetQueryObjectivARB(wglGetProcAddress('glGetQueryObjectivARB'{$IFDEF CLR}, typeof(TglGetQueryObjectivARB){$ENDIF}));
  glGetQueryObjectuivARB := TglGetQueryObjectuivARB(wglGetProcAddress('glGetQueryObjectuivARB'{$IFDEF CLR}, typeof(TglGetQueryObjectuivARB){$ENDIF}));
end;

procedure ReadExtensions;
begin
  ReadOpenGLCore;
  Read_GL_3DFX_tbuffer;
  Read_GL_APPLE_element_array;
  Read_GL_APPLE_fence;
  Read_GL_APPLE_vertex_array_object;
  Read_GL_APPLE_vertex_array_range;
  Read_GL_ARB_matrix_palette;
  Read_GL_ARB_multitexture;
  Read_GL_ARB_point_parameters;
  Read_GL_ARB_texture_compression;
  Read_GL_ARB_transpose_matrix;
  Read_GL_ARB_vertex_blend;
  Read_GL_ARB_buffer_object;
  Read_GL_ARB_vertex_program;
  Read_GL_ARB_window_pos;
  Read_GL_ARB_color_buffer_float;
  Read_GL_ATI_draw_buffers;
  Read_GL_ATI_element_array;
  Read_GL_ATI_envmap_bumpmap;
  Read_GL_ATI_fragment_shader;
  Read_GL_ATI_map_object_buffer;
  Read_GL_ATI_pn_triangles;
  Read_GL_ATI_separate_stencil;
  Read_GL_ATI_vertex_array_object;
  Read_GL_ATI_vertex_attrib_array_object;
  Read_GL_ATI_vertex_streams;
  Read_GL_EXT_blend_color;
  Read_GL_EXT_blend_func_separate;
  Read_GL_EXT_blend_minmax;
  Read_GL_EXT_color_subtable;
  Read_GL_EXT_compiled_vertex_array;
  Read_GL_EXT_convolution;
  Read_GL_EXT_coordinate_frame;
  Read_GL_EXT_copy_texture;
  Read_GL_EXT_cull_vertex;
  Read_GL_EXT_draw_range_elements;
  Read_GL_EXT_fog_coord;
  Read_GL_EXT_framebuffer_object;
  Read_GL_EXT_histogram;
  Read_GL_EXT_index_func;
  Read_GL_EXT_index_material;
  Read_GL_EXT_multi_draw_arrays;
  Read_GL_EXT_multisample;
  Read_GL_EXT_paletted_texture;
  Read_GL_EXT_pixel_transform;
  Read_GL_EXT_point_parameters;
  Read_GL_EXT_polygon_offset;
  Read_GL_EXT_secondary_color;
  Read_GL_EXT_stencil_two_side;
  Read_GL_EXT_subtexture;
  Read_GL_EXT_texture3D;
  Read_GL_EXT_texture_object;
  Read_GL_EXT_texture_perturb_normal;
  Read_GL_EXT_vertex_array;
  Read_GL_EXT_vertex_shader;
  Read_GL_EXT_vertex_weighting;
  Read_GL_EXT_depth_bounds_test;
  Read_GL_EXT_blend_equation_separate;
  Read_GL_EXT_stencil_clear_tag;
  Read_GL_HP_image_transform;
  Read_GL_IBM_multimode_draw_arrays;
  Read_GL_IBM_vertex_array_lists;
  Read_GL_INGR_blend_func_separate;
  Read_GL_INTEL_parallel_arrays;
  Read_GL_MESA_resize_buffers;
  Read_GL_MESA_window_pos;
  Read_GL_NV_evaluators;
  Read_GL_NV_fence;
  Read_GL_NV_fragment_program;
  Read_GL_NV_half_float;
  Read_GL_NV_occlusion_query;
  Read_GL_NV_pixel_data_range;
  Read_GL_NV_point_sprite;
  Read_GL_NV_primitive_restart;
  Read_GL_NV_register_combiners;
  Read_GL_NV_register_combiners2;
  Read_GL_NV_vertex_array_range;
  Read_GL_NV_vertex_program;
  Read_GL_PGI_misc_hints;
  Read_GL_SGIS_detail_texture;
  Read_GL_SGIS_fog_function;
  Read_GL_SGIS_multisample;
  Read_GL_SGIS_pixel_texture;
  Read_GL_SGIS_point_parameters;
  Read_GL_SGIS_sharpen_texture;
  Read_GL_SGIS_texture4D;
  Read_GL_SGIS_texture_color_mask;
  Read_GL_SGIS_texture_filter4;
  Read_GL_SGIX_async;
  Read_GL_SGIX_flush_raster;
  Read_GL_SGIX_fragment_lighting;
  Read_GL_SGIX_framezoom;
  Read_GL_SGIX_igloo_interface;
  Read_GL_SGIX_instruments;
  Read_GL_SGIX_list_priority;
  Read_GL_SGIX_pixel_texture;
  Read_GL_SGIX_polynomial_ffd;
  Read_GL_SGIX_reference_plane;
  Read_GL_SGIX_sprite;
  Read_GL_SGIX_tag_sample_buffer;
  Read_GL_SGI_color_table;
  Read_GL_SUNX_constant_data;
  Read_GL_SUN_global_alpha;
  Read_GL_SUN_mesh_array;
  Read_GL_SUN_triangle_list;
  Read_GL_SUN_vertex;

{$IFDEF Win32CLR}
  Read_WGL_ARB_buffer_region;
  Read_WGL_ARB_extensions_string;
  Read_WGL_ARB_make_current_read;
  Read_WGL_ARB_pbuffer;
  Read_WGL_ARB_pixel_format;
  Read_WGL_ARB_pixel_format_float;
  Read_WGL_ARB_render_texture;
  Read_WGL_EXT_display_color_table;
  Read_WGL_EXT_extensions_string;
  Read_WGL_EXT_make_current_read;
  Read_WGL_EXT_pbuffer;
  Read_WGL_EXT_pixel_format;
  Read_WGL_EXT_swap_control;
  Read_WGL_I3D_digital_video_control;
  Read_WGL_I3D_gamma;
  Read_WGL_I3D_genlock;
  Read_WGL_I3D_image_buffer;
  Read_WGL_I3D_swap_frame_lock;
  Read_WGL_I3D_swap_frame_usage;
  Read_WGL_NV_vertex_array_range;
  Read_WGL_OML_sync_control;
{$ENDIF}

  //Phobeus
  {$IFDEF Win32CLR}
  Read_WIN_draw_range_elements;
  Read_WIN_swap_hint;
  {$ENDIF}
  
  Read_GL_ARB_Shader_Objects;
  Read_GL_ARB_occlusion_query;
  ExtensionsRead := True;
end;

// =============================================================================
//  ReadImplementationProperties
// =============================================================================

procedure ReadImplementationProperties;
var
  Buffer: string;
  MajorVersion, MinorVersion: Integer;

  procedure TrimAndSplitVersionString(Buffer: string; var Max, Min: Integer);
    // Peels out the X.Y form from the given Buffer which must contain a version string like "text Minor.Major.Build text"
    // at least however "Major.Minor".
  var
    Separator: Integer;
  begin
    try
      // There must be at least one dot to separate major and minor version number.
      Separator := Pos('.', Buffer);
      // At least one number must be before and one after the dot.
      if (Separator > 1) and (Separator < Length(Buffer)) and (AnsiChar(Buffer[Separator - 1]) in ['0'..'9']) and
      (AnsiChar(Buffer[Separator + 1]) in ['0'..'9']) then
      begin
        // OK, it's a valid version string. Now remove unnecessary parts.
        Dec(Separator);
        // Find last non-numeric character before version number.
        while (Separator > 0) and (AnsiChar(Buffer[Separator]) in ['0'..'9']) do
          Dec(Separator);
        // Delete leading characters which do not belong to the version string.
        Delete(Buffer, 1, Separator);
        Separator := Pos('.', Buffer) + 1;
        // Find first non-numeric character after version number
        while (Separator <= Length(Buffer)) and (AnsiChar(Buffer[Separator]) in ['0'..'9']) do
          Inc(Separator);
        // delete trailing characters not belonging to the version string
        Delete(Buffer, Separator, 255);
        // Now translate the numbers.
        Separator := Pos('.', Buffer); // This is necessary because the buffer length might have changed.
        Max := StrToInt(Copy(Buffer, 1, Separator - 1));
        Min := StrToInt(Copy(Buffer, Separator + 1, 1));
      end
      else
        Abort;
    except
      Min := 0;
      Max := 0;
    end;
  end;

  // Checks if the given Extension string is in Buffer.
  function CheckExtension(const Extension: string): Boolean;
  var
    ExtPos: Integer;
  begin
    // First find the position of the extension string as substring in Buffer.
    ExtPos := Pos(Extension, Buffer);
    Result := ExtPos > 0;
    // Now check that it isn't only a substring of another extension.
    if Result then
      Result := ((ExtPos + Length(Extension) - 1) = Length(Buffer)) or
        not (AnsiChar(Buffer[ExtPos + Length(Extension)]) in ['_', 'A'..'Z', 'a'..'z']);
  end;
begin
  // determine version of implementation
  // GL
  Buffer := glGetString(GL_VERSION);
  TrimAndSplitVersionString(Buffer, MajorVersion, MinorVersion);

  GL_VERSION_1_0 := True;
  GL_VERSION_1_1 := False;
  GL_VERSION_1_2 := False;
  GL_VERSION_1_3 := False;
  GL_VERSION_1_4 := False;
  GL_VERSION_1_5 := False;
  GL_VERSION_2_0 := False;

  if MajorVersion = 1 then
  begin
    if MinorVersion >= 1 then
    begin
      GL_VERSION_1_1 := True;
      if MinorVersion >= 2 then
        GL_VERSION_1_2 := True;
      if MinorVersion >= 3 then
        GL_VERSION_1_3 := True;
      if MinorVersion >= 4 then
        GL_VERSION_1_4 := True;
      if MinorVersion >= 5 then
        GL_VERSION_1_5 := True;
    end;
  end;

  if MajorVersion >= 2 then
  begin
    GL_VERSION_1_1 := True;
    GL_VERSION_1_2 := True;
    GL_VERSION_1_3 := True;
    GL_VERSION_1_4 := True;
    GL_VERSION_1_5 := True;
    GL_VERSION_2_0 := True;
  end;

  // GLU
  GLU_VERSION_1_1 := False;
  GLU_VERSION_1_2 := False;
  GLU_VERSION_1_3 := False;
  // gluGetString is valid for version 1.1 or later
{$IFNDEF CLR}if Assigned(_gluGetString) then
{$ENDIF}
  begin
    Buffer := gluGetString(GLU_VERSION);
    TrimAndSplitVersionString(Buffer, Majorversion, MinorVersion);
    GLU_VERSION_1_1 := True;
    if MinorVersion >= 2 then
      GLU_VERSION_1_2 := True;
    if MinorVersion >= 3 then
      GLU_VERSION_1_3 := True;
  end;

  // check supported extensions
  Buffer := glGetString(GL_EXTENSIONS);
  if (LibHandle <> 0) then
  begin
{$IFDEF Win32CLR}
    if Assigned(@_wglGetExtensionsStringEXT) then
      Buffer := Buffer + ' ' + wglGetExtensionsStringEXT
    else
    begin
      _wglGetExtensionsStringARB := TwglGetExtensionsStringARB(glProcedure('wglGetExtensionsStringARB'));
      if Assigned(@_wglGetExtensionsStringARB) then
        Buffer := Buffer + ' ' + wglGetExtensionsStringARB(wglGetCurrentDC);
    end;
{$ENDIF}
  end;
  // Check all extensions
  // === 3DFX ====================================================================
  GL_3DFX_multisample := CheckExtension('GL_3DFX_multisample');
  GL_3DFX_tbuffer := CheckExtension('GL_3DFX_tbuffer');
  GL_3DFX_texture_compression_FXT1 := CheckExtension('GL_3DFX_texture_compression_FXT1');
  // === APPLE ===================================================================
  GL_APPLE_client_storage := CheckExtension('GL_APPLE_client_storage');
  GL_APPLE_element_array := CheckExtension('GL_APPLE_element_array');
  GL_APPLE_fence := CheckExtension('GL_APPLE_fence');
  GL_APPLE_specular_vector := CheckExtension('GL_APPLE_specular_vector');
  GL_APPLE_transform_hint := CheckExtension('GL_APPLE_transform_hint');
  GL_APPLE_vertex_array_object := CheckExtension('GL_APPLE_vertex_array_object');
  GL_APPLE_vertex_array_range := CheckExtension('GL_APPLE_vertex_array_range');
  GL_APPLE_ycbcr_422 := CheckExtension('GL_APPLE_ycbcr_422');
  // === ARB =====================================================================
  GL_ARB_depth_texture := CheckExtension('GL_ARB_depth_texture');
  GL_ARB_fragment_program := CheckExtension('GL_ARB_fragment_program');
  GL_ARB_imaging := CheckExtension('GL_ARB_imaging');
  GL_ARB_matrix_palette := CheckExtension('GL_ARB_matrix_palette');
  GL_ARB_multisample := CheckExtension('GL_ARB_multisample');
  GL_ARB_multitexture := CheckExtension('GL_ARB_multitexture');
  GL_ARB_point_parameters := CheckExtension('GL_ARB_point_parameters');
  GL_ARB_shadow := CheckExtension('GL_ARB_shadow');
  GL_ARB_shadow_ambient := CheckExtension('GL_ARB_shadow_ambient');
  GL_ARB_texture_border_clamp := CheckExtension('GL_ARB_texture_border_clamp');
  GL_ARB_texture_compression := CheckExtension('GL_ARB_texture_compression');
  GL_ARB_texture_cube_map := CheckExtension('GL_ARB_texture_cube_map');
  GL_ARB_texture_env_add := CheckExtension('GL_ARB_texture_env_add');
  GL_ARB_texture_env_combine := CheckExtension('GL_ARB_texture_env_combine');
  GL_ARB_texture_env_crossbar := CheckExtension('GL_ARB_texture_env_crossbar');
  GL_ARB_texture_env_dot3 := CheckExtension('GL_ARB_texture_env_dot3');
  GL_ARB_texture_mirrored_repeat := CheckExtension('GL_ARB_texture_mirrored_repeat');
  GL_ARB_transpose_matrix := CheckExtension('GL_ARB_transpose_matrix');
  GL_ARB_vertex_blend := CheckExtension('GL_ARB_vertex_blend');
  GL_ARB_vertex_buffer_object := CheckExtension('GL_ARB_vertex_buffer_object');
  GL_ARB_vertex_program := CheckExtension('GL_ARB_vertex_program');
  GL_ARB_window_pos := CheckExtension('GL_ARB_window_pos');
  GL_ARB_shader_objects := CheckExtension('GL_ARB_shader_objects');
  GL_ARB_vertex_shader := CheckExtension('GL_ARB_vertex_shader');
  GL_ARB_fragment_shader := CheckExtension('GL_ARB_fragment_shader');
  GL_ARB_occlusion_query := CheckExtension('GL_ARB_occlusion_query');
  GL_ARB_shading_language_100 := CheckExtension('GL_ARB_shading_language_100');
  GL_ARB_point_sprite := CheckExtension('GL_ARB_point_sprite');
  GL_ARB_texture_non_power_of_two := CheckExtension('GL_ARB_texture_non_power_of_two');
  GL_ARB_fragment_program_shadow := CheckExtension('GL_ARB_fragment_program_shadow');
  GL_ARB_draw_buffers := CheckExtension('GL_ARB_draw_buffers');
  GL_ARB_texture_rectangle := CheckExtension('GL_ARB_texture_rectangle');
  GL_ARB_color_buffer_float := CheckExtension('GL_ARB_color_buffer_float');
  GL_ARB_half_float_pixel := CheckExtension('GL_ARB_half_float_pixel');
  GL_ARB_texture_float := CheckExtension('GL_ARB_texture_float');
  GL_ARB_pixel_buffer_object := CheckExtension('GL_ARB_pixel_buffer_object');
  // === ATI =====================================================================
  GL_ATI_draw_buffers := CheckExtension('GL_ATI_draw_buffers');
  GL_ATI_element_array := CheckExtension('GL_ATI_element_array');
  GL_ATI_envmap_bumpmap := CheckExtension('GL_ATI_envmap_bumpmap');
  GL_ATI_fragment_shader := CheckExtension('GL_ATI_fragment_shader');
  GL_ATI_map_object_buffer := CheckExtension('GL_ATI_map_object_buffer');
  GL_ATI_pn_triangles := CheckExtension('GL_ATI_pn_triangles');
  GL_ATI_separate_stencil := CheckExtension('GL_ATI_separate_stencil');
  GL_ATI_text_fragment_shader := CheckExtension('GL_ATI_text_fragment_shader');
  GL_ATI_texture_env_combine3 := CheckExtension('GL_ATI_texture_env_combine3');
  GL_ATI_texture_float := CheckExtension('GL_ATI_texture_float');
  GL_ATI_texture_mirror_once := CheckExtension('GL_ATI_texture_mirror_once');
  GL_ATI_vertex_array_object := CheckExtension('GL_ATI_vertex_array_object');
  GL_ATI_vertex_attrib_array_object := CheckExtension('GL_ATI_vertex_attrib_array_object');
  GL_ATI_vertex_streams := CheckExtension('GL_ATI_vertex_streams');
  // === EXT =====================================================================
  GL_EXT_422_pixels := CheckExtension('GL_EXT_422_pixels');
  GL_EXT_abgr := CheckExtension('GL_EXT_abgr');
  GL_EXT_bgra := CheckExtension('GL_EXT_bgra');
  GL_EXT_blend_color := CheckExtension('GL_EXT_blend_color');
  GL_EXT_blend_func_separate := CheckExtension('GL_EXT_blend_func_separate');
  GL_EXT_blend_logic_op := CheckExtension('GL_EXT_blend_logic_op');
  GL_EXT_blend_minmax := CheckExtension('GL_EXT_blend_minmax');
  GL_EXT_blend_subtract := CheckExtension('GL_EXT_blend_subtract');
  GL_EXT_clip_volume_hint := CheckExtension('GL_EXT_clip_volume_hint');
  GL_EXT_cmyka := CheckExtension('GL_EXT_cmyka');
  GL_EXT_color_matrix := CheckExtension('GL_EXT_color_matrix');
  GL_EXT_color_subtable := CheckExtension('GL_EXT_color_subtable');
  GL_EXT_compiled_vertex_array := CheckExtension('GL_EXT_compiled_vertex_array');
  GL_EXT_convolution := CheckExtension('GL_EXT_convolution');
  GL_EXT_coordinate_frame := CheckExtension('GL_EXT_coordinate_frame');
  GL_EXT_copy_texture := CheckExtension('GL_EXT_copy_texture');
  GL_EXT_cull_vertex := CheckExtension('GL_EXT_cull_vertex');
  GL_EXT_draw_range_elements := CheckExtension('GL_EXT_draw_range_elements');
  GL_EXT_fog_coord := CheckExtension('GL_EXT_fog_coord');
  GL_EXT_framebuffer_object := CheckExtension('GL_EXT_framebuffer_object');
  GL_EXT_histogram := CheckExtension('GL_EXT_histogram');
  GL_EXT_index_array_formats := CheckExtension('GL_EXT_index_array_formats');
  GL_EXT_index_func := CheckExtension('GL_EXT_index_func');
  GL_EXT_index_material := CheckExtension('GL_EXT_index_material');
  GL_EXT_index_texture := CheckExtension('GL_EXT_index_texture');
  GL_EXT_light_texture := CheckExtension('GL_EXT_light_texture');
  GL_EXT_misc_attribute := CheckExtension('GL_EXT_misc_attribute');
  GL_EXT_multi_draw_arrays := CheckExtension('GL_EXT_multi_draw_arrays');
  GL_EXT_multisample := CheckExtension('GL_EXT_multisample');
  GL_EXT_packed_pixels := CheckExtension('GL_EXT_packed_pixels');
  GL_EXT_paletted_texture := CheckExtension('GL_EXT_paletted_texture');
  GL_EXT_pixel_transform := CheckExtension('GL_EXT_pixel_transform');
  GL_EXT_pixel_transform_color_table := CheckExtension('GL_EXT_pixel_transform_color_table');
  GL_EXT_point_parameters := CheckExtension('GL_EXT_point_parameters');
  GL_EXT_polygon_offset := CheckExtension('GL_EXT_polygon_offset');
  GL_EXT_rescale_normal := CheckExtension('GL_EXT_rescale_normal');
  GL_EXT_secondary_color := CheckExtension('GL_EXT_secondary_color');
  GL_EXT_separate_specular_color := CheckExtension('GL_EXT_separate_specular_color');
  GL_EXT_shadow_funcs := CheckExtension('GL_EXT_shadow_funcs');
  GL_EXT_shared_texture_palette := CheckExtension('GL_EXT_shared_texture_palette');
  GL_EXT_stencil_two_side := CheckExtension('GL_EXT_stencil_two_side');
  GL_EXT_stencil_wrap := CheckExtension('GL_EXT_stencil_wrap');
  GL_EXT_subtexture := CheckExtension('GL_EXT_subtexture');
  GL_EXT_texture := CheckExtension('GL_EXT_texture');
  GL_EXT_texture3D := CheckExtension('GL_EXT_texture3D');
  GL_EXT_texture_compression_s3tc := CheckExtension('GL_EXT_texture_compression_s3tc');
  GL_EXT_texture_cube_map := CheckExtension('GL_EXT_texture_cube_map');
  GL_EXT_texture_edge_clamp := CheckExtension('GL_EXT_texture_edge_clamp');
  GL_EXT_texture_env_add := CheckExtension('GL_EXT_texture_env_add');
  GL_EXT_texture_env_combine := CheckExtension('GL_EXT_texture_env_combine');
  GL_EXT_texture_env_dot3 := CheckExtension('GL_EXT_texture_env_dot3');
  GL_EXT_texture_filter_anisotropic := CheckExtension('GL_EXT_texture_filter_anisotropic');
  GL_EXT_texture_lod_bias := CheckExtension('GL_EXT_texture_lod_bias');
  GL_EXT_texture_object := CheckExtension('GL_EXT_texture_object');
  GL_EXT_texture_perturb_normal := CheckExtension('GL_EXT_texture_perturb_normal');
  GL_EXT_texture_rectangle := CheckExtension('GL_EXT_texture_rectangle');
  GL_EXT_vertex_array := CheckExtension('GL_EXT_vertex_array');
  GL_EXT_vertex_shader := CheckExtension('GL_EXT_vertex_shader');
  GL_EXT_vertex_weighting := CheckExtension('GL_EXT_vertex_weighting');
  GL_EXT_depth_bounds_test := CheckExtension('GL_EXT_depth_bounds_test');
  GL_EXT_texture_mirror_clamp := CheckExtension('GL_EXT_texture_mirror_clamp');
  GL_EXT_blend_equation_separate := CheckExtension('GL_EXT_blend_equation_separate');
  GL_EXT_pixel_buffer_object := CheckExtension('GL_EXT_pixel_buffer_object');
  GL_EXT_texture_compression_dxt1 := CheckExtension('GL_EXT_texture_compression_dxt1');
  GL_EXT_stencil_clear_tag := CheckExtension('GL_EXT_stencil_clear_tag');
  GL_FfdMaskSGIX := CheckExtension('GL_FfdMaskSGIX');
  // === HP ======================================================================
  GL_HP_convolution_border_modes := CheckExtension('GL_HP_convolution_border_modes');
  GL_HP_image_transform := CheckExtension('GL_HP_image_transform');
  GL_HP_occlusion_test := CheckExtension('GL_HP_occlusion_test');
  GL_HP_texture_lighting := CheckExtension('GL_HP_texture_lighting');
  // === IBM =====================================================================
  GL_IBM_cull_vertex := CheckExtension('GL_IBM_cull_vertex');
  GL_IBM_multimode_draw_arrays := CheckExtension('GL_IBM_multimode_draw_arrays');
  GL_IBM_rasterpos_clip := CheckExtension('GL_IBM_rasterpos_clip');
  GL_IBM_texture_mirrored_repeat := CheckExtension('GL_IBM_texture_mirrored_repeat');
  GL_IBM_vertex_array_lists := CheckExtension('GL_IBM_vertex_array_lists');
  // === INGR ====================================================================
  GL_INGR_blend_func_separate := CheckExtension('GL_INGR_blend_func_separate');
  GL_INGR_color_clamp := CheckExtension('GL_INGR_color_clamp');
  GL_INGR_interlace_read := CheckExtension('GL_INGR_interlace_read');
  GL_INGR_palette_buffer := CheckExtension('GL_INGR_palette_buffer');
  // === INTEL ===================================================================
  GL_INTEL_parallel_arrays := CheckExtension('GL_INTEL_parallel_arrays');
  GL_INTEL_texture_scissor := CheckExtension('GL_INTEL_texture_scissor');
  // === MESA ====================================================================
  GL_MESA_resize_buffers := CheckExtension('GL_MESA_resize_buffers');
  GL_MESA_window_pos := CheckExtension('GL_MESA_window_pos');
  // === NVIDIA ==================================================================
  GL_NV_blend_square := CheckExtension('GL_NV_blend_square');
  GL_NV_copy_depth_to_color := CheckExtension('GL_NV_copy_depth_to_color');
  GL_NV_depth_clamp := CheckExtension('GL_NV_depth_clamp');
  GL_NV_evaluators := CheckExtension('GL_NV_evaluators');
  GL_NV_fence := CheckExtension('GL_NV_fence');
  GL_NV_float_buffer := CheckExtension('GL_NV_float_buffer');
  GL_NV_fog_distance := CheckExtension('GL_NV_fog_distance');
  GL_NV_fragment_program := CheckExtension('GL_NV_fragment_program');
  GL_NV_half_float := CheckExtension('GL_NV_half_float');
  GL_NV_light_max_exponent := CheckExtension('GL_NV_light_max_exponent');
  GL_NV_multisample_filter_hint := CheckExtension('GL_NV_multisample_filter_hint');
  GL_NV_occlusion_query := CheckExtension('GL_NV_occlusion_query');
  GL_NV_packed_depth_stencil := CheckExtension('GL_NV_packed_depth_stencil');
  GL_NV_pixel_data_range := CheckExtension('GL_NV_pixel_data_range');
  GL_NV_point_sprite := CheckExtension('GL_NV_point_sprite');
  GL_NV_primitive_restart := CheckExtension('GL_NV_primitive_restart');
  GL_NV_register_combiners := CheckExtension('GL_NV_register_combiners');
  GL_NV_register_combiners2 := CheckExtension('GL_NV_register_combiners2');
  GL_NV_texgen_emboss := CheckExtension('GL_NV_texgen_emboss');
  GL_NV_texgen_reflection := CheckExtension('GL_NV_texgen_reflection');
  GL_NV_texture_compression_vtc := CheckExtension('GL_NV_texture_compression_vtc');
  GL_NV_texture_env_combine4 := CheckExtension('GL_NV_texture_env_combine4');
  GL_NV_texture_expand_normal := CheckExtension('GL_NV_texture_expand_normal');
  GL_NV_texture_rectangle := CheckExtension('GL_NV_texture_rectangle');
  GL_NV_texture_shader := CheckExtension('GL_NV_texture_shader');
  GL_NV_texture_shader2 := CheckExtension('GL_NV_texture_shader2');
  GL_NV_texture_shader3 := CheckExtension('GL_NV_texture_shader3');
  GL_NV_vertex_array_range := CheckExtension('GL_NV_vertex_array_range');
  GL_NV_vertex_array_range2 := CheckExtension('GL_NV_vertex_array_range2');
  GL_NV_vertex_program := CheckExtension('GL_NV_vertex_program');
  GL_NV_vertex_program1_1 := CheckExtension('GL_NV_vertex_program1_1');
  GL_NV_vertex_program2 := CheckExtension('GL_NV_vertex_program2');
  GL_NV_fragment_program_option := CheckExtension('GL_NV_fragment_program_option');
  GL_NV_fragment_program2 := CheckExtension('GL_NV_fragment_program2');
  GL_NV_vertex_program2_option := CheckExtension('GL_NV_vertex_program2_option');
  GL_NV_vertex_program3 := CheckExtension('GL_NV_vertex_program3');
  // === OML =====================================================================
  GL_OML_interlace := CheckExtension('GL_OML_interlace');
  GL_OML_resample := CheckExtension('GL_OML_resample');
  GL_OML_subsample := CheckExtension('GL_OML_subsample');
  // === PGI =====================================================================
  GL_PGI_misc_hints := CheckExtension('GL_PGI_misc_hints');
  GL_PGI_vertex_hints := CheckExtension('GL_PGI_vertex_hints');
  // === REND ====================================================================
  GL_REND_screen_coordinates := CheckExtension('GL_REND_screen_coordinates');
  // === S3 ======================================================================
  GL_S3_s3tc := CheckExtension('GL_S3_s3tc');
  // === SGIS ====================================================================
  GL_SGIS_detail_texture := CheckExtension('GL_SGIS_detail_texture');
  GL_SGIS_fog_function := CheckExtension('GL_SGIS_fog_function');
  GL_SGIS_generate_mipmap := CheckExtension('GL_SGIS_generate_mipmap');
  GL_SGIS_multisample := CheckExtension('GL_SGIS_multisample');
  GL_SGIS_pixel_texture := CheckExtension('GL_SGIS_pixel_texture');
  GL_SGIS_point_line_texgen := CheckExtension('GL_SGIS_point_line_texgen');
  GL_SGIS_point_parameters := CheckExtension('GL_SGIS_point_parameters');
  GL_SGIS_sharpen_texture := CheckExtension('GL_SGIS_sharpen_texture');
  GL_SGIS_texture4D := CheckExtension('GL_SGIS_texture4D');
  GL_SGIS_texture_border_clamp := CheckExtension('GL_SGIS_texture_border_clamp');
  GL_SGIS_texture_color_mask := CheckExtension('GL_SGIS_texture_color_mask');
  GL_SGIS_texture_edge_clamp := CheckExtension('GL_SGIS_texture_edge_clamp');
  GL_SGIS_texture_filter4 := CheckExtension('GL_SGIS_texture_filter4');
  GL_SGIS_texture_lod := CheckExtension('GL_SGIS_texture_lod');
  GL_SGIS_texture_select := CheckExtension('GL_SGIS_texture_select');
  // === SGIX ====================================================================
  GL_SGIX_async := CheckExtension('GL_SGIX_async');
  GL_SGIX_async_histogram := CheckExtension('GL_SGIX_async_histogram');
  GL_SGIX_async_pixel := CheckExtension('GL_SGIX_async_pixel');
  GL_SGIX_blend_alpha_minmax := CheckExtension('GL_SGIX_blend_alpha_minmax');
  GL_SGIX_calligraphic_fragment := CheckExtension('GL_SGIX_calligraphic_fragment');
  GL_SGIX_clipmap := CheckExtension('GL_SGIX_clipmap');
  GL_SGIX_convolution_accuracy := CheckExtension('GL_SGIX_convolution_accuracy');
  GL_SGIX_depth_pass_instrument := CheckExtension('GL_SGIX_depth_pass_instrument');
  GL_SGIX_depth_texture := CheckExtension('GL_SGIX_depth_texture');
  GL_SGIX_flush_raster := CheckExtension('GL_SGIX_flush_raster');
  GL_SGIX_fog_offset := CheckExtension('GL_SGIX_fog_offset');
  GL_SGIX_fog_scale := CheckExtension('GL_SGIX_fog_scale');
  GL_SGIX_fragment_lighting := CheckExtension('GL_SGIX_fragment_lighting');
  GL_SGIX_framezoom := CheckExtension('GL_SGIX_framezoom');
  GL_SGIX_igloo_interface := CheckExtension('GL_SGIX_igloo_interface');
  GL_SGIX_impact_pixel_texture := CheckExtension('GL_SGIX_impact_pixel_texture');
  GL_SGIX_instruments := CheckExtension('GL_SGIX_instruments');
  GL_SGIX_interlace := CheckExtension('GL_SGIX_interlace');
  GL_SGIX_ir_instrument1 := CheckExtension('GL_SGIX_ir_instrument1');
  GL_SGIX_list_priority := CheckExtension('GL_SGIX_list_priority');
  GL_SGIX_pixel_texture := CheckExtension('GL_SGIX_pixel_texture');
  GL_SGIX_pixel_tiles := CheckExtension('GL_SGIX_pixel_tiles');
  GL_SGIX_polynomial_ffd := CheckExtension('GL_SGIX_polynomial_ffd');
  GL_SGIX_reference_plane := CheckExtension('GL_SGIX_reference_plane');
  GL_SGIX_resample := CheckExtension('GL_SGIX_resample');
  GL_SGIX_scalebias_hint := CheckExtension('GL_SGIX_scalebias_hint');
  GL_SGIX_shadow := CheckExtension('GL_SGIX_shadow');
  GL_SGIX_shadow_ambient := CheckExtension('GL_SGIX_shadow_ambient');
  GL_SGIX_sprite := CheckExtension('GL_SGIX_sprite');
  GL_SGIX_subsample := CheckExtension('GL_SGIX_subsample');
  GL_SGIX_tag_sample_buffer := CheckExtension('GL_SGIX_tag_sample_buffer');
  GL_SGIX_texture_add_env := CheckExtension('GL_SGIX_texture_add_env');
  GL_SGIX_texture_coordinate_clamp := CheckExtension('GL_SGIX_texture_coordinate_clamp');
  GL_SGIX_texture_lod_bias := CheckExtension('GL_SGIX_texture_lod_bias');
  GL_SGIX_texture_multi_buffer := CheckExtension('GL_SGIX_texture_multi_buffer');
  GL_SGIX_texture_scale_bias := CheckExtension('GL_SGIX_texture_scale_bias');
  GL_SGIX_texture_select := CheckExtension('GL_SGIX_texture_select');
  GL_SGIX_vertex_preclip := CheckExtension('GL_SGIX_vertex_preclip');
  GL_SGIX_ycrcb := CheckExtension('GL_SGIX_ycrcb');
  GL_SGIX_ycrcb_subsample := CheckExtension('GL_SGIX_ycrcb_subsample');
  GL_SGIX_ycrcba := CheckExtension('GL_SGIX_ycrcba');
  // === SGI =====================================================================
  GL_SGI_color_matrix := CheckExtension('GL_SGI_color_matrix');
  GL_SGI_color_table := CheckExtension('GL_SGI_color_table');
  GL_SGI_depth_pass_instrument := CheckExtension('GL_SGI_depth_pass_instrument');
  GL_SGI_texture_color_table := CheckExtension('GL_SGI_texture_color_table');
  // === SUN =====================================================================
  GL_SUNX_constant_data := CheckExtension('GL_SUNX_constant_data');
  GL_SUN_convolution_border_modes := CheckExtension('GL_SUN_convolution_border_modes');
  GL_SUN_global_alpha := CheckExtension('GL_SUN_global_alpha');
  GL_SUN_mesh_array := CheckExtension('GL_SUN_mesh_array');
  GL_SUN_slice_accum := CheckExtension('GL_SUN_slice_accum');
  GL_SUN_triangle_list := CheckExtension('GL_SUN_triangle_list');
  GL_SUN_vertex := CheckExtension('GL_SUN_vertex');
  // === WIN =====================================================================
  GL_WIN_phong_shading := CheckExtension('GL_WIN_phong_shading');
  GL_WIN_specular_fog := CheckExtension('GL_WIN_specular_fog');
  // === WGL =====================================================================
{$IFDEF WIN32}
  WGL_3DFX_multisample := CheckExtension('WGL_3DFX_multisample');
  WGL_ARB_buffer_region := CheckExtension('WGL_ARB_buffer_region');
  WGL_ARB_extensions_string := CheckExtension('WGL_ARB_extensions_string');
  WGL_ARB_make_current_read := CheckExtension('WGL_ARB_make_current_read');
  WGL_ARB_multisample := CheckExtension('WGL_ARB_multisample');
  WGL_ARB_pbuffer := CheckExtension('WGL_ARB_pbuffer');
  WGL_ARB_pixel_format := CheckExtension('WGL_ARB_pixel_format');
  WGL_ARB_pixel_format_float := CheckExtension('WGL_ARB_pixel_format_float');
  WGL_ARB_render_texture := CheckExtension('WGL_ARB_render_texture');
  WGL_ATI_pixel_format_float := CheckExtension('WGL_ATI_pixel_format_float');
  WGL_EXT_depth_float := CheckExtension('WGL_EXT_depth_float');
  WGL_EXT_display_color_table := CheckExtension('WGL_EXT_display_color_table');
  WGL_EXT_extensions_string := CheckExtension('WGL_EXT_extensions_string');
  WGL_EXT_make_current_read := CheckExtension('WGL_EXT_make_current_read');
  WGL_EXT_multisample := CheckExtension('WGL_EXT_multisample');
  WGL_EXT_pbuffer := CheckExtension('WGL_EXT_pbuffer');
  WGL_EXT_pixel_format := CheckExtension('WGL_EXT_pixel_format');
  WGL_EXT_swap_control := CheckExtension('WGL_EXT_swap_control');
  WGL_I3D_digital_video_control := CheckExtension('WGL_I3D_digital_video_control');
  WGL_I3D_gamma := CheckExtension('WGL_I3D_gamma');
  WGL_I3D_genlock := CheckExtension('WGL_I3D_genlock');
  WGL_I3D_image_buffer := CheckExtension('WGL_I3D_image_buffer');
  WGL_I3D_swap_frame_lock := CheckExtension('WGL_I3D_swap_frame_lock');
  WGL_I3D_swap_frame_usage := CheckExtension('WGL_I3D_swap_frame_usage');
  WGL_NV_float_buffer := CheckExtension('WGL_NV_float_buffer');
  WGL_NV_render_depth_texture := CheckExtension('WGL_NV_render_depth_texture');
  WGL_NV_render_texture_rectangle := CheckExtension('WGL_NV_render_texture_rectangle');
  WGL_NV_vertex_array_range := CheckExtension('WGL_NV_vertex_array_range');
  WGL_OML_sync_control := CheckExtension('WGL_OML_sync_control');
{$ENDIF}
  WIN_draw_range_elements := CheckExtension('WIN_draw_range_elements');
  WIN_swap_hint := CheckExtension('WIN_swap_hint');
  ImplementationRead := True;
end;

{$IFDEF WIN32}
// =============================================================================
// RaiseLastOSError
// =============================================================================
// Needed for compatibility with older Delphiversions
// =============================================================================

procedure RaiseLastOSError;
begin
{$IFDEF FPC}
  // Changed by bero
  raise Exception.Create('RaiseLastOSError!'); // To-Do: find a better solution
{$ELSE}
{$IFDEF VER140} // If Delphi 6 or later
  SysUtils.RaiseLastOSError;
{$ELSE}
  SysUtils.RaiseLastWin32Error;
{$ENDIF}
{$ENDIF}
end;

{$ENDIF}
{$IFDEF Win32CLR}
// =============================================================================
// CreateRenderingContext
// =============================================================================

function CreateRenderingContext(DC: HDC; Options: TRCOptions; ColorBits, ZBits, StencilBits, AccumBits, AuxBuffers: Integer; Layer: Integer): HGLRC;
const
  OBJ_MEMDC = 10;
  OBJ_ENHMETADC = 12;
  OBJ_METADC = 4;
  PFD_DOUBLEBUFFER = $00000001;
  PFD_STEREO = $00000002;
  PFD_DRAW_TO_WINDOW = $00000004;
  PFD_DRAW_TO_BITMAP = $00000008;
  PFD_SUPPORT_GDI = $00000010;
  PFD_SUPPORT_OPENGL = $00000020;
  PFD_TYPE_RGBA = 0;
  PFD_MAIN_PLANE = 0;
  PFD_OVERLAY_PLANE = 1;
  PFD_UNDERLAY_PLANE = LongWord(-1);
  MemoryDCs = [OBJ_MEMDC, OBJ_METADC, OBJ_ENHMETADC];
var
  PFDescriptor: TPixelFormatDescriptor;
  PixelFormat: Integer;
  AType: DWORD;
begin
  if LibHandle = 0 then
    InitOpenGL;

{$IFNDEF CLR}FillChar(PFDescriptor, SizeOf(PFDescriptor), 0); {$ENDIF}
  with PFDescriptor do
  begin
    nSize := SizeOf(PFDescriptor);
    nVersion := 1;
    dwFlags := PFD_SUPPORT_OPENGL;
    AType := GetObjectType(DC);
    if AType = 0 then
      RaiseLastOSError;
    if AType in MemoryDCs then
      dwFlags := dwFlags or PFD_DRAW_TO_BITMAP
    else
      dwFlags := dwFlags or PFD_DRAW_TO_WINDOW;
    if opDoubleBuffered in Options then
      dwFlags := dwFlags or PFD_DOUBLEBUFFER;
    if opGDI in Options then
      dwFlags := dwFlags or PFD_SUPPORT_GDI;
    if opStereo in Options then
      dwFlags := dwFlags or PFD_STEREO;
    iPixelType := PFD_TYPE_RGBA;
    cColorBits := ColorBits;
    cDepthBits := zBits;
    cStencilBits := StencilBits;
    cAccumBits := AccumBits;
    cAuxBuffers := AuxBuffers;
    if Layer = 0 then
      iLayerType := PFD_MAIN_PLANE
    else if Layer > 0 then
      iLayerType := PFD_OVERLAY_PLANE
    else
      iLayerType := Byte(PFD_UNDERLAY_PLANE);
  end;
{$IFDEF CLR}
  PixelFormat := ChoosePixelFormat(DC, PFDescriptor);
{$ELSE}
  PixelFormat := ChoosePixelFormat(DC, @PFDescriptor);
{$ENDIF}
  if PixelFormat = 0 then
    RaiseLastOSError;
  if GetPixelFormat(DC) <> PixelFormat then
{$IFDEF CLR}
    if not SetPixelFormat(DC, PixelFormat, PFDescriptor) then
{$ELSE}
    if not SetPixelFormat(DC, PixelFormat, @PFDescriptor) then
{$ENDIF}
      RaiseLastOSError;
  DescribePixelFormat(DC, PixelFormat, SizeOf(PFDescriptor), PFDescriptor);
  Result := wglCreateLayerContext(DC, Layer);
  if Result = 0 then
    RaiseLastOSError
  else
    LastPixelFormat := 0;
end;

// =============================================================================
// ActivateRenderingContext
// =============================================================================

procedure ActivateRenderingContext(DC: HDC; RC: HGLRC; loadext: boolean = true);
begin
  Assert((DC <> 0), 'DC must not be 0');
  Assert((RC <> 0), 'RC must not be 0');
  wglMakeCurrent(DC, RC);
  if (loadext) then
    ReadExtensions;
  ReadImplementationProperties;
end;

// =============================================================================
// DeactivateRenderingContext
// =============================================================================

procedure DeactivateRenderingContext;
begin
  wglMakeCurrent(0, 0);
end;

// =============================================================================
// DestroyRenderingContext
// =============================================================================

procedure DestroyRenderingContext(RC: HGLRC);
begin
  wglDeleteContext(RC);
end;
{$ENDIF}

{$IFDEF FPC}
{$IFDEF CPU386}
// Added by bero
const
  Default8087CW: Word = $1332;

procedure Set8087CW(NewCW: Word); assembler;
asm
  MOV Default8087CW, AX
end;
{$ENDIF}
{$ENDIF}

procedure STUB_glAccum(op: TGLenum; value: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glAccum := TglAccum(glProcedure('glAccum'{$IFDEF CLR}, typeof(TglAccum){$ENDIF}));
  glAccum(op, value);
end;

procedure STUB_glAlphaFunc(func: TGLenum; ref: TGLclampf); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glAlphaFunc := TglAlphaFunc(glProcedure('glAlphaFunc'{$IFDEF CLR}, typeof(TglAlphaFunc){$ENDIF}));
  glAlphaFunc(func, ref);
end;

function STUB_glAreTexturesResident(n: TGLsizei; const textures: PGLuint; residences: PGLboolean): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glAreTexturesResident := TglAreTexturesResident(glProcedure('glAreTexturesResident'{$IFDEF CLR}, typeof(TglAreTexturesResident){$ENDIF}));
  result := glAreTexturesResident(n, textures, residences);
end;

procedure STUB_glArrayElement(i: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glArrayElement := TglArrayElement(glProcedure('glArrayElement'{$IFDEF CLR}, typeof(TglArrayElement){$ENDIF}));
  glArrayElement(i);
end;

procedure STUB_glBegin(mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glBegin := TglBegin(glProcedure('glBegin'{$IFDEF CLR}, typeof(TglBegin){$ENDIF}));
  glBegin(mode);
end;

procedure STUB_glBindTexture(target: TGLenum; texture: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glBindTexture := TglBindTexture(glProcedure('glBindTexture'{$IFDEF CLR}, typeof(TglBindTexture){$ENDIF}));
  glBindTexture(target, texture);
end;

procedure STUB_glBitmap(width: TGLsizei; height: TGLsizei; xorig: TGLfloat; yorig: TGLfloat; xmove: TGLfloat; ymove: TGLfloat; const bitmap: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glBitmap := TglBitmap(glProcedure('glBitmap'{$IFDEF CLR}, typeof(TglBitmap){$ENDIF}));
  glBitmap(width, height, xorig, yorig, xmove, ymove, bitmap);
end;

procedure STUB_glBlendFunc(sfactor: TGLenum; dfactor: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glBlendFunc := TglBlendFunc(glProcedure('glBlendFunc'{$IFDEF CLR}, typeof(TglBlendFunc){$ENDIF}));
  glBlendFunc(sfactor, dfactor);
end;

procedure STUB_glCallList(list: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCallList := TglCallList(glProcedure('glCallList'{$IFDEF CLR}, typeof(TglCallList){$ENDIF}));
  glCallList(list);
end;

procedure STUB_glCallLists(n: TGLsizei; _type: TGLenum; const lists: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCallLists := TglCallLists(glProcedure('glCallLists'{$IFDEF CLR}, typeof(TglCallLists){$ENDIF}));
  glCallLists(n, _type, lists);
end;

procedure STUB_glClear(mask: TGLbitfield); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glClear := TglClear(glProcedure('glClear'{$IFDEF CLR}, typeof(TglClear){$ENDIF}));
  glClear(mask);
end;

procedure STUB_glClearAccum(red: TGLfloat; green: TGLfloat; blue: TGLfloat; alpha: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glClearAccum := TglClearAccum(glProcedure('glClearAccum'{$IFDEF CLR}, typeof(TglClearAccum){$ENDIF}));
  glClearAccum(red, green, blue, alpha);
end;

procedure STUB_glClearColor(red: TGLclampf; green: TGLclampf; blue: TGLclampf; alpha: TGLclampf); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glClearColor := TglClearColor(glProcedure('glClearColor'{$IFDEF CLR}, typeof(TglClearColor){$ENDIF}));
  glClearColor(red, green, blue, alpha);
end;

procedure STUB_glClearDepth(depth: TGLclampd); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glClearDepth := TglClearDepth(glProcedure('glClearDepth'{$IFDEF CLR}, typeof(TglClearDepth){$ENDIF}));
  glClearDepth(depth);
end;

procedure STUB_glClearIndex(c: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glClearIndex := TglClearIndex(glProcedure('glClearIndex'{$IFDEF CLR}, typeof(TglClearIndex){$ENDIF}));
  glClearIndex(c);
end;

procedure STUB_glClearStencil(s: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glClearStencil := TglClearStencil(glProcedure('glClearStencil'{$IFDEF CLR}, typeof(TglClearStencil){$ENDIF}));
  glClearStencil(s);
end;

procedure STUB_glClipPlane(plane: TGLenum; const equation: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glClipPlane := TglClipPlane(glProcedure('glClipPlane'{$IFDEF CLR}, typeof(TglClipPlane){$ENDIF}));
  glClipPlane(plane, equation);
end;

procedure STUB_glColor3b(red: TGLbyte; green: TGLbyte; blue: TGLbyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor3b := TglColor3b(glProcedure('glColor3b'{$IFDEF CLR}, typeof(TglColor3b){$ENDIF}));
  glColor3b(red, green, blue);
end;

procedure STUB_glColor3bv(const v: PGLbyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor3bv := TglColor3bv(glProcedure('glColor3bv'{$IFDEF CLR}, typeof(TglColor3bv){$ENDIF}));
  glColor3bv(v);
end;

procedure STUB_glColor3d(red: TGLdouble; green: TGLdouble; blue: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor3d := TglColor3d(glProcedure('glColor3d'{$IFDEF CLR}, typeof(TglColor3d){$ENDIF}));
  glColor3d(red, green, blue);
end;

procedure STUB_glColor3dv(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor3dv := TglColor3dv(glProcedure('glColor3dv'{$IFDEF CLR}, typeof(TglColor3dv){$ENDIF}));
  glColor3dv(v);
end;

procedure STUB_glColor3f(red: TGLfloat; green: TGLfloat; blue: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor3f := TglColor3f(glProcedure('glColor3f'{$IFDEF CLR}, typeof(TglColor3f){$ENDIF}));
  glColor3f(red, green, blue);
end;

procedure STUB_glColor3fv(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor3fv := TglColor3fv(glProcedure('glColor3fv'{$IFDEF CLR}, typeof(TglColor3fv){$ENDIF}));
  glColor3fv(v);
end;

procedure STUB_glColor3i(red: TGLint; green: TGLint; blue: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor3i := TglColor3i(glProcedure('glColor3i'{$IFDEF CLR}, typeof(TglColor3i){$ENDIF}));
  glColor3i(red, green, blue);
end;

procedure STUB_glColor3iv(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor3iv := TglColor3iv(glProcedure('glColor3iv'{$IFDEF CLR}, typeof(TglColor3iv){$ENDIF}));
  glColor3iv(v);
end;

procedure STUB_glColor3s(red: TGLshort; green: TGLshort; blue: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor3s := TglColor3s(glProcedure('glColor3s'{$IFDEF CLR}, typeof(TglColor3s){$ENDIF}));
  glColor3s(red, green, blue);
end;

procedure STUB_glColor3sv(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor3sv := TglColor3sv(glProcedure('glColor3sv'{$IFDEF CLR}, typeof(TglColor3sv){$ENDIF}));
  glColor3sv(v);
end;

procedure STUB_glColor3ub(red: TGLubyte; green: TGLubyte; blue: TGLubyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor3ub := TglColor3ub(glProcedure('glColor3ub'{$IFDEF CLR}, typeof(TglColor3ub){$ENDIF}));
  glColor3ub(red, green, blue);
end;

procedure STUB_glColor3ubv(const v: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor3ubv := TglColor3ubv(glProcedure('glColor3ubv'{$IFDEF CLR}, typeof(TglColor3ubv){$ENDIF}));
  glColor3ubv(v);
end;

procedure STUB_glColor3ui(red: TGLuint; green: TGLuint; blue: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor3ui := TglColor3ui(glProcedure('glColor3ui'{$IFDEF CLR}, typeof(TglColor3ui){$ENDIF}));
  glColor3ui(red, green, blue);
end;

procedure STUB_glColor3uiv(const v: PGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor3uiv := TglColor3uiv(glProcedure('glColor3uiv'{$IFDEF CLR}, typeof(TglColor3uiv){$ENDIF}));
  glColor3uiv(v);
end;

procedure STUB_glColor3us(red: TGLushort; green: TGLushort; blue: TGLushort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor3us := TglColor3us(glProcedure('glColor3us'{$IFDEF CLR}, typeof(TglColor3us){$ENDIF}));
  glColor3us(red, green, blue);
end;

procedure STUB_glColor3usv(const v: PGLushort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor3usv := TglColor3usv(glProcedure('glColor3usv'{$IFDEF CLR}, typeof(TglColor3usv){$ENDIF}));
  glColor3usv(v);
end;

procedure STUB_glColor4b(red: TGLbyte; green: TGLbyte; blue: TGLbyte; alpha: TGLbyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor4b := TglColor4b(glProcedure('glColor4b'{$IFDEF CLR}, typeof(TglColor4b){$ENDIF}));
  glColor4b(red, green, blue, alpha);
end;

procedure STUB_glColor4bv(const v: PGLbyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor4bv := TglColor4bv(glProcedure('glColor4bv'{$IFDEF CLR}, typeof(TglColor4bv){$ENDIF}));
  glColor4bv(v);
end;

procedure STUB_glColor4d(red: TGLdouble; green: TGLdouble; blue: TGLdouble; alpha: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor4d := TglColor4d(glProcedure('glColor4d'{$IFDEF CLR}, typeof(TglColor4d){$ENDIF}));
  glColor4d(red, green, blue, alpha);
end;

procedure STUB_glColor4dv(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor4dv := TglColor4dv(glProcedure('glColor4dv'{$IFDEF CLR}, typeof(TglColor4dv){$ENDIF}));
  glColor4dv(v);
end;

procedure STUB_glColor4f(red: TGLfloat; green: TGLfloat; blue: TGLfloat; alpha: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor4f := TglColor4f(glProcedure('glColor4f'{$IFDEF CLR}, typeof(TglColor4f){$ENDIF}));
  glColor4f(red, green, blue, alpha);
end;

procedure STUB_glColor4fv(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor4fv := TglColor4fv(glProcedure('glColor4fv'{$IFDEF CLR}, typeof(TglColor4fv){$ENDIF}));
  glColor4fv(v);
end;

procedure STUB_glColor4i(red: TGLint; green: TGLint; blue: TGLint; alpha: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor4i := TglColor4i(glProcedure('glColor4i'{$IFDEF CLR}, typeof(TglColor4i){$ENDIF}));
  glColor4i(red, green, blue, alpha);
end;

procedure STUB_glColor4iv(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor4iv := TglColor4iv(glProcedure('glColor4iv'{$IFDEF CLR}, typeof(TglColor4iv){$ENDIF}));
  glColor4iv(v);
end;

procedure STUB_glColor4s(red: TGLshort; green: TGLshort; blue: TGLshort; alpha: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor4s := TglColor4s(glProcedure('glColor4s'{$IFDEF CLR}, typeof(TglColor4s){$ENDIF}));
  glColor4s(red, green, blue, alpha);
end;

procedure STUB_glColor4sv(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor4sv := TglColor4sv(glProcedure('glColor4sv'{$IFDEF CLR}, typeof(TglColor4sv){$ENDIF}));
  glColor4sv(v);
end;

procedure STUB_glColor4ub(red: TGLubyte; green: TGLubyte; blue: TGLubyte; alpha: TGLubyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor4ub := TglColor4ub(glProcedure('glColor4ub'{$IFDEF CLR}, typeof(TglColor4ub){$ENDIF}));
  glColor4ub(red, green, blue, alpha);
end;

procedure STUB_glColor4ubv(const v: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor4ubv := TglColor4ubv(glProcedure('glColor4ubv'{$IFDEF CLR}, typeof(TglColor4ubv){$ENDIF}));
  glColor4ubv(v);
end;

procedure STUB_glColor4ui(red: TGLuint; green: TGLuint; blue: TGLuint; alpha: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor4ui := TglColor4ui(glProcedure('glColor4ui'{$IFDEF CLR}, typeof(TglColor4ui){$ENDIF}));
  glColor4ui(red, green, blue, alpha);
end;

procedure STUB_glColor4uiv(const v: PGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor4uiv := TglColor4uiv(glProcedure('glColor4uiv'{$IFDEF CLR}, typeof(TglColor4uiv){$ENDIF}));
  glColor4uiv(v);
end;

procedure STUB_glColor4us(red: TGLushort; green: TGLushort; blue: TGLushort; alpha: TGLushort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor4us := TglColor4us(glProcedure('glColor4us'{$IFDEF CLR}, typeof(TglColor4us){$ENDIF}));
  glColor4us(red, green, blue, alpha);
end;

procedure STUB_glColor4usv(const v: PGLushort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColor4usv := TglColor4usv(glProcedure('glColor4usv'{$IFDEF CLR}, typeof(TglColor4usv){$ENDIF}));
  glColor4usv(v);
end;

procedure STUB_glColorMask(red: TGLboolean; green: TGLboolean; blue: TGLboolean; alpha: TGLboolean); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColorMask := TglColorMask(glProcedure('glColorMask'{$IFDEF CLR}, typeof(TglColorMask){$ENDIF}));
  glColorMask(red, green, blue, alpha);
end;

procedure STUB_glColorMaterial(face: TGLenum; mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColorMaterial := TglColorMaterial(glProcedure('glColorMaterial'{$IFDEF CLR}, typeof(TglColorMaterial){$ENDIF}));
  glColorMaterial(face, mode);
end;

procedure STUB__glColorPointer(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  _glColorPointer := TglColorPointer(glProcedure('glColorPointer'{$IFDEF CLR}, typeof(TglColorPointer){$ENDIF}));
  _glColorPointer(size, _type, stride, _pointer);
end;

procedure STUB_glCopyPixels(x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei; _type: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCopyPixels := TglCopyPixels(glProcedure('glCopyPixels'{$IFDEF CLR}, typeof(TglCopyPixels){$ENDIF}));
  glCopyPixels(x, y, width, height, _type);
end;

procedure STUB_glCopyTexImage1D(target: TGLenum; level: TGLint; internalFormat: TGLenum; x: TGLint; y: TGLint; width: TGLsizei; border: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCopyTexImage1D := TglCopyTexImage1D(glProcedure('glCopyTexImage1D'{$IFDEF CLR}, typeof(TglCopyTexImage1D){$ENDIF}));
  glCopyTexImage1D(target, level, internalFormat, x, y, width, border);
end;

procedure STUB_glCopyTexImage2D(target: TGLenum; level: TGLint; internalFormat: TGLenum; x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei; border: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCopyTexImage2D := TglCopyTexImage2D(glProcedure('glCopyTexImage2D'{$IFDEF CLR}, typeof(TglCopyTexImage2D){$ENDIF}));
  glCopyTexImage2D(target, level, internalFormat, x, y, width, height, border);
end;

procedure STUB_glCopyTexSubImage1D(target: TGLenum; level: TGLint; xoffset: TGLint; x: TGLint; y: TGLint; width: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCopyTexSubImage1D := TglCopyTexSubImage1D(glProcedure('glCopyTexSubImage1D'{$IFDEF CLR}, typeof(TglCopyTexSubImage1D){$ENDIF}));
  glCopyTexSubImage1D(target, level, xoffset, x, y, width);
end;

procedure STUB_glCopyTexSubImage2D(target: TGLenum; level: TGLint; xoffset: TGLint; yoffset: TGLint; x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCopyTexSubImage2D := TglCopyTexSubImage2D(glProcedure('glCopyTexSubImage2D'{$IFDEF CLR}, typeof(TglCopyTexSubImage2D){$ENDIF}));
  glCopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
end;

procedure STUB_glCullFace(mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCullFace := TglCullFace(glProcedure('glCullFace'{$IFDEF CLR}, typeof(TglCullFace){$ENDIF}));
  glCullFace(mode);
end;

procedure STUB_glDeleteLists(list: TGLuint; range: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDeleteLists := TglDeleteLists(glProcedure('glDeleteLists'{$IFDEF CLR}, typeof(TglDeleteLists){$ENDIF}));
  glDeleteLists(list, range);
end;

procedure STUB_glDeleteTextures(n: TGLsizei; const textures: PGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDeleteTextures := TglDeleteTextures(glProcedure('glDeleteTextures'{$IFDEF CLR}, typeof(TglDeleteTextures){$ENDIF}));
  glDeleteTextures(n, textures);
end;

procedure STUB_glDepthFunc(func: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDepthFunc := TglDepthFunc(glProcedure('glDepthFunc'{$IFDEF CLR}, typeof(TglDepthFunc){$ENDIF}));
  glDepthFunc(func);
end;

procedure STUB_glDepthMask(flag: TGLboolean); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDepthMask := TglDepthMask(glProcedure('glDepthMask'{$IFDEF CLR}, typeof(TglDepthMask){$ENDIF}));
  glDepthMask(flag);
end;

procedure STUB_glDepthRange(zNear: TGLclampd; zFar: TGLclampd); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDepthRange := TglDepthRange(glProcedure('glDepthRange'{$IFDEF CLR}, typeof(TglDepthRange){$ENDIF}));
  glDepthRange(zNear, zFar);
end;

procedure STUB_glDisable(cap: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDisable := TglDisable(glProcedure('glDisable'{$IFDEF CLR}, typeof(TglDisable){$ENDIF}));
  glDisable(cap);
end;

procedure STUB_glDisableClientState(_array: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDisableClientState := TglDisableClientState(glProcedure('glDisableClientState'{$IFDEF CLR}, typeof(TglDisableClientState){$ENDIF}));
  glDisableClientState(_array);
end;

procedure STUB_glDrawArrays(mode: TGLenum; first: TGLint; count: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDrawArrays := TglDrawArrays(glProcedure('glDrawArrays'{$IFDEF CLR}, typeof(TglDrawArrays){$ENDIF}));
  glDrawArrays(mode, first, count);
end;

procedure STUB_glDrawBuffer(mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDrawBuffer := TglDrawBuffer(glProcedure('glDrawBuffer'{$IFDEF CLR}, typeof(TglDrawBuffer){$ENDIF}));
  glDrawBuffer(mode);
end;

procedure STUB_glDrawElements(mode: TGLenum; count: TGLsizei; _type: TGLenum; const indices: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDrawElements := TglDrawElements(glProcedure('glDrawElements'{$IFDEF CLR}, typeof(TglDrawElements){$ENDIF}));
  glDrawElements(mode, count, _type, indices);
end;

procedure STUB_glDrawPixels(width: TGLsizei; height: TGLsizei; format: TGLenum; _type: TGLenum; const pixels: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDrawPixels := TglDrawPixels(glProcedure('glDrawPixels'{$IFDEF CLR}, typeof(TglDrawPixels){$ENDIF}));
  glDrawPixels(width, height, format, _type, pixels);
end;

procedure STUB_glEdgeFlag(flag: TGLboolean); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glEdgeFlag := TglEdgeFlag(glProcedure('glEdgeFlag'{$IFDEF CLR}, typeof(TglEdgeFlag){$ENDIF}));
  glEdgeFlag(flag);
end;

procedure STUB_glEdgeFlagPointer(stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glEdgeFlagPointer := TglEdgeFlagPointer(glProcedure('glEdgeFlagPointer'{$IFDEF CLR}, typeof(TglEdgeFlagPointer){$ENDIF}));
  glEdgeFlagPointer(stride, _pointer);
end;

procedure STUB_glEdgeFlagv(const flag: PGLboolean); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glEdgeFlagv := TglEdgeFlagv(glProcedure('glEdgeFlagv'{$IFDEF CLR}, typeof(TglEdgeFlagv){$ENDIF}));
  glEdgeFlagv(flag);
end;

procedure STUB_glEnable(cap: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glEnable := TglEnable(glProcedure('glEnable'{$IFDEF CLR}, typeof(TglEnable){$ENDIF}));
  glEnable(cap);
end;

procedure STUB_glEnableClientState(_array: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glEnableClientState := TglEnableClientState(glProcedure('glEnableClientState'{$IFDEF CLR}, typeof(TglEnableClientState){$ENDIF}));
  glEnableClientState(_array);
end;

procedure STUB_glEnd(); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glEnd := TglEnd(glProcedure('glEnd'{$IFDEF CLR}, typeof(TglEnd){$ENDIF}));
  glEnd();
end;

procedure STUB_glEndList(); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glEndList := TglEndList(glProcedure('glEndList'{$IFDEF CLR}, typeof(TglEndList){$ENDIF}));
  glEndList();
end;

procedure STUB_glEvalCoord1d(u: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glEvalCoord1d := TglEvalCoord1d(glProcedure('glEvalCoord1d'{$IFDEF CLR}, typeof(TglEvalCoord1d){$ENDIF}));
  glEvalCoord1d(u);
end;

procedure STUB_glEvalCoord1dv(const u: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glEvalCoord1dv := TglEvalCoord1dv(glProcedure('glEvalCoord1dv'{$IFDEF CLR}, typeof(TglEvalCoord1dv){$ENDIF}));
  glEvalCoord1dv(u);
end;

procedure STUB_glEvalCoord1f(u: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glEvalCoord1f := TglEvalCoord1f(glProcedure('glEvalCoord1f'{$IFDEF CLR}, typeof(TglEvalCoord1f){$ENDIF}));
  glEvalCoord1f(u);
end;

procedure STUB_glEvalCoord1fv(const u: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glEvalCoord1fv := TglEvalCoord1fv(glProcedure('glEvalCoord1fv'{$IFDEF CLR}, typeof(TglEvalCoord1fv){$ENDIF}));
  glEvalCoord1fv(u);
end;

procedure STUB_glEvalCoord2d(u: TGLdouble; v: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glEvalCoord2d := TglEvalCoord2d(glProcedure('glEvalCoord2d'{$IFDEF CLR}, typeof(TglEvalCoord2d){$ENDIF}));
  glEvalCoord2d(u, v);
end;

procedure STUB_glEvalCoord2dv(const u: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glEvalCoord2dv := TglEvalCoord2dv(glProcedure('glEvalCoord2dv'{$IFDEF CLR}, typeof(TglEvalCoord2dv){$ENDIF}));
  glEvalCoord2dv(u);
end;

procedure STUB_glEvalCoord2f(u: TGLfloat; v: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glEvalCoord2f := TglEvalCoord2f(glProcedure('glEvalCoord2f'{$IFDEF CLR}, typeof(TglEvalCoord2f){$ENDIF}));
  glEvalCoord2f(u, v);
end;

procedure STUB_glEvalCoord2fv(const u: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glEvalCoord2fv := TglEvalCoord2fv(glProcedure('glEvalCoord2fv'{$IFDEF CLR}, typeof(TglEvalCoord2fv){$ENDIF}));
  glEvalCoord2fv(u);
end;

procedure STUB_glEvalMesh1(mode: TGLenum; i1: TGLint; i2: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glEvalMesh1 := TglEvalMesh1(glProcedure('glEvalMesh1'{$IFDEF CLR}, typeof(TglEvalMesh1){$ENDIF}));
  glEvalMesh1(mode, i1, i2);
end;

procedure STUB_glEvalMesh2(mode: TGLenum; i1: TGLint; i2: TGLint; j1: TGLint; j2: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glEvalMesh2 := TglEvalMesh2(glProcedure('glEvalMesh2'{$IFDEF CLR}, typeof(TglEvalMesh2){$ENDIF}));
  glEvalMesh2(mode, i1, i2, j1, j2);
end;

procedure STUB_glEvalPoint1(i: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glEvalPoint1 := TglEvalPoint1(glProcedure('glEvalPoint1'{$IFDEF CLR}, typeof(TglEvalPoint1){$ENDIF}));
  glEvalPoint1(i);
end;

procedure STUB_glEvalPoint2(i: TGLint; j: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glEvalPoint2 := TglEvalPoint2(glProcedure('glEvalPoint2'{$IFDEF CLR}, typeof(TglEvalPoint2){$ENDIF}));
  glEvalPoint2(i, j);
end;

procedure STUB_glFeedbackBuffer(size: TGLsizei; _type: TGLenum; buffer: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glFeedbackBuffer := TglFeedbackBuffer(glProcedure('glFeedbackBuffer'{$IFDEF CLR}, typeof(TglFeedbackBuffer){$ENDIF}));
  glFeedbackBuffer(size, _type, buffer);
end;

procedure STUB_glFinish(); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glFinish := TglFinish(glProcedure('glFinish'{$IFDEF CLR}, typeof(TglFinish){$ENDIF}));
  glFinish();
end;

procedure STUB_glFlush(); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glFlush := TglFlush(glProcedure('glFlush'{$IFDEF CLR}, typeof(TglFlush){$ENDIF}));
  glFlush();
end;

procedure STUB_glFogf(pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glFogf := TglFogf(glProcedure('glFogf'{$IFDEF CLR}, typeof(TglFogf){$ENDIF}));
  glFogf(pname, param);
end;

procedure STUB_glFogfv(pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glFogfv := TglFogfv(glProcedure('glFogfv'{$IFDEF CLR}, typeof(TglFogfv){$ENDIF}));
  glFogfv(pname, params);
end;

procedure STUB_glFogi(pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glFogi := TglFogi(glProcedure('glFogi'{$IFDEF CLR}, typeof(TglFogi){$ENDIF}));
  glFogi(pname, param);
end;

procedure STUB_glFogiv(pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glFogiv := TglFogiv(glProcedure('glFogiv'{$IFDEF CLR}, typeof(TglFogiv){$ENDIF}));
  glFogiv(pname, params);
end;

procedure STUB_glFrontFace(mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glFrontFace := TglFrontFace(glProcedure('glFrontFace'{$IFDEF CLR}, typeof(TglFrontFace){$ENDIF}));
  glFrontFace(mode);
end;

procedure STUB_glFrustum(left: TGLdouble; right: TGLdouble; bottom: TGLdouble; top: TGLdouble; zNear: TGLdouble; zFar: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glFrustum := TglFrustum(glProcedure('glFrustum'{$IFDEF CLR}, typeof(TglFrustum){$ENDIF}));
  glFrustum(left, right, bottom, top, zNear, zFar);
end;

function STUB_glGenLists(range: TGLsizei): TGLuint; {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGenLists := TglGenLists(glProcedure('glGenLists'{$IFDEF CLR}, typeof(TglGenLists){$ENDIF}));
  result := glGenLists(range);
end;

procedure STUB_glGenTextures(n: TGLsizei; textures: PGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  _glGenTextures := TglGenTextures(glProcedure('glGenTextures'{$IFDEF CLR}, typeof(TglGenTextures){$ENDIF}));
  _glGenTextures(n, textures);
end;

procedure STUB_glGetBooleanv(pname: TGLenum; params: PGLboolean); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetBooleanv := TglGetBooleanv(glProcedure('glGetBooleanv'{$IFDEF CLR}, typeof(TglGetBooleanv){$ENDIF}));
  glGetBooleanv(pname, params);
end;

procedure STUB_glGetClipPlane(plane: TGLenum; equation: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetClipPlane := TglGetClipPlane(glProcedure('glGetClipPlane'{$IFDEF CLR}, typeof(TglGetClipPlane){$ENDIF}));
  glGetClipPlane(plane, equation);
end;

procedure STUB_glGetDoublev(pname: TGLenum; params: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetDoublev := TglGetDoublev(glProcedure('glGetDoublev'{$IFDEF CLR}, typeof(TglGetDoublev){$ENDIF}));
  glGetDoublev(pname, params);
end;

function STUB_glGetError(): TGLenum; {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetError := TglGetError(glProcedure('glGetError'{$IFDEF CLR}, typeof(TglGetError){$ENDIF}));
  result := glGetError();
end;

procedure STUB_glGetFloatv(pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetFloatv := TglGetFloatv(glProcedure('glGetFloatv'{$IFDEF CLR}, typeof(TglGetFloatv){$ENDIF}));
  glGetFloatv(pname, params);
end;

procedure STUB_glGetIntegerv(pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetIntegerv := TglGetIntegerv(glProcedure('glGetIntegerv'{$IFDEF CLR}, typeof(TglGetIntegerv){$ENDIF}));
  glGetIntegerv(pname, params);
end;

procedure STUB_glGetLightfv(light: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetLightfv := TglGetLightfv(glProcedure('glGetLightfv'{$IFDEF CLR}, typeof(TglGetLightfv){$ENDIF}));
  glGetLightfv(light, pname, params);
end;

procedure STUB_glGetLightiv(light: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetLightiv := TglGetLightiv(glProcedure('glGetLightiv'{$IFDEF CLR}, typeof(TglGetLightiv){$ENDIF}));
  glGetLightiv(light, pname, params);
end;

procedure STUB_glGetMapdv(target: TGLenum; query: TGLenum; v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetMapdv := TglGetMapdv(glProcedure('glGetMapdv'{$IFDEF CLR}, typeof(TglGetMapdv){$ENDIF}));
  glGetMapdv(target, query, v);
end;

procedure STUB_glGetMapfv(target: TGLenum; query: TGLenum; v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetMapfv := TglGetMapfv(glProcedure('glGetMapfv'{$IFDEF CLR}, typeof(TglGetMapfv){$ENDIF}));
  glGetMapfv(target, query, v);
end;

procedure STUB_glGetMapiv(target: TGLenum; query: TGLenum; v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetMapiv := TglGetMapiv(glProcedure('glGetMapiv'{$IFDEF CLR}, typeof(TglGetMapiv){$ENDIF}));
  glGetMapiv(target, query, v);
end;

procedure STUB_glGetMaterialfv(face: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetMaterialfv := TglGetMaterialfv(glProcedure('glGetMaterialfv'{$IFDEF CLR}, typeof(TglGetMaterialfv){$ENDIF}));
  glGetMaterialfv(face, pname, params);
end;

procedure STUB_glGetMaterialiv(face: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetMaterialiv := TglGetMaterialiv(glProcedure('glGetMaterialiv'{$IFDEF CLR}, typeof(TglGetMaterialiv){$ENDIF}));
  glGetMaterialiv(face, pname, params);
end;

procedure STUB_glGetPixelMapfv(map: TGLenum; values: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetPixelMapfv := TglGetPixelMapfv(glProcedure('glGetPixelMapfv'{$IFDEF CLR}, typeof(TglGetPixelMapfv){$ENDIF}));
  glGetPixelMapfv(map, values);
end;

procedure STUB_glGetPixelMapuiv(map: TGLenum; values: PGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetPixelMapuiv := TglGetPixelMapuiv(glProcedure('glGetPixelMapuiv'{$IFDEF CLR}, typeof(TglGetPixelMapuiv){$ENDIF}));
  glGetPixelMapuiv(map, values);
end;

procedure STUB_glGetPixelMapusv(map: TGLenum; values: PGLushort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetPixelMapusv := TglGetPixelMapusv(glProcedure('glGetPixelMapusv'{$IFDEF CLR}, typeof(TglGetPixelMapusv){$ENDIF}));
  glGetPixelMapusv(map, values);
end;

procedure STUB_glGetPointerv(pname: TGLenum; params: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetPointerv := TglGetPointerv(glProcedure('glGetPointerv'{$IFDEF CLR}, typeof(TglGetPointerv){$ENDIF}));
  glGetPointerv(pname, params);
end;

procedure STUB_glGetPolygonStipple(mask: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetPolygonStipple := TglGetPolygonStipple(glProcedure('glGetPolygonStipple'{$IFDEF CLR}, typeof(TglGetPolygonStipple){$ENDIF}));
  glGetPolygonStipple(mask);
end;

{$IFDEF CLR}

function STUB__glGetString(name: TGLenum): IntPtr; {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  _glGetString := TglGetString(glProcedure('glGetString'{$IFDEF CLR}, typeof(TglGetString){$ENDIF}));
  result := _glGetString(name);
end;

{$ELSE}

function STUB__glGetString(name: TGLenum): PChar; {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  _glGetString := TglGetString(glProcedure('glGetString'{$IFDEF CLR}, typeof(TglGetString){$ENDIF}));
  result := _glGetString(name);
end;

{$ENDIF}

procedure STUB_glGetTexEnvfv(target: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetTexEnvfv := TglGetTexEnvfv(glProcedure('glGetTexEnvfv'{$IFDEF CLR}, typeof(TglGetTexEnvfv){$ENDIF}));
  glGetTexEnvfv(target, pname, params);
end;

procedure STUB_glGetTexEnviv(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetTexEnviv := TglGetTexEnviv(glProcedure('glGetTexEnviv'{$IFDEF CLR}, typeof(TglGetTexEnviv){$ENDIF}));
  glGetTexEnviv(target, pname, params);
end;

procedure STUB_glGetTexGendv(coord: TGLenum; pname: TGLenum; params: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetTexGendv := TglGetTexGendv(glProcedure('glGetTexGendv'{$IFDEF CLR}, typeof(TglGetTexGendv){$ENDIF}));
  glGetTexGendv(coord, pname, params);
end;

procedure STUB_glGetTexGenfv(coord: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetTexGenfv := TglGetTexGenfv(glProcedure('glGetTexGenfv'{$IFDEF CLR}, typeof(TglGetTexGenfv){$ENDIF}));
  glGetTexGenfv(coord, pname, params);
end;

procedure STUB_glGetTexGeniv(coord: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetTexGeniv := TglGetTexGeniv(glProcedure('glGetTexGeniv'{$IFDEF CLR}, typeof(TglGetTexGeniv){$ENDIF}));
  glGetTexGeniv(coord, pname, params);
end;

procedure STUB_glGetTexImage(target: TGLenum; level: TGLint; format: TGLenum; _type: TGLenum; pixels: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetTexImage := TglGetTexImage(glProcedure('glGetTexImage'{$IFDEF CLR}, typeof(TglGetTexImage){$ENDIF}));
  glGetTexImage(target, level, format, _type, pixels);
end;

procedure STUB_glGetTexLevelParameterfv(target: TGLenum; level: TGLint; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetTexLevelParameterfv := TglGetTexLevelParameterfv(glProcedure('glGetTexLevelParameterfv'{$IFDEF CLR}, typeof(TglGetTexLevelParameterfv){$ENDIF}));
  glGetTexLevelParameterfv(target, level, pname, params);
end;

procedure STUB_glGetTexLevelParameteriv(target: TGLenum; level: TGLint; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetTexLevelParameteriv := TglGetTexLevelParameteriv(glProcedure('glGetTexLevelParameteriv'{$IFDEF CLR}, typeof(TglGetTexLevelParameteriv){$ENDIF}));
  glGetTexLevelParameteriv(target, level, pname, params);
end;

procedure STUB_glGetTexParameterfv(target: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetTexParameterfv := TglGetTexParameterfv(glProcedure('glGetTexParameterfv'{$IFDEF CLR}, typeof(TglGetTexParameterfv){$ENDIF}));
  glGetTexParameterfv(target, pname, params);
end;

procedure STUB_glGetTexParameteriv(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetTexParameteriv := TglGetTexParameteriv(glProcedure('glGetTexParameteriv'{$IFDEF CLR}, typeof(TglGetTexParameteriv){$ENDIF}));
  glGetTexParameteriv(target, pname, params);
end;

procedure STUB_glHint(target: TGLenum; mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glHint := TglHint(glProcedure('glHint'{$IFDEF CLR}, typeof(TglHint){$ENDIF}));
  glHint(target, mode);
end;

procedure STUB_glIndexMask(mask: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glIndexMask := TglIndexMask(glProcedure('glIndexMask'{$IFDEF CLR}, typeof(TglIndexMask){$ENDIF}));
  glIndexMask(mask);
end;

procedure STUB_glIndexPointer(_type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glIndexPointer := TglIndexPointer(glProcedure('glIndexPointer'{$IFDEF CLR}, typeof(TglIndexPointer){$ENDIF}));
  glIndexPointer(_type, stride, _pointer);
end;

procedure STUB_glIndexd(c: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glIndexd := TglIndexd(glProcedure('glIndexd'{$IFDEF CLR}, typeof(TglIndexd){$ENDIF}));
  glIndexd(c);
end;

procedure STUB_glIndexdv(const c: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glIndexdv := TglIndexdv(glProcedure('glIndexdv'{$IFDEF CLR}, typeof(TglIndexdv){$ENDIF}));
  glIndexdv(c);
end;

procedure STUB_glIndexf(c: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glIndexf := TglIndexf(glProcedure('glIndexf'{$IFDEF CLR}, typeof(TglIndexf){$ENDIF}));
  glIndexf(c);
end;

procedure STUB_glIndexfv(const c: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glIndexfv := TglIndexfv(glProcedure('glIndexfv'{$IFDEF CLR}, typeof(TglIndexfv){$ENDIF}));
  glIndexfv(c);
end;

procedure STUB_glIndexi(c: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glIndexi := TglIndexi(glProcedure('glIndexi'{$IFDEF CLR}, typeof(TglIndexi){$ENDIF}));
  glIndexi(c);
end;

procedure STUB_glIndexiv(const c: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glIndexiv := TglIndexiv(glProcedure('glIndexiv'{$IFDEF CLR}, typeof(TglIndexiv){$ENDIF}));
  glIndexiv(c);
end;

procedure STUB_glIndexs(c: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glIndexs := TglIndexs(glProcedure('glIndexs'{$IFDEF CLR}, typeof(TglIndexs){$ENDIF}));
  glIndexs(c);
end;

procedure STUB_glIndexsv(const c: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glIndexsv := TglIndexsv(glProcedure('glIndexsv'{$IFDEF CLR}, typeof(TglIndexsv){$ENDIF}));
  glIndexsv(c);
end;

procedure STUB_glIndexub(c: TGLubyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glIndexub := TglIndexub(glProcedure('glIndexub'{$IFDEF CLR}, typeof(TglIndexub){$ENDIF}));
  glIndexub(c);
end;

procedure STUB_glIndexubv(const c: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glIndexubv := TglIndexubv(glProcedure('glIndexubv'{$IFDEF CLR}, typeof(TglIndexubv){$ENDIF}));
  glIndexubv(c);
end;

procedure STUB_glInitNames(); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glInitNames := TglInitNames(glProcedure('glInitNames'{$IFDEF CLR}, typeof(TglInitNames){$ENDIF}));
  glInitNames();
end;

procedure STUB_glInterleavedArrays(format: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glInterleavedArrays := TglInterleavedArrays(glProcedure('glInterleavedArrays'{$IFDEF CLR}, typeof(TglInterleavedArrays){$ENDIF}));
  glInterleavedArrays(format, stride, _pointer);
end;

function STUB_glIsEnabled(cap: TGLenum): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glIsEnabled := TglIsEnabled(glProcedure('glIsEnabled'{$IFDEF CLR}, typeof(TglIsEnabled){$ENDIF}));
  result := glIsEnabled(cap);
end;

function STUB_glIsList(list: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glIsList := TglIsList(glProcedure('glIsList'{$IFDEF CLR}, typeof(TglIsList){$ENDIF}));
  result := glIsList(list);
end;

function STUB_glIsTexture(texture: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glIsTexture := TglIsTexture(glProcedure('glIsTexture'{$IFDEF CLR}, typeof(TglIsTexture){$ENDIF}));
  result := glIsTexture(texture);
end;

procedure STUB_glLightModelf(pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glLightModelf := TglLightModelf(glProcedure('glLightModelf'{$IFDEF CLR}, typeof(TglLightModelf){$ENDIF}));
  glLightModelf(pname, param);
end;

procedure STUB_glLightModelfv(pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glLightModelfv := TglLightModelfv(glProcedure('glLightModelfv'{$IFDEF CLR}, typeof(TglLightModelfv){$ENDIF}));
  glLightModelfv(pname, params);
end;

procedure STUB_glLightModeli(pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glLightModeli := TglLightModeli(glProcedure('glLightModeli'{$IFDEF CLR}, typeof(TglLightModeli){$ENDIF}));
  glLightModeli(pname, param);
end;

procedure STUB_glLightModeliv(pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glLightModeliv := TglLightModeliv(glProcedure('glLightModeliv'{$IFDEF CLR}, typeof(TglLightModeliv){$ENDIF}));
  glLightModeliv(pname, params);
end;

procedure STUB_glLightf(light: TGLenum; pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glLightf := TglLightf(glProcedure('glLightf'{$IFDEF CLR}, typeof(TglLightf){$ENDIF}));
  glLightf(light, pname, param);
end;

procedure STUB_glLightfv(light: TGLenum; pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glLightfv := TglLightfv(glProcedure('glLightfv'{$IFDEF CLR}, typeof(TglLightfv){$ENDIF}));
  glLightfv(light, pname, params);
end;

procedure STUB_glLighti(light: TGLenum; pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glLighti := TglLighti(glProcedure('glLighti'{$IFDEF CLR}, typeof(TglLighti){$ENDIF}));
  glLighti(light, pname, param);
end;

procedure STUB_glLightiv(light: TGLenum; pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glLightiv := TglLightiv(glProcedure('glLightiv'{$IFDEF CLR}, typeof(TglLightiv){$ENDIF}));
  glLightiv(light, pname, params);
end;

procedure STUB_glLineStipple(factor: TGLint; pattern: TGLushort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glLineStipple := TglLineStipple(glProcedure('glLineStipple'{$IFDEF CLR}, typeof(TglLineStipple){$ENDIF}));
  glLineStipple(factor, pattern);
end;

procedure STUB_glLineWidth(width: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glLineWidth := TglLineWidth(glProcedure('glLineWidth'{$IFDEF CLR}, typeof(TglLineWidth){$ENDIF}));
  glLineWidth(width);
end;

procedure STUB_glListBase(base: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glListBase := TglListBase(glProcedure('glListBase'{$IFDEF CLR}, typeof(TglListBase){$ENDIF}));
  glListBase(base);
end;

procedure STUB_glLoadIdentity(); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glLoadIdentity := TglLoadIdentity(glProcedure('glLoadIdentity'{$IFDEF CLR}, typeof(TglLoadIdentity){$ENDIF}));
  glLoadIdentity();
end;

procedure STUB_glLoadMatrixd(const m: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glLoadMatrixd := TglLoadMatrixd(glProcedure('glLoadMatrixd'{$IFDEF CLR}, typeof(TglLoadMatrixd){$ENDIF}));
  glLoadMatrixd(m);
end;

procedure STUB_glLoadMatrixf(const m: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glLoadMatrixf := TglLoadMatrixf(glProcedure('glLoadMatrixf'{$IFDEF CLR}, typeof(TglLoadMatrixf){$ENDIF}));
  glLoadMatrixf(m);
end;

procedure STUB_glLoadName(name: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glLoadName := TglLoadName(glProcedure('glLoadName'{$IFDEF CLR}, typeof(TglLoadName){$ENDIF}));
  glLoadName(name);
end;

procedure STUB_glLogicOp(opcode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glLogicOp := TglLogicOp(glProcedure('glLogicOp'{$IFDEF CLR}, typeof(TglLogicOp){$ENDIF}));
  glLogicOp(opcode);
end;

procedure STUB_glMap1d(target: TGLenum; u1: TGLdouble; u2: TGLdouble; stride: TGLint; order: TGLint; const points: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMap1d := TglMap1d(glProcedure('glMap1d'{$IFDEF CLR}, typeof(TglMap1d){$ENDIF}));
  glMap1d(target, u1, u2, stride, order, points);
end;

procedure STUB_glMap1f(target: TGLenum; u1: TGLfloat; u2: TGLfloat; stride: TGLint; order: TGLint; const points: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMap1f := TglMap1f(glProcedure('glMap1f'{$IFDEF CLR}, typeof(TglMap1f){$ENDIF}));
  glMap1f(target, u1, u2, stride, order, points);
end;

procedure STUB_glMap2d(target: TGLenum; u1: TGLdouble; u2: TGLdouble; ustride: TGLint; uorder: TGLint; v1: TGLdouble; v2: TGLdouble; vstride: TGLint; vorder: TGLint; const points: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMap2d := TglMap2d(glProcedure('glMap2d'{$IFDEF CLR}, typeof(TglMap2d){$ENDIF}));
  glMap2d(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
end;

procedure STUB_glMap2f(target: TGLenum; u1: TGLfloat; u2: TGLfloat; ustride: TGLint; uorder: TGLint; v1: TGLfloat; v2: TGLfloat; vstride: TGLint; vorder: TGLint; const points: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMap2f := TglMap2f(glProcedure('glMap2f'{$IFDEF CLR}, typeof(TglMap2f){$ENDIF}));
  glMap2f(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
end;

procedure STUB_glMapGrid1d(un: TGLint; u1: TGLdouble; u2: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMapGrid1d := TglMapGrid1d(glProcedure('glMapGrid1d'{$IFDEF CLR}, typeof(TglMapGrid1d){$ENDIF}));
  glMapGrid1d(un, u1, u2);
end;

procedure STUB_glMapGrid1f(un: TGLint; u1: TGLfloat; u2: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMapGrid1f := TglMapGrid1f(glProcedure('glMapGrid1f'{$IFDEF CLR}, typeof(TglMapGrid1f){$ENDIF}));
  glMapGrid1f(un, u1, u2);
end;

procedure STUB_glMapGrid2d(un: TGLint; u1: TGLdouble; u2: TGLdouble; vn: TGLint; v1: TGLdouble; v2: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMapGrid2d := TglMapGrid2d(glProcedure('glMapGrid2d'{$IFDEF CLR}, typeof(TglMapGrid2d){$ENDIF}));
  glMapGrid2d(un, u1, u2, vn, v1, v2);
end;

procedure STUB_glMapGrid2f(un: TGLint; u1: TGLfloat; u2: TGLfloat; vn: TGLint; v1: TGLfloat; v2: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMapGrid2f := TglMapGrid2f(glProcedure('glMapGrid2f'{$IFDEF CLR}, typeof(TglMapGrid2f){$ENDIF}));
  glMapGrid2f(un, u1, u2, vn, v1, v2);
end;

procedure STUB_glMaterialf(face: TGLenum; pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMaterialf := TglMaterialf(glProcedure('glMaterialf'{$IFDEF CLR}, typeof(TglMaterialf){$ENDIF}));
  glMaterialf(face, pname, param);
end;

procedure STUB_glMaterialfv(face: TGLenum; pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMaterialfv := TglMaterialfv(glProcedure('glMaterialfv'{$IFDEF CLR}, typeof(TglMaterialfv){$ENDIF}));
  glMaterialfv(face, pname, params);
end;

procedure STUB_glMateriali(face: TGLenum; pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMateriali := TglMateriali(glProcedure('glMateriali'{$IFDEF CLR}, typeof(TglMateriali){$ENDIF}));
  glMateriali(face, pname, param);
end;

procedure STUB_glMaterialiv(face: TGLenum; pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMaterialiv := TglMaterialiv(glProcedure('glMaterialiv'{$IFDEF CLR}, typeof(TglMaterialiv){$ENDIF}));
  glMaterialiv(face, pname, params);
end;

procedure STUB_glMatrixMode(mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMatrixMode := TglMatrixMode(glProcedure('glMatrixMode'{$IFDEF CLR}, typeof(TglMatrixMode){$ENDIF}));
  glMatrixMode(mode);
end;

procedure STUB_glMultMatrixd(const m: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultMatrixd := TglMultMatrixd(glProcedure('glMultMatrixd'{$IFDEF CLR}, typeof(TglMultMatrixd){$ENDIF}));
  glMultMatrixd(m);
end;

procedure STUB_glMultMatrixf(const m: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultMatrixf := TglMultMatrixf(glProcedure('glMultMatrixf'{$IFDEF CLR}, typeof(TglMultMatrixf){$ENDIF}));
  glMultMatrixf(m);
end;

procedure STUB_glNewList(list: TGLuint; mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glNewList := TglNewList(glProcedure('glNewList'{$IFDEF CLR}, typeof(TglNewList){$ENDIF}));
  glNewList(list, mode);
end;

procedure STUB_glNormal3b(nx: TGLbyte; ny: TGLbyte; nz: TGLbyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glNormal3b := TglNormal3b(glProcedure('glNormal3b'{$IFDEF CLR}, typeof(TglNormal3b){$ENDIF}));
  glNormal3b(nx, ny, nz);
end;

procedure STUB_glNormal3bv(const v: PGLbyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glNormal3bv := TglNormal3bv(glProcedure('glNormal3bv'{$IFDEF CLR}, typeof(TglNormal3bv){$ENDIF}));
  glNormal3bv(v);
end;

procedure STUB_glNormal3d(nx: TGLdouble; ny: TGLdouble; nz: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glNormal3d := TglNormal3d(glProcedure('glNormal3d'{$IFDEF CLR}, typeof(TglNormal3d){$ENDIF}));
  glNormal3d(nx, ny, nz);
end;

procedure STUB_glNormal3dv(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glNormal3dv := TglNormal3dv(glProcedure('glNormal3dv'{$IFDEF CLR}, typeof(TglNormal3dv){$ENDIF}));
  glNormal3dv(v);
end;

procedure STUB_glNormal3f(nx: TGLfloat; ny: TGLfloat; nz: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glNormal3f := TglNormal3f(glProcedure('glNormal3f'{$IFDEF CLR}, typeof(TglNormal3f){$ENDIF}));
  glNormal3f(nx, ny, nz);
end;

procedure STUB_glNormal3fv(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glNormal3fv := TglNormal3fv(glProcedure('glNormal3fv'{$IFDEF CLR}, typeof(TglNormal3fv){$ENDIF}));
  glNormal3fv(v);
end;

procedure STUB_glNormal3i(nx: TGLint; ny: TGLint; nz: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glNormal3i := TglNormal3i(glProcedure('glNormal3i'{$IFDEF CLR}, typeof(TglNormal3i){$ENDIF}));
  glNormal3i(nx, ny, nz);
end;

procedure STUB_glNormal3iv(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glNormal3iv := TglNormal3iv(glProcedure('glNormal3iv'{$IFDEF CLR}, typeof(TglNormal3iv){$ENDIF}));
  glNormal3iv(v);
end;

procedure STUB_glNormal3s(nx: TGLshort; ny: TGLshort; nz: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glNormal3s := TglNormal3s(glProcedure('glNormal3s'{$IFDEF CLR}, typeof(TglNormal3s){$ENDIF}));
  glNormal3s(nx, ny, nz);
end;

procedure STUB_glNormal3sv(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glNormal3sv := TglNormal3sv(glProcedure('glNormal3sv'{$IFDEF CLR}, typeof(TglNormal3sv){$ENDIF}));
  glNormal3sv(v);
end;

procedure STUB_glNormalPointer(_type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  _glNormalPointer := TglNormalPointer(glProcedure('glNormalPointer'{$IFDEF CLR}, typeof(TglNormalPointer){$ENDIF}));
  _glNormalPointer(_type, stride, _pointer);
end;

procedure STUB_glOrtho(left: TGLdouble; right: TGLdouble; bottom: TGLdouble; top: TGLdouble; zNear: TGLdouble; zFar: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glOrtho := TglOrtho(glProcedure('glOrtho'{$IFDEF CLR}, typeof(TglOrtho){$ENDIF}));
  glOrtho(left, right, bottom, top, zNear, zFar);
end;

procedure STUB_glPassThrough(token: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPassThrough := TglPassThrough(glProcedure('glPassThrough'{$IFDEF CLR}, typeof(TglPassThrough){$ENDIF}));
  glPassThrough(token);
end;

procedure STUB_glPixelMapfv(map: TGLenum; mapsize: TGLsizei; const values: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPixelMapfv := TglPixelMapfv(glProcedure('glPixelMapfv'{$IFDEF CLR}, typeof(TglPixelMapfv){$ENDIF}));
  glPixelMapfv(map, mapsize, values);
end;

procedure STUB_glPixelMapuiv(map: TGLenum; mapsize: TGLsizei; const values: PGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPixelMapuiv := TglPixelMapuiv(glProcedure('glPixelMapuiv'{$IFDEF CLR}, typeof(TglPixelMapuiv){$ENDIF}));
  glPixelMapuiv(map, mapsize, values);
end;

procedure STUB_glPixelMapusv(map: TGLenum; mapsize: TGLsizei; const values: PGLushort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPixelMapusv := TglPixelMapusv(glProcedure('glPixelMapusv'{$IFDEF CLR}, typeof(TglPixelMapusv){$ENDIF}));
  glPixelMapusv(map, mapsize, values);
end;

procedure STUB_glPixelStoref(pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPixelStoref := TglPixelStoref(glProcedure('glPixelStoref'{$IFDEF CLR}, typeof(TglPixelStoref){$ENDIF}));
  glPixelStoref(pname, param);
end;

procedure STUB_glPixelStorei(pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPixelStorei := TglPixelStorei(glProcedure('glPixelStorei'{$IFDEF CLR}, typeof(TglPixelStorei){$ENDIF}));
  glPixelStorei(pname, param);
end;

procedure STUB_glPixelTransferf(pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPixelTransferf := TglPixelTransferf(glProcedure('glPixelTransferf'{$IFDEF CLR}, typeof(TglPixelTransferf){$ENDIF}));
  glPixelTransferf(pname, param);
end;

procedure STUB_glPixelTransferi(pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPixelTransferi := TglPixelTransferi(glProcedure('glPixelTransferi'{$IFDEF CLR}, typeof(TglPixelTransferi){$ENDIF}));
  glPixelTransferi(pname, param);
end;

procedure STUB_glPixelZoom(xfactor: TGLfloat; yfactor: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPixelZoom := TglPixelZoom(glProcedure('glPixelZoom'{$IFDEF CLR}, typeof(TglPixelZoom){$ENDIF}));
  glPixelZoom(xfactor, yfactor);
end;

procedure STUB_glPointSize(size: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPointSize := TglPointSize(glProcedure('glPointSize'{$IFDEF CLR}, typeof(TglPointSize){$ENDIF}));
  glPointSize(size);
end;

procedure STUB_glPolygonMode(face: TGLenum; mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPolygonMode := TglPolygonMode(glProcedure('glPolygonMode'{$IFDEF CLR}, typeof(TglPolygonMode){$ENDIF}));
  glPolygonMode(face, mode);
end;

procedure STUB_glPolygonOffset(factor: TGLfloat; units: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPolygonOffset := TglPolygonOffset(glProcedure('glPolygonOffset'{$IFDEF CLR}, typeof(TglPolygonOffset){$ENDIF}));
  glPolygonOffset(factor, units);
end;

procedure STUB_glPolygonStipple(const mask: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPolygonStipple := TglPolygonStipple(glProcedure('glPolygonStipple'{$IFDEF CLR}, typeof(TglPolygonStipple){$ENDIF}));
  glPolygonStipple(mask);
end;

procedure STUB_glPopAttrib(); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPopAttrib := TglPopAttrib(glProcedure('glPopAttrib'{$IFDEF CLR}, typeof(TglPopAttrib){$ENDIF}));
  glPopAttrib();
end;

procedure STUB_glPopClientAttrib(); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPopClientAttrib := TglPopClientAttrib(glProcedure('glPopClientAttrib'{$IFDEF CLR}, typeof(TglPopClientAttrib){$ENDIF}));
  glPopClientAttrib();
end;

procedure STUB_glPopMatrix(); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPopMatrix := TglPopMatrix(glProcedure('glPopMatrix'{$IFDEF CLR}, typeof(TglPopMatrix){$ENDIF}));
  glPopMatrix();
end;

procedure STUB_glPopName(); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPopName := TglPopName(glProcedure('glPopName'{$IFDEF CLR}, typeof(TglPopName){$ENDIF}));
  glPopName();
end;

procedure STUB_glPrioritizeTextures(n: TGLsizei; const textures: PGLuint; const priorities: PGLclampf); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPrioritizeTextures := TglPrioritizeTextures(glProcedure('glPrioritizeTextures'{$IFDEF CLR}, typeof(TglPrioritizeTextures){$ENDIF}));
  glPrioritizeTextures(n, textures, priorities);
end;

procedure STUB_glPushAttrib(mask: TGLbitfield); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPushAttrib := TglPushAttrib(glProcedure('glPushAttrib'{$IFDEF CLR}, typeof(TglPushAttrib){$ENDIF}));
  glPushAttrib(mask);
end;

procedure STUB_glPushClientAttrib(mask: TGLbitfield); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPushClientAttrib := TglPushClientAttrib(glProcedure('glPushClientAttrib'{$IFDEF CLR}, typeof(TglPushClientAttrib){$ENDIF}));
  glPushClientAttrib(mask);
end;

procedure STUB_glPushMatrix(); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPushMatrix := TglPushMatrix(glProcedure('glPushMatrix'{$IFDEF CLR}, typeof(TglPushMatrix){$ENDIF}));
  glPushMatrix();
end;

procedure STUB_glPushName(name: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPushName := TglPushName(glProcedure('glPushName'{$IFDEF CLR}, typeof(TglPushName){$ENDIF}));
  glPushName(name);
end;

procedure STUB_glRasterPos2d(x: TGLdouble; y: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRasterPos2d := TglRasterPos2d(glProcedure('glRasterPos2d'{$IFDEF CLR}, typeof(TglRasterPos2d){$ENDIF}));
  glRasterPos2d(x, y);
end;

procedure STUB_glRasterPos2dv(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRasterPos2dv := TglRasterPos2dv(glProcedure('glRasterPos2dv'{$IFDEF CLR}, typeof(TglRasterPos2dv){$ENDIF}));
  glRasterPos2dv(v);
end;

procedure STUB_glRasterPos2f(x: TGLfloat; y: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRasterPos2f := TglRasterPos2f(glProcedure('glRasterPos2f'{$IFDEF CLR}, typeof(TglRasterPos2f){$ENDIF}));
  glRasterPos2f(x, y);
end;

procedure STUB_glRasterPos2fv(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRasterPos2fv := TglRasterPos2fv(glProcedure('glRasterPos2fv'{$IFDEF CLR}, typeof(TglRasterPos2fv){$ENDIF}));
  glRasterPos2fv(v);
end;

procedure STUB_glRasterPos2i(x: TGLint; y: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRasterPos2i := TglRasterPos2i(glProcedure('glRasterPos2i'{$IFDEF CLR}, typeof(TglRasterPos2i){$ENDIF}));
  glRasterPos2i(x, y);
end;

procedure STUB_glRasterPos2iv(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRasterPos2iv := TglRasterPos2iv(glProcedure('glRasterPos2iv'{$IFDEF CLR}, typeof(TglRasterPos2iv){$ENDIF}));
  glRasterPos2iv(v);
end;

procedure STUB_glRasterPos2s(x: TGLshort; y: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRasterPos2s := TglRasterPos2s(glProcedure('glRasterPos2s'{$IFDEF CLR}, typeof(TglRasterPos2s){$ENDIF}));
  glRasterPos2s(x, y);
end;

procedure STUB_glRasterPos2sv(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRasterPos2sv := TglRasterPos2sv(glProcedure('glRasterPos2sv'{$IFDEF CLR}, typeof(TglRasterPos2sv){$ENDIF}));
  glRasterPos2sv(v);
end;

procedure STUB_glRasterPos3d(x: TGLdouble; y: TGLdouble; z: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRasterPos3d := TglRasterPos3d(glProcedure('glRasterPos3d'{$IFDEF CLR}, typeof(TglRasterPos3d){$ENDIF}));
  glRasterPos3d(x, y, z);
end;

procedure STUB_glRasterPos3dv(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRasterPos3dv := TglRasterPos3dv(glProcedure('glRasterPos3dv'{$IFDEF CLR}, typeof(TglRasterPos3dv){$ENDIF}));
  glRasterPos3dv(v);
end;

procedure STUB_glRasterPos3f(x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRasterPos3f := TglRasterPos3f(glProcedure('glRasterPos3f'{$IFDEF CLR}, typeof(TglRasterPos3f){$ENDIF}));
  glRasterPos3f(x, y, z);
end;

procedure STUB_glRasterPos3fv(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRasterPos3fv := TglRasterPos3fv(glProcedure('glRasterPos3fv'{$IFDEF CLR}, typeof(TglRasterPos3fv){$ENDIF}));
  glRasterPos3fv(v);
end;

procedure STUB_glRasterPos3i(x: TGLint; y: TGLint; z: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRasterPos3i := TglRasterPos3i(glProcedure('glRasterPos3i'{$IFDEF CLR}, typeof(TglRasterPos3i){$ENDIF}));
  glRasterPos3i(x, y, z);
end;

procedure STUB_glRasterPos3iv(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRasterPos3iv := TglRasterPos3iv(glProcedure('glRasterPos3iv'{$IFDEF CLR}, typeof(TglRasterPos3iv){$ENDIF}));
  glRasterPos3iv(v);
end;

procedure STUB_glRasterPos3s(x: TGLshort; y: TGLshort; z: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRasterPos3s := TglRasterPos3s(glProcedure('glRasterPos3s'{$IFDEF CLR}, typeof(TglRasterPos3s){$ENDIF}));
  glRasterPos3s(x, y, z);
end;

procedure STUB_glRasterPos3sv(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRasterPos3sv := TglRasterPos3sv(glProcedure('glRasterPos3sv'{$IFDEF CLR}, typeof(TglRasterPos3sv){$ENDIF}));
  glRasterPos3sv(v);
end;

procedure STUB_glRasterPos4d(x: TGLdouble; y: TGLdouble; z: TGLdouble; w: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRasterPos4d := TglRasterPos4d(glProcedure('glRasterPos4d'{$IFDEF CLR}, typeof(TglRasterPos4d){$ENDIF}));
  glRasterPos4d(x, y, z, w);
end;

procedure STUB_glRasterPos4dv(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRasterPos4dv := TglRasterPos4dv(glProcedure('glRasterPos4dv'{$IFDEF CLR}, typeof(TglRasterPos4dv){$ENDIF}));
  glRasterPos4dv(v);
end;

procedure STUB_glRasterPos4f(x: TGLfloat; y: TGLfloat; z: TGLfloat; w: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRasterPos4f := TglRasterPos4f(glProcedure('glRasterPos4f'{$IFDEF CLR}, typeof(TglRasterPos4f){$ENDIF}));
  glRasterPos4f(x, y, z, w);
end;

procedure STUB_glRasterPos4fv(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRasterPos4fv := TglRasterPos4fv(glProcedure('glRasterPos4fv'{$IFDEF CLR}, typeof(TglRasterPos4fv){$ENDIF}));
  glRasterPos4fv(v);
end;

procedure STUB_glRasterPos4i(x: TGLint; y: TGLint; z: TGLint; w: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRasterPos4i := TglRasterPos4i(glProcedure('glRasterPos4i'{$IFDEF CLR}, typeof(TglRasterPos4i){$ENDIF}));
  glRasterPos4i(x, y, z, w);
end;

procedure STUB_glRasterPos4iv(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRasterPos4iv := TglRasterPos4iv(glProcedure('glRasterPos4iv'{$IFDEF CLR}, typeof(TglRasterPos4iv){$ENDIF}));
  glRasterPos4iv(v);
end;

procedure STUB_glRasterPos4s(x: TGLshort; y: TGLshort; z: TGLshort; w: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRasterPos4s := TglRasterPos4s(glProcedure('glRasterPos4s'{$IFDEF CLR}, typeof(TglRasterPos4s){$ENDIF}));
  glRasterPos4s(x, y, z, w);
end;

procedure STUB_glRasterPos4sv(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRasterPos4sv := TglRasterPos4sv(glProcedure('glRasterPos4sv'{$IFDEF CLR}, typeof(TglRasterPos4sv){$ENDIF}));
  glRasterPos4sv(v);
end;

procedure STUB_glReadBuffer(mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glReadBuffer := TglReadBuffer(glProcedure('glReadBuffer'{$IFDEF CLR}, typeof(TglReadBuffer){$ENDIF}));
  glReadBuffer(mode);
end;

procedure STUB_glReadPixels(x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei; format: TGLenum; _type: TGLenum; pixels: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  _glReadPixels := TglReadPixels(glProcedure('glReadPixels'{$IFDEF CLR}, typeof(TglReadPixels){$ENDIF}));
  _glReadPixels(x, y, width, height, format, _type, pixels);
end;

procedure STUB_glRectd(x1: TGLdouble; y1: TGLdouble; x2: TGLdouble; y2: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRectd := TglRectd(glProcedure('glRectd'{$IFDEF CLR}, typeof(TglRectd){$ENDIF}));
  glRectd(x1, y1, x2, y2);
end;

procedure STUB_glRectdv(const v1: PGLdouble; const v2: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRectdv := TglRectdv(glProcedure('glRectdv'{$IFDEF CLR}, typeof(TglRectdv){$ENDIF}));
  glRectdv(v1, v2);
end;

procedure STUB_glRectf(x1: TGLfloat; y1: TGLfloat; x2: TGLfloat; y2: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRectf := TglRectf(glProcedure('glRectf'{$IFDEF CLR}, typeof(TglRectf){$ENDIF}));
  glRectf(x1, y1, x2, y2);
end;

procedure STUB_glRectfv(const v1: PGLfloat; const v2: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRectfv := TglRectfv(glProcedure('glRectfv'{$IFDEF CLR}, typeof(TglRectfv){$ENDIF}));
  glRectfv(v1, v2);
end;

procedure STUB_glRecti(x1: TGLint; y1: TGLint; x2: TGLint; y2: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRecti := TglRecti(glProcedure('glRecti'{$IFDEF CLR}, typeof(TglRecti){$ENDIF}));
  glRecti(x1, y1, x2, y2);
end;

procedure STUB_glRectiv(const v1: PGLint; const v2: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRectiv := TglRectiv(glProcedure('glRectiv'{$IFDEF CLR}, typeof(TglRectiv){$ENDIF}));
  glRectiv(v1, v2);
end;

procedure STUB_glRects(x1: TGLshort; y1: TGLshort; x2: TGLshort; y2: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRects := TglRects(glProcedure('glRects'{$IFDEF CLR}, typeof(TglRects){$ENDIF}));
  glRects(x1, y1, x2, y2);
end;

procedure STUB_glRectsv(const v1: PGLshort; const v2: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRectsv := TglRectsv(glProcedure('glRectsv'{$IFDEF CLR}, typeof(TglRectsv){$ENDIF}));
  glRectsv(v1, v2);
end;

function STUB_glRenderMode(mode: TGLenum): TGLint; {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRenderMode := TglRenderMode(glProcedure('glRenderMode'{$IFDEF CLR}, typeof(TglRenderMode){$ENDIF}));
  result := glRenderMode(mode);
end;

procedure STUB_glRotated(angle: TGLdouble; x: TGLdouble; y: TGLdouble; z: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRotated := TglRotated(glProcedure('glRotated'{$IFDEF CLR}, typeof(TglRotated){$ENDIF}));
  glRotated(angle, x, y, z);
end;

procedure STUB_glRotatef(angle: TGLfloat; x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glRotatef := TglRotatef(glProcedure('glRotatef'{$IFDEF CLR}, typeof(TglRotatef){$ENDIF}));
  glRotatef(angle, x, y, z);
end;

procedure STUB_glScaled(x: TGLdouble; y: TGLdouble; z: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glScaled := TglScaled(glProcedure('glScaled'{$IFDEF CLR}, typeof(TglScaled){$ENDIF}));
  glScaled(x, y, z);
end;

procedure STUB_glScalef(x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glScalef := TglScalef(glProcedure('glScalef'{$IFDEF CLR}, typeof(TglScalef){$ENDIF}));
  glScalef(x, y, z);
end;

procedure STUB_glScissor(x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glScissor := TglScissor(glProcedure('glScissor'{$IFDEF CLR}, typeof(TglScissor){$ENDIF}));
  glScissor(x, y, width, height);
end;

procedure STUB_glSelectBuffer(size: TGLsizei; buffer: PGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glSelectBuffer := TglSelectBuffer(glProcedure('glSelectBuffer'{$IFDEF CLR}, typeof(TglSelectBuffer){$ENDIF}));
  glSelectBuffer(size, buffer);
end;

procedure STUB_glShadeModel(mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glShadeModel := TglShadeModel(glProcedure('glShadeModel'{$IFDEF CLR}, typeof(TglShadeModel){$ENDIF}));
  glShadeModel(mode);
end;

procedure STUB_glStencilFunc(func: TGLenum; ref: TGLint; mask: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glStencilFunc := TglStencilFunc(glProcedure('glStencilFunc'{$IFDEF CLR}, typeof(TglStencilFunc){$ENDIF}));
  glStencilFunc(func, ref, mask);
end;

procedure STUB_glStencilMask(mask: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glStencilMask := TglStencilMask(glProcedure('glStencilMask'{$IFDEF CLR}, typeof(TglStencilMask){$ENDIF}));
  glStencilMask(mask);
end;

procedure STUB_glStencilOp(fail: TGLenum; zfail: TGLenum; zpass: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glStencilOp := TglStencilOp(glProcedure('glStencilOp'{$IFDEF CLR}, typeof(TglStencilOp){$ENDIF}));
  glStencilOp(fail, zfail, zpass);
end;

procedure STUB_glTexCoord1d(s: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord1d := TglTexCoord1d(glProcedure('glTexCoord1d'{$IFDEF CLR}, typeof(TglTexCoord1d){$ENDIF}));
  glTexCoord1d(s);
end;

procedure STUB_glTexCoord1dv(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord1dv := TglTexCoord1dv(glProcedure('glTexCoord1dv'{$IFDEF CLR}, typeof(TglTexCoord1dv){$ENDIF}));
  glTexCoord1dv(v);
end;

procedure STUB_glTexCoord1f(s: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord1f := TglTexCoord1f(glProcedure('glTexCoord1f'{$IFDEF CLR}, typeof(TglTexCoord1f){$ENDIF}));
  glTexCoord1f(s);
end;

procedure STUB_glTexCoord1fv(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord1fv := TglTexCoord1fv(glProcedure('glTexCoord1fv'{$IFDEF CLR}, typeof(TglTexCoord1fv){$ENDIF}));
  glTexCoord1fv(v);
end;

procedure STUB_glTexCoord1i(s: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord1i := TglTexCoord1i(glProcedure('glTexCoord1i'{$IFDEF CLR}, typeof(TglTexCoord1i){$ENDIF}));
  glTexCoord1i(s);
end;

procedure STUB_glTexCoord1iv(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord1iv := TglTexCoord1iv(glProcedure('glTexCoord1iv'{$IFDEF CLR}, typeof(TglTexCoord1iv){$ENDIF}));
  glTexCoord1iv(v);
end;

procedure STUB_glTexCoord1s(s: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord1s := TglTexCoord1s(glProcedure('glTexCoord1s'{$IFDEF CLR}, typeof(TglTexCoord1s){$ENDIF}));
  glTexCoord1s(s);
end;

procedure STUB_glTexCoord1sv(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord1sv := TglTexCoord1sv(glProcedure('glTexCoord1sv'{$IFDEF CLR}, typeof(TglTexCoord1sv){$ENDIF}));
  glTexCoord1sv(v);
end;

procedure STUB_glTexCoord2d(s: TGLdouble; t: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord2d := TglTexCoord2d(glProcedure('glTexCoord2d'{$IFDEF CLR}, typeof(TglTexCoord2d){$ENDIF}));
  glTexCoord2d(s, t);
end;

procedure STUB_glTexCoord2dv(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord2dv := TglTexCoord2dv(glProcedure('glTexCoord2dv'{$IFDEF CLR}, typeof(TglTexCoord2dv){$ENDIF}));
  glTexCoord2dv(v);
end;

procedure STUB_glTexCoord2f(s: TGLfloat; t: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord2f := TglTexCoord2f(glProcedure('glTexCoord2f'{$IFDEF CLR}, typeof(TglTexCoord2f){$ENDIF}));
  glTexCoord2f(s, t);
end;

procedure STUB_glTexCoord2fv(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord2fv := TglTexCoord2fv(glProcedure('glTexCoord2fv'{$IFDEF CLR}, typeof(TglTexCoord2fv){$ENDIF}));
  glTexCoord2fv(v);
end;

procedure STUB_glTexCoord2i(s: TGLint; t: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord2i := TglTexCoord2i(glProcedure('glTexCoord2i'{$IFDEF CLR}, typeof(TglTexCoord2i){$ENDIF}));
  glTexCoord2i(s, t);
end;

procedure STUB_glTexCoord2iv(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord2iv := TglTexCoord2iv(glProcedure('glTexCoord2iv'{$IFDEF CLR}, typeof(TglTexCoord2iv){$ENDIF}));
  glTexCoord2iv(v);
end;

procedure STUB_glTexCoord2s(s: TGLshort; t: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord2s := TglTexCoord2s(glProcedure('glTexCoord2s'{$IFDEF CLR}, typeof(TglTexCoord2s){$ENDIF}));
  glTexCoord2s(s, t);
end;

procedure STUB_glTexCoord2sv(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord2sv := TglTexCoord2sv(glProcedure('glTexCoord2sv'{$IFDEF CLR}, typeof(TglTexCoord2sv){$ENDIF}));
  glTexCoord2sv(v);
end;

procedure STUB_glTexCoord3d(s: TGLdouble; t: TGLdouble; r: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord3d := TglTexCoord3d(glProcedure('glTexCoord3d'{$IFDEF CLR}, typeof(TglTexCoord3d){$ENDIF}));
  glTexCoord3d(s, t, r);
end;

procedure STUB_glTexCoord3dv(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord3dv := TglTexCoord3dv(glProcedure('glTexCoord3dv'{$IFDEF CLR}, typeof(TglTexCoord3dv){$ENDIF}));
  glTexCoord3dv(v);
end;

procedure STUB_glTexCoord3f(s: TGLfloat; t: TGLfloat; r: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord3f := TglTexCoord3f(glProcedure('glTexCoord3f'{$IFDEF CLR}, typeof(TglTexCoord3f){$ENDIF}));
  glTexCoord3f(s, t, r);
end;

procedure STUB_glTexCoord3fv(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord3fv := TglTexCoord3fv(glProcedure('glTexCoord3fv'{$IFDEF CLR}, typeof(TglTexCoord3fv){$ENDIF}));
  glTexCoord3fv(v);
end;

procedure STUB_glTexCoord3i(s: TGLint; t: TGLint; r: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord3i := TglTexCoord3i(glProcedure('glTexCoord3i'{$IFDEF CLR}, typeof(TglTexCoord3i){$ENDIF}));
  glTexCoord3i(s, t, r);
end;

procedure STUB_glTexCoord3iv(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord3iv := TglTexCoord3iv(glProcedure('glTexCoord3iv'{$IFDEF CLR}, typeof(TglTexCoord3iv){$ENDIF}));
  glTexCoord3iv(v);
end;

procedure STUB_glTexCoord3s(s: TGLshort; t: TGLshort; r: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord3s := TglTexCoord3s(glProcedure('glTexCoord3s'{$IFDEF CLR}, typeof(TglTexCoord3s){$ENDIF}));
  glTexCoord3s(s, t, r);
end;

procedure STUB_glTexCoord3sv(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord3sv := TglTexCoord3sv(glProcedure('glTexCoord3sv'{$IFDEF CLR}, typeof(TglTexCoord3sv){$ENDIF}));
  glTexCoord3sv(v);
end;

procedure STUB_glTexCoord4d(s: TGLdouble; t: TGLdouble; r: TGLdouble; q: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord4d := TglTexCoord4d(glProcedure('glTexCoord4d'{$IFDEF CLR}, typeof(TglTexCoord4d){$ENDIF}));
  glTexCoord4d(s, t, r, q);
end;

procedure STUB_glTexCoord4dv(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord4dv := TglTexCoord4dv(glProcedure('glTexCoord4dv'{$IFDEF CLR}, typeof(TglTexCoord4dv){$ENDIF}));
  glTexCoord4dv(v);
end;

procedure STUB_glTexCoord4f(s: TGLfloat; t: TGLfloat; r: TGLfloat; q: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord4f := TglTexCoord4f(glProcedure('glTexCoord4f'{$IFDEF CLR}, typeof(TglTexCoord4f){$ENDIF}));
  glTexCoord4f(s, t, r, q);
end;

procedure STUB_glTexCoord4fv(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord4fv := TglTexCoord4fv(glProcedure('glTexCoord4fv'{$IFDEF CLR}, typeof(TglTexCoord4fv){$ENDIF}));
  glTexCoord4fv(v);
end;

procedure STUB_glTexCoord4i(s: TGLint; t: TGLint; r: TGLint; q: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord4i := TglTexCoord4i(glProcedure('glTexCoord4i'{$IFDEF CLR}, typeof(TglTexCoord4i){$ENDIF}));
  glTexCoord4i(s, t, r, q);
end;

procedure STUB_glTexCoord4iv(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord4iv := TglTexCoord4iv(glProcedure('glTexCoord4iv'{$IFDEF CLR}, typeof(TglTexCoord4iv){$ENDIF}));
  glTexCoord4iv(v);
end;

procedure STUB_glTexCoord4s(s: TGLshort; t: TGLshort; r: TGLshort; q: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord4s := TglTexCoord4s(glProcedure('glTexCoord4s'{$IFDEF CLR}, typeof(TglTexCoord4s){$ENDIF}));
  glTexCoord4s(s, t, r, q);
end;

procedure STUB_glTexCoord4sv(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexCoord4sv := TglTexCoord4sv(glProcedure('glTexCoord4sv'{$IFDEF CLR}, typeof(TglTexCoord4sv){$ENDIF}));
  glTexCoord4sv(v);
end;

procedure STUB_glTexCoordPointer(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  _glTexCoordPointer := TglTexCoordPointer(glProcedure('glTexCoordPointer'{$IFDEF CLR}, typeof(TglTexCoordPointer){$ENDIF}));
  _glTexCoordPointer(size, _type, stride, _pointer);
end;

procedure STUB_glTexEnvf(target: TGLenum; pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexEnvf := TglTexEnvf(glProcedure('glTexEnvf'{$IFDEF CLR}, typeof(TglTexEnvf){$ENDIF}));
  glTexEnvf(target, pname, param);
end;

procedure STUB_glTexEnvfv(target: TGLenum; pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexEnvfv := TglTexEnvfv(glProcedure('glTexEnvfv'{$IFDEF CLR}, typeof(TglTexEnvfv){$ENDIF}));
  glTexEnvfv(target, pname, params);
end;

procedure STUB_glTexEnvi(target: TGLenum; pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexEnvi := TglTexEnvi(glProcedure('glTexEnvi'{$IFDEF CLR}, typeof(TglTexEnvi){$ENDIF}));
  glTexEnvi(target, pname, param);
end;

procedure STUB_glTexEnviv(target: TGLenum; pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexEnviv := TglTexEnviv(glProcedure('glTexEnviv'{$IFDEF CLR}, typeof(TglTexEnviv){$ENDIF}));
  glTexEnviv(target, pname, params);
end;

procedure STUB_glTexGend(coord: TGLenum; pname: TGLenum; param: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexGend := TglTexGend(glProcedure('glTexGend'{$IFDEF CLR}, typeof(TglTexGend){$ENDIF}));
  glTexGend(coord, pname, param);
end;

procedure STUB_glTexGendv(coord: TGLenum; pname: TGLenum; const params: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexGendv := TglTexGendv(glProcedure('glTexGendv'{$IFDEF CLR}, typeof(TglTexGendv){$ENDIF}));
  glTexGendv(coord, pname, params);
end;

procedure STUB_glTexGenf(coord: TGLenum; pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexGenf := TglTexGenf(glProcedure('glTexGenf'{$IFDEF CLR}, typeof(TglTexGenf){$ENDIF}));
  glTexGenf(coord, pname, param);
end;

procedure STUB_glTexGenfv(coord: TGLenum; pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexGenfv := TglTexGenfv(glProcedure('glTexGenfv'{$IFDEF CLR}, typeof(TglTexGenfv){$ENDIF}));
  glTexGenfv(coord, pname, params);
end;

procedure STUB_glTexGeni(coord: TGLenum; pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexGeni := TglTexGeni(glProcedure('glTexGeni'{$IFDEF CLR}, typeof(TglTexGeni){$ENDIF}));
  glTexGeni(coord, pname, param);
end;

procedure STUB_glTexGeniv(coord: TGLenum; pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexGeniv := TglTexGeniv(glProcedure('glTexGeniv'{$IFDEF CLR}, typeof(TglTexGeniv){$ENDIF}));
  glTexGeniv(coord, pname, params);
end;

procedure STUB_glTexImage1D(target: TGLenum; level: TGLint; internalformat: TGLint; width: TGLsizei; border: TGLint; format: TGLenum; _type: TGLenum; const pixels: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexImage1D := TglTexImage1D(glProcedure('glTexImage1D'{$IFDEF CLR}, typeof(TglTexImage1D){$ENDIF}));
  glTexImage1D(target, level, internalformat, width, border, format, _type, pixels);
end;

procedure STUB_glTexImage2D(target: TGLenum; level: TGLint; internalformat: TGLint; width: TGLsizei; height: TGLsizei; border: TGLint; format: TGLenum; _type: TGLenum; const pixels: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  _glTexImage2D := TglTexImage2D(glProcedure('glTexImage2D'{$IFDEF CLR}, typeof(TglTexImage2D){$ENDIF}));
  _glTexImage2D(target, level, internalformat, width, height, border, format, _type, pixels);
end;

procedure STUB_glTexParameterf(target: TGLenum; pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexParameterf := TglTexParameterf(glProcedure('glTexParameterf'{$IFDEF CLR}, typeof(TglTexParameterf){$ENDIF}));
  glTexParameterf(target, pname, param);
end;

procedure STUB_glTexParameterfv(target: TGLenum; pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexParameterfv := TglTexParameterfv(glProcedure('glTexParameterfv'{$IFDEF CLR}, typeof(TglTexParameterfv){$ENDIF}));
  glTexParameterfv(target, pname, params);
end;

procedure STUB_glTexParameteri(target: TGLenum; pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexParameteri := TglTexParameteri(glProcedure('glTexParameteri'{$IFDEF CLR}, typeof(TglTexParameteri){$ENDIF}));
  glTexParameteri(target, pname, param);
end;

procedure STUB_glTexParameteriv(target: TGLenum; pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexParameteriv := TglTexParameteriv(glProcedure('glTexParameteriv'{$IFDEF CLR}, typeof(TglTexParameteriv){$ENDIF}));
  glTexParameteriv(target, pname, params);
end;

procedure STUB_glTexSubImage1D(target: TGLenum; level: TGLint; xoffset: TGLint; width: TGLsizei; format: TGLenum; _type: TGLenum; const pixels: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexSubImage1D := TglTexSubImage1D(glProcedure('glTexSubImage1D'{$IFDEF CLR}, typeof(TglTexSubImage1D){$ENDIF}));
  glTexSubImage1D(target, level, xoffset, width, format, _type, pixels);
end;

procedure STUB_glTexSubImage2D(target: TGLenum; level: TGLint; xoffset: TGLint; yoffset: TGLint; width: TGLsizei; height: TGLsizei; format: TGLenum; _type: TGLenum; const pixels: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexSubImage2D := TglTexSubImage2D(glProcedure('glTexSubImage2D'{$IFDEF CLR}, typeof(TglTexSubImage2D){$ENDIF}));
  glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, _type, pixels);
end;

procedure STUB_glTranslated(x: TGLdouble; y: TGLdouble; z: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTranslated := TglTranslated(glProcedure('glTranslated'{$IFDEF CLR}, typeof(TglTranslated){$ENDIF}));
  glTranslated(x, y, z);
end;

procedure STUB_glTranslatef(x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTranslatef := TglTranslatef(glProcedure('glTranslatef'{$IFDEF CLR}, typeof(TglTranslatef){$ENDIF}));
  glTranslatef(x, y, z);
end;

procedure STUB_glVertex2d(x: TGLdouble; y: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertex2d := TglVertex2d(glProcedure('glVertex2d'{$IFDEF CLR}, typeof(TglVertex2d){$ENDIF}));
  glVertex2d(x, y);
end;

procedure STUB_glVertex2dv(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertex2dv := TglVertex2dv(glProcedure('glVertex2dv'{$IFDEF CLR}, typeof(TglVertex2dv){$ENDIF}));
  glVertex2dv(v);
end;

procedure STUB_glVertex2f(x: TGLfloat; y: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertex2f := TglVertex2f(glProcedure('glVertex2f'{$IFDEF CLR}, typeof(TglVertex2f){$ENDIF}));
  glVertex2f(x, y);
end;

procedure STUB_glVertex2fv(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertex2fv := TglVertex2fv(glProcedure('glVertex2fv'{$IFDEF CLR}, typeof(TglVertex2fv){$ENDIF}));
  glVertex2fv(v);
end;

procedure STUB_glVertex2i(x: TGLint; y: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertex2i := TglVertex2i(glProcedure('glVertex2i'{$IFDEF CLR}, typeof(TglVertex2i){$ENDIF}));
  glVertex2i(x, y);
end;

procedure STUB_glVertex2iv(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertex2iv := TglVertex2iv(glProcedure('glVertex2iv'{$IFDEF CLR}, typeof(TglVertex2iv){$ENDIF}));
  glVertex2iv(v);
end;

procedure STUB_glVertex2s(x: TGLshort; y: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertex2s := TglVertex2s(glProcedure('glVertex2s'{$IFDEF CLR}, typeof(TglVertex2s){$ENDIF}));
  glVertex2s(x, y);
end;

procedure STUB_glVertex2sv(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertex2sv := TglVertex2sv(glProcedure('glVertex2sv'{$IFDEF CLR}, typeof(TglVertex2sv){$ENDIF}));
  glVertex2sv(v);
end;

procedure STUB_glVertex3d(x: TGLdouble; y: TGLdouble; z: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertex3d := TglVertex3d(glProcedure('glVertex3d'{$IFDEF CLR}, typeof(TglVertex3d){$ENDIF}));
  glVertex3d(x, y, z);
end;

procedure STUB_glVertex3dv(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertex3dv := TglVertex3dv(glProcedure('glVertex3dv'{$IFDEF CLR}, typeof(TglVertex3dv){$ENDIF}));
  glVertex3dv(v);
end;

procedure STUB_glVertex3f(x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertex3f := TglVertex3f(glProcedure('glVertex3f'{$IFDEF CLR}, typeof(TglVertex3f){$ENDIF}));
  glVertex3f(x, y, z);
end;

procedure STUB_glVertex3fv(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertex3fv := TglVertex3fv(glProcedure('glVertex3fv'{$IFDEF CLR}, typeof(TglVertex3fv){$ENDIF}));
  glVertex3fv(v);
end;

procedure STUB_glVertex3i(x: TGLint; y: TGLint; z: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertex3i := TglVertex3i(glProcedure('glVertex3i'{$IFDEF CLR}, typeof(TglVertex3i){$ENDIF}));
  glVertex3i(x, y, z);
end;

procedure STUB_glVertex3iv(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertex3iv := TglVertex3iv(glProcedure('glVertex3iv'{$IFDEF CLR}, typeof(TglVertex3iv){$ENDIF}));
  glVertex3iv(v);
end;

procedure STUB_glVertex3s(x: TGLshort; y: TGLshort; z: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertex3s := TglVertex3s(glProcedure('glVertex3s'{$IFDEF CLR}, typeof(TglVertex3s){$ENDIF}));
  glVertex3s(x, y, z);
end;

procedure STUB_glVertex3sv(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertex3sv := TglVertex3sv(glProcedure('glVertex3sv'{$IFDEF CLR}, typeof(TglVertex3sv){$ENDIF}));
  glVertex3sv(v);
end;

procedure STUB_glVertex4d(x: TGLdouble; y: TGLdouble; z: TGLdouble; w: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertex4d := TglVertex4d(glProcedure('glVertex4d'{$IFDEF CLR}, typeof(TglVertex4d){$ENDIF}));
  glVertex4d(x, y, z, w);
end;

procedure STUB_glVertex4dv(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertex4dv := TglVertex4dv(glProcedure('glVertex4dv'{$IFDEF CLR}, typeof(TglVertex4dv){$ENDIF}));
  glVertex4dv(v);
end;

procedure STUB_glVertex4f(x: TGLfloat; y: TGLfloat; z: TGLfloat; w: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertex4f := TglVertex4f(glProcedure('glVertex4f'{$IFDEF CLR}, typeof(TglVertex4f){$ENDIF}));
  glVertex4f(x, y, z, w);
end;

procedure STUB_glVertex4fv(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertex4fv := TglVertex4fv(glProcedure('glVertex4fv'{$IFDEF CLR}, typeof(TglVertex4fv){$ENDIF}));
  glVertex4fv(v);
end;

procedure STUB_glVertex4i(x: TGLint; y: TGLint; z: TGLint; w: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertex4i := TglVertex4i(glProcedure('glVertex4i'{$IFDEF CLR}, typeof(TglVertex4i){$ENDIF}));
  glVertex4i(x, y, z, w);
end;

procedure STUB_glVertex4iv(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertex4iv := TglVertex4iv(glProcedure('glVertex4iv'{$IFDEF CLR}, typeof(TglVertex4iv){$ENDIF}));
  glVertex4iv(v);
end;

procedure STUB_glVertex4s(x: TGLshort; y: TGLshort; z: TGLshort; w: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertex4s := TglVertex4s(glProcedure('glVertex4s'{$IFDEF CLR}, typeof(TglVertex4s){$ENDIF}));
  glVertex4s(x, y, z, w);
end;

procedure STUB_glVertex4sv(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertex4sv := TglVertex4sv(glProcedure('glVertex4sv'{$IFDEF CLR}, typeof(TglVertex4sv){$ENDIF}));
  glVertex4sv(v);
end;

procedure STUB_glVertexPointer(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  _glVertexPointer := TglVertexPointer(glProcedure('glVertexPointer'{$IFDEF CLR}, typeof(TglVertexPointer){$ENDIF}));
  _glVertexPointer(size, _type, stride, _pointer);
end;

procedure STUB_glViewport(x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glViewport := TglViewport(glProcedure('glViewport'{$IFDEF CLR}, typeof(TglViewport){$ENDIF}));
  glViewport(x, y, width, height);
end;

procedure STUB_glBlendColor(red: TGLclampf; green: TGLclampf; blue: TGLclampf; alpha: TGLclampf); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glBlendColor := TglBlendColor(glProcedure('glBlendColor'{$IFDEF CLR}, typeof(TglBlendColor){$ENDIF}));
  glBlendColor(red, green, blue, alpha);
end;

procedure STUB_glBlendEquation(mode: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glBlendEquation := TglBlendEquation(glProcedure('glBlendEquation'{$IFDEF CLR}, typeof(TglBlendEquation){$ENDIF}));
  glBlendEquation(mode);
end;

procedure STUB_glDrawRangeElements(mode: TGLenum; start: TGLuint; _end: TGLuint; count: TGLsizei; _type: TGLenum; const indices: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDrawRangeElements := TglDrawRangeElements(glProcedure('glDrawRangeElements'{$IFDEF CLR}, typeof(TglDrawRangeElements){$ENDIF}));
  glDrawRangeElements(mode, start, _end, count, _type, indices);
end;

procedure STUB_glColorTable(target: TGLenum; internalformat: TGLenum; width: TGLsizei; format: TGLenum; _type: TGLenum; const table: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColorTable := TglColorTable(glProcedure('glColorTable'{$IFDEF CLR}, typeof(TglColorTable){$ENDIF}));
  glColorTable(target, internalformat, width, format, _type, table);
end;

procedure STUB_glColorTableParameterfv(target: TGLenum; pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColorTableParameterfv := TglColorTableParameterfv(glProcedure('glColorTableParameterfv'{$IFDEF CLR}, typeof(TglColorTableParameterfv){$ENDIF}));
  glColorTableParameterfv(target, pname, params);
end;

procedure STUB_glColorTableParameteriv(target: TGLenum; pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColorTableParameteriv := TglColorTableParameteriv(glProcedure('glColorTableParameteriv'{$IFDEF CLR}, typeof(TglColorTableParameteriv){$ENDIF}));
  glColorTableParameteriv(target, pname, params);
end;

procedure STUB_glCopyColorTable(target: TGLenum; internalformat: TGLenum; x: TGLint; y: TGLint; width: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCopyColorTable := TglCopyColorTable(glProcedure('glCopyColorTable'{$IFDEF CLR}, typeof(TglCopyColorTable){$ENDIF}));
  glCopyColorTable(target, internalformat, x, y, width);
end;

procedure STUB_glGetColorTable(target: TGLenum; format: TGLenum; _type: TGLenum; table: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetColorTable := TglGetColorTable(glProcedure('glGetColorTable'{$IFDEF CLR}, typeof(TglGetColorTable){$ENDIF}));
  glGetColorTable(target, format, _type, table);
end;

procedure STUB_glGetColorTableParameterfv(target: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetColorTableParameterfv := TglGetColorTableParameterfv(glProcedure('glGetColorTableParameterfv'{$IFDEF CLR}, typeof(TglGetColorTableParameterfv){$ENDIF}));
  glGetColorTableParameterfv(target, pname, params);
end;

procedure STUB_glGetColorTableParameteriv(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetColorTableParameteriv := TglGetColorTableParameteriv(glProcedure('glGetColorTableParameteriv'{$IFDEF CLR}, typeof(TglGetColorTableParameteriv){$ENDIF}));
  glGetColorTableParameteriv(target, pname, params);
end;

procedure STUB_glColorSubTable(target: TGLenum; start: TGLsizei; count: TGLsizei; format: TGLenum; _type: TGLenum; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColorSubTable := TglColorSubTable(glProcedure('glColorSubTable'{$IFDEF CLR}, typeof(TglColorSubTable){$ENDIF}));
  glColorSubTable(target, start, count, format, _type, data);
end;

procedure STUB_glCopyColorSubTable(target: TGLenum; start: TGLsizei; x: TGLint; y: TGLint; width: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCopyColorSubTable := TglCopyColorSubTable(glProcedure('glCopyColorSubTable'{$IFDEF CLR}, typeof(TglCopyColorSubTable){$ENDIF}));
  glCopyColorSubTable(target, start, x, y, width);
end;

procedure STUB_glConvolutionFilter1D(target: TGLenum; internalformat: TGLenum; width: TGLsizei; format: TGLenum; _type: TGLenum; const image: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glConvolutionFilter1D := TglConvolutionFilter1D(glProcedure('glConvolutionFilter1D'{$IFDEF CLR}, typeof(TglConvolutionFilter1D){$ENDIF}));
  glConvolutionFilter1D(target, internalformat, width, format, _type, image);
end;

procedure STUB_glConvolutionFilter2D(target: TGLenum; internalformat: TGLenum; width: TGLsizei; height: TGLsizei; format: TGLenum; _type: TGLenum; const image: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glConvolutionFilter2D := TglConvolutionFilter2D(glProcedure('glConvolutionFilter2D'{$IFDEF CLR}, typeof(TglConvolutionFilter2D){$ENDIF}));
  glConvolutionFilter2D(target, internalformat, width, height, format, _type, image);
end;

procedure STUB_glConvolutionParameterf(target: TGLenum; pname: TGLenum; params: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glConvolutionParameterf := TglConvolutionParameterf(glProcedure('glConvolutionParameterf'{$IFDEF CLR}, typeof(TglConvolutionParameterf){$ENDIF}));
  glConvolutionParameterf(target, pname, params);
end;

procedure STUB_glConvolutionParameterfv(target: TGLenum; pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glConvolutionParameterfv := TglConvolutionParameterfv(glProcedure('glConvolutionParameterfv'{$IFDEF CLR}, typeof(TglConvolutionParameterfv){$ENDIF}));
  glConvolutionParameterfv(target, pname, params);
end;

procedure STUB_glConvolutionParameteri(target: TGLenum; pname: TGLenum; params: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glConvolutionParameteri := TglConvolutionParameteri(glProcedure('glConvolutionParameteri'{$IFDEF CLR}, typeof(TglConvolutionParameteri){$ENDIF}));
  glConvolutionParameteri(target, pname, params);
end;

procedure STUB_glConvolutionParameteriv(target: TGLenum; pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glConvolutionParameteriv := TglConvolutionParameteriv(glProcedure('glConvolutionParameteriv'{$IFDEF CLR}, typeof(TglConvolutionParameteriv){$ENDIF}));
  glConvolutionParameteriv(target, pname, params);
end;

procedure STUB_glCopyConvolutionFilter1D(target: TGLenum; internalformat: TGLenum; x: TGLint; y: TGLint; width: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCopyConvolutionFilter1D := TglCopyConvolutionFilter1D(glProcedure('glCopyConvolutionFilter1D'{$IFDEF CLR}, typeof(TglCopyConvolutionFilter1D){$ENDIF}));
  glCopyConvolutionFilter1D(target, internalformat, x, y, width);
end;

procedure STUB_glCopyConvolutionFilter2D(target: TGLenum; internalformat: TGLenum; x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCopyConvolutionFilter2D := TglCopyConvolutionFilter2D(glProcedure('glCopyConvolutionFilter2D'{$IFDEF CLR}, typeof(TglCopyConvolutionFilter2D){$ENDIF}));
  glCopyConvolutionFilter2D(target, internalformat, x, y, width, height);
end;

procedure STUB_glGetConvolutionFilter(target: TGLenum; format: TGLenum; _type: TGLenum; image: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetConvolutionFilter := TglGetConvolutionFilter(glProcedure('glGetConvolutionFilter'{$IFDEF CLR}, typeof(TglGetConvolutionFilter){$ENDIF}));
  glGetConvolutionFilter(target, format, _type, image);
end;

procedure STUB_glGetConvolutionParameterfv(target: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetConvolutionParameterfv := TglGetConvolutionParameterfv(glProcedure('glGetConvolutionParameterfv'{$IFDEF CLR}, typeof(TglGetConvolutionParameterfv){$ENDIF}));
  glGetConvolutionParameterfv(target, pname, params);
end;

procedure STUB_glGetConvolutionParameteriv(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetConvolutionParameteriv := TglGetConvolutionParameteriv(glProcedure('glGetConvolutionParameteriv'{$IFDEF CLR}, typeof(TglGetConvolutionParameteriv){$ENDIF}));
  glGetConvolutionParameteriv(target, pname, params);
end;

procedure STUB_glGetSeparableFilter(target: TGLenum; format: TGLenum; _type: TGLenum; row: PGLvoid; column: PGLvoid; span: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetSeparableFilter := TglGetSeparableFilter(glProcedure('glGetSeparableFilter'{$IFDEF CLR}, typeof(TglGetSeparableFilter){$ENDIF}));
  glGetSeparableFilter(target, format, _type, row, column, span);
end;

procedure STUB_glSeparableFilter2D(target: TGLenum; internalformat: TGLenum; width: TGLsizei; height: TGLsizei; format: TGLenum; _type: TGLenum; const row: PGLvoid; const column: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glSeparableFilter2D := TglSeparableFilter2D(glProcedure('glSeparableFilter2D'{$IFDEF CLR}, typeof(TglSeparableFilter2D){$ENDIF}));
  glSeparableFilter2D(target, internalformat, width, height, format, _type, row, column);
end;

procedure STUB_glGetHistogram(target: TGLenum; reset: TGLboolean; format: TGLenum; _type: TGLenum; values: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetHistogram := TglGetHistogram(glProcedure('glGetHistogram'{$IFDEF CLR}, typeof(TglGetHistogram){$ENDIF}));
  glGetHistogram(target, reset, format, _type, values);
end;

procedure STUB_glGetHistogramParameterfv(target: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetHistogramParameterfv := TglGetHistogramParameterfv(glProcedure('glGetHistogramParameterfv'{$IFDEF CLR}, typeof(TglGetHistogramParameterfv){$ENDIF}));
  glGetHistogramParameterfv(target, pname, params);
end;

procedure STUB_glGetHistogramParameteriv(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetHistogramParameteriv := TglGetHistogramParameteriv(glProcedure('glGetHistogramParameteriv'{$IFDEF CLR}, typeof(TglGetHistogramParameteriv){$ENDIF}));
  glGetHistogramParameteriv(target, pname, params);
end;

procedure STUB_glGetMinmax(target: TGLenum; reset: TGLboolean; format: TGLenum; _type: TGLenum; values: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetMinmax := TglGetMinmax(glProcedure('glGetMinmax'{$IFDEF CLR}, typeof(TglGetMinmax){$ENDIF}));
  glGetMinmax(target, reset, format, _type, values);
end;

procedure STUB_glGetMinmaxParameterfv(target: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetMinmaxParameterfv := TglGetMinmaxParameterfv(glProcedure('glGetMinmaxParameterfv'{$IFDEF CLR}, typeof(TglGetMinmaxParameterfv){$ENDIF}));
  glGetMinmaxParameterfv(target, pname, params);
end;

procedure STUB_glGetMinmaxParameteriv(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetMinmaxParameteriv := TglGetMinmaxParameteriv(glProcedure('glGetMinmaxParameteriv'{$IFDEF CLR}, typeof(TglGetMinmaxParameteriv){$ENDIF}));
  glGetMinmaxParameteriv(target, pname, params);
end;

procedure STUB_glHistogram(target: TGLenum; width: TGLsizei; internalformat: TGLenum; sink: TGLboolean); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glHistogram := TglHistogram(glProcedure('glHistogram'{$IFDEF CLR}, typeof(TglHistogram){$ENDIF}));
  glHistogram(target, width, internalformat, sink);
end;

procedure STUB_glMinmax(target: TGLenum; internalformat: TGLenum; sink: TGLboolean); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMinmax := TglMinmax(glProcedure('glMinmax'{$IFDEF CLR}, typeof(TglMinmax){$ENDIF}));
  glMinmax(target, internalformat, sink);
end;

procedure STUB_glResetHistogram(target: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glResetHistogram := TglResetHistogram(glProcedure('glResetHistogram'{$IFDEF CLR}, typeof(TglResetHistogram){$ENDIF}));
  glResetHistogram(target);
end;

procedure STUB_glResetMinmax(target: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glResetMinmax := TglResetMinmax(glProcedure('glResetMinmax'{$IFDEF CLR}, typeof(TglResetMinmax){$ENDIF}));
  glResetMinmax(target);
end;

procedure STUB_glTexImage3D(target: TGLenum; level: TGLint; internalformat: TGLint; width: TGLsizei; height: TGLsizei; depth: TGLsizei; border: TGLint; format: TGLenum; _type: TGLenum; const pixels: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexImage3D := TglTexImage3D(glProcedure('glTexImage3D'{$IFDEF CLR}, typeof(TglTexImage3D){$ENDIF}));
  glTexImage3D(target, level, internalformat, width, height, depth, border, format, _type, pixels);
end;

procedure STUB_glTexSubImage3D(target: TGLenum; level: TGLint; xoffset: TGLint; yoffset: TGLint; zoffset: TGLint; width: TGLsizei; height: TGLsizei; depth: TGLsizei; format: TGLenum; _type: TGLenum; const pixels: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexSubImage3D := TglTexSubImage3D(glProcedure('glTexSubImage3D'{$IFDEF CLR}, typeof(TglTexSubImage3D){$ENDIF}));
  glTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, _type, pixels);
end;

procedure STUB_glCopyTexSubImage3D(target: TGLenum; level: TGLint; xoffset: TGLint; yoffset: TGLint; zoffset: TGLint; x: TGLint; y: TGLint; width: TGLsizei; height: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCopyTexSubImage3D := TglCopyTexSubImage3D(glProcedure('glCopyTexSubImage3D'{$IFDEF CLR}, typeof(TglCopyTexSubImage3D){$ENDIF}));
  glCopyTexSubImage3D(target, level, xoffset, yoffset, zoffset, x, y, width, height);
end;

procedure STUB_glActiveTexture(texture: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glActiveTexture := TglActiveTexture(glProcedure('glActiveTexture'{$IFDEF CLR}, typeof(TglActiveTexture){$ENDIF}));
  glActiveTexture(texture);
end;

procedure STUB_glClientActiveTexture(texture: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glClientActiveTexture := TglClientActiveTexture(glProcedure('glClientActiveTexture'{$IFDEF CLR}, typeof(TglClientActiveTexture){$ENDIF}));
  glClientActiveTexture(texture);
end;

procedure STUB_glMultiTexCoord1d(target: TGLenum; s: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord1d := TglMultiTexCoord1d(glProcedure('glMultiTexCoord1d'{$IFDEF CLR}, typeof(TglMultiTexCoord1d){$ENDIF}));
  glMultiTexCoord1d(target, s);
end;

procedure STUB_glMultiTexCoord1dv(target: TGLenum; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord1dv := TglMultiTexCoord1dv(glProcedure('glMultiTexCoord1dv'{$IFDEF CLR}, typeof(TglMultiTexCoord1dv){$ENDIF}));
  glMultiTexCoord1dv(target, v);
end;

procedure STUB_glMultiTexCoord1f(target: TGLenum; s: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord1f := TglMultiTexCoord1f(glProcedure('glMultiTexCoord1f'{$IFDEF CLR}, typeof(TglMultiTexCoord1f){$ENDIF}));
  glMultiTexCoord1f(target, s);
end;

procedure STUB_glMultiTexCoord1fv(target: TGLenum; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord1fv := TglMultiTexCoord1fv(glProcedure('glMultiTexCoord1fv'{$IFDEF CLR}, typeof(TglMultiTexCoord1fv){$ENDIF}));
  glMultiTexCoord1fv(target, v);
end;

procedure STUB_glMultiTexCoord1i(target: TGLenum; s: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord1i := TglMultiTexCoord1i(glProcedure('glMultiTexCoord1i'{$IFDEF CLR}, typeof(TglMultiTexCoord1i){$ENDIF}));
  glMultiTexCoord1i(target, s);
end;

procedure STUB_glMultiTexCoord1iv(target: TGLenum; const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord1iv := TglMultiTexCoord1iv(glProcedure('glMultiTexCoord1iv'{$IFDEF CLR}, typeof(TglMultiTexCoord1iv){$ENDIF}));
  glMultiTexCoord1iv(target, v);
end;

procedure STUB_glMultiTexCoord1s(target: TGLenum; s: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord1s := TglMultiTexCoord1s(glProcedure('glMultiTexCoord1s'{$IFDEF CLR}, typeof(TglMultiTexCoord1s){$ENDIF}));
  glMultiTexCoord1s(target, s);
end;

procedure STUB_glMultiTexCoord1sv(target: TGLenum; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord1sv := TglMultiTexCoord1sv(glProcedure('glMultiTexCoord1sv'{$IFDEF CLR}, typeof(TglMultiTexCoord1sv){$ENDIF}));
  glMultiTexCoord1sv(target, v);
end;

procedure STUB_glMultiTexCoord2d(target: TGLenum; s: TGLdouble; t: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord2d := TglMultiTexCoord2d(glProcedure('glMultiTexCoord2d'{$IFDEF CLR}, typeof(TglMultiTexCoord2d){$ENDIF}));
  glMultiTexCoord2d(target, s, t);
end;

procedure STUB_glMultiTexCoord2dv(target: TGLenum; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord2dv := TglMultiTexCoord2dv(glProcedure('glMultiTexCoord2dv'{$IFDEF CLR}, typeof(TglMultiTexCoord2dv){$ENDIF}));
  glMultiTexCoord2dv(target, v);
end;

procedure STUB_glMultiTexCoord2f(target: TGLenum; s: TGLfloat; t: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord2f := TglMultiTexCoord2f(glProcedure('glMultiTexCoord2f'{$IFDEF CLR}, typeof(TglMultiTexCoord2f){$ENDIF}));
  glMultiTexCoord2f(target, s, t);
end;

procedure STUB_glMultiTexCoord2fv(target: TGLenum; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord2fv := TglMultiTexCoord2fv(glProcedure('glMultiTexCoord2fv'{$IFDEF CLR}, typeof(TglMultiTexCoord2fv){$ENDIF}));
  glMultiTexCoord2fv(target, v);
end;

procedure STUB_glMultiTexCoord2i(target: TGLenum; s: TGLint; t: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord2i := TglMultiTexCoord2i(glProcedure('glMultiTexCoord2i'{$IFDEF CLR}, typeof(TglMultiTexCoord2i){$ENDIF}));
  glMultiTexCoord2i(target, s, t);
end;

procedure STUB_glMultiTexCoord2iv(target: TGLenum; const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord2iv := TglMultiTexCoord2iv(glProcedure('glMultiTexCoord2iv'{$IFDEF CLR}, typeof(TglMultiTexCoord2iv){$ENDIF}));
  glMultiTexCoord2iv(target, v);
end;

procedure STUB_glMultiTexCoord2s(target: TGLenum; s: TGLshort; t: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord2s := TglMultiTexCoord2s(glProcedure('glMultiTexCoord2s'{$IFDEF CLR}, typeof(TglMultiTexCoord2s){$ENDIF}));
  glMultiTexCoord2s(target, s, t);
end;

procedure STUB_glMultiTexCoord2sv(target: TGLenum; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord2sv := TglMultiTexCoord2sv(glProcedure('glMultiTexCoord2sv'{$IFDEF CLR}, typeof(TglMultiTexCoord2sv){$ENDIF}));
  glMultiTexCoord2sv(target, v);
end;

procedure STUB_glMultiTexCoord3d(target: TGLenum; s: TGLdouble; t: TGLdouble; r: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord3d := TglMultiTexCoord3d(glProcedure('glMultiTexCoord3d'{$IFDEF CLR}, typeof(TglMultiTexCoord3d){$ENDIF}));
  glMultiTexCoord3d(target, s, t, r);
end;

procedure STUB_glMultiTexCoord3dv(target: TGLenum; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord3dv := TglMultiTexCoord3dv(glProcedure('glMultiTexCoord3dv'{$IFDEF CLR}, typeof(TglMultiTexCoord3dv){$ENDIF}));
  glMultiTexCoord3dv(target, v);
end;

procedure STUB_glMultiTexCoord3f(target: TGLenum; s: TGLfloat; t: TGLfloat; r: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord3f := TglMultiTexCoord3f(glProcedure('glMultiTexCoord3f'{$IFDEF CLR}, typeof(TglMultiTexCoord3f){$ENDIF}));
  glMultiTexCoord3f(target, s, t, r);
end;

procedure STUB_glMultiTexCoord3fv(target: TGLenum; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord3fv := TglMultiTexCoord3fv(glProcedure('glMultiTexCoord3fv'{$IFDEF CLR}, typeof(TglMultiTexCoord3fv){$ENDIF}));
  glMultiTexCoord3fv(target, v);
end;

procedure STUB_glMultiTexCoord3i(target: TGLenum; s: TGLint; t: TGLint; r: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord3i := TglMultiTexCoord3i(glProcedure('glMultiTexCoord3i'{$IFDEF CLR}, typeof(TglMultiTexCoord3i){$ENDIF}));
  glMultiTexCoord3i(target, s, t, r);
end;

procedure STUB_glMultiTexCoord3iv(target: TGLenum; const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord3iv := TglMultiTexCoord3iv(glProcedure('glMultiTexCoord3iv'{$IFDEF CLR}, typeof(TglMultiTexCoord3iv){$ENDIF}));
  glMultiTexCoord3iv(target, v);
end;

procedure STUB_glMultiTexCoord3s(target: TGLenum; s: TGLshort; t: TGLshort; r: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord3s := TglMultiTexCoord3s(glProcedure('glMultiTexCoord3s'{$IFDEF CLR}, typeof(TglMultiTexCoord3s){$ENDIF}));
  glMultiTexCoord3s(target, s, t, r);
end;

procedure STUB_glMultiTexCoord3sv(target: TGLenum; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord3sv := TglMultiTexCoord3sv(glProcedure('glMultiTexCoord3sv'{$IFDEF CLR}, typeof(TglMultiTexCoord3sv){$ENDIF}));
  glMultiTexCoord3sv(target, v);
end;

procedure STUB_glMultiTexCoord4d(target: TGLenum; s: TGLdouble; t: TGLdouble; r: TGLdouble; q: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord4d := TglMultiTexCoord4d(glProcedure('glMultiTexCoord4d'{$IFDEF CLR}, typeof(TglMultiTexCoord4d){$ENDIF}));
  glMultiTexCoord4d(target, s, t, r, q);
end;

procedure STUB_glMultiTexCoord4dv(target: TGLenum; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord4dv := TglMultiTexCoord4dv(glProcedure('glMultiTexCoord4dv'{$IFDEF CLR}, typeof(TglMultiTexCoord4dv){$ENDIF}));
  glMultiTexCoord4dv(target, v);
end;

procedure STUB_glMultiTexCoord4f(target: TGLenum; s: TGLfloat; t: TGLfloat; r: TGLfloat; q: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord4f := TglMultiTexCoord4f(glProcedure('glMultiTexCoord4f'{$IFDEF CLR}, typeof(TglMultiTexCoord4f){$ENDIF}));
  glMultiTexCoord4f(target, s, t, r, q);
end;

procedure STUB_glMultiTexCoord4fv(target: TGLenum; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord4fv := TglMultiTexCoord4fv(glProcedure('glMultiTexCoord4fv'{$IFDEF CLR}, typeof(TglMultiTexCoord4fv){$ENDIF}));
  glMultiTexCoord4fv(target, v);
end;

procedure STUB_glMultiTexCoord4i(target: TGLenum; s: TGLint; t: TGLint; r: TGLint; q: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord4i := TglMultiTexCoord4i(glProcedure('glMultiTexCoord4i'{$IFDEF CLR}, typeof(TglMultiTexCoord4i){$ENDIF}));
  glMultiTexCoord4i(target, s, t, r, q);
end;

procedure STUB_glMultiTexCoord4iv(target: TGLenum; const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord4iv := TglMultiTexCoord4iv(glProcedure('glMultiTexCoord4iv'{$IFDEF CLR}, typeof(TglMultiTexCoord4iv){$ENDIF}));
  glMultiTexCoord4iv(target, v);
end;

procedure STUB_glMultiTexCoord4s(target: TGLenum; s: TGLshort; t: TGLshort; r: TGLshort; q: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord4s := TglMultiTexCoord4s(glProcedure('glMultiTexCoord4s'{$IFDEF CLR}, typeof(TglMultiTexCoord4s){$ENDIF}));
  glMultiTexCoord4s(target, s, t, r, q);
end;

procedure STUB_glMultiTexCoord4sv(target: TGLenum; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord4sv := TglMultiTexCoord4sv(glProcedure('glMultiTexCoord4sv'{$IFDEF CLR}, typeof(TglMultiTexCoord4sv){$ENDIF}));
  glMultiTexCoord4sv(target, v);
end;

procedure STUB_glLoadTransposeMatrixf(const m: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glLoadTransposeMatrixf := TglLoadTransposeMatrixf(glProcedure('glLoadTransposeMatrixf'{$IFDEF CLR}, typeof(TglLoadTransposeMatrixf){$ENDIF}));
  glLoadTransposeMatrixf(m);
end;

procedure STUB_glLoadTransposeMatrixd(const m: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glLoadTransposeMatrixd := TglLoadTransposeMatrixd(glProcedure('glLoadTransposeMatrixd'{$IFDEF CLR}, typeof(TglLoadTransposeMatrixd){$ENDIF}));
  glLoadTransposeMatrixd(m);
end;

procedure STUB_glMultTransposeMatrixf(const m: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultTransposeMatrixf := TglMultTransposeMatrixf(glProcedure('glMultTransposeMatrixf'{$IFDEF CLR}, typeof(TglMultTransposeMatrixf){$ENDIF}));
  glMultTransposeMatrixf(m);
end;

procedure STUB_glMultTransposeMatrixd(const m: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultTransposeMatrixd := TglMultTransposeMatrixd(glProcedure('glMultTransposeMatrixd'{$IFDEF CLR}, typeof(TglMultTransposeMatrixd){$ENDIF}));
  glMultTransposeMatrixd(m);
end;

procedure STUB_glSampleCoverage(value: TGLclampf; invert: TGLboolean); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glSampleCoverage := TglSampleCoverage(glProcedure('glSampleCoverage'{$IFDEF CLR}, typeof(TglSampleCoverage){$ENDIF}));
  glSampleCoverage(value, invert);
end;

procedure STUB_glCompressedTexImage3D(target: TGLenum; level: TGLint; internalformat: TGLenum; width: TGLsizei; height: TGLsizei; depth: TGLsizei; border: TGLint; imageSize: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCompressedTexImage3D := TglCompressedTexImage3D(glProcedure('glCompressedTexImage3D'{$IFDEF CLR}, typeof(TglCompressedTexImage3D){$ENDIF}));
  glCompressedTexImage3D(target, level, internalformat, width, height, depth, border, imageSize, data);
end;

procedure STUB_glCompressedTexImage2D(target: TGLenum; level: TGLint; internalformat: TGLenum; width: TGLsizei; height: TGLsizei; border: TGLint; imageSize: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCompressedTexImage2D := TglCompressedTexImage2D(glProcedure('glCompressedTexImage2D'{$IFDEF CLR}, typeof(TglCompressedTexImage2D){$ENDIF}));
  glCompressedTexImage2D(target, level, internalformat, width, height, border, imageSize, data);
end;

procedure STUB_glCompressedTexImage1D(target: TGLenum; level: TGLint; internalformat: TGLenum; width: TGLsizei; border: TGLint; imageSize: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCompressedTexImage1D := TglCompressedTexImage1D(glProcedure('glCompressedTexImage1D'{$IFDEF CLR}, typeof(TglCompressedTexImage1D){$ENDIF}));
  glCompressedTexImage1D(target, level, internalformat, width, border, imageSize, data);
end;

procedure STUB_glCompressedTexSubImage3D(target: TGLenum; level: TGLint; xoffset: TGLint; yoffset: TGLint; zoffset: TGLint; width: TGLsizei; height: TGLsizei; depth: TGLsizei; format: TGLenum; imageSize: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCompressedTexSubImage3D := TglCompressedTexSubImage3D(glProcedure('glCompressedTexSubImage3D'{$IFDEF CLR}, typeof(TglCompressedTexSubImage3D){$ENDIF}));
  glCompressedTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
end;

procedure STUB_glCompressedTexSubImage2D(target: TGLenum; level: TGLint; xoffset: TGLint; yoffset: TGLint; width: TGLsizei; height: TGLsizei; format: TGLenum; imageSize: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCompressedTexSubImage2D := TglCompressedTexSubImage2D(glProcedure('glCompressedTexSubImage2D'{$IFDEF CLR}, typeof(TglCompressedTexSubImage2D){$ENDIF}));
  glCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, data);
end;

procedure STUB_glCompressedTexSubImage1D(target: TGLenum; level: TGLint; xoffset: TGLint; width: TGLsizei; format: TGLenum; imageSize: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCompressedTexSubImage1D := TglCompressedTexSubImage1D(glProcedure('glCompressedTexSubImage1D'{$IFDEF CLR}, typeof(TglCompressedTexSubImage1D){$ENDIF}));
  glCompressedTexSubImage1D(target, level, xoffset, width, format, imageSize, data);
end;

procedure STUB_glGetCompressedTexImage(target: TGLenum; level: TGLint; img: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetCompressedTexImage := TglGetCompressedTexImage(glProcedure('glGetCompressedTexImage'{$IFDEF CLR}, typeof(TglGetCompressedTexImage){$ENDIF}));
  glGetCompressedTexImage(target, level, img);
end;

procedure STUB_glBlendFuncSeparate(sfactorRGB: TGLenum; dfactorRGB: TGLenum; sfactorAlpha: TGLenum; dfactorAlpha: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glBlendFuncSeparate := TglBlendFuncSeparate(glProcedure('glBlendFuncSeparate'{$IFDEF CLR}, typeof(TglBlendFuncSeparate){$ENDIF}));
  glBlendFuncSeparate(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
end;

procedure STUB_glFogCoordf(coord: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glFogCoordf := TglFogCoordf(glProcedure('glFogCoordf'{$IFDEF CLR}, typeof(TglFogCoordf){$ENDIF}));
  glFogCoordf(coord);
end;

procedure STUB_glFogCoordfv(const coord: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glFogCoordfv := TglFogCoordfv(glProcedure('glFogCoordfv'{$IFDEF CLR}, typeof(TglFogCoordfv){$ENDIF}));
  glFogCoordfv(coord);
end;

procedure STUB_glFogCoordd(coord: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glFogCoordd := TglFogCoordd(glProcedure('glFogCoordd'{$IFDEF CLR}, typeof(TglFogCoordd){$ENDIF}));
  glFogCoordd(coord);
end;

procedure STUB_glFogCoorddv(const coord: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glFogCoorddv := TglFogCoorddv(glProcedure('glFogCoorddv'{$IFDEF CLR}, typeof(TglFogCoorddv){$ENDIF}));
  glFogCoorddv(coord);
end;

procedure STUB_glFogCoordPointer(_type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glFogCoordPointer := TglFogCoordPointer(glProcedure('glFogCoordPointer'{$IFDEF CLR}, typeof(TglFogCoordPointer){$ENDIF}));
  glFogCoordPointer(_type, stride, _pointer);
end;

procedure STUB_glMultiDrawArrays(mode: TGLenum; first: PGLint; count: PGLsizei; primcount: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiDrawArrays := TglMultiDrawArrays(glProcedure('glMultiDrawArrays'{$IFDEF CLR}, typeof(TglMultiDrawArrays){$ENDIF}));
  glMultiDrawArrays(mode, first, count, primcount);
end;

procedure STUB_glMultiDrawElements(mode: TGLenum; const count: PGLsizei; _type: TGLenum; const indices: PGLvoid; primcount: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiDrawElements := TglMultiDrawElements(glProcedure('glMultiDrawElements'{$IFDEF CLR}, typeof(TglMultiDrawElements){$ENDIF}));
  glMultiDrawElements(mode, count, _type, indices, primcount);
end;

procedure STUB_glPointParameterf(pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPointParameterf := TglPointParameterf(glProcedure('glPointParameterf'{$IFDEF CLR}, typeof(TglPointParameterf){$ENDIF}));
  glPointParameterf(pname, param);
end;

procedure STUB_glPointParameterfv(pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPointParameterfv := TglPointParameterfv(glProcedure('glPointParameterfv'{$IFDEF CLR}, typeof(TglPointParameterfv){$ENDIF}));
  glPointParameterfv(pname, params);
end;

procedure STUB_glPointParameteri(pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPointParameteri := TglPointParameteri(glProcedure('glPointParameteri'{$IFDEF CLR}, typeof(TglPointParameteri){$ENDIF}));
  glPointParameteri(pname, param);
end;

procedure STUB_glPointParameteriv(pname: TGLenum; const params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPointParameteriv := TglPointParameteriv(glProcedure('glPointParameteriv'{$IFDEF CLR}, typeof(TglPointParameteriv){$ENDIF}));
  glPointParameteriv(pname, params);
end;

procedure STUB_glSecondaryColor3b(red: TGLbyte; green: TGLbyte; blue: TGLbyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glSecondaryColor3b := TglSecondaryColor3b(glProcedure('glSecondaryColor3b'{$IFDEF CLR}, typeof(TglSecondaryColor3b){$ENDIF}));
  glSecondaryColor3b(red, green, blue);
end;

procedure STUB_glSecondaryColor3bv(const v: PGLbyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glSecondaryColor3bv := TglSecondaryColor3bv(glProcedure('glSecondaryColor3bv'{$IFDEF CLR}, typeof(TglSecondaryColor3bv){$ENDIF}));
  glSecondaryColor3bv(v);
end;

procedure STUB_glSecondaryColor3d(red: TGLdouble; green: TGLdouble; blue: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glSecondaryColor3d := TglSecondaryColor3d(glProcedure('glSecondaryColor3d'{$IFDEF CLR}, typeof(TglSecondaryColor3d){$ENDIF}));
  glSecondaryColor3d(red, green, blue);
end;

procedure STUB_glSecondaryColor3dv(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glSecondaryColor3dv := TglSecondaryColor3dv(glProcedure('glSecondaryColor3dv'{$IFDEF CLR}, typeof(TglSecondaryColor3dv){$ENDIF}));
  glSecondaryColor3dv(v);
end;

procedure STUB_glSecondaryColor3f(red: TGLfloat; green: TGLfloat; blue: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glSecondaryColor3f := TglSecondaryColor3f(glProcedure('glSecondaryColor3f'{$IFDEF CLR}, typeof(TglSecondaryColor3f){$ENDIF}));
  glSecondaryColor3f(red, green, blue);
end;

procedure STUB_glSecondaryColor3fv(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glSecondaryColor3fv := TglSecondaryColor3fv(glProcedure('glSecondaryColor3fv'{$IFDEF CLR}, typeof(TglSecondaryColor3fv){$ENDIF}));
  glSecondaryColor3fv(v);
end;

procedure STUB_glSecondaryColor3i(red: TGLint; green: TGLint; blue: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glSecondaryColor3i := TglSecondaryColor3i(glProcedure('glSecondaryColor3i'{$IFDEF CLR}, typeof(TglSecondaryColor3i){$ENDIF}));
  glSecondaryColor3i(red, green, blue);
end;

procedure STUB_glSecondaryColor3iv(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glSecondaryColor3iv := TglSecondaryColor3iv(glProcedure('glSecondaryColor3iv'{$IFDEF CLR}, typeof(TglSecondaryColor3iv){$ENDIF}));
  glSecondaryColor3iv(v);
end;

procedure STUB_glSecondaryColor3s(red: TGLshort; green: TGLshort; blue: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glSecondaryColor3s := TglSecondaryColor3s(glProcedure('glSecondaryColor3s'{$IFDEF CLR}, typeof(TglSecondaryColor3s){$ENDIF}));
  glSecondaryColor3s(red, green, blue);
end;

procedure STUB_glSecondaryColor3sv(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glSecondaryColor3sv := TglSecondaryColor3sv(glProcedure('glSecondaryColor3sv'{$IFDEF CLR}, typeof(TglSecondaryColor3sv){$ENDIF}));
  glSecondaryColor3sv(v);
end;

procedure STUB_glSecondaryColor3ub(red: TGLubyte; green: TGLubyte; blue: TGLubyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glSecondaryColor3ub := TglSecondaryColor3ub(glProcedure('glSecondaryColor3ub'{$IFDEF CLR}, typeof(TglSecondaryColor3ub){$ENDIF}));
  glSecondaryColor3ub(red, green, blue);
end;

procedure STUB_glSecondaryColor3ubv(const v: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glSecondaryColor3ubv := TglSecondaryColor3ubv(glProcedure('glSecondaryColor3ubv'{$IFDEF CLR}, typeof(TglSecondaryColor3ubv){$ENDIF}));
  glSecondaryColor3ubv(v);
end;

procedure STUB_glSecondaryColor3ui(red: TGLuint; green: TGLuint; blue: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glSecondaryColor3ui := TglSecondaryColor3ui(glProcedure('glSecondaryColor3ui'{$IFDEF CLR}, typeof(TglSecondaryColor3ui){$ENDIF}));
  glSecondaryColor3ui(red, green, blue);
end;

procedure STUB_glSecondaryColor3uiv(const v: PGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glSecondaryColor3uiv := TglSecondaryColor3uiv(glProcedure('glSecondaryColor3uiv'{$IFDEF CLR}, typeof(TglSecondaryColor3uiv){$ENDIF}));
  glSecondaryColor3uiv(v);
end;

procedure STUB_glSecondaryColor3us(red: TGLushort; green: TGLushort; blue: TGLushort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glSecondaryColor3us := TglSecondaryColor3us(glProcedure('glSecondaryColor3us'{$IFDEF CLR}, typeof(TglSecondaryColor3us){$ENDIF}));
  glSecondaryColor3us(red, green, blue);
end;

procedure STUB_glSecondaryColor3usv(const v: PGLushort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glSecondaryColor3usv := TglSecondaryColor3usv(glProcedure('glSecondaryColor3usv'{$IFDEF CLR}, typeof(TglSecondaryColor3usv){$ENDIF}));
  glSecondaryColor3usv(v);
end;

procedure STUB_glSecondaryColorPointer(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glSecondaryColorPointer := TglSecondaryColorPointer(glProcedure('glSecondaryColorPointer'{$IFDEF CLR}, typeof(TglSecondaryColorPointer){$ENDIF}));
  glSecondaryColorPointer(size, _type, stride, _pointer);
end;

procedure STUB_glWindowPos2d(x: TGLdouble; y: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos2d := TglWindowPos2d(glProcedure('glWindowPos2d'{$IFDEF CLR}, typeof(TglWindowPos2d){$ENDIF}));
  glWindowPos2d(x, y);
end;

procedure STUB_glWindowPos2dv(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos2dv := TglWindowPos2dv(glProcedure('glWindowPos2dv'{$IFDEF CLR}, typeof(TglWindowPos2dv){$ENDIF}));
  glWindowPos2dv(v);
end;

procedure STUB_glWindowPos2f(x: TGLfloat; y: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos2f := TglWindowPos2f(glProcedure('glWindowPos2f'{$IFDEF CLR}, typeof(TglWindowPos2f){$ENDIF}));
  glWindowPos2f(x, y);
end;

procedure STUB_glWindowPos2fv(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos2fv := TglWindowPos2fv(glProcedure('glWindowPos2fv'{$IFDEF CLR}, typeof(TglWindowPos2fv){$ENDIF}));
  glWindowPos2fv(v);
end;

procedure STUB_glWindowPos2i(x: TGLint; y: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos2i := TglWindowPos2i(glProcedure('glWindowPos2i'{$IFDEF CLR}, typeof(TglWindowPos2i){$ENDIF}));
  glWindowPos2i(x, y);
end;

procedure STUB_glWindowPos2iv(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos2iv := TglWindowPos2iv(glProcedure('glWindowPos2iv'{$IFDEF CLR}, typeof(TglWindowPos2iv){$ENDIF}));
  glWindowPos2iv(v);
end;

procedure STUB_glWindowPos2s(x: TGLshort; y: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos2s := TglWindowPos2s(glProcedure('glWindowPos2s'{$IFDEF CLR}, typeof(TglWindowPos2s){$ENDIF}));
  glWindowPos2s(x, y);
end;

procedure STUB_glWindowPos2sv(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos2sv := TglWindowPos2sv(glProcedure('glWindowPos2sv'{$IFDEF CLR}, typeof(TglWindowPos2sv){$ENDIF}));
  glWindowPos2sv(v);
end;

procedure STUB_glWindowPos3d(x: TGLdouble; y: TGLdouble; z: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos3d := TglWindowPos3d(glProcedure('glWindowPos3d'{$IFDEF CLR}, typeof(TglWindowPos3d){$ENDIF}));
  glWindowPos3d(x, y, z);
end;

procedure STUB_glWindowPos3dv(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos3dv := TglWindowPos3dv(glProcedure('glWindowPos3dv'{$IFDEF CLR}, typeof(TglWindowPos3dv){$ENDIF}));
  glWindowPos3dv(v);
end;

procedure STUB_glWindowPos3f(x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos3f := TglWindowPos3f(glProcedure('glWindowPos3f'{$IFDEF CLR}, typeof(TglWindowPos3f){$ENDIF}));
  glWindowPos3f(x, y, z);
end;

procedure STUB_glWindowPos3fv(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos3fv := TglWindowPos3fv(glProcedure('glWindowPos3fv'{$IFDEF CLR}, typeof(TglWindowPos3fv){$ENDIF}));
  glWindowPos3fv(v);
end;

procedure STUB_glWindowPos3i(x: TGLint; y: TGLint; z: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos3i := TglWindowPos3i(glProcedure('glWindowPos3i'{$IFDEF CLR}, typeof(TglWindowPos3i){$ENDIF}));
  glWindowPos3i(x, y, z);
end;

procedure STUB_glWindowPos3iv(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos3iv := TglWindowPos3iv(glProcedure('glWindowPos3iv'{$IFDEF CLR}, typeof(TglWindowPos3iv){$ENDIF}));
  glWindowPos3iv(v);
end;

procedure STUB_glWindowPos3s(x: TGLshort; y: TGLshort; z: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos3s := TglWindowPos3s(glProcedure('glWindowPos3s'{$IFDEF CLR}, typeof(TglWindowPos3s){$ENDIF}));
  glWindowPos3s(x, y, z);
end;

procedure STUB_glWindowPos3sv(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos3sv := TglWindowPos3sv(glProcedure('glWindowPos3sv'{$IFDEF CLR}, typeof(TglWindowPos3sv){$ENDIF}));
  glWindowPos3sv(v);
end;

procedure STUB_glTbufferMask3DFX(mask: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTbufferMask3DFX := TglTbufferMask3DFX(glProcedure('glTbufferMask3DFX'{$IFDEF CLR}, typeof(TglTbufferMask3DFX){$ENDIF}));
  glTbufferMask3DFX(mask);
end;

procedure STUB_glElementPointerAPPLE(_type: TGLenum; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glElementPointerAPPLE := TglElementPointerAPPLE(glProcedure('glElementPointerAPPLE'{$IFDEF CLR}, typeof(TglElementPointerAPPLE){$ENDIF}));
  glElementPointerAPPLE(_type, _pointer);
end;

procedure STUB_glDrawElementArrayAPPLE(mode: TGLenum; first: TGLint; count: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDrawElementArrayAPPLE := TglDrawElementArrayAPPLE(glProcedure('glDrawElementArrayAPPLE'{$IFDEF CLR}, typeof(TglDrawElementArrayAPPLE){$ENDIF}));
  glDrawElementArrayAPPLE(mode, first, count);
end;

procedure STUB_glDrawRangeElementArrayAPPLE(mode: TGLenum; start: TGLuint; _end: TGLuint; first: TGLint; count: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDrawRangeElementArrayAPPLE := TglDrawRangeElementArrayAPPLE(glProcedure('glDrawRangeElementArrayAPPLE'{$IFDEF CLR}, typeof(TglDrawRangeElementArrayAPPLE){$ENDIF}));
  glDrawRangeElementArrayAPPLE(mode, start, _end, first, count);
end;

procedure STUB_glMultiDrawElementArrayAPPLE(mode: TGLenum; const first: PGLint; const count: PGLsizei; primcount: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiDrawElementArrayAPPLE := TglMultiDrawElementArrayAPPLE(glProcedure('glMultiDrawElementArrayAPPLE'{$IFDEF CLR}, typeof(TglMultiDrawElementArrayAPPLE){$ENDIF}));
  glMultiDrawElementArrayAPPLE(mode, first, count, primcount);
end;

procedure STUB_glMultiDrawRangeElementArrayAPPLE(mode: TGLenum; start: TGLuint; _end: TGLuint; const first: PGLint; const count: PGLsizei; primcount: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiDrawRangeElementArrayAPPLE := TglMultiDrawRangeElementArrayAPPLE(glProcedure('glMultiDrawRangeElementArrayAPPLE'{$IFDEF CLR}, typeof(TglMultiDrawRangeElementArrayAPPLE){$ENDIF}));
  glMultiDrawRangeElementArrayAPPLE(mode, start, _end, first, count, primcount);
end;

procedure STUB_glGenFencesAPPLE(n: TGLsizei; fences: PGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGenFencesAPPLE := TglGenFencesAPPLE(glProcedure('glGenFencesAPPLE'{$IFDEF CLR}, typeof(TglGenFencesAPPLE){$ENDIF}));
  glGenFencesAPPLE(n, fences);
end;

procedure STUB_glDeleteFencesAPPLE(n: TGLsizei; const fences: PGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDeleteFencesAPPLE := TglDeleteFencesAPPLE(glProcedure('glDeleteFencesAPPLE'{$IFDEF CLR}, typeof(TglDeleteFencesAPPLE){$ENDIF}));
  glDeleteFencesAPPLE(n, fences);
end;

procedure STUB_glSetFenceAPPLE(fence: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glSetFenceAPPLE := TglSetFenceAPPLE(glProcedure('glSetFenceAPPLE'{$IFDEF CLR}, typeof(TglSetFenceAPPLE){$ENDIF}));
  glSetFenceAPPLE(fence);
end;

function STUB_glIsFenceAPPLE(fence: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glIsFenceAPPLE := TglIsFenceAPPLE(glProcedure('glIsFenceAPPLE'{$IFDEF CLR}, typeof(TglIsFenceAPPLE){$ENDIF}));
  result := glIsFenceAPPLE(fence);
end;

function STUB_glTestFenceAPPLE(fence: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTestFenceAPPLE := TglTestFenceAPPLE(glProcedure('glTestFenceAPPLE'{$IFDEF CLR}, typeof(TglTestFenceAPPLE){$ENDIF}));
  result := glTestFenceAPPLE(fence);
end;

procedure STUB_glFinishFenceAPPLE(fence: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glFinishFenceAPPLE := TglFinishFenceAPPLE(glProcedure('glFinishFenceAPPLE'{$IFDEF CLR}, typeof(TglFinishFenceAPPLE){$ENDIF}));
  glFinishFenceAPPLE(fence);
end;

function STUB_glTestObjectAPPLE(_object: TGLenum; name: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTestObjectAPPLE := TglTestObjectAPPLE(glProcedure('glTestObjectAPPLE'{$IFDEF CLR}, typeof(TglTestObjectAPPLE){$ENDIF}));
  result := glTestObjectAPPLE(_object, name);
end;

procedure STUB_glFinishObjectAPPLE(_object: TGLenum; name: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glFinishObjectAPPLE := TglFinishObjectAPPLE(glProcedure('glFinishObjectAPPLE'{$IFDEF CLR}, typeof(TglFinishObjectAPPLE){$ENDIF}));
  glFinishObjectAPPLE(_object, name);
end;

procedure STUB_glBindVertexArrayAPPLE(_array: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glBindVertexArrayAPPLE := TglBindVertexArrayAPPLE(glProcedure('glBindVertexArrayAPPLE'{$IFDEF CLR}, typeof(TglBindVertexArrayAPPLE){$ENDIF}));
  glBindVertexArrayAPPLE(_array);
end;

procedure STUB_glDeleteVertexArraysAPPLE(n: TGLsizei; const arrays: PGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDeleteVertexArraysAPPLE := TglDeleteVertexArraysAPPLE(glProcedure('glDeleteVertexArraysAPPLE'{$IFDEF CLR}, typeof(TglDeleteVertexArraysAPPLE){$ENDIF}));
  glDeleteVertexArraysAPPLE(n, arrays);
end;

procedure STUB_glGenVertexArraysAPPLE(n: TGLsizei; const arrays: PGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGenVertexArraysAPPLE := TglGenVertexArraysAPPLE(glProcedure('glGenVertexArraysAPPLE'{$IFDEF CLR}, typeof(TglGenVertexArraysAPPLE){$ENDIF}));
  glGenVertexArraysAPPLE(n, arrays);
end;

function STUB_glIsVertexArrayAPPLE(_array: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glIsVertexArrayAPPLE := TglIsVertexArrayAPPLE(glProcedure('glIsVertexArrayAPPLE'{$IFDEF CLR}, typeof(TglIsVertexArrayAPPLE){$ENDIF}));
  result := glIsVertexArrayAPPLE(_array);
end;

procedure STUB_glVertexArrayRangeAPPLE(length: TGLsizei; _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexArrayRangeAPPLE := TglVertexArrayRangeAPPLE(glProcedure('glVertexArrayRangeAPPLE'{$IFDEF CLR}, typeof(TglVertexArrayRangeAPPLE){$ENDIF}));
  glVertexArrayRangeAPPLE(length, _pointer);
end;

procedure STUB_glFlushVertexArrayRangeAPPLE(length: TGLsizei; _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glFlushVertexArrayRangeAPPLE := TglFlushVertexArrayRangeAPPLE(glProcedure('glFlushVertexArrayRangeAPPLE'{$IFDEF CLR}, typeof(TglFlushVertexArrayRangeAPPLE){$ENDIF}));
  glFlushVertexArrayRangeAPPLE(length, _pointer);
end;

procedure STUB_glVertexArrayParameteriAPPLE(pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexArrayParameteriAPPLE := TglVertexArrayParameteriAPPLE(glProcedure('glVertexArrayParameteriAPPLE'{$IFDEF CLR}, typeof(TglVertexArrayParameteriAPPLE){$ENDIF}));
  glVertexArrayParameteriAPPLE(pname, param);
end;

procedure STUB_glCurrentPaletteMatrixARB(index: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCurrentPaletteMatrixARB := TglCurrentPaletteMatrixARB(glProcedure('glCurrentPaletteMatrixARB'{$IFDEF CLR}, typeof(TglCurrentPaletteMatrixARB){$ENDIF}));
  glCurrentPaletteMatrixARB(index);
end;

procedure STUB_glMatrixIndexubvARB(size: TGLint; const indices: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMatrixIndexubvARB := TglMatrixIndexubvARB(glProcedure('glMatrixIndexubvARB'{$IFDEF CLR}, typeof(TglMatrixIndexubvARB){$ENDIF}));
  glMatrixIndexubvARB(size, indices);
end;

procedure STUB_glMatrixIndexusvARB(size: TGLint; const indices: PGLushort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMatrixIndexusvARB := TglMatrixIndexusvARB(glProcedure('glMatrixIndexusvARB'{$IFDEF CLR}, typeof(TglMatrixIndexusvARB){$ENDIF}));
  glMatrixIndexusvARB(size, indices);
end;

procedure STUB_glMatrixIndexuivARB(size: TGLint; const indices: PGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMatrixIndexuivARB := TglMatrixIndexuivARB(glProcedure('glMatrixIndexuivARB'{$IFDEF CLR}, typeof(TglMatrixIndexuivARB){$ENDIF}));
  glMatrixIndexuivARB(size, indices);
end;

procedure STUB_glMatrixIndexPointerARB(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMatrixIndexPointerARB := TglMatrixIndexPointerARB(glProcedure('glMatrixIndexPointerARB'{$IFDEF CLR}, typeof(TglMatrixIndexPointerARB){$ENDIF}));
  glMatrixIndexPointerARB(size, _type, stride, _pointer);
end;

procedure STUB_glSampleCoverageARB(value: TGLclampf; invert: TGLboolean); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glSampleCoverageARB := TglSampleCoverageARB(glProcedure('glSampleCoverageARB'{$IFDEF CLR}, typeof(TglSampleCoverageARB){$ENDIF}));
  glSampleCoverageARB(value, invert);
end;

procedure STUB_glActiveTextureARB(texture: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glActiveTextureARB := TglActiveTextureARB(glProcedure('glActiveTextureARB'{$IFDEF CLR}, typeof(TglActiveTextureARB){$ENDIF}));
  glActiveTextureARB(texture);
end;

procedure STUB_glClientActiveTextureARB(texture: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glClientActiveTextureARB := TglClientActiveTextureARB(glProcedure('glClientActiveTextureARB'{$IFDEF CLR}, typeof(TglClientActiveTextureARB){$ENDIF}));
  glClientActiveTextureARB(texture);
end;

procedure STUB_glMultiTexCoord1dARB(target: TGLenum; s: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord1dARB := TglMultiTexCoord1dARB(glProcedure('glMultiTexCoord1dARB'{$IFDEF CLR}, typeof(TglMultiTexCoord1dARB){$ENDIF}));
  glMultiTexCoord1dARB(target, s);
end;

procedure STUB_glMultiTexCoord1dvARB(target: TGLenum; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord1dvARB := TglMultiTexCoord1dvARB(glProcedure('glMultiTexCoord1dvARB'{$IFDEF CLR}, typeof(TglMultiTexCoord1dvARB){$ENDIF}));
  glMultiTexCoord1dvARB(target, v);
end;

procedure STUB_glMultiTexCoord1fARB(target: TGLenum; s: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord1fARB := TglMultiTexCoord1fARB(glProcedure('glMultiTexCoord1fARB'{$IFDEF CLR}, typeof(TglMultiTexCoord1fARB){$ENDIF}));
  glMultiTexCoord1fARB(target, s);
end;

procedure STUB_glMultiTexCoord1fvARB(target: TGLenum; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord1fvARB := TglMultiTexCoord1fvARB(glProcedure('glMultiTexCoord1fvARB'{$IFDEF CLR}, typeof(TglMultiTexCoord1fvARB){$ENDIF}));
  glMultiTexCoord1fvARB(target, v);
end;

procedure STUB_glMultiTexCoord1iARB(target: TGLenum; s: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord1iARB := TglMultiTexCoord1iARB(glProcedure('glMultiTexCoord1iARB'{$IFDEF CLR}, typeof(TglMultiTexCoord1iARB){$ENDIF}));
  glMultiTexCoord1iARB(target, s);
end;

procedure STUB_glMultiTexCoord1ivARB(target: TGLenum; const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord1ivARB := TglMultiTexCoord1ivARB(glProcedure('glMultiTexCoord1ivARB'{$IFDEF CLR}, typeof(TglMultiTexCoord1ivARB){$ENDIF}));
  glMultiTexCoord1ivARB(target, v);
end;

procedure STUB_glMultiTexCoord1sARB(target: TGLenum; s: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord1sARB := TglMultiTexCoord1sARB(glProcedure('glMultiTexCoord1sARB'{$IFDEF CLR}, typeof(TglMultiTexCoord1sARB){$ENDIF}));
  glMultiTexCoord1sARB(target, s);
end;

procedure STUB_glMultiTexCoord1svARB(target: TGLenum; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord1svARB := TglMultiTexCoord1svARB(glProcedure('glMultiTexCoord1svARB'{$IFDEF CLR}, typeof(TglMultiTexCoord1svARB){$ENDIF}));
  glMultiTexCoord1svARB(target, v);
end;

procedure STUB_glMultiTexCoord2dARB(target: TGLenum; s: TGLdouble; t: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord2dARB := TglMultiTexCoord2dARB(glProcedure('glMultiTexCoord2dARB'{$IFDEF CLR}, typeof(TglMultiTexCoord2dARB){$ENDIF}));
  glMultiTexCoord2dARB(target, s, t);
end;

procedure STUB_glMultiTexCoord2dvARB(target: TGLenum; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord2dvARB := TglMultiTexCoord2dvARB(glProcedure('glMultiTexCoord2dvARB'{$IFDEF CLR}, typeof(TglMultiTexCoord2dvARB){$ENDIF}));
  glMultiTexCoord2dvARB(target, v);
end;

procedure STUB_glMultiTexCoord2fARB(target: TGLenum; s: TGLfloat; t: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord2fARB := TglMultiTexCoord2fARB(glProcedure('glMultiTexCoord2fARB'{$IFDEF CLR}, typeof(TglMultiTexCoord2fARB){$ENDIF}));
  glMultiTexCoord2fARB(target, s, t);
end;

procedure STUB_glMultiTexCoord2fvARB(target: TGLenum; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord2fvARB := TglMultiTexCoord2fvARB(glProcedure('glMultiTexCoord2fvARB'{$IFDEF CLR}, typeof(TglMultiTexCoord2fvARB){$ENDIF}));
  glMultiTexCoord2fvARB(target, v);
end;

procedure STUB_glMultiTexCoord2iARB(target: TGLenum; s: TGLint; t: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord2iARB := TglMultiTexCoord2iARB(glProcedure('glMultiTexCoord2iARB'{$IFDEF CLR}, typeof(TglMultiTexCoord2iARB){$ENDIF}));
  glMultiTexCoord2iARB(target, s, t);
end;

procedure STUB_glMultiTexCoord2ivARB(target: TGLenum; const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord2ivARB := TglMultiTexCoord2ivARB(glProcedure('glMultiTexCoord2ivARB'{$IFDEF CLR}, typeof(TglMultiTexCoord2ivARB){$ENDIF}));
  glMultiTexCoord2ivARB(target, v);
end;

procedure STUB_glMultiTexCoord2sARB(target: TGLenum; s: TGLshort; t: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord2sARB := TglMultiTexCoord2sARB(glProcedure('glMultiTexCoord2sARB'{$IFDEF CLR}, typeof(TglMultiTexCoord2sARB){$ENDIF}));
  glMultiTexCoord2sARB(target, s, t);
end;

procedure STUB_glMultiTexCoord2svARB(target: TGLenum; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord2svARB := TglMultiTexCoord2svARB(glProcedure('glMultiTexCoord2svARB'{$IFDEF CLR}, typeof(TglMultiTexCoord2svARB){$ENDIF}));
  glMultiTexCoord2svARB(target, v);
end;

procedure STUB_glMultiTexCoord3dARB(target: TGLenum; s: TGLdouble; t: TGLdouble; r: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord3dARB := TglMultiTexCoord3dARB(glProcedure('glMultiTexCoord3dARB'{$IFDEF CLR}, typeof(TglMultiTexCoord3dARB){$ENDIF}));
  glMultiTexCoord3dARB(target, s, t, r);
end;

procedure STUB_glMultiTexCoord3dvARB(target: TGLenum; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord3dvARB := TglMultiTexCoord3dvARB(glProcedure('glMultiTexCoord3dvARB'{$IFDEF CLR}, typeof(TglMultiTexCoord3dvARB){$ENDIF}));
  glMultiTexCoord3dvARB(target, v);
end;

procedure STUB_glMultiTexCoord3fARB(target: TGLenum; s: TGLfloat; t: TGLfloat; r: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord3fARB := TglMultiTexCoord3fARB(glProcedure('glMultiTexCoord3fARB'{$IFDEF CLR}, typeof(TglMultiTexCoord3fARB){$ENDIF}));
  glMultiTexCoord3fARB(target, s, t, r);
end;

procedure STUB_glMultiTexCoord3fvARB(target: TGLenum; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord3fvARB := TglMultiTexCoord3fvARB(glProcedure('glMultiTexCoord3fvARB'{$IFDEF CLR}, typeof(TglMultiTexCoord3fvARB){$ENDIF}));
  glMultiTexCoord3fvARB(target, v);
end;

procedure STUB_glMultiTexCoord3iARB(target: TGLenum; s: TGLint; t: TGLint; r: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord3iARB := TglMultiTexCoord3iARB(glProcedure('glMultiTexCoord3iARB'{$IFDEF CLR}, typeof(TglMultiTexCoord3iARB){$ENDIF}));
  glMultiTexCoord3iARB(target, s, t, r);
end;

procedure STUB_glMultiTexCoord3ivARB(target: TGLenum; const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord3ivARB := TglMultiTexCoord3ivARB(glProcedure('glMultiTexCoord3ivARB'{$IFDEF CLR}, typeof(TglMultiTexCoord3ivARB){$ENDIF}));
  glMultiTexCoord3ivARB(target, v);
end;

procedure STUB_glMultiTexCoord3sARB(target: TGLenum; s: TGLshort; t: TGLshort; r: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord3sARB := TglMultiTexCoord3sARB(glProcedure('glMultiTexCoord3sARB'{$IFDEF CLR}, typeof(TglMultiTexCoord3sARB){$ENDIF}));
  glMultiTexCoord3sARB(target, s, t, r);
end;

procedure STUB_glMultiTexCoord3svARB(target: TGLenum; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord3svARB := TglMultiTexCoord3svARB(glProcedure('glMultiTexCoord3svARB'{$IFDEF CLR}, typeof(TglMultiTexCoord3svARB){$ENDIF}));
  glMultiTexCoord3svARB(target, v);
end;

procedure STUB_glMultiTexCoord4dARB(target: TGLenum; s: TGLdouble; t: TGLdouble; r: TGLdouble; q: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord4dARB := TglMultiTexCoord4dARB(glProcedure('glMultiTexCoord4dARB'{$IFDEF CLR}, typeof(TglMultiTexCoord4dARB){$ENDIF}));
  glMultiTexCoord4dARB(target, s, t, r, q);
end;

procedure STUB_glMultiTexCoord4dvARB(target: TGLenum; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord4dvARB := TglMultiTexCoord4dvARB(glProcedure('glMultiTexCoord4dvARB'{$IFDEF CLR}, typeof(TglMultiTexCoord4dvARB){$ENDIF}));
  glMultiTexCoord4dvARB(target, v);
end;

procedure STUB_glMultiTexCoord4fARB(target: TGLenum; s: TGLfloat; t: TGLfloat; r: TGLfloat; q: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord4fARB := TglMultiTexCoord4fARB(glProcedure('glMultiTexCoord4fARB'{$IFDEF CLR}, typeof(TglMultiTexCoord4fARB){$ENDIF}));
  glMultiTexCoord4fARB(target, s, t, r, q);
end;

procedure STUB_glMultiTexCoord4fvARB(target: TGLenum; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord4fvARB := TglMultiTexCoord4fvARB(glProcedure('glMultiTexCoord4fvARB'{$IFDEF CLR}, typeof(TglMultiTexCoord4fvARB){$ENDIF}));
  glMultiTexCoord4fvARB(target, v);
end;

procedure STUB_glMultiTexCoord4iARB(target: TGLenum; s: TGLint; t: TGLint; r: TGLint; q: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord4iARB := TglMultiTexCoord4iARB(glProcedure('glMultiTexCoord4iARB'{$IFDEF CLR}, typeof(TglMultiTexCoord4iARB){$ENDIF}));
  glMultiTexCoord4iARB(target, s, t, r, q);
end;

procedure STUB_glMultiTexCoord4ivARB(target: TGLenum; const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord4ivARB := TglMultiTexCoord4ivARB(glProcedure('glMultiTexCoord4ivARB'{$IFDEF CLR}, typeof(TglMultiTexCoord4ivARB){$ENDIF}));
  glMultiTexCoord4ivARB(target, v);
end;

procedure STUB_glMultiTexCoord4sARB(target: TGLenum; s: TGLshort; t: TGLshort; r: TGLshort; q: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord4sARB := TglMultiTexCoord4sARB(glProcedure('glMultiTexCoord4sARB'{$IFDEF CLR}, typeof(TglMultiTexCoord4sARB){$ENDIF}));
  glMultiTexCoord4sARB(target, s, t, r, q);
end;

procedure STUB_glMultiTexCoord4svARB(target: TGLenum; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultiTexCoord4svARB := TglMultiTexCoord4svARB(glProcedure('glMultiTexCoord4svARB'{$IFDEF CLR}, typeof(TglMultiTexCoord4svARB){$ENDIF}));
  glMultiTexCoord4svARB(target, v);
end;

procedure STUB_glPointParameterfARB(pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPointParameterfARB := TglPointParameterfARB(glProcedure('glPointParameterfARB'{$IFDEF CLR}, typeof(TglPointParameterfARB){$ENDIF}));
  glPointParameterfARB(pname, param);
end;

procedure STUB_glPointParameterfvARB(pname: TGLenum; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPointParameterfvARB := TglPointParameterfvARB(glProcedure('glPointParameterfvARB'{$IFDEF CLR}, typeof(TglPointParameterfvARB){$ENDIF}));
  glPointParameterfvARB(pname, params);
end;

procedure STUB_glCompressedTexImage3DARB(target: TGLenum; level: TGLint; internalformat: TGLenum; width: TGLsizei; height: TGLsizei; depth: TGLsizei; border: TGLint; imageSize: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCompressedTexImage3DARB := TglCompressedTexImage3DARB(glProcedure('glCompressedTexImage3DARB'{$IFDEF CLR}, typeof(TglCompressedTexImage3DARB){$ENDIF}));
  glCompressedTexImage3DARB(target, level, internalformat, width, height, depth, border, imageSize, data);
end;

procedure STUB_glCompressedTexImage2DARB(target: TGLenum; level: TGLint; internalformat: TGLenum; width: TGLsizei; height: TGLsizei; border: TGLint; imageSize: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCompressedTexImage2DARB := TglCompressedTexImage2DARB(glProcedure('glCompressedTexImage2DARB'{$IFDEF CLR}, typeof(TglCompressedTexImage2DARB){$ENDIF}));
  glCompressedTexImage2DARB(target, level, internalformat, width, height, border, imageSize, data);
end;

procedure STUB_glCompressedTexImage1DARB(target: TGLenum; level: TGLint; internalformat: TGLenum; width: TGLsizei; border: TGLint; imageSize: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCompressedTexImage1DARB := TglCompressedTexImage1DARB(glProcedure('glCompressedTexImage1DARB'{$IFDEF CLR}, typeof(TglCompressedTexImage1DARB){$ENDIF}));
  glCompressedTexImage1DARB(target, level, internalformat, width, border, imageSize, data);
end;

procedure STUB_glCompressedTexSubImage3DARB(target: TGLenum; level: TGLint; xoffset: TGLint; yoffset: TGLint; zoffset: TGLint; width: TGLsizei; height: TGLsizei; depth: TGLsizei; format: TGLenum; imageSize: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCompressedTexSubImage3DARB := TglCompressedTexSubImage3DARB(glProcedure('glCompressedTexSubImage3DARB'{$IFDEF CLR}, typeof(TglCompressedTexSubImage3DARB){$ENDIF}));
  glCompressedTexSubImage3DARB(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
end;

procedure STUB_glCompressedTexSubImage2DARB(target: TGLenum; level: TGLint; xoffset: TGLint; yoffset: TGLint; width: TGLsizei; height: TGLsizei; format: TGLenum; imageSize: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCompressedTexSubImage2DARB := TglCompressedTexSubImage2DARB(glProcedure('glCompressedTexSubImage2DARB'{$IFDEF CLR}, typeof(TglCompressedTexSubImage2DARB){$ENDIF}));
  glCompressedTexSubImage2DARB(target, level, xoffset, yoffset, width, height, format, imageSize, data);
end;

procedure STUB_glCompressedTexSubImage1DARB(target: TGLenum; level: TGLint; xoffset: TGLint; width: TGLsizei; format: TGLenum; imageSize: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glCompressedTexSubImage1DARB := TglCompressedTexSubImage1DARB(glProcedure('glCompressedTexSubImage1DARB'{$IFDEF CLR}, typeof(TglCompressedTexSubImage1DARB){$ENDIF}));
  glCompressedTexSubImage1DARB(target, level, xoffset, width, format, imageSize, data);
end;

procedure STUB_glGetCompressedTexImageARB(target: TGLenum; level: TGLint; img: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetCompressedTexImageARB := TglGetCompressedTexImageARB(glProcedure('glGetCompressedTexImageARB'{$IFDEF CLR}, typeof(TglGetCompressedTexImageARB){$ENDIF}));
  glGetCompressedTexImageARB(target, level, img);
end;

procedure STUB_glLoadTransposeMatrixfARB(const m: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glLoadTransposeMatrixfARB := TglLoadTransposeMatrixfARB(glProcedure('glLoadTransposeMatrixfARB'{$IFDEF CLR}, typeof(TglLoadTransposeMatrixfARB){$ENDIF}));
  glLoadTransposeMatrixfARB(m);
end;

procedure STUB_glLoadTransposeMatrixdARB(const m: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glLoadTransposeMatrixdARB := TglLoadTransposeMatrixdARB(glProcedure('glLoadTransposeMatrixdARB'{$IFDEF CLR}, typeof(TglLoadTransposeMatrixdARB){$ENDIF}));
  glLoadTransposeMatrixdARB(m);
end;

procedure STUB_glMultTransposeMatrixfARB(const m: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultTransposeMatrixfARB := TglMultTransposeMatrixfARB(glProcedure('glMultTransposeMatrixfARB'{$IFDEF CLR}, typeof(TglMultTransposeMatrixfARB){$ENDIF}));
  glMultTransposeMatrixfARB(m);
end;

procedure STUB_glMultTransposeMatrixdARB(const m: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMultTransposeMatrixdARB := TglMultTransposeMatrixdARB(glProcedure('glMultTransposeMatrixdARB'{$IFDEF CLR}, typeof(TglMultTransposeMatrixdARB){$ENDIF}));
  glMultTransposeMatrixdARB(m);
end;

procedure STUB_glWeightbvARB(size: TGLint; const weights: PGLbyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWeightbvARB := TglWeightbvARB(glProcedure('glWeightbvARB'{$IFDEF CLR}, typeof(TglWeightbvARB){$ENDIF}));
  glWeightbvARB(size, weights);
end;

procedure STUB_glWeightsvARB(size: TGLint; const weights: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWeightsvARB := TglWeightsvARB(glProcedure('glWeightsvARB'{$IFDEF CLR}, typeof(TglWeightsvARB){$ENDIF}));
  glWeightsvARB(size, weights);
end;

procedure STUB_glWeightivARB(size: TGLint; const weights: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWeightivARB := TglWeightivARB(glProcedure('glWeightivARB'{$IFDEF CLR}, typeof(TglWeightivARB){$ENDIF}));
  glWeightivARB(size, weights);
end;

procedure STUB_glWeightfvARB(size: TGLint; const weights: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWeightfvARB := TglWeightfvARB(glProcedure('glWeightfvARB'{$IFDEF CLR}, typeof(TglWeightfvARB){$ENDIF}));
  glWeightfvARB(size, weights);
end;

procedure STUB_glWeightdvARB(size: TGLint; const weights: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWeightdvARB := TglWeightdvARB(glProcedure('glWeightdvARB'{$IFDEF CLR}, typeof(TglWeightdvARB){$ENDIF}));
  glWeightdvARB(size, weights);
end;

procedure STUB_glWeightubvARB(size: TGLint; const weights: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWeightubvARB := TglWeightubvARB(glProcedure('glWeightubvARB'{$IFDEF CLR}, typeof(TglWeightubvARB){$ENDIF}));
  glWeightubvARB(size, weights);
end;

procedure STUB_glWeightusvARB(size: TGLint; const weights: PGLushort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWeightusvARB := TglWeightusvARB(glProcedure('glWeightusvARB'{$IFDEF CLR}, typeof(TglWeightusvARB){$ENDIF}));
  glWeightusvARB(size, weights);
end;

procedure STUB_glWeightuivARB(size: TGLint; const weights: PGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWeightuivARB := TglWeightuivARB(glProcedure('glWeightuivARB'{$IFDEF CLR}, typeof(TglWeightuivARB){$ENDIF}));
  glWeightuivARB(size, weights);
end;

procedure STUB_glWeightPointerARB(size: TGLint; _type: TGLenum; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWeightPointerARB := TglWeightPointerARB(glProcedure('glWeightPointerARB'{$IFDEF CLR}, typeof(TglWeightPointerARB){$ENDIF}));
  glWeightPointerARB(size, _type, stride, _pointer);
end;

procedure STUB_glVertexBlendARB(count: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexBlendARB := TglVertexBlendARB(glProcedure('glVertexBlendARB'{$IFDEF CLR}, typeof(TglVertexBlendARB){$ENDIF}));
  glVertexBlendARB(count);
end;

procedure STUB_glBindBufferARB(target: TGLenum; buffer: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glBindBufferARB := TglBindBufferARB(glProcedure('glBindBufferARB'{$IFDEF CLR}, typeof(TglBindBufferARB){$ENDIF}));
  glBindBufferARB(target, buffer);
end;

procedure STUB_glDeleteBuffersARB(n: TGLsizei; const buffers: PGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDeleteBuffersARB := TglDeleteBuffersARB(glProcedure('glDeleteBuffersARB'{$IFDEF CLR}, typeof(TglDeleteBuffersARB){$ENDIF}));
  glDeleteBuffersARB(n, buffers);
end;

procedure STUB_glGenBuffersARB(n: TGLsizei; buffers: PGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGenBuffersARB := TglGenBuffersARB(glProcedure('glGenBuffersARB'{$IFDEF CLR}, typeof(TglGenBuffersARB){$ENDIF}));
  glGenBuffersARB(n, buffers);
end;

function STUB_glIsBufferARB(buffer: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glIsBufferARB := TglIsBufferARB(glProcedure('glIsBufferARB'{$IFDEF CLR}, typeof(TglIsBufferARB){$ENDIF}));
  result := glIsBufferARB(buffer);
end;

procedure STUB_glBufferDataARB(target: TGLenum; size: TGLsizei; const data: PGLvoid; usage: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  _glBufferDataARB := TglBufferDataARB(glProcedure('glBufferDataARB'{$IFDEF CLR}, typeof(TglBufferDataARB){$ENDIF}));
  _glBufferDataARB(target, size, data, usage);
end;

procedure STUB_glBufferSubDataARB(target: TGLenum; offset: TGLsizei; size: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  _glBufferSubDataARB := TglBufferSubDataARB(glProcedure('glBufferSubDataARB'{$IFDEF CLR}, typeof(TglBufferSubDataARB){$ENDIF}));
  _glBufferSubDataARB(target, offset, size, data);
end;

procedure STUB_glGetBufferSubDataARB(target: TGLenum; offset: TGLsizei; size: TGLsizei; data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetBufferSubDataARB := TglGetBufferSubDataARB(glProcedure('glGetBufferSubDataARB'{$IFDEF CLR}, typeof(TglGetBufferSubDataARB){$ENDIF}));
  glGetBufferSubDataARB(target, offset, size, data);
end;

function STUB_glMapBufferARB(target: TGLenum; access: TGLenum): PGLvoid; {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMapBufferARB := TglMapBufferARB(glProcedure('glMapBufferARB'{$IFDEF CLR}, typeof(TglMapBufferARB){$ENDIF}));
  result := glMapBufferARB(target, access);
end;

function STUB_glUnmapBufferARB(target: TGLenum): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glUnmapBufferARB := TglUnmapBufferARB(glProcedure('glUnmapBufferARB'{$IFDEF CLR}, typeof(TglUnmapBufferARB){$ENDIF}));
  result := glUnmapBufferARB(target);
end;

procedure STUB_glGetBufferParameterivARB(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetBufferParameterivARB := TglGetBufferParameterivARB(glProcedure('glGetBufferParameterivARB'{$IFDEF CLR}, typeof(TglGetBufferParameterivARB){$ENDIF}));
  glGetBufferParameterivARB(target, pname, params);
end;

procedure STUB_glGetBufferPointervARB(target: TGLenum; pname: TGLenum; params: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetBufferPointervARB := TglGetBufferPointervARB(glProcedure('glGetBufferPointervARB'{$IFDEF CLR}, typeof(TglGetBufferPointervARB){$ENDIF}));
  glGetBufferPointervARB(target, pname, params);
end;

procedure STUB_glBindBuffer(target: TGLenum; buffer: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glBindBuffer := TglBindBuffer(glProcedure('glBindBuffer'{$IFDEF CLR}, typeof(TglBindBuffer){$ENDIF}));
  glBindBuffer(target, buffer);
end;

procedure STUB_glDeleteBuffers(n: TGLsizei; const buffers: PGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDeleteBuffers := TglDeleteBuffers(glProcedure('glDeleteBuffers'{$IFDEF CLR}, typeof(TglDeleteBuffers){$ENDIF}));
  glDeleteBuffers(n, buffers);
end;

procedure STUB_glGenBuffers(n: TGLsizei; buffers: PGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGenBuffers := TglGenBuffers(glProcedure('glGenBuffers'{$IFDEF CLR}, typeof(TglGenBuffers){$ENDIF}));
  glGenBuffers(n, buffers);
end;

function STUB_glIsBuffer(buffer: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glIsBuffer := TglIsBuffer(glProcedure('glIsBuffer'{$IFDEF CLR}, typeof(TglIsBuffer){$ENDIF}));
  result := glIsBuffer(buffer);
end;

procedure STUB_glBufferData(target: TGLenum; size: TGLsizei; const data: PGLvoid; usage: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  _glBufferData := TglBufferData(glProcedure('glBufferData'{$IFDEF CLR}, typeof(TglBufferData){$ENDIF}));
  _glBufferData(target, size, data, usage);
end;

procedure STUB_glBufferSubData(target: TGLenum; offset: TGLsizei; size: TGLsizei; const data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  _glBufferSubData := TglBufferSubData(glProcedure('glBufferSubData'{$IFDEF CLR}, typeof(TglBufferSubData){$ENDIF}));
  _glBufferSubData(target, offset, size, data);
end;

procedure STUB_glGetBufferSubData(target: TGLenum; offset: TGLsizei; size: TGLsizei; data: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetBufferSubData := TglGetBufferSubData(glProcedure('glGetBufferSubData'{$IFDEF CLR}, typeof(TglGetBufferSubData){$ENDIF}));
  glGetBufferSubData(target, offset, size, data);
end;

function STUB_glMapBuffer(target: TGLenum; access: TGLenum): PGLvoid; {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMapBuffer := TglMapBuffer(glProcedure('glMapBuffer'{$IFDEF CLR}, typeof(TglMapBuffer){$ENDIF}));
  result := glMapBuffer(target, access);
end;

function STUB_glUnmapBuffer(target: TGLenum): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glUnmapBuffer := TglUnmapBuffer(glProcedure('glUnmapBuffer'{$IFDEF CLR}, typeof(TglUnmapBuffer){$ENDIF}));
  result := glUnmapBuffer(target);
end;

procedure STUB_glGetBufferParameteriv(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetBufferParameteriv := TglGetBufferParameteriv(glProcedure('glGetBufferParameteriv'{$IFDEF CLR}, typeof(TglGetBufferParameteriv){$ENDIF}));
  glGetBufferParameteriv(target, pname, params);
end;

procedure STUB_glGetBufferPointerv(target: TGLenum; pname: TGLenum; params: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetBufferPointerv := TglGetBufferPointerv(glProcedure('glGetBufferPointerv'{$IFDEF CLR}, typeof(TglGetBufferPointerv){$ENDIF}));
  glGetBufferPointerv(target, pname, params);
end;

procedure STUB_glBlendEquationSeparate(modeRGB: GLenum; modeAlpha: GLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glBlendEquationSeparate := TglBlendEquationSeparate(wglGetProcAddress('glBlendEquationSeparate'{$IFDEF CLR}, typeof(TglBlendEquationSeparate){$ENDIF}));
  glBlendEquationSeparate(modeRGB, modeAlpha);
end;

procedure STUB_glDrawBuffers(n: GLsizei; const bufs: PGLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glDrawBuffers := TglDrawBuffers(wglGetProcAddress('glDrawBuffers'{$IFDEF CLR}, typeof(TglDrawBuffers){$ENDIF}));
  glDrawBuffers(n, bufs);
end;

procedure STUB_glStencilOpSeparate(face: GLenum; sfail: GLenum; dpfail: GLenum; dppass: GLenum); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glStencilOpSeparate := TglStencilOpSeparate(wglGetProcAddress('glStencilOpSeparate'{$IFDEF CLR}, typeof(TglStencilOpSeparate){$ENDIF}));
  glStencilOpSeparate(face, sfail, dpfail, dppass);
end;

procedure STUB_glStencilFuncSeparate(frontfunc: GLenum; backfunc: GLenum; ref: GLint; mask: GLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glStencilFuncSeparate := TglStencilFuncSeparate(wglGetProcAddress('glStencilFuncSeparate'{$IFDEF CLR}, typeof(TglStencilFuncSeparate){$ENDIF}));
  glStencilFuncSeparate(frontfunc, backfunc, ref, mask);
end;

procedure STUB_glStencilMaskSeparate(face: GLenum; mask: GLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glStencilMaskSeparate := TglStencilMaskSeparate(wglGetProcAddress('glStencilMaskSeparate'{$IFDEF CLR}, typeof(TglStencilMaskSeparate){$ENDIF}));
  glStencilMaskSeparate(face, mask);
end;

procedure STUB_glAttachShader(programObj, shaderObj: GLhandleARB); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glAttachShader := TglAttachShader(wglGetProcAddress('glAttachShader'{$IFDEF CLR}, typeof(TglAttachShader){$ENDIF}));
  glAttachShader(programObj, shaderObj);
end;

procedure STUB_glBindAttribLocation(programObj: GLhandleARB; index: GLuint; name: PChar); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glBindAttribLocation := TglBindAttribLocation(wglGetProcAddress('glBindAttribLocation'{$IFDEF CLR}, typeof(TglBindAttribLocation){$ENDIF}));
  glBindAttribLocation(programObj, index, name);
end;

procedure STUB_glCompileShader(shaderObj: GLhandleARB); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glCompileShader := TglCompileShader(wglGetProcAddress('glCompileShader'{$IFDEF CLR}, typeof(TglCompileShader){$ENDIF}));
  glCompileShader(shaderObj);
end;

function STUB_glCreateProgram: GLhandleARB; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glCreateProgram := TglCreateProgram(wglGetProcAddress('glCreateProgram'{$IFDEF CLR}, typeof(TglCreateProgram){$ENDIF}));
  Result := glCreateProgram;
end;

function STUB_glCreateShader(shaderType: GLenum): GLhandleARB; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glCreateShader := TglCreateShader(wglGetProcAddress('glCreateShader'{$IFDEF CLR}, typeof(TglCreateShader){$ENDIF}));
  Result := glCreateShader(shaderType);
end;

procedure STUB_glDeleteProgram(programObj: GLhandleARB); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glDeleteProgram := TglDeleteProgram(wglGetProcAddress('glDeleteProgram'{$IFDEF CLR}, typeof(TglDeleteProgram){$ENDIF}));
  glDeleteProgram(programObj);
end;

procedure STUB_glDeleteShader(shaderObj: GLhandleARB); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glDeleteShader := TglDeleteShader(wglGetProcAddress('glDeleteShader'{$IFDEF CLR}, typeof(TglDeleteShader){$ENDIF}));
  glDeleteShader(shaderObj);
end;

procedure STUB_glDetachShader(programObj, shaderObj: GLhandleARB); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glDetachShader := TglDetachShader(wglGetProcAddress('glDetachShader'{$IFDEF CLR}, typeof(TglDetachShader){$ENDIF}));
  glDetachShader(programObj, shaderObj);
end;

procedure STUB_glDisableVertexAttribArray(index: GLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glDisableVertexAttribArray := TglDisableVertexAttribArray(wglGetProcAddress('glDisableVertexAttribArray'{$IFDEF CLR}, typeof(TglDisableVertexAttribArray){$ENDIF}));
  glDisableVertexAttribArray(index);
end;

procedure STUB_glEnableVertexAttribArray(index: GLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glEnableVertexAttribArray := TglEnableVertexAttribArray(wglGetProcAddress('glEnableVertexAttribArray'{$IFDEF CLR}, typeof(TglEnableVertexAttribArray){$ENDIF}));
  glEnableVertexAttribArray(index);
end;

procedure STUB_glGetActiveAttrib(programObj: GLhandleARB; index: GLuint; maxlength: GLsizei; var length: GLint; var _type: GLenum; name: PChar); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glGetActiveAttrib := TglGetActiveAttrib(wglGetProcAddress('glGetActiveAttrib'{$IFDEF CLR}, typeof(TglGetActiveAttrib){$ENDIF}));
  glGetActiveAttrib(programObj, index, maxlength, length, _type, name);
end;

procedure STUB_glGetActiveUniform(programObj: GLhandleARB; index: GLuint; maxLength: GLsizei; var length: GLsizei; var size: GLint; var _type: GLenum; name: PChar); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glGetActiveUniform := TglGetActiveUniform(wglGetProcAddress('glGetActiveUniform'{$IFDEF CLR}, typeof(TglGetActiveUniform){$ENDIF}));
  glGetActiveUniform(programObj, index, maxLength, length, size, _type, name);
end;

procedure STUB_glGetAttachedShaders(programObj: GLhandleARB; MaxCount: GLsizei; var Count: GLint; shaders: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glGetAttachedShaders := TglGetAttachedShaders(wglGetProcAddress('glGetAttachedShaders'{$IFDEF CLR}, typeof(TglGetAttachedShaders){$ENDIF}));
  glGetAttachedShaders(programObj, MaxCount, Count, shaders);
end;

function STUB_glGetAttribLocation(programObj: GLhandleARB; char: string): glint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glGetAttribLocation := TglGetAttribLocation(wglGetProcAddress('glGetAttribLocation'{$IFDEF CLR}, typeof(TglGetAttribLocation){$ENDIF}));
  Result := glGetAttribLocation(programObj, char);
end;

procedure STUB_glGetProgramiv(programObj: GLhandleARB; pname: TGLenum; params: PGLInt); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glGetProgramiv := TglGetProgramiv(wglGetProcAddress('glGetProgramiv'{$IFDEF CLR}, typeof(TglGetProgramiv){$ENDIF}));
  glGetProgramiv(programObj, pname, params);
end;

{$IFDEF CLR}
procedure STUB_glGetProgramInfoLog(programObj: GLHandleARB; maxLength: glsizei; var length: GLint; infoLog: StringBuilder); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  _glGetProgramInfoLog := TglGetProgramInfoLog(wglGetProcAddress('glGetProgramInfoLog'{$IFDEF CLR}, typeof(TglGetProgramInfoLog){$ENDIF}));
  _glGetProgramInfoLog(programObj, maxLength, length, infoLog);
end;
{$ELSE}
procedure STUB_glGetProgramInfoLog(programObj: GLHandleARB; maxLength: glsizei; var length: GLint; infoLog: PChar); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  _glGetProgramInfoLog := TglGetProgramInfoLog(wglGetProcAddress('glGetProgramInfoLog'{$IFDEF CLR}, typeof(TglGetProgramInfoLog){$ENDIF}));
  _glGetProgramInfoLog(programObj, maxLength, length, infoLog);
end;
{$ENDIF}

procedure STUB_glGetShaderiv(shaderObj: GLhandleARB; pname: TGLenum; params: PGLInt); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glGetShaderiv := TglGetShaderiv(wglGetProcAddress('glGetShaderiv'{$IFDEF CLR}, typeof(TglGetShaderiv){$ENDIF}));
  glGetShaderiv(shaderObj, pname, params);
end;

{$IFDEF CLR}
procedure STUB_glGetShaderInfoLog(shaderObj: GLHandleARB; maxLength: glsizei; var length: glint; infoLog: StringBuilder); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  _glGetShaderInfoLog := TglGetShaderInfoLog(wglGetProcAddress('glGetShaderInfoLog'{$IFDEF CLR}, typeof(TglGetShaderInfoLog){$ENDIF}));
  _glGetShaderInfoLog(shaderObj, maxLength, length, infoLog);
end;
{$ELSE}
procedure STUB_glGetShaderInfoLog(shaderObj: GLHandleARB; maxLength: glsizei; var length: glint; infoLog: PChar); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  _glGetShaderInfoLog := TglGetShaderInfoLog(wglGetProcAddress('glGetShaderInfoLog'{$IFDEF CLR}, typeof(TglGetShaderInfoLog){$ENDIF}));
  _glGetShaderInfoLog(shaderObj, maxLength, length, infoLog);
end;
{$ENDIF}

procedure STUB_glGetShaderSource(shaderObj: GLhandleARB; maxlength: GLsizei; var length: GLsizei; source: PChar); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glGetShaderSource := TglGetShaderSource(wglGetProcAddress('glGetShaderSource'{$IFDEF CLR}, typeof(TglGetShaderSource){$ENDIF}));
  glGetShaderSource(shaderObj, maxlength, length, source);
end;

function STUB_glGetUniformLocation(programObj: GLhandleARB; const char: PChar): glint; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glGetUniformLocation := TglGetUniformLocation(wglGetProcAddress('glGetUniformLocation'{$IFDEF CLR}, typeof(TglGetUniformLocation){$ENDIF}));
  Result := glGetUniformLocation(programObj, char);
end;

procedure STUB_glGetUniformfv(programObj: GLhandleARB; location: GLint; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glGetUniformfv := TglGetUniformfv(wglGetProcAddress('glGetUniformfv'{$IFDEF CLR}, typeof(TglGetUniformfv){$ENDIF}));
  glGetUniformfv(programObj, location, params);
end;

procedure STUB_glGetUniformiv(programObj: GLhandleARB; location: GLint; params: PGLInt); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glGetUniformiv := TglGetUniformiv(wglGetProcAddress('glGetUniformiv'{$IFDEF CLR}, typeof(TglGetUniformiv){$ENDIF}));
  glGetUniformiv(programObj, location, params);
end;

procedure STUB_glGetVertexAttribfv(index: GLuint; pname: GLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glGetVertexAttribfv := TglGetVertexAttribfv(wglGetProcAddress('glGetVertexAttribfv'{$IFDEF CLR}, typeof(TglGetVertexAttribfv){$ENDIF}));
  glGetVertexAttribfv(index, pname, params);
end;

procedure STUB_glGetVertexAttribiv(index: GLuint; pname: GLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glGetVertexAttribiv := TglGetVertexAttribiv(wglGetProcAddress('glGetVertexAttribiv'{$IFDEF CLR}, typeof(TglGetVertexAttribiv){$ENDIF}));
  glGetVertexAttribiv(index, pname, params);
end;

procedure STUB_glGetVertexAttribPointerv(index: GLuint; pname: GLenum; _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glGetVertexAttribPointerv := TglGetVertexAttribPointerv(wglGetProcAddress('glGetVertexAttribPointerv'{$IFDEF CLR}, typeof(TglGetVertexAttribPointerv){$ENDIF}));
  glGetVertexAttribPointerv(index, pname, _pointer);
end;

function STUB_glIsProgram(programObj: GLhandleARB) : TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glIsProgram := TglIsProgram(wglGetProcAddress('glIsProgram'{$IFDEF CLR}, typeof(TglIsProgram){$ENDIF}));
  Result := glIsProgram(programObj);
end;

function STUB_glIsShader(shaderObj: GLhandleARB) : TGLboolean; {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glIsShader := TglIsShader(wglGetProcAddress('glIsShader'{$IFDEF CLR}, typeof(TglIsShader){$ENDIF}));
  Result := glIsShader(shaderObj);
end;

procedure STUB_glLinkProgram(programObj: GLHandleARB); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glLinkProgram := TglLinkProgram(wglGetProcAddress('glLinkProgram'{$IFDEF CLR}, typeof(TglLinkProgram){$ENDIF}));
  glLinkProgram(programObj);
end;

{$IFDEF CLR}
procedure STUB_glShaderSource(shaderObj: GLHandleARB; count: glsizei; _string: array of string; lengths: pglint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  _glShaderSource := TglShaderSource(wglGetProcAddress('glShaderSource'{$IFDEF CLR}, typeof(TglShaderSource){$ENDIF}));
  _glShaderSource(shaderObj, count, _string, lengths);
end;
{$ELSE}
procedure STUB_glShaderSource(shaderObj: GLHandleARB; count: glsizei; _string: PPGLChar; lengths: pglint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  _glShaderSource := TglShaderSource(wglGetProcAddress('glShaderSource'{$IFDEF CLR}, typeof(TglShaderSource){$ENDIF}));
  _glShaderSource(shaderObj, count, _string, lengths);
end;
{$ENDIF}

procedure STUB_glUseProgram(programObj: GLhandleARB); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glUseProgram := TglUseProgram(wglGetProcAddress('glUseProgram'{$IFDEF CLR}, typeof(TglUseProgram){$ENDIF}));
  glUseProgram(programObj);
end;

procedure STUB_glUniform1f(location: GLint; v0: GLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glUniform1f := TglUniform1f(wglGetProcAddress('glUniform1f'{$IFDEF CLR}, typeof(TglUniform1f){$ENDIF}));
  glUniform1f(location, v0);
end;

procedure STUB_glUniform2f(location: GLint; v0, v1: GLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glUniform2f := TglUniform2f(wglGetProcAddress('glUniform2f'{$IFDEF CLR}, typeof(TglUniform2f){$ENDIF}));
  glUniform2f(location, v0, v1);
end;

procedure STUB_glUniform3f(location: GLint; v0, v1, v2: GLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glUniform3f := TglUniform3f(wglGetProcAddress('glUniform3f'{$IFDEF CLR}, typeof(TglUniform3f){$ENDIF}));
  glUniform3f(location, v0, v1, v2);
end;

procedure STUB_glUniform4f(location: GLint; v0, v1, v2, v3: GLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glUniform4f := TglUniform4f(wglGetProcAddress('glUniform4f'{$IFDEF CLR}, typeof(TglUniform4f){$ENDIF}));
  glUniform4f(location, v0, v1, v2, v3);
end;

procedure STUB_glUniform1i(location: GLint; v0: GLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glUniform1i := TglUniform1i(wglGetProcAddress('glUniform1i'{$IFDEF CLR}, typeof(TglUniform1i){$ENDIF}));
  glUniform1i(location, v0);
end;

procedure STUB_glUniform2i(location: GLint; v0, v1: GLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glUniform2i := TglUniform2i(wglGetProcAddress('glUniform2i'{$IFDEF CLR}, typeof(TglUniform2i){$ENDIF}));
  glUniform2i(location, v0, v1);
end;

procedure STUB_glUniform3i(location: GLint; v0, v1, v2: GLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glUniform3i := TglUniform3i(wglGetProcAddress('glUniform3i'{$IFDEF CLR}, typeof(TglUniform3i){$ENDIF}));
  glUniform3i(location, v0, v1, v2);
end;

procedure STUB_glUniform4i(location: GLint; v0, v1, v2, v3: GLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glUniform4i := TglUniform4i(wglGetProcAddress('glUniform4i'{$IFDEF CLR}, typeof(TglUniform4i){$ENDIF}));
  glUniform4i(location, v0, v1, v2, v3);
end;

procedure STUB_glUniform1fv(location: GLint; count: GLsizei; value: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glUniform1fv := TglUniform1fv(wglGetProcAddress('glUniform1fv'{$IFDEF CLR}, typeof(TglUniform1fv){$ENDIF}));
  glUniform1fv(location, count, value);
end;

procedure STUB_glUniform2fv(location: GLint; count: GLsizei; value: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glUniform2fv := TglUniform2fv(wglGetProcAddress('glUniform2fv'{$IFDEF CLR}, typeof(TglUniform2fv){$ENDIF}));
  glUniform2fv(location, count, value);
end;

procedure STUB_glUniform3fv(location: GLint; count: GLsizei; value: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glUniform3fv := TglUniform3fv(wglGetProcAddress('glUniform3fv'{$IFDEF CLR}, typeof(TglUniform3fv){$ENDIF}));
  glUniform3fv(location, count, value);
end;

procedure STUB_glUniform4fv(location: GLint; count: GLsizei; value: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glUniform4fv := TglUniform4fv(wglGetProcAddress('glUniform4fv'{$IFDEF CLR}, typeof(TglUniform4fv){$ENDIF}));
  glUniform4fv(location, count, value);
end;

procedure STUB_glUniform1iv(location: GLint; count: GLsizei; value: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glUniform1iv := TglUniform1iv(wglGetProcAddress('glUniform1iv'{$IFDEF CLR}, typeof(TglUniform1iv){$ENDIF}));
  glUniform1iv(location, count, value);
end;

procedure STUB_glUniform2iv(location: GLint; count: GLsizei; value: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glUniform2iv := TglUniform2iv(wglGetProcAddress('glUniform2iv'{$IFDEF CLR}, typeof(TglUniform2iv){$ENDIF}));
  glUniform2iv(location, count, value);
end;

procedure STUB_glUniform3iv(location: GLint; count: GLsizei; value: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glUniform3iv := TglUniform3iv(wglGetProcAddress('glUniform3iv'{$IFDEF CLR}, typeof(TglUniform3iv){$ENDIF}));
  glUniform3iv(location, count, value);
end;

procedure STUB_glUniform4iv(location: GLint; count: GLsizei; value: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glUniform4iv := TglUniform4iv(wglGetProcAddress('glUniform4iv'{$IFDEF CLR}, typeof(TglUniform4iv){$ENDIF}));
  glUniform4iv(location, count, value);
end;

procedure STUB_glUniformMatrix2fv(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glUniformMatrix2fv := TglUniformMatrix2fv(wglGetProcAddress('glUniformMatrix2fv'{$IFDEF CLR}, typeof(TglUniformMatrix2fv){$ENDIF}));
  glUniformMatrix2fv(location, count, transpose, value);
end;

procedure STUB_glUniformMatrix3fv(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glUniformMatrix3fv := TglUniformMatrix3fv(wglGetProcAddress('glUniformMatrix3fv'{$IFDEF CLR}, typeof(TglUniformMatrix3fv){$ENDIF}));
  glUniformMatrix3fv(location, count, transpose, value);
end;

procedure STUB_glUniformMatrix4fv(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glUniformMatrix4fv := TglUniformMatrix4fv(wglGetProcAddress('glUniformMatrix4fv'{$IFDEF CLR}, typeof(TglUniformMatrix4fv){$ENDIF}));
  glUniformMatrix4fv(location, count, transpose, value);
end;

procedure STUB_glValidateProgram(programObj: GLhandleARB); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glValidateProgram := TglValidateProgram(wglGetProcAddress('glValidateProgram'{$IFDEF CLR}, typeof(TglValidateProgram){$ENDIF}));
  glValidateProgram(programObj);
end;

procedure STUB_glVertexAttrib1d(index: GLuint; x: GLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib1d := TglVertexAttrib1d(wglGetProcAddress('glVertexAttrib1d'{$IFDEF CLR}, typeof(TglVertexAttrib1d){$ENDIF}));
  glVertexAttrib1d(index, x);
end;

procedure STUB_glVertexAttrib1dv(index: GLuint; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib1dv := TglVertexAttrib1dv(wglGetProcAddress('glVertexAttrib1dv'{$IFDEF CLR}, typeof(TglVertexAttrib1dv){$ENDIF}));
  glVertexAttrib1dv(index, v);
end;

procedure STUB_glVertexAttrib1f(index: GLuint; x: GLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib1f := TglVertexAttrib1f(wglGetProcAddress('glVertexAttrib1f'{$IFDEF CLR}, typeof(TglVertexAttrib1f){$ENDIF}));
  glVertexAttrib1f(index, x);
end;

procedure STUB_glVertexAttrib1fv(index: GLuint; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib1fv := TglVertexAttrib1fv(wglGetProcAddress('glVertexAttrib1fv'{$IFDEF CLR}, typeof(TglVertexAttrib1fv){$ENDIF}));
  glVertexAttrib1fv(index, v);
end;

procedure STUB_glVertexAttrib1s(index: GLuint; x: GLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib1s := TglVertexAttrib1s(wglGetProcAddress('glVertexAttrib1s'{$IFDEF CLR}, typeof(TglVertexAttrib1s){$ENDIF}));
  glVertexAttrib1s(index, x);
end;

procedure STUB_glVertexAttrib1sv(index: GLuint; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib1sv := TglVertexAttrib1sv(wglGetProcAddress('glVertexAttrib1sv'{$IFDEF CLR}, typeof(TglVertexAttrib1sv){$ENDIF}));
  glVertexAttrib1sv(index, v);
end;

procedure STUB_glVertexAttrib2d(index: GLuint; x: GLdouble; y: GLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib2d := TglVertexAttrib2d(wglGetProcAddress('glVertexAttrib2d'{$IFDEF CLR}, typeof(TglVertexAttrib2d){$ENDIF}));
  glVertexAttrib2d(index, x, y);
end;

procedure STUB_glVertexAttrib2dv(index: GLuint; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib2dv := TglVertexAttrib2dv(wglGetProcAddress('glVertexAttrib2dv'{$IFDEF CLR}, typeof(TglVertexAttrib2dv){$ENDIF}));
  glVertexAttrib2dv(index, v);
end;

procedure STUB_glVertexAttrib2f(index: GLuint; x: GLfloat; y: GLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib2f := TglVertexAttrib2f(wglGetProcAddress('glVertexAttrib2f'{$IFDEF CLR}, typeof(TglVertexAttrib2f){$ENDIF}));
  glVertexAttrib2f(index, x, y);
end;

procedure STUB_glVertexAttrib2fv(index: GLuint; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib2fv := TglVertexAttrib2fv(wglGetProcAddress('glVertexAttrib2fv'{$IFDEF CLR}, typeof(TglVertexAttrib2fv){$ENDIF}));
  glVertexAttrib2fv(index, v);
end;

procedure STUB_glVertexAttrib2s(index: GLuint; x: GLshort; y: GLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib2s := TglVertexAttrib2s(wglGetProcAddress('glVertexAttrib2s'{$IFDEF CLR}, typeof(TglVertexAttrib2s){$ENDIF}));
  glVertexAttrib2s(index, x, y);
end;

procedure STUB_glVertexAttrib2sv(index: GLuint; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib2sv := TglVertexAttrib2sv(wglGetProcAddress('glVertexAttrib2sv'{$IFDEF CLR}, typeof(TglVertexAttrib2sv){$ENDIF}));
  glVertexAttrib2sv(index, v);
end;

procedure STUB_glVertexAttrib3d(index: GLuint; x: GLdouble; y: GLdouble; z: GLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib3d := TglVertexAttrib3d(wglGetProcAddress('glVertexAttrib3d'{$IFDEF CLR}, typeof(TglVertexAttrib3d){$ENDIF}));
  glVertexAttrib3d(index, x, y, z);
end;

procedure STUB_glVertexAttrib3dv(index: GLuint; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib3dv := TglVertexAttrib3dv(wglGetProcAddress('glVertexAttrib3dv'{$IFDEF CLR}, typeof(TglVertexAttrib3dv){$ENDIF}));
  glVertexAttrib3dv(index, v);
end;

procedure STUB_glVertexAttrib3f(index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib3f := TglVertexAttrib3f(wglGetProcAddress('glVertexAttrib3f'{$IFDEF CLR}, typeof(TglVertexAttrib3f){$ENDIF}));
  glVertexAttrib3f(index, x, y, z);
end;

procedure STUB_glVertexAttrib3fv(index: GLuint; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib3fv := TglVertexAttrib3fv(wglGetProcAddress('glVertexAttrib3fv'{$IFDEF CLR}, typeof(TglVertexAttrib3fv){$ENDIF}));
  glVertexAttrib3fv(index, v);
end;

procedure STUB_glVertexAttrib3s(index: GLuint; x: GLshort; y: GLshort; z: GLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib3s := TglVertexAttrib3s(wglGetProcAddress('glVertexAttrib3s'{$IFDEF CLR}, typeof(TglVertexAttrib3s){$ENDIF}));
  glVertexAttrib3s(index, x, y, z);
end;

procedure STUB_glVertexAttrib3sv(index: GLuint; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib3sv := TglVertexAttrib3sv(wglGetProcAddress('glVertexAttrib3sv'{$IFDEF CLR}, typeof(TglVertexAttrib3sv){$ENDIF}));
  glVertexAttrib3sv(index, v);
end;

procedure STUB_glVertexAttrib4Nbv(index: GLuint; const v: PGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4Nbv := TglVertexAttrib4Nbv(wglGetProcAddress('glVertexAttrib4Nbv'{$IFDEF CLR}, typeof(TglVertexAttrib4Nbv){$ENDIF}));
  glVertexAttrib4Nbv(index, v);
end;

procedure STUB_glVertexAttrib4Niv(index: GLuint; const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4Niv := TglVertexAttrib4Niv(wglGetProcAddress('glVertexAttrib4Niv'{$IFDEF CLR}, typeof(TglVertexAttrib4Niv){$ENDIF}));
  glVertexAttrib4Niv(index, v);
end;

procedure STUB_glVertexAttrib4Nsv(index: GLuint; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4Nsv := TglVertexAttrib4Nsv(wglGetProcAddress('glVertexAttrib4Nsv'{$IFDEF CLR}, typeof(TglVertexAttrib4Nsv){$ENDIF}));
  glVertexAttrib4Nsv(index, v);
end;

procedure STUB_glVertexAttrib4Nub(index: GLuint; x: GLubyte; y: GLubyte; z: GLubyte; w: GLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4Nub := TglVertexAttrib4Nub(wglGetProcAddress('glVertexAttrib4Nub'{$IFDEF CLR}, typeof(TglVertexAttrib4Nub){$ENDIF}));
  glVertexAttrib4Nub(index, x, y, z, w);
end;

procedure STUB_glVertexAttrib4Nubv(index: GLuint; const v: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4Nubv := TglVertexAttrib4Nubv(wglGetProcAddress('glVertexAttrib4Nubv'{$IFDEF CLR}, typeof(TglVertexAttrib4Nubv){$ENDIF}));
  glVertexAttrib4Nubv(index, v);
end;

procedure STUB_glVertexAttrib4Nuiv(index: GLuint; const v: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4Nuiv := TglVertexAttrib4Nuiv(wglGetProcAddress('glVertexAttrib4Nuiv'{$IFDEF CLR}, typeof(TglVertexAttrib4Nuiv){$ENDIF}));
  glVertexAttrib4Nuiv(index, v);
end;

procedure STUB_glVertexAttrib4Nusv(index: GLuint; const v: PGLushort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4Nusv := TglVertexAttrib4Nusv(wglGetProcAddress('glVertexAttrib4Nusv'{$IFDEF CLR}, typeof(TglVertexAttrib4Nusv){$ENDIF}));
  glVertexAttrib4Nusv(index, v);
end;

procedure STUB_glVertexAttrib4bv(index: GLuint; const v: PGLbyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4bv := TglVertexAttrib4bv(wglGetProcAddress('glVertexAttrib4bv'{$IFDEF CLR}, typeof(TglVertexAttrib4bv){$ENDIF}));
  glVertexAttrib4bv(index, v);
end;

procedure STUB_glVertexAttrib4d(index: GLuint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4d := TglVertexAttrib4d(wglGetProcAddress('glVertexAttrib4d'{$IFDEF CLR}, typeof(TglVertexAttrib4d){$ENDIF}));
  glVertexAttrib4d(index, x, y, z, w);
end;

procedure STUB_glVertexAttrib4dv(index: GLuint; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4dv := TglVertexAttrib4dv(wglGetProcAddress('glVertexAttrib4dv'{$IFDEF CLR}, typeof(TglVertexAttrib4dv){$ENDIF}));
  glVertexAttrib4dv(index, v);
end;

procedure STUB_glVertexAttrib4f(index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4f := TglVertexAttrib4f(wglGetProcAddress('glVertexAttrib4f'{$IFDEF CLR}, typeof(TglVertexAttrib4f){$ENDIF}));
  glVertexAttrib4f(index, x, y, z, w);
end;

procedure STUB_glVertexAttrib4fv(index: GLuint; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4fv := TglVertexAttrib4fv(wglGetProcAddress('glVertexAttrib4fv'{$IFDEF CLR}, typeof(TglVertexAttrib4fv){$ENDIF}));
  glVertexAttrib4fv(index, v);
end;

procedure STUB_glVertexAttrib4iv(index: GLuint; const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4iv := TglVertexAttrib4iv(wglGetProcAddress('glVertexAttrib4iv'{$IFDEF CLR}, typeof(TglVertexAttrib4iv){$ENDIF}));
  glVertexAttrib4iv(index, v);
end;

procedure STUB_glVertexAttrib4s(index: GLuint; x: GLshort; y: GLshort; z: GLshort; w: GLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4s := TglVertexAttrib4s(wglGetProcAddress('glVertexAttrib4s'{$IFDEF CLR}, typeof(TglVertexAttrib4s){$ENDIF}));
  glVertexAttrib4s(index, x, y, z, w);
end;

procedure STUB_glVertexAttrib4sv(index: GLuint; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4sv := TglVertexAttrib4sv(wglGetProcAddress('glVertexAttrib4sv'{$IFDEF CLR}, typeof(TglVertexAttrib4sv){$ENDIF}));
  glVertexAttrib4sv(index, v);
end;

procedure STUB_glVertexAttrib4ubv(index: GLuint; const v: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4ubv := TglVertexAttrib4ubv(wglGetProcAddress('glVertexAttrib4ubv'{$IFDEF CLR}, typeof(TglVertexAttrib4ubv){$ENDIF}));
  glVertexAttrib4ubv(index, v);
end;

procedure STUB_glVertexAttrib4uiv(index: GLuint; const v: PGLuint); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4uiv := TglVertexAttrib4uiv(wglGetProcAddress('glVertexAttrib4uiv'{$IFDEF CLR}, typeof(TglVertexAttrib4uiv){$ENDIF}));
  glVertexAttrib4uiv(index, v);
end;

procedure STUB_glVertexAttrib4usv(index: GLuint; const v: PGLushort); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4usv := TglVertexAttrib4usv(wglGetProcAddress('glVertexAttrib4usv'{$IFDEF CLR}, typeof(TglVertexAttrib4usv){$ENDIF}));
  glVertexAttrib4usv(index, v);  
end;

procedure STUB_glVertexAttribPointer(index: GLuint; size: GLint; _type: GLenum; normalized: GLboolean; stride: GLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32}stdcall; {$ELSE}cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttribPointer := TglVertexAttribPointer(wglGetProcAddress('glVertexAttribPointer'{$IFDEF CLR}, typeof(TglVertexAttribPointer){$ENDIF}));
  glVertexAttribPointer(index, size, _type, normalized, stride, _pointer);
end;

procedure STUB_glVertexAttrib1dARB(index: TGLuint; x: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib1dARB := TglVertexAttrib1dARB(glProcedure('glVertexAttrib1dARB'{$IFDEF CLR}, typeof(TglVertexAttrib1dARB){$ENDIF}));
  glVertexAttrib1dARB(index, x);
end;

procedure STUB_glVertexAttrib1dvARB(index: TGLuint; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib1dvARB := TglVertexAttrib1dvARB(glProcedure('glVertexAttrib1dvARB'{$IFDEF CLR}, typeof(TglVertexAttrib1dvARB){$ENDIF}));
  glVertexAttrib1dvARB(index, v);
end;

procedure STUB_glVertexAttrib1fARB(index: TGLuint; x: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib1fARB := TglVertexAttrib1fARB(glProcedure('glVertexAttrib1fARB'{$IFDEF CLR}, typeof(TglVertexAttrib1fARB){$ENDIF}));
  glVertexAttrib1fARB(index, x);
end;

procedure STUB_glVertexAttrib1fvARB(index: TGLuint; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib1fvARB := TglVertexAttrib1fvARB(glProcedure('glVertexAttrib1fvARB'{$IFDEF CLR}, typeof(TglVertexAttrib1fvARB){$ENDIF}));
  glVertexAttrib1fvARB(index, v);
end;

procedure STUB_glVertexAttrib1sARB(index: TGLuint; x: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib1sARB := TglVertexAttrib1sARB(glProcedure('glVertexAttrib1sARB'{$IFDEF CLR}, typeof(TglVertexAttrib1sARB){$ENDIF}));
  glVertexAttrib1sARB(index, x);
end;

procedure STUB_glVertexAttrib1svARB(index: TGLuint; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib1svARB := TglVertexAttrib1svARB(glProcedure('glVertexAttrib1svARB'{$IFDEF CLR}, typeof(TglVertexAttrib1svARB){$ENDIF}));
  glVertexAttrib1svARB(index, v);
end;

procedure STUB_glVertexAttrib2dARB(index: TGLuint; x: TGLdouble; y: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib2dARB := TglVertexAttrib2dARB(glProcedure('glVertexAttrib2dARB'{$IFDEF CLR}, typeof(TglVertexAttrib2dARB){$ENDIF}));
  glVertexAttrib2dARB(index, x, y);
end;

procedure STUB_glVertexAttrib2dvARB(index: TGLuint; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib2dvARB := TglVertexAttrib2dvARB(glProcedure('glVertexAttrib2dvARB'{$IFDEF CLR}, typeof(TglVertexAttrib2dvARB){$ENDIF}));
  glVertexAttrib2dvARB(index, v);
end;

procedure STUB_glVertexAttrib2fARB(index: TGLuint; x: TGLfloat; y: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib2fARB := TglVertexAttrib2fARB(glProcedure('glVertexAttrib2fARB'{$IFDEF CLR}, typeof(TglVertexAttrib2fARB){$ENDIF}));
  glVertexAttrib2fARB(index, x, y);
end;

procedure STUB_glVertexAttrib2fvARB(index: TGLuint; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib2fvARB := TglVertexAttrib2fvARB(glProcedure('glVertexAttrib2fvARB'{$IFDEF CLR}, typeof(TglVertexAttrib2fvARB){$ENDIF}));
  glVertexAttrib2fvARB(index, v);
end;

procedure STUB_glVertexAttrib2sARB(index: TGLuint; x: TGLshort; y: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib2sARB := TglVertexAttrib2sARB(glProcedure('glVertexAttrib2sARB'{$IFDEF CLR}, typeof(TglVertexAttrib2sARB){$ENDIF}));
  glVertexAttrib2sARB(index, x, y);
end;

procedure STUB_glVertexAttrib2svARB(index: TGLuint; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib2svARB := TglVertexAttrib2svARB(glProcedure('glVertexAttrib2svARB'{$IFDEF CLR}, typeof(TglVertexAttrib2svARB){$ENDIF}));
  glVertexAttrib2svARB(index, v);
end;

procedure STUB_glVertexAttrib3dARB(index: TGLuint; x: TGLdouble; y: TGLdouble; z: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib3dARB := TglVertexAttrib3dARB(glProcedure('glVertexAttrib3dARB'{$IFDEF CLR}, typeof(TglVertexAttrib3dARB){$ENDIF}));
  glVertexAttrib3dARB(index, x, y, z);
end;

procedure STUB_glVertexAttrib3dvARB(index: TGLuint; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib3dvARB := TglVertexAttrib3dvARB(glProcedure('glVertexAttrib3dvARB'{$IFDEF CLR}, typeof(TglVertexAttrib3dvARB){$ENDIF}));
  glVertexAttrib3dvARB(index, v);
end;

procedure STUB_glVertexAttrib3fARB(index: TGLuint; x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib3fARB := TglVertexAttrib3fARB(glProcedure('glVertexAttrib3fARB'{$IFDEF CLR}, typeof(TglVertexAttrib3fARB){$ENDIF}));
  glVertexAttrib3fARB(index, x, y, z);
end;

procedure STUB_glVertexAttrib3fvARB(index: TGLuint; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib3fvARB := TglVertexAttrib3fvARB(glProcedure('glVertexAttrib3fvARB'{$IFDEF CLR}, typeof(TglVertexAttrib3fvARB){$ENDIF}));
  glVertexAttrib3fvARB(index, v);
end;

procedure STUB_glVertexAttrib3sARB(index: TGLuint; x: TGLshort; y: TGLshort; z: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib3sARB := TglVertexAttrib3sARB(glProcedure('glVertexAttrib3sARB'{$IFDEF CLR}, typeof(TglVertexAttrib3sARB){$ENDIF}));
  glVertexAttrib3sARB(index, x, y, z);
end;

procedure STUB_glVertexAttrib3svARB(index: TGLuint; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib3svARB := TglVertexAttrib3svARB(glProcedure('glVertexAttrib3svARB'{$IFDEF CLR}, typeof(TglVertexAttrib3svARB){$ENDIF}));
  glVertexAttrib3svARB(index, v);
end;

procedure STUB_glVertexAttrib4NbvARB(index: TGLuint; const v: PGLbyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4NbvARB := TglVertexAttrib4NbvARB(glProcedure('glVertexAttrib4NbvARB'{$IFDEF CLR}, typeof(TglVertexAttrib4NbvARB){$ENDIF}));
  glVertexAttrib4NbvARB(index, v);
end;

procedure STUB_glVertexAttrib4NivARB(index: TGLuint; const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4NivARB := TglVertexAttrib4NivARB(glProcedure('glVertexAttrib4NivARB'{$IFDEF CLR}, typeof(TglVertexAttrib4NivARB){$ENDIF}));
  glVertexAttrib4NivARB(index, v);
end;

procedure STUB_glVertexAttrib4NsvARB(index: TGLuint; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4NsvARB := TglVertexAttrib4NsvARB(glProcedure('glVertexAttrib4NsvARB'{$IFDEF CLR}, typeof(TglVertexAttrib4NsvARB){$ENDIF}));
  glVertexAttrib4NsvARB(index, v);
end;

procedure STUB_glVertexAttrib4NubARB(index: TGLuint; x: TGLubyte; y: TGLubyte; z: TGLubyte; w: TGLubyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4NubARB := TglVertexAttrib4NubARB(glProcedure('glVertexAttrib4NubARB'{$IFDEF CLR}, typeof(TglVertexAttrib4NubARB){$ENDIF}));
  glVertexAttrib4NubARB(index, x, y, z, w);
end;

procedure STUB_glVertexAttrib4NubvARB(index: TGLuint; const v: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4NubvARB := TglVertexAttrib4NubvARB(glProcedure('glVertexAttrib4NubvARB'{$IFDEF CLR}, typeof(TglVertexAttrib4NubvARB){$ENDIF}));
  glVertexAttrib4NubvARB(index, v);
end;

procedure STUB_glVertexAttrib4NuivARB(index: TGLuint; const v: PGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4NuivARB := TglVertexAttrib4NuivARB(glProcedure('glVertexAttrib4NuivARB'{$IFDEF CLR}, typeof(TglVertexAttrib4NuivARB){$ENDIF}));
  glVertexAttrib4NuivARB(index, v);
end;

procedure STUB_glVertexAttrib4NusvARB(index: TGLuint; const v: PGLushort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4NusvARB := TglVertexAttrib4NusvARB(glProcedure('glVertexAttrib4NusvARB'{$IFDEF CLR}, typeof(TglVertexAttrib4NusvARB){$ENDIF}));
  glVertexAttrib4NusvARB(index, v);
end;

procedure STUB_glVertexAttrib4bvARB(index: TGLuint; const v: PGLbyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4bvARB := TglVertexAttrib4bvARB(glProcedure('glVertexAttrib4bvARB'{$IFDEF CLR}, typeof(TglVertexAttrib4bvARB){$ENDIF}));
  glVertexAttrib4bvARB(index, v);
end;

procedure STUB_glVertexAttrib4dARB(index: TGLuint; x: TGLdouble; y: TGLdouble; z: TGLdouble; w: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4dARB := TglVertexAttrib4dARB(glProcedure('glVertexAttrib4dARB'{$IFDEF CLR}, typeof(TglVertexAttrib4dARB){$ENDIF}));
  glVertexAttrib4dARB(index, x, y, z, w);
end;

procedure STUB_glVertexAttrib4dvARB(index: TGLuint; const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4dvARB := TglVertexAttrib4dvARB(glProcedure('glVertexAttrib4dvARB'{$IFDEF CLR}, typeof(TglVertexAttrib4dvARB){$ENDIF}));
  glVertexAttrib4dvARB(index, v);
end;

procedure STUB_glVertexAttrib4fARB(index: TGLuint; x: TGLfloat; y: TGLfloat; z: TGLfloat; w: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4fARB := TglVertexAttrib4fARB(glProcedure('glVertexAttrib4fARB'{$IFDEF CLR}, typeof(TglVertexAttrib4fARB){$ENDIF}));
  glVertexAttrib4fARB(index, x, y, z, w);
end;

procedure STUB_glVertexAttrib4fvARB(index: TGLuint; const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4fvARB := TglVertexAttrib4fvARB(glProcedure('glVertexAttrib4fvARB'{$IFDEF CLR}, typeof(TglVertexAttrib4fvARB){$ENDIF}));
  glVertexAttrib4fvARB(index, v);
end;

procedure STUB_glVertexAttrib4ivARB(index: TGLuint; const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4ivARB := TglVertexAttrib4ivARB(glProcedure('glVertexAttrib4ivARB'{$IFDEF CLR}, typeof(TglVertexAttrib4ivARB){$ENDIF}));
  glVertexAttrib4ivARB(index, v);
end;

procedure STUB_glVertexAttrib4sARB(index: TGLuint; x: TGLshort; y: TGLshort; z: TGLshort; w: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4sARB := TglVertexAttrib4sARB(glProcedure('glVertexAttrib4sARB'{$IFDEF CLR}, typeof(TglVertexAttrib4sARB){$ENDIF}));
  glVertexAttrib4sARB(index, x, y, z, w);
end;

procedure STUB_glVertexAttrib4svARB(index: TGLuint; const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4svARB := TglVertexAttrib4svARB(glProcedure('glVertexAttrib4svARB'{$IFDEF CLR}, typeof(TglVertexAttrib4svARB){$ENDIF}));
  glVertexAttrib4svARB(index, v);
end;

procedure STUB_glVertexAttrib4ubvARB(index: TGLuint; const v: PGLubyte); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4ubvARB := TglVertexAttrib4ubvARB(glProcedure('glVertexAttrib4ubvARB'{$IFDEF CLR}, typeof(TglVertexAttrib4ubvARB){$ENDIF}));
  glVertexAttrib4ubvARB(index, v);
end;

procedure STUB_glVertexAttrib4uivARB(index: TGLuint; const v: PGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4uivARB := TglVertexAttrib4uivARB(glProcedure('glVertexAttrib4uivARB'{$IFDEF CLR}, typeof(TglVertexAttrib4uivARB){$ENDIF}));
  glVertexAttrib4uivARB(index, v);
end;

procedure STUB_glVertexAttrib4usvARB(index: TGLuint; const v: PGLushort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttrib4usvARB := TglVertexAttrib4usvARB(glProcedure('glVertexAttrib4usvARB'{$IFDEF CLR}, typeof(TglVertexAttrib4usvARB){$ENDIF}));
  glVertexAttrib4usvARB(index, v);
end;

procedure STUB_glVertexAttribPointerARB(index: TGLuint; size: TGLint; _type: TGLenum; normalized: TGLboolean; stride: TGLsizei; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  _glVertexAttribPointerARB := TglVertexAttribPointerARB(glProcedure('glVertexAttribPointerARB'{$IFDEF CLR}, typeof(TglVertexAttribPointerARB){$ENDIF}));
  _glVertexAttribPointerARB(index, size, _type, normalized, stride, _pointer);
end;

procedure STUB_glEnableVertexAttribArrayARB(index: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glEnableVertexAttribArrayARB := TglEnableVertexAttribArrayARB(glProcedure('glEnableVertexAttribArrayARB'{$IFDEF CLR}, typeof(TglEnableVertexAttribArrayARB){$ENDIF}));
  glEnableVertexAttribArrayARB(index);
end;

procedure STUB_glDisableVertexAttribArrayARB(index: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDisableVertexAttribArrayARB := TglDisableVertexAttribArrayARB(glProcedure('glDisableVertexAttribArrayARB'{$IFDEF CLR}, typeof(TglDisableVertexAttribArrayARB){$ENDIF}));
  glDisableVertexAttribArrayARB(index);
end;

{$IFDEF CLR}

procedure STUB_glProgramStringARB(target: TGLenum; format: TGLenum; len: TGLsizei; const _string: System.&String); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glProgramStringARB := TglProgramStringARB(glProcedure('glProgramStringARB'{$IFDEF CLR}, typeof(TglProgramStringARB){$ENDIF}));
  glProgramStringARB(target, format, len, _string);
end;
{$ELSE}

procedure STUB_glProgramStringARB(target: TGLenum; format: TGLenum; len: TGLsizei; const _string: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glProgramStringARB := TglProgramStringARB(glProcedure('glProgramStringARB'{$IFDEF CLR}, typeof(TglProgramStringARB){$ENDIF}));
  glProgramStringARB(target, format, len, _string);
end;
{$ENDIF}

procedure STUB_glBindProgramARB(target: TGLenum; _program: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glBindProgramARB := TglBindProgramARB(glProcedure('glBindProgramARB'{$IFDEF CLR}, typeof(TglBindProgramARB){$ENDIF}));
  glBindProgramARB(target, _program);
end;

procedure STUB_glDeleteProgramsARB(n: TGLsizei; const programs: PGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDeleteProgramsARB := TglDeleteProgramsARB(glProcedure('glDeleteProgramsARB'{$IFDEF CLR}, typeof(TglDeleteProgramsARB){$ENDIF}));
  glDeleteProgramsARB(n, programs);
end;

procedure STUB_glGenProgramsARB(n: TGLsizei; programs: PGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGenProgramsARB := TglGenProgramsARB(glProcedure('glGenProgramsARB'{$IFDEF CLR}, typeof(TglGenProgramsARB){$ENDIF}));
  glGenProgramsARB(n, programs);
end;

procedure STUB_glProgramEnvParameter4dARB(target: TGLenum; index: TGLuint; x: TGLdouble; y: TGLdouble; z: TGLdouble; w: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glProgramEnvParameter4dARB := TglProgramEnvParameter4dARB(glProcedure('glProgramEnvParameter4dARB'{$IFDEF CLR}, typeof(TglProgramEnvParameter4dARB){$ENDIF}));
  glProgramEnvParameter4dARB(target, index, x, y, z, w);
end;

procedure STUB_glProgramEnvParameter4dvARB(target: TGLenum; index: TGLuint; const params: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glProgramEnvParameter4dvARB := TglProgramEnvParameter4dvARB(glProcedure('glProgramEnvParameter4dvARB'{$IFDEF CLR}, typeof(TglProgramEnvParameter4dvARB){$ENDIF}));
  glProgramEnvParameter4dvARB(target, index, params);
end;

procedure STUB_glProgramEnvParameter4fARB(target: TGLenum; index: TGLuint; x: TGLfloat; y: TGLfloat; z: TGLfloat; w: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glProgramEnvParameter4fARB := TglProgramEnvParameter4fARB(glProcedure('glProgramEnvParameter4fARB'{$IFDEF CLR}, typeof(TglProgramEnvParameter4fARB){$ENDIF}));
  glProgramEnvParameter4fARB(target, index, x, y, z, w);
end;

procedure STUB_glProgramEnvParameter4fvARB(target: TGLenum; index: TGLuint; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glProgramEnvParameter4fvARB := TglProgramEnvParameter4fvARB(glProcedure('glProgramEnvParameter4fvARB'{$IFDEF CLR}, typeof(TglProgramEnvParameter4fvARB){$ENDIF}));
  glProgramEnvParameter4fvARB(target, index, params);
end;

procedure STUB_glProgramLocalParameter4dARB(target: TGLenum; index: TGLuint; x: TGLdouble; y: TGLdouble; z: TGLdouble; w: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glProgramLocalParameter4dARB := TglProgramLocalParameter4dARB(glProcedure('glProgramLocalParameter4dARB'{$IFDEF CLR}, typeof(TglProgramLocalParameter4dARB){$ENDIF}));
  glProgramLocalParameter4dARB(target, index, x, y, z, w);
end;

procedure STUB_glProgramLocalParameter4dvARB(target: TGLenum; index: TGLuint; const params: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glProgramLocalParameter4dvARB := TglProgramLocalParameter4dvARB(glProcedure('glProgramLocalParameter4dvARB'{$IFDEF CLR}, typeof(TglProgramLocalParameter4dvARB){$ENDIF}));
  glProgramLocalParameter4dvARB(target, index, params);
end;

procedure STUB_glProgramLocalParameter4fARB(target: TGLenum; index: TGLuint; x: TGLfloat; y: TGLfloat; z: TGLfloat; w: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glProgramLocalParameter4fARB := TglProgramLocalParameter4fARB(glProcedure('glProgramLocalParameter4fARB'{$IFDEF CLR}, typeof(TglProgramLocalParameter4fARB){$ENDIF}));
  glProgramLocalParameter4fARB(target, index, x, y, z, w);
end;

procedure STUB_glProgramLocalParameter4fvARB(target: TGLenum; index: TGLuint; const params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glProgramLocalParameter4fvARB := TglProgramLocalParameter4fvARB(glProcedure('glProgramLocalParameter4fvARB'{$IFDEF CLR}, typeof(TglProgramLocalParameter4fvARB){$ENDIF}));
  glProgramLocalParameter4fvARB(target, index, params);
end;

procedure STUB_glGetProgramEnvParameterdvARB(target: TGLenum; index: TGLuint; params: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetProgramEnvParameterdvARB := TglGetProgramEnvParameterdvARB(glProcedure('glGetProgramEnvParameterdvARB'{$IFDEF CLR}, typeof(TglGetProgramEnvParameterdvARB){$ENDIF}));
  glGetProgramEnvParameterdvARB(target, index, params);
end;

procedure STUB_glGetProgramEnvParameterfvARB(target: TGLenum; index: TGLuint; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetProgramEnvParameterfvARB := TglGetProgramEnvParameterfvARB(glProcedure('glGetProgramEnvParameterfvARB'{$IFDEF CLR}, typeof(TglGetProgramEnvParameterfvARB){$ENDIF}));
  glGetProgramEnvParameterfvARB(target, index, params);
end;

procedure STUB_glGetProgramLocalParameterdvARB(target: TGLenum; index: TGLuint; params: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetProgramLocalParameterdvARB := TglGetProgramLocalParameterdvARB(glProcedure('glGetProgramLocalParameterdvARB'{$IFDEF CLR}, typeof(TglGetProgramLocalParameterdvARB){$ENDIF}));
  glGetProgramLocalParameterdvARB(target, index, params);
end;

procedure STUB_glGetProgramLocalParameterfvARB(target: TGLenum; index: TGLuint; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetProgramLocalParameterfvARB := TglGetProgramLocalParameterfvARB(glProcedure('glGetProgramLocalParameterfvARB'{$IFDEF CLR}, typeof(TglGetProgramLocalParameterfvARB){$ENDIF}));
  glGetProgramLocalParameterfvARB(target, index, params);
end;

procedure STUB_glGetProgramivARB(target: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetProgramivARB := TglGetProgramivARB(glProcedure('glGetProgramivARB'{$IFDEF CLR}, typeof(TglGetProgramivARB){$ENDIF}));
  glGetProgramivARB(target, pname, params);
end;

procedure STUB_glGetProgramStringARB(target: TGLenum; pname: TGLenum; _string: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetProgramStringARB := TglGetProgramStringARB(glProcedure('glGetProgramStringARB'{$IFDEF CLR}, typeof(TglGetProgramStringARB){$ENDIF}));
  glGetProgramStringARB(target, pname, _string);
end;

procedure STUB_glGetVertexAttribdvARB(index: TGLuint; pname: TGLenum; params: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetVertexAttribdvARB := TglGetVertexAttribdvARB(glProcedure('glGetVertexAttribdvARB'{$IFDEF CLR}, typeof(TglGetVertexAttribdvARB){$ENDIF}));
  glGetVertexAttribdvARB(index, pname, params);
end;

procedure STUB_glGetVertexAttribfvARB(index: TGLuint; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetVertexAttribfvARB := TglGetVertexAttribfvARB(glProcedure('glGetVertexAttribfvARB'{$IFDEF CLR}, typeof(TglGetVertexAttribfvARB){$ENDIF}));
  glGetVertexAttribfvARB(index, pname, params);
end;

procedure STUB_glGetVertexAttribivARB(index: TGLuint; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetVertexAttribivARB := TglGetVertexAttribivARB(glProcedure('glGetVertexAttribivARB'{$IFDEF CLR}, typeof(TglGetVertexAttribivARB){$ENDIF}));
  glGetVertexAttribivARB(index, pname, params);
end;

procedure STUB_glGetVertexAttribPointervARB(index: TGLuint; pname: TGLenum; _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetVertexAttribPointervARB := TglGetVertexAttribPointervARB(glProcedure('glGetVertexAttribPointervARB'{$IFDEF CLR}, typeof(TglGetVertexAttribPointervARB){$ENDIF}));
  glGetVertexAttribPointervARB(index, pname, _pointer);
end;

function STUB_glIsProgramARB(_program: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glIsProgramARB := TglIsProgramARB(glProcedure('glIsProgramARB'{$IFDEF CLR}, typeof(TglIsProgramARB){$ENDIF}));
  result := glIsProgramARB(_program);
end;

procedure STUB_glWindowPos2dARB(x: TGLdouble; y: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos2dARB := TglWindowPos2dARB(glProcedure('glWindowPos2dARB'{$IFDEF CLR}, typeof(TglWindowPos2dARB){$ENDIF}));
  glWindowPos2dARB(x, y);
end;

procedure STUB_glWindowPos2dvARB(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos2dvARB := TglWindowPos2dvARB(glProcedure('glWindowPos2dvARB'{$IFDEF CLR}, typeof(TglWindowPos2dvARB){$ENDIF}));
  glWindowPos2dvARB(v);
end;

procedure STUB_glWindowPos2fARB(x: TGLfloat; y: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos2fARB := TglWindowPos2fARB(glProcedure('glWindowPos2fARB'{$IFDEF CLR}, typeof(TglWindowPos2fARB){$ENDIF}));
  glWindowPos2fARB(x, y);
end;

procedure STUB_glWindowPos2fvARB(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos2fvARB := TglWindowPos2fvARB(glProcedure('glWindowPos2fvARB'{$IFDEF CLR}, typeof(TglWindowPos2fvARB){$ENDIF}));
  glWindowPos2fvARB(v);
end;

procedure STUB_glWindowPos2iARB(x: TGLint; y: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos2iARB := TglWindowPos2iARB(glProcedure('glWindowPos2iARB'{$IFDEF CLR}, typeof(TglWindowPos2iARB){$ENDIF}));
  glWindowPos2iARB(x, y);
end;

procedure STUB_glWindowPos2ivARB(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos2ivARB := TglWindowPos2ivARB(glProcedure('glWindowPos2ivARB'{$IFDEF CLR}, typeof(TglWindowPos2ivARB){$ENDIF}));
  glWindowPos2ivARB(v);
end;

procedure STUB_glWindowPos2sARB(x: TGLshort; y: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos2sARB := TglWindowPos2sARB(glProcedure('glWindowPos2sARB'{$IFDEF CLR}, typeof(TglWindowPos2sARB){$ENDIF}));
  glWindowPos2sARB(x, y);
end;

procedure STUB_glWindowPos2svARB(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos2svARB := TglWindowPos2svARB(glProcedure('glWindowPos2svARB'{$IFDEF CLR}, typeof(TglWindowPos2svARB){$ENDIF}));
  glWindowPos2svARB(v);
end;

procedure STUB_glWindowPos3dARB(x: TGLdouble; y: TGLdouble; z: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos3dARB := TglWindowPos3dARB(glProcedure('glWindowPos3dARB'{$IFDEF CLR}, typeof(TglWindowPos3dARB){$ENDIF}));
  glWindowPos3dARB(x, y, z);
end;

procedure STUB_glWindowPos3dvARB(const v: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos3dvARB := TglWindowPos3dvARB(glProcedure('glWindowPos3dvARB'{$IFDEF CLR}, typeof(TglWindowPos3dvARB){$ENDIF}));
  glWindowPos3dvARB(v);
end;

procedure STUB_glWindowPos3fARB(x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos3fARB := TglWindowPos3fARB(glProcedure('glWindowPos3fARB'{$IFDEF CLR}, typeof(TglWindowPos3fARB){$ENDIF}));
  glWindowPos3fARB(x, y, z);
end;

procedure STUB_glWindowPos3fvARB(const v: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos3fvARB := TglWindowPos3fvARB(glProcedure('glWindowPos3fvARB'{$IFDEF CLR}, typeof(TglWindowPos3fvARB){$ENDIF}));
  glWindowPos3fvARB(v);
end;

procedure STUB_glWindowPos3iARB(x: TGLint; y: TGLint; z: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos3iARB := TglWindowPos3iARB(glProcedure('glWindowPos3iARB'{$IFDEF CLR}, typeof(TglWindowPos3iARB){$ENDIF}));
  glWindowPos3iARB(x, y, z);
end;

procedure STUB_glWindowPos3ivARB(const v: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos3ivARB := TglWindowPos3ivARB(glProcedure('glWindowPos3ivARB'{$IFDEF CLR}, typeof(TglWindowPos3ivARB){$ENDIF}));
  glWindowPos3ivARB(v);
end;

procedure STUB_glWindowPos3sARB(x: TGLshort; y: TGLshort; z: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos3sARB := TglWindowPos3sARB(glProcedure('glWindowPos3sARB'{$IFDEF CLR}, typeof(TglWindowPos3sARB){$ENDIF}));
  glWindowPos3sARB(x, y, z);
end;

procedure STUB_glWindowPos3svARB(const v: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glWindowPos3svARB := TglWindowPos3svARB(glProcedure('glWindowPos3svARB'{$IFDEF CLR}, typeof(TglWindowPos3svARB){$ENDIF}));
  glWindowPos3svARB(v);
end;

procedure STUB_glDrawBuffersARB(n: TGLsizei; bufs: PGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDrawBuffersARB := TglDrawBuffersARB(glProcedure('glDrawBuffersARB'{$IFDEF CLR}, typeof(TglDrawBuffersARB){$ENDIF}));
  glDrawBuffersARB(n, bufs);
end;

procedure STUB_glClampColorARB(target: TGLenum; clamp: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glClampColorARB := TglClampColorARB(glProcedure('glClampColorARB'{$IFDEF CLR}, typeof(TglClampColorARB){$ENDIF}));
  glClampColorARB(target, clamp);
end;

procedure STUB_glDrawBuffersATI(n: TGLsizei; const bufs: PGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDrawBuffersATI := TglDrawBuffersATI(glProcedure('glDrawBuffersATI'{$IFDEF CLR}, typeof(TglDrawBuffersATI){$ENDIF}));
  glDrawBuffersATI(n, bufs);
end;

procedure STUB_glElementPointerATI(_type: TGLenum; const _pointer: PGLvoid); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glElementPointerATI := TglElementPointerATI(glProcedure('glElementPointerATI'{$IFDEF CLR}, typeof(TglElementPointerATI){$ENDIF}));
  glElementPointerATI(_type, _pointer);
end;

procedure STUB_glDrawElementArrayATI(mode: TGLenum; count: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDrawElementArrayATI := TglDrawElementArrayATI(glProcedure('glDrawElementArrayATI'{$IFDEF CLR}, typeof(TglDrawElementArrayATI){$ENDIF}));
  glDrawElementArrayATI(mode, count);
end;

procedure STUB_glDrawRangeElementArrayATI(mode: TGLenum; start: TGLuint; _end: TGLuint; count: TGLsizei); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDrawRangeElementArrayATI := TglDrawRangeElementArrayATI(glProcedure('glDrawRangeElementArrayATI'{$IFDEF CLR}, typeof(TglDrawRangeElementArrayATI){$ENDIF}));
  glDrawRangeElementArrayATI(mode, start, _end, count);
end;

procedure STUB_glTexBumpParameterivATI(pname: TGLenum; const param: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexBumpParameterivATI := TglTexBumpParameterivATI(glProcedure('glTexBumpParameterivATI'{$IFDEF CLR}, typeof(TglTexBumpParameterivATI){$ENDIF}));
  glTexBumpParameterivATI(pname, param);
end;

procedure STUB_glTexBumpParameterfvATI(pname: TGLenum; const param: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glTexBumpParameterfvATI := TglTexBumpParameterfvATI(glProcedure('glTexBumpParameterfvATI'{$IFDEF CLR}, typeof(TglTexBumpParameterfvATI){$ENDIF}));
  glTexBumpParameterfvATI(pname, param);
end;

procedure STUB_glGetTexBumpParameterivATI(pname: TGLenum; param: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetTexBumpParameterivATI := TglGetTexBumpParameterivATI(glProcedure('glGetTexBumpParameterivATI'{$IFDEF CLR}, typeof(TglGetTexBumpParameterivATI){$ENDIF}));
  glGetTexBumpParameterivATI(pname, param);
end;

procedure STUB_glGetTexBumpParameterfvATI(pname: TGLenum; param: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetTexBumpParameterfvATI := TglGetTexBumpParameterfvATI(glProcedure('glGetTexBumpParameterfvATI'{$IFDEF CLR}, typeof(TglGetTexBumpParameterfvATI){$ENDIF}));
  glGetTexBumpParameterfvATI(pname, param);
end;

function STUB_glGenFragmentShadersATI(range: TGLuint): TGLuint; {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGenFragmentShadersATI := TglGenFragmentShadersATI(glProcedure('glGenFragmentShadersATI'{$IFDEF CLR}, typeof(TglGenFragmentShadersATI){$ENDIF}));
  result := glGenFragmentShadersATI(range);
end;

procedure STUB_glBindFragmentShaderATI(id: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glBindFragmentShaderATI := TglBindFragmentShaderATI(glProcedure('glBindFragmentShaderATI'{$IFDEF CLR}, typeof(TglBindFragmentShaderATI){$ENDIF}));
  glBindFragmentShaderATI(id);
end;

procedure STUB_glDeleteFragmentShaderATI(id: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glDeleteFragmentShaderATI := TglDeleteFragmentShaderATI(glProcedure('glDeleteFragmentShaderATI'{$IFDEF CLR}, typeof(TglDeleteFragmentShaderATI){$ENDIF}));
  glDeleteFragmentShaderATI(id);
end;

procedure STUB_glBeginFragmentShaderATI(); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glBeginFragmentShaderATI := TglBeginFragmentShaderATI(glProcedure('glBeginFragmentShaderATI'{$IFDEF CLR}, typeof(TglBeginFragmentShaderATI){$ENDIF}));
  glBeginFragmentShaderATI();
end;

procedure STUB_glEndFragmentShaderATI(); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glEndFragmentShaderATI := TglEndFragmentShaderATI(glProcedure('glEndFragmentShaderATI'{$IFDEF CLR}, typeof(TglEndFragmentShaderATI){$ENDIF}));
  glEndFragmentShaderATI();
end;

procedure STUB_glPassTexCoordATI(dst: TGLuint; coord: TGLuint; swizzle: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPassTexCoordATI := TglPassTexCoordATI(glProcedure('glPassTexCoordATI'{$IFDEF CLR}, typeof(TglPassTexCoordATI){$ENDIF}));
  glPassTexCoordATI(dst, coord, swizzle);
end;

procedure STUB_glSampleMapATI(dst: TGLuint; interp: TGLuint; swizzle: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glSampleMapATI := TglSampleMapATI(glProcedure('glSampleMapATI'{$IFDEF CLR}, typeof(TglSampleMapATI){$ENDIF}));
  glSampleMapATI(dst, interp, swizzle);
end;

procedure STUB_glColorFragmentOp1ATI(op: TGLenum; dst: TGLuint; dstMask: TGLuint; dstMod: TGLuint; arg1: TGLuint; arg1Rep: TGLuint; arg1Mod: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColorFragmentOp1ATI := TglColorFragmentOp1ATI(glProcedure('glColorFragmentOp1ATI'{$IFDEF CLR}, typeof(TglColorFragmentOp1ATI){$ENDIF}));
  glColorFragmentOp1ATI(op, dst, dstMask, dstMod, arg1, arg1Rep, arg1Mod);
end;

procedure STUB_glColorFragmentOp2ATI(op: TGLenum; dst: TGLuint; dstMask: TGLuint; dstMod: TGLuint; arg1: TGLuint; arg1Rep: TGLuint; arg1Mod: TGLuint; arg2: TGLuint; arg2Rep: TGLuint; arg2Mod: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColorFragmentOp2ATI := TglColorFragmentOp2ATI(glProcedure('glColorFragmentOp2ATI'{$IFDEF CLR}, typeof(TglColorFragmentOp2ATI){$ENDIF}));
  glColorFragmentOp2ATI(op, dst, dstMask, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod);
end;

procedure STUB_glColorFragmentOp3ATI(op: TGLenum; dst: TGLuint; dstMask: TGLuint; dstMod: TGLuint; arg1: TGLuint; arg1Rep: TGLuint; arg1Mod: TGLuint; arg2: TGLuint; arg2Rep: TGLuint; arg2Mod: TGLuint; arg3: TGLuint; arg3Rep: TGLuint; arg3Mod: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glColorFragmentOp3ATI := TglColorFragmentOp3ATI(glProcedure('glColorFragmentOp3ATI'{$IFDEF CLR}, typeof(TglColorFragmentOp3ATI){$ENDIF}));
  glColorFragmentOp3ATI(op, dst, dstMask, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod, arg3, arg3Rep, arg3Mod);
end;

procedure STUB_glAlphaFragmentOp1ATI(op: TGLenum; dst: TGLuint; dstMod: TGLuint; arg1: TGLuint; arg1Rep: TGLuint; arg1Mod: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glAlphaFragmentOp1ATI := TglAlphaFragmentOp1ATI(glProcedure('glAlphaFragmentOp1ATI'{$IFDEF CLR}, typeof(TglAlphaFragmentOp1ATI){$ENDIF}));
  glAlphaFragmentOp1ATI(op, dst, dstMod, arg1, arg1Rep, arg1Mod);
end;

procedure STUB_glAlphaFragmentOp2ATI(op: TGLenum; dst: TGLuint; dstMod: TGLuint; arg1: TGLuint; arg1Rep: TGLuint; arg1Mod: TGLuint; arg2: TGLuint; arg2Rep: TGLuint; arg2Mod: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glAlphaFragmentOp2ATI := TglAlphaFragmentOp2ATI(glProcedure('glAlphaFragmentOp2ATI'{$IFDEF CLR}, typeof(TglAlphaFragmentOp2ATI){$ENDIF}));
  glAlphaFragmentOp2ATI(op, dst, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod);
end;

procedure STUB_glAlphaFragmentOp3ATI(op: TGLenum; dst: TGLuint; dstMod: TGLuint; arg1: TGLuint; arg1Rep: TGLuint; arg1Mod: TGLuint; arg2: TGLuint; arg2Rep: TGLuint; arg2Mod: TGLuint; arg3: TGLuint; arg3Rep: TGLuint; arg3Mod: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glAlphaFragmentOp3ATI := TglAlphaFragmentOp3ATI(glProcedure('glAlphaFragmentOp3ATI'{$IFDEF CLR}, typeof(TglAlphaFragmentOp3ATI){$ENDIF}));
  glAlphaFragmentOp3ATI(op, dst, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod, arg3, arg3Rep, arg3Mod);
end;

procedure STUB_glSetFragmentShaderConstantATI(dst: TGLuint; const value: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glSetFragmentShaderConstantATI := TglSetFragmentShaderConstantATI(glProcedure('glSetFragmentShaderConstantATI'{$IFDEF CLR}, typeof(TglSetFragmentShaderConstantATI){$ENDIF}));
  glSetFragmentShaderConstantATI(dst, value);
end;

function STUB_glMapObjectBufferATI(buffer: TGLuint): PGLvoid; {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glMapObjectBufferATI := TglMapObjectBufferATI(glProcedure('glMapObjectBufferATI'{$IFDEF CLR}, typeof(TglMapObjectBufferATI){$ENDIF}));
  result := glMapObjectBufferATI(buffer);
end;

procedure STUB_glUnmapObjectBufferATI(buffer: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glUnmapObjectBufferATI := TglUnmapObjectBufferATI(glProcedure('glUnmapObjectBufferATI'{$IFDEF CLR}, typeof(TglUnmapObjectBufferATI){$ENDIF}));
  glUnmapObjectBufferATI(buffer);
end;

procedure STUB_glPNTrianglesiATI(pname: TGLenum; param: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPNTrianglesiATI := TglPNTrianglesiATI(glProcedure('glPNTrianglesiATI'{$IFDEF CLR}, typeof(TglPNTrianglesiATI){$ENDIF}));
  glPNTrianglesiATI(pname, param);
end;

procedure STUB_glPNTrianglesfATI(pname: TGLenum; param: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glPNTrianglesfATI := TglPNTrianglesfATI(glProcedure('glPNTrianglesfATI'{$IFDEF CLR}, typeof(TglPNTrianglesfATI){$ENDIF}));
  glPNTrianglesfATI(pname, param);
end;

procedure STUB_glStencilOpSeparateATI(face: TGLenum; sfail: TGLenum; dpfail: TGLenum; dppass: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glStencilOpSeparateATI := TglStencilOpSeparateATI(glProcedure('glStencilOpSeparateATI'{$IFDEF CLR}, typeof(TglStencilOpSeparateATI){$ENDIF}));
  glStencilOpSeparateATI(face, sfail, dpfail, dppass);
end;

procedure STUB_glStencilFuncSeparateATI(frontfunc: TGLenum; backfunc: TGLenum; ref: TGLint; mask: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glStencilFuncSeparateATI := TglStencilFuncSeparateATI(glProcedure('glStencilFuncSeparateATI'{$IFDEF CLR}, typeof(TglStencilFuncSeparateATI){$ENDIF}));
  glStencilFuncSeparateATI(frontfunc, backfunc, ref, mask);
end;

function STUB_glNewObjectBufferATI(size: TGLsizei; const _pointer: PGLvoid; usage: TGLenum): TGLuint; {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glNewObjectBufferATI := TglNewObjectBufferATI(glProcedure('glNewObjectBufferATI'{$IFDEF CLR}, typeof(TglNewObjectBufferATI){$ENDIF}));
  result := glNewObjectBufferATI(size, _pointer, usage);
end;

function STUB_glIsObjectBufferATI(buffer: TGLuint): TGLboolean; {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glIsObjectBufferATI := TglIsObjectBufferATI(glProcedure('glIsObjectBufferATI'{$IFDEF CLR}, typeof(TglIsObjectBufferATI){$ENDIF}));
  result := glIsObjectBufferATI(buffer);
end;

procedure STUB_glUpdateObjectBufferATI(buffer: TGLuint; offset: TGLuint; size: TGLsizei; const _pointer: PGLvoid; preserve: TGLenum); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glUpdateObjectBufferATI := TglUpdateObjectBufferATI(glProcedure('glUpdateObjectBufferATI'{$IFDEF CLR}, typeof(TglUpdateObjectBufferATI){$ENDIF}));
  glUpdateObjectBufferATI(buffer, offset, size, _pointer, preserve);
end;

procedure STUB_glGetObjectBufferfvATI(buffer: TGLuint; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetObjectBufferfvATI := TglGetObjectBufferfvATI(glProcedure('glGetObjectBufferfvATI'{$IFDEF CLR}, typeof(TglGetObjectBufferfvATI){$ENDIF}));
  glGetObjectBufferfvATI(buffer, pname, params);
end;

procedure STUB_glGetObjectBufferivATI(buffer: TGLuint; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetObjectBufferivATI := TglGetObjectBufferivATI(glProcedure('glGetObjectBufferivATI'{$IFDEF CLR}, typeof(TglGetObjectBufferivATI){$ENDIF}));
  glGetObjectBufferivATI(buffer, pname, params);
end;

procedure STUB_glFreeObjectBufferATI(buffer: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glFreeObjectBufferATI := TglFreeObjectBufferATI(glProcedure('glFreeObjectBufferATI'{$IFDEF CLR}, typeof(TglFreeObjectBufferATI){$ENDIF}));
  glFreeObjectBufferATI(buffer);
end;

procedure STUB_glArrayObjectATI(_array: TGLenum; size: TGLint; _type: TGLenum; stride: TGLsizei; buffer: TGLuint; offset: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glArrayObjectATI := TglArrayObjectATI(glProcedure('glArrayObjectATI'{$IFDEF CLR}, typeof(TglArrayObjectATI){$ENDIF}));
  glArrayObjectATI(_array, size, _type, stride, buffer, offset);
end;

procedure STUB_glGetArrayObjectfvATI(_array: TGLenum; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetArrayObjectfvATI := TglGetArrayObjectfvATI(glProcedure('glGetArrayObjectfvATI'{$IFDEF CLR}, typeof(TglGetArrayObjectfvATI){$ENDIF}));
  glGetArrayObjectfvATI(_array, pname, params);
end;

procedure STUB_glGetArrayObjectivATI(_array: TGLenum; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetArrayObjectivATI := TglGetArrayObjectivATI(glProcedure('glGetArrayObjectivATI'{$IFDEF CLR}, typeof(TglGetArrayObjectivATI){$ENDIF}));
  glGetArrayObjectivATI(_array, pname, params);
end;

procedure STUB_glVariantArrayObjectATI(id: TGLuint; _type: TGLenum; stride: TGLsizei; buffer: TGLuint; offset: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVariantArrayObjectATI := TglVariantArrayObjectATI(glProcedure('glVariantArrayObjectATI'{$IFDEF CLR}, typeof(TglVariantArrayObjectATI){$ENDIF}));
  glVariantArrayObjectATI(id, _type, stride, buffer, offset);
end;

procedure STUB_glGetVariantArrayObjectfvATI(id: TGLuint; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetVariantArrayObjectfvATI := TglGetVariantArrayObjectfvATI(glProcedure('glGetVariantArrayObjectfvATI'{$IFDEF CLR}, typeof(TglGetVariantArrayObjectfvATI){$ENDIF}));
  glGetVariantArrayObjectfvATI(id, pname, params);
end;

procedure STUB_glGetVariantArrayObjectivATI(id: TGLuint; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetVariantArrayObjectivATI := TglGetVariantArrayObjectivATI(glProcedure('glGetVariantArrayObjectivATI'{$IFDEF CLR}, typeof(TglGetVariantArrayObjectivATI){$ENDIF}));
  glGetVariantArrayObjectivATI(id, pname, params);
end;

procedure STUB_glVertexAttribArrayObjectATI(index: TGLuint; size: TGLint; _type: TGLenum; normalized: TGLboolean; stride: TGLsizei; buffer: TGLuint; offset: TGLuint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexAttribArrayObjectATI := TglVertexAttribArrayObjectATI(glProcedure('glVertexAttribArrayObjectATI'{$IFDEF CLR}, typeof(TglVertexAttribArrayObjectATI){$ENDIF}));
  glVertexAttribArrayObjectATI(index, size, _type, normalized, stride, buffer, offset);
end;

procedure STUB_glGetVertexAttribArrayObjectfvATI(index: TGLuint; pname: TGLenum; params: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetVertexAttribArrayObjectfvATI := TglGetVertexAttribArrayObjectfvATI(glProcedure('glGetVertexAttribArrayObjectfvATI'{$IFDEF CLR}, typeof(TglGetVertexAttribArrayObjectfvATI){$ENDIF}));
  glGetVertexAttribArrayObjectfvATI(index, pname, params);
end;

procedure STUB_glGetVertexAttribArrayObjectivATI(index: TGLuint; pname: TGLenum; params: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glGetVertexAttribArrayObjectivATI := TglGetVertexAttribArrayObjectivATI(glProcedure('glGetVertexAttribArrayObjectivATI'{$IFDEF CLR}, typeof(TglGetVertexAttribArrayObjectivATI){$ENDIF}));
  glGetVertexAttribArrayObjectivATI(index, pname, params);
end;

procedure STUB_glVertexStream1sATI(stream: TGLenum; x: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream1sATI := TglVertexStream1sATI(glProcedure('glVertexStream1sATI'{$IFDEF CLR}, typeof(TglVertexStream1sATI){$ENDIF}));
  glVertexStream1sATI(stream, x);
end;

procedure STUB_glVertexStream1svATI(stream: TGLenum; const coords: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream1svATI := TglVertexStream1svATI(glProcedure('glVertexStream1svATI'{$IFDEF CLR}, typeof(TglVertexStream1svATI){$ENDIF}));
  glVertexStream1svATI(stream, coords);
end;

procedure STUB_glVertexStream1iATI(stream: TGLenum; x: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream1iATI := TglVertexStream1iATI(glProcedure('glVertexStream1iATI'{$IFDEF CLR}, typeof(TglVertexStream1iATI){$ENDIF}));
  glVertexStream1iATI(stream, x);
end;

procedure STUB_glVertexStream1ivATI(stream: TGLenum; const coords: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream1ivATI := TglVertexStream1ivATI(glProcedure('glVertexStream1ivATI'{$IFDEF CLR}, typeof(TglVertexStream1ivATI){$ENDIF}));
  glVertexStream1ivATI(stream, coords);
end;

procedure STUB_glVertexStream1fATI(stream: TGLenum; x: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream1fATI := TglVertexStream1fATI(glProcedure('glVertexStream1fATI'{$IFDEF CLR}, typeof(TglVertexStream1fATI){$ENDIF}));
  glVertexStream1fATI(stream, x);
end;

procedure STUB_glVertexStream1fvATI(stream: TGLenum; const coords: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream1fvATI := TglVertexStream1fvATI(glProcedure('glVertexStream1fvATI'{$IFDEF CLR}, typeof(TglVertexStream1fvATI){$ENDIF}));
  glVertexStream1fvATI(stream, coords);
end;

procedure STUB_glVertexStream1dATI(stream: TGLenum; x: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream1dATI := TglVertexStream1dATI(glProcedure('glVertexStream1dATI'{$IFDEF CLR}, typeof(TglVertexStream1dATI){$ENDIF}));
  glVertexStream1dATI(stream, x);
end;

procedure STUB_glVertexStream1dvATI(stream: TGLenum; const coords: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream1dvATI := TglVertexStream1dvATI(glProcedure('glVertexStream1dvATI'{$IFDEF CLR}, typeof(TglVertexStream1dvATI){$ENDIF}));
  glVertexStream1dvATI(stream, coords);
end;

procedure STUB_glVertexStream2sATI(stream: TGLenum; x: TGLshort; y: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream2sATI := TglVertexStream2sATI(glProcedure('glVertexStream2sATI'{$IFDEF CLR}, typeof(TglVertexStream2sATI){$ENDIF}));
  glVertexStream2sATI(stream, x, y);
end;

procedure STUB_glVertexStream2svATI(stream: TGLenum; const coords: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream2svATI := TglVertexStream2svATI(glProcedure('glVertexStream2svATI'{$IFDEF CLR}, typeof(TglVertexStream2svATI){$ENDIF}));
  glVertexStream2svATI(stream, coords);
end;

procedure STUB_glVertexStream2iATI(stream: TGLenum; x: TGLint; y: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream2iATI := TglVertexStream2iATI(glProcedure('glVertexStream2iATI'{$IFDEF CLR}, typeof(TglVertexStream2iATI){$ENDIF}));
  glVertexStream2iATI(stream, x, y);
end;

procedure STUB_glVertexStream2ivATI(stream: TGLenum; const coords: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream2ivATI := TglVertexStream2ivATI(glProcedure('glVertexStream2ivATI'{$IFDEF CLR}, typeof(TglVertexStream2ivATI){$ENDIF}));
  glVertexStream2ivATI(stream, coords);
end;

procedure STUB_glVertexStream2fATI(stream: TGLenum; x: TGLfloat; y: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream2fATI := TglVertexStream2fATI(glProcedure('glVertexStream2fATI'{$IFDEF CLR}, typeof(TglVertexStream2fATI){$ENDIF}));
  glVertexStream2fATI(stream, x, y);
end;

procedure STUB_glVertexStream2fvATI(stream: TGLenum; const coords: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream2fvATI := TglVertexStream2fvATI(glProcedure('glVertexStream2fvATI'{$IFDEF CLR}, typeof(TglVertexStream2fvATI){$ENDIF}));
  glVertexStream2fvATI(stream, coords);
end;

procedure STUB_glVertexStream2dATI(stream: TGLenum; x: TGLdouble; y: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream2dATI := TglVertexStream2dATI(glProcedure('glVertexStream2dATI'{$IFDEF CLR}, typeof(TglVertexStream2dATI){$ENDIF}));
  glVertexStream2dATI(stream, x, y);
end;

procedure STUB_glVertexStream2dvATI(stream: TGLenum; const coords: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream2dvATI := TglVertexStream2dvATI(glProcedure('glVertexStream2dvATI'{$IFDEF CLR}, typeof(TglVertexStream2dvATI){$ENDIF}));
  glVertexStream2dvATI(stream, coords);
end;

procedure STUB_glVertexStream3sATI(stream: TGLenum; x: TGLshort; y: TGLshort; z: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream3sATI := TglVertexStream3sATI(glProcedure('glVertexStream3sATI'{$IFDEF CLR}, typeof(TglVertexStream3sATI){$ENDIF}));
  glVertexStream3sATI(stream, x, y, z);
end;

procedure STUB_glVertexStream3svATI(stream: TGLenum; const coords: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream3svATI := TglVertexStream3svATI(glProcedure('glVertexStream3svATI'{$IFDEF CLR}, typeof(TglVertexStream3svATI){$ENDIF}));
  glVertexStream3svATI(stream, coords);
end;

procedure STUB_glVertexStream3iATI(stream: TGLenum; x: TGLint; y: TGLint; z: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream3iATI := TglVertexStream3iATI(glProcedure('glVertexStream3iATI'{$IFDEF CLR}, typeof(TglVertexStream3iATI){$ENDIF}));
  glVertexStream3iATI(stream, x, y, z);
end;

procedure STUB_glVertexStream3ivATI(stream: TGLenum; const coords: PGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream3ivATI := TglVertexStream3ivATI(glProcedure('glVertexStream3ivATI'{$IFDEF CLR}, typeof(TglVertexStream3ivATI){$ENDIF}));
  glVertexStream3ivATI(stream, coords);
end;

procedure STUB_glVertexStream3fATI(stream: TGLenum; x: TGLfloat; y: TGLfloat; z: TGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream3fATI := TglVertexStream3fATI(glProcedure('glVertexStream3fATI'{$IFDEF CLR}, typeof(TglVertexStream3fATI){$ENDIF}));
  glVertexStream3fATI(stream, x, y, z);
end;

procedure STUB_glVertexStream3fvATI(stream: TGLenum; const coords: PGLfloat); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream3fvATI := TglVertexStream3fvATI(glProcedure('glVertexStream3fvATI'{$IFDEF CLR}, typeof(TglVertexStream3fvATI){$ENDIF}));
  glVertexStream3fvATI(stream, coords);
end;

procedure STUB_glVertexStream3dATI(stream: TGLenum; x: TGLdouble; y: TGLdouble; z: TGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream3dATI := TglVertexStream3dATI(glProcedure('glVertexStream3dATI'{$IFDEF CLR}, typeof(TglVertexStream3dATI){$ENDIF}));
  glVertexStream3dATI(stream, x, y, z);
end;

procedure STUB_glVertexStream3dvATI(stream: TGLenum; const coords: PGLdouble); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream3dvATI := TglVertexStream3dvATI(glProcedure('glVertexStream3dvATI'{$IFDEF CLR}, typeof(TglVertexStream3dvATI){$ENDIF}));
  glVertexStream3dvATI(stream, coords);
end;

procedure STUB_glVertexStream4sATI(stream: TGLenum; x: TGLshort; y: TGLshort; z: TGLshort; w: TGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream4sATI := TglVertexStream4sATI(glProcedure('glVertexStream4sATI'{$IFDEF CLR}, typeof(TglVertexStream4sATI){$ENDIF}));
  glVertexStream4sATI(stream, x, y, z, w);
end;

procedure STUB_glVertexStream4svATI(stream: TGLenum; const coords: PGLshort); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glVertexStream4svATI := TglVertexStream4svATI(glProcedure('glVertexStream4svATI'{$IFDEF CLR}, typeof(TglVertexStream4svATI){$ENDIF}));
  glVertexStream4svATI(stream, coords);
end;

procedure STUB_glVertexStream4iATI(stream: TGLenum; x: TGLint; y: TGLint; z: TGLint; w: TGLint); {$IFNDEF CLR}{$IFDEF Win32} stdcall; {$ELSE} cdecl; {$ENDIF}{$ENDIF}
begin
  glV