unit uGLInfo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  dglOpenGL, StdCtrls, ComCtrls;

type
  TfmGLInfo = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox7: TCheckBox;
    CheckBox8: TCheckBox;
    CheckBox9: TCheckBox;
    edVersion: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    TabSheet2: TTabSheet;
    meExtensions: TMemo;
    edVendor: TEdit;
    edRenderer: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    procedure CheckBox1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private-Deklarationen }
    Creating:boolean;
  public
    { Public-Deklarationen }
    DC,RC:THandle;
  end;

var
  fmGLInfo: TfmGLInfo;

implementation

{$R *.DFM}


procedure TfmGLInfo.CheckBox1Click(Sender: TObject);
begin
  if not Creating then begin
    Creating:= true;
    (Sender as TCheckbox).Checked:= not(Sender as TCheckbox).Checked;
    creating:= false;
  end;
end;

procedure TfmGLInfo.FormShow(Sender: TObject);
var buf:pChar;
begin
  Creating:= true;

  ActivateRenderingContext(DC,RC);
  ReadImplementationProperties;
  buf:= glGetString(GL_VERSION);
  edVersion.Text:= buf;
  CheckBox1.Checked:= GL_VERSION_1_0;
  CheckBox2.Checked:= GL_VERSION_1_1;
  CheckBox3.Checked:= GL_VERSION_1_2;

  CheckBox7.Checked:= GLU_VERSION_1_1;
  CheckBox8.Checked:= GLU_VERSION_1_2;
  CheckBox9.Checked:= GLU_VERSION_1_3;

  edVendor.Text:= glGetString(GL_VENDOR);
  edRenderer.Text:= glGetString(GL_RENDERER);

  meExtensions.Text:= StringReplace(glGetString(GL_EXTENSIONS),' ',#13#10,[rfReplaceAll]);

  PageControl1.ActivePage:= PageControl1.Pages[0];

  creating:= false;
end;

end.
