unit uUtils;

interface

uses Windows,SysUtils;

function GetTempDir: String;
function FloatToStr(X:double):String;
function StrToFloat(S:String):double;
function IsFormat(Text,Format:string):boolean;
function Sign(X:Single):Single;
procedure Limit(var X:Double; Limit:double);    overload;
procedure Limit(var X:Single; Limit:single);    overload;
function AppendBackSlash(D:String):String;
function ExpandDirectory(Base, Relative:string):string;


function PCStart: Int64;
function PCStop(Start:Int64): Double;

implementation

function PathCombine(lpszDest: PChar; const lpszDir, lpszFile: PChar):
           PChar; stdcall; external 'shlwapi.dll' name 'PathCombineA';

function GetTempDir: String;
var
  Dir: String;
  Len: DWord;
begin
  SetLength(Dir,MAX_PATH);
  Len:=GetTempPath(MAX_PATH,PChar(Dir));
  if Len>0 then begin
    SetLength(Dir,Len);
    Result:=Dir;
    if Result[length(Result)]<>'\' then Result:= Result+'\';
  end;
end;

function FloatToStr(X:double):String;
begin
  Result:= SysUtils.FloatToStr(X);
  Result:= StringReplace(Result,DecimalSeparator,'.',[]);
end;

function StrToFloat(S:String):double;
begin
  S:= StringReplace(s,'.',DecimalSeparator,[]);
  S:= StringReplace(s,',',DecimalSeparator,[]);
  Result:= SysUtils.StrToFloat(s);
end;

function IsFormat(Text,Format:string):boolean;
var i:integer;
    v:boolean;
begin
  Result:= false;
  if (length(Text)=0) or (length(format)=0) then exit;
  for i:= 1 to length(Text) do begin
    v:= Text[i]=Format[i];
    case Format[i] of
      'C' : V:= Text[i] in ['A'..'Z'];
      'c' : V:= Text[i] in ['a'..'z'];
      '0' : V:= Text[i] in ['0'..'9'];
      '#' : V:= Text[i] in ['A'..'Z','a'..'z','0'..'9'];
      '*' : break;
    end;
    if not v then exit;
  end;
  Result:= true;
end;

function Sign(X:Single):Single;
begin
  if X=0 then Result:= 0 else
    Result:= X/Abs(X);
end;

procedure Limit(var X:Double; Limit:double);
begin
  if abs(X)>Limit then X:= Limit*Sign(X);
end;

procedure Limit(var X:single; Limit:single);
begin
  if abs(X)>Limit then X:= Limit*Sign(X);
end;

function AppendBackSlash(D:String):String;
begin
  if D[length(d)]<>'\' then Result:= d+'\' else Result:= d;
end;

function ExpandDirectory(Base, Relative:string):string;
begin
  Base:= AppendBackSlash(Base);
  SetLength(Result, MAX_PATH);
  PathCombine(@Result[1], PChar(Base), PChar(Relative));
  SetLength(Result, StrLen(@Result[1]));
end;

var PCFreq:Int64;

function PCStart: Int64;
begin
  QueryPerformanceCounter(Result);
end;

function PCStop(Start:Int64): Double;
var e:int64;
begin
  QueryPerformanceCounter(e);
  Result:= (e-Start)/PCFreq * 1000;
end;


initialization
  QueryPerformanceFrequency(PCFreq);

end.
 