﻿Imports System.IO
Imports freeimageapi

Module Module1
    Dim comstr As System.Collections.ObjectModel.ReadOnlyCollection(Of String)
    Dim startdir, zdir, xdir, yfile, ypng As String, z, x, y As Integer
    Dim filenoj, filenoc, filenop As Integer, cfile, jfile, pfile As String, i, j, l, ll, tt As Integer, s As String, cwork As Integer
    Dim nt(6), zl(6), lvoff(6) As Integer, jpoff, flj, ljs, ii, k As Integer, done As Boolean, js As String
    Dim maxlat, maxlon, minlat, minlon, tmaxlat, tmaxlon, tminlat, tminlon As Double, pdib, ppdib As FIBITMAP, coord, c As Integer
    Dim tw, th As Short, mpp, kpi, kdeg2rad As Double, w1, te, tn As Double, xd, yd As Double
    Dim zs As String, zz As Integer, pxl, pxr, pyt, pyb As Integer, cut As Boolean, maxtiles, numj, jj As Integer
    Dim sminlon, smaxlon As Double, nct(6) As Integer, typehelp As Boolean, fif As FREE_IMAGE_FORMAT
    Dim sas As Boolean
    Sub Main()
        'process the arguments on the command line
        maxtiles = 48000
        sas = False
        comstr = My.Application.CommandLineArgs
        typehelp = False
        If comstr.Count < 1 Or comstr.Count > 2 Then
            typehelp = True
        End If
        If comstr.Count > 0 Then startdir = comstr(0) 'first and only command line argument
        If LCase(startdir) = "help" Or LCase(startdir) = "-help" Or LCase(startdir) = "-h" Then typehelp = True
        If comstr.Count = 2 Then
            If LCase(comstr(1)) = "-sas" Then sas = True Else maxtiles = Val(comstr(1))
        End If
        If maxtiles < 10 Then typehelp = True
        If typehelp Then
            Console.WriteLine("Usage : mobat2jnx <directory> <<maxtiles>>")
            Console.WriteLine("<directory> contains the zoom levels 10,12,14 etc")
            Console.WriteLine("Tile format must be z\x\y.png or z\x\y.jpg")
            Console.WriteLine("Output is <diretory>\jnx.jnx")
            Console.WriteLine("Maxtiles default is 48000; if exceeded output is cut")
            Console.WriteLine("into two or more pieces")
            Console.WriteLine("Alternative : mobat2jnx <directory> -sas   to process")
            Console.WriteLine("SAS Planet tile stores (Zz\y\x.png)")
            Console.WriteLine("Requires Freeimage 3.13")
            Console.ReadLine()
            End
        End If
        Console.WriteLine(startdir)
        'initial values
        kpi = Math.PI
        kdeg2rad = kpi / 180
        If Right(startdir, 1) <> "\" Then startdir = startdir & "\"
        '============= Number of levels of detail. Current firmware version only loads first 5 levels. 
        'first sort the directories into proper order! because 10,12,14,8
        Call scan_mobat()
        If nt(l) <= maxtiles Then
            jfile = startdir & "jnx.jnx"
            Call make_jnx()
        Else
            sminlon = minlon
            smaxlon = maxlon
            numj = Int(nt(l) / maxtiles) + 1
            For jj = 1 To numj
                minlon = sminlon + (jj - 1) * (smaxlon - sminlon) / numj
                maxlon = sminlon + (jj) * (smaxlon - sminlon) / numj
                Console.WriteLine(minlon & " to " & maxlon)
                jfile = startdir & "jnx" & jj & ".jnx"
                Call make_jnx()
            Next
        End If
        Console.WriteLine("Done")
        Console.ReadLine()
    End Sub
    Private Sub scan_mobat()
        l = 0
        For Each zdir In Directory.GetDirectories(startdir)
            l = l + 1
            zs = Mid(zdir, Len(startdir) + 1)
            zs = Replace(LCase(zs), "z", "")
            zl(l) = Val(zs)
            If zl(l).ToString <> zs Then Console.WriteLine("Invalid zoom level ignored : " & zs)
        Next
        If l = 0 Then
            Console.WriteLine("No levels")
            Console.ReadLine()
            End
        End If
        If l > 1 Then 'sort levels list
            For i = 1 To l - 1
                For ii = l To i + 1 Step -1
                    If zl(ii - 1) > zl(ii) Then 'swap
                        tt = zl(ii - 1)
                        zl(ii - 1) = zl(ii)
                        zl(ii) = tt
                    End If
                Next
            Next
        End If
        ' need to count them
        For zz = 1 To l
            nt(zz) = 0
            If sas Then zdir = startdir & "z" & zl(zz).ToString Else zdir = startdir & zl(zz).ToString
            minlat = 91
            minlon = 181
            maxlat = -91
            maxlon = -181
            For Each xdir In Directory.GetDirectories(zdir)
                If sas Then y = Mid(xdir, Len(zdir) + 2) Else x = Mid(xdir, Len(zdir) + 2)
                For Each yfile In Directory.GetFiles(xdir)
                    nt(zz) = nt(zz) + 1 'num tiles at this level
                    ypng = Mid(yfile, Len(xdir) + 2)
                    If sas Then x = Left(ypng, Len(ypng) - 4) Else y = Left(ypng, Len(ypng) - 4)
                    Call xyz2ll(x, y, zl(zz), tmaxlat, tminlon)
                    Call xyz2ll(x + 1, y + 1, zl(zz), tminlat, tmaxlon)
                    ' update max and min
                    If tmaxlat > maxlat Then maxlat = tmaxlat
                    If tmaxlon > maxlon Then maxlon = tmaxlon
                    If tminlat < minlat Then minlat = tminlat
                    If tminlon < minlon Then minlon = tminlon
                Next
            Next
        Next
        Console.WriteLine("levels=" & l)
        For i = 1 To l
            Console.WriteLine(nt(i) & " tiles at level " & zl(i))
        Next
    End Sub
    Private Sub make_jnx()
        If File.Exists(jfile) Then Kill(jfile)
        cfile = Replace(jfile, ".jnx", ".crc")
        pfile = Replace(jfile, ".jnx", ".jpg")
        If File.Exists(cfile) Then Kill(cfile)
        ' cfile used to write the maxlat and maxlon of each coordinate pair for CRC calculation
        filenoc = FreeFile()
        FileOpen(filenoc, cfile, OpenMode.Binary)
        c = 9 ' first 2 written later
        filenoj = FreeFile()
        FileOpen(filenoj, jfile, OpenMode.Binary, OpenAccess.Write)
        '============ JNX format version. All JNX I've seen have 0x00000003 in this field. 
        j = 1
        s = Chr(&H3) & Chr(0) & Chr(0) & Chr(0)
        FilePut(filenoj, s, j) '00000003
        j = j + 4
        '============ Device ID. It is zero, in demo maps.
        s = Chr(0) & Chr(0) & Chr(0) & Chr(0)
        FilePut(filenoj, s, j) 'devid
        j = j + 4
        '============= Map coordinates. set later Coordinate system is described below. 
        cwork = 0
        For i = 1 To 4 'coordinates
            FilePut(filenoj, cwork, j)
            j = j + 4
        Next
        FilePut(filenoj, l, j)
        j = j + 4
        For i = 1 To 5 'expdate,0,crc,sigver,sigoff
            '============== The subscription expiration date and time (this seems to be a number of seconds _
            '     elapsed since December 30, 1989, 12:00 PM). 0 in demo maps. BirdsEye Select Deutschland maps also have 0 in this field. 
            '=============== Unknown yet. 0 in demo, and in BirdsEye maps. 3 in BirdsEye Select Deutschland maps. 
            '=============== CRC32 of tile coordinates (see below). 0 in demo maps.
            ' CRC set later
            '=============== Signature version. All non-demo JNX I've seen, have value 0x00040001 in this field. 0 in demo maps. 
            '=============== Signature offset (see 5. Signature below). 0 in demo maps.

            FilePut(filenoj, cwork, j)
            j = j + 4
        Next
        jpoff = 769 'room for signature
        For i = 1 To l
            jpoff = jpoff + 28 * nt(i)
            '=========== Number of tiles in this level. This number should not exceed 6250. 
            FilePut(filenoj, nt(i), j) 'no of tiles
            j = j + 4
            cwork = 0
            lvoff(i) = j 'record position for later rewrite
            FilePut(filenoj, cwork, j) 'tile table offset provisional
            j = j + 4
            'compute cwork from zl(i) 
            '============== Looks like a scale at which this level's tiles become visible. 
            mpp = 6378137 * 2 * kpi * System.Math.Cos((maxlat + minlat) / 2 * kdeg2rad) / (256 * 2 ^ zl(i))
            cwork = mpp * 600
            FilePut(filenoj, cwork, j) 'scale
            j = j + 4
        Next
        jpoff = j + jpoff ' where jpgs will go
        'll = 0
        ' format is .....\z\x\y.png
        For zz = 1 To l
            nt(zz) = 0
            If sas Then zdir = startdir & "z" & zl(zz).ToString Else zdir = startdir & zl(zz).ToString
            z = zl(zz)
            ll = zz
            tt = 0
            'Console.WriteLine(zdir)
            For Each xdir In Directory.GetDirectories(zdir)
                If sas Then y = Mid(xdir, Len(zdir) + 2) Else x = Mid(xdir, Len(zdir) + 2)
                'Console.WriteLine(xdir)
                For Each yfile In Directory.GetFiles(xdir)
                    ypng = Mid(yfile, Len(xdir) + 2)
                    If sas Then x = Left(ypng, Len(ypng) - 4) Else y = Left(ypng, Len(ypng) - 4)
                    tt = tt + 1
                    If tt = 1 Then FilePut(filenoj, j - 1, lvoff(ll)) 'fill link to tile description table in levels table
                    ' calculate coordinates zoom level, x and y to Latitude and longitude
                    Call xyz2ll(x, y, zl(ll), tmaxlat, tminlon)
                    Call xyz2ll(x + 1, y + 1, zl(ll), tminlat, tmaxlon)
                    '=============== Tile coordinates. 
                    cut = False
                    'check the tile is in bounds
                    If tminlon < maxlon And tmaxlon > minlon Then
                        ' Need to cut tile if outside bounds
                        nt(zz) = nt(zz) + 1
                        If tmaxlat > maxlat Then
                            Call ll2xyz(xd, yd, zl(ll), maxlat, maxlon)
                            yd = yd - Int(yd)
                            pyt = Int(yd * 256)
                            tmaxlat = maxlat
                            cut = True
                        Else
                            pyt = 0
                        End If
                        If tmaxlon > maxlon Then
                            Call ll2xyz(xd, yd, zl(ll), maxlat, maxlon)
                            xd = xd - Int(xd)
                            pxr = Int(xd * 256 + 0.999)
                            tmaxlon = maxlon
                            cut = True
                        Else
                            pxr = 256
                        End If
                        If tminlat < minlat Then
                            Call ll2xyz(xd, yd, zl(ll), minlat, minlon)
                            yd = yd - Int(yd)
                            pyb = Int(yd * 256 + 0.999)
                            tminlat = minlat
                            cut = True
                        Else
                            pyb = 256
                        End If
                        If tminlon < minlon Then
                            Call ll2xyz(xd, yd, zl(ll), minlat, minlon)
                            xd = xd - Int(xd)
                            pxl = Int(xd * 256) 'round down
                            tminlon = minlon
                            cut = True
                        Else
                            pxl = 0
                        End If
                        ' save details in tile table
                        cwork = tmaxlat / 180 * (2 ^ 31 - 1) 'maxlat
                        coord = cwork
                        FilePut(filenoj, coord, j)
                        j = j + 4
                        FilePut(filenoc, coord, c)
                        c = c + 4
                        cwork = tmaxlon / 180 * (2 ^ 31 - 1) 'maxlon
                        coord = cwork
                        FilePut(filenoj, coord, j)
                        j = j + 4
                        FilePut(filenoc, coord, c)
                        c = c + 4
                        cwork = tminlat / 180 * (2 ^ 31 - 1) 'minlat
                        coord = cwork
                        FilePut(filenoj, coord, j)
                        j = j + 4
                        cwork = tminlon / 180 * (2 ^ 31 - 1) 'minlon
                        coord = cwork
                        FilePut(filenoj, coord, j)
                        j = j + 4
                        tw = pxr - pxl
                        th = pyb - pyt
                        '============== Image width. 
                        FilePut(filenoj, tw, j)
                        j = j + 2
                        '============== Image height. 
                        FilePut(filenoj, th, j)
                        j = j + 2
                        ' load png and save a jpg. If jpg already then just copy
                        fif = FreeImage.GetFileType(yfile, 0)
                        pdib = FreeImage.Load(fif, yfile, 0)
                        If FreeImage.GetBPP(pdib) < 8 Then
                            ppdib = FreeImage.ConvertTo24Bits(pdib)
                            FreeImage.Unload(pdib)
                            pdib = ppdib
                        End If
                        If cut Then
                            'Console.WriteLine(pxl & " " & pyt & " " & pxr & " " & pyb)
                            ppdib = FreeImage.Copy(pdib, pxl, pyt, pxr, pyb)
                            FreeImage.Unload(pdib)
                            pdib = ppdib
                        End If
                        ' save as jpg
                        FreeImage.Save(FREE_IMAGE_FORMAT.FIF_JPEG, pdib, pfile, 0)
                        ' copy jpg contents to table
                        FreeImage.Unload(pdib)
                        ' now copy the jpg (without first two bytes0 into the JNX
                        filenop = FreeFile()
                        FileOpen(filenop, pfile, OpenMode.Binary)
                        flj = FileLen(pfile) - 2
                        ljs = 256
                        js = New String(" ", ljs)
                        ii = 0
                        done = False
                        Do Until done
                            If flj - ii >= ljs Then
                                FileGet(filenop, js, ii + 3)
                                FilePut(filenoj, js, jpoff + 1)
                                ii = ii + ljs
                                jpoff = jpoff + ljs
                            Else
                                ljs = ljs / 2
                                js = New String(" ", ljs)
                            End If
                            If ii = flj Then done = True
                        Loop
                        '============ Images size in bytes.
                        FilePut(filenoj, flj, j) 'image size
                        j = j + 4
                        k = jpoff - flj
                        '=========== Offset to the image. 
                        FilePut(filenoj, k, j) 'offset
                        j = j + 4
                        FileClose(filenop)
                        'Kill(pfile)
                    End If
                    'Console.WriteLine(yfile & " " & x & " " & y & " " & z)
                Next
            Next
            Console.WriteLine(nt(ll) & " tiles written at level " & zl(ll))
        Next
        'write overall coordinates
        j = 9
        c = 1
        ' now set overall coordinates
        cwork = maxlat / 180 * (2 ^ 31 - 1) 'maxlat
        coord = cwork
        FilePut(filenoj, coord, j)
        j = j + 4
        FilePut(filenoc, coord, c)
        c = c + 4
        cwork = maxlon / 180 * (2 ^ 31 - 1) 'maxlon
        coord = cwork
        FilePut(filenoj, coord, j)
        j = j + 4
        FilePut(filenoc, coord, c)
        c = c + 4
        cwork = minlat / 180 * (2 ^ 31 - 1) 'minlat
        coord = cwork
        FilePut(filenoj, coord, j)
        j = j + 4
        cwork = minlon / 180 * (2 ^ 31 - 1) 'minlon
        coord = cwork
        FilePut(filenoj, coord, j)
        j = j + 4
        For i = 1 To l
            mpp = 6378137 * 2 * kpi * System.Math.Cos((maxlat + minlat) / 2 * kdeg2rad) / (256 * 2 ^ zl(i))
            cwork = set_scale(mpp)
            FilePut(filenoj, cwork, lvoff(i) + 4) 'scale
            FilePut(filenoj, nt(i), lvoff(i) - 4) 'tiles at this level
        Next
        ' write Birdseye
        s = Chr(&H42) & Chr(&H69) & Chr(&H72) & Chr(&H64) & Chr(&H73) & Chr(&H45) & Chr(&H79) & Chr(&H65) 'BirdsEye 
        FilePut(filenoj, s, jpoff + 1)
        jpoff = jpoff + Len(s)
        FileClose(filenoc)
        'save calculated CRC
        FilePut(filenoj, docrc(cfile), 37)
        FileClose(filenoj)
    End Sub
    Private Sub xyz2ll(ByVal x As Integer, ByVal y As Integer, ByVal z As Integer, ByRef lat As Double, ByRef lon As Double)
        Dim w1, te, tn As Double
        w1 = 2 ^ z
        te = x / (w1 / (kpi * 2)) - kpi 'top left of tile
        tn = kpi - (y) / (w1 / (kpi * 2))
        'http://en.wikipedia.org/wiki/Mercator_projection
        lon = te / kdeg2rad
        lat = (2 * System.Math.Atan(System.Math.Exp(tn)) - (kpi / 2)) / kdeg2rad
    End Sub
    Private Sub ll2xyz(ByRef x As Double, ByRef y As Double, ByVal z As Integer, ByVal lat As Double, ByVal lon As Double)
        Dim w1, te, tn As Double
        w1 = 2 ^ z
        te = lon * kdeg2rad
        tn = System.Math.Log((1 + System.Math.Sin(lat * kdeg2rad)) / (1 - System.Math.Sin(lat * kdeg2rad))) / 2
        x = (te + kpi) * (w1 / (kpi * 2))
        y = (kpi - tn) * (w1 / (kpi * 2))
    End Sub
    Private Function docrc(ByVal crcpath As String) As Integer
        Dim c As New CRC32()
        Dim crc As Integer = 0
        ' CRC32 Hash:
        Dim f As FileStream = New FileStream(crcpath, FileMode.Open, FileAccess.Read, FileShare.Read, 8192)
        crc = c.GetCrc32(f)
        f.Close()
        docrc = crc
    End Function
    Private Function set_scale(ByVal mpp As Double) As Integer
        Dim scale, w, w2, w3 As Double, done As Boolean, i, ii As Integer
        Dim scalelist() As Single = {1, 75, 149, 298, 597, 1194, 2388, 4777, 9554, 19109, 38218, 76437, 152877, 305758, 611526, 1223072, 2446184}
        done = False
        w = mpp * 200
        w2 = 999
        ii = 8
        scale = 74
        For i = 1 To 16
            w3 = Math.Abs(w - scalelist(i)) / scalelist(i) 'find closest as a ratio
            If w3 < w2 Then
                w2 = w3
                ii = i
            End If
        Next
        'ldisptt(w & " scale " & CInt(scalelist(ii)))
        Return (CInt(scalelist(ii)))
    End Function
End Module
