unit MarksSmlToDataSet;

interface

uses
  Windows,
  Classes,
  SysUtils,
  i_Timer,
  DB,
  DBClient,
  ALXmlDoc,
  ALMime,
  ALString,
  ALStringList;

type
  TAlcinoeXmlToDataSet = class
  private
    FCdsMarks: TClientDataSet;
    FFormatSettings: TALFormatSettings;
    procedure InitEmptyDataSet(const AutoIncValue: Integer);
    procedure ParseStartElement(Sender: TObject; const Path, Name: AnsiString; const Attributes: TALStrings);
  public
    procedure Process(const AStream: TStream; const ATimer: ITimer);
  end;

implementation

procedure TAlcinoeXmlToDataSet.Process(const AStream: TStream; const ATimer: ITimer);
var
  VXml: TAlXmlDocument;
  VStartTime, VFinishTime: Int64;
begin
  FCdsMarks := TClientDataSet.Create(nil);
  try
    FFormatSettings.DecimalSeparator := '.';

    VXml := TALXmlDocument.create('root');
    try
      VXml.OnParseStartElement := ParseStartElement;

      AStream.Position := 0;

      VStartTime := ATimer.CurrentTime;
      VXml.LoadFromStream(AStream, True);
      VFinishTime := ATimer.CurrentTime;

      Writeln(Format('AlcinoeXmlToDataSet in SAX mode: %.8f sec.', [(VFinishTime - VStartTime)/ATimer.Freq]));
      Writeln;
    finally
      VXml.Free;
    end;
  finally
    FCdsMarks.Free;
  end;
end;

procedure TAlcinoeXmlToDataSet.ParseStartElement(Sender: TObject; const Path, Name: AnsiString; const Attributes: TALStrings);
//var
  //I: Integer;
begin
  if ALSameText(Name, 'ROW') then begin
    (*
    if Attributes.Count <> 15 then begin
      Writeln(Format('StartElement >> Path: "%s" | Name: "%s" | Attributes Count: %d', [Path, Name, Attributes.Count]));
      for I := 0 to Attributes.Count - 1 do begin
        Writeln(Format('    Attr #%d: %s', [I+1, Attributes[I]]));
      end;
      Exit;
    end;
    *)

    FCdsMarks.Insert;

    //FCdsMarks.FieldByName('id').AsInteger := ALStrToInt(Attributes.Values['id']);
    FCdsMarks.FieldByName('Visible').AsBoolean := AlStrToBool(Attributes.Values['Visible']);
    FCdsMarks.FieldByName('name').AsString := Attributes.Values['name'];
    FCdsMarks.FieldByName('categoryid').AsInteger := ALStrToInt(Attributes.Values['categoryid']);
    FCdsMarks.FieldByName('descr').AsString := Attributes.Values['descr'];
    FCdsMarks.FieldByName('LonL').AsFloat := ALStrToFloat(Attributes.Values['LonL'], FFormatSettings);
    FCdsMarks.FieldByName('LatT').AsFloat := ALStrToFloat(Attributes.Values['LatT'], FFormatSettings);
    FCdsMarks.FieldByName('LonR').AsFloat := ALStrToFloat(Attributes.Values['LonR'], FFormatSettings);
    FCdsMarks.FieldByName('LatB').AsFloat := ALStrToFloat(Attributes.Values['LatB'], FFormatSettings);
    FCdsMarks.FieldByName('PicName').AsString := Attributes.Values['PicName'];
    FCdsMarks.FieldByName('LonLatArr').AsString := ALMimeBase64DecodeString(Attributes.Values['LonLatArr']);
    FCdsMarks.FieldByName('Color1').AsInteger := ALStrToInt(Attributes.Values['Color1']);
    FCdsMarks.FieldByName('Color2').AsInteger := ALStrToInt(Attributes.Values['Color2']);
    FCdsMarks.FieldByName('Scale1').AsInteger := ALStrToInt(Attributes.Values['Scale1']);
    FCdsMarks.FieldByName('Scale2').AsInteger := ALStrToInt(Attributes.Values['Scale2']);

    FCdsMarks.Post;
  end else if ALSameText(Name, 'PARAMS') then begin
    InitEmptyDataSet(ALStrToInt(Attributes.Values['AUTOINCVALUE']));
  end;
end;

procedure TAlcinoeXmlToDataSet.InitEmptyDataSet(const AutoIncValue: Integer);
begin
  FCdsMarks.Name := 'MarksDB';
  FCdsMarks.DisableControls;

  FCdsMarks.Close;

  FCdsMarks.XMLData :=
    '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' +
    '<DATAPACKET Version="2.0">' +
    '   <METADATA>' +
    '           <FIELDS>' +
    '                   <FIELD attrname="id" fieldtype="i4" readonly="true" SUBTYPE="Autoinc"/>' +
    '                   <FIELD attrname="name" fieldtype="string" WIDTH="255"/>' +
    '                   <FIELD attrname="descr" fieldtype="bin.hex" SUBTYPE="Text"/>' +
    '                   <FIELD attrname="scale1" fieldtype="i4"/>' +
    '                   <FIELD attrname="scale2" fieldtype="i4"/>' +
    '                   <FIELD attrname="lonlatarr" fieldtype="bin.hex" SUBTYPE="Binary"/>' +
    '                   <FIELD attrname="lonL" fieldtype="r8"/>' +
    '                   <FIELD attrname="latT" fieldtype="r8"/>' +
    '                   <FIELD attrname="LonR" fieldtype="r8"/>' +
    '                   <FIELD attrname="LatB" fieldtype="r8"/>' +
    '                   <FIELD attrname="color1" fieldtype="i4"/>' +
    '                   <FIELD attrname="color2" fieldtype="i4"/>' +
    '                   <FIELD attrname="visible" fieldtype="boolean"/>' +
    '                   <FIELD attrname="picname" fieldtype="string" WIDTH="255"/>' +
    '                   <FIELD attrname="categoryid" fieldtype="i4"/>' +
    '           </FIELDS>' +
    '           <PARAMS AUTOINCVALUE="' + IntToStr(AutoIncValue) + '"/>' +
    '   </METADATA>' +
    '   <ROWDATA/>' +
    '</DATAPACKET>';

  FCdsMarks.Open;

  FCdsMarks.LogChanges := False;
end;

end.
