unit OXmlParserTest;

interface

uses
  Windows,
  Classes,
  SysUtils,
  i_Timer,
  OXmlSAX,
  OWideSupp;

{$DEFINE VERB_SAX_MODE}

type
  TOXmlTester = class
  private
    {$IFDEF VERB_SAX_MODE}
    procedure OnStartElement(aSaxParser: TSAXParser; const aName: OWideString; const aAttributes: TSAXAttributes);
    procedure OnProcessingInstruction(aSaxParser: TSAXParser; const aTarget, aContent: OWideString);
    procedure OnCharacters(aSaxParser: TSAXParser; const aText: OWideString);
    procedure OnComment(aSaxParser: TSAXParser; const aText: OWideString);
    {$ENDIF}
  public
    procedure TestIt(const AStream: TStream; const ATimer: ITimer);
  end;

implementation

uses
  OXmlPDOM,
  OEncoding;

procedure TOXmlTester.TestIt(const AStream: TStream; const ATimer: ITimer);
var
  VXmlSAX: OXmlSAX.TSAXParser;
  VXmlDOM: OXmlPDOM.TXMLDocument;
  VEncoding: TEncoding;
  VStartTime, VFinishTime: Int64;
begin
  VEncoding := nil; //TEncoding.ANSI;

  VXmlSAX := TSAXParser.Create;
  try
    {$IFDEF VERB_SAX_MODE}
    //VXml.OnStartDocument :=
    //VXml.OnEndDocument :=
    VXmlSAX.OnCharacters := Self.OnCharacters;
    VXmlSAX.OnComment := Self.OnComment;
    VXmlSAX.OnProcessingInstruction := Self.OnProcessingInstruction;
    VXmlSAX.OnStartElement := Self.OnStartElement;
    //VXml.OnEndElement :=
    {$ENDIF}

    AStream.Position := 0;

    VStartTime := ATimer.CurrentTime;
    VXmlSAX.ParseStream(AStream, VEncoding);
    VFinishTime := ATimer.CurrentTime;

    Writeln(Format('OXml in SAX mode: %.8f sec.', [(VFinishTime - VStartTime)/ATimer.Freq]));
  finally
    VXmlSAX.Free;
  end;

  VXmlDOM := TXMLDocument.Create;
  try
    AStream.Position := 0;
    
    VStartTime := ATimer.CurrentTime;
    VXmlDOM.LoadFromStream(AStream, VEncoding);
    VFinishTime := ATimer.CurrentTime;

    Writeln(Format('OXml in DOM mode: %.8f sec.', [(VFinishTime - VStartTime)/ATimer.Freq]));
  finally
    VXmlDOM.Free;
  end;

end;

{$IFDEF VERB_SAX_MODE}

(*
function SAXEscapeString(const aString: OWideString): OWideString;
begin
  Result := aString;
  Result := OStringReplace(Result, sLineBreak, '\n', [rfReplaceAll]);
  Result := OStringReplace(Result, '"', '\"', [rfReplaceAll]);
end;
*)

procedure TOXmlTester.OnStartElement(aSaxParser: TSAXParser; const aName: OWideString; const aAttributes: TSAXAttributes);
var
  I: Integer;
  //xAttrStr: OWideString;
  xAttr: PSAXAttribute;
begin
  (*
  xAttrStr := '';
  for I := 0 to aAttributes.Count-1 do begin
    xAttr := aAttributes[I];
    if xAttrStr <> '' then
      xAttrStr := xAttrStr + ', ';
    xAttrStr := xAttrStr + SAXEscapeString(xAttr.NodeName)+'="'+SAXEscapeString(xAttr.NodeValue)+'"';
  end;
  xAttrStr := '['+xAttrStr+']';
  Writeln(Format('StartElement >> Name: "%s" | Attributes: %s', [aName, xAttrStr]));
  *)

  Writeln(Format('StartElement >> Name: "%s" | Attributes Count: %d', [aName, aAttributes.Count]));
  for I := 0 to aAttributes.Count - 1 do begin
    xAttr := aAttributes[I];
    Writeln(Format('    Attr #%d: %s=%s', [I+1, xAttr.NodeName, xAttr.NodeValue]));
  end;
end;

procedure TOXmlTester.OnProcessingInstruction(aSaxParser: TSAXParser; const aTarget, aContent: OWideString);
begin
  Writeln(Format('ProcessingInstruction >> Target: "%s" | Content: "%s"', [aTarget, aContent]));
end;

procedure TOXmlTester.OnCharacters(aSaxParser: TSAXParser; const aText: OWideString);
begin
  Writeln(Format('Characters >> Text: "%s"', [aText]));
end;

procedure TOXmlTester.OnComment(aSaxParser: TSAXParser; const aText: OWideString);
begin
  Writeln(Format('Comment >> Text: "%s"', [aText]));
end;

{$ENDIF}

end.
