program WritePNG;

{$IFDEF FPC}
  {$MODE Delphi}

  {$IFDEF CPUI386}
    {$DEFINE CPU386}
    {$ASMMODE INTEL}
  {$ENDIF}

  {$IFNDEF WIN32}
    {$LINKLIB c}
  {$ENDIF}
{$ELSE}
  {$APPTYPE CONSOLE}
{$ENDIF}


uses
  Math,
  Classes,
  SysUtils,
  libPNG in '..\libPNG.pas';


var
  // output
  stream: TFileStream;
  png: png_structp;
  png_info: png_infop;

  text: png_text;

  png_rows: array of Pointer;
  Row: Integer;


procedure write_to_stream(png: png_structp; buffer: png_bytep; size: cardinal); cdecl;
var
  FS: TStream;
begin
  FS := TStream(png_get_io_ptr(png));

  FS.Write(buffer^, size);
end;


procedure FillRow(pData: pByte; Row: Integer);
var
  Idx: Integer;
begin
  for Idx := 0 to 256 do begin
    // red
    pData^ := Max(0, Row - Idx);
    inc(pData);

    // green
    pData^ := Max(0, Idx - Row);
    inc(pData);

    // blue
    pData^ := Max(0, 255 - Idx - Row);
    inc(pData);
  end;
end;


begin
  // *** initialization ***
  if not init_libPNG then begin
    writeln('ERROR: Couldn''t initialize libPNG.');
    halt;
  end;

  // *** version ***
  writeln('WritePNG using libPNG (', png_get_libpng_ver(nil), ')');
  writeln('');

  stream := TFileStream.Create('test.png', fmCreate);

  // create write struct
  png := png_create_write_struct(PNG_LIBPNG_VER_STRING, nil, nil, nil);
  if png = nil then begin
    writeln('ERROR: error creating png struct.');
    halt;
  end;

  // create png info
  png_info := png_create_info_struct(png);
  if png_info = nil then begin
    png_destroy_write_struct(@png, nil);

    writeln('ERROR: error creating info struct.');
    halt;
  end;

  // set read callback
  png_set_write_fn(png, stream, write_to_stream, nil);

  // set compression
  png_set_compression_level(png, 6);

  // setup header
  png_set_IHDR(png, png_info, 256, 256, 8, PNG_COLOR_TYPE_RGB, PNG_INTERLACE_NONE, PNG_COMPRESSION_TYPE_DEFAULT, PNG_FILTER_TYPE_DEFAULT);

  // gamma
  png_set_gAMA(png, png_info, 0.9);

  // creating data
  SetLength(png_rows, png_get_image_height(png, png_info));
  for Row := low(png_rows) to high(png_rows) do begin
    GetMem(png_rows[Row], png_get_rowbytes(png, png_info));
    FillRow(png_rows[Row], Row);
  end;

  // set text
  text.key := 'Comment';
  text.text := 'Created with WritePNG';
  text.text_length := Length(text.text);
  png_set_text(png, png_info, @text, 1);

  // write info
  png_write_info(png, png_info);

  // write image data
  png_write_image(png, @png_rows[0]);

  // write end
  png_write_end(png, png_info);

  writeln('saving successful');

  // *** finalization output ***
  png_destroy_write_struct(@png, @png_info);

  stream.Free;

  // free rows
  for Row := Low(png_rows) to High(png_rows) do
    FreeMem(png_rows[Row]);

  SetLength(png_rows, 0);

  // not really necessary in this case
  quit_libPNG;
end.
 